/* Generated by re2c 3.0 */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) Zend Technologies Ltd. (http://www.zend.com)           |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@php.net>                                 |
   |          Zeev Suraski <zeev@php.net>                                 |
   +----------------------------------------------------------------------+
*/

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef ZEND_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#include <stdarg.h>

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
ZEND_API size_t language_scanner_globals_offset;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) SCNG(scanned_string_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    SCNG(scanned_string_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x80)
#define IS_LABEL_SUCCESSOR(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || ((c) >= '0' && (c) <= '9') || (c) == '_' || (c) >= 0x80)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))


static void strip_underscores(char *str, size_t *len)
{
	char *src = str, *dest = str;
	while (*src != '\0') {
		if (*src != '_') {
			*dest = *src;
			dest++;
		} else {
			--(*len);
		}
		src++;
	}
	*dest = '\0';
}

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding));
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	ZEND_ASSERT(internal_encoding);
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8);
}


static void _yy_push_state(int new_state)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION());
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(void)
{
	int *stack_state = zend_stack_top(&SCNG(state_stack));
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, size_t len)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(void)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(extra_fn_flags) = 0;
	zend_stack_init(&SCNG(state_stack), sizeof(int));
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(void)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_stack_destroy(&SCNG(nest_location_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_scan_ahead) = 0;
	SCNG(on_event) = NULL;
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack), sizeof(int));

	lex_state->nest_location_stack = SCNG(nest_location_stack);
	zend_stack_init(&SCNG(nest_location_stack), sizeof(zend_nest_location));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = CG(compiled_filename);
	lex_state->lineno = CG(zend_lineno);
	CG(compiled_filename) = NULL;

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);

	lex_state->on_event = SCNG(on_event);
	lex_state->on_event_context = SCNG(on_event_context);

	lex_state->ast = CG(ast);
	lex_state->ast_arena = CG(ast_arena);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_stack_destroy(&SCNG(nest_location_stack));
	SCNG(nest_location_stack) = lex_state->nest_location_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename);

	if (SCNG(script_filtered) && SCNG(script_filtered) != lex_state->script_filtered) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	SCNG(on_event) = lex_state->on_event;
	SCNG(on_event_context) = lex_state->on_event_context;

	CG(ast) = lex_state->ast;
	CG(ast_arena) = lex_state->ast_arena;

	RESET_DOC_COMMENT();
}

ZEND_API zend_result zend_lex_tstring(zval *zv, unsigned char *ident)
{
	unsigned char *end = ident;
	while ((*end >= 'a' && *end <= 'z') || (*end >= 'A' && *end <= 'Z') || *end == '_') {
		end++;
	}

	size_t length = end - ident;
	if (length == 0) {
		ZEND_ASSERT(ident[0] == '<' && ident[1] == '?' && ident[2] == '=');
		zend_throw_exception(zend_ce_parse_error, "Cannot use \"<?=\" as an identifier", 0);
		return FAILURE;
	}

	if (SCNG(on_event)) {
		SCNG(on_event)(ON_FEEDBACK, T_STRING, 0, (char *) ident, length, SCNG(on_event_context));
	}

	ZVAL_STRINGL(zv, (char *) ident, length);
	return SUCCESS;
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	assert(p >= script);
	while ((size_t)(p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(void)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while ((size_t)(pos1 - pos2) >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size));
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(void)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode();
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size));
	}

	return CG(script_encoding_list)[0];
}

ZEND_API zend_result zend_multibyte_set_filter(const zend_encoding *onetime_encoding)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding();
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding();

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return SUCCESS;
}

ZEND_API zend_result open_file_for_scanning(zend_file_handle *file_handle)
{
	char *buf;
	size_t size;
	zend_string *compiled_filename;

	if (zend_stream_fixup(file_handle, &buf, &size) == FAILURE) {
		/* Still add it to open_files to make destroy_file_handle work */
		zend_llist_add_element(&CG(open_files), file_handle);
		file_handle->in_list = 1;
		return FAILURE;
	}

	ZEND_ASSERT(!EG(exception) && "stream_fixup() should have failed");
	zend_llist_add_element(&CG(open_files), file_handle);
	file_handle->in_list = 1;

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != (size_t)-1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf;
		yy_scan_buffer(buf, size);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	if (CG(skip_shebang)) {
		BEGIN(SHEBANG);
	} else {
		BEGIN(INITIAL);
	}

	if (file_handle->opened_path) {
		compiled_filename = zend_string_copy(file_handle->opened_path);
	} else {
		compiled_filename = zend_string_copy(file_handle->filename);
	}

	zend_set_compiled_filename(compiled_filename);
	zend_string_release_ex(compiled_filename, 0);

	RESET_DOC_COMMENT();
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	return SUCCESS;
}

static zend_op_array *zend_compile(int type)
{
	zend_op_array *op_array = NULL;
	bool original_in_compilation = CG(in_compilation);

	CG(in_compilation) = 1;
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);

	if (!zendparse()) {
		int last_lineno = CG(zend_lineno);
		zend_file_context original_file_context;
		zend_oparray_context original_oparray_context;
		zend_op_array *original_active_op_array = CG(active_op_array);

		op_array = emalloc(sizeof(zend_op_array));
		init_op_array(op_array, type, INITIAL_OP_ARRAY_SIZE);
		CG(active_op_array) = op_array;

		/* Use heap to not waste arena memory */
		op_array->fn_flags |= ZEND_ACC_HEAP_RT_CACHE;

		if (zend_ast_process) {
			zend_ast_process(CG(ast));
		}

		zend_file_context_begin(&original_file_context);
		zend_oparray_context_begin(&original_oparray_context, op_array);
		zend_compile_top_stmt(CG(ast));
		CG(zend_lineno) = last_lineno;
		zend_emit_final_return(type == ZEND_USER_FUNCTION);
		op_array->line_start = 1;
		op_array->line_end = last_lineno;
		pass_two(op_array);
		zend_oparray_context_end(&original_oparray_context);
		zend_file_context_end(&original_file_context);

		CG(active_op_array) = original_active_op_array;
	}

	zend_ast_destroy(CG(ast));
	zend_arena_destroy(CG(ast_arena));

	CG(in_compilation) = original_in_compilation;

	return op_array;
}

ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zend_save_lexical_state(&original_lex_state);

	if (open_file_for_scanning(file_handle)==FAILURE) {
		if (!EG(exception)) {
			if (type==ZEND_REQUIRE) {
				zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, ZSTR_VAL(file_handle->filename));
			} else {
				zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, ZSTR_VAL(file_handle->filename));
			}
		}
	} else {
		op_array = zend_compile(ZEND_USER_FUNCTION);
	}

	zend_restore_lexical_state(&original_lex_state);
	return op_array;
}

ZEND_API zend_ast *zend_compile_string_to_ast(
		zend_string *code, zend_arena **ast_arena, zend_string *filename) {
	zval code_zv;
	bool original_in_compilation;
	zend_lex_state original_lex_state;
	zend_ast *ast;

	ZVAL_STR_COPY(&code_zv, code);

	original_in_compilation = CG(in_compilation);
	CG(in_compilation) = 1;

	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&code_zv, filename);
	CG(ast) = NULL;
	CG(ast_arena) = zend_arena_create(1024 * 32);
	LANG_SCNG(yy_state) = yycINITIAL;

	if (zendparse() != 0) {
		zend_ast_destroy(CG(ast));
		zend_arena_destroy(CG(ast_arena));
		CG(ast) = NULL;
	}

	/* restore_lexical_state changes CG(ast) and CG(ast_arena) */
	ast = CG(ast);
	*ast_arena = CG(ast_arena);

	zend_restore_lexical_state(&original_lex_state);
	CG(in_compilation) = original_in_compilation;

	zval_ptr_dtor_str(&code_zv);

	return ast;
}

zend_op_array *compile_filename(int type, zend_string *filename)
{
	zend_file_handle file_handle;
	zend_op_array *retval;
	zend_string *opened_path = NULL;

	zend_stream_init_filename_ex(&file_handle, filename);

	retval = zend_compile_file(&file_handle, type);
	if (retval && file_handle.handle.stream.handle) {
		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = zend_string_copy(filename);
		}

		zend_hash_add_empty_element(&EG(included_files), file_handle.opened_path);

		if (opened_path) {
			zend_string_release_ex(opened_path, 0);
		}
	}
	zend_destroy_file_handle(&file_handle);

	return retval;
}

ZEND_API void zend_prepare_string_for_scanning(zval *str, zend_string *filename)
{
	char *buf;
	size_t size, old_len;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	old_len = Z_STRLEN_P(str);
	Z_STR_P(str) = zend_string_extend(Z_STR_P(str), old_len + ZEND_MMAP_AHEAD, 0);
	Z_TYPE_INFO_P(str) = IS_STRING_EX;
	memset(Z_STRVAL_P(str) + old_len, 0, ZEND_MMAP_AHEAD + 1);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = old_len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding());

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size))) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size);
	zend_set_compiled_filename(filename);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
}


ZEND_API size_t zend_get_scanned_file_offset(void)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}

zend_op_array *compile_string(zend_string *source_string, const char *filename, zend_compile_position position)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = NULL;
	zval tmp;
	zend_string *filename_str;

	if (ZSTR_LEN(source_string) == 0) {
		return NULL;
	}

	ZVAL_STR_COPY(&tmp, source_string);

	zend_save_lexical_state(&original_lex_state);
	filename_str = zend_string_init(filename, strlen(filename), 0);
	zend_prepare_string_for_scanning(&tmp, filename_str);
	zend_string_release(filename_str);

	switch (position) {
		case ZEND_COMPILE_POSITION_AT_SHEBANG:
			BEGIN(SHEBANG);
			break;
		case ZEND_COMPILE_POSITION_AT_OPEN_TAG:
			BEGIN(INITIAL);
			break;
		case ZEND_COMPILE_POSITION_AFTER_OPEN_TAG:
			BEGIN(ST_IN_SCRIPTING);
			break;
	}

	op_array = zend_compile(ZEND_EVAL_CODE);

	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&tmp);

	return op_array;
}


zend_result highlight_file(const char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	zend_stream_init_filename(&file_handle, filename);
	zend_save_lexical_state(&original_lex_state);
	if (open_file_for_scanning(&file_handle)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename);
		zend_destroy_file_handle(&file_handle);
		zend_restore_lexical_state(&original_lex_state);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle);
	zend_restore_lexical_state(&original_lex_state);
	return SUCCESS;
}

void highlight_string(zend_string *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, const char *filename)
{
	zend_lex_state original_lex_state;
	zval str_zv;
	zend_string *filename_str = zend_string_init(filename, strlen(filename), 0);
	ZVAL_STR_COPY(&str_zv, str);
	zend_save_lexical_state(&original_lex_state);
	zend_prepare_string_for_scanning(&str_zv, filename_str);
	zend_string_release(filename_str);
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state);
	zval_ptr_dtor(&str_zv);
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size))) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + length;

	SCNG(yy_start) = new_yy_start;
}


// TODO: avoid reallocation ???
# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		char *s = NULL; \
		SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng); \
		ZVAL_STRINGL(zendlval, s, sz); \
		efree(s); \
	} else if (yyleng == 1) { \
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext))); \
	} else { \
		ZVAL_STRINGL(zendlval, yytext, yyleng); \
	}

static zend_result zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type)
{
	char *s, *t;
	char *end;

	if (len <= 1) {
		if (len < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*str;
			HANDLE_NEWLINE(c);
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}

	ZVAL_STRINGL(zendlval, str, len);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					break;
				case 'r':
					*t++ = '\r';
					break;
				case 't':
					*t++ = '\t';
					break;
				case 'f':
					*t++ = '\f';
					break;
				case 'v':
					*t++ = '\v';
					break;
				case 'e':
#ifdef ZEND_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
					ZEND_FALLTHROUGH;
				case '\\':
				case '$':
					*t++ = *s;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						hex_buf[0] = *(++s);
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
						}
						*t++ = (char) ZEND_STRTOL(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				/* UTF-8 codepoint escape, format: /\\u\{\x+\}/ */
				case 'u':
					{
						/* cache where we started so we can parse after validating */
						char *start = s + 1;
						size_t len = 0;
						bool valid = 1;
						unsigned long codepoint;

						if (*start != '{') {
							/* we silently let this pass to avoid breaking code
							 * with JSON in string literals (e.g. "\"\u202e\""
							 */
							*t++ = '\\';
							*t++ = 'u';
							break;
						} else {
							/* on the other hand, invalid \u{blah} errors */
							s++;
							len++;
							s++;
							while (*s != '}') {
								if (!ZEND_IS_HEX(*s)) {
									valid = 0;
									break;
								} else {
									len++;
								}
								s++;
							}
							if (*s == '}') {
								valid = 1;
								len++;
							}
						}

						/* \u{} is invalid */
						if (len <= 2) {
							valid = 0;
						}

						if (!valid) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						errno = 0;
						codepoint = strtoul(start + 1, NULL, 16);

						/* per RFC 3629, UTF-8 can only represent 21 bits */
						if (codepoint > 0x10FFFF || errno) {
							zend_throw_exception(zend_ce_parse_error,
								"Invalid UTF-8 codepoint escape sequence: Codepoint too large", 0);
							zval_ptr_dtor(zendlval);
							ZVAL_UNDEF(zendlval);
							return FAILURE;
						}

						/* based on https://en.wikipedia.org/wiki/UTF-8#Sample_code */
						if (codepoint < 0x80) {
							*t++ = codepoint;
						} else if (codepoint <= 0x7FF) {
							*t++ = (codepoint >> 6) + 0xC0;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0xFFFF) {
							*t++ = (codepoint >> 12) + 0xE0;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						} else if (codepoint <= 0x10FFFF) {
							*t++ = (codepoint >> 18) + 0xF0;
							*t++ = ((codepoint >> 12) & 0x3F) + 0x80;
							*t++ = ((codepoint >> 6) & 0x3F) + 0x80;
							*t++ = (codepoint & 0x3F) + 0x80;
						}
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
							}
						}
						if (octal_buf[2] && (octal_buf[0] > '3') && !SCNG(heredoc_scan_ahead)) {
							/* 3 octit values must not overflow 0xFF (\377) */
							zend_error(E_COMPILE_WARNING, "Octal escape sequence overflow \\%s is greater than \\377", octal_buf);
						}

						*t++ = (char) ZEND_STRTOL(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		unsigned char *str;
		// TODO: avoid realocation ???
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)(&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		zval_ptr_dtor(zendlval);
		ZVAL_STRINGL(zendlval, (char *) str, sz);
		efree(str);
	}
	return SUCCESS;
}

#define HEREDOC_USING_SPACES 1
#define HEREDOC_USING_TABS 2

static const char *next_newline(const char *str, const char *end, size_t *newline_len) {
	for (; str < end; str++) {
		if (*str == '\r') {
			*newline_len = str + 1 < end && *(str + 1) == '\n' ? 2 : 1;
			return str;
		} else if (*str == '\n') {
			*newline_len = 1;
			return str;
		}
	}
	*newline_len = 0;
	return NULL;
}

static bool strip_multiline_string_indentation(
	zval *zendlval, int indentation, bool using_spaces,
	bool newline_at_start, bool newline_at_end)
{
	const char *str = Z_STRVAL_P(zendlval), *end = str + Z_STRLEN_P(zendlval);
	char *copy = Z_STRVAL_P(zendlval);

	int newline_count = 0;
	size_t newline_len;
	const char *nl;

	if (!newline_at_start) {
		nl = next_newline(str, end, &newline_len);
		if (!nl) {
			return 1;
		}

		str = nl + newline_len;
		copy = (char *) nl + newline_len;
		newline_count++;
	} else {
		nl = str;
	}

	/* <= intentional */
	while (str <= end && nl) {
		size_t skip;
		nl = next_newline(str, end, &newline_len);
		if (!nl && newline_at_end) {
			nl = end;
		}

		/* Try to skip indentation */
		for (skip = 0; skip < indentation; skip++, str++) {
			if (str == nl) {
				/* Don't require full indentation on whitespace-only lines */
				break;
			}

			if (str == end || (*str != ' ' && *str != '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception_ex(zend_ce_parse_error, 0,
					"Invalid body indentation level (expecting an indentation level of at least %d)", indentation);
				goto error;
			}

			if ((!using_spaces && *str == ' ') || (using_spaces && *str == '\t')) {
				CG(zend_lineno) += newline_count;
				zend_throw_exception(zend_ce_parse_error,
					"Invalid indentation - tabs and spaces cannot be mixed", 0);
				goto error;
			}
		}

		if (str == end) {
			break;
		}

		size_t len = nl ? (nl - str + newline_len) : (end - str);
		memmove(copy, str, len);
		str += len;
		copy += len;
		newline_count++;
	}

	*copy = '\0';
	Z_STRLEN_P(zendlval) = copy - Z_STRVAL_P(zendlval);
	return 1;

error:
	zval_ptr_dtor_str(zendlval);
	ZVAL_UNDEF(zendlval);

	return 0;
}

static void copy_heredoc_label_stack(void *void_heredoc_label)
{
	zend_heredoc_label *heredoc_label = void_heredoc_label;
	zend_heredoc_label *new_heredoc_label = emalloc(sizeof(zend_heredoc_label));

	*new_heredoc_label = *heredoc_label;
	new_heredoc_label->label = estrndup(heredoc_label->label, heredoc_label->length);

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) new_heredoc_label);
}

/* Check that { }, [ ], ( ) are nested correctly */
static void report_bad_nesting(char opening, int opening_lineno, char closing)
{
	char   buf[256];
	size_t used = 0;

	used = snprintf(buf, sizeof(buf), "Unclosed '%c'", opening);

	if (opening_lineno != CG(zend_lineno)) {
		used += snprintf(buf + used, sizeof(buf) - used, " on line %d", opening_lineno);
	}

	if (closing) { 	/* 'closing' will be 0 if at end of file */
		used += snprintf(buf + used, sizeof(buf) - used, " does not match '%c'", closing);
	}

	zend_throw_exception(zend_ce_parse_error, buf, 0);
}

static void enter_nesting(char opening)
{
	zend_nest_location nest_loc = {opening, CG(zend_lineno)};
	zend_stack_push(&SCNG(nest_location_stack), &nest_loc);
}

static zend_result exit_nesting(char closing)
{
	if (zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unmatched '%c'", closing);
		return FAILURE;
	}

	zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
	char opening = nest_loc->text;

	if ((opening == '{' && closing != '}') ||
	    (opening == '[' && closing != ']') ||
	    (opening == '(' && closing != ')')) {
		report_bad_nesting(opening, nest_loc->lineno, closing);
		return FAILURE;
	}

	zend_stack_del_top(&SCNG(nest_location_stack));
	return SUCCESS;
}

static zend_result check_nesting_at_end(void)
{
	if (!zend_stack_is_empty(&SCNG(nest_location_stack))) {
		zend_nest_location *nest_loc = zend_stack_top(&SCNG(nest_location_stack));
		report_bad_nesting(nest_loc->text, nest_loc->lineno, 0);
		return FAILURE;
	}

	return SUCCESS;
}

#define PARSER_MODE() \
	EXPECTED(elem != NULL)

#define RETURN_TOKEN(_token) do { \
		token = _token; \
		goto emit_token; \
	} while (0)

#define RETURN_TOKEN_WITH_VAL(_token) do { \
		token = _token; \
		goto emit_token_with_val; \
	} while (0)

#define RETURN_TOKEN_WITH_STR(_token, _offset) do { \
		token = _token; \
		offset = _offset; \
		goto emit_token_with_str; \
	} while (0)

#define RETURN_TOKEN_WITH_IDENT(_token) do { \
		token = _token; \
		goto emit_token_with_ident; \
	} while (0)

#define RETURN_OR_SKIP_TOKEN(_token) do { \
		token = _token; \
		if (PARSER_MODE()) { \
			goto skip_token; \
		} \
		goto emit_token; \
	} while (0)

#define RETURN_EXIT_NESTING_TOKEN(_token) do { \
		if (exit_nesting(_token) != SUCCESS && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(_token); \
		} \
	} while(0)

#define RETURN_END_TOKEN do { \
		if (check_nesting_at_end() != SUCCESS && PARSER_MODE()) { \
			RETURN_TOKEN(T_ERROR); \
		} else { \
			RETURN_TOKEN(END); \
		} \
	} while (0)

int ZEND_FASTCALL lex_scan(zval *zendlval, zend_parser_stack_elem *elem)
{
int token;
int offset;
int start_line = CG(zend_lineno);

	ZVAL_UNDEF(zendlval);
restart:
	SCNG(yy_text) = YYCURSOR;


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 8) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				if (YYGETCONDITION() < 7) {
					goto yyc_ST_VAR_OFFSET;
				} else {
					goto yyc_SHEBANG;
				}
			}
		} else {
			if (YYGETCONDITION() < 9) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 10) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			/* table 1 .. 8: 0 */
			  0, 134, 134, 134, 134, 134, 134, 134, 
			134, 135,   4, 134, 134,   4, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			135, 134, 134, 134, 134, 134, 134, 134, 
			134, 134,  66, 134, 134, 134, 134, 134, 
			190, 190, 182, 182, 182, 182, 182, 182, 
			166, 166, 134, 134, 134, 134, 134, 134, 
			134, 166, 166, 166, 166, 166, 166, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 166, 166, 166, 166, 166, 166, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			134, 134, 134, 134, 134, 134, 134, 134, 
			/* table 9 .. 11: 256 */
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  32,  32,   0,   0,  32,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 32,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192, 192, 192, 192, 192, 192, 192, 192, 
			192, 192,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(0, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 32) {
			goto yy2;
		}
		switch (yych) {
			case 0x00:
			case 0x01:
			case 0x02:
			case 0x03:
			case 0x04:
			case 0x05:
			case 0x06:
			case 0x07:
			case 0x08:
			case '\t':
			case '\n':
			case '\v':
			case '\f':
			case '\r':
			case 0x0E:
			case 0x0F:
			case 0x10:
			case 0x11:
			case 0x12:
			case 0x13:
			case 0x14:
			case 0x15:
			case 0x16:
			case 0x17:
			case 0x18:
			case 0x19:
			case 0x1A:
			case 0x1B:
			case 0x1C:
			case 0x1D:
			case 0x1E:
			case 0x1F:
			case 0x7F: goto yy1;
			case ' ':
			case '!': goto yy3;
			case '"': goto yy5;
			case '#': goto yy6;
			case '$': goto yy8;
			case '%': goto yy9;
			case '&': goto yy10;
			case '\'': goto yy12;
			case '(': goto yy13;
			case ')':
			case ']': goto yy15;
			case '*': goto yy16;
			case '+': goto yy17;
			case ',':
			case ';':
			case '@':
			case '~': goto yy18;
			case '-': goto yy19;
			case '.': goto yy20;
			case '/': goto yy21;
			case '0': goto yy22;
			case '1':
			case '2':
			case '3':
			case '4':
			case '5':
			case '6':
			case '7':
			case '8':
			case '9': goto yy24;
			case ':': goto yy26;
			case '<': goto yy27;
			case '=': goto yy28;
			case '>': goto yy29;
			case '?': goto yy30;
			case 'A':
			case 'a': goto yy31;
			case 'B':
			case 'b': goto yy33;
			case 'C':
			case 'c': goto yy34;
			case 'D':
			case 'd': goto yy35;
			case 'E':
			case 'e': goto yy36;
			case 'F':
			case 'f': goto yy37;
			case 'G':
			case 'g': goto yy38;
			case 'I':
			case 'i': goto yy41;
			case 'L':
			case 'l': goto yy42;
			case 'M':
			case 'm': goto yy43;
			case 'N':
			case 'n': goto yy44;
			case 'O':
			case 'o': goto yy45;
			case 'P':
			case 'p': goto yy46;
			case 'R':
			case 'r': goto yy47;
			case 'S':
			case 's': goto yy48;
			case 'T':
			case 't': goto yy49;
			case 'U':
			case 'u': goto yy50;
			case 'V':
			case 'v': goto yy51;
			case 'W':
			case 'w': goto yy52;
			case 'X':
			case 'x': goto yy53;
			case 'Y':
			case 'y': goto yy54;
			case '[': goto yy55;
			case '\\': goto yy56;
			case '^': goto yy58;
			case '_': goto yy59;
			case '`': goto yy60;
			case '{': goto yy61;
			case '|': goto yy62;
			case '}': goto yy63;
			default: goto yy39;
		}
yy1:
		YYDEBUG(1, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy2:
		YYDEBUG(2, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 32) {
			goto yy2;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy64;
yy4:
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(yytext[0]);
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				if (EXPECTED(zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"') == SUCCESS)
				 || !PARSER_MODE()) {
					RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
				} else {
					RETURN_TOKEN(T_ERROR);
				}
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	RETURN_TOKEN('"');
}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '[') goto yy66;
yy7:
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy4;
			if (yych <= 'Z') goto yy67;
			if (yych <= '^') goto yy4;
			goto yy67;
		} else {
			if (yych <= '`') goto yy4;
			if (yych <= 'z') goto yy67;
			if (yych <= 0x7F) goto yy4;
			goto yy67;
		}
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy69;
		goto yy4;
yy10:
		YYDEBUG(10, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy11;
				if (yych <= '\n') goto yy71;
			} else {
				if (yych <= '\r') goto yy71;
				if (yych == ' ') goto yy71;
			}
		} else {
			if (yych <= '-') {
				if (yych <= '$') goto yy71;
				if (yych == '&') goto yy76;
			} else {
				if (yych <= '/') goto yy71;
				if (yych == '=') goto yy79;
			}
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AMPERSAND_NOT_FOLLOWED_BY_VAR_OR_VARARG);
}
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			ZVAL_NULL(zendlval);
			RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
		}
	}

	if (yyleng-bprefix-2 <= 1) {
		if (yyleng-bprefix-2 < 1) {
			ZVAL_EMPTY_STRING(zendlval);
		} else {
			zend_uchar c = (zend_uchar)*(yytext+bprefix+1);
			HANDLE_NEWLINE(c);
			ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR(c));
		}
		goto skip_escape_conversion;
	}
	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2);

	/* convert escape sequences */
	s = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (1) {
		if (UNEXPECTED(*s=='\\')) {
			break;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
		if (s == end) {
			goto skip_escape_conversion;
		}
	}

	t = s;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (*s == '\\' || *s == '\'') {
				*t++ = *s;
			} else {
				*t++ = '\\';
				*t++ = *s;
			}
		} else {
			*t++ = *s;
		}
		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	Z_STRLEN_P(zendlval) = t - Z_STRVAL_P(zendlval);

skip_escape_conversion:
	if (SCNG(output_filter)) {
		size_t sz = 0;
		char *str = NULL;
		zend_string *new_str;
		s = Z_STRVAL_P(zendlval);
		// TODO: avoid reallocation ???
		SCNG(output_filter)((unsigned char **)&str, &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval));
		new_str = zend_string_init(str, sz, 0);
		if (str != s) {
			efree(str);
		}
		zend_string_release_ex(Z_STR_P(zendlval), 0);
		ZVAL_STR(zendlval, new_str);
	}
	RETURN_TOKEN_WITH_VAL(T_CONSTANT_ENCAPSED_STRING);
}
yy13:
		YYDEBUG(13, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy81;
					if (yych >= ' ') goto yy81;
				} else {
					if (yych <= '@') goto yy14;
					if (yych != 'C') goto yy81;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy81;
					if (yych >= 'I') goto yy81;
				} else {
					if (yych == 'O') goto yy81;
					if (yych >= 'R') goto yy81;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych <= 'T') goto yy14;
					if (yych <= 'V') goto yy81;
					if (yych >= 'a') goto yy81;
				} else {
					if (yych == 'd') goto yy81;
					if (yych >= 'f') goto yy81;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy81;
					if (yych >= 'o') goto yy81;
				} else {
					if (yych <= 's') {
						if (yych >= 'r') goto yy81;
					} else {
						if (yych <= 't') goto yy14;
						if (yych <= 'v') goto yy81;
					}
				}
			}
		}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting(yytext[0]);
	RETURN_TOKEN(yytext[0]);
}
yy15:
		YYDEBUG(15, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Check that ] and ) match up properly with a preceding [ or ( */
	RETURN_EXIT_NESTING_TOKEN(yytext[0]);
}
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy92;
		if (yych == '=') goto yy93;
		goto yy4;
yy17:
		YYDEBUG(17, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy94;
		if (yych == '=') goto yy95;
		goto yy4;
yy18:
		YYDEBUG(18, *YYCURSOR);
		++YYCURSOR;
		goto yy4;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy96;
			goto yy4;
		} else {
			if (yych <= '=') goto yy97;
			if (yych <= '>') goto yy98;
			goto yy4;
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy99;
			goto yy4;
		} else {
			if (yych <= '9') goto yy100;
			if (yych == '=') goto yy103;
			goto yy4;
		}
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy104;
			goto yy4;
		} else {
			if (yych <= '/') goto yy106;
			if (yych == '=') goto yy107;
			goto yy4;
		}
yy22:
		YYDEBUG(22, *YYCURSOR);
		yyaccept = 3;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'N') {
				if (yych == 'B') goto yy109;
				goto yy25;
			} else {
				if (yych <= 'O') goto yy111;
				if (yych <= 'W') goto yy25;
				goto yy112;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy109;
				goto yy25;
			} else {
				if (yych <= 'o') goto yy111;
				if (yych == 'x') goto yy112;
				goto yy25;
			}
		}
yy23:
		YYDEBUG(23, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	size_t len = yyleng;
	char *end, *lnum = yytext;
	bool is_octal = lnum[0] == '0';
	bool contains_underscores = (memchr(lnum, '_', len) != NULL);

	if (contains_underscores) {
		lnum = estrndup(lnum, len);
		strip_underscores(lnum, &len);
	}

	/* Digits 8 and 9 are illegal in octal literals. */
	if (is_octal) {
		size_t i;
		for (i = 0; i < len; i++) {
			if (lnum[i] == '8' || lnum[i] == '9') {
				zend_throw_exception(zend_ce_parse_error, "Invalid numeric literal", 0);
				if (PARSER_MODE()) {
					if (contains_underscores) {
						efree(lnum);
					}
					ZVAL_UNDEF(zendlval);
					RETURN_TOKEN(T_ERROR);
				}

				/* Continue in order to determine if this is T_LNUMBER or T_DNUMBER. */
				len = i;
				break;
			}
		}
	}


	if (len < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		errno = 0;
		/* base must be passed explicitly for correct parse error on Windows */
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, is_octal ? 8 : 10));
		ZEND_ASSERT(end == lnum + len);
	} else {
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(lnum, &end, 0));
		if (errno == ERANGE) { /* Overflow */
			errno = 0;
			if (is_octal) { /* octal overflow */
				ZVAL_DOUBLE(zendlval, zend_oct_strtod(lnum, (const char **)&end));
			} else {
				ZVAL_DOUBLE(zendlval, zend_strtod(lnum, (const char **)&end));
			}
			ZEND_ASSERT(end == lnum + len);
			if (contains_underscores) {
				efree(lnum);
			}
			RETURN_TOKEN_WITH_VAL(T_DNUMBER);
		}
		ZEND_ASSERT(end == lnum + len);
	}
	ZEND_ASSERT(!errno);
	if (contains_underscores) {
		efree(lnum);
	}
	RETURN_TOKEN_WITH_VAL(T_LNUMBER);
}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy25:
		YYDEBUG(25, *YYCURSOR);
		if (yybm[256+yych] & 64) {
			goto yy24;
		}
		if (yych <= 'E') {
			if (yych == '.') goto yy108;
			if (yych <= 'D') goto yy23;
			goto yy110;
		} else {
			if (yych <= '_') {
				if (yych <= '^') goto yy23;
				goto yy113;
			} else {
				if (yych == 'e') goto yy110;
				goto yy23;
			}
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy114;
		goto yy4;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ';') goto yy4;
		if (yych <= '<') goto yy115;
		if (yych <= '=') goto yy117;
		if (yych <= '>') goto yy118;
		goto yy4;
yy28:
		YYDEBUG(28, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy4;
		if (yych <= '=') goto yy119;
		if (yych <= '>') goto yy120;
		goto yy4;
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy4;
		if (yych <= '=') goto yy121;
		if (yych <= '>') goto yy122;
		goto yy4;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '=') {
			if (yych == '-') goto yy123;
			goto yy4;
		} else {
			if (yych <= '>') goto yy124;
			if (yych <= '?') goto yy126;
			goto yy4;
		}
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy127;
				goto yy40;
			} else {
				if (yych <= 'N') goto yy128;
				if (yych <= 'Q') goto yy40;
				if (yych <= 'R') goto yy129;
				goto yy130;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy127;
				if (yych <= 'm') goto yy40;
				goto yy128;
			} else {
				if (yych <= 'q') goto yy40;
				if (yych <= 'r') goto yy129;
				if (yych <= 's') goto yy130;
				goto yy40;
			}
		}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy33:
		YYDEBUG(33, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy40;
				goto yy5;
			} else {
				if (yych == '\'') goto yy12;
				goto yy40;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy133;
				if (yych <= 'Q') goto yy40;
				goto yy134;
			} else {
				if (yych == 'r') goto yy134;
				goto yy40;
			}
		}
yy34:
		YYDEBUG(34, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy135;
				goto yy40;
			} else {
				if (yych <= 'L') goto yy136;
				if (yych <= 'N') goto yy40;
				goto yy137;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy135;
				goto yy40;
			} else {
				if (yych <= 'l') goto yy136;
				if (yych == 'o') goto yy137;
				goto yy40;
			}
		}
yy35:
		YYDEBUG(35, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy138;
				goto yy40;
			} else {
				if (yych <= 'I') goto yy139;
				if (yych <= 'N') goto yy40;
				goto yy140;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy138;
				goto yy40;
			} else {
				if (yych <= 'i') goto yy139;
				if (yych == 'o') goto yy140;
				goto yy40;
			}
		}
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'C':
			case 'c': goto yy142;
			case 'L':
			case 'l': goto yy143;
			case 'M':
			case 'm': goto yy144;
			case 'N':
			case 'n': goto yy145;
			case 'V':
			case 'v': goto yy146;
			case 'X':
			case 'x': goto yy147;
			default: goto yy40;
		}
yy37:
		YYDEBUG(37, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych <= 'M') {
				if (yych == 'I') goto yy148;
				goto yy40;
			} else {
				if (yych <= 'N') goto yy149;
				if (yych <= 'O') goto yy151;
				if (yych <= 'T') goto yy40;
				goto yy152;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy148;
				if (yych <= 'm') goto yy40;
				goto yy149;
			} else {
				if (yych <= 'o') goto yy151;
				if (yych == 'u') goto yy152;
				goto yy40;
			}
		}
yy38:
		YYDEBUG(38, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'L') goto yy153;
			if (yych <= 'N') goto yy40;
			goto yy154;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy40;
				goto yy153;
			} else {
				if (yych == 'o') goto yy154;
				goto yy40;
			}
		}
yy39:
		YYDEBUG(39, *YYCURSOR);
		yyaccept = 4;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy40:
		YYDEBUG(40, *YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
		goto yy32;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy155;
				goto yy40;
			} else {
				if (yych <= 'M') goto yy157;
				if (yych <= 'N') goto yy158;
				if (yych <= 'R') goto yy40;
				goto yy159;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy155;
				if (yych <= 'l') goto yy40;
				goto yy157;
			} else {
				if (yych <= 'n') goto yy158;
				if (yych == 's') goto yy159;
				goto yy40;
			}
		}
yy42:
		YYDEBUG(42, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy160;
		if (yych == 'i') goto yy160;
		goto yy40;
yy43:
		YYDEBUG(43, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy161;
		if (yych == 'a') goto yy161;
		goto yy40;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy162;
			if (yych <= 'D') goto yy40;
			goto yy163;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy40;
				goto yy162;
			} else {
				if (yych == 'e') goto yy163;
				goto yy40;
			}
		}
yy45:
		YYDEBUG(45, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy164;
		if (yych == 'r') goto yy164;
		goto yy40;
yy46:
		YYDEBUG(46, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'R') goto yy166;
			if (yych <= 'T') goto yy40;
			goto yy167;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy40;
				goto yy166;
			} else {
				if (yych == 'u') goto yy167;
				goto yy40;
			}
		}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy168;
		if (yych == 'e') goto yy168;
		goto yy40;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych == 'T') goto yy169;
			if (yych <= 'V') goto yy40;
			goto yy170;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy40;
				goto yy169;
			} else {
				if (yych == 'w') goto yy170;
				goto yy40;
			}
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'R') {
			if (yych == 'H') goto yy171;
			if (yych <= 'Q') goto yy40;
			goto yy172;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy40;
				goto yy171;
			} else {
				if (yych == 'r') goto yy172;
				goto yy40;
			}
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych == 'N') goto yy173;
			if (yych <= 'R') goto yy40;
			goto yy174;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy40;
				goto yy173;
			} else {
				if (yych == 's') goto yy174;
				goto yy40;
			}
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy175;
		if (yych == 'a') goto yy175;
		goto yy40;
yy52:
		YYDEBUG(52, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy176;
		if (yych == 'h') goto yy176;
		goto yy40;
yy53:
		YYDEBUG(53, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy177;
		if (yych == 'o') goto yy177;
		goto yy40;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy178;
		if (yych == 'i') goto yy178;
		goto yy40;
yy55:
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		goto yy14;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy57;
			if (yych <= 'Z') goto yy179;
			if (yych >= '_') goto yy179;
		} else {
			if (yych <= '`') goto yy57;
			if (yych <= 'z') goto yy179;
			if (yych >= 0x80) goto yy179;
		}
yy57:
		YYDEBUG(57, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NS_SEPARATOR);
}
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy181;
		goto yy4;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy182;
		goto yy40;
yy60:
		YYDEBUG(60, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	RETURN_TOKEN('`');
}
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	enter_nesting('{');
	RETURN_TOKEN('{');
}
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '>') {
			if (yych <= '<') goto yy4;
			if (yych <= '=') goto yy183;
			goto yy184;
		} else {
			if (yych == '|') goto yy185;
			goto yy4;
		}
yy63:
		YYDEBUG(63, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state();
	}
	RETURN_EXIT_NESTING_TOKEN('}');
}
yy64:
		YYDEBUG(64, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy186;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_EQUAL);
}
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	enter_nesting('[');
	RETURN_TOKEN(T_ATTRIBUTE);
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy67;
			} else {
				if (yych <= '@') goto yy68;
				if (yych <= 'Z') goto yy67;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy67;
			} else {
				if (yych <= 'z') goto yy67;
				if (yych >= 0x80) goto yy67;
			}
		}
yy68:
		YYDEBUG(68, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy69:
		YYDEBUG(69, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MOD_EQUAL);
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy71:
		YYDEBUG(71, *YYCURSOR);
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy72;
				if (yych <= '\n') goto yy70;
			} else {
				if (yych <= '\r') goto yy70;
				if (yych >= ' ') goto yy70;
			}
		} else {
			if (yych <= '$') {
				if (yych <= '"') goto yy72;
				if (yych <= '#') goto yy73;
				goto yy74;
			} else {
				if (yych <= '-') goto yy72;
				if (yych <= '.') goto yy77;
				if (yych <= '/') goto yy78;
			}
		}
yy72:
		YYDEBUG(72, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 48) {
			if (yyaccept <= 24) {
				if (yyaccept <= 12) {
					if (yyaccept <= 6) {
						if (yyaccept <= 3) {
							if (yyaccept <= 1) {
								if (yyaccept == 0) {
									goto yy11;
								} else {
									goto yy14;
								}
							} else {
								if (yyaccept == 2) {
									goto yy4;
								} else {
									goto yy23;
								}
							}
						} else {
							if (yyaccept <= 5) {
								if (yyaccept == 4) {
									goto yy32;
								} else {
									goto yy102;
								}
							} else {
								goto yy105;
							}
						}
					} else {
						if (yyaccept <= 9) {
							if (yyaccept <= 8) {
								if (yyaccept == 7) {
									goto yy116;
								} else {
									goto yy131;
								}
							} else {
								goto yy141;
							}
						} else {
							if (yyaccept <= 11) {
								if (yyaccept == 10) {
									goto yy150;
								} else {
									goto yy156;
								}
							} else {
								goto yy165;
							}
						}
					}
				} else {
					if (yyaccept <= 18) {
						if (yyaccept <= 15) {
							if (yyaccept <= 14) {
								if (yyaccept == 13) {
									goto yy180;
								} else {
									goto yy207;
								}
							} else {
								goto yy211;
							}
						} else {
							if (yyaccept <= 17) {
								if (yyaccept == 16) {
									goto yy213;
								} else {
									goto yy225;
								}
							} else {
								goto yy228;
							}
						}
					} else {
						if (yyaccept <= 21) {
							if (yyaccept <= 20) {
								if (yyaccept == 19) {
									goto yy240;
								} else {
									goto yy251;
								}
							} else {
								goto yy264;
							}
						} else {
							if (yyaccept <= 23) {
								if (yyaccept == 22) {
									goto yy276;
								} else {
									goto yy279;
								}
							} else {
								goto yy281;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 36) {
					if (yyaccept <= 30) {
						if (yyaccept <= 27) {
							if (yyaccept <= 26) {
								if (yyaccept == 25) {
									goto yy284;
								} else {
									goto yy75;
								}
							} else {
								goto yy321;
							}
						} else {
							if (yyaccept <= 29) {
								if (yyaccept == 28) {
									goto yy330;
								} else {
									goto yy332;
								}
							} else {
								goto yy341;
							}
						}
					} else {
						if (yyaccept <= 33) {
							if (yyaccept <= 32) {
								if (yyaccept == 31) {
									goto yy343;
								} else {
									goto yy350;
								}
							} else {
								goto yy357;
							}
						} else {
							if (yyaccept <= 35) {
								if (yyaccept == 34) {
									goto yy408;
								} else {
									goto yy410;
								}
							} else {
								goto yy413;
							}
						}
					}
				} else {
					if (yyaccept <= 42) {
						if (yyaccept <= 39) {
							if (yyaccept <= 38) {
								if (yyaccept == 37) {
									goto yy415;
								} else {
									goto yy417;
								}
							} else {
								goto yy419;
							}
						} else {
							if (yyaccept <= 41) {
								if (yyaccept == 40) {
									goto yy425;
								} else {
									goto yy429;
								}
							} else {
								goto yy437;
							}
						}
					} else {
						if (yyaccept <= 45) {
							if (yyaccept <= 44) {
								if (yyaccept == 43) {
									goto yy447;
								} else {
									goto yy449;
								}
							} else {
								goto yy452;
							}
						} else {
							if (yyaccept <= 47) {
								if (yyaccept == 46) {
									goto yy462;
								} else {
									goto yy464;
								}
							} else {
								goto yy466;
							}
						}
					}
				}
			}
		} else {
			if (yyaccept <= 72) {
				if (yyaccept <= 60) {
					if (yyaccept <= 54) {
						if (yyaccept <= 51) {
							if (yyaccept <= 50) {
								if (yyaccept == 49) {
									goto yy468;
								} else {
									goto yy470;
								}
							} else {
								goto yy503;
							}
						} else {
							if (yyaccept <= 53) {
								if (yyaccept == 52) {
									goto yy506;
								} else {
									goto yy510;
								}
							} else {
								goto yy521;
							}
						}
					} else {
						if (yyaccept <= 57) {
							if (yyaccept <= 56) {
								if (yyaccept == 55) {
									goto yy531;
								} else {
									goto yy535;
								}
							} else {
								goto yy537;
							}
						} else {
							if (yyaccept <= 59) {
								if (yyaccept == 58) {
									goto yy539;
								} else {
									goto yy568;
								}
							} else {
								goto yy570;
							}
						}
					}
				} else {
					if (yyaccept <= 66) {
						if (yyaccept <= 63) {
							if (yyaccept <= 62) {
								if (yyaccept == 61) {
									goto yy584;
								} else {
									goto yy586;
								}
							} else {
								goto yy588;
							}
						} else {
							if (yyaccept <= 65) {
								if (yyaccept == 64) {
									goto yy592;
								} else {
									goto yy598;
								}
							} else {
								goto yy603;
							}
						}
					} else {
						if (yyaccept <= 69) {
							if (yyaccept <= 68) {
								if (yyaccept == 67) {
									goto yy610;
								} else {
									goto yy625;
								}
							} else {
								goto yy627;
							}
						} else {
							if (yyaccept <= 71) {
								if (yyaccept == 70) {
									goto yy629;
								} else {
									goto yy634;
								}
							} else {
								goto yy641;
							}
						}
					}
				}
			} else {
				if (yyaccept <= 84) {
					if (yyaccept <= 78) {
						if (yyaccept <= 75) {
							if (yyaccept <= 74) {
								if (yyaccept == 73) {
									goto yy652;
								} else {
									goto yy661;
								}
							} else {
								goto yy665;
							}
						} else {
							if (yyaccept <= 77) {
								if (yyaccept == 76) {
									goto yy677;
								} else {
									goto yy688;
								}
							} else {
								goto yy690;
							}
						}
					} else {
						if (yyaccept <= 81) {
							if (yyaccept <= 80) {
								if (yyaccept == 79) {
									goto yy692;
								} else {
									goto yy695;
								}
							} else {
								goto yy702;
							}
						} else {
							if (yyaccept <= 83) {
								if (yyaccept == 82) {
									goto yy709;
								} else {
									goto yy713;
								}
							} else {
								goto yy715;
							}
						}
					}
				} else {
					if (yyaccept <= 90) {
						if (yyaccept <= 87) {
							if (yyaccept <= 86) {
								if (yyaccept == 85) {
									goto yy726;
								} else {
									goto yy729;
								}
							} else {
								goto yy742;
							}
						} else {
							if (yyaccept <= 89) {
								if (yyaccept == 88) {
									goto yy755;
								} else {
									goto yy783;
								}
							} else {
								goto yy787;
							}
						}
					} else {
						if (yyaccept <= 93) {
							if (yyaccept <= 92) {
								if (yyaccept == 91) {
									goto yy761;
								} else {
									goto yy794;
								}
							} else {
								goto yy798;
							}
						} else {
							if (yyaccept <= 95) {
								if (yyaccept == 94) {
									goto yy771;
								} else {
									goto yy814;
								}
							} else {
								goto yy833;
							}
						}
					}
				}
			}
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy188;
			goto yy187;
		} else {
			if (yych <= '\r') goto yy188;
			if (yych == '[') goto yy72;
			goto yy187;
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		++YYCURSOR;
yy75:
		YYDEBUG(75, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(1);
	RETURN_TOKEN(T_AMPERSAND_FOLLOWED_BY_VAR_OR_VARARG);
}
yy76:
		YYDEBUG(76, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_AND);
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy189;
		goto yy72;
yy78:
		YYDEBUG(78, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy190;
		if (yych == '/') goto yy187;
		goto yy72;
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_AND_EQUAL);
}
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy81:
		YYDEBUG(81, *YYCURSOR);
		if (yybm[0+yych] & 1) {
			goto yy80;
		}
		switch (yych) {
			case 'A':
			case 'a': goto yy82;
			case 'B':
			case 'b': goto yy83;
			case 'D':
			case 'd': goto yy84;
			case 'F':
			case 'f': goto yy85;
			case 'I':
			case 'i': goto yy86;
			case 'O':
			case 'o': goto yy87;
			case 'R':
			case 'r': goto yy88;
			case 'S':
			case 's': goto yy89;
			case 'U':
			case 'u': goto yy90;
			case 'V':
			case 'v': goto yy91;
			default: goto yy72;
		}
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy191;
		if (yych == 'r') goto yy191;
		goto yy72;
yy83:
		YYDEBUG(83, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy192;
			if (yych <= 'N') goto yy72;
			goto yy193;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy72;
				goto yy192;
			} else {
				if (yych == 'o') goto yy193;
				goto yy72;
			}
		}
yy84:
		YYDEBUG(84, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy194;
		if (yych == 'o') goto yy194;
		goto yy72;
yy85:
		YYDEBUG(85, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy195;
		if (yych == 'l') goto yy195;
		goto yy72;
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy196;
		if (yych == 'n') goto yy196;
		goto yy72;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy197;
		if (yych == 'b') goto yy197;
		goto yy72;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy198;
		if (yych == 'e') goto yy198;
		goto yy72;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy199;
		if (yych == 't') goto yy199;
		goto yy72;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy200;
		if (yych == 'n') goto yy200;
		goto yy72;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy201;
		if (yych == 'o') goto yy201;
		goto yy72;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy202;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW);
}
yy93:
		YYDEBUG(93, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MUL_EQUAL);
}
yy94:
		YYDEBUG(94, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INC);
}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PLUS_EQUAL);
}
yy96:
		YYDEBUG(96, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DEC);
}
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_MINUS_EQUAL);
}
yy98:
		YYDEBUG(98, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy203;
		goto yy72;
yy100:
		YYDEBUG(100, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
yy101:
		YYDEBUG(101, *YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '/') goto yy102;
			if (yych <= '9') goto yy100;
			if (yych >= 'E') goto yy110;
		} else {
			if (yych <= '_') {
				if (yych >= '_') goto yy204;
			} else {
				if (yych == 'e') goto yy110;
			}
		}
yy102:
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *end;
	size_t len = yyleng;
	char *dnum = yytext;
	bool contains_underscores = (memchr(dnum, '_', len) != NULL);

	if (contains_underscores) {
		dnum = estrndup(dnum, len);
		strip_underscores(dnum, &len);
	}

	ZVAL_DOUBLE(zendlval, zend_strtod(dnum, &end));
	/* errno isn't checked since we allow HUGE_VAL/INF overflow */
	ZEND_ASSERT(end == dnum + len);
	if (contains_underscores) {
		efree(dnum);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_CONCAT_EQUAL);
}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyaccept = 6;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy205;
yy105:
		YYDEBUG(105, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy106:
		YYDEBUG(106, *YYCURSOR);
		++YYCURSOR;
		goto yy7;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DIV_EQUAL);
}
yy108:
		YYDEBUG(108, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy102;
		goto yy101;
yy109:
		YYDEBUG(109, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		goto yy72;
yy110:
		YYDEBUG(110, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy208;
			goto yy72;
		} else {
			if (yych <= '-') goto yy208;
			if (yych <= '/') goto yy72;
			if (yych <= '9') goto yy209;
			goto yy72;
		}
yy111:
		YYDEBUG(111, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy210;
		}
		goto yy72;
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy212;
		}
		goto yy72;
yy113:
		YYDEBUG(113, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[256+yych] & 64) {
			goto yy24;
		}
		goto yy72;
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PAAMAYIM_NEKUDOTAYIM);
}
yy115:
		YYDEBUG(115, *YYCURSOR);
		yyaccept = 7;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy116;
		if (yych <= '<') goto yy214;
		if (yych <= '=') goto yy215;
yy116:
		YYDEBUG(116, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL);
}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy216;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_SMALLER_OR_EQUAL);
}
yy118:
		YYDEBUG(118, *YYCURSOR);
		++YYCURSOR;
		goto yy65;
yy119:
		YYDEBUG(119, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy217;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_EQUAL);
}
yy120:
		YYDEBUG(120, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_ARROW);
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_GREATER_OR_EQUAL);
}
yy122:
		YYDEBUG(122, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy218;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR);
}
yy123:
		YYDEBUG(123, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy219;
		goto yy72;
yy124:
		YYDEBUG(124, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy220;
		if (yych == '\r') goto yy221;
yy125:
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(INITIAL);
	if (yytext[yyleng-1] != '>') {
		CG(increment_lineno) = 1;
	}
	if (PARSER_MODE()) {
		RETURN_TOKEN(';');  /* implicit ';' at php-end tag */
	}
	RETURN_TOKEN(T_CLOSE_TAG);
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy222;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE);
}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy223;
		if (yych == 's') goto yy223;
		goto yy40;
yy128:
		YYDEBUG(128, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy224;
		if (yych == 'd') goto yy224;
		goto yy40;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy226;
		if (yych == 'r') goto yy226;
		goto yy40;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yyaccept = 8;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy131:
		YYDEBUG(131, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_AS);
}
yy132:
		YYDEBUG(132, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy72;
			if (yych <= 'Z') goto yy227;
			if (yych <= '^') goto yy72;
			goto yy227;
		} else {
			if (yych <= '`') goto yy72;
			if (yych <= 'z') goto yy227;
			if (yych <= 0x7F) goto yy72;
			goto yy227;
		}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy229;
		goto yy72;
yy134:
		YYDEBUG(134, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy230;
		if (yych == 'e') goto yy230;
		goto yy40;
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy40;
				goto yy231;
			} else {
				if (yych <= 'R') goto yy40;
				if (yych <= 'S') goto yy232;
				goto yy233;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy231;
				goto yy40;
			} else {
				if (yych <= 's') goto yy232;
				if (yych <= 't') goto yy233;
				goto yy40;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'A') goto yy234;
			if (yych <= 'N') goto yy40;
			goto yy235;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy40;
				goto yy234;
			} else {
				if (yych == 'o') goto yy235;
				goto yy40;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy236;
		if (yych == 'n') goto yy236;
		goto yy40;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'F') {
			if (yych == 'C') goto yy237;
			if (yych <= 'E') goto yy40;
			goto yy238;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy40;
				goto yy237;
			} else {
				if (yych == 'f') goto yy238;
				goto yy40;
			}
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy239;
		if (yych == 'e') goto yy239;
		goto yy40;
yy140:
		YYDEBUG(140, *YYCURSOR);
		yyaccept = 9;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DO);
}
yy142:
		YYDEBUG(142, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy241;
		if (yych == 'h') goto yy241;
		goto yy40;
yy143:
		YYDEBUG(143, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy242;
		if (yych == 's') goto yy242;
		goto yy40;
yy144:
		YYDEBUG(144, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy243;
		if (yych == 'p') goto yy243;
		goto yy40;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'D') goto yy244;
			if (yych <= 'T') goto yy40;
			goto yy245;
		} else {
			if (yych <= 'd') {
				if (yych <= 'c') goto yy40;
				goto yy244;
			} else {
				if (yych == 'u') goto yy245;
				goto yy40;
			}
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy246;
		if (yych == 'a') goto yy246;
		goto yy40;
yy147:
		YYDEBUG(147, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych == 'I') goto yy247;
			if (yych <= 'S') goto yy40;
			goto yy248;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy40;
				goto yy247;
			} else {
				if (yych == 't') goto yy248;
				goto yy40;
			}
		}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy249;
		if (yych == 'n') goto yy249;
		goto yy40;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yyaccept = 10;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FN);
}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy250;
		if (yych == 'r') goto yy250;
		goto yy40;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy252;
		if (yych == 'n') goto yy252;
		goto yy40;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy253;
		if (yych == 'o') goto yy253;
		goto yy40;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy254;
		if (yych == 't') goto yy254;
		goto yy40;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 11;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy156:
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IF);
}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy255;
		if (yych == 'p') goto yy255;
		goto yy40;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy40;
				goto yy256;
			} else {
				if (yych <= 'R') goto yy40;
				if (yych <= 'S') goto yy257;
				goto yy258;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy256;
				goto yy40;
			} else {
				if (yych <= 's') goto yy257;
				if (yych <= 't') goto yy258;
				goto yy40;
			}
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy259;
		if (yych == 's') goto yy259;
		goto yy40;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy260;
		if (yych == 's') goto yy260;
		goto yy40;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy261;
		if (yych == 't') goto yy261;
		goto yy40;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy262;
		if (yych == 'm') goto yy262;
		goto yy40;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy263;
		if (yych == 'w') goto yy263;
		goto yy40;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yyaccept = 12;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_OR);
}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == 'I') goto yy265;
			if (yych <= 'N') goto yy40;
			goto yy266;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy40;
				goto yy265;
			} else {
				if (yych == 'o') goto yy266;
				goto yy40;
			}
		}
yy167:
		YYDEBUG(167, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy267;
		if (yych == 'b') goto yy267;
		goto yy40;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'P') {
				if (yych == 'A') goto yy268;
				goto yy40;
			} else {
				if (yych <= 'Q') goto yy269;
				if (yych <= 'S') goto yy40;
				goto yy270;
			}
		} else {
			if (yych <= 'p') {
				if (yych == 'a') goto yy268;
				goto yy40;
			} else {
				if (yych <= 'q') goto yy269;
				if (yych == 't') goto yy270;
				goto yy40;
			}
		}
yy169:
		YYDEBUG(169, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy271;
		if (yych == 'a') goto yy271;
		goto yy40;
yy170:
		YYDEBUG(170, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy272;
		if (yych == 'i') goto yy272;
		goto yy40;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy273;
		if (yych == 'r') goto yy273;
		goto yy40;
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'Y') {
			if (yych == 'A') goto yy274;
			if (yych <= 'X') goto yy40;
			goto yy275;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy40;
				goto yy274;
			} else {
				if (yych == 'y') goto yy275;
				goto yy40;
			}
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy277;
		if (yych == 's') goto yy277;
		goto yy40;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy278;
		if (yych == 'e') goto yy278;
		goto yy40;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy280;
		if (yych == 'r') goto yy280;
		goto yy40;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy282;
		if (yych == 'i') goto yy282;
		goto yy40;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy283;
		if (yych == 'r') goto yy283;
		goto yy40;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy285;
		if (yych == 'e') goto yy285;
		goto yy40;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyaccept = 13;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy180;
				if (yych <= '9') goto yy179;
			} else {
				if (yych <= 'Z') goto yy179;
				if (yych >= '\\') goto yy286;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy179;
			} else {
				if (yych <= 'z') goto yy179;
				if (yych >= 0x80) goto yy179;
			}
		}
yy180:
		YYDEBUG(180, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_FULLY_QUALIFIED, 1);
}
yy181:
		YYDEBUG(181, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_XOR_EQUAL);
}
yy182:
		YYDEBUG(182, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'C':
			case 'c': goto yy287;
			case 'D':
			case 'd': goto yy288;
			case 'F':
			case 'f': goto yy289;
			case 'H':
			case 'h': goto yy290;
			case 'L':
			case 'l': goto yy291;
			case 'M':
			case 'm': goto yy292;
			case 'N':
			case 'n': goto yy293;
			case 'P':
			case 'p': goto yy294;
			case 'T':
			case 't': goto yy295;
			default: goto yy40;
		}
yy183:
		YYDEBUG(183, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OR_EQUAL);
}
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_PIPE);
}
yy185:
		YYDEBUG(185, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOLEAN_OR);
}
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_NOT_IDENTICAL);
}
yy187:
		YYDEBUG(187, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy187;
		}
		if (yych <= 0x00) goto yy72;
		goto yy70;
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy187;
				goto yy188;
			} else {
				if (yych <= '\n') goto yy70;
				if (yych == '\r') goto yy70;
				goto yy187;
			}
		} else {
			if (yych <= '$') {
				if (yych <= ' ') goto yy188;
				if (yych <= '"') goto yy187;
				if (yych <= '#') goto yy296;
				goto yy297;
			} else {
				if (yych <= '-') goto yy187;
				if (yych <= '.') goto yy298;
				if (yych <= '/') goto yy299;
				goto yy187;
			}
		}
yy189:
		YYDEBUG(189, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '.') goto yy74;
		goto yy72;
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy190;
		}
		if (yych <= 0x00) goto yy72;
		goto yy300;
yy191:
		YYDEBUG(191, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy301;
		if (yych == 'r') goto yy301;
		goto yy72;
yy192:
		YYDEBUG(192, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy302;
		if (yych == 'n') goto yy302;
		goto yy72;
yy193:
		YYDEBUG(193, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy303;
		if (yych == 'o') goto yy303;
		goto yy72;
yy194:
		YYDEBUG(194, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy304;
		if (yych == 'u') goto yy304;
		goto yy72;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy305;
		if (yych == 'o') goto yy305;
		goto yy72;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy306;
		if (yych == 't') goto yy306;
		goto yy72;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy307;
		if (yych == 'j') goto yy307;
		goto yy72;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy308;
		if (yych == 'a') goto yy308;
		goto yy72;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy309;
		if (yych == 'r') goto yy309;
		goto yy72;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy310;
		if (yych == 's') goto yy310;
		goto yy72;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy311;
		if (yych == 'i') goto yy311;
		goto yy72;
yy202:
		YYDEBUG(202, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_POW_EQUAL);
}
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ELLIPSIS);
}
yy204:
		YYDEBUG(204, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy72;
		if (yych <= '9') goto yy100;
		goto yy72;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy72;
			if (yych <= '\n') goto yy312;
			goto yy72;
		} else {
			if (yych <= '\r') goto yy312;
			if (yych == ' ') goto yy312;
			goto yy72;
		}
yy206:
		YYDEBUG(206, *YYCURSOR);
		yyaccept = 14;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy206;
		}
		if (yych == '_') goto yy109;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0b" */
	size_t len = yyleng - 2;
	char *end, *bin = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*bin == '0' || *bin == '_')) {
		++bin;
		--len;
	}

	contains_underscores = (memchr(bin, '_', len) != NULL);

	if (contains_underscores) {
		bin = estrndup(bin, len);
		strip_underscores(bin, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 8) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(bin, &end, 2));
			ZEND_ASSERT(!errno && end == bin + len);
		}
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == bin + len);
		if (contains_underscores) {
			efree(bin);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy72;
		if (yych >= ':') goto yy72;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yyaccept = 5;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy102;
		if (yych <= '9') goto yy209;
		if (yych == '_') goto yy208;
		goto yy102;
yy210:
		YYDEBUG(210, *YYCURSOR);
		yyaccept = 15;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy210;
		}
		if (yych == '_') goto yy111;
yy211:
		YYDEBUG(211, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0o" */
	size_t len = yyleng - 2;
	char *end, *octal = yytext + 2;
	bool contains_underscores = (memchr(octal, '_', len) != NULL);

	/* Skip any leading 0s */
	while (len > 0 && (*octal == '0' || *octal == '_')) {
		++octal;
		--len;
	}

	if (len == 0) {
		ZVAL_LONG(zendlval, 0);
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	if (contains_underscores) {
		octal = estrndup(octal, len);
		strip_underscores(octal, &len);
	}

	errno = 0;

	ZVAL_LONG(zendlval, ZEND_STRTOL(octal, &end, 8));

	ZEND_ASSERT(end == octal + len);

	if (!errno) {
		if (contains_underscores) {
			efree(octal);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	}

	/* Overflow */
	ZEND_ASSERT(errno == ERANGE);
	/* Reset errno */
	errno = 0;

	/* zend_oct_strtod skips leading '0' */
	ZVAL_DOUBLE(zendlval, zend_oct_strtod(octal, (const char **)&end));
	ZEND_ASSERT(!errno);
	ZEND_ASSERT(end == octal + len);
	if (contains_underscores) {
		efree(octal);
	}
	RETURN_TOKEN_WITH_VAL(T_DNUMBER);
}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyaccept = 16;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy212;
		}
		if (yych == '_') goto yy112;
yy213:
		YYDEBUG(213, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* The +/- 2 skips "0x" */
	size_t len = yyleng - 2;
	char *end, *hex = yytext + 2;
	bool contains_underscores;

	/* Skip any leading 0s */
	while (len > 0 && (*hex == '0' || *hex == '_')) {
		++hex;
		--len;
	}

	contains_underscores = (memchr(hex, '_', len) != NULL);

	if (contains_underscores) {
		hex = estrndup(hex, len);
		strip_underscores(hex, &len);
	}

	if (len < SIZEOF_ZEND_LONG * 2 || (len == SIZEOF_ZEND_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			ZVAL_LONG(zendlval, 0);
		} else {
			errno = 0;
			ZVAL_LONG(zendlval, ZEND_STRTOL(hex, &end, 16));
			ZEND_ASSERT(!errno && end == hex + len);
		}
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_LNUMBER);
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, (const char **)&end));
		/* errno isn't checked since we allow HUGE_VAL/INF overflow */
		ZEND_ASSERT(end == hex + len);
		if (contains_underscores) {
			efree(hex);
		}
		RETURN_TOKEN_WITH_VAL(T_DNUMBER);
	}
}
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '\'') {
			if (yych <= ' ') {
				if (yych == '\t') goto yy214;
				if (yych <= 0x1F) goto yy72;
				goto yy214;
			} else {
				if (yych == '"') goto yy313;
				if (yych <= '&') goto yy72;
				goto yy314;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy72;
				if (yych <= 'Z') goto yy315;
				if (yych <= '^') goto yy72;
				goto yy315;
			} else {
				if (yych <= '`') goto yy72;
				if (yych <= 'z') goto yy315;
				if (yych <= 0x7F) goto yy72;
				goto yy315;
			}
		}
yy215:
		YYDEBUG(215, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SL_EQUAL);
}
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SPACESHIP);
}
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_IS_IDENTICAL);
}
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_SR_EQUAL);
}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		goto yy125;
yy221:
		YYDEBUG(221, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy220;
		goto yy125;
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_COALESCE_EQUAL);
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy316;
		if (yych == 't') goto yy316;
		goto yy40;
yy224:
		YYDEBUG(224, *YYCURSOR);
		yyaccept = 17;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy225:
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_AND);
}
yy226:
		YYDEBUG(226, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy317;
		if (yych == 'a') goto yy317;
		goto yy40;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yyaccept = 18;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy228;
				if (yych <= '9') goto yy227;
			} else {
				if (yych <= 'Z') goto yy227;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy227;
			} else {
				if (yych <= 'z') goto yy227;
				if (yych >= 0x80) goto yy227;
			}
		}
yy228:
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_QUALIFIED, 0);
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy214;
		goto yy72;
yy230:
		YYDEBUG(230, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy318;
		if (yych == 'a') goto yy318;
		goto yy40;
yy231:
		YYDEBUG(231, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy319;
		if (yych == 'l') goto yy319;
		goto yy40;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy320;
		if (yych == 'e') goto yy320;
		goto yy40;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy322;
		if (yych == 'c') goto yy322;
		goto yy40;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy323;
		if (yych == 's') goto yy323;
		goto yy40;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy324;
		if (yych == 'n') goto yy324;
		goto yy40;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'T') {
			if (yych <= 'R') goto yy40;
			if (yych <= 'S') goto yy325;
			goto yy326;
		} else {
			if (yych <= 'r') goto yy40;
			if (yych <= 's') goto yy325;
			if (yych <= 't') goto yy326;
			goto yy40;
		}
yy237:
		YYDEBUG(237, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy327;
		if (yych == 'l') goto yy327;
		goto yy40;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy328;
		if (yych == 'a') goto yy328;
		goto yy40;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yyaccept = 19;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy241:
		YYDEBUG(241, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy329;
		if (yych == 'o') goto yy329;
		goto yy40;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy331;
		if (yych == 'e') goto yy331;
		goto yy40;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy333;
		if (yych == 't') goto yy333;
		goto yy40;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		switch (yych) {
			case 'D':
			case 'd': goto yy334;
			case 'F':
			case 'f': goto yy335;
			case 'I':
			case 'i': goto yy336;
			case 'S':
			case 's': goto yy337;
			case 'W':
			case 'w': goto yy338;
			default: goto yy40;
		}
yy245:
		YYDEBUG(245, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy339;
		if (yych == 'm') goto yy339;
		goto yy40;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy340;
		if (yych == 'l') goto yy340;
		goto yy40;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy342;
		if (yych == 't') goto yy342;
		goto yy40;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy344;
		if (yych == 'e') goto yy344;
		goto yy40;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy345;
		if (yych == 'a') goto yy345;
		goto yy40;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yyaccept = 20;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy251;
				if (yych <= '9') goto yy39;
				if (yych >= 'A') goto yy39;
			} else {
				if (yych <= 'E') goto yy346;
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy39;
				if (yych >= 'a') goto yy39;
			} else {
				if (yych <= 'e') goto yy346;
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy251:
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOR);
}
yy252:
		YYDEBUG(252, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy347;
		if (yych == 'c') goto yy347;
		goto yy40;
yy253:
		YYDEBUG(253, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy348;
		if (yych == 'b') goto yy348;
		goto yy40;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy349;
		if (yych == 'o') goto yy349;
		goto yy40;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy351;
		if (yych == 'l') goto yy351;
		goto yy40;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy352;
		if (yych == 'l') goto yy352;
		goto yy40;
yy257:
		YYDEBUG(257, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy353;
		if (yych == 't') goto yy353;
		goto yy40;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy354;
		if (yych == 'e') goto yy354;
		goto yy40;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy355;
		if (yych == 'e') goto yy355;
		goto yy40;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy356;
		if (yych == 't') goto yy356;
		goto yy40;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy358;
		if (yych == 'c') goto yy358;
		goto yy40;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy359;
		if (yych == 'e') goto yy359;
		goto yy40;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yyaccept = 21;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NEW);
}
yy265:
		YYDEBUG(265, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'V') {
			if (yych == 'N') goto yy360;
			if (yych <= 'U') goto yy40;
			goto yy361;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy40;
				goto yy360;
			} else {
				if (yych == 'v') goto yy361;
				goto yy40;
			}
		}
yy266:
		YYDEBUG(266, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy362;
		if (yych == 't') goto yy362;
		goto yy40;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy40;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy364;
		if (yych == 'd') goto yy364;
		goto yy40;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy365;
		if (yych == 'u') goto yy365;
		goto yy40;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy366;
		if (yych == 'u') goto yy366;
		goto yy40;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy367;
		if (yych == 't') goto yy367;
		goto yy40;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy368;
		if (yych == 't') goto yy368;
		goto yy40;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy369;
		if (yych == 'o') goto yy369;
		goto yy40;
yy274:
		YYDEBUG(274, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy370;
		if (yych == 'i') goto yy370;
		goto yy40;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yyaccept = 22;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRY);
}
yy277:
		YYDEBUG(277, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy371;
		if (yych == 'e') goto yy371;
		goto yy40;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yyaccept = 23;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_USE);
}
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyaccept = 24;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_VAR);
}
yy282:
		YYDEBUG(282, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy372;
		if (yych == 'l') goto yy372;
		goto yy40;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yyaccept = 25;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LOGICAL_XOR);
}
yy285:
		YYDEBUG(285, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy373;
		if (yych == 'l') goto yy373;
		goto yy40;
yy286:
		YYDEBUG(286, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy72;
			if (yych <= 'Z') goto yy179;
			if (yych <= '^') goto yy72;
			goto yy179;
		} else {
			if (yych <= '`') goto yy72;
			if (yych <= 'z') goto yy179;
			if (yych <= 0x7F) goto yy72;
			goto yy179;
		}
yy287:
		YYDEBUG(287, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy374;
		if (yych == 'l') goto yy374;
		goto yy40;
yy288:
		YYDEBUG(288, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy375;
		if (yych == 'i') goto yy375;
		goto yy40;
yy289:
		YYDEBUG(289, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'U') {
			if (yych == 'I') goto yy376;
			if (yych <= 'T') goto yy40;
			goto yy377;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy40;
				goto yy376;
			} else {
				if (yych == 'u') goto yy377;
				goto yy40;
			}
		}
yy290:
		YYDEBUG(290, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy378;
		if (yych == 'a') goto yy378;
		goto yy40;
yy291:
		YYDEBUG(291, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy379;
		if (yych == 'i') goto yy379;
		goto yy40;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy380;
		if (yych == 'e') goto yy380;
		goto yy40;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy381;
		if (yych == 'a') goto yy381;
		goto yy40;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy382;
		if (yych == 'r') goto yy382;
		goto yy40;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy383;
		if (yych == 'r') goto yy383;
		goto yy40;
yy296:
		YYDEBUG(296, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy187;
		}
		if (yych <= 0x00) goto yy72;
		goto yy188;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 2) {
			goto yy187;
		}
		if (yych <= 0x00) goto yy75;
		goto yy70;
yy298:
		YYDEBUG(298, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy70;
			goto yy187;
		} else {
			if (yych <= '\r') goto yy70;
			if (yych == '.') goto yy384;
			goto yy187;
		}
yy299:
		YYDEBUG(299, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy70;
			goto yy187;
		} else {
			if (yych <= '\r') goto yy70;
			if (yych == '*') goto yy385;
			goto yy187;
		}
yy300:
		YYDEBUG(300, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy300;
		}
		if (yych <= 0x00) goto yy72;
		if (yych == '/') goto yy70;
		goto yy190;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy386;
		if (yych == 'a') goto yy386;
		goto yy72;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy387;
		if (yych == 'a') goto yy387;
		goto yy72;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy388;
		if (yych == 'l') goto yy388;
		goto yy72;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy389;
		if (yych == 'b') goto yy389;
		goto yy72;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy390;
		if (yych == 'a') goto yy390;
		goto yy72;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy393;
		if (yych == 'e') goto yy393;
		goto yy392;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy394;
		if (yych == 'e') goto yy394;
		goto yy72;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy395;
		if (yych == 'l') goto yy395;
		goto yy72;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy396;
		if (yych == 'i') goto yy396;
		goto yy72;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy397;
		if (yych == 'e') goto yy397;
		goto yy72;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy398;
		if (yych == 'd') goto yy398;
		goto yy72;
yy312:
		YYDEBUG(312, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy105;
			if (yych <= '\n') goto yy312;
			goto yy105;
		} else {
			if (yych <= '\r') goto yy312;
			if (yych == ' ') goto yy312;
			goto yy105;
		}
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy72;
		if (yych <= '/') goto yy400;
		if (yych <= '9') goto yy72;
		goto yy400;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy72;
		if (yych <= '/') goto yy402;
		if (yych <= '9') goto yy72;
		goto yy402;
yy315:
		YYDEBUG(315, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy403;
				goto yy72;
			} else {
				if (yych <= '\r') goto yy405;
				if (yych <= '/') goto yy72;
				if (yych <= '9') goto yy315;
				goto yy72;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy315;
				if (yych <= '^') goto yy72;
				goto yy315;
			} else {
				if (yych <= '`') goto yy72;
				if (yych <= 'z') goto yy315;
				if (yych <= 0x7F) goto yy72;
				goto yy315;
			}
		}
yy316:
		YYDEBUG(316, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy406;
		if (yych == 'r') goto yy406;
		goto yy40;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy407;
		if (yych == 'y') goto yy407;
		goto yy40;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'K') goto yy409;
		if (yych == 'k') goto yy409;
		goto yy40;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy411;
		if (yych == 'a') goto yy411;
		goto yy40;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yyaccept = 27;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CASE);
}
yy322:
		YYDEBUG(322, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy412;
		if (yych == 'h') goto yy412;
		goto yy40;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy414;
		if (yych == 's') goto yy414;
		goto yy40;
yy324:
		YYDEBUG(324, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy416;
		if (yych == 'e') goto yy416;
		goto yy40;
yy325:
		YYDEBUG(325, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy418;
		if (yych == 't') goto yy418;
		goto yy40;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy420;
		if (yych == 'i') goto yy420;
		goto yy40;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy421;
		if (yych == 'a') goto yy421;
		goto yy40;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy422;
		if (yych == 'u') goto yy422;
		goto yy40;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yyaccept = 28;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ECHO);
}
yy331:
		YYDEBUG(331, *YYCURSOR);
		yyaccept = 29;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'H') {
				if (yych <= '/') goto yy332;
				if (yych <= '9') goto yy39;
				if (yych >= 'A') goto yy39;
			} else {
				if (yych <= 'I') goto yy423;
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= 'h') {
				if (yych == '_') goto yy39;
				if (yych >= 'a') goto yy39;
			} else {
				if (yych <= 'i') goto yy423;
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy332:
		YYDEBUG(332, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSE);
}
yy333:
		YYDEBUG(333, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy424;
		if (yych == 'y') goto yy424;
		goto yy40;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy426;
		if (yych == 'e') goto yy426;
		goto yy40;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy427;
		if (yych == 'o') goto yy427;
		goto yy40;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy428;
		if (yych == 'f') goto yy428;
		goto yy40;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy430;
		if (yych == 'w') goto yy430;
		goto yy40;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy431;
		if (yych == 'h') goto yy431;
		goto yy40;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 0x1F) {
			if (yych <= '\n') {
				if (yych <= 0x08) goto yy40;
				goto yy432;
			} else {
				if (yych == '\r') goto yy432;
				goto yy40;
			}
		} else {
			if (yych <= '#') {
				if (yych <= ' ') goto yy432;
				if (yych <= '"') goto yy40;
				goto yy433;
			} else {
				if (yych == '/') goto yy434;
				goto yy40;
			}
		}
yy340:
		YYDEBUG(340, *YYCURSOR);
		yyaccept = 30;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EVAL);
}
yy342:
		YYDEBUG(342, *YYCURSOR);
		yyaccept = 31;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXIT);
}
yy344:
		YYDEBUG(344, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy435;
		if (yych == 'n') goto yy435;
		goto yy40;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy436;
		if (yych == 'l') goto yy436;
		goto yy40;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy438;
		if (yych == 'a') goto yy438;
		goto yy40;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy439;
		if (yych == 't') goto yy439;
		goto yy40;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy440;
		if (yych == 'a') goto yy440;
		goto yy40;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yyaccept = 32;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GOTO);
}
yy351:
		YYDEBUG(351, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy441;
		if (yych == 'e') goto yy441;
		goto yy40;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy442;
		if (yych == 'u') goto yy442;
		goto yy40;
yy353:
		YYDEBUG(353, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych == 'A') goto yy443;
			if (yych <= 'D') goto yy40;
			goto yy444;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy40;
				goto yy443;
			} else {
				if (yych == 'e') goto yy444;
				goto yy40;
			}
		}
yy354:
		YYDEBUG(354, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy445;
		if (yych == 'r') goto yy445;
		goto yy40;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy446;
		if (yych == 't') goto yy446;
		goto yy40;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yyaccept = 33;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LIST);
}
yy358:
		YYDEBUG(358, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy448;
		if (yych == 'h') goto yy448;
		goto yy40;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy450;
		if (yych == 's') goto yy450;
		goto yy40;
yy360:
		YYDEBUG(360, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy451;
		if (yych == 't') goto yy451;
		goto yy40;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy453;
		if (yych == 'a') goto yy453;
		goto yy40;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy454;
		if (yych == 'e') goto yy454;
		goto yy40;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy455;
		if (yych == 'i') goto yy455;
		goto yy40;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy456;
		if (yych == 'o') goto yy456;
		goto yy40;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy457;
		if (yych == 'i') goto yy457;
		goto yy40;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy458;
		if (yych == 'r') goto yy458;
		goto yy40;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy459;
		if (yych == 'i') goto yy459;
		goto yy40;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy460;
		if (yych == 'c') goto yy460;
		goto yy40;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'W') goto yy461;
		if (yych == 'w') goto yy461;
		goto yy40;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy463;
		if (yych == 't') goto yy463;
		goto yy40;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy465;
		if (yych == 't') goto yy465;
		goto yy40;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy467;
		if (yych == 'e') goto yy467;
		goto yy40;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy469;
		if (yych == 'd') goto yy469;
		goto yy40;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy471;
		if (yych == 'a') goto yy471;
		goto yy40;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy472;
		if (yych == 'r') goto yy472;
		goto yy40;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy473;
		if (yych == 'l') goto yy473;
		goto yy40;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy474;
		if (yych == 'n') goto yy474;
		goto yy40;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy475;
		if (yych == 'l') goto yy475;
		goto yy40;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy476;
		if (yych == 'n') goto yy476;
		goto yy40;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy477;
		if (yych == 't') goto yy477;
		goto yy40;
yy381:
		YYDEBUG(381, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy478;
		if (yych == 'm') goto yy478;
		goto yy40;
yy382:
		YYDEBUG(382, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy479;
		if (yych == 'o') goto yy479;
		goto yy40;
yy383:
		YYDEBUG(383, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy480;
		if (yych == 'a') goto yy480;
		goto yy40;
yy384:
		YYDEBUG(384, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy70;
			goto yy187;
		} else {
			if (yych <= '\r') goto yy70;
			if (yych == '.') goto yy297;
			goto yy187;
		}
yy385:
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy385;
		}
		if (yych <= 0x00) goto yy72;
		if (yych <= '\r') goto yy481;
		goto yy482;
yy386:
		YYDEBUG(386, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy483;
		if (yych == 'y') goto yy483;
		goto yy72;
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy484;
		if (yych == 'r') goto yy484;
		goto yy72;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy487;
		if (yych == 'e') goto yy487;
		goto yy486;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy488;
		if (yych == 'l') goto yy488;
		goto yy72;
yy390:
		YYDEBUG(390, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy489;
		if (yych == 't') goto yy489;
		goto yy72;
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy392:
		YYDEBUG(392, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy391;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy391;
			if (yych != ')') goto yy72;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_INT_CAST);
}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy490;
		if (yych == 'g') goto yy490;
		goto yy72;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy491;
		if (yych == 'c') goto yy491;
		goto yy72;
yy395:
		YYDEBUG(395, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy395;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy395;
			if (yych == ')') goto yy492;
			goto yy72;
		}
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy493;
		if (yych == 'n') goto yy493;
		goto yy72;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy494;
		if (yych == 't') goto yy494;
		goto yy72;
yy398:
		YYDEBUG(398, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy398;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy398;
			if (yych == ')') goto yy495;
			goto yy72;
		}
yy399:
		YYDEBUG(399, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy400:
		YYDEBUG(400, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '"') goto yy496;
				goto yy72;
			} else {
				if (yych <= '9') goto yy399;
				if (yych <= '@') goto yy72;
				goto yy399;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy399;
				goto yy72;
			} else {
				if (yych <= 'z') goto yy399;
				if (yych <= 0x7F) goto yy72;
				goto yy399;
			}
		}
yy401:
		YYDEBUG(401, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy402:
		YYDEBUG(402, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy496;
				goto yy72;
			} else {
				if (yych <= '9') goto yy401;
				if (yych <= '@') goto yy72;
				goto yy401;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy401;
				goto yy72;
			} else {
				if (yych <= 'z') goto yy401;
				if (yych <= 0x7F) goto yy72;
				goto yy401;
			}
		}
yy403:
		YYDEBUG(403, *YYCURSOR);
		++YYCURSOR;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	unsigned char *saved_cursor;
	int bprefix = (yytext[0] != '<') ? 1 : 0, spacing = 0, indentation = 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));
	bool is_heredoc = 1;

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;
		is_heredoc = 0;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);
	heredoc_label->indentation_uses_spaces = 0;
	heredoc_label->indentation = 0;
	saved_cursor = YYCURSOR;

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
		if (*YYCURSOR == '\t') {
			spacing |= HEREDOC_USING_TABS;
		} else {
			spacing |= HEREDOC_USING_SPACES;
		}
		++YYCURSOR;
		++indentation;
	}

	if (YYCURSOR == YYLIMIT) {
		YYCURSOR = saved_cursor;
		RETURN_TOKEN(T_START_HEREDOC);
	}

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		if (!IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
			if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
				zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
				if (PARSER_MODE()) {
					RETURN_TOKEN(T_ERROR);
				}
			}

			YYCURSOR = saved_cursor;
			heredoc_label->indentation = indentation;

			BEGIN(ST_END_HEREDOC);
			RETURN_TOKEN(T_START_HEREDOC);
		}
	}

	YYCURSOR = saved_cursor;

	if (is_heredoc && !SCNG(heredoc_scan_ahead)) {
		zend_lex_state current_state;
		zend_string *saved_doc_comment = CG(doc_comment);
		int heredoc_nesting_level = 1;
		int first_token = 0;
		int error = 0;

		zend_save_lexical_state(&current_state);

		SCNG(heredoc_scan_ahead) = 1;
		SCNG(heredoc_indentation) = 0;
		SCNG(heredoc_indentation_uses_spaces) = 0;
		LANG_SCNG(on_event) = NULL;
		CG(doc_comment) = NULL;

		zend_ptr_stack_reverse_apply(&current_state.heredoc_label_stack, copy_heredoc_label_stack);

		zend_exception_save();
		while (heredoc_nesting_level) {
			zval zv;
			int retval;

			ZVAL_UNDEF(&zv);
			retval = lex_scan(&zv, NULL);
			zval_ptr_dtor_nogc(&zv);

			if (EG(exception)) {
				zend_clear_exception();
				break;
			}

			if (!first_token) {
				first_token = retval;
			}

			switch (retval) {
				case T_START_HEREDOC:
					++heredoc_nesting_level;
					break;
				case T_END_HEREDOC:
					--heredoc_nesting_level;
					break;
				case END:
					heredoc_nesting_level = 0;
			}
		}
		zend_exception_restore();

		if (
		    (first_token == T_VARIABLE
		     || first_token == T_DOLLAR_OPEN_CURLY_BRACES
		     || first_token == T_CURLY_OPEN
		    ) && SCNG(heredoc_indentation)) {
			zend_throw_exception_ex(zend_ce_parse_error, 0, "Invalid body indentation level (expecting an indentation level of at least %d)", SCNG(heredoc_indentation));
			error = 1;
		}

		heredoc_label->indentation = SCNG(heredoc_indentation);
		heredoc_label->indentation_uses_spaces = SCNG(heredoc_indentation_uses_spaces);

		zend_restore_lexical_state(&current_state);
		SCNG(heredoc_scan_ahead) = 0;
		CG(increment_lineno) = 0;
		CG(doc_comment) = saved_doc_comment;

		if (PARSER_MODE() && error) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	RETURN_TOKEN(T_START_HEREDOC);
}
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy403;
		goto yy404;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy497;
		if (yych == 'a') goto yy497;
		goto yy40;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yyaccept = 34;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy408:
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ARRAY);
}
yy409:
		YYDEBUG(409, *YYCURSOR);
		yyaccept = 35;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_BREAK);
}
yy411:
		YYDEBUG(411, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'B') goto yy498;
		if (yych == 'b') goto yy498;
		goto yy40;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yyaccept = 36;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CATCH);
}
yy414:
		YYDEBUG(414, *YYCURSOR);
		yyaccept = 37;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy415:
		YYDEBUG(415, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS);
}
yy416:
		YYDEBUG(416, *YYCURSOR);
		yyaccept = 38;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy417:
		YYDEBUG(417, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLONE);
}
yy418:
		YYDEBUG(418, *YYCURSOR);
		yyaccept = 39;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONST);
}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy499;
		if (yych == 'n') goto yy499;
		goto yy40;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy500;
		if (yych == 'r') goto yy500;
		goto yy40;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy501;
		if (yych == 'l') goto yy501;
		goto yy40;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy502;
		if (yych == 'f') goto yy502;
		goto yy40;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yyaccept = 40;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EMPTY);
}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy504;
		if (yych == 'c') goto yy504;
		goto yy40;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy505;
		if (yych == 'r') goto yy505;
		goto yy40;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yyaccept = 41;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy429:
		YYDEBUG(429, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDIF);
}
yy430:
		YYDEBUG(430, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy507;
		if (yych == 'i') goto yy507;
		goto yy40;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy508;
		if (yych == 'i') goto yy508;
		goto yy40;
yy432:
		YYDEBUG(432, *YYCURSOR);
		++YYCURSOR;
		YYFILL(10);
		yych = *YYCURSOR;
		if (yych <= 'E') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy72;
					if (yych <= '\n') goto yy432;
					goto yy72;
				} else {
					if (yych <= '\r') goto yy432;
					if (yych <= 0x1F) goto yy72;
					goto yy432;
				}
			} else {
				if (yych <= '.') {
					if (yych != '#') goto yy72;
				} else {
					if (yych <= '/') goto yy434;
					if (yych <= '@') goto yy72;
					if (yych <= 'D') goto yy509;
					goto yy511;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'Z') {
					if (yych == 'I') goto yy512;
					goto yy509;
				} else {
					if (yych == '_') goto yy509;
					goto yy72;
				}
			} else {
				if (yych <= 'h') {
					if (yych == 'e') goto yy511;
					goto yy509;
				} else {
					if (yych <= 'i') goto yy512;
					if (yych <= 'z') goto yy509;
					if (yych <= 0x7F) goto yy72;
					goto yy509;
				}
			}
		}
yy433:
		YYDEBUG(433, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy514;
			goto yy513;
		} else {
			if (yych <= '\r') goto yy514;
			if (yych == '[') goto yy72;
			goto yy513;
		}
yy434:
		YYDEBUG(434, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy515;
		if (yych == '/') goto yy513;
		goto yy72;
yy435:
		YYDEBUG(435, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy516;
		if (yych == 'd') goto yy516;
		goto yy40;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yyaccept = 42;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'K') {
				if (yych <= '/') goto yy437;
				if (yych <= '9') goto yy39;
				if (yych >= 'A') goto yy39;
			} else {
				if (yych <= 'L') goto yy517;
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= 'k') {
				if (yych == '_') goto yy39;
				if (yych >= 'a') goto yy39;
			} else {
				if (yych <= 'l') goto yy517;
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy437:
		YYDEBUG(437, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINAL);
}
yy438:
		YYDEBUG(438, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy518;
		if (yych == 'c') goto yy518;
		goto yy40;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy519;
		if (yych == 'i') goto yy519;
		goto yy40;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy520;
		if (yych == 'l') goto yy520;
		goto yy40;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy522;
		if (yych == 'm') goto yy522;
		goto yy40;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy523;
		if (yych == 'd') goto yy523;
		goto yy40;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy524;
		if (yych == 'n') goto yy524;
		goto yy40;
yy444:
		YYDEBUG(444, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy525;
		if (yych == 'a') goto yy525;
		goto yy40;
yy445:
		YYDEBUG(445, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy526;
		if (yych == 'f') goto yy526;
		goto yy40;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yyaccept = 43;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy447:
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ISSET);
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yyaccept = 44;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_MATCH);
}
yy450:
		YYDEBUG(450, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy527;
		if (yych == 'p') goto yy527;
		goto yy40;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yyaccept = 45;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRINT);
}
yy453:
		YYDEBUG(453, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy528;
		if (yych == 't') goto yy528;
		goto yy40;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy529;
		if (yych == 'c') goto yy529;
		goto yy40;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy530;
		if (yych == 'c') goto yy530;
		goto yy40;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy532;
		if (yych == 'n') goto yy532;
		goto yy40;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy533;
		if (yych == 'r') goto yy533;
		goto yy40;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy534;
		if (yych == 'n') goto yy534;
		goto yy40;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy536;
		if (yych == 'c') goto yy536;
		goto yy40;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy538;
		if (yych == 'h') goto yy538;
		goto yy40;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yyaccept = 46;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_THROW);
}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yyaccept = 47;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy464:
		YYDEBUG(464, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT);
}
yy465:
		YYDEBUG(465, *YYCURSOR);
		yyaccept = 48;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy466:
		YYDEBUG(466, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_UNSET);
}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yyaccept = 49;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy468:
		YYDEBUG(468, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_WHILE);
}
yy469:
		YYDEBUG(469, *YYCURSOR);
		yyaccept = 50;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych <= ' ') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy470;
				if (yych <= '\n') goto yy540;
			} else {
				if (yych <= '\r') goto yy540;
				if (yych >= ' ') goto yy540;
			}
		} else {
			if (yych <= '.') {
				if (yych == '#') goto yy541;
			} else {
				if (yych <= '/') goto yy542;
				if (yych == '\\') goto yy132;
			}
		}
yy470:
		YYDEBUG(470, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_YIELD);
}
yy471:
		YYDEBUG(471, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy543;
		if (yych == 's') goto yy543;
		goto yy40;
yy472:
		YYDEBUG(472, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy544;
		goto yy40;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy545;
		if (yych == 'e') goto yy545;
		goto yy40;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy546;
		if (yych == 'c') goto yy546;
		goto yy40;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy547;
		if (yych == 't') goto yy547;
		goto yy40;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy548;
		if (yych == 'e') goto yy548;
		goto yy40;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy549;
		if (yych == 'h') goto yy549;
		goto yy40;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy550;
		if (yych == 'e') goto yy550;
		goto yy40;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy551;
		if (yych == 'p') goto yy551;
		goto yy40;
yy480:
		YYDEBUG(480, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy552;
		if (yych == 'i') goto yy552;
		goto yy40;
yy481:
		YYDEBUG(481, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy300;
		}
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy190;
				goto yy481;
			} else {
				if (yych == '\r') goto yy481;
				if (yych <= 0x1F) goto yy190;
				goto yy481;
			}
		} else {
			if (yych <= '$') {
				if (yych <= '"') goto yy190;
				if (yych <= '#') goto yy553;
				goto yy554;
			} else {
				if (yych <= '-') goto yy190;
				if (yych <= '.') goto yy555;
				if (yych <= '/') goto yy556;
				goto yy190;
			}
		}
yy482:
		YYDEBUG(482, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy385;
			} else {
				if (yych <= '\n') goto yy481;
				if (yych <= '\f') goto yy385;
				goto yy481;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy385;
				goto yy482;
			} else {
				if (yych == '/') goto yy188;
				goto yy385;
			}
		}
yy483:
		YYDEBUG(483, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy483;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy483;
			if (yych == ')') goto yy557;
			goto yy72;
		}
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy558;
		if (yych == 'y') goto yy558;
		goto yy72;
yy485:
		YYDEBUG(485, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy486:
		YYDEBUG(486, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy485;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy485;
			if (yych != ')') goto yy72;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_BOOL_CAST);
}
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy559;
		if (yych == 'a') goto yy559;
		goto yy72;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy489;
		if (yych != 'e') goto yy72;
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy489;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy489;
			if (yych == ')') goto yy560;
			goto yy72;
		}
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy561;
		if (yych == 'e') goto yy561;
		goto yy72;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy562;
		if (yych == 't') goto yy562;
		goto yy72;
yy492:
		YYDEBUG(492, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (PARSER_MODE()) {
		zend_throw_exception(zend_ce_parse_error, "The (real) cast has been removed, use (float) instead", 0);
		RETURN_TOKEN(T_ERROR);
	}
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy558;
		if (yych == 'g') goto yy558;
		goto yy72;
yy494:
		YYDEBUG(494, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy494;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy494;
			if (yych == ')') goto yy563;
			goto yy72;
		}
yy495:
		YYDEBUG(495, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_VOID_CAST);
}
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy403;
		if (yych == '\r') goto yy405;
		goto yy72;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy564;
		if (yych == 'c') goto yy564;
		goto yy40;
yy498:
		YYDEBUG(498, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy565;
		if (yych == 'l') goto yy565;
		goto yy40;
yy499:
		YYDEBUG(499, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'U') goto yy566;
		if (yych == 'u') goto yy566;
		goto yy40;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy567;
		if (yych == 'e') goto yy567;
		goto yy40;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy569;
		if (yych == 't') goto yy569;
		goto yy40;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yyaccept = 51;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ELSEIF);
}
yy504:
		YYDEBUG(504, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy571;
		if (yych == 'l') goto yy571;
		goto yy40;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yyaccept = 52;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= 'D') {
				if (yych <= '/') goto yy506;
				if (yych <= '9') goto yy39;
				if (yych >= 'A') goto yy39;
			} else {
				if (yych <= 'E') goto yy572;
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= 'd') {
				if (yych == '_') goto yy39;
				if (yych >= 'a') goto yy39;
			} else {
				if (yych <= 'e') goto yy572;
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy506:
		YYDEBUG(506, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOR);
}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy573;
		if (yych == 't') goto yy573;
		goto yy40;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy574;
		if (yych == 'l') goto yy574;
		goto yy40;
yy509:
		YYDEBUG(509, *YYCURSOR);
		++YYCURSOR;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_IDENT(T_ENUM);
}
yy511:
		YYDEBUG(511, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'X') goto yy575;
		if (yych == 'x') goto yy575;
		goto yy510;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yyaccept = 53;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy576;
		if (yych == 'm') goto yy576;
		goto yy510;
yy513:
		YYDEBUG(513, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '\t') goto yy513;
			goto yy432;
		} else {
			if (yych == '\r') goto yy432;
			goto yy513;
		}
yy514:
		YYDEBUG(514, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x1F) {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy72;
					if (yych <= 0x08) goto yy513;
					goto yy514;
				} else {
					if (yych <= '\n') goto yy432;
					if (yych == '\r') goto yy432;
					goto yy513;
				}
			} else {
				if (yych <= '#') {
					if (yych <= ' ') goto yy514;
					if (yych <= '"') goto yy513;
					goto yy577;
				} else {
					if (yych == '/') goto yy578;
					if (yych <= '@') goto yy513;
					goto yy579;
				}
			}
		} else {
			if (yych <= '`') {
				if (yych <= 'I') {
					if (yych <= 'E') goto yy580;
					if (yych <= 'H') goto yy579;
					goto yy581;
				} else {
					if (yych <= 'Z') goto yy579;
					if (yych == '_') goto yy579;
					goto yy513;
				}
			} else {
				if (yych <= 'h') {
					if (yych == 'e') goto yy580;
					goto yy579;
				} else {
					if (yych <= 'i') goto yy581;
					if (yych <= 'z') goto yy579;
					if (yych <= 0x7F) goto yy513;
					goto yy579;
				}
			}
		}
yy515:
		YYDEBUG(515, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy72;
		if (yych == '*') goto yy582;
		goto yy515;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy583;
		if (yych == 's') goto yy583;
		goto yy40;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy585;
		if (yych == 'y') goto yy585;
		goto yy40;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy587;
		if (yych == 'h') goto yy587;
		goto yy40;
yy519:
		YYDEBUG(519, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy589;
		if (yych == 'o') goto yy589;
		goto yy40;
yy520:
		YYDEBUG(520, *YYCURSOR);
		yyaccept = 54;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_GLOBAL);
}
yy522:
		YYDEBUG(522, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy590;
		if (yych == 'e') goto yy590;
		goto yy40;
yy523:
		YYDEBUG(523, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy591;
		if (yych == 'e') goto yy591;
		goto yy40;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy593;
		if (yych == 'c') goto yy593;
		goto yy40;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy594;
		if (yych == 'd') goto yy594;
		goto yy40;
yy526:
		YYDEBUG(526, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy595;
		if (yych == 'a') goto yy595;
		goto yy40;
yy527:
		YYDEBUG(527, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy596;
		if (yych == 'a') goto yy596;
		goto yy40;
yy528:
		YYDEBUG(528, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy597;
		if (yych == 'e') goto yy597;
		goto yy40;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy599;
		if (yych == 't') goto yy599;
		goto yy40;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yyaccept = 55;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '(') goto yy600;
		if (yych == '\\') goto yy132;
yy531:
		YYDEBUG(531, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC);
}
yy532:
		YYDEBUG(532, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy601;
		if (yych == 'l') goto yy601;
		goto yy40;
yy533:
		YYDEBUG(533, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy602;
		if (yych == 'e') goto yy602;
		goto yy40;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yyaccept = 56;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_RETURN);
}
yy536:
		YYDEBUG(536, *YYCURSOR);
		yyaccept = 57;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_STATIC);
}
yy538:
		YYDEBUG(538, *YYCURSOR);
		yyaccept = 58;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_SWITCH);
}
yy540:
		YYDEBUG(540, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy72;
				if (yych <= '\n') goto yy540;
				goto yy72;
			} else {
				if (yych <= '\r') goto yy540;
				if (yych == ' ') goto yy540;
				goto yy72;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '#') goto yy541;
				if (yych == '/') goto yy542;
				goto yy72;
			} else {
				if (yych <= 'F') goto yy604;
				if (yych == 'f') goto yy604;
				goto yy72;
			}
		}
yy541:
		YYDEBUG(541, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy606;
			goto yy605;
		} else {
			if (yych <= '\r') goto yy606;
			if (yych == '[') goto yy72;
			goto yy605;
		}
yy542:
		YYDEBUG(542, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych == '*') goto yy607;
		if (yych == '/') goto yy605;
		goto yy72;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy608;
		if (yych == 's') goto yy608;
		goto yy40;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy609;
		goto yy40;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy611;
		goto yy40;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy612;
		if (yych == 't') goto yy612;
		goto yy40;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy613;
		goto yy40;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy614;
		goto yy40;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy615;
		if (yych == 'o') goto yy615;
		goto yy40;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy616;
		if (yych == 's') goto yy616;
		goto yy40;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy617;
		if (yych == 'e') goto yy617;
		goto yy40;
yy552:
		YYDEBUG(552, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy618;
		if (yych == 't') goto yy618;
		goto yy40;
yy553:
		YYDEBUG(553, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy385;
			} else {
				if (yych <= '\n') goto yy619;
				if (yych <= '\f') goto yy385;
				goto yy619;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy385;
				goto yy482;
			} else {
				if (yych == '[') goto yy190;
				goto yy385;
			}
		}
yy554:
		YYDEBUG(554, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 4) {
			goto yy190;
		}
		if (yych <= 0x00) goto yy75;
		goto yy300;
yy555:
		YYDEBUG(555, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy300;
		}
		if (yych <= 0x00) goto yy72;
		if (yych == '.') goto yy620;
		goto yy190;
yy556:
		YYDEBUG(556, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy190;
			goto yy621;
		} else {
			if (yych == '/') goto yy385;
			goto yy190;
		}
yy557:
		YYDEBUG(557, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_ARRAY_CAST);
}
yy558:
		YYDEBUG(558, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy558;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy558;
			if (yych == ')') goto yy622;
			goto yy72;
		}
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy485;
		if (yych == 'n') goto yy485;
		goto yy72;
yy560:
		YYDEBUG(560, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_DOUBLE_CAST);
}
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy391;
		if (yych == 'r') goto yy391;
		goto yy72;
yy562:
		YYDEBUG(562, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy562;
			goto yy72;
		} else {
			if (yych <= ' ') goto yy562;
			if (yych == ')') goto yy623;
			goto yy72;
		}
yy563:
		YYDEBUG(563, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_UNSET_CAST);
}
yy564:
		YYDEBUG(564, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy624;
		if (yych == 't') goto yy624;
		goto yy40;
yy565:
		YYDEBUG(565, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy626;
		if (yych == 'e') goto yy626;
		goto yy40;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy628;
		if (yych == 'e') goto yy628;
		goto yy40;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yyaccept = 59;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DECLARE);
}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yyaccept = 60;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DEFAULT);
}
yy571:
		YYDEBUG(571, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy630;
		if (yych == 'a') goto yy630;
		goto yy40;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy631;
		if (yych == 'a') goto yy631;
		goto yy40;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy632;
		if (yych == 'c') goto yy632;
		goto yy40;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy633;
		if (yych == 'e') goto yy633;
		goto yy40;
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy635;
		if (yych == 't') goto yy635;
		goto yy72;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy636;
		if (yych == 'p') goto yy636;
		goto yy72;
yy577:
		YYDEBUG(577, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '\t') goto yy513;
			goto yy514;
		} else {
			if (yych == '\r') goto yy514;
			goto yy513;
		}
yy578:
		YYDEBUG(578, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy432;
			goto yy513;
		} else {
			if (yych <= '\r') goto yy432;
			if (yych == '*') goto yy637;
			goto yy513;
		}
yy579:
		YYDEBUG(579, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy510;
			if (yych <= '\t') goto yy513;
			goto yy432;
		} else {
			if (yych == '\r') goto yy432;
			goto yy513;
		}
yy580:
		YYDEBUG(580, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy510;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'X') {
				if (yych <= 'W') goto yy513;
				goto yy638;
			} else {
				if (yych == 'x') goto yy638;
				goto yy513;
			}
		}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy510;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy513;
				goto yy639;
			} else {
				if (yych == 'm') goto yy639;
				goto yy513;
			}
		}
yy582:
		YYDEBUG(582, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy515;
			goto yy582;
		} else {
			if (yych == '/') goto yy432;
			goto yy515;
		}
yy583:
		YYDEBUG(583, *YYCURSOR);
		yyaccept = 61;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy584:
		YYDEBUG(584, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_EXTENDS);
}
yy585:
		YYDEBUG(585, *YYCURSOR);
		yyaccept = 62;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy586:
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FINALLY);
}
yy587:
		YYDEBUG(587, *YYCURSOR);
		yyaccept = 63;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FOREACH);
}
yy589:
		YYDEBUG(589, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy640;
		if (yych == 'n') goto yy640;
		goto yy40;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy642;
		if (yych == 'n') goto yy642;
		goto yy40;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yyaccept = 64;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy592;
				if (yych <= '9') goto yy39;
			} else {
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy643;
			} else {
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy592:
		YYDEBUG(592, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE);
}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy644;
		if (yych == 'e') goto yy644;
		goto yy40;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy645;
		if (yych == 'o') goto yy645;
		goto yy40;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy646;
		if (yych == 'c') goto yy646;
		goto yy40;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy647;
		if (yych == 'c') goto yy647;
		goto yy40;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yyaccept = 65;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '(') goto yy648;
		if (yych == '\\') goto yy132;
yy598:
		YYDEBUG(598, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE);
}
yy599:
		YYDEBUG(599, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy649;
		if (yych == 'e') goto yy649;
		goto yy40;
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy650;
		if (yych == 's') goto yy650;
		goto yy72;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy651;
		if (yych == 'y') goto yy651;
		goto yy40;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yyaccept = 66;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy603;
				if (yych <= '9') goto yy39;
			} else {
				if (yych <= 'Z') goto yy39;
				if (yych >= '\\') goto yy132;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy653;
			} else {
				if (yych <= 'z') goto yy39;
				if (yych >= 0x80) goto yy39;
			}
		}
yy603:
		YYDEBUG(603, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE);
}
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy654;
		if (yych == 'r') goto yy654;
		goto yy72;
yy605:
		YYDEBUG(605, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '\t') goto yy605;
			goto yy540;
		} else {
			if (yych == '\r') goto yy540;
			goto yy605;
		}
yy606:
		YYDEBUG(606, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy605;
				if (yych <= '\t') goto yy606;
				goto yy540;
			} else {
				if (yych == '\r') goto yy540;
				if (yych <= 0x1F) goto yy605;
				goto yy606;
			}
		} else {
			if (yych <= '/') {
				if (yych == '#') goto yy655;
				if (yych <= '.') goto yy605;
				goto yy656;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy605;
					goto yy657;
				} else {
					if (yych == 'f') goto yy657;
					goto yy605;
				}
			}
		}
yy607:
		YYDEBUG(607, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy72;
		if (yych == '*') goto yy658;
		goto yy607;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy659;
		goto yy40;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yyaccept = 67;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_DIR);
}
yy611:
		YYDEBUG(611, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy660;
		goto yy40;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy662;
		if (yych == 'i') goto yy662;
		goto yy40;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy663;
		if (yych == 'c') goto yy663;
		goto yy40;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy664;
		goto yy40;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy666;
		if (yych == 'd') goto yy666;
		goto yy40;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy667;
		if (yych == 'p') goto yy667;
		goto yy40;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy668;
		if (yych == 'r') goto yy668;
		goto yy40;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy669;
		goto yy40;
yy619:
		YYDEBUG(619, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ' ') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy385;
				if (yych <= '\t') goto yy619;
				goto yy481;
			} else {
				if (yych == '\r') goto yy481;
				if (yych <= 0x1F) goto yy385;
				goto yy619;
			}
		} else {
			if (yych <= ')') {
				if (yych <= '"') goto yy385;
				if (yych <= '#') goto yy670;
				if (yych <= '$') goto yy671;
				goto yy385;
			} else {
				if (yych <= '-') {
					if (yych <= '*') goto yy482;
					goto yy385;
				} else {
					if (yych <= '.') goto yy672;
					if (yych <= '/') goto yy673;
					goto yy385;
				}
			}
		}
yy620:
		YYDEBUG(620, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy300;
		}
		if (yych <= 0x00) goto yy72;
		if (yych == '.') goto yy554;
		goto yy190;
yy621:
		YYDEBUG(621, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy300;
		}
		if (yych <= 0x00) goto yy72;
		if (yych == '/') goto yy481;
		goto yy190;
yy622:
		YYDEBUG(622, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_STRING_CAST);
}
yy623:
		YYDEBUG(623, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_CAST);
}
yy624:
		YYDEBUG(624, *YYCURSOR);
		yyaccept = 68;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ABSTRACT);
}
yy626:
		YYDEBUG(626, *YYCURSOR);
		yyaccept = 69;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CALLABLE);
}
yy628:
		YYDEBUG(628, *YYCURSOR);
		yyaccept = 70;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy629:
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CONTINUE);
}
yy630:
		YYDEBUG(630, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy674;
		if (yych == 'r') goto yy674;
		goto yy40;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy675;
		if (yych == 'c') goto yy675;
		goto yy40;
yy632:
		YYDEBUG(632, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy676;
		if (yych == 'h') goto yy676;
		goto yy40;
yy633:
		YYDEBUG(633, *YYCURSOR);
		yyaccept = 71;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy634:
		YYDEBUG(634, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDWHILE);
}
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy678;
		if (yych == 'e') goto yy678;
		goto yy72;
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy679;
		if (yych == 'l') goto yy679;
		goto yy72;
yy637:
		YYDEBUG(637, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy680;
			goto yy637;
		} else {
			if (yych <= '\r') goto yy680;
			if (yych == '*') goto yy681;
			goto yy637;
		}
yy638:
		YYDEBUG(638, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy513;
				goto yy682;
			} else {
				if (yych == 't') goto yy682;
				goto yy513;
			}
		}
yy639:
		YYDEBUG(639, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'P') {
				if (yych <= 'O') goto yy513;
				goto yy683;
			} else {
				if (yych == 'p') goto yy683;
				goto yy513;
			}
		}
yy640:
		YYDEBUG(640, *YYCURSOR);
		yyaccept = 72;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy641:
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNCTION);
}
yy642:
		YYDEBUG(642, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy684;
		if (yych == 't') goto yy684;
		goto yy40;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy685;
		if (yych == 'o') goto yy685;
		goto yy40;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy686;
		if (yych == 'o') goto yy686;
		goto yy40;
yy645:
		YYDEBUG(645, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy687;
		if (yych == 'f') goto yy687;
		goto yy40;
yy646:
		YYDEBUG(646, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy689;
		if (yych == 'e') goto yy689;
		goto yy40;
yy647:
		YYDEBUG(647, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy691;
		if (yych == 'e') goto yy691;
		goto yy40;
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy693;
		if (yych == 's') goto yy693;
		goto yy72;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'D') goto yy694;
		if (yych == 'd') goto yy694;
		goto yy40;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy696;
		if (yych == 'e') goto yy696;
		goto yy72;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yyaccept = 73;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_READONLY);
}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy697;
		if (yych == 'o') goto yy697;
		goto yy40;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy698;
		if (yych == 'o') goto yy698;
		goto yy72;
yy655:
		YYDEBUG(655, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy72;
			if (yych <= '\t') goto yy605;
			goto yy606;
		} else {
			if (yych == '\r') goto yy606;
			goto yy605;
		}
yy656:
		YYDEBUG(656, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy540;
			goto yy605;
		} else {
			if (yych <= '\r') goto yy540;
			if (yych == '*') goto yy699;
			goto yy605;
		}
yy657:
		YYDEBUG(657, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy605;
			} else {
				if (yych <= '\n') goto yy540;
				if (yych <= '\f') goto yy605;
				goto yy540;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= 'Q') goto yy605;
				goto yy700;
			} else {
				if (yych == 'r') goto yy700;
				goto yy605;
			}
		}
yy658:
		YYDEBUG(658, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy607;
			goto yy658;
		} else {
			if (yych == '/') goto yy540;
			goto yy607;
		}
yy659:
		YYDEBUG(659, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy701;
		goto yy40;
yy660:
		YYDEBUG(660, *YYCURSOR);
		yyaccept = 74;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy661:
		YYDEBUG(661, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FILE);
}
yy662:
		YYDEBUG(662, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy703;
		if (yych == 'o') goto yy703;
		goto yy40;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'O') goto yy704;
		if (yych == 'o') goto yy704;
		goto yy40;
yy664:
		YYDEBUG(664, *YYCURSOR);
		yyaccept = 75;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy665:
		YYDEBUG(665, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_LINE);
}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy705;
		goto yy40;
yy667:
		YYDEBUG(667, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'A') goto yy706;
		if (yych == 'a') goto yy706;
		goto yy40;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'T') goto yy707;
		if (yych == 't') goto yy707;
		goto yy40;
yy669:
		YYDEBUG(669, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy708;
		goto yy40;
yy670:
		YYDEBUG(670, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy385;
		}
		if (yych <= 0x00) goto yy72;
		if (yych <= '\r') goto yy619;
		goto yy482;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yyaccept = 26;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy385;
		}
		if (yych <= 0x00) goto yy75;
		if (yych <= '\r') goto yy481;
		goto yy482;
yy672:
		YYDEBUG(672, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy385;
			} else {
				if (yych <= '\n') goto yy481;
				if (yych <= '\f') goto yy385;
				goto yy481;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy385;
				goto yy482;
			} else {
				if (yych == '.') goto yy710;
				goto yy385;
			}
		}
yy673:
		YYDEBUG(673, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy385;
		}
		if (yych <= 0x00) goto yy72;
		if (yych <= '\r') goto yy481;
		goto yy711;
yy674:
		YYDEBUG(674, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy712;
		if (yych == 'e') goto yy712;
		goto yy40;
yy675:
		YYDEBUG(675, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'H') goto yy714;
		if (yych == 'h') goto yy714;
		goto yy40;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yyaccept = 76;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy677:
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDSWITCH);
}
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy716;
		if (yych == 'n') goto yy716;
		goto yy72;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy717;
		if (yych == 'e') goto yy717;
		goto yy72;
yy680:
		YYDEBUG(680, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= ' ') {
				if (yych <= '\n') {
					if (yych <= 0x00) goto yy72;
					if (yych <= 0x08) goto yy515;
					goto yy680;
				} else {
					if (yych == '\r') goto yy680;
					if (yych <= 0x1F) goto yy515;
					goto yy680;
				}
			} else {
				if (yych <= ')') {
					if (yych == '#') goto yy718;
					goto yy515;
				} else {
					if (yych <= '*') goto yy582;
					if (yych == '/') goto yy719;
					goto yy515;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'H') {
					if (yych == 'E') goto yy721;
					goto yy720;
				} else {
					if (yych <= 'I') goto yy722;
					if (yych <= 'Z') goto yy720;
					if (yych <= '^') goto yy515;
					goto yy720;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= '`') goto yy515;
					if (yych == 'e') goto yy721;
					goto yy720;
				} else {
					if (yych <= 'i') goto yy722;
					if (yych <= 'z') goto yy720;
					if (yych <= 0x7F) goto yy515;
					goto yy720;
				}
			}
		}
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy637;
			} else {
				if (yych <= '\n') goto yy680;
				if (yych <= '\f') goto yy637;
				goto yy680;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy637;
				goto yy681;
			} else {
				if (yych == '/') goto yy514;
				goto yy637;
			}
		}
yy682:
		YYDEBUG(682, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy513;
				goto yy723;
			} else {
				if (yych == 'e') goto yy723;
				goto yy513;
			}
		}
yy683:
		YYDEBUG(683, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy513;
				goto yy724;
			} else {
				if (yych == 'l') goto yy724;
				goto yy513;
			}
		}
yy684:
		YYDEBUG(684, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'S') goto yy725;
		if (yych == 's') goto yy725;
		goto yy40;
yy685:
		YYDEBUG(685, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy727;
		if (yych == 'n') goto yy727;
		goto yy40;
yy686:
		YYDEBUG(686, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'F') goto yy728;
		if (yych == 'f') goto yy728;
		goto yy40;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yyaccept = 77;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
    RETURN_TOKEN_WITH_IDENT(T_INSTEADOF);
}
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyaccept = 78;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INTERFACE);
}
yy691:
		YYDEBUG(691, *YYCURSOR);
		yyaccept = 79;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy730;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NAMESPACE);
}
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy731;
		if (yych == 'e') goto yy731;
		goto yy72;
yy694:
		YYDEBUG(694, *YYCURSOR);
		yyaccept = 80;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '(') goto yy732;
		if (yych == '\\') goto yy132;
yy695:
		YYDEBUG(695, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED);
}
yy696:
		YYDEBUG(696, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy733;
		if (yych == 't') goto yy733;
		goto yy72;
yy697:
		YYDEBUG(697, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy734;
		if (yych == 'n') goto yy734;
		goto yy40;
yy698:
		YYDEBUG(698, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy735;
		if (yych == 'm') goto yy735;
		goto yy72;
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy736;
			goto yy699;
		} else {
			if (yych <= '\r') goto yy736;
			if (yych == '*') goto yy737;
			goto yy699;
		}
yy700:
		YYDEBUG(700, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy605;
			} else {
				if (yych <= '\n') goto yy540;
				if (yych <= '\f') goto yy605;
				goto yy540;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= 'N') goto yy605;
				goto yy738;
			} else {
				if (yych == 'o') goto yy738;
				goto yy605;
			}
		}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yyaccept = 81;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_CLASS_C);
}
yy703:
		YYDEBUG(703, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'N') goto yy739;
		if (yych == 'n') goto yy739;
		goto yy40;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'M') goto yy740;
		if (yych == 'm') goto yy740;
		goto yy40;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy741;
		goto yy40;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy743;
		if (yych == 'c') goto yy743;
		goto yy40;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'Y') goto yy744;
		if (yych == 'y') goto yy744;
		goto yy40;
yy708:
		YYDEBUG(708, *YYCURSOR);
		yyaccept = 82;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy709:
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_TRAIT_C);
}
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy385;
			} else {
				if (yych <= '\n') goto yy481;
				if (yych <= '\f') goto yy385;
				goto yy481;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy385;
				goto yy482;
			} else {
				if (yych == '.') goto yy671;
				goto yy385;
			}
		}
yy711:
		YYDEBUG(711, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy385;
			} else {
				if (yych <= '\n') goto yy481;
				if (yych <= '\f') goto yy385;
				goto yy481;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy385;
				goto yy482;
			} else {
				if (yych == '/') goto yy619;
				goto yy385;
			}
		}
yy712:
		YYDEBUG(712, *YYCURSOR);
		yyaccept = 83;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDDECLARE);
}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yyaccept = 84;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy715:
		YYDEBUG(715, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_ENDFOREACH);
}
yy716:
		YYDEBUG(716, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy745;
		if (yych == 'd') goto yy745;
		goto yy72;
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy746;
		if (yych == 'm') goto yy746;
		goto yy72;
yy718:
		YYDEBUG(718, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy637;
			} else {
				if (yych <= '\n') goto yy747;
				if (yych <= '\f') goto yy637;
				goto yy747;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy637;
				goto yy681;
			} else {
				if (yych == '[') goto yy515;
				goto yy637;
			}
		}
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy515;
			goto yy748;
		} else {
			if (yych == '/') goto yy637;
			goto yy515;
		}
yy720:
		YYDEBUG(720, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy510;
		if (yych == '*') goto yy582;
		goto yy515;
yy721:
		YYDEBUG(721, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'W') {
			if (yych <= 0x00) goto yy510;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'X') goto yy749;
			if (yych == 'x') goto yy749;
			goto yy515;
		}
yy722:
		YYDEBUG(722, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy510;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'M') goto yy750;
			if (yych == 'm') goto yy750;
			goto yy515;
		}
yy723:
		YYDEBUG(723, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'M') goto yy513;
				goto yy751;
			} else {
				if (yych == 'n') goto yy751;
				goto yy513;
			}
		}
yy724:
		YYDEBUG(724, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy513;
				goto yy752;
			} else {
				if (yych == 'e') goto yy752;
				goto yy513;
			}
		}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yyaccept = 85;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy726:
		YYDEBUG(726, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_IMPLEMENTS);
}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy753;
		if (yych == 'c') goto yy753;
		goto yy40;
yy728:
		YYDEBUG(728, *YYCURSOR);
		yyaccept = 86;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy729:
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INSTANCEOF);
}
yy730:
		YYDEBUG(730, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy72;
			if (yych <= 'Z') goto yy754;
			if (yych <= '^') goto yy72;
			goto yy754;
		} else {
			if (yych <= '`') goto yy72;
			if (yych <= 'z') goto yy754;
			if (yych <= 0x7F) goto yy72;
			goto yy754;
		}
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy756;
		if (yych == 't') goto yy756;
		goto yy72;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy757;
		if (yych == 's') goto yy757;
		goto yy72;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ')') goto yy758;
		goto yy72;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'C') goto yy759;
		if (yych == 'c') goto yy759;
		goto yy40;
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych <= '/') goto yy760;
				goto yy72;
			} else {
				if (yych <= '@') goto yy760;
				if (yych <= 'Z') goto yy72;
				goto yy760;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy72;
				goto yy760;
			} else {
				if (yych <= 'z') goto yy72;
				if (yych <= 0x7F) goto yy760;
				goto yy72;
			}
		}
yy736:
		YYDEBUG(736, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy607;
				if (yych <= '\n') goto yy736;
				goto yy607;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy736;
					goto yy607;
				} else {
					if (yych <= ' ') goto yy736;
					if (yych <= '"') goto yy607;
					goto yy762;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych == '*') goto yy658;
				if (yych <= '.') goto yy607;
				goto yy763;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy607;
					goto yy764;
				} else {
					if (yych == 'f') goto yy764;
					goto yy607;
				}
			}
		}
yy737:
		YYDEBUG(737, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy699;
			} else {
				if (yych <= '\n') goto yy736;
				if (yych <= '\f') goto yy699;
				goto yy736;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy699;
				goto yy737;
			} else {
				if (yych == '/') goto yy606;
				goto yy699;
			}
		}
yy738:
		YYDEBUG(738, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy605;
			} else {
				if (yych <= '\n') goto yy540;
				if (yych <= '\f') goto yy605;
				goto yy540;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy605;
				goto yy765;
			} else {
				if (yych == 'm') goto yy765;
				goto yy605;
			}
		}
yy739:
		YYDEBUG(739, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy766;
		goto yy40;
yy740:
		YYDEBUG(740, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'P') goto yy767;
		if (yych == 'p') goto yy767;
		goto yy40;
yy741:
		YYDEBUG(741, *YYCURSOR);
		yyaccept = 87;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy742:
		YYDEBUG(742, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_METHOD_C);
}
yy743:
		YYDEBUG(743, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy768;
		if (yych == 'e') goto yy768;
		goto yy40;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy769;
		goto yy40;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy770;
		if (yych == 's') goto yy770;
		goto yy72;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy772;
		if (yych == 'e') goto yy772;
		goto yy72;
yy747:
		YYDEBUG(747, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= 0x1F) {
				if (yych <= '\t') {
					if (yych <= 0x00) goto yy72;
					if (yych <= 0x08) goto yy637;
					goto yy747;
				} else {
					if (yych <= '\n') goto yy680;
					if (yych == '\r') goto yy680;
					goto yy637;
				}
			} else {
				if (yych <= ')') {
					if (yych <= ' ') goto yy747;
					if (yych == '#') goto yy773;
					goto yy637;
				} else {
					if (yych <= '*') goto yy681;
					if (yych == '/') goto yy774;
					goto yy637;
				}
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'H') {
					if (yych == 'E') goto yy776;
					goto yy775;
				} else {
					if (yych <= 'I') goto yy777;
					if (yych <= 'Z') goto yy775;
					if (yych <= '^') goto yy637;
					goto yy775;
				}
			} else {
				if (yych <= 'h') {
					if (yych <= '`') goto yy637;
					if (yych == 'e') goto yy776;
					goto yy775;
				} else {
					if (yych <= 'i') goto yy777;
					if (yych <= 'z') goto yy775;
					if (yych <= 0x7F) goto yy637;
					goto yy775;
				}
			}
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy515;
			goto yy582;
		} else {
			if (yych == '/') goto yy680;
			goto yy515;
		}
yy749:
		YYDEBUG(749, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'T') goto yy778;
			if (yych == 't') goto yy778;
			goto yy515;
		}
yy750:
		YYDEBUG(750, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'P') goto yy779;
			if (yych == 'p') goto yy779;
			goto yy515;
		}
yy751:
		YYDEBUG(751, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= 'C') goto yy513;
				goto yy780;
			} else {
				if (yych == 'd') goto yy780;
				goto yy513;
			}
		}
yy752:
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= 'L') goto yy513;
				goto yy781;
			} else {
				if (yych == 'm') goto yy781;
				goto yy513;
			}
		}
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy782;
		if (yych == 'e') goto yy782;
		goto yy40;
yy754:
		YYDEBUG(754, *YYCURSOR);
		yyaccept = 88;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\\') {
			if (yych <= '@') {
				if (yych <= '/') goto yy755;
				if (yych <= '9') goto yy754;
			} else {
				if (yych <= 'Z') goto yy754;
				if (yych >= '\\') goto yy730;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy754;
			} else {
				if (yych <= 'z') goto yy754;
				if (yych >= 0x80) goto yy754;
			}
		}
yy755:
		YYDEBUG(755, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_NAME_RELATIVE, sizeof("namespace\\") - 1);
}
yy756:
		YYDEBUG(756, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ')') goto yy784;
		goto yy72;
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy785;
		if (yych == 'e') goto yy785;
		goto yy72;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PUBLIC_SET);
}
yy759:
		YYDEBUG(759, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy786;
		if (yych == 'e') goto yy786;
		goto yy40;
yy760:
		YYDEBUG(760, *YYCURSOR);
		++YYCURSOR;
yy761:
		YYDEBUG(761, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_IDENT(T_YIELD_FROM);
}
yy762:
		YYDEBUG(762, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy699;
			} else {
				if (yych <= '\n') goto yy788;
				if (yych <= '\f') goto yy699;
				goto yy788;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy699;
				goto yy737;
			} else {
				if (yych == '[') goto yy607;
				goto yy699;
			}
		}
yy763:
		YYDEBUG(763, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy607;
			goto yy789;
		} else {
			if (yych == '/') goto yy699;
			goto yy607;
		}
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'Q') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy658;
			goto yy607;
		} else {
			if (yych <= 'R') goto yy790;
			if (yych == 'r') goto yy790;
			goto yy607;
		}
yy765:
		YYDEBUG(765, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '9') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy760;
				if (yych <= '\t') goto yy791;
				goto yy792;
			} else {
				if (yych == '\r') goto yy792;
				if (yych <= '/') goto yy791;
				goto yy605;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy791;
				if (yych <= 'Z') goto yy605;
				if (yych <= '^') goto yy791;
				goto yy605;
			} else {
				if (yych <= '`') goto yy791;
				if (yych <= 'z') goto yy605;
				if (yych <= 0x7F) goto yy791;
				goto yy605;
			}
		}
yy766:
		YYDEBUG(766, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy793;
		goto yy40;
yy767:
		YYDEBUG(767, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'I') goto yy795;
		if (yych == 'i') goto yy795;
		goto yy40;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy796;
		goto yy40;
yy769:
		YYDEBUG(769, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy797;
		goto yy40;
yy770:
		YYDEBUG(770, *YYCURSOR);
		++YYCURSOR;
yy771:
		YYDEBUG(771, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(4);
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy772:
		YYDEBUG(772, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy799;
		if (yych == 'n') goto yy799;
		goto yy72;
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy747;
			goto yy637;
		} else {
			if (yych <= '\r') goto yy747;
			if (yych == '*') goto yy681;
			goto yy637;
		}
yy774:
		YYDEBUG(774, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy680;
			goto yy637;
		} else {
			if (yych <= '\r') goto yy680;
			if (yych == '*') goto yy800;
			goto yy637;
		}
yy775:
		YYDEBUG(775, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy510;
			if (yych == '\n') goto yy680;
			goto yy637;
		} else {
			if (yych <= '\r') goto yy680;
			if (yych == '*') goto yy681;
			goto yy637;
		}
yy776:
		YYDEBUG(776, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy510;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'X') {
				if (yych <= '*') goto yy681;
				if (yych <= 'W') goto yy637;
				goto yy801;
			} else {
				if (yych == 'x') goto yy801;
				goto yy637;
			}
		}
yy777:
		YYDEBUG(777, *YYCURSOR);
		yyaccept = 53;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy510;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy681;
				if (yych <= 'L') goto yy637;
				goto yy802;
			} else {
				if (yych == 'm') goto yy802;
				goto yy637;
			}
		}
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'E') goto yy803;
			if (yych == 'e') goto yy803;
			goto yy515;
		}
yy779:
		YYDEBUG(779, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'K') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'L') goto yy804;
			if (yych == 'l') goto yy804;
			goto yy515;
		}
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'S') {
				if (yych <= 'R') goto yy513;
				goto yy805;
			} else {
				if (yych == 's') goto yy805;
				goto yy513;
			}
		}
yy781:
		YYDEBUG(781, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy513;
				goto yy806;
			} else {
				if (yych == 'e') goto yy806;
				goto yy513;
			}
		}
yy782:
		YYDEBUG(782, *YYCURSOR);
		yyaccept = 89;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_INCLUDE_ONCE);
}
yy784:
		YYDEBUG(784, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PRIVATE_SET);
}
yy785:
		YYDEBUG(785, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy807;
		if (yych == 't') goto yy807;
		goto yy72;
yy786:
		YYDEBUG(786, *YYCURSOR);
		yyaccept = 90;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy787:
		YYDEBUG(787, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_REQUIRE_ONCE);
}
yy788:
		YYDEBUG(788, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= 0x08) goto yy699;
				if (yych <= '\t') goto yy788;
				goto yy736;
			} else {
				if (yych <= '\r') {
					if (yych <= '\f') goto yy699;
					goto yy736;
				} else {
					if (yych == ' ') goto yy788;
					goto yy699;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych <= ')') {
					if (yych <= '#') goto yy808;
					goto yy699;
				} else {
					if (yych <= '*') goto yy737;
					if (yych <= '.') goto yy699;
					goto yy809;
				}
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy699;
					goto yy810;
				} else {
					if (yych == 'f') goto yy810;
					goto yy699;
				}
			}
		}
yy789:
		YYDEBUG(789, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy72;
			if (yych <= ')') goto yy607;
			goto yy658;
		} else {
			if (yych == '/') goto yy736;
			goto yy607;
		}
yy790:
		YYDEBUG(790, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'N') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy658;
			goto yy607;
		} else {
			if (yych <= 'O') goto yy811;
			if (yych == 'o') goto yy811;
			goto yy607;
		}
yy791:
		YYDEBUG(791, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy761;
			if (yych <= '\t') goto yy605;
			goto yy540;
		} else {
			if (yych == '\r') goto yy540;
			goto yy605;
		}
yy792:
		YYDEBUG(792, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		if (yych <= '"') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy761;
				if (yych <= '\n') goto yy540;
				goto yy761;
			} else {
				if (yych <= '\r') goto yy540;
				if (yych == ' ') goto yy540;
				goto yy761;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '#') goto yy541;
				if (yych == '/') goto yy542;
				goto yy761;
			} else {
				if (yych <= 'F') goto yy604;
				if (yych == 'f') goto yy604;
				goto yy761;
			}
		}
yy793:
		YYDEBUG(793, *YYCURSOR);
		yyaccept = 92;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_FUNC_C);
}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'L') goto yy812;
		if (yych == 'l') goto yy812;
		goto yy40;
yy796:
		YYDEBUG(796, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '_') goto yy813;
		goto yy40;
yy797:
		YYDEBUG(797, *YYCURSOR);
		yyaccept = 93;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROPERTY_C);
}
yy799:
		YYDEBUG(799, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy745;
		if (yych == 't') goto yy745;
		goto yy72;
yy800:
		YYDEBUG(800, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy637;
			} else {
				if (yych <= '\n') goto yy680;
				if (yych <= '\f') goto yy637;
				goto yy680;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy637;
				goto yy681;
			} else {
				if (yych == '/') goto yy747;
				goto yy637;
			}
		}
yy801:
		YYDEBUG(801, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= '*') goto yy681;
				if (yych <= 'S') goto yy637;
				goto yy815;
			} else {
				if (yych == 't') goto yy815;
				goto yy637;
			}
		}
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'P') {
				if (yych <= '*') goto yy681;
				if (yych <= 'O') goto yy637;
				goto yy816;
			} else {
				if (yych == 'p') goto yy816;
				goto yy637;
			}
		}
yy803:
		YYDEBUG(803, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'M') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'N') goto yy817;
			if (yych == 'n') goto yy817;
			goto yy515;
		}
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'E') goto yy818;
			if (yych == 'e') goto yy818;
			goto yy515;
		}
yy805:
		YYDEBUG(805, *YYCURSOR);
		yyaccept = 94;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\n') {
			if (yych <= 0x00) goto yy771;
			if (yych <= '\t') goto yy513;
			goto yy432;
		} else {
			if (yych == '\r') goto yy432;
			goto yy513;
		}
yy806:
		YYDEBUG(806, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= 'M') goto yy513;
				goto yy819;
			} else {
				if (yych == 'n') goto yy819;
				goto yy513;
			}
		}
yy807:
		YYDEBUG(807, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ')') goto yy820;
		goto yy72;
yy808:
		YYDEBUG(808, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy788;
			goto yy699;
		} else {
			if (yych <= '\r') goto yy788;
			if (yych == '*') goto yy737;
			goto yy699;
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy72;
			if (yych == '\n') goto yy736;
			goto yy699;
		} else {
			if (yych <= '\r') goto yy736;
			if (yych == '*') goto yy821;
			goto yy699;
		}
yy810:
		YYDEBUG(810, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy699;
				goto yy736;
			} else {
				if (yych == '\r') goto yy736;
				goto yy699;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '*') goto yy737;
				if (yych <= 'Q') goto yy699;
				goto yy822;
			} else {
				if (yych == 'r') goto yy822;
				goto yy699;
			}
		}
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy658;
			goto yy607;
		} else {
			if (yych <= 'M') goto yy823;
			if (yych == 'm') goto yy823;
			goto yy607;
		}
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'E') goto yy824;
		if (yych == 'e') goto yy824;
		goto yy40;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyaccept = 95;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_NS_C);
}
yy815:
		YYDEBUG(815, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy681;
				if (yych <= 'D') goto yy637;
				goto yy825;
			} else {
				if (yych == 'e') goto yy825;
				goto yy637;
			}
		}
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'L') {
				if (yych <= '*') goto yy681;
				if (yych <= 'K') goto yy637;
				goto yy826;
			} else {
				if (yych == 'l') goto yy826;
				goto yy637;
			}
		}
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'C') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'D') goto yy827;
			if (yych == 'd') goto yy827;
			goto yy515;
		}
yy818:
		YYDEBUG(818, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'L') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'M') goto yy828;
			if (yych == 'm') goto yy828;
			goto yy515;
		}
yy819:
		YYDEBUG(819, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy513;
			} else {
				if (yych <= '\n') goto yy432;
				if (yych <= '\f') goto yy513;
				goto yy432;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= 'S') goto yy513;
				goto yy780;
			} else {
				if (yych == 't') goto yy780;
				goto yy513;
			}
		}
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_PROTECTED_SET);
}
yy821:
		YYDEBUG(821, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy72;
				goto yy699;
			} else {
				if (yych <= '\n') goto yy736;
				if (yych <= '\f') goto yy699;
				goto yy736;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy699;
				goto yy737;
			} else {
				if (yych == '/') goto yy788;
				goto yy699;
			}
		}
yy822:
		YYDEBUG(822, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy699;
				goto yy736;
			} else {
				if (yych == '\r') goto yy736;
				goto yy699;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '*') goto yy737;
				if (yych <= 'N') goto yy699;
				goto yy829;
			} else {
				if (yych == 'o') goto yy829;
				goto yy699;
			}
		}
yy823:
		YYDEBUG(823, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '@') {
			if (yych <= '*') {
				if (yych <= 0x00) goto yy760;
				if (yych <= ')') goto yy830;
				goto yy831;
			} else {
				if (yych <= '/') goto yy830;
				if (yych <= '9') goto yy607;
				goto yy830;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy607;
				if (yych <= '^') goto yy830;
				goto yy607;
			} else {
				if (yych <= '`') goto yy830;
				if (yych <= 'z') goto yy607;
				if (yych <= 0x7F) goto yy830;
				goto yy607;
			}
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'R') goto yy832;
		if (yych == 'r') goto yy832;
		goto yy40;
yy825:
		YYDEBUG(825, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '*') goto yy681;
				if (yych <= 'M') goto yy637;
				goto yy834;
			} else {
				if (yych == 'n') goto yy834;
				goto yy637;
			}
		}
yy826:
		YYDEBUG(826, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy681;
				if (yych <= 'D') goto yy637;
				goto yy835;
			} else {
				if (yych == 'e') goto yy835;
				goto yy637;
			}
		}
yy827:
		YYDEBUG(827, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'R') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'S') goto yy836;
			if (yych == 's') goto yy836;
			goto yy515;
		}
yy828:
		YYDEBUG(828, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'D') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'E') goto yy837;
			if (yych == 'e') goto yy837;
			goto yy515;
		}
yy829:
		YYDEBUG(829, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy699;
				goto yy736;
			} else {
				if (yych == '\r') goto yy736;
				goto yy699;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy737;
				if (yych <= 'L') goto yy699;
				goto yy838;
			} else {
				if (yych == 'm') goto yy838;
				goto yy699;
			}
		}
yy830:
		YYDEBUG(830, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy761;
		if (yych == '*') goto yy658;
		goto yy607;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '*') {
			if (yych <= 0x00) goto yy761;
			if (yych <= ')') goto yy607;
			goto yy658;
		} else {
			if (yych == '/') goto yy540;
			goto yy607;
		}
yy832:
		YYDEBUG(832, *YYCURSOR);
		yyaccept = 96;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yybm[256+yych] & 128) {
			goto yy39;
		}
		if (yych == '\\') goto yy132;
yy833:
		YYDEBUG(833, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_IDENT(T_HALT_COMPILER);
}
yy834:
		YYDEBUG(834, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'D') {
				if (yych <= '*') goto yy681;
				if (yych <= 'C') goto yy637;
				goto yy839;
			} else {
				if (yych == 'd') goto yy839;
				goto yy637;
			}
		}
yy835:
		YYDEBUG(835, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'M') {
				if (yych <= '*') goto yy681;
				if (yych <= 'L') goto yy637;
				goto yy840;
			} else {
				if (yych == 'm') goto yy840;
				goto yy637;
			}
		}
yy836:
		YYDEBUG(836, *YYCURSOR);
		yyaccept = 94;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 0x00) goto yy771;
		if (yych == '*') goto yy582;
		goto yy515;
yy837:
		YYDEBUG(837, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'M') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'N') goto yy841;
			if (yych == 'n') goto yy841;
			goto yy515;
		}
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy760;
				if (yych == '\n') goto yy843;
				goto yy842;
			} else {
				if (yych <= '\r') goto yy843;
				if (yych == '*') goto yy844;
				goto yy842;
			}
		} else {
			if (yych <= '^') {
				if (yych <= '9') goto yy699;
				if (yych <= '@') goto yy842;
				if (yych <= 'Z') goto yy699;
				goto yy842;
			} else {
				if (yych <= '`') {
					if (yych <= '_') goto yy699;
					goto yy842;
				} else {
					if (yych <= 'z') goto yy699;
					if (yych <= 0x7F) goto yy842;
					goto yy699;
				}
			}
		}
yy839:
		YYDEBUG(839, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'S') {
				if (yych <= '*') goto yy681;
				if (yych <= 'R') goto yy637;
				goto yy845;
			} else {
				if (yych == 's') goto yy845;
				goto yy637;
			}
		}
yy840:
		YYDEBUG(840, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'E') {
				if (yych <= '*') goto yy681;
				if (yych <= 'D') goto yy637;
				goto yy846;
			} else {
				if (yych == 'e') goto yy846;
				goto yy637;
			}
		}
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 0x00) goto yy72;
			if (yych == '*') goto yy582;
			goto yy515;
		} else {
			if (yych <= 'T') goto yy827;
			if (yych == 't') goto yy827;
			goto yy515;
		}
yy842:
		YYDEBUG(842, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy761;
			if (yych == '\n') goto yy736;
			goto yy699;
		} else {
			if (yych <= '\r') goto yy736;
			if (yych == '*') goto yy737;
			goto yy699;
		}
yy843:
		YYDEBUG(843, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych <= '\f') {
				if (yych <= 0x00) goto yy761;
				if (yych <= 0x08) goto yy607;
				if (yych <= '\n') goto yy736;
				goto yy607;
			} else {
				if (yych <= 0x1F) {
					if (yych <= '\r') goto yy736;
					goto yy607;
				} else {
					if (yych <= ' ') goto yy736;
					if (yych <= '"') goto yy607;
					goto yy762;
				}
			}
		} else {
			if (yych <= '/') {
				if (yych == '*') goto yy658;
				if (yych <= '.') goto yy607;
				goto yy763;
			} else {
				if (yych <= 'F') {
					if (yych <= 'E') goto yy607;
					goto yy764;
				} else {
					if (yych == 'f') goto yy764;
					goto yy607;
				}
			}
		}
yy844:
		YYDEBUG(844, *YYCURSOR);
		yyaccept = 91;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\r') {
			if (yych <= '\t') {
				if (yych <= 0x00) goto yy761;
				goto yy699;
			} else {
				if (yych <= '\n') goto yy736;
				if (yych <= '\f') goto yy699;
				goto yy736;
			}
		} else {
			if (yych <= '*') {
				if (yych <= ')') goto yy699;
				goto yy737;
			} else {
				if (yych == '/') goto yy606;
				goto yy699;
			}
		}
yy845:
		YYDEBUG(845, *YYCURSOR);
		yyaccept = 94;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x00) goto yy771;
			if (yych == '\n') goto yy680;
			goto yy637;
		} else {
			if (yych <= '\r') goto yy680;
			if (yych == '*') goto yy681;
			goto yy637;
		}
yy846:
		YYDEBUG(846, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'N') {
				if (yych <= '*') goto yy681;
				if (yych <= 'M') goto yy637;
			} else {
				if (yych != 'n') goto yy637;
			}
		}
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= ')') {
			if (yych <= '\n') {
				if (yych <= 0x00) goto yy72;
				if (yych <= '\t') goto yy637;
				goto yy680;
			} else {
				if (yych == '\r') goto yy680;
				goto yy637;
			}
		} else {
			if (yych <= 'T') {
				if (yych <= '*') goto yy681;
				if (yych <= 'S') goto yy637;
				goto yy839;
			} else {
				if (yych == 't') goto yy839;
				goto yy637;
			}
		}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(847, *YYCURSOR);
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy850;
		}
		if (yych <= '?') {
			if (yych <= '-') {
				if (yych == '#') goto yy851;
				if (yych >= '-') goto yy852;
			} else {
				if (yych == '/') goto yy853;
				if (yych >= '?') goto yy854;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy848;
				if (yych <= 'Z') goto yy855;
				if (yych >= '_') goto yy855;
			} else {
				if (yych <= '`') goto yy848;
				if (yych <= 'z') goto yy855;
				if (yych >= 0x80) goto yy855;
			}
		}
yy848:
		YYDEBUG(848, *YYCURSOR);
		++YYCURSOR;
yy849:
		YYDEBUG(849, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	goto restart;
}
yy850:
		YYDEBUG(850, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy850;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	goto return_whitespace;
}
yy851:
		YYDEBUG(851, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
			case '\n':
				YYCURSOR--;
				break;
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy852:
		YYDEBUG(852, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy856;
		goto yy849;
yy853:
		YYDEBUG(853, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy857;
		if (yych == '/') goto yy851;
		goto yy849;
yy854:
		YYDEBUG(854, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '-') goto yy859;
		goto yy849;
yy855:
		YYDEBUG(855, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy855;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy856:
		YYDEBUG(856, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_OBJECT_OPERATOR);
}
yy857:
		YYDEBUG(857, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy861;
yy858:
		YYDEBUG(858, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_throw_exception_ex(zend_ce_parse_error, 0, "Unterminated comment starting line %d", CG(zend_lineno));
		if (PARSER_MODE()) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = zend_string_init(yytext, yyleng, 0);
		RETURN_OR_SKIP_TOKEN(T_DOC_COMMENT);
	}

	RETURN_OR_SKIP_TOKEN(T_COMMENT);
}
yy859:
		YYDEBUG(859, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy862;
yy860:
		YYDEBUG(860, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy849;
		} else {
			goto yy858;
		}
yy861:
		YYDEBUG(861, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy860;
			if (yych <= '\n') goto yy863;
			goto yy860;
		} else {
			if (yych <= '\r') goto yy863;
			if (yych == ' ') goto yy863;
			goto yy860;
		}
yy862:
		YYDEBUG(862, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN(T_NULLSAFE_OBJECT_OPERATOR);
}
yy863:
		YYDEBUG(863, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy858;
			if (yych <= '\n') goto yy863;
			goto yy858;
		} else {
			if (yych <= '\r') goto yy863;
			if (yych == ' ') goto yy863;
			goto yy858;
		}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(864, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy866;
		} else {
			if (yych <= '`') goto yy867;
			if (yych == '{') goto yy868;
		}
		++YYCURSOR;
yy865:
		YYDEBUG(865, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '`') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy866:
		YYDEBUG(866, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy865;
			if (yych <= 'Z') goto yy869;
			if (yych <= '^') goto yy865;
			goto yy869;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy865;
				goto yy869;
			} else {
				if (yych <= '{') goto yy871;
				if (yych <= 0x7F) goto yy865;
				goto yy869;
			}
		}
yy867:
		YYDEBUG(867, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('`');
}
yy868:
		YYDEBUG(868, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy872;
		goto yy865;
yy869:
		YYDEBUG(869, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy869;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy873;
		} else {
			if (yych <= '?') goto yy875;
			if (yych <= '@') goto yy870;
			if (yych <= '[') goto yy876;
		}
yy870:
		YYDEBUG(870, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy871:
		YYDEBUG(871, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy872:
		YYDEBUG(872, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy873:
		YYDEBUG(873, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy877;
yy874:
		YYDEBUG(874, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy870;
yy875:
		YYDEBUG(875, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy878;
		goto yy874;
yy876:
		YYDEBUG(876, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy877:
		YYDEBUG(877, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy874;
			if (yych <= 'Z') goto yy879;
			if (yych <= '^') goto yy874;
			goto yy879;
		} else {
			if (yych <= '`') goto yy874;
			if (yych <= 'z') goto yy879;
			if (yych <= 0x7F) goto yy874;
			goto yy879;
		}
yy878:
		YYDEBUG(878, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy880;
		goto yy874;
yy879:
		YYDEBUG(879, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy880:
		YYDEBUG(880, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy874;
			if (yych <= 'Z') goto yy881;
			if (yych <= '^') goto yy874;
		} else {
			if (yych <= '`') goto yy874;
			if (yych <= 'z') goto yy881;
			if (yych <= 0x7F) goto yy874;
		}
yy881:
		YYDEBUG(881, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(882, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy884;
		} else {
			if (yych <= '$') goto yy885;
			if (yych == '{') goto yy886;
		}
		++YYCURSOR;
yy883:
		YYDEBUG(883, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (EXPECTED(zend_scan_escape_string(zendlval, yytext, yyleng, '"') == SUCCESS)
	 || !PARSER_MODE()) {
		RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
	} else {
		RETURN_TOKEN(T_ERROR);
	}
}
yy884:
		YYDEBUG(884, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN('"');
}
yy885:
		YYDEBUG(885, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy883;
			if (yych <= 'Z') goto yy887;
			if (yych <= '^') goto yy883;
			goto yy887;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy883;
				goto yy887;
			} else {
				if (yych <= '{') goto yy889;
				if (yych <= 0x7F) goto yy883;
				goto yy887;
			}
		}
yy886:
		YYDEBUG(886, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy890;
		goto yy883;
yy887:
		YYDEBUG(887, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy887;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy891;
		} else {
			if (yych <= '?') goto yy893;
			if (yych <= '@') goto yy888;
			if (yych <= '[') goto yy894;
		}
yy888:
		YYDEBUG(888, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy889:
		YYDEBUG(889, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy890:
		YYDEBUG(890, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy891:
		YYDEBUG(891, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy895;
yy892:
		YYDEBUG(892, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy888;
yy893:
		YYDEBUG(893, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy896;
		goto yy892;
yy894:
		YYDEBUG(894, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy895:
		YYDEBUG(895, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy892;
			if (yych <= 'Z') goto yy897;
			if (yych <= '^') goto yy892;
			goto yy897;
		} else {
			if (yych <= '`') goto yy892;
			if (yych <= 'z') goto yy897;
			if (yych <= 0x7F) goto yy892;
			goto yy897;
		}
yy896:
		YYDEBUG(896, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy898;
		goto yy892;
yy897:
		YYDEBUG(897, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy898:
		YYDEBUG(898, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy892;
			if (yych <= 'Z') goto yy899;
			if (yych <= '^') goto yy892;
		} else {
			if (yych <= '`') goto yy892;
			if (yych <= 'z') goto yy899;
			if (yych <= 0x7F) goto yy892;
		}
yy899:
		YYDEBUG(899, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(900, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy902;
		if (yych == '{') goto yy903;
		++YYCURSOR;
yy901:
		YYDEBUG(901, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = 0;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					if (SCNG(heredoc_scan_ahead)) {
						SCNG(heredoc_indentation) = indentation;
						SCNG(heredoc_indentation_uses_spaces) = (spacing == HEREDOC_USING_SPACES);
					} else {
						YYCURSOR -= indentation;
					}

					BEGIN(ST_END_HEREDOC);

					goto heredoc_scan_done;
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:

	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!SCNG(heredoc_scan_ahead) && !EG(exception) && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		zend_string *copy = Z_STR_P(zendlval);

		if (!strip_multiline_string_indentation(
				zendlval, heredoc_label->indentation, heredoc_label->indentation_uses_spaces,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}

		if (UNEXPECTED(zend_scan_escape_string(zendlval, ZSTR_VAL(copy), ZSTR_LEN(copy), 0) != SUCCESS)) {
			zend_string_efree(copy);
			RETURN_TOKEN(T_ERROR);
		}

		zend_string_efree(copy);
	} else {
		HANDLE_NEWLINES(yytext, yyleng - newline);
	}

	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy902:
		YYDEBUG(902, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy901;
			if (yych <= 'Z') goto yy904;
			if (yych <= '^') goto yy901;
			goto yy904;
		} else {
			if (yych <= 'z') {
				if (yych <= '`') goto yy901;
				goto yy904;
			} else {
				if (yych <= '{') goto yy906;
				if (yych <= 0x7F) goto yy901;
				goto yy904;
			}
		}
yy903:
		YYDEBUG(903, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy907;
		goto yy901;
yy904:
		YYDEBUG(904, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(4);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy904;
		}
		if (yych <= '>') {
			if (yych == '-') goto yy908;
		} else {
			if (yych <= '?') goto yy910;
			if (yych <= '@') goto yy905;
			if (yych <= '[') goto yy911;
		}
yy905:
		YYDEBUG(905, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy906:
		YYDEBUG(906, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME);
	enter_nesting('{');
	RETURN_TOKEN(T_DOLLAR_OPEN_CURLY_BRACES);
}
yy907:
		YYDEBUG(907, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING);
	yyless(1);
	enter_nesting('{');
	RETURN_TOKEN(T_CURLY_OPEN);
}
yy908:
		YYDEBUG(908, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy912;
yy909:
		YYDEBUG(909, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy905;
yy910:
		YYDEBUG(910, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '-') goto yy913;
		goto yy909;
yy911:
		YYDEBUG(911, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy912:
		YYDEBUG(912, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy909;
			if (yych <= 'Z') goto yy914;
			if (yych <= '^') goto yy909;
			goto yy914;
		} else {
			if (yych <= '`') goto yy909;
			if (yych <= 'z') goto yy914;
			if (yych <= 0x7F) goto yy909;
			goto yy914;
		}
yy913:
		YYDEBUG(913, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy915;
		goto yy909;
yy914:
		YYDEBUG(914, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy915:
		YYDEBUG(915, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy909;
			if (yych <= 'Z') goto yy916;
			if (yych <= '^') goto yy909;
		} else {
			if (yych <= '`') goto yy909;
			if (yych <= 'z') goto yy916;
			if (yych <= 0x7F) goto yy909;
		}
yy916:
		YYDEBUG(916, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 4);
	yy_push_state(ST_LOOKING_FOR_PROPERTY);
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(917, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy918;
			if (yych <= 'Z') goto yy920;
			if (yych >= '_') goto yy920;
		} else {
			if (yych <= '`') goto yy918;
			if (yych <= 'z') goto yy920;
			if (yych >= 0x80) goto yy920;
		}
yy918:
		YYDEBUG(918, *YYCURSOR);
		++YYCURSOR;
yy919:
		YYDEBUG(919, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	goto restart;
}
yy920:
		YYDEBUG(920, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy919;
				if (yych <= '9') goto yy922;
				goto yy919;
			} else {
				if (yych <= '[') goto yy922;
				if (yych <= '^') goto yy919;
				goto yy922;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy919;
				if (yych <= 'z') goto yy922;
				goto yy919;
			} else {
				if (yych <= '}') goto yy922;
				if (yych <= 0x7F) goto yy919;
				goto yy922;
			}
		}
yy921:
		YYDEBUG(921, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy922:
		YYDEBUG(922, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy921;
		}
		if (yych <= '@') goto yy923;
		if (yych <= '[') goto yy924;
		if (yych == '}') goto yy924;
yy923:
		YYDEBUG(923, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy919;
yy924:
		YYDEBUG(924, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_pop_state();
	yy_push_state(ST_IN_SCRIPTING);
	RETURN_TOKEN_WITH_STR(T_STRING_VARNAME, 0);
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			248, 248, 216, 216, 216, 216, 216, 216, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,   0, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(925, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '0') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy926;
					if (yych <= '\n') goto yy927;
				} else {
					if (yych <= '\r') goto yy927;
					if (yych >= ' ') goto yy927;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy928;
					if (yych <= '#') goto yy927;
					goto yy930;
				} else {
					if (yych == '\'') goto yy927;
					if (yych <= '/') goto yy928;
					goto yy931;
				}
			}
		} else {
			if (yych <= ']') {
				if (yych <= 'Z') {
					if (yych <= '9') goto yy933;
					if (yych <= '@') goto yy928;
					goto yy934;
				} else {
					if (yych <= '[') goto yy928;
					if (yych <= '\\') goto yy927;
					goto yy935;
				}
			} else {
				if (yych <= '`') {
					if (yych == '_') goto yy934;
					goto yy928;
				} else {
					if (yych <= 'z') goto yy934;
					if (yych <= '~') goto yy928;
					if (yych >= 0x80) goto yy934;
				}
			}
		}
yy926:
		YYDEBUG(926, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	RETURN_TOKEN(T_BAD_CHARACTER);
}
yy927:
		YYDEBUG(927, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state();
	ZVAL_NULL(zendlval);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
yy928:
		YYDEBUG(928, *YYCURSOR);
		++YYCURSOR;
yy929:
		YYDEBUG(929, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' or '-' can be valid, but returning other tokens will allow a more explicit parse error */
	RETURN_TOKEN(yytext[0]);
}
yy930:
		YYDEBUG(930, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy929;
			if (yych <= 'Z') goto yy936;
			if (yych <= '^') goto yy929;
			goto yy936;
		} else {
			if (yych <= '`') goto yy929;
			if (yych <= 'z') goto yy936;
			if (yych <= 0x7F) goto yy929;
			goto yy936;
		}
yy931:
		YYDEBUG(931, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'X') {
			if (yych <= 'B') {
				if (yych <= '/') goto yy932;
				if (yych <= '9') goto yy938;
				if (yych >= 'B') goto yy940;
			} else {
				if (yych == 'O') goto yy942;
				if (yych >= 'X') goto yy943;
			}
		} else {
			if (yych <= 'b') {
				if (yych == '_') goto yy944;
				if (yych >= 'b') goto yy940;
			} else {
				if (yych <= 'o') {
					if (yych >= 'o') goto yy942;
				} else {
					if (yych == 'x') goto yy943;
				}
			}
		}
yy932:
		YYDEBUG(932, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		char *end;
		errno = 0;
		ZVAL_LONG(zendlval, ZEND_STRTOL(yytext, &end, 10));
		if (errno == ERANGE) {
			goto string;
		}
		ZEND_ASSERT(end == yytext + yyleng);
	} else {
string:
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy933:
		YYDEBUG(933, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 8) {
			goto yy933;
		}
		if (yych == '_') goto yy944;
		goto yy932;
yy934:
		YYDEBUG(934, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy934;
		}
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_STRING, 0);
}
yy935:
		YYDEBUG(935, *YYCURSOR);
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state();
	RETURN_TOKEN(']');
}
yy936:
		YYDEBUG(936, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy936;
			} else {
				if (yych <= '@') goto yy937;
				if (yych <= 'Z') goto yy936;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy936;
			} else {
				if (yych <= 'z') goto yy936;
				if (yych >= 0x80) goto yy936;
			}
		}
yy937:
		YYDEBUG(937, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RETURN_TOKEN_WITH_STR(T_VARIABLE, 1);
}
yy938:
		YYDEBUG(938, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy939;
		if (yych <= '9') goto yy938;
		if (yych == '_') goto yy944;
yy939:
		YYDEBUG(939, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*(yytext)));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	RETURN_TOKEN_WITH_VAL(T_NUM_STRING);
}
yy940:
		YYDEBUG(940, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy945;
		}
yy941:
		YYDEBUG(941, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy932;
		} else {
			goto yy939;
		}
yy942:
		YYDEBUG(942, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy946;
		}
		goto yy941;
yy943:
		YYDEBUG(943, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy947;
		}
		goto yy941;
yy944:
		YYDEBUG(944, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yych <= '/') goto yy941;
		if (yych <= '9') goto yy938;
		goto yy941;
yy945:
		YYDEBUG(945, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy945;
		}
		if (yych == '_') goto yy940;
		goto yy939;
yy946:
		YYDEBUG(946, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy946;
		}
		if (yych == '_') goto yy942;
		goto yy939;
yy947:
		YYDEBUG(947, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy947;
		}
		if (yych == '_') goto yy943;
		goto yy939;
	}
/* *********************************** */
yyc_SHEBANG:
	{
		static const unsigned char yybm[] = {
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(948, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '#') goto yy950;
		++YYCURSOR;
yy949:
		YYDEBUG(949, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	BEGIN(INITIAL);
	goto restart;
}
yy950:
		YYDEBUG(950, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '!') goto yy949;
yy951:
		YYDEBUG(951, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy951;
		}
		++YYCURSOR;
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	CG(zend_lineno)++;
	BEGIN(INITIAL);
	goto restart;
}
	}
/* *********************************** */
yyc_INITIAL:
	YYDEBUG(952, *YYCURSOR);
	YYFILL(7);
	yych = *YYCURSOR;
	if (yych == '<') goto yy954;
	++YYCURSOR;
yy953:
	YYDEBUG(953, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR >= YYLIMIT) {
			break;
		}

		if (*YYCURSOR == '?') {
			if (CG(short_tags) /* <? */
				|| (*(YYCURSOR + 1) == '=') /* <?= */
				|| (!strncasecmp((char*)YYCURSOR + 1, "php", 3) && /* <?php[ \t\r\n] */
					(YYCURSOR + 4 == YYLIMIT ||
					YYCURSOR[4] == ' ' || YYCURSOR[4] == '\t' ||
					YYCURSOR[4] == '\n' || YYCURSOR[4] == '\r'))
			) {
				YYCURSOR--;
				break;
			}
		}
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		size_t readsize;
		char *s = NULL;
		size_t sz = 0;
		// TODO: avoid reallocation ???
		readsize = SCNG(output_filter)((unsigned char **)&s, &sz, (unsigned char *)yytext, (size_t)yyleng);
		ZVAL_STRINGL(zendlval, s, sz);
		efree(s);
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else if (yyleng == 1) {
		ZVAL_INTERNED_STR(zendlval, ZSTR_CHAR((zend_uchar)*yytext));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng);
	}
	HANDLE_NEWLINES(yytext, yyleng);
	RETURN_TOKEN_WITH_VAL(T_INLINE_HTML);
}
yy954:
	YYDEBUG(954, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych != '?') goto yy953;
	yych = *(YYMARKER = ++YYCURSOR);
	if (yych <= 'O') {
		if (yych == '=') goto yy956;
	} else {
		if (yych <= 'P') goto yy957;
		if (yych == 'p') goto yy957;
	}
yy955:
	YYDEBUG(955, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	if (CG(short_tags)) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	} else {
		goto inline_char_handler;
	}
}
yy956:
	YYDEBUG(956, *YYCURSOR);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	BEGIN(ST_IN_SCRIPTING);
	if (PARSER_MODE()) {
		/* We'll reject this as an identifier in zend_lex_tstring. */
		RETURN_TOKEN_WITH_IDENT(T_ECHO);
	}
	RETURN_TOKEN(T_OPEN_TAG_WITH_ECHO);
}
yy957:
	YYDEBUG(957, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'H') goto yy959;
	if (yych == 'h') goto yy959;
yy958:
	YYDEBUG(958, *YYCURSOR);
	YYCURSOR = YYMARKER;
	goto yy955;
yy959:
	YYDEBUG(959, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == 'P') goto yy960;
	if (yych != 'p') goto yy958;
yy960:
	YYDEBUG(960, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych <= '\f') {
		if (yych <= 0x08) goto yy961;
		if (yych <= '\n') goto yy962;
	} else {
		if (yych <= '\r') goto yy964;
		if (yych == ' ') goto yy962;
	}
yy961:
	YYDEBUG(961, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	/* Allow <?php followed by end of file. */
	if (YYCURSOR == YYLIMIT) {
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	/* Degenerate case: <?phpX is interpreted as <? phpX with short tags. */
	if (CG(short_tags)) {
		yyless(2);
		BEGIN(ST_IN_SCRIPTING);
		RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
	}
	goto inline_char_handler;
}
yy962:
	YYDEBUG(962, *YYCURSOR);
	++YYCURSOR;
yy963:
	YYDEBUG(963, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	RETURN_OR_SKIP_TOKEN(T_OPEN_TAG);
}
yy964:
	YYDEBUG(964, *YYCURSOR);
	yych = *++YYCURSOR;
	if (yych == '\n') goto yy962;
	goto yy963;
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(965, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	yyleng = heredoc_label->indentation + heredoc_label->length;
	YYCURSOR += yyleng - 1;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	RETURN_TOKEN(T_END_HEREDOC);
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(966, *YYCURSOR);
	YYFILL(1);
	++YYCURSOR;
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));
	int newline = 0, indentation = 0, spacing = -1;

	if (YYCURSOR > YYLIMIT) {
		RETURN_END_TOKEN;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				ZEND_FALLTHROUGH;
			case '\n':
				indentation = spacing = 0;

				while (YYCURSOR < YYLIMIT && (*YYCURSOR == ' ' || *YYCURSOR == '\t')) {
					if (*YYCURSOR == '\t') {
						spacing |= HEREDOC_USING_TABS;
					} else {
						spacing |= HEREDOC_USING_SPACES;
					}
					++YYCURSOR;
					++indentation;
				}

				if (YYCURSOR == YYLIMIT) {
					yyleng = YYCURSOR - SCNG(yy_text);
					HANDLE_NEWLINES(yytext, yyleng);
					ZVAL_NULL(zendlval);
					RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
				}

				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					if (IS_LABEL_SUCCESSOR(YYCURSOR[heredoc_label->length])) {
						continue;
					}

					if (spacing == (HEREDOC_USING_SPACES | HEREDOC_USING_TABS)) {
						zend_throw_exception(zend_ce_parse_error, "Invalid indentation - tabs and spaces cannot be mixed", 0);
						if (PARSER_MODE()) {
							RETURN_TOKEN(T_ERROR);
						}
					}

					/* newline before label will be subtracted from returned text, but
					 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
					if (YYCURSOR[-indentation - 2] == '\r' && YYCURSOR[-indentation - 1] == '\n') {
						newline = 2; /* Windows newline */
					} else {
						newline = 1;
					}

					CG(increment_lineno) = 1; /* For newline before label */

					YYCURSOR -= indentation;
					heredoc_label->indentation = indentation;

					BEGIN(ST_END_HEREDOC);

					goto nowdoc_scan_done;
				}
				ZEND_FALLTHROUGH;
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);
	ZVAL_STRINGL(zendlval, yytext, yyleng - newline);

	if (!EG(exception) && spacing != -1 && PARSER_MODE()) {
		bool newline_at_start = *(yytext - 1) == '\n' || *(yytext - 1) == '\r';
		if (!strip_multiline_string_indentation(
				zendlval, indentation, spacing == HEREDOC_USING_SPACES,
				newline_at_start, newline != 0)) {
			RETURN_TOKEN(T_ERROR);
		}
	}

	HANDLE_NEWLINES(yytext, yyleng - newline);
	RETURN_TOKEN_WITH_VAL(T_ENCAPSED_AND_WHITESPACE);
}
}


emit_token_with_str:
	zend_copy_value(zendlval, (yytext + offset), (yyleng - offset));

emit_token_with_val:
	if (PARSER_MODE()) {
		ZEND_ASSERT(Z_TYPE_P(zendlval) != IS_UNDEF);
		elem->ast = zend_ast_create_zval_with_lineno(zendlval, start_line);
	}

emit_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

emit_token_with_ident:
	if (PARSER_MODE()) {
		elem->ident = SCNG(yy_text);
	}
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	return token;

return_whitespace:
	HANDLE_NEWLINES(yytext, yyleng);
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, T_WHITESPACE, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	if (PARSER_MODE()) {
		start_line = CG(zend_lineno);
		goto restart;
	} else {
		return T_WHITESPACE;
	}

skip_token:
	if (SCNG(on_event)) {
		SCNG(on_event)(ON_TOKEN, token, start_line, yytext, yyleng, SCNG(on_event_context));
	}
	start_line = CG(zend_lineno);
	goto restart;
}
