{-|
Module      : Graphics.Autom.Display2D
Description : Convience wrappers to display a 2D Gloss Picture on the screen.
Copyright   : (c) Christopher Howard, 2016
License     : GPL-3
Maintainer  : ch.howard@zoho.com
-}
module Graphics.Autom.Display2D where

import Prelude(IO, Int, String)
import Graphics.Gloss ( display,
                        Display( FullScreen, InWindow ),
                        Picture,
                        Color
                      )


-- |Displays a 'Picture' in a window on the screen.
displayWindow :: (Int, Int) -- ^ width and height of the display area
                 -> Color   -- ^ background color
                 -> String  -- ^ window title
                 -> Picture -- ^ Picture to be displayed
                 -> IO ()
displayWindow (width, height) bg title pic =
  display (InWindow title (width, height) (0, 0)) bg pic

-- NOTE: This function is buggy on my system.
-- -- |Display a 'Picture' on the screen, in full-screen mode
-- displayFullscreen :: (Int, Int) -- ^ width and height of the display area
--                      -> Color   -- ^ background color
--                      -> Picture -- ^ Picture to be dislayed
--                      -> IO () 
-- displayFullscreen (width, height) bg pic =
--   display (FullScreen (width, height)) bg pic

