{-|
Module      : Graphics.Autom.Example
Description : Examples using the library API
Copyright   : (c) Christopher Howard, 2016
License     : GPL-3
Maintainer  : ch.howard@zoho.com

Some interesting example images. On most systems, images will take a
minute or two to be calculated before being displayed.

Do not use these functions in production code. Changes to Example
functions will not be counted as breaking changes for purposes of
version numbering.
-}
module Graphics.Autom.Example where

import Graphics.Autom

import Prelude (Bool(..), IO, take)
import Graphics.Gloss (black)
import System.Random (randomRs, mkStdGen)
import Data.Vector.Unboxed (fromList)

example1 :: IO ()
example1 = displayWindow (w, w) black "Autom"
             (toPicture v w)
  where w = 800
        v = grid b r w
        r = fromQuad 195 188 227 144
        b = fromList (Prelude.take w (randomRs (False, True) g ))
        g = mkStdGen s
        s = 9384934

example2 :: IO ()
example2 = displayWindow (800, 800) black "Autom"
            (toPicture v w)
  where w = 800
        v = grid b r w
        r = fromQuad 213 196 192 153
        b = fromList (Prelude.take w (randomRs (False, True) g ))
        g = mkStdGen s
        s = 9384934

example3 :: IO ()
example3 = displayWindow (w, h) black "Autom"
              (toPictureColored ov w 200 3)
  where w = 800
        h = 600
        v = grid b r h
        ov = overlaidGrid v w
        r = 1127606298
        b = fromList (Prelude.take w (randomRs (False, True) g ))
        g = mkStdGen s
        s = 9384934

example4 :: IO ()
example4 = displayWindow (w, h) black "Autom"
              (toPictureColored ov w 200 15)
  where w = 800
        h = 600
        v = grid b r h
        ov = overlaidGrid v w
        r = 3620459850
        b = fromList (Prelude.take w (randomRs (False, True) g ))
        g = mkStdGen s
        s = 9384934
