module Codec.Libevent.Class where

import qualified Data.ByteString as BS

class TaggedStructure a where
  -- | Return a structure filled with default values
  empty :: a
  -- | Serialise a structure to a strict bytestring
  serialise :: a -> BS.ByteString
  -- | Attempt to deserialise a bytestring, returning either an error
  --   message or a structure
  deserialise :: BS.ByteString -> Either String a
