module Main where

import System.Environment

import Codec.Libevent.Parse
import Codec.Libevent.Generate

main = do
  args <- getArgs
  case args of
       [inputfile, modulename] -> do
         parseResult <- parseRPCFile inputfile
         case parseResult of
           Left err -> fail $ show err
           Right rpc -> generate modulename rpc >> return ()
       otherwise -> fail "Usage: <input rpc file> <module name>"
