module Graphics.Fonts.OpenGL.Basic4x6
  ( -- * Digits
    digit0, digit1, digit2, digit3, digit4, digit5, digit6, digit7, digit8, digit9
    -- * Symbols
  , exclamation, percent, plus, minus, period, slash, colon, lessThan, equal, greaterThan
  )
  where

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

import qualified Graphics.Rendering.OpenGL as GL

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

digit0 :: IO ()
digit0 =
    renderQuads
      [ (-2,3),  (-2,-3), (-1,-3), (-1,3)
      , (-1,3),  (-1,2),  (1,2),   (1,3)
      , (-1,-2), (-1,-3), (1,-3),  (1,-2)
      , (1,3),   (1,-3),  (2,-3),  (2,3)
      ]

digit1 :: IO ()
digit1 =
    renderQuads
      [ (-0.5,3), (-0.5,-3), (0.5,-3), (0.5,3)
      ]

digit2 :: IO ()
digit2 =
    renderQuads
      [ (-2,3),  (-2,2),  (1,2),   (1,3)
      , (1,3),   (1,-1),  (2,-1),  (2,3)
      , (-1,0),  (-1,-1), (1,-1),  (1,0)
      , (-2,0),  (-2,-3), (-1,-3), (-1,0)
      , (-1,-2), (-1,-3), (2,-3),  (2,-2)
      ]

digit3 :: IO ()
digit3 =
    renderQuads
      [ (-2,3),  (-2,2),  (1,2),  (1,3)
      , (1,3),   (1,-3),  (2,-3), (2,3)
      , (-2,0),  (-2,-1), (1,-1), (1,0)
      , (-2,-2), (-2,-3), (1,-3), (1,-2)
      ]

digit4 :: IO ()
digit4 =
    renderQuads
      [ (-2,3), (-2,-1), (-1,-1), (-1,3)
      , (-1,0), (-1,-1), (1,-1),  (1,0)
      , (1,3),  (1,-3),  (2,-3),  (2,3)
      ]

digit5 :: IO ()
digit5 =
    renderQuads
      [ (-1,3),  (-1,2),  (2,2),   (2,3)
      , (-2,3),  (-2,-1), (-1,-1), (-1,3)
      , (-1,0),  (-1,-1), (1,-1),  (1,0)
      , (1,0),   (1,-3),  (2,-3),  (2,0)
      , (-2,-2), (-2,-3), (1,-3),  (1,-2)
      ]

digit6 :: IO ()
digit6 =
    renderQuads
      [ (-1,3),  (-1,2),  (2,2),   (2,3)
      , (-2,3),  (-2,-3), (-1,-3), (-1,3)
      , (-1,0),  (-1,-1), (1,-1),  (1,0)
      , (-1,-2), (-1,-3), (1,-3),  (1,-2)
      , (1,0),   (1,-3),  (2,-3),  (2,0)
      ]

digit7 :: IO ()
digit7 =
    renderQuads
      [ (-2,3), (-2,2), (1,2),  (1,3)
      , (1,3),  (1,-3), (2,-3), (2,3)
      ]

digit8 :: IO ()
digit8 =
    renderQuads
      [ (-2,3),  (-2,-3), (-1,-3), (-1,3)
      , (-1,3),  (-1,2),  (1,2),   (1,3)
      , (-1,0),  (-1,-1), (1,-1),  (1,0)
      , (-1,-2), (-1,-3), (1,-3),  (1,-2)
      , (1,3),   (1,-3),  (2,-3),  (2,3)
      ]

digit9 :: IO ()
digit9 =
    renderQuads
      [ (-2,3), (-2,-1), (-1,-1), (-1,3)
      , (-1,3), (-1,2),  (1,2),   (1,3)
      , (-1,0), (-1,-1), (1,-1),  (1,0)
      , (1,3),  (1,-3),  (2,-3),  (2,3)
      ]

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

exclamation :: IO ()
exclamation =
    renderQuads
      [ (-0.5,3),  (-0.5,-1), (0.5,-1), (0.5,3)
      , (-0.5,-2), (-0.5,-3), (0.5,-3), (0.5,-2)
      ]

percent :: IO ()
percent =
    renderQuads
      [ (1,3),  (-2,-3), (-1,-3), (2,3)
      , (-2,3), (-2,2),  (-1,2),  (-1,3)
      , (1,-2), (1,-3),  (2,-3),  (2,-2)
      ]

plus :: IO ()
plus =
    renderQuads
      [ (-2,0.5),  (-2,-0.5),  (-0.5,-0.5), (-0.5,0.5)
      , (-0.5,2),  (-0.5,-2),  (0.5,-2),    (0.5,2)
      , (0.5,0.5), (0.5,-0.5), (2,-0.5),    (2,0.5)
      ]

minus :: IO ()
minus =
    renderQuads
      [ (-2,0.5), (-2,-0.5), (2,-0.5), (2,0.5)
      ]

period :: IO ()
period =
    renderQuads
      [ (-0.5,-2), (-0.5,-3), (0.5,-3), (0.5,-2)
      ]

slash :: IO ()
slash =
    renderQuads
      [ (1,3), (-2,-3), (-1,-3), (2,3)
      ]

colon :: IO ()
colon =
    renderQuads
      [ (-0.5,1.5),  (-0.5,0.5),  (0.5,0.5),  (0.5,1.5)
      , (-0.5,-0.5), (-0.5,-1.5), (0.5,-1.5), (0.5,-0.5)
      ]

lessThan :: IO ()
lessThan =
    renderQuads
      [ (1,3),  (-2,0), (-1,0), (2,3)
      , (-2,0), (1,-3), (2,-3), (-1,0)
      ]

equal :: IO ()
equal =
    renderQuads
      [ (-2,1.5),  (-2,0.5),  (2,0.5),  (2,1.5)
      , (-2,-0.5), (-2,-1.5), (2,-1.5), (2,-0.5)
      ]

greaterThan :: IO ()
greaterThan =
    renderQuads
      [ (-2,3), (1,0),   (2,0),   (-1,3)
      , (1,0),  (-2,-3), (-1,-3), (2,0)
      ]

-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- --

renderQuads :: [(GL.GLfloat, GL.GLfloat)] -> IO ()
renderQuads =
    GL.renderPrimitive GL.Quads . mapM_ (\(x, y) -> GL.vertex (GL.Vertex2 x y))
