module Godot.Api.Auto where
import Data.Coerce
import Foreign.C
import Godot.Internal.Dispatch
import System.IO.Unsafe
import Godot.Gdnative.Internal
import Godot.Gdnative.Types

newtype GodotGlobalConstants = GodotGlobalConstants GodotObject
                                 deriving newtype AsVariant
bindObject_free
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "free" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_free #-}

instance Method "free" GodotObject (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_free (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject__notification
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "_notification" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject__notification #-}

instance Method "_notification" GodotObject (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject__notification (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject__set
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "_set" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject__set #-}

instance Method "_set" GodotObject
           (GodotString -> GodotVariant -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject__set (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject__get
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "_get" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject__get #-}

instance Method "_get" GodotObject (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject__get (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject__get_property_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "_get_property_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject__get_property_list #-}

instance Method "_get_property_list" GodotObject (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject__get_property_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject__init
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "_init" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject__init #-}

instance Method "_init" GodotObject (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject__init (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_class
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_class" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_class #-}

instance Method "get_class" GodotObject (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_class (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_is_class
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "is_class" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_is_class #-}

instance Method "is_class" GodotObject (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_is_class (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set #-}

instance Method "set" GodotObject
           (GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get #-}

instance Method "get" GodotObject (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set_indexed
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set_indexed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set_indexed #-}

instance Method "set_indexed" GodotObject
           (GodotNodePath -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set_indexed (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_indexed
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_indexed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_indexed #-}

instance Method "get_indexed" GodotObject
           (GodotNodePath -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_indexed (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_property_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_property_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_property_list #-}

instance Method "get_property_list" GodotObject (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_property_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_method_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_method_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_method_list #-}

instance Method "get_method_list" GodotObject (IO GodotArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_method_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_notification
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "notification" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_notification #-}

instance Method "notification" GodotObject (Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_notification (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_instance_id
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_instance_id #-}

instance Method "get_instance_id" GodotObject (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_instance_id (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set_script
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set_script" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set_script #-}

instance Method "set_script" GodotObject (GodotReference -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set_script (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_script
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_script" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_script #-}

instance Method "get_script" GodotObject (IO GodotReference) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_script (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set_meta
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set_meta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set_meta #-}

instance Method "set_meta" GodotObject
           (GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set_meta (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_meta
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_meta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_meta #-}

instance Method "get_meta" GodotObject
           (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_meta (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_has_meta
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "has_meta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_has_meta #-}

instance Method "has_meta" GodotObject (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_has_meta (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_meta_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_meta_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_meta_list #-}

instance Method "get_meta_list" GodotObject
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_meta_list (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_add_user_signal
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "add_user_signal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_add_user_signal #-}

instance Method "add_user_signal" GodotObject
           (GodotString -> GodotArray -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_add_user_signal (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_has_user_signal
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "has_user_signal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_has_user_signal #-}

instance Method "has_user_signal" GodotObject
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_has_user_signal (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_callv
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "callv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_callv #-}

instance Method "callv" GodotObject
           (GodotString -> GodotArray -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_callv (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_has_method
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "has_method" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_has_method #-}

instance Method "has_method" GodotObject (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_has_method (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_signal_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_signal_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_signal_list #-}

instance Method "get_signal_list" GodotObject (IO GodotArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_signal_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_signal_connection_list
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_signal_connection_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_signal_connection_list #-}

instance Method "get_signal_connection_list" GodotObject
           (GodotString -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_signal_connection_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_get_incoming_connections
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "get_incoming_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_get_incoming_connections #-}

instance Method "get_incoming_connections" GodotObject
           (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_get_incoming_connections
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_connect
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "connect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_connect #-}

instance Method "connect" GodotObject
           (GodotString ->
              GodotObject -> GodotString -> GodotArray -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_connect (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_disconnect
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "disconnect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_disconnect #-}

instance Method "disconnect" GodotObject
           (GodotString -> GodotObject -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_disconnect (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_is_connected
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "is_connected" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_is_connected #-}

instance Method "is_connected" GodotObject
           (GodotString -> GodotObject -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_is_connected (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set_block_signals
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set_block_signals" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set_block_signals #-}

instance Method "set_block_signals" GodotObject (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set_block_signals (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_is_blocking_signals
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "is_blocking_signals" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_is_blocking_signals #-}

instance Method "is_blocking_signals" GodotObject (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_is_blocking_signals (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_property_list_changed_notify
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "property_list_changed_notify" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_property_list_changed_notify #-}

instance Method "property_list_changed_notify" GodotObject (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_property_list_changed_notify
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_set_message_translation
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "set_message_translation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_set_message_translation #-}

instance Method "set_message_translation" GodotObject
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_set_message_translation
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_can_translate_messages
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "can_translate_messages" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_can_translate_messages #-}

instance Method "can_translate_messages" GodotObject (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_can_translate_messages
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_tr
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "tr" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_tr #-}

instance Method "tr" GodotObject (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_tr (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindObject_is_queued_for_deletion
  = unsafePerformIO $
      withCString "Object" $
        \ clsNamePtr ->
          withCString "is_queued_for_deletion" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindObject_is_queued_for_deletion #-}

instance Method "is_queued_for_deletion" GodotObject (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindObject_is_queued_for_deletion
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotReference = GodotReference GodotObject
                           deriving newtype AsVariant

instance HasBaseClass GodotReference where
        type BaseClass GodotReference = GodotObject
        super = coerce
bindReference_init_ref
  = unsafePerformIO $
      withCString "Reference" $
        \ clsNamePtr ->
          withCString "init_ref" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindReference_init_ref #-}

instance Method "init_ref" GodotReference (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindReference_init_ref (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindReference_reference
  = unsafePerformIO $
      withCString "Reference" $
        \ clsNamePtr ->
          withCString "reference" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindReference_reference #-}

instance Method "reference" GodotReference (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindReference_reference (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindReference_unreference
  = unsafePerformIO $
      withCString "Reference" $
        \ clsNamePtr ->
          withCString "unreference" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindReference_unreference #-}

instance Method "unreference" GodotReference (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindReference_unreference (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotResource = GodotResource GodotObject
                          deriving newtype AsVariant

instance HasBaseClass GodotResource where
        type BaseClass GodotResource = GodotReference
        super = coerce
bindResource__setup_local_to_scene
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "_setup_local_to_scene" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource__setup_local_to_scene #-}

instance Method "_setup_local_to_scene" GodotResource (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource__setup_local_to_scene
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_set_path
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "set_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_set_path #-}

instance Method "set_path" GodotResource (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_set_path (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_take_over_path
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "take_over_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_take_over_path #-}

instance Method "take_over_path" GodotResource
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_take_over_path (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_get_path
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "get_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_get_path #-}

instance Method "get_path" GodotResource (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_get_path (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_set_name
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "set_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_set_name #-}

instance Method "set_name" GodotResource (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_set_name (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_get_name
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "get_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_get_name #-}

instance Method "get_name" GodotResource (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_get_name (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_get_rid
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "get_rid" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_get_rid #-}

instance Method "get_rid" GodotResource (IO GodotRid) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_get_rid (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_set_local_to_scene
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "set_local_to_scene" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_set_local_to_scene #-}

instance Method "set_local_to_scene" GodotResource (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_set_local_to_scene (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_is_local_to_scene
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "is_local_to_scene" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_is_local_to_scene #-}

instance Method "is_local_to_scene" GodotResource (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_is_local_to_scene (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_get_local_scene
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "get_local_scene" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_get_local_scene #-}

instance Method "get_local_scene" GodotResource (IO GodotNode)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_get_local_scene (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_setup_local_to_scene
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "setup_local_to_scene" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_setup_local_to_scene #-}

instance Method "setup_local_to_scene" GodotResource (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_setup_local_to_scene
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResource_duplicate
  = unsafePerformIO $
      withCString "Resource" $
        \ clsNamePtr ->
          withCString "duplicate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResource_duplicate #-}

instance Method "duplicate" GodotResource
           (Bool -> IO GodotResource)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResource_duplicate (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotScript = GodotScript GodotObject
                        deriving newtype AsVariant

instance HasBaseClass GodotScript where
        type BaseClass GodotScript = GodotResource
        super = coerce
bindScript_can_instance
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "can_instance" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_can_instance #-}

instance Method "can_instance" GodotScript (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_can_instance (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_instance_has
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "instance_has" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_instance_has #-}

instance Method "instance_has" GodotScript (GodotObject -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_instance_has (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_has_source_code
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "has_source_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_has_source_code #-}

instance Method "has_source_code" GodotScript (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_has_source_code (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_get_source_code
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "get_source_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_get_source_code #-}

instance Method "get_source_code" GodotScript (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_get_source_code (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_set_source_code
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "set_source_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_set_source_code #-}

instance Method "set_source_code" GodotScript
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_set_source_code (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_reload
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "reload" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_reload #-}

instance Method "reload" GodotScript (Bool -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_reload (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_get_base_script
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "get_base_script" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_get_base_script #-}

instance Method "get_base_script" GodotScript (IO GodotScript)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_get_base_script (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_get_instance_base_type
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "get_instance_base_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_get_instance_base_type #-}

instance Method "get_instance_base_type" GodotScript
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_get_instance_base_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_has_script_signal
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "has_script_signal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_has_script_signal #-}

instance Method "has_script_signal" GodotScript
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_has_script_signal (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindScript_is_tool
  = unsafePerformIO $
      withCString "Script" $
        \ clsNamePtr ->
          withCString "is_tool" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindScript_is_tool #-}

instance Method "is_tool" GodotScript (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindScript_is_tool (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotWeakRef = GodotWeakRef GodotObject
                         deriving newtype AsVariant

instance HasBaseClass GodotWeakRef where
        type BaseClass GodotWeakRef = GodotReference
        super = coerce
bindWeakRef_get_ref
  = unsafePerformIO $
      withCString "WeakRef" $
        \ clsNamePtr ->
          withCString "get_ref" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindWeakRef_get_ref #-}

instance Method "get_ref" GodotWeakRef (IO GodotVariant) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindWeakRef_get_ref (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotImage = GodotImage GodotObject
                       deriving newtype AsVariant

instance HasBaseClass GodotImage where
        type BaseClass GodotImage = GodotResource
        super = coerce
bindImage_get_width
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_width" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_width #-}

instance Method "get_width" GodotImage (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_width (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_height
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_height" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_height #-}

instance Method "get_height" GodotImage (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_height (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_size
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_size #-}

instance Method "get_size" GodotImage (IO GodotVector2) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_size (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_has_mipmaps
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "has_mipmaps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_has_mipmaps #-}

instance Method "has_mipmaps" GodotImage (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_has_mipmaps (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_format
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_format" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_format #-}

instance Method "get_format" GodotImage (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_format (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_data
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_data #-}

instance Method "get_data" GodotImage (IO GodotPoolByteArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_data (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_convert
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "convert" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_convert #-}

instance Method "convert" GodotImage (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_convert (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_mipmap_offset
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_mipmap_offset" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_mipmap_offset #-}

instance Method "get_mipmap_offset" GodotImage (Int -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_mipmap_offset (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_resize_to_po2
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "resize_to_po2" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_resize_to_po2 #-}

instance Method "resize_to_po2" GodotImage (Bool -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_resize_to_po2 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_resize
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "resize" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_resize #-}

instance Method "resize" GodotImage (Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_resize (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_shrink_x2
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "shrink_x2" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_shrink_x2 #-}

instance Method "shrink_x2" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_shrink_x2 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_expand_x2_hq2x
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "expand_x2_hq2x" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_expand_x2_hq2x #-}

instance Method "expand_x2_hq2x" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_expand_x2_hq2x (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_crop
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "crop" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_crop #-}

instance Method "crop" GodotImage (Int -> Int -> IO ()) where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_crop (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_flip_x
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "flip_x" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_flip_x #-}

instance Method "flip_x" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_flip_x (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_flip_y
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "flip_y" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_flip_y #-}

instance Method "flip_y" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_flip_y (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_generate_mipmaps
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "generate_mipmaps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_generate_mipmaps #-}

instance Method "generate_mipmaps" GodotImage (Bool -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_generate_mipmaps (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_clear_mipmaps
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "clear_mipmaps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_clear_mipmaps #-}

instance Method "clear_mipmaps" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_clear_mipmaps (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_create
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_create #-}

instance Method "create" GodotImage
           (Int -> Int -> Bool -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_create (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_create_from_data
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "create_from_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_create_from_data #-}

instance Method "create_from_data" GodotImage
           (Int -> Int -> Bool -> Int -> GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_create_from_data (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_is_empty
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "is_empty" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_is_empty #-}

instance Method "is_empty" GodotImage (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_is_empty (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_load
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "load" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_load #-}

instance Method "load" GodotImage (GodotString -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_load (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_save_png
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "save_png" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_save_png #-}

instance Method "save_png" GodotImage (GodotString -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_save_png (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_detect_alpha
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "detect_alpha" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_detect_alpha #-}

instance Method "detect_alpha" GodotImage (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_detect_alpha (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_is_invisible
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "is_invisible" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_is_invisible #-}

instance Method "is_invisible" GodotImage (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_is_invisible (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_compress
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "compress" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_compress #-}

instance Method "compress" GodotImage
           (Int -> Int -> Float -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_compress (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_decompress
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "decompress" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_decompress #-}

instance Method "decompress" GodotImage (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_decompress (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_is_compressed
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "is_compressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_is_compressed #-}

instance Method "is_compressed" GodotImage (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_is_compressed (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_fix_alpha_edges
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "fix_alpha_edges" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_fix_alpha_edges #-}

instance Method "fix_alpha_edges" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_fix_alpha_edges (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_premultiply_alpha
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "premultiply_alpha" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_premultiply_alpha #-}

instance Method "premultiply_alpha" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_premultiply_alpha (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_srgb_to_linear
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "srgb_to_linear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_srgb_to_linear #-}

instance Method "srgb_to_linear" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_srgb_to_linear (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_normalmap_to_xy
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "normalmap_to_xy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_normalmap_to_xy #-}

instance Method "normalmap_to_xy" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_normalmap_to_xy (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_rgbe_to_srgb
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "rgbe_to_srgb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_rgbe_to_srgb #-}

instance Method "rgbe_to_srgb" GodotImage (IO GodotImage) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_rgbe_to_srgb (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_bumpmap_to_normalmap
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "bumpmap_to_normalmap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_bumpmap_to_normalmap #-}

instance Method "bumpmap_to_normalmap" GodotImage (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_bumpmap_to_normalmap (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_blit_rect
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "blit_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_blit_rect #-}

instance Method "blit_rect" GodotImage
           (GodotImage -> GodotRect2 -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_blit_rect (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_blit_rect_mask
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "blit_rect_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_blit_rect_mask #-}

instance Method "blit_rect_mask" GodotImage
           (GodotImage -> GodotImage -> GodotRect2 -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_blit_rect_mask (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_blend_rect
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "blend_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_blend_rect #-}

instance Method "blend_rect" GodotImage
           (GodotImage -> GodotRect2 -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_blend_rect (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_blend_rect_mask
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "blend_rect_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_blend_rect_mask #-}

instance Method "blend_rect_mask" GodotImage
           (GodotImage -> GodotImage -> GodotRect2 -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_blend_rect_mask (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_fill
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "fill" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_fill #-}

instance Method "fill" GodotImage (GodotColor -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_fill (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_used_rect
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_used_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_used_rect #-}

instance Method "get_used_rect" GodotImage (IO GodotRect2) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_used_rect (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_rect
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_rect #-}

instance Method "get_rect" GodotImage (GodotRect2 -> IO GodotImage)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_rect (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_copy_from
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "copy_from" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_copy_from #-}

instance Method "copy_from" GodotImage (GodotImage -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_copy_from (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage__set_data
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "_set_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage__set_data #-}

instance Method "_set_data" GodotImage (GodotDictionary -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage__set_data (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage__get_data
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "_get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage__get_data #-}

instance Method "_get_data" GodotImage (IO GodotDictionary) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage__get_data (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_lock
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "lock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_lock #-}

instance Method "lock" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_lock (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_unlock
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "unlock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_unlock #-}

instance Method "unlock" GodotImage (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_unlock (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_pixelv
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_pixelv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_pixelv #-}

instance Method "get_pixelv" GodotImage
           (GodotVector2 -> IO GodotColor)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_pixelv (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_get_pixel
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "get_pixel" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_get_pixel #-}

instance Method "get_pixel" GodotImage
           (Int -> Int -> IO GodotColor)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_get_pixel (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_set_pixelv
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "set_pixelv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_set_pixelv #-}

instance Method "set_pixelv" GodotImage
           (GodotVector2 -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_set_pixelv (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_set_pixel
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "set_pixel" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_set_pixel #-}

instance Method "set_pixel" GodotImage
           (Int -> Int -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_set_pixel (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_load_png_from_buffer
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "load_png_from_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_load_png_from_buffer #-}

instance Method "load_png_from_buffer" GodotImage
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_load_png_from_buffer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_load_jpg_from_buffer
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "load_jpg_from_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_load_jpg_from_buffer #-}

instance Method "load_jpg_from_buffer" GodotImage
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_load_jpg_from_buffer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindImage_load_webp_from_buffer
  = unsafePerformIO $
      withCString "Image" $
        \ clsNamePtr ->
          withCString "load_webp_from_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindImage_load_webp_from_buffer #-}

instance Method "load_webp_from_buffer" GodotImage
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindImage_load_webp_from_buffer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEvent = GodotInputEvent GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotInputEvent where
        type BaseClass GodotInputEvent = GodotResource
        super = coerce
bindInputEvent_set_device
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "set_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_set_device #-}

instance Method "set_device" GodotInputEvent (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_set_device (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_get_device
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "get_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_get_device #-}

instance Method "get_device" GodotInputEvent (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_get_device (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_action
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_action #-}

instance Method "is_action" GodotInputEvent
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_action (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_action_pressed
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_action_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_action_pressed #-}

instance Method "is_action_pressed" GodotInputEvent
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_action_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_action_released
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_action_released" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_action_released #-}

instance Method "is_action_released" GodotInputEvent
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_action_released
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_get_action_strength
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "get_action_strength" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_get_action_strength #-}

instance Method "get_action_strength" GodotInputEvent
           (GodotString -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_get_action_strength
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_pressed
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_pressed #-}

instance Method "is_pressed" GodotInputEvent (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_echo
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_echo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_echo #-}

instance Method "is_echo" GodotInputEvent (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_echo (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_as_text
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "as_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_as_text #-}

instance Method "as_text" GodotInputEvent (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_as_text (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_shortcut_match
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "shortcut_match" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_shortcut_match #-}

instance Method "shortcut_match" GodotInputEvent
           (GodotInputEvent -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_shortcut_match (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_is_action_type
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "is_action_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_is_action_type #-}

instance Method "is_action_type" GodotInputEvent (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_is_action_type (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEvent_xformed_by
  = unsafePerformIO $
      withCString "InputEvent" $
        \ clsNamePtr ->
          withCString "xformed_by" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEvent_xformed_by #-}

instance Method "xformed_by" GodotInputEvent
           (GodotTransform2d -> GodotVector2 -> IO GodotInputEvent)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEvent_xformed_by (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventWithModifiers = GodotInputEventWithModifiers GodotObject
                                         deriving newtype AsVariant

instance HasBaseClass GodotInputEventWithModifiers where
        type BaseClass GodotInputEventWithModifiers = GodotInputEvent
        super = coerce
bindInputEventWithModifiers_set_alt
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "set_alt" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_set_alt #-}

instance Method "set_alt" GodotInputEventWithModifiers
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_set_alt
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_get_alt
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "get_alt" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_get_alt #-}

instance Method "get_alt" GodotInputEventWithModifiers (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_get_alt
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_set_shift
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "set_shift" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_set_shift #-}

instance Method "set_shift" GodotInputEventWithModifiers
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_set_shift
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_get_shift
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "get_shift" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_get_shift #-}

instance Method "get_shift" GodotInputEventWithModifiers (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_get_shift
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_set_control
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "set_control" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_set_control #-}

instance Method "set_control" GodotInputEventWithModifiers
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_set_control
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_get_control
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "get_control" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_get_control #-}

instance Method "get_control" GodotInputEventWithModifiers
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_get_control
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_set_metakey
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "set_metakey" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_set_metakey #-}

instance Method "set_metakey" GodotInputEventWithModifiers
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_set_metakey
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_get_metakey
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "get_metakey" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_get_metakey #-}

instance Method "get_metakey" GodotInputEventWithModifiers
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_get_metakey
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_set_command
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "set_command" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_set_command #-}

instance Method "set_command" GodotInputEventWithModifiers
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_set_command
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventWithModifiers_get_command
  = unsafePerformIO $
      withCString "InputEventWithModifiers" $
        \ clsNamePtr ->
          withCString "get_command" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventWithModifiers_get_command #-}

instance Method "get_command" GodotInputEventWithModifiers
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventWithModifiers_get_command
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventKey = GodotInputEventKey GodotObject
                               deriving newtype AsVariant

instance HasBaseClass GodotInputEventKey where
        type BaseClass GodotInputEventKey = GodotInputEventWithModifiers
        super = coerce
bindInputEventKey_is_pressed
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_is_pressed #-}

instance Method "is_pressed" GodotInputEventKey (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_is_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_is_echo
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "is_echo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_is_echo #-}

instance Method "is_echo" GodotInputEventKey (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_is_echo (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_set_pressed
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "set_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_set_pressed #-}

instance Method "set_pressed" GodotInputEventKey (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_set_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_set_scancode
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "set_scancode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_set_scancode #-}

instance Method "set_scancode" GodotInputEventKey (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_set_scancode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_get_scancode
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "get_scancode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_get_scancode #-}

instance Method "get_scancode" GodotInputEventKey (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_get_scancode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_set_unicode
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "set_unicode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_set_unicode #-}

instance Method "set_unicode" GodotInputEventKey (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_set_unicode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_get_unicode
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "get_unicode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_get_unicode #-}

instance Method "get_unicode" GodotInputEventKey (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_get_unicode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_set_echo
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "set_echo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_set_echo #-}

instance Method "set_echo" GodotInputEventKey (Bool -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventKey_set_echo (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventKey_get_scancode_with_modifiers
  = unsafePerformIO $
      withCString "InputEventKey" $
        \ clsNamePtr ->
          withCString "get_scancode_with_modifiers" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventKey_get_scancode_with_modifiers #-}

instance Method "get_scancode_with_modifiers" GodotInputEventKey
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindInputEventKey_get_scancode_with_modifiers
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventMouse = GodotInputEventMouse GodotObject
                                 deriving newtype AsVariant

instance HasBaseClass GodotInputEventMouse where
        type BaseClass GodotInputEventMouse = GodotInputEventWithModifiers
        super = coerce
bindInputEventMouse_set_button_mask
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "set_button_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_set_button_mask #-}

instance Method "set_button_mask" GodotInputEventMouse
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_set_button_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouse_get_button_mask
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "get_button_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_get_button_mask #-}

instance Method "get_button_mask" GodotInputEventMouse (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_get_button_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouse_set_position
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "set_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_set_position #-}

instance Method "set_position" GodotInputEventMouse
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_set_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouse_get_position
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_get_position #-}

instance Method "get_position" GodotInputEventMouse
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_get_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouse_set_global_position
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "set_global_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_set_global_position #-}

instance Method "set_global_position" GodotInputEventMouse
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_set_global_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouse_get_global_position
  = unsafePerformIO $
      withCString "InputEventMouse" $
        \ clsNamePtr ->
          withCString "get_global_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouse_get_global_position #-}

instance Method "get_global_position" GodotInputEventMouse
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouse_get_global_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventMouseButton = GodotInputEventMouseButton GodotObject
                                       deriving newtype AsVariant

instance HasBaseClass GodotInputEventMouseButton where
        type BaseClass GodotInputEventMouseButton = GodotInputEventMouse
        super = coerce
bindInputEventMouseButton_is_pressed
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_is_pressed #-}

instance Method "is_pressed" GodotInputEventMouseButton (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_is_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_set_factor
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "set_factor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_set_factor #-}

instance Method "set_factor" GodotInputEventMouseButton
           (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_set_factor
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_get_factor
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "get_factor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_get_factor #-}

instance Method "get_factor" GodotInputEventMouseButton (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_get_factor
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_set_button_index
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "set_button_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_set_button_index #-}

instance Method "set_button_index" GodotInputEventMouseButton
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_set_button_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_get_button_index
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "get_button_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_get_button_index #-}

instance Method "get_button_index" GodotInputEventMouseButton
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_get_button_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_set_pressed
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "set_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_set_pressed #-}

instance Method "set_pressed" GodotInputEventMouseButton
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_set_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_set_doubleclick
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "set_doubleclick" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_set_doubleclick #-}

instance Method "set_doubleclick" GodotInputEventMouseButton
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_set_doubleclick
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseButton_is_doubleclick
  = unsafePerformIO $
      withCString "InputEventMouseButton" $
        \ clsNamePtr ->
          withCString "is_doubleclick" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseButton_is_doubleclick #-}

instance Method "is_doubleclick" GodotInputEventMouseButton
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseButton_is_doubleclick
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventMouseMotion = GodotInputEventMouseMotion GodotObject
                                       deriving newtype AsVariant

instance HasBaseClass GodotInputEventMouseMotion where
        type BaseClass GodotInputEventMouseMotion = GodotInputEventMouse
        super = coerce
bindInputEventMouseMotion_set_relative
  = unsafePerformIO $
      withCString "InputEventMouseMotion" $
        \ clsNamePtr ->
          withCString "set_relative" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseMotion_set_relative #-}

instance Method "set_relative" GodotInputEventMouseMotion
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseMotion_set_relative
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseMotion_get_relative
  = unsafePerformIO $
      withCString "InputEventMouseMotion" $
        \ clsNamePtr ->
          withCString "get_relative" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseMotion_get_relative #-}

instance Method "get_relative" GodotInputEventMouseMotion
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseMotion_get_relative
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseMotion_set_speed
  = unsafePerformIO $
      withCString "InputEventMouseMotion" $
        \ clsNamePtr ->
          withCString "set_speed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseMotion_set_speed #-}

instance Method "set_speed" GodotInputEventMouseMotion
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseMotion_set_speed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMouseMotion_get_speed
  = unsafePerformIO $
      withCString "InputEventMouseMotion" $
        \ clsNamePtr ->
          withCString "get_speed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMouseMotion_get_speed #-}

instance Method "get_speed" GodotInputEventMouseMotion
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMouseMotion_get_speed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventJoypadButton = GodotInputEventJoypadButton GodotObject
                                        deriving newtype AsVariant

instance HasBaseClass GodotInputEventJoypadButton where
        type BaseClass GodotInputEventJoypadButton = GodotInputEvent
        super = coerce
bindInputEventJoypadButton_is_pressed
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_is_pressed #-}

instance Method "is_pressed" GodotInputEventJoypadButton (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_is_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadButton_set_button_index
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "set_button_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_set_button_index #-}

instance Method "set_button_index" GodotInputEventJoypadButton
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_set_button_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadButton_get_button_index
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "get_button_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_get_button_index #-}

instance Method "get_button_index" GodotInputEventJoypadButton
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_get_button_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadButton_set_pressure
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "set_pressure" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_set_pressure #-}

instance Method "set_pressure" GodotInputEventJoypadButton
           (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_set_pressure
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadButton_get_pressure
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "get_pressure" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_get_pressure #-}

instance Method "get_pressure" GodotInputEventJoypadButton
           (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_get_pressure
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadButton_set_pressed
  = unsafePerformIO $
      withCString "InputEventJoypadButton" $
        \ clsNamePtr ->
          withCString "set_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadButton_set_pressed #-}

instance Method "set_pressed" GodotInputEventJoypadButton
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadButton_set_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventJoypadMotion = GodotInputEventJoypadMotion GodotObject
                                        deriving newtype AsVariant

instance HasBaseClass GodotInputEventJoypadMotion where
        type BaseClass GodotInputEventJoypadMotion = GodotInputEvent
        super = coerce
bindInputEventJoypadMotion_set_axis
  = unsafePerformIO $
      withCString "InputEventJoypadMotion" $
        \ clsNamePtr ->
          withCString "set_axis" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadMotion_set_axis #-}

instance Method "set_axis" GodotInputEventJoypadMotion
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadMotion_set_axis
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadMotion_get_axis
  = unsafePerformIO $
      withCString "InputEventJoypadMotion" $
        \ clsNamePtr ->
          withCString "get_axis" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadMotion_get_axis #-}

instance Method "get_axis" GodotInputEventJoypadMotion (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadMotion_get_axis
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadMotion_set_axis_value
  = unsafePerformIO $
      withCString "InputEventJoypadMotion" $
        \ clsNamePtr ->
          withCString "set_axis_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadMotion_set_axis_value #-}

instance Method "set_axis_value" GodotInputEventJoypadMotion
           (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadMotion_set_axis_value
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventJoypadMotion_get_axis_value
  = unsafePerformIO $
      withCString "InputEventJoypadMotion" $
        \ clsNamePtr ->
          withCString "get_axis_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventJoypadMotion_get_axis_value #-}

instance Method "get_axis_value" GodotInputEventJoypadMotion
           (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventJoypadMotion_get_axis_value
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventScreenDrag = GodotInputEventScreenDrag GodotObject
                                      deriving newtype AsVariant

instance HasBaseClass GodotInputEventScreenDrag where
        type BaseClass GodotInputEventScreenDrag = GodotInputEvent
        super = coerce
bindInputEventScreenDrag_set_index
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "set_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_set_index #-}

instance Method "set_index" GodotInputEventScreenDrag
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_set_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_get_index
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "get_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_get_index #-}

instance Method "get_index" GodotInputEventScreenDrag (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_get_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_set_position
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "set_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_set_position #-}

instance Method "set_position" GodotInputEventScreenDrag
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_set_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_get_position
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_get_position #-}

instance Method "get_position" GodotInputEventScreenDrag
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_get_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_set_relative
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "set_relative" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_set_relative #-}

instance Method "set_relative" GodotInputEventScreenDrag
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_set_relative
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_get_relative
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "get_relative" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_get_relative #-}

instance Method "get_relative" GodotInputEventScreenDrag
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_get_relative
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_set_speed
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "set_speed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_set_speed #-}

instance Method "set_speed" GodotInputEventScreenDrag
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_set_speed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenDrag_get_speed
  = unsafePerformIO $
      withCString "InputEventScreenDrag" $
        \ clsNamePtr ->
          withCString "get_speed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenDrag_get_speed #-}

instance Method "get_speed" GodotInputEventScreenDrag
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenDrag_get_speed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventScreenTouch = GodotInputEventScreenTouch GodotObject
                                       deriving newtype AsVariant

instance HasBaseClass GodotInputEventScreenTouch where
        type BaseClass GodotInputEventScreenTouch = GodotInputEvent
        super = coerce
bindInputEventScreenTouch_is_pressed
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_is_pressed #-}

instance Method "is_pressed" GodotInputEventScreenTouch (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_is_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenTouch_set_index
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "set_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_set_index #-}

instance Method "set_index" GodotInputEventScreenTouch
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_set_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenTouch_get_index
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "get_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_get_index #-}

instance Method "get_index" GodotInputEventScreenTouch (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_get_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenTouch_set_position
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "set_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_set_position #-}

instance Method "set_position" GodotInputEventScreenTouch
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_set_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenTouch_get_position
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_get_position #-}

instance Method "get_position" GodotInputEventScreenTouch
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_get_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventScreenTouch_set_pressed
  = unsafePerformIO $
      withCString "InputEventScreenTouch" $
        \ clsNamePtr ->
          withCString "set_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventScreenTouch_set_pressed #-}

instance Method "set_pressed" GodotInputEventScreenTouch
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventScreenTouch_set_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventAction = GodotInputEventAction GodotObject
                                  deriving newtype AsVariant

instance HasBaseClass GodotInputEventAction where
        type BaseClass GodotInputEventAction = GodotInputEvent
        super = coerce
bindInputEventAction_is_pressed
  = unsafePerformIO $
      withCString "InputEventAction" $
        \ clsNamePtr ->
          withCString "is_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventAction_is_pressed #-}

instance Method "is_pressed" GodotInputEventAction (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventAction_is_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventAction_set_action
  = unsafePerformIO $
      withCString "InputEventAction" $
        \ clsNamePtr ->
          withCString "set_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventAction_set_action #-}

instance Method "set_action" GodotInputEventAction
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventAction_set_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventAction_get_action
  = unsafePerformIO $
      withCString "InputEventAction" $
        \ clsNamePtr ->
          withCString "get_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventAction_get_action #-}

instance Method "get_action" GodotInputEventAction (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventAction_get_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventAction_set_pressed
  = unsafePerformIO $
      withCString "InputEventAction" $
        \ clsNamePtr ->
          withCString "set_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventAction_set_pressed #-}

instance Method "set_pressed" GodotInputEventAction (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventAction_set_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventGesture = GodotInputEventGesture GodotObject
                                   deriving newtype AsVariant

instance HasBaseClass GodotInputEventGesture where
        type BaseClass GodotInputEventGesture =
             GodotInputEventWithModifiers
        super = coerce
bindInputEventGesture_set_position
  = unsafePerformIO $
      withCString "InputEventGesture" $
        \ clsNamePtr ->
          withCString "set_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventGesture_set_position #-}

instance Method "set_position" GodotInputEventGesture
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventGesture_set_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventGesture_get_position
  = unsafePerformIO $
      withCString "InputEventGesture" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventGesture_get_position #-}

instance Method "get_position" GodotInputEventGesture
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventGesture_get_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventMagnifyGesture = GodotInputEventMagnifyGesture GodotObject
                                          deriving newtype AsVariant

instance HasBaseClass GodotInputEventMagnifyGesture where
        type BaseClass GodotInputEventMagnifyGesture =
             GodotInputEventGesture
        super = coerce
bindInputEventMagnifyGesture_set_factor
  = unsafePerformIO $
      withCString "InputEventMagnifyGesture" $
        \ clsNamePtr ->
          withCString "set_factor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMagnifyGesture_set_factor #-}

instance Method "set_factor" GodotInputEventMagnifyGesture
           (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMagnifyGesture_set_factor
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventMagnifyGesture_get_factor
  = unsafePerformIO $
      withCString "InputEventMagnifyGesture" $
        \ clsNamePtr ->
          withCString "get_factor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventMagnifyGesture_get_factor #-}

instance Method "get_factor" GodotInputEventMagnifyGesture
           (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventMagnifyGesture_get_factor
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputEventPanGesture = GodotInputEventPanGesture GodotObject
                                      deriving newtype AsVariant

instance HasBaseClass GodotInputEventPanGesture where
        type BaseClass GodotInputEventPanGesture = GodotInputEventGesture
        super = coerce
bindInputEventPanGesture_set_delta
  = unsafePerformIO $
      withCString "InputEventPanGesture" $
        \ clsNamePtr ->
          withCString "set_delta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventPanGesture_set_delta #-}

instance Method "set_delta" GodotInputEventPanGesture
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventPanGesture_set_delta
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputEventPanGesture_get_delta
  = unsafePerformIO $
      withCString "InputEventPanGesture" $
        \ clsNamePtr ->
          withCString "get_delta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputEventPanGesture_get_delta #-}

instance Method "get_delta" GodotInputEventPanGesture
           (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputEventPanGesture_get_delta
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotFuncRef = GodotFuncRef GodotObject
                         deriving newtype AsVariant

instance HasBaseClass GodotFuncRef where
        type BaseClass GodotFuncRef = GodotReference
        super = coerce
bindFuncRef_set_instance
  = unsafePerformIO $
      withCString "FuncRef" $
        \ clsNamePtr ->
          withCString "set_instance" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindFuncRef_set_instance #-}

instance Method "set_instance" GodotFuncRef (GodotObject -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindFuncRef_set_instance (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindFuncRef_set_function
  = unsafePerformIO $
      withCString "FuncRef" $
        \ clsNamePtr ->
          withCString "set_function" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindFuncRef_set_function #-}

instance Method "set_function" GodotFuncRef (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindFuncRef_set_function (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotStreamPeer = GodotStreamPeer GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotStreamPeer where
        type BaseClass GodotStreamPeer = GodotReference
        super = coerce
bindStreamPeer_put_data
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_data #-}

instance Method "put_data" GodotStreamPeer
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_data (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_partial_data
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_partial_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_partial_data #-}

instance Method "put_partial_data" GodotStreamPeer
           (GodotPoolByteArray -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_partial_data (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_data
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_data #-}

instance Method "get_data" GodotStreamPeer (Int -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_data (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_partial_data
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_partial_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_partial_data #-}

instance Method "get_partial_data" GodotStreamPeer
           (Int -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_partial_data (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_available_bytes
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_available_bytes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_available_bytes #-}

instance Method "get_available_bytes" GodotStreamPeer (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_available_bytes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_set_big_endian
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "set_big_endian" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_set_big_endian #-}

instance Method "set_big_endian" GodotStreamPeer (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_set_big_endian (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_is_big_endian_enabled
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "is_big_endian_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_is_big_endian_enabled #-}

instance Method "is_big_endian_enabled" GodotStreamPeer (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_is_big_endian_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_8
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_8 #-}

instance Method "put_8" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_8 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_u8
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_u8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_u8 #-}

instance Method "put_u8" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_u8 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_16
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_16 #-}

instance Method "put_16" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_16 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_u16
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_u16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_u16 #-}

instance Method "put_u16" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_u16 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_32
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_32 #-}

instance Method "put_32" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_32 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_u32
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_u32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_u32 #-}

instance Method "put_u32" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_u32 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_64
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_64 #-}

instance Method "put_64" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_64 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_u64
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_u64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_u64 #-}

instance Method "put_u64" GodotStreamPeer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_u64 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_float
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_float" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_float #-}

instance Method "put_float" GodotStreamPeer (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_float (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_double
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_double" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_double #-}

instance Method "put_double" GodotStreamPeer (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_double (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_string
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_string #-}

instance Method "put_string" GodotStreamPeer (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_utf8_string
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_utf8_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_utf8_string #-}

instance Method "put_utf8_string" GodotStreamPeer
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_utf8_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_put_var
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "put_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_put_var #-}

instance Method "put_var" GodotStreamPeer (GodotVariant -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_put_var (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_8
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_8 #-}

instance Method "get_8" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_8 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_u8
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_u8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_u8 #-}

instance Method "get_u8" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_u8 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_16
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_16 #-}

instance Method "get_16" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_16 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_u16
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_u16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_u16 #-}

instance Method "get_u16" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_u16 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_32
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_32 #-}

instance Method "get_32" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_32 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_u32
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_u32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_u32 #-}

instance Method "get_u32" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_u32 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_64
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_64 #-}

instance Method "get_64" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_64 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_u64
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_u64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_u64 #-}

instance Method "get_u64" GodotStreamPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_u64 (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_float
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_float" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_float #-}

instance Method "get_float" GodotStreamPeer (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_float (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_double
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_double" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_double #-}

instance Method "get_double" GodotStreamPeer (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_double (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_string
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_string #-}

instance Method "get_string" GodotStreamPeer
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_utf8_string
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_utf8_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_utf8_string #-}

instance Method "get_utf8_string" GodotStreamPeer
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_utf8_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeer_get_var
  = unsafePerformIO $
      withCString "StreamPeer" $
        \ clsNamePtr ->
          withCString "get_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeer_get_var #-}

instance Method "get_var" GodotStreamPeer (IO GodotVariant) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeer_get_var (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotStreamPeerBuffer = GodotStreamPeerBuffer GodotObject
                                  deriving newtype AsVariant

instance HasBaseClass GodotStreamPeerBuffer where
        type BaseClass GodotStreamPeerBuffer = GodotStreamPeer
        super = coerce
bindStreamPeerBuffer_seek
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "seek" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_seek #-}

instance Method "seek" GodotStreamPeerBuffer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_seek (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_get_size
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "get_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_get_size #-}

instance Method "get_size" GodotStreamPeerBuffer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_get_size (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_get_position
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_get_position #-}

instance Method "get_position" GodotStreamPeerBuffer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_get_position
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_resize
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "resize" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_resize #-}

instance Method "resize" GodotStreamPeerBuffer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_resize (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_set_data_array
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "set_data_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_set_data_array #-}

instance Method "set_data_array" GodotStreamPeerBuffer
           (GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_set_data_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_get_data_array
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "get_data_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_get_data_array #-}

instance Method "get_data_array" GodotStreamPeerBuffer
           (IO GodotPoolByteArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_get_data_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_clear
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_clear #-}

instance Method "clear" GodotStreamPeerBuffer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_clear (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerBuffer_duplicate
  = unsafePerformIO $
      withCString "StreamPeerBuffer" $
        \ clsNamePtr ->
          withCString "duplicate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerBuffer_duplicate #-}

instance Method "duplicate" GodotStreamPeerBuffer
           (IO GodotStreamPeerBuffer)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerBuffer_duplicate (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotStreamPeerTCP = GodotStreamPeerTCP GodotObject
                               deriving newtype AsVariant

instance HasBaseClass GodotStreamPeerTCP where
        type BaseClass GodotStreamPeerTCP = GodotStreamPeer
        super = coerce
bindStreamPeerTCP_connect_to_host
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "connect_to_host" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_connect_to_host #-}

instance Method "connect_to_host" GodotStreamPeerTCP
           (GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_connect_to_host
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_is_connected_to_host
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "is_connected_to_host" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_is_connected_to_host #-}

instance Method "is_connected_to_host" GodotStreamPeerTCP (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_is_connected_to_host
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_get_status
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "get_status" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_get_status #-}

instance Method "get_status" GodotStreamPeerTCP (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_get_status (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_get_connected_host
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "get_connected_host" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_get_connected_host #-}

instance Method "get_connected_host" GodotStreamPeerTCP
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_get_connected_host
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_get_connected_port
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "get_connected_port" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_get_connected_port #-}

instance Method "get_connected_port" GodotStreamPeerTCP (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_get_connected_port
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_disconnect_from_host
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "disconnect_from_host" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_disconnect_from_host #-}

instance Method "disconnect_from_host" GodotStreamPeerTCP (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_disconnect_from_host
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerTCP_set_no_delay
  = unsafePerformIO $
      withCString "StreamPeerTCP" $
        \ clsNamePtr ->
          withCString "set_no_delay" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerTCP_set_no_delay #-}

instance Method "set_no_delay" GodotStreamPeerTCP (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerTCP_set_no_delay (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotTCP_Server = GodotTCP_Server GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotTCP_Server where
        type BaseClass GodotTCP_Server = GodotReference
        super = coerce
bindTCP_Server_listen
  = unsafePerformIO $
      withCString "TCP_Server" $
        \ clsNamePtr ->
          withCString "listen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTCP_Server_listen #-}

instance Method "listen" GodotTCP_Server
           (Int -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTCP_Server_listen (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTCP_Server_is_connection_available
  = unsafePerformIO $
      withCString "TCP_Server" $
        \ clsNamePtr ->
          withCString "is_connection_available" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTCP_Server_is_connection_available #-}

instance Method "is_connection_available" GodotTCP_Server (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTCP_Server_is_connection_available
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTCP_Server_take_connection
  = unsafePerformIO $
      withCString "TCP_Server" $
        \ clsNamePtr ->
          withCString "take_connection" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTCP_Server_take_connection #-}

instance Method "take_connection" GodotTCP_Server
           (IO GodotStreamPeerTCP)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTCP_Server_take_connection (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTCP_Server_stop
  = unsafePerformIO $
      withCString "TCP_Server" $
        \ clsNamePtr ->
          withCString "stop" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTCP_Server_stop #-}

instance Method "stop" GodotTCP_Server (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTCP_Server_stop (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPacketPeer = GodotPacketPeer GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotPacketPeer where
        type BaseClass GodotPacketPeer = GodotReference
        super = coerce
bindPacketPeer_get_var
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "get_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_get_var #-}

instance Method "get_var" GodotPacketPeer (IO GodotVariant) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_get_var (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_put_var
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "put_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_put_var #-}

instance Method "put_var" GodotPacketPeer (GodotVariant -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_put_var (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_get_packet
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "get_packet" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_get_packet #-}

instance Method "get_packet" GodotPacketPeer
           (IO GodotPoolByteArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_get_packet (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_put_packet
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "put_packet" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_put_packet #-}

instance Method "put_packet" GodotPacketPeer
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_put_packet (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_get_packet_error
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "get_packet_error" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_get_packet_error #-}

instance Method "get_packet_error" GodotPacketPeer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_get_packet_error (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_get_available_packet_count
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "get_available_packet_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_get_available_packet_count #-}

instance Method "get_available_packet_count" GodotPacketPeer
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_get_available_packet_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_set_allow_object_decoding
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "set_allow_object_decoding" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_set_allow_object_decoding #-}

instance Method "set_allow_object_decoding" GodotPacketPeer
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_set_allow_object_decoding
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeer_is_object_decoding_allowed
  = unsafePerformIO $
      withCString "PacketPeer" $
        \ clsNamePtr ->
          withCString "is_object_decoding_allowed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeer_is_object_decoding_allowed #-}

instance Method "is_object_decoding_allowed" GodotPacketPeer
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeer_is_object_decoding_allowed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPacketPeerUDP = GodotPacketPeerUDP GodotObject
                               deriving newtype AsVariant

instance HasBaseClass GodotPacketPeerUDP where
        type BaseClass GodotPacketPeerUDP = GodotPacketPeer
        super = coerce
bindPacketPeerUDP_listen
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "listen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_listen #-}

instance Method "listen" GodotPacketPeerUDP
           (Int -> GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_listen (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_close
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "close" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_close #-}

instance Method "close" GodotPacketPeerUDP (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_close (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_wait
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "wait" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_wait #-}

instance Method "wait" GodotPacketPeerUDP (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_wait (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_is_listening
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "is_listening" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_is_listening #-}

instance Method "is_listening" GodotPacketPeerUDP (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_is_listening (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_get_packet_ip
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "get_packet_ip" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_get_packet_ip #-}

instance Method "get_packet_ip" GodotPacketPeerUDP (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_get_packet_ip (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_get_packet_port
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "get_packet_port" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_get_packet_port #-}

instance Method "get_packet_port" GodotPacketPeerUDP (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_get_packet_port
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerUDP_set_dest_address
  = unsafePerformIO $
      withCString "PacketPeerUDP" $
        \ clsNamePtr ->
          withCString "set_dest_address" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerUDP_set_dest_address #-}

instance Method "set_dest_address" GodotPacketPeerUDP
           (GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerUDP_set_dest_address
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotStreamPeerSSL = GodotStreamPeerSSL GodotObject
                               deriving newtype AsVariant

instance HasBaseClass GodotStreamPeerSSL where
        type BaseClass GodotStreamPeerSSL = GodotStreamPeer
        super = coerce
bindStreamPeerSSL_poll
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "poll" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_poll #-}

instance Method "poll" GodotStreamPeerSSL (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerSSL_poll (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_accept_stream
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "accept_stream" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_accept_stream #-}

instance Method "accept_stream" GodotStreamPeerSSL
           (GodotStreamPeer -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerSSL_accept_stream (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_connect_to_stream
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "connect_to_stream" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_connect_to_stream #-}

instance Method "connect_to_stream" GodotStreamPeerSSL
           (GodotStreamPeer -> Bool -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerSSL_connect_to_stream
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_get_status
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "get_status" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_get_status #-}

instance Method "get_status" GodotStreamPeerSSL (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerSSL_get_status (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_disconnect_from_stream
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "disconnect_from_stream" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_disconnect_from_stream #-}

instance Method "disconnect_from_stream" GodotStreamPeerSSL (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindStreamPeerSSL_disconnect_from_stream
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_set_blocking_handshake_enabled
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "set_blocking_handshake_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_set_blocking_handshake_enabled #-}

instance Method "set_blocking_handshake_enabled" GodotStreamPeerSSL
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindStreamPeerSSL_set_blocking_handshake_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindStreamPeerSSL_is_blocking_handshake_enabled
  = unsafePerformIO $
      withCString "StreamPeerSSL" $
        \ clsNamePtr ->
          withCString "is_blocking_handshake_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindStreamPeerSSL_is_blocking_handshake_enabled #-}

instance Method "is_blocking_handshake_enabled" GodotStreamPeerSSL
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindStreamPeerSSL_is_blocking_handshake_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotIP = GodotIP GodotObject
                    deriving newtype AsVariant

instance HasBaseClass GodotIP where
        type BaseClass GodotIP = GodotObject
        super = coerce
bindIP_resolve_hostname
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "resolve_hostname" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_resolve_hostname #-}

instance Method "resolve_hostname" GodotIP
           (GodotString -> Int -> IO GodotString)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_resolve_hostname (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_resolve_hostname_queue_item
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "resolve_hostname_queue_item" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_resolve_hostname_queue_item #-}

instance Method "resolve_hostname_queue_item" GodotIP
           (GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_resolve_hostname_queue_item
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_get_resolve_item_status
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "get_resolve_item_status" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_get_resolve_item_status #-}

instance Method "get_resolve_item_status" GodotIP (Int -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_get_resolve_item_status (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_get_resolve_item_address
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "get_resolve_item_address" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_get_resolve_item_address #-}

instance Method "get_resolve_item_address" GodotIP
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_get_resolve_item_address (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_erase_resolve_item
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "erase_resolve_item" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_erase_resolve_item #-}

instance Method "erase_resolve_item" GodotIP (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_erase_resolve_item (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_get_local_addresses
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "get_local_addresses" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_get_local_addresses #-}

instance Method "get_local_addresses" GodotIP (IO GodotArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_get_local_addresses (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindIP_clear_cache
  = unsafePerformIO $
      withCString "IP" $
        \ clsNamePtr ->
          withCString "clear_cache" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindIP_clear_cache #-}

instance Method "clear_cache" GodotIP (GodotString -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindIP_clear_cache (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPacketPeerStream = GodotPacketPeerStream GodotObject
                                  deriving newtype AsVariant

instance HasBaseClass GodotPacketPeerStream where
        type BaseClass GodotPacketPeerStream = GodotPacketPeer
        super = coerce
bindPacketPeerStream_set_stream_peer
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "set_stream_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_set_stream_peer #-}

instance Method "set_stream_peer" GodotPacketPeerStream
           (GodotStreamPeer -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerStream_set_stream_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerStream_get_stream_peer
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "get_stream_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_get_stream_peer #-}

instance Method "get_stream_peer" GodotPacketPeerStream
           (IO GodotStreamPeer)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPacketPeerStream_get_stream_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerStream_set_input_buffer_max_size
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "set_input_buffer_max_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_set_input_buffer_max_size #-}

instance Method "set_input_buffer_max_size" GodotPacketPeerStream
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPacketPeerStream_set_input_buffer_max_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerStream_set_output_buffer_max_size
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "set_output_buffer_max_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_set_output_buffer_max_size #-}

instance Method "set_output_buffer_max_size" GodotPacketPeerStream
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPacketPeerStream_set_output_buffer_max_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerStream_get_input_buffer_max_size
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "get_input_buffer_max_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_get_input_buffer_max_size #-}

instance Method "get_input_buffer_max_size" GodotPacketPeerStream
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPacketPeerStream_get_input_buffer_max_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPacketPeerStream_get_output_buffer_max_size
  = unsafePerformIO $
      withCString "PacketPeerStream" $
        \ clsNamePtr ->
          withCString "get_output_buffer_max_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPacketPeerStream_get_output_buffer_max_size #-}

instance Method "get_output_buffer_max_size" GodotPacketPeerStream
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPacketPeerStream_get_output_buffer_max_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotNetworkedMultiplayerPeer = GodotNetworkedMultiplayerPeer GodotObject
                                          deriving newtype AsVariant

instance HasBaseClass GodotNetworkedMultiplayerPeer where
        type BaseClass GodotNetworkedMultiplayerPeer = GodotPacketPeer
        super = coerce
bindNetworkedMultiplayerPeer_set_transfer_mode
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "set_transfer_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_set_transfer_mode #-}

instance Method "set_transfer_mode" GodotNetworkedMultiplayerPeer
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindNetworkedMultiplayerPeer_set_transfer_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_get_transfer_mode
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "get_transfer_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_get_transfer_mode #-}

instance Method "get_transfer_mode" GodotNetworkedMultiplayerPeer
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindNetworkedMultiplayerPeer_get_transfer_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_set_target_peer
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "set_target_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_set_target_peer #-}

instance Method "set_target_peer" GodotNetworkedMultiplayerPeer
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindNetworkedMultiplayerPeer_set_target_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_get_packet_peer
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "get_packet_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_get_packet_peer #-}

instance Method "get_packet_peer" GodotNetworkedMultiplayerPeer
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindNetworkedMultiplayerPeer_get_packet_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_poll
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "poll" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_poll #-}

instance Method "poll" GodotNetworkedMultiplayerPeer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindNetworkedMultiplayerPeer_poll
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_get_connection_status
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "get_connection_status" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_get_connection_status #-}

instance Method "get_connection_status"
           GodotNetworkedMultiplayerPeer
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindNetworkedMultiplayerPeer_get_connection_status
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_get_unique_id
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "get_unique_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_get_unique_id #-}

instance Method "get_unique_id" GodotNetworkedMultiplayerPeer
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindNetworkedMultiplayerPeer_get_unique_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_set_refuse_new_connections
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "set_refuse_new_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_set_refuse_new_connections
             #-}

instance Method "set_refuse_new_connections"
           GodotNetworkedMultiplayerPeer
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindNetworkedMultiplayerPeer_set_refuse_new_connections
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindNetworkedMultiplayerPeer_is_refusing_new_connections
  = unsafePerformIO $
      withCString "NetworkedMultiplayerPeer" $
        \ clsNamePtr ->
          withCString "is_refusing_new_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindNetworkedMultiplayerPeer_is_refusing_new_connections
             #-}

instance Method "is_refusing_new_connections"
           GodotNetworkedMultiplayerPeer
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindNetworkedMultiplayerPeer_is_refusing_new_connections
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotMultiplayerAPI = GodotMultiplayerAPI GodotObject
                                deriving newtype AsVariant

instance HasBaseClass GodotMultiplayerAPI where
        type BaseClass GodotMultiplayerAPI = GodotReference
        super = coerce
bindMultiplayerAPI_set_root_node
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "set_root_node" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_set_root_node #-}

instance Method "set_root_node" GodotMultiplayerAPI
           (GodotObject -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_set_root_node
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_send_bytes
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "send_bytes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_send_bytes #-}

instance Method "send_bytes" GodotMultiplayerAPI
           (GodotPoolByteArray -> Int -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_send_bytes (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_has_network_peer
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "has_network_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_has_network_peer #-}

instance Method "has_network_peer" GodotMultiplayerAPI (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_has_network_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_get_network_peer
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "get_network_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_get_network_peer #-}

instance Method "get_network_peer" GodotMultiplayerAPI
           (IO GodotNetworkedMultiplayerPeer)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_get_network_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_get_network_unique_id
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "get_network_unique_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_get_network_unique_id #-}

instance Method "get_network_unique_id" GodotMultiplayerAPI
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_get_network_unique_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_is_network_server
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "is_network_server" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_is_network_server #-}

instance Method "is_network_server" GodotMultiplayerAPI (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_is_network_server
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_get_rpc_sender_id
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "get_rpc_sender_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_get_rpc_sender_id #-}

instance Method "get_rpc_sender_id" GodotMultiplayerAPI (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_get_rpc_sender_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI__add_peer
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "_add_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI__add_peer #-}

instance Method "_add_peer" GodotMultiplayerAPI (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI__add_peer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI__del_peer
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "_del_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI__del_peer #-}

instance Method "_del_peer" GodotMultiplayerAPI (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI__del_peer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_set_network_peer
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "set_network_peer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_set_network_peer #-}

instance Method "set_network_peer" GodotMultiplayerAPI
           (GodotNetworkedMultiplayerPeer -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_set_network_peer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_poll
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "poll" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_poll #-}

instance Method "poll" GodotMultiplayerAPI (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_poll (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_clear
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_clear #-}

instance Method "clear" GodotMultiplayerAPI (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI_clear (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI__connected_to_server
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "_connected_to_server" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI__connected_to_server #-}

instance Method "_connected_to_server" GodotMultiplayerAPI (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI__connected_to_server
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI__connection_failed
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "_connection_failed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI__connection_failed #-}

instance Method "_connection_failed" GodotMultiplayerAPI (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI__connection_failed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI__server_disconnected
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "_server_disconnected" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI__server_disconnected #-}

instance Method "_server_disconnected" GodotMultiplayerAPI (IO ())
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMultiplayerAPI__server_disconnected
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_get_network_connected_peers
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "get_network_connected_peers" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_get_network_connected_peers #-}

instance Method "get_network_connected_peers" GodotMultiplayerAPI
           (IO GodotPoolIntArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindMultiplayerAPI_get_network_connected_peers
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_set_refuse_new_network_connections
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "set_refuse_new_network_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_set_refuse_new_network_connections
             #-}

instance Method "set_refuse_new_network_connections"
           GodotMultiplayerAPI
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindMultiplayerAPI_set_refuse_new_network_connections
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMultiplayerAPI_is_refusing_new_network_connections
  = unsafePerformIO $
      withCString "MultiplayerAPI" $
        \ clsNamePtr ->
          withCString "is_refusing_new_network_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMultiplayerAPI_is_refusing_new_network_connections
             #-}

instance Method "is_refusing_new_network_connections"
           GodotMultiplayerAPI
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindMultiplayerAPI_is_refusing_new_network_connections
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotMainLoop = GodotMainLoop GodotObject
                          deriving newtype AsVariant

instance HasBaseClass GodotMainLoop where
        type BaseClass GodotMainLoop = GodotObject
        super = coerce
bindMainLoop__input_event
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_input_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__input_event #-}

instance Method "_input_event" GodotMainLoop
           (GodotInputEvent -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__input_event (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__input_text
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_input_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__input_text #-}

instance Method "_input_text" GodotMainLoop (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__input_text (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__initialize
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_initialize" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__initialize #-}

instance Method "_initialize" GodotMainLoop (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__initialize (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__iteration
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_iteration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__iteration #-}

instance Method "_iteration" GodotMainLoop (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__iteration (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__idle
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_idle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__idle #-}

instance Method "_idle" GodotMainLoop (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__idle (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__drop_files
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_drop_files" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__drop_files #-}

instance Method "_drop_files" GodotMainLoop
           (GodotPoolStringArray -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__drop_files (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop__finalize
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "_finalize" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop__finalize #-}

instance Method "_finalize" GodotMainLoop (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop__finalize (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_input_event
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "input_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_input_event #-}

instance Method "input_event" GodotMainLoop
           (GodotInputEvent -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_input_event (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_input_text
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "input_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_input_text #-}

instance Method "input_text" GodotMainLoop (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_input_text (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_init
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "init" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_init #-}

instance Method "init" GodotMainLoop (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_init (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_iteration
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "iteration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_iteration #-}

instance Method "iteration" GodotMainLoop (Float -> IO Bool) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_iteration (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_idle
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "idle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_idle #-}

instance Method "idle" GodotMainLoop (Float -> IO Bool) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_idle (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindMainLoop_finish
  = unsafePerformIO $
      withCString "MainLoop" $
        \ clsNamePtr ->
          withCString "finish" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindMainLoop_finish #-}

instance Method "finish" GodotMainLoop (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindMainLoop_finish (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotTranslation = GodotTranslation GodotObject
                             deriving newtype AsVariant

instance HasBaseClass GodotTranslation where
        type BaseClass GodotTranslation = GodotResource
        super = coerce
bindTranslation_set_locale
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "set_locale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_set_locale #-}

instance Method "set_locale" GodotTranslation
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_set_locale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_get_locale
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "get_locale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_get_locale #-}

instance Method "get_locale" GodotTranslation (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_get_locale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_add_message
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "add_message" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_add_message #-}

instance Method "add_message" GodotTranslation
           (GodotString -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_add_message (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_get_message
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "get_message" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_get_message #-}

instance Method "get_message" GodotTranslation
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_get_message (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_erase_message
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "erase_message" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_erase_message #-}

instance Method "erase_message" GodotTranslation
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_erase_message (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_get_message_list
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "get_message_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_get_message_list #-}

instance Method "get_message_list" GodotTranslation
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_get_message_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation_get_message_count
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "get_message_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation_get_message_count #-}

instance Method "get_message_count" GodotTranslation (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation_get_message_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation__set_messages
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "_set_messages" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation__set_messages #-}

instance Method "_set_messages" GodotTranslation
           (GodotPoolStringArray -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation__set_messages (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslation__get_messages
  = unsafePerformIO $
      withCString "Translation" $
        \ clsNamePtr ->
          withCString "_get_messages" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslation__get_messages #-}

instance Method "_get_messages" GodotTranslation
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslation__get_messages (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPHashTranslation = GodotPHashTranslation GodotObject
                                  deriving newtype AsVariant

instance HasBaseClass GodotPHashTranslation where
        type BaseClass GodotPHashTranslation = GodotTranslation
        super = coerce
bindPHashTranslation_generate
  = unsafePerformIO $
      withCString "PHashTranslation" $
        \ clsNamePtr ->
          withCString "generate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPHashTranslation_generate #-}

instance Method "generate" GodotPHashTranslation
           (GodotTranslation -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPHashTranslation_generate (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotUndoRedo = GodotUndoRedo GodotObject
                          deriving newtype AsVariant

instance HasBaseClass GodotUndoRedo where
        type BaseClass GodotUndoRedo = GodotObject
        super = coerce
bindUndoRedo_create_action
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "create_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_create_action #-}

instance Method "create_action" GodotUndoRedo
           (GodotString -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_create_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_commit_action
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "commit_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_commit_action #-}

instance Method "commit_action" GodotUndoRedo (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_commit_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_add_do_property
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "add_do_property" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_add_do_property #-}

instance Method "add_do_property" GodotUndoRedo
           (GodotObject -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_add_do_property (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_add_undo_property
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "add_undo_property" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_add_undo_property #-}

instance Method "add_undo_property" GodotUndoRedo
           (GodotObject -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_add_undo_property (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_add_do_reference
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "add_do_reference" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_add_do_reference #-}

instance Method "add_do_reference" GodotUndoRedo
           (GodotObject -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_add_do_reference (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_add_undo_reference
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "add_undo_reference" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_add_undo_reference #-}

instance Method "add_undo_reference" GodotUndoRedo
           (GodotObject -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_add_undo_reference (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_clear_history
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "clear_history" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_clear_history #-}

instance Method "clear_history" GodotUndoRedo (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_clear_history (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_get_current_action_name
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "get_current_action_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_get_current_action_name #-}

instance Method "get_current_action_name" GodotUndoRedo
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_get_current_action_name
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_get_version
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "get_version" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_get_version #-}

instance Method "get_version" GodotUndoRedo (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_get_version (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_redo
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "redo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_redo #-}

instance Method "redo" GodotUndoRedo (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_redo (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindUndoRedo_undo
  = unsafePerformIO $
      withCString "UndoRedo" $
        \ clsNamePtr ->
          withCString "undo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindUndoRedo_undo #-}

instance Method "undo" GodotUndoRedo (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindUndoRedo_undo (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotHTTPClient = GodotHTTPClient GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotHTTPClient where
        type BaseClass GodotHTTPClient = GodotReference
        super = coerce
bindHTTPClient_connect_to_host
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "connect_to_host" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_connect_to_host #-}

instance Method "connect_to_host" GodotHTTPClient
           (GodotString -> Int -> Bool -> Bool -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_connect_to_host (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_set_connection
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "set_connection" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_set_connection #-}

instance Method "set_connection" GodotHTTPClient
           (GodotStreamPeer -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_set_connection (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_connection
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_connection" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_connection #-}

instance Method "get_connection" GodotHTTPClient
           (IO GodotStreamPeer)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_get_connection (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_request_raw
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "request_raw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_request_raw #-}

instance Method "request_raw" GodotHTTPClient
           (Int ->
              GodotString ->
                GodotPoolStringArray -> GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_request_raw (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_request
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "request" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_request #-}

instance Method "request" GodotHTTPClient
           (Int ->
              GodotString -> GodotPoolStringArray -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_request (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_close
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "close" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_close #-}

instance Method "close" GodotHTTPClient (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_close (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_has_response
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "has_response" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_has_response #-}

instance Method "has_response" GodotHTTPClient (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_has_response (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_is_response_chunked
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "is_response_chunked" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_is_response_chunked #-}

instance Method "is_response_chunked" GodotHTTPClient (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_is_response_chunked
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_response_code
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_response_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_response_code #-}

instance Method "get_response_code" GodotHTTPClient (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_get_response_code
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_response_headers
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_response_headers" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_response_headers #-}

instance Method "get_response_headers" GodotHTTPClient
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_get_response_headers
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_response_headers_as_dictionary
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_response_headers_as_dictionary" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_response_headers_as_dictionary #-}

instance Method "get_response_headers_as_dictionary"
           GodotHTTPClient
           (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindHTTPClient_get_response_headers_as_dictionary
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_response_body_length
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_response_body_length" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_response_body_length #-}

instance Method "get_response_body_length" GodotHTTPClient (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_get_response_body_length
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_read_response_body_chunk
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "read_response_body_chunk" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_read_response_body_chunk #-}

instance Method "read_response_body_chunk" GodotHTTPClient
           (IO GodotPoolByteArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_read_response_body_chunk
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_set_read_chunk_size
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "set_read_chunk_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_set_read_chunk_size #-}

instance Method "set_read_chunk_size" GodotHTTPClient
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_set_read_chunk_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_set_blocking_mode
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "set_blocking_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_set_blocking_mode #-}

instance Method "set_blocking_mode" GodotHTTPClient (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_set_blocking_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_is_blocking_mode_enabled
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "is_blocking_mode_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_is_blocking_mode_enabled #-}

instance Method "is_blocking_mode_enabled" GodotHTTPClient
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_is_blocking_mode_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_get_status
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "get_status" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_get_status #-}

instance Method "get_status" GodotHTTPClient (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_get_status (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_poll
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "poll" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_poll #-}

instance Method "poll" GodotHTTPClient (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_poll (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindHTTPClient_query_string_from_dict
  = unsafePerformIO $
      withCString "HTTPClient" $
        \ clsNamePtr ->
          withCString "query_string_from_dict" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindHTTPClient_query_string_from_dict #-}

instance Method "query_string_from_dict" GodotHTTPClient
           (GodotDictionary -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindHTTPClient_query_string_from_dict
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotTriangleMesh = GodotTriangleMesh GodotObject
                              deriving newtype AsVariant

instance HasBaseClass GodotTriangleMesh where
        type BaseClass GodotTriangleMesh = GodotReference
        super = coerce

newtype GodotResourceInteractiveLoader = GodotResourceInteractiveLoader GodotObject
                                           deriving newtype AsVariant

instance HasBaseClass GodotResourceInteractiveLoader where
        type BaseClass GodotResourceInteractiveLoader = GodotReference
        super = coerce
bindResourceInteractiveLoader_get_resource
  = unsafePerformIO $
      withCString "ResourceInteractiveLoader" $
        \ clsNamePtr ->
          withCString "get_resource" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResourceInteractiveLoader_get_resource #-}

instance Method "get_resource" GodotResourceInteractiveLoader
           (IO GodotResource)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResourceInteractiveLoader_get_resource
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResourceInteractiveLoader_poll
  = unsafePerformIO $
      withCString "ResourceInteractiveLoader" $
        \ clsNamePtr ->
          withCString "poll" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResourceInteractiveLoader_poll #-}

instance Method "poll" GodotResourceInteractiveLoader (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResourceInteractiveLoader_poll
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResourceInteractiveLoader_wait
  = unsafePerformIO $
      withCString "ResourceInteractiveLoader" $
        \ clsNamePtr ->
          withCString "wait" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResourceInteractiveLoader_wait #-}

instance Method "wait" GodotResourceInteractiveLoader (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResourceInteractiveLoader_wait
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResourceInteractiveLoader_get_stage
  = unsafePerformIO $
      withCString "ResourceInteractiveLoader" $
        \ clsNamePtr ->
          withCString "get_stage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResourceInteractiveLoader_get_stage #-}

instance Method "get_stage" GodotResourceInteractiveLoader (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindResourceInteractiveLoader_get_stage
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindResourceInteractiveLoader_get_stage_count
  = unsafePerformIO $
      withCString "ResourceInteractiveLoader" $
        \ clsNamePtr ->
          withCString "get_stage_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindResourceInteractiveLoader_get_stage_count #-}

instance Method "get_stage_count" GodotResourceInteractiveLoader
           (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindResourceInteractiveLoader_get_stage_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_File = Godot_File GodotObject
                       deriving newtype AsVariant

instance HasBaseClass Godot_File where
        type BaseClass Godot_File = GodotReference
        super = coerce
bind_File_open_encrypted
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "open_encrypted" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_open_encrypted #-}

instance Method "open_encrypted" Godot_File
           (GodotString -> Int -> GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_open_encrypted (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_open_encrypted_with_pass
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "open_encrypted_with_pass" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_open_encrypted_with_pass #-}

instance Method "open_encrypted_with_pass" Godot_File
           (GodotString -> Int -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_open_encrypted_with_pass
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_open_compressed
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "open_compressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_open_compressed #-}

instance Method "open_compressed" Godot_File
           (GodotString -> Int -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_open_compressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_open
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "open" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_open #-}

instance Method "open" Godot_File (GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_open (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_close
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "close" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_close #-}

instance Method "close" Godot_File (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_close (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_path
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_path #-}

instance Method "get_path" Godot_File (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_path (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_path_absolute
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_path_absolute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_path_absolute #-}

instance Method "get_path_absolute" Godot_File (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_path_absolute (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_is_open
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "is_open" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_is_open #-}

instance Method "is_open" Godot_File (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_is_open (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_seek
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "seek" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_seek #-}

instance Method "seek" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_seek (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_seek_end
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "seek_end" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_seek_end #-}

instance Method "seek_end" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_seek_end (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_position
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_position #-}

instance Method "get_position" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_position (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_len
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_len" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_len #-}

instance Method "get_len" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_len (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_eof_reached
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "eof_reached" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_eof_reached #-}

instance Method "eof_reached" Godot_File (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_eof_reached (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_8
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_8 #-}

instance Method "get_8" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_8 (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_16
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_16 #-}

instance Method "get_16" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_16 (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_32
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_32 #-}

instance Method "get_32" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_32 (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_64
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_64 #-}

instance Method "get_64" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_64 (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_float
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_float" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_float #-}

instance Method "get_float" Godot_File (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_float (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_double
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_double" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_double #-}

instance Method "get_double" Godot_File (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_double (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_real
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_real" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_real #-}

instance Method "get_real" Godot_File (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_real (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_buffer
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_buffer #-}

instance Method "get_buffer" Godot_File
           (Int -> IO GodotPoolByteArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_buffer (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_line
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_line #-}

instance Method "get_line" Godot_File (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_line (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_as_text
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_as_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_as_text #-}

instance Method "get_as_text" Godot_File (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_as_text (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_md5
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_md5" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_md5 #-}

instance Method "get_md5" Godot_File
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_md5 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_sha256
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_sha256" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_sha256 #-}

instance Method "get_sha256" Godot_File
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_sha256 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_endian_swap
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_endian_swap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_endian_swap #-}

instance Method "get_endian_swap" Godot_File (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_endian_swap (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_set_endian_swap
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "set_endian_swap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_set_endian_swap #-}

instance Method "set_endian_swap" Godot_File (Bool -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_set_endian_swap (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_error
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_error" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_error #-}

instance Method "get_error" Godot_File (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_error (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_var
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_var #-}

instance Method "get_var" Godot_File (IO GodotVariant) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_var (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_csv_line
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_csv_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_csv_line #-}

instance Method "get_csv_line" Godot_File
           (GodotString -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_csv_line (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_8
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_8 #-}

instance Method "store_8" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_8 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_16
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_16" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_16 #-}

instance Method "store_16" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_16 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_32
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_32" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_32 #-}

instance Method "store_32" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_32 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_64
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_64 #-}

instance Method "store_64" Godot_File (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_64 (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_float
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_float" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_float #-}

instance Method "store_float" Godot_File (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_float (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_double
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_double" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_double #-}

instance Method "store_double" Godot_File (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_double (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_real
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_real" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_real #-}

instance Method "store_real" Godot_File (Float -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_real (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_buffer
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_buffer #-}

instance Method "store_buffer" Godot_File
           (GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_buffer (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_line
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_line #-}

instance Method "store_line" Godot_File (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_line (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_string
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_string #-}

instance Method "store_string" Godot_File (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_string (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_var
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_var" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_var #-}

instance Method "store_var" Godot_File (GodotVariant -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_var (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_store_pascal_string
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "store_pascal_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_store_pascal_string #-}

instance Method "store_pascal_string" Godot_File
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_store_pascal_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_pascal_string
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_pascal_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_pascal_string #-}

instance Method "get_pascal_string" Godot_File (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_pascal_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_file_exists
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "file_exists" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_file_exists #-}

instance Method "file_exists" Godot_File (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_file_exists (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_File_get_modified_time
  = unsafePerformIO $
      withCString "_File" $
        \ clsNamePtr ->
          withCString "get_modified_time" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_File_get_modified_time #-}

instance Method "get_modified_time" Godot_File
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_File_get_modified_time (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Directory = Godot_Directory GodotObject
                            deriving newtype AsVariant

instance HasBaseClass Godot_Directory where
        type BaseClass Godot_Directory = GodotReference
        super = coerce
bind_Directory_open
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "open" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_open #-}

instance Method "open" Godot_Directory (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_open (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_list_dir_begin
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "list_dir_begin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_list_dir_begin #-}

instance Method "list_dir_begin" Godot_Directory
           (Bool -> Bool -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_list_dir_begin (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_next
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_next" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_next #-}

instance Method "get_next" Godot_Directory (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_next (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_current_is_dir
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "current_is_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_current_is_dir #-}

instance Method "current_is_dir" Godot_Directory (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_current_is_dir (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_list_dir_end
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "list_dir_end" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_list_dir_end #-}

instance Method "list_dir_end" Godot_Directory (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_list_dir_end (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_drive_count
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_drive_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_drive_count #-}

instance Method "get_drive_count" Godot_Directory (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_drive_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_drive
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_drive" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_drive #-}

instance Method "get_drive" Godot_Directory (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_drive (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_current_drive
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_current_drive" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_current_drive #-}

instance Method "get_current_drive" Godot_Directory (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_current_drive
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_change_dir
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "change_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_change_dir #-}

instance Method "change_dir" Godot_Directory
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_change_dir (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_current_dir
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_current_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_current_dir #-}

instance Method "get_current_dir" Godot_Directory (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_current_dir (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_make_dir
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "make_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_make_dir #-}

instance Method "make_dir" Godot_Directory (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_make_dir (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_make_dir_recursive
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "make_dir_recursive" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_make_dir_recursive #-}

instance Method "make_dir_recursive" Godot_Directory
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_make_dir_recursive
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_file_exists
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "file_exists" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_file_exists #-}

instance Method "file_exists" Godot_Directory
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_file_exists (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_dir_exists
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "dir_exists" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_dir_exists #-}

instance Method "dir_exists" Godot_Directory
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_dir_exists (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_get_space_left
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "get_space_left" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_get_space_left #-}

instance Method "get_space_left" Godot_Directory (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_get_space_left (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_copy
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "copy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_copy #-}

instance Method "copy" Godot_Directory
           (GodotString -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_copy (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_rename
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "rename" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_rename #-}

instance Method "rename" Godot_Directory
           (GodotString -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_rename (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Directory_remove
  = unsafePerformIO $
      withCString "_Directory" $
        \ clsNamePtr ->
          withCString "remove" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Directory_remove #-}

instance Method "remove" Godot_Directory (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Directory_remove (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Thread = Godot_Thread GodotObject
                         deriving newtype AsVariant

instance HasBaseClass Godot_Thread where
        type BaseClass Godot_Thread = GodotReference
        super = coerce
bind_Thread_start
  = unsafePerformIO $
      withCString "_Thread" $
        \ clsNamePtr ->
          withCString "start" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Thread_start #-}

instance Method "start" Godot_Thread
           (GodotObject -> GodotString -> GodotVariant -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Thread_start (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Thread_get_id
  = unsafePerformIO $
      withCString "_Thread" $
        \ clsNamePtr ->
          withCString "get_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Thread_get_id #-}

instance Method "get_id" Godot_Thread (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Thread_get_id (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Thread_is_active
  = unsafePerformIO $
      withCString "_Thread" $
        \ clsNamePtr ->
          withCString "is_active" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Thread_is_active #-}

instance Method "is_active" Godot_Thread (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Thread_is_active (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Thread_wait_to_finish
  = unsafePerformIO $
      withCString "_Thread" $
        \ clsNamePtr ->
          withCString "wait_to_finish" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Thread_wait_to_finish #-}

instance Method "wait_to_finish" Godot_Thread (IO GodotVariant)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Thread_wait_to_finish (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Mutex = Godot_Mutex GodotObject
                        deriving newtype AsVariant

instance HasBaseClass Godot_Mutex where
        type BaseClass Godot_Mutex = GodotReference
        super = coerce
bind_Mutex_lock
  = unsafePerformIO $
      withCString "_Mutex" $
        \ clsNamePtr ->
          withCString "lock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Mutex_lock #-}

instance Method "lock" Godot_Mutex (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Mutex_lock (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Mutex_try_lock
  = unsafePerformIO $
      withCString "_Mutex" $
        \ clsNamePtr ->
          withCString "try_lock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Mutex_try_lock #-}

instance Method "try_lock" Godot_Mutex (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Mutex_try_lock (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Mutex_unlock
  = unsafePerformIO $
      withCString "_Mutex" $
        \ clsNamePtr ->
          withCString "unlock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Mutex_unlock #-}

instance Method "unlock" Godot_Mutex (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Mutex_unlock (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Semaphore = Godot_Semaphore GodotObject
                            deriving newtype AsVariant

instance HasBaseClass Godot_Semaphore where
        type BaseClass Godot_Semaphore = GodotReference
        super = coerce
bind_Semaphore_wait
  = unsafePerformIO $
      withCString "_Semaphore" $
        \ clsNamePtr ->
          withCString "wait" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Semaphore_wait #-}

instance Method "wait" Godot_Semaphore (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Semaphore_wait (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Semaphore_post
  = unsafePerformIO $
      withCString "_Semaphore" $
        \ clsNamePtr ->
          withCString "post" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Semaphore_post #-}

instance Method "post" Godot_Semaphore (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Semaphore_post (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotXMLParser = GodotXMLParser GodotObject
                           deriving newtype AsVariant

instance HasBaseClass GodotXMLParser where
        type BaseClass GodotXMLParser = GodotReference
        super = coerce
bindXMLParser_read
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "read" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_read #-}

instance Method "read" GodotXMLParser (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_read (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_node_type
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_node_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_node_type #-}

instance Method "get_node_type" GodotXMLParser (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_node_type (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_node_name
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_node_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_node_name #-}

instance Method "get_node_name" GodotXMLParser (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_node_name (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_node_data
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_node_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_node_data #-}

instance Method "get_node_data" GodotXMLParser (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_node_data (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_node_offset
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_node_offset" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_node_offset #-}

instance Method "get_node_offset" GodotXMLParser (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_node_offset (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_attribute_count
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_attribute_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_attribute_count #-}

instance Method "get_attribute_count" GodotXMLParser (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_attribute_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_attribute_name
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_attribute_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_attribute_name #-}

instance Method "get_attribute_name" GodotXMLParser
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_attribute_name
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_attribute_value
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_attribute_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_attribute_value #-}

instance Method "get_attribute_value" GodotXMLParser
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_attribute_value
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_has_attribute
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "has_attribute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_has_attribute #-}

instance Method "has_attribute" GodotXMLParser
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_has_attribute (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_named_attribute_value
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_named_attribute_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_named_attribute_value #-}

instance Method "get_named_attribute_value" GodotXMLParser
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_named_attribute_value
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_named_attribute_value_safe
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_named_attribute_value_safe" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_named_attribute_value_safe #-}

instance Method "get_named_attribute_value_safe" GodotXMLParser
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_named_attribute_value_safe
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_is_empty
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "is_empty" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_is_empty #-}

instance Method "is_empty" GodotXMLParser (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_is_empty (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_get_current_line
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "get_current_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_get_current_line #-}

instance Method "get_current_line" GodotXMLParser (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_get_current_line (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_skip_section
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "skip_section" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_skip_section #-}

instance Method "skip_section" GodotXMLParser (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_skip_section (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_seek
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "seek" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_seek #-}

instance Method "seek" GodotXMLParser (Int -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_seek (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_open
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "open" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_open #-}

instance Method "open" GodotXMLParser (GodotString -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_open (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindXMLParser_open_buffer
  = unsafePerformIO $
      withCString "XMLParser" $
        \ clsNamePtr ->
          withCString "open_buffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindXMLParser_open_buffer #-}

instance Method "open_buffer" GodotXMLParser
           (GodotPoolByteArray -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindXMLParser_open_buffer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotConfigFile = GodotConfigFile GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotConfigFile where
        type BaseClass GodotConfigFile = GodotReference
        super = coerce
bindConfigFile_set_value
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "set_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_set_value #-}

instance Method "set_value" GodotConfigFile
           (GodotString -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_set_value (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_get_value
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "get_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_get_value #-}

instance Method "get_value" GodotConfigFile
           (GodotString -> GodotString -> GodotVariant -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_get_value (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_has_section
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "has_section" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_has_section #-}

instance Method "has_section" GodotConfigFile
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_has_section (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_has_section_key
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "has_section_key" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_has_section_key #-}

instance Method "has_section_key" GodotConfigFile
           (GodotString -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_has_section_key (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_get_sections
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "get_sections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_get_sections #-}

instance Method "get_sections" GodotConfigFile
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_get_sections (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_get_section_keys
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "get_section_keys" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_get_section_keys #-}

instance Method "get_section_keys" GodotConfigFile
           (GodotString -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_get_section_keys (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_erase_section
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "erase_section" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_erase_section #-}

instance Method "erase_section" GodotConfigFile
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_erase_section (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_load
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "load" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_load #-}

instance Method "load" GodotConfigFile (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_load (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindConfigFile_save
  = unsafePerformIO $
      withCString "ConfigFile" $
        \ clsNamePtr ->
          withCString "save" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindConfigFile_save #-}

instance Method "save" GodotConfigFile (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindConfigFile_save (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPCKPacker = GodotPCKPacker GodotObject
                           deriving newtype AsVariant

instance HasBaseClass GodotPCKPacker where
        type BaseClass GodotPCKPacker = GodotReference
        super = coerce
bindPCKPacker_pck_start
  = unsafePerformIO $
      withCString "PCKPacker" $
        \ clsNamePtr ->
          withCString "pck_start" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPCKPacker_pck_start #-}

instance Method "pck_start" GodotPCKPacker
           (GodotString -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPCKPacker_pck_start (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPCKPacker_add_file
  = unsafePerformIO $
      withCString "PCKPacker" $
        \ clsNamePtr ->
          withCString "add_file" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPCKPacker_add_file #-}

instance Method "add_file" GodotPCKPacker
           (GodotString -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPCKPacker_add_file (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPCKPacker_flush
  = unsafePerformIO $
      withCString "PCKPacker" $
        \ clsNamePtr ->
          withCString "flush" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPCKPacker_flush #-}

instance Method "flush" GodotPCKPacker (Bool -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPCKPacker_flush (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPackedDataContainer = GodotPackedDataContainer GodotObject
                                     deriving newtype AsVariant

instance HasBaseClass GodotPackedDataContainer where
        type BaseClass GodotPackedDataContainer = GodotResource
        super = coerce
bindPackedDataContainer__set_data
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "_set_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer__set_data #-}

instance Method "_set_data" GodotPackedDataContainer
           (GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer__set_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer__get_data
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "_get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer__get_data #-}

instance Method "_get_data" GodotPackedDataContainer
           (IO GodotPoolByteArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer__get_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer__iter_init
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "_iter_init" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer__iter_init #-}

instance Method "_iter_init" GodotPackedDataContainer
           (GodotArray -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer__iter_init
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer__iter_get
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "_iter_get" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer__iter_get #-}

instance Method "_iter_get" GodotPackedDataContainer
           (GodotVariant -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer__iter_get
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer__iter_next
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "_iter_next" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer__iter_next #-}

instance Method "_iter_next" GodotPackedDataContainer
           (GodotArray -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer__iter_next
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer_pack
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "pack" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer_pack #-}

instance Method "pack" GodotPackedDataContainer
           (GodotVariant -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer_pack (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainer_size
  = unsafePerformIO $
      withCString "PackedDataContainer" $
        \ clsNamePtr ->
          withCString "size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainer_size #-}

instance Method "size" GodotPackedDataContainer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainer_size (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPackedDataContainerRef = GodotPackedDataContainerRef GodotObject
                                        deriving newtype AsVariant

instance HasBaseClass GodotPackedDataContainerRef where
        type BaseClass GodotPackedDataContainerRef = GodotReference
        super = coerce
bindPackedDataContainerRef_size
  = unsafePerformIO $
      withCString "PackedDataContainerRef" $
        \ clsNamePtr ->
          withCString "size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainerRef_size #-}

instance Method "size" GodotPackedDataContainerRef (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainerRef_size (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainerRef__iter_init
  = unsafePerformIO $
      withCString "PackedDataContainerRef" $
        \ clsNamePtr ->
          withCString "_iter_init" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainerRef__iter_init #-}

instance Method "_iter_init" GodotPackedDataContainerRef
           (GodotArray -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainerRef__iter_init
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainerRef__iter_get
  = unsafePerformIO $
      withCString "PackedDataContainerRef" $
        \ clsNamePtr ->
          withCString "_iter_get" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainerRef__iter_get #-}

instance Method "_iter_get" GodotPackedDataContainerRef
           (GodotVariant -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainerRef__iter_get
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainerRef__iter_next
  = unsafePerformIO $
      withCString "PackedDataContainerRef" $
        \ clsNamePtr ->
          withCString "_iter_next" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainerRef__iter_next #-}

instance Method "_iter_next" GodotPackedDataContainerRef
           (GodotArray -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainerRef__iter_next
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPackedDataContainerRef__is_dictionary
  = unsafePerformIO $
      withCString "PackedDataContainerRef" $
        \ clsNamePtr ->
          withCString "_is_dictionary" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPackedDataContainerRef__is_dictionary #-}

instance Method "_is_dictionary" GodotPackedDataContainerRef
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPackedDataContainerRef__is_dictionary
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotAStar = GodotAStar GodotObject
                       deriving newtype AsVariant

instance HasBaseClass GodotAStar where
        type BaseClass GodotAStar = GodotReference
        super = coerce
bindAStar__estimate_cost
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "_estimate_cost" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar__estimate_cost #-}

instance Method "_estimate_cost" GodotAStar
           (Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar__estimate_cost (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar__compute_cost
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "_compute_cost" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar__compute_cost #-}

instance Method "_compute_cost" GodotAStar (Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar__compute_cost (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_available_point_id
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_available_point_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_available_point_id #-}

instance Method "get_available_point_id" GodotAStar (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_available_point_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_add_point
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "add_point" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_add_point #-}

instance Method "add_point" GodotAStar
           (Int -> GodotVector3 -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_add_point (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_point_position
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_point_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_point_position #-}

instance Method "get_point_position" GodotAStar
           (Int -> IO GodotVector3)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_point_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_set_point_position
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "set_point_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_set_point_position #-}

instance Method "set_point_position" GodotAStar
           (Int -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_set_point_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_point_weight_scale
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_point_weight_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_point_weight_scale #-}

instance Method "get_point_weight_scale" GodotAStar
           (Int -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_point_weight_scale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_set_point_weight_scale
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "set_point_weight_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_set_point_weight_scale #-}

instance Method "set_point_weight_scale" GodotAStar
           (Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_set_point_weight_scale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_remove_point
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "remove_point" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_remove_point #-}

instance Method "remove_point" GodotAStar (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_remove_point (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_has_point
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "has_point" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_has_point #-}

instance Method "has_point" GodotAStar (Int -> IO Bool) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_has_point (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_points
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_points" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_points #-}

instance Method "get_points" GodotAStar (IO GodotArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_points (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_point_connections
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_point_connections" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_point_connections #-}

instance Method "get_point_connections" GodotAStar
           (Int -> IO GodotPoolIntArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_point_connections (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_connect_points
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "connect_points" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_connect_points #-}

instance Method "connect_points" GodotAStar
           (Int -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_connect_points (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_disconnect_points
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "disconnect_points" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_disconnect_points #-}

instance Method "disconnect_points" GodotAStar
           (Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_disconnect_points (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_are_points_connected
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "are_points_connected" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_are_points_connected #-}

instance Method "are_points_connected" GodotAStar
           (Int -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_are_points_connected (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_clear
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_clear #-}

instance Method "clear" GodotAStar (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_clear (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_closest_point
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_closest_point" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_closest_point #-}

instance Method "get_closest_point" GodotAStar
           (GodotVector3 -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_closest_point (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_closest_position_in_segment
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_closest_position_in_segment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_closest_position_in_segment #-}

instance Method "get_closest_position_in_segment" GodotAStar
           (GodotVector3 -> IO GodotVector3)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_closest_position_in_segment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_point_path
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_point_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_point_path #-}

instance Method "get_point_path" GodotAStar
           (Int -> Int -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_point_path (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAStar_get_id_path
  = unsafePerformIO $
      withCString "AStar" $
        \ clsNamePtr ->
          withCString "get_id_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAStar_get_id_path #-}

instance Method "get_id_path" GodotAStar
           (Int -> Int -> IO GodotPoolIntArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAStar_get_id_path (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotEncodedObjectAsID = GodotEncodedObjectAsID GodotObject
                                   deriving newtype AsVariant

instance HasBaseClass GodotEncodedObjectAsID where
        type BaseClass GodotEncodedObjectAsID = GodotReference
        super = coerce
bindEncodedObjectAsID_set_object_id
  = unsafePerformIO $
      withCString "EncodedObjectAsID" $
        \ clsNamePtr ->
          withCString "set_object_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindEncodedObjectAsID_set_object_id #-}

instance Method "set_object_id" GodotEncodedObjectAsID
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindEncodedObjectAsID_set_object_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindEncodedObjectAsID_get_object_id
  = unsafePerformIO $
      withCString "EncodedObjectAsID" $
        \ clsNamePtr ->
          withCString "get_object_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindEncodedObjectAsID_get_object_id #-}

instance Method "get_object_id" GodotEncodedObjectAsID (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindEncodedObjectAsID_get_object_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotJSONParseResult = GodotJSONParseResult GodotObject
                                 deriving newtype AsVariant

instance HasBaseClass GodotJSONParseResult where
        type BaseClass GodotJSONParseResult = GodotReference
        super = coerce
bindJSONParseResult_get_error
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "get_error" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_get_error #-}

instance Method "get_error" GodotJSONParseResult (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_get_error (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_get_error_string
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "get_error_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_get_error_string #-}

instance Method "get_error_string" GodotJSONParseResult
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_get_error_string
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_get_error_line
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "get_error_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_get_error_line #-}

instance Method "get_error_line" GodotJSONParseResult (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_get_error_line
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_get_result
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "get_result" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_get_result #-}

instance Method "get_result" GodotJSONParseResult (IO GodotVariant)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_get_result (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_set_error
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "set_error" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_set_error #-}

instance Method "set_error" GodotJSONParseResult (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_set_error (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_set_error_string
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "set_error_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_set_error_string #-}

instance Method "set_error_string" GodotJSONParseResult
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_set_error_string
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_set_error_line
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "set_error_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_set_error_line #-}

instance Method "set_error_line" GodotJSONParseResult
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_set_error_line
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindJSONParseResult_set_result
  = unsafePerformIO $
      withCString "JSONParseResult" $
        \ clsNamePtr ->
          withCString "set_result" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindJSONParseResult_set_result #-}

instance Method "set_result" GodotJSONParseResult
           (GodotVariant -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindJSONParseResult_set_result (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotIP_Unix = GodotIP_Unix GodotObject
                         deriving newtype AsVariant

instance HasBaseClass GodotIP_Unix where
        type BaseClass GodotIP_Unix = GodotIP
        super = coerce

newtype Godot_Geometry = Godot_Geometry GodotObject
                           deriving newtype AsVariant

instance HasBaseClass Godot_Geometry where
        type BaseClass Godot_Geometry = GodotObject
        super = coerce
bind_Geometry_build_box_planes
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "build_box_planes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_build_box_planes #-}

instance Method "build_box_planes" Godot_Geometry
           (GodotVector3 -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_build_box_planes (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_build_cylinder_planes
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "build_cylinder_planes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_build_cylinder_planes #-}

instance Method "build_cylinder_planes" Godot_Geometry
           (Float -> Float -> Int -> Int -> IO GodotArray)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_build_cylinder_planes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_build_capsule_planes
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "build_capsule_planes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_build_capsule_planes #-}

instance Method "build_capsule_planes" Godot_Geometry
           (Float -> Float -> Int -> Int -> Int -> IO GodotArray)
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_build_capsule_planes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_circle
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_circle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_circle #-}

instance Method "segment_intersects_circle" Godot_Geometry
           (GodotVector2 -> GodotVector2 -> GodotVector2 -> Float -> IO Float)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_circle
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_segment_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_segment_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_segment_2d #-}

instance Method "segment_intersects_segment_2d" Godot_Geometry
           (GodotVector2 ->
              GodotVector2 -> GodotVector2 -> GodotVector2 -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_segment_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_line_intersects_line_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "line_intersects_line_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_line_intersects_line_2d #-}

instance Method "line_intersects_line_2d" Godot_Geometry
           (GodotVector2 ->
              GodotVector2 -> GodotVector2 -> GodotVector2 -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_line_intersects_line_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_points_between_segments_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_points_between_segments_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_points_between_segments_2d
             #-}

instance Method "get_closest_points_between_segments_2d"
           Godot_Geometry
           (GodotVector2 ->
              GodotVector2 ->
                GodotVector2 -> GodotVector2 -> IO GodotPoolVector2Array)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_Geometry_get_closest_points_between_segments_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_points_between_segments
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_points_between_segments" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_points_between_segments #-}

instance Method "get_closest_points_between_segments"
           Godot_Geometry
           (GodotVector3 ->
              GodotVector3 ->
                GodotVector3 -> GodotVector3 -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_Geometry_get_closest_points_between_segments
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_point_to_segment_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_point_to_segment_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_point_to_segment_2d #-}

instance Method "get_closest_point_to_segment_2d" Godot_Geometry
           (GodotVector2 -> GodotVector2 -> GodotVector2 -> IO GodotVector2)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_Geometry_get_closest_point_to_segment_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_point_to_segment
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_point_to_segment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_point_to_segment #-}

instance Method "get_closest_point_to_segment" Godot_Geometry
           (GodotVector3 -> GodotVector3 -> GodotVector3 -> IO GodotVector3)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_get_closest_point_to_segment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_point_to_segment_uncapped_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_point_to_segment_uncapped_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_point_to_segment_uncapped_2d
             #-}

instance Method "get_closest_point_to_segment_uncapped_2d"
           Godot_Geometry
           (GodotVector2 -> GodotVector2 -> GodotVector2 -> IO GodotVector2)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_Geometry_get_closest_point_to_segment_uncapped_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_closest_point_to_segment_uncapped
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_closest_point_to_segment_uncapped" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_closest_point_to_segment_uncapped
             #-}

instance Method "get_closest_point_to_segment_uncapped"
           Godot_Geometry
           (GodotVector3 -> GodotVector3 -> GodotVector3 -> IO GodotVector3)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_Geometry_get_closest_point_to_segment_uncapped
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_get_uv84_normal_bit
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "get_uv84_normal_bit" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_get_uv84_normal_bit #-}

instance Method "get_uv84_normal_bit" Godot_Geometry
           (GodotVector3 -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_get_uv84_normal_bit
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_ray_intersects_triangle
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "ray_intersects_triangle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_ray_intersects_triangle #-}

instance Method "ray_intersects_triangle" Godot_Geometry
           (GodotVector3 ->
              GodotVector3 ->
                GodotVector3 -> GodotVector3 -> GodotVector3 -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_ray_intersects_triangle
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_triangle
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_triangle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_triangle #-}

instance Method "segment_intersects_triangle" Godot_Geometry
           (GodotVector3 ->
              GodotVector3 ->
                GodotVector3 -> GodotVector3 -> GodotVector3 -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_triangle
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_sphere
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_sphere" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_sphere #-}

instance Method "segment_intersects_sphere" Godot_Geometry
           (GodotVector3 ->
              GodotVector3 -> GodotVector3 -> Float -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_sphere
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_cylinder
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_cylinder" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_cylinder #-}

instance Method "segment_intersects_cylinder" Godot_Geometry
           (GodotVector3 ->
              GodotVector3 -> Float -> Float -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_cylinder
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_segment_intersects_convex
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "segment_intersects_convex" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_segment_intersects_convex #-}

instance Method "segment_intersects_convex" Godot_Geometry
           (GodotVector3 ->
              GodotVector3 -> GodotArray -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_segment_intersects_convex
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_point_is_inside_triangle
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "point_is_inside_triangle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_point_is_inside_triangle #-}

instance Method "point_is_inside_triangle" Godot_Geometry
           (GodotVector2 ->
              GodotVector2 -> GodotVector2 -> GodotVector2 -> IO Bool)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_point_is_inside_triangle
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_triangulate_polygon
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "triangulate_polygon" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_triangulate_polygon #-}

instance Method "triangulate_polygon" Godot_Geometry
           (GodotPoolVector2Array -> IO GodotPoolIntArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_triangulate_polygon
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_convex_hull_2d
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "convex_hull_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_convex_hull_2d #-}

instance Method "convex_hull_2d" Godot_Geometry
           (GodotPoolVector2Array -> IO GodotPoolVector2Array)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_convex_hull_2d (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_clip_polygon
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "clip_polygon" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_clip_polygon #-}

instance Method "clip_polygon" Godot_Geometry
           (GodotPoolVector3Array -> GodotPlane -> IO GodotPoolVector3Array)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_clip_polygon (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Geometry_make_atlas
  = unsafePerformIO $
      withCString "_Geometry" $
        \ clsNamePtr ->
          withCString "make_atlas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Geometry_make_atlas #-}

instance Method "make_atlas" Godot_Geometry
           (GodotPoolVector2Array -> IO GodotDictionary)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Geometry_make_atlas (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_ResourceLoader = Godot_ResourceLoader GodotObject
                                 deriving newtype AsVariant

instance HasBaseClass Godot_ResourceLoader where
        type BaseClass Godot_ResourceLoader = GodotObject
        super = coerce
bind_ResourceLoader_load_interactive
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "load_interactive" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_load_interactive #-}

instance Method "load_interactive" Godot_ResourceLoader
           (GodotString -> GodotString -> IO GodotResourceInteractiveLoader)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_load_interactive
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_load
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "load" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_load #-}

instance Method "load" Godot_ResourceLoader
           (GodotString -> GodotString -> Bool -> IO GodotResource)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_load (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_get_recognized_extensions_for_type
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "get_recognized_extensions_for_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_get_recognized_extensions_for_type
             #-}

instance Method "get_recognized_extensions_for_type"
           Godot_ResourceLoader
           (GodotString -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_ResourceLoader_get_recognized_extensions_for_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_set_abort_on_missing_resources
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "set_abort_on_missing_resources" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_set_abort_on_missing_resources #-}

instance Method "set_abort_on_missing_resources"
           Godot_ResourceLoader
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_ResourceLoader_set_abort_on_missing_resources
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_get_dependencies
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "get_dependencies" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_get_dependencies #-}

instance Method "get_dependencies" Godot_ResourceLoader
           (GodotString -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_get_dependencies
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_has_cached
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "has_cached" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_has_cached #-}

instance Method "has_cached" Godot_ResourceLoader
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_has_cached (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_exists
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "exists" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_exists #-}

instance Method "exists" Godot_ResourceLoader
           (GodotString -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_exists (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceLoader_has
  = unsafePerformIO $
      withCString "_ResourceLoader" $
        \ clsNamePtr ->
          withCString "has" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceLoader_has #-}

instance Method "has" Godot_ResourceLoader (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceLoader_has (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_ResourceSaver = Godot_ResourceSaver GodotObject
                                deriving newtype AsVariant

instance HasBaseClass Godot_ResourceSaver where
        type BaseClass Godot_ResourceSaver = GodotObject
        super = coerce
bind_ResourceSaver_save
  = unsafePerformIO $
      withCString "_ResourceSaver" $
        \ clsNamePtr ->
          withCString "save" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceSaver_save #-}

instance Method "save" Godot_ResourceSaver
           (GodotString -> GodotResource -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceSaver_save (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ResourceSaver_get_recognized_extensions
  = unsafePerformIO $
      withCString "_ResourceSaver" $
        \ clsNamePtr ->
          withCString "get_recognized_extensions" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ResourceSaver_get_recognized_extensions #-}

instance Method "get_recognized_extensions" Godot_ResourceSaver
           (GodotResource -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ResourceSaver_get_recognized_extensions
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_OS = Godot_OS GodotObject
                     deriving newtype AsVariant

instance HasBaseClass Godot_OS where
        type BaseClass Godot_OS = GodotObject
        super = coerce
bind_OS_set_clipboard
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_clipboard" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_clipboard #-}

instance Method "set_clipboard" Godot_OS (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_clipboard (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_clipboard
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_clipboard" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_clipboard #-}

instance Method "get_clipboard" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_clipboard (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_video_driver_count
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_video_driver_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_video_driver_count #-}

instance Method "get_video_driver_count" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_video_driver_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_video_driver_name
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_video_driver_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_video_driver_name #-}

instance Method "get_video_driver_name" Godot_OS
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_video_driver_name (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_audio_driver_count
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_audio_driver_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_audio_driver_count #-}

instance Method "get_audio_driver_count" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_audio_driver_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_audio_driver_name
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_audio_driver_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_audio_driver_name #-}

instance Method "get_audio_driver_name" Godot_OS
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_audio_driver_name (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_connected_midi_inputs
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_connected_midi_inputs" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_connected_midi_inputs #-}

instance Method "get_connected_midi_inputs" Godot_OS
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_connected_midi_inputs
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_open_midi_inputs
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "open_midi_inputs" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_open_midi_inputs #-}

instance Method "open_midi_inputs" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_open_midi_inputs (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_close_midi_inputs
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "close_midi_inputs" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_close_midi_inputs #-}

instance Method "close_midi_inputs" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_close_midi_inputs (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_screen_count
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_screen_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_screen_count #-}

instance Method "get_screen_count" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_screen_count (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_current_screen
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_current_screen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_current_screen #-}

instance Method "get_current_screen" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_current_screen (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_current_screen
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_current_screen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_current_screen #-}

instance Method "set_current_screen" Godot_OS (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_current_screen (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_screen_position
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_screen_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_screen_position #-}

instance Method "get_screen_position" Godot_OS
           (Int -> IO GodotVector2)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_screen_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_screen_size
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_screen_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_screen_size #-}

instance Method "get_screen_size" Godot_OS (Int -> IO GodotVector2)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_screen_size (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_screen_dpi
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_screen_dpi" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_screen_dpi #-}

instance Method "get_screen_dpi" Godot_OS (Int -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_screen_dpi (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_window_position
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_window_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_window_position #-}

instance Method "get_window_position" Godot_OS (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_window_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_position
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_position #-}

instance Method "set_window_position" Godot_OS
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_window_size
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_window_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_window_size #-}

instance Method "get_window_size" Godot_OS (IO GodotVector2) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_window_size (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_size
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_size #-}

instance Method "set_window_size" Godot_OS (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_size (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_window_safe_area
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_window_safe_area" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_window_safe_area #-}

instance Method "get_window_safe_area" Godot_OS (IO GodotRect2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_window_safe_area (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_fullscreen
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_fullscreen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_fullscreen #-}

instance Method "set_window_fullscreen" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_fullscreen (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_window_fullscreen
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_window_fullscreen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_window_fullscreen #-}

instance Method "is_window_fullscreen" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_window_fullscreen (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_resizable
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_resizable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_resizable #-}

instance Method "set_window_resizable" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_resizable (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_window_resizable
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_window_resizable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_window_resizable #-}

instance Method "is_window_resizable" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_window_resizable (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_minimized
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_minimized" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_minimized #-}

instance Method "set_window_minimized" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_minimized (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_window_minimized
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_window_minimized" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_window_minimized #-}

instance Method "is_window_minimized" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_window_minimized (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_maximized
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_maximized" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_maximized #-}

instance Method "set_window_maximized" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_maximized (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_window_maximized
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_window_maximized" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_window_maximized #-}

instance Method "is_window_maximized" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_window_maximized (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_always_on_top
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_always_on_top" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_always_on_top #-}

instance Method "set_window_always_on_top" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_always_on_top
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_window_always_on_top
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_window_always_on_top" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_window_always_on_top #-}

instance Method "is_window_always_on_top" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_window_always_on_top (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_request_attention
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "request_attention" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_request_attention #-}

instance Method "request_attention" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_request_attention (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_real_window_size
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_real_window_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_real_window_size #-}

instance Method "get_real_window_size" Godot_OS (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_real_window_size (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_center_window
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "center_window" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_center_window #-}

instance Method "center_window" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_center_window (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_borderless_window
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_borderless_window" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_borderless_window #-}

instance Method "set_borderless_window" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_borderless_window (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_borderless_window
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_borderless_window" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_borderless_window #-}

instance Method "get_borderless_window" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_borderless_window (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_window_per_pixel_transparency_enabled
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_window_per_pixel_transparency_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_window_per_pixel_transparency_enabled #-}

instance Method "get_window_per_pixel_transparency_enabled"
           Godot_OS
           (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_OS_get_window_per_pixel_transparency_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_per_pixel_transparency_enabled
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_per_pixel_transparency_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_per_pixel_transparency_enabled #-}

instance Method "set_window_per_pixel_transparency_enabled"
           Godot_OS
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bind_OS_set_window_per_pixel_transparency_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_ime_position
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_ime_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_ime_position #-}

instance Method "set_ime_position" Godot_OS (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_ime_position (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_screen_orientation
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_screen_orientation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_screen_orientation #-}

instance Method "set_screen_orientation" Godot_OS (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_screen_orientation (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_screen_orientation
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_screen_orientation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_screen_orientation #-}

instance Method "get_screen_orientation" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_screen_orientation (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_keep_screen_on
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_keep_screen_on" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_keep_screen_on #-}

instance Method "set_keep_screen_on" Godot_OS (Bool -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_keep_screen_on (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_keep_screen_on
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_keep_screen_on" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_keep_screen_on #-}

instance Method "is_keep_screen_on" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_keep_screen_on (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_has_touchscreen_ui_hint
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "has_touchscreen_ui_hint" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_has_touchscreen_ui_hint #-}

instance Method "has_touchscreen_ui_hint" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_has_touchscreen_ui_hint (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_window_title
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_window_title" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_window_title #-}

instance Method "set_window_title" Godot_OS (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_window_title (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_low_processor_usage_mode
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_low_processor_usage_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_low_processor_usage_mode #-}

instance Method "set_low_processor_usage_mode" Godot_OS
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_low_processor_usage_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_in_low_processor_usage_mode
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_in_low_processor_usage_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_in_low_processor_usage_mode #-}

instance Method "is_in_low_processor_usage_mode" Godot_OS (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_in_low_processor_usage_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_processor_count
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_processor_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_processor_count #-}

instance Method "get_processor_count" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_processor_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_executable_path
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_executable_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_executable_path #-}

instance Method "get_executable_path" Godot_OS (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_executable_path (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_execute
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "execute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_execute #-}

instance Method "execute" Godot_OS
           (GodotString ->
              GodotPoolStringArray -> Bool -> GodotArray -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_execute (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_kill
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "kill" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_kill #-}

instance Method "kill" Godot_OS (Int -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_kill (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_shell_open
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "shell_open" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_shell_open #-}

instance Method "shell_open" Godot_OS (GodotString -> IO Int) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_shell_open (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_process_id
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_process_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_process_id #-}

instance Method "get_process_id" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_process_id (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_environment
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_environment #-}

instance Method "get_environment" Godot_OS
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_environment (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_has_environment
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "has_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_has_environment #-}

instance Method "has_environment" Godot_OS (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_has_environment (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_name
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_name #-}

instance Method "get_name" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_name (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_cmdline_args
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_cmdline_args" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_cmdline_args #-}

instance Method "get_cmdline_args" Godot_OS
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_cmdline_args (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_datetime
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_datetime" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_datetime #-}

instance Method "get_datetime" Godot_OS
           (Bool -> IO GodotDictionary)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_datetime (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_date
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_date" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_date #-}

instance Method "get_date" Godot_OS (Bool -> IO GodotDictionary)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_date (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_time
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_time" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_time #-}

instance Method "get_time" Godot_OS (Bool -> IO GodotDictionary)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_time (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_time_zone_info
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_time_zone_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_time_zone_info #-}

instance Method "get_time_zone_info" Godot_OS (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_time_zone_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_unix_time
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_unix_time" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_unix_time #-}

instance Method "get_unix_time" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_unix_time (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_datetime_from_unix_time
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_datetime_from_unix_time" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_datetime_from_unix_time #-}

instance Method "get_datetime_from_unix_time" Godot_OS
           (Int -> IO GodotDictionary)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_datetime_from_unix_time
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_unix_time_from_datetime
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_unix_time_from_datetime" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_unix_time_from_datetime #-}

instance Method "get_unix_time_from_datetime" Godot_OS
           (GodotDictionary -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_unix_time_from_datetime
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_system_time_secs
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_system_time_secs" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_system_time_secs #-}

instance Method "get_system_time_secs" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_system_time_secs (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_icon
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_icon" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_icon #-}

instance Method "set_icon" Godot_OS (GodotImage -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_icon (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_exit_code
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_exit_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_exit_code #-}

instance Method "get_exit_code" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_exit_code (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_exit_code
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_exit_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_exit_code #-}

instance Method "set_exit_code" Godot_OS (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_exit_code (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_delay_usec
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "delay_usec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_delay_usec #-}

instance Method "delay_usec" Godot_OS (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_delay_usec (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_delay_msec
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "delay_msec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_delay_msec #-}

instance Method "delay_msec" Godot_OS (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_delay_msec (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_ticks_msec
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_ticks_msec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_ticks_msec #-}

instance Method "get_ticks_msec" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_ticks_msec (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_ticks_usec
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_ticks_usec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_ticks_usec #-}

instance Method "get_ticks_usec" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_ticks_usec (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_splash_tick_msec
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_splash_tick_msec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_splash_tick_msec #-}

instance Method "get_splash_tick_msec" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_splash_tick_msec (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_locale
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_locale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_locale #-}

instance Method "get_locale" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_locale (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_latin_keyboard_variant
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_latin_keyboard_variant" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_latin_keyboard_variant #-}

instance Method "get_latin_keyboard_variant" Godot_OS
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_latin_keyboard_variant
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_model_name
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_model_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_model_name #-}

instance Method "get_model_name" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_model_name (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_can_draw
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "can_draw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_can_draw #-}

instance Method "can_draw" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_can_draw (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_userfs_persistent
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_userfs_persistent" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_userfs_persistent #-}

instance Method "is_userfs_persistent" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_userfs_persistent (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_stdout_verbose
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_stdout_verbose" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_stdout_verbose #-}

instance Method "is_stdout_verbose" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_stdout_verbose (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_can_use_threads
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "can_use_threads" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_can_use_threads #-}

instance Method "can_use_threads" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_can_use_threads (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_debug_build
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_debug_build" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_debug_build #-}

instance Method "is_debug_build" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_debug_build (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_dump_memory_to_file
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "dump_memory_to_file" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_dump_memory_to_file #-}

instance Method "dump_memory_to_file" Godot_OS
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_dump_memory_to_file (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_dump_resources_to_file
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "dump_resources_to_file" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_dump_resources_to_file #-}

instance Method "dump_resources_to_file" Godot_OS
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_dump_resources_to_file (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_has_virtual_keyboard
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "has_virtual_keyboard" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_has_virtual_keyboard #-}

instance Method "has_virtual_keyboard" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_has_virtual_keyboard (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_show_virtual_keyboard
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "show_virtual_keyboard" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_show_virtual_keyboard #-}

instance Method "show_virtual_keyboard" Godot_OS
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_show_virtual_keyboard (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_hide_virtual_keyboard
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "hide_virtual_keyboard" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_hide_virtual_keyboard #-}

instance Method "hide_virtual_keyboard" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_hide_virtual_keyboard (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_virtual_keyboard_height
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_virtual_keyboard_height" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_virtual_keyboard_height #-}

instance Method "get_virtual_keyboard_height" Godot_OS (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_virtual_keyboard_height
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_print_resources_in_use
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "print_resources_in_use" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_print_resources_in_use #-}

instance Method "print_resources_in_use" Godot_OS (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_print_resources_in_use (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_print_all_resources
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "print_all_resources" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_print_all_resources #-}

instance Method "print_all_resources" Godot_OS
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_print_all_resources (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_static_memory_usage
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_static_memory_usage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_static_memory_usage #-}

instance Method "get_static_memory_usage" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_static_memory_usage (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_static_memory_peak_usage
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_static_memory_peak_usage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_static_memory_peak_usage #-}

instance Method "get_static_memory_peak_usage" Godot_OS (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_static_memory_peak_usage
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_dynamic_memory_usage
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_dynamic_memory_usage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_dynamic_memory_usage #-}

instance Method "get_dynamic_memory_usage" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_dynamic_memory_usage
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_user_data_dir
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_user_data_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_user_data_dir #-}

instance Method "get_user_data_dir" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_user_data_dir (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_system_dir
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_system_dir" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_system_dir #-}

instance Method "get_system_dir" Godot_OS (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_system_dir (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_unique_id
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_unique_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_unique_id #-}

instance Method "get_unique_id" Godot_OS (IO GodotString) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_unique_id (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_ok_left_and_cancel_right
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_ok_left_and_cancel_right" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_ok_left_and_cancel_right #-}

instance Method "is_ok_left_and_cancel_right" Godot_OS (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_ok_left_and_cancel_right
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_print_all_textures_by_size
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "print_all_textures_by_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_print_all_textures_by_size #-}

instance Method "print_all_textures_by_size" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_print_all_textures_by_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_print_resources_by_type
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "print_resources_by_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_print_resources_by_type #-}

instance Method "print_resources_by_type" Godot_OS
           (GodotPoolStringArray -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_print_resources_by_type (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_native_video_play
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "native_video_play" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_native_video_play #-}

instance Method "native_video_play" Godot_OS
           (GodotString -> Float -> GodotString -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_native_video_play (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_native_video_is_playing
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "native_video_is_playing" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_native_video_is_playing #-}

instance Method "native_video_is_playing" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_native_video_is_playing (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_native_video_stop
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "native_video_stop" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_native_video_stop #-}

instance Method "native_video_stop" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_native_video_stop (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_native_video_pause
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "native_video_pause" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_native_video_pause #-}

instance Method "native_video_pause" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_native_video_pause (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_native_video_unpause
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "native_video_unpause" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_native_video_unpause #-}

instance Method "native_video_unpause" Godot_OS (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_native_video_unpause (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_scancode_string
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_scancode_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_scancode_string #-}

instance Method "get_scancode_string" Godot_OS
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_scancode_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_scancode_unicode
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_scancode_unicode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_scancode_unicode #-}

instance Method "is_scancode_unicode" Godot_OS (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_scancode_unicode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_find_scancode_from_string
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "find_scancode_from_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_find_scancode_from_string #-}

instance Method "find_scancode_from_string" Godot_OS
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_find_scancode_from_string
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_use_file_access_save_and_swap
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_use_file_access_save_and_swap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_use_file_access_save_and_swap #-}

instance Method "set_use_file_access_save_and_swap" Godot_OS
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_use_file_access_save_and_swap
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_alert
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "alert" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_alert #-}

instance Method "alert" Godot_OS
           (GodotString -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_alert (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_thread_name
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_thread_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_thread_name #-}

instance Method "set_thread_name" Godot_OS (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_thread_name (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_set_use_vsync
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "set_use_vsync" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_set_use_vsync #-}

instance Method "set_use_vsync" Godot_OS (Bool -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_set_use_vsync (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_is_vsync_enabled
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "is_vsync_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_is_vsync_enabled #-}

instance Method "is_vsync_enabled" Godot_OS (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_is_vsync_enabled (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_has_feature
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "has_feature" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_has_feature #-}

instance Method "has_feature" Godot_OS (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_has_feature (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_power_state
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_power_state" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_power_state #-}

instance Method "get_power_state" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_power_state (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_power_seconds_left
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_power_seconds_left" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_power_seconds_left #-}

instance Method "get_power_seconds_left" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_power_seconds_left (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_OS_get_power_percent_left
  = unsafePerformIO $
      withCString "_OS" $
        \ clsNamePtr ->
          withCString "get_power_percent_left" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_OS_get_power_percent_left #-}

instance Method "get_power_percent_left" Godot_OS (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_OS_get_power_percent_left (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Engine = Godot_Engine GodotObject
                         deriving newtype AsVariant

instance HasBaseClass Godot_Engine where
        type BaseClass Godot_Engine = GodotObject
        super = coerce
bind_Engine_set_iterations_per_second
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "set_iterations_per_second" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_set_iterations_per_second #-}

instance Method "set_iterations_per_second" Godot_Engine
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_set_iterations_per_second
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_iterations_per_second
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_iterations_per_second" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_iterations_per_second #-}

instance Method "get_iterations_per_second" Godot_Engine (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_iterations_per_second
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_set_physics_jitter_fix
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "set_physics_jitter_fix" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_set_physics_jitter_fix #-}

instance Method "set_physics_jitter_fix" Godot_Engine
           (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_set_physics_jitter_fix
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_physics_jitter_fix
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_physics_jitter_fix" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_physics_jitter_fix #-}

instance Method "get_physics_jitter_fix" Godot_Engine (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_physics_jitter_fix
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_set_target_fps
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "set_target_fps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_set_target_fps #-}

instance Method "set_target_fps" Godot_Engine (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_set_target_fps (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_target_fps
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_target_fps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_target_fps #-}

instance Method "get_target_fps" Godot_Engine (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_target_fps (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_set_time_scale
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "set_time_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_set_time_scale #-}

instance Method "set_time_scale" Godot_Engine (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_set_time_scale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_time_scale
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_time_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_time_scale #-}

instance Method "get_time_scale" Godot_Engine (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_time_scale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_frames_drawn
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_frames_drawn" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_frames_drawn #-}

instance Method "get_frames_drawn" Godot_Engine (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_frames_drawn (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_frames_per_second
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_frames_per_second" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_frames_per_second #-}

instance Method "get_frames_per_second" Godot_Engine (IO Float)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_frames_per_second
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_main_loop
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_main_loop" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_main_loop #-}

instance Method "get_main_loop" Godot_Engine (IO GodotMainLoop)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_main_loop (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_version_info
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_version_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_version_info #-}

instance Method "get_version_info" Godot_Engine
           (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_version_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_author_info
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_author_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_author_info #-}

instance Method "get_author_info" Godot_Engine (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_author_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_copyright_info
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_copyright_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_copyright_info #-}

instance Method "get_copyright_info" Godot_Engine (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_copyright_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_donor_info
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_donor_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_donor_info #-}

instance Method "get_donor_info" Godot_Engine (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_donor_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_license_info
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_license_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_license_info #-}

instance Method "get_license_info" Godot_Engine
           (IO GodotDictionary)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_license_info (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_license_text
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_license_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_license_text #-}

instance Method "get_license_text" Godot_Engine (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_license_text (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_is_in_physics_frame
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "is_in_physics_frame" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_is_in_physics_frame #-}

instance Method "is_in_physics_frame" Godot_Engine (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_is_in_physics_frame (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_has_singleton
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "has_singleton" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_has_singleton #-}

instance Method "has_singleton" Godot_Engine
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_has_singleton (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_get_singleton
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "get_singleton" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_get_singleton #-}

instance Method "get_singleton" Godot_Engine
           (GodotString -> IO GodotObject)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_get_singleton (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_set_editor_hint
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "set_editor_hint" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_set_editor_hint #-}

instance Method "set_editor_hint" Godot_Engine (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_set_editor_hint (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Engine_is_editor_hint
  = unsafePerformIO $
      withCString "_Engine" $
        \ clsNamePtr ->
          withCString "is_editor_hint" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Engine_is_editor_hint #-}

instance Method "is_editor_hint" Godot_Engine (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Engine_is_editor_hint (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_ClassDB = Godot_ClassDB GodotObject
                          deriving newtype AsVariant

instance HasBaseClass Godot_ClassDB where
        type BaseClass Godot_ClassDB = GodotObject
        super = coerce
bind_ClassDB_get_class_list
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "get_class_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_get_class_list #-}

instance Method "get_class_list" Godot_ClassDB
           (IO GodotPoolStringArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_get_class_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_get_inheriters_from_class
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "get_inheriters_from_class" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_get_inheriters_from_class #-}

instance Method "get_inheriters_from_class" Godot_ClassDB
           (GodotString -> IO GodotPoolStringArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_get_inheriters_from_class
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_get_parent_class
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "get_parent_class" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_get_parent_class #-}

instance Method "get_parent_class" Godot_ClassDB
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_get_parent_class (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_exists
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_exists" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_exists #-}

instance Method "class_exists" Godot_ClassDB
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_exists (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_is_parent_class
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "is_parent_class" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_is_parent_class #-}

instance Method "is_parent_class" Godot_ClassDB
           (GodotString -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_is_parent_class (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_can_instance
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "can_instance" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_can_instance #-}

instance Method "can_instance" Godot_ClassDB
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_can_instance (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_instance
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "instance" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_instance #-}

instance Method "instance" Godot_ClassDB
           (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_instance (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_has_signal
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_has_signal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_has_signal #-}

instance Method "class_has_signal" Godot_ClassDB
           (GodotString -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_has_signal (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_signal
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_signal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_signal #-}

instance Method "class_get_signal" Godot_ClassDB
           (GodotString -> GodotString -> IO GodotDictionary)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_signal (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_signal_list
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_signal_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_signal_list #-}

instance Method "class_get_signal_list" Godot_ClassDB
           (GodotString -> Bool -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_signal_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_property_list
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_property_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_property_list #-}

instance Method "class_get_property_list" Godot_ClassDB
           (GodotString -> Bool -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_property_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_property
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_property" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_property #-}

instance Method "class_get_property" Godot_ClassDB
           (GodotObject -> GodotString -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_property (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_set_property
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_set_property" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_set_property #-}

instance Method "class_set_property" Godot_ClassDB
           (GodotObject -> GodotString -> GodotVariant -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_set_property (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_has_method
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_has_method" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_has_method #-}

instance Method "class_has_method" Godot_ClassDB
           (GodotString -> GodotString -> Bool -> IO Bool)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_has_method (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_method_list
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_method_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_method_list #-}

instance Method "class_get_method_list" Godot_ClassDB
           (GodotString -> Bool -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_method_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_integer_constant_list
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_integer_constant_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_integer_constant_list #-}

instance Method "class_get_integer_constant_list" Godot_ClassDB
           (GodotString -> Bool -> IO GodotPoolStringArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_integer_constant_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_has_integer_constant
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_has_integer_constant" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_has_integer_constant #-}

instance Method "class_has_integer_constant" Godot_ClassDB
           (GodotString -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_has_integer_constant
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_integer_constant
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_integer_constant" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_integer_constant #-}

instance Method "class_get_integer_constant" Godot_ClassDB
           (GodotString -> GodotString -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_integer_constant
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_class_get_category
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "class_get_category" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_class_get_category #-}

instance Method "class_get_category" Godot_ClassDB
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_class_get_category (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_ClassDB_is_class_enabled
  = unsafePerformIO $
      withCString "_ClassDB" $
        \ clsNamePtr ->
          withCString "is_class_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_ClassDB_is_class_enabled #-}

instance Method "is_class_enabled" Godot_ClassDB
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_ClassDB_is_class_enabled (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_Marshalls = Godot_Marshalls GodotObject
                            deriving newtype AsVariant

instance HasBaseClass Godot_Marshalls where
        type BaseClass Godot_Marshalls = GodotReference
        super = coerce
bind_Marshalls_variant_to_base64
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "variant_to_base64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_variant_to_base64 #-}

instance Method "variant_to_base64" Godot_Marshalls
           (GodotVariant -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_variant_to_base64
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Marshalls_base64_to_variant
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "base64_to_variant" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_base64_to_variant #-}

instance Method "base64_to_variant" Godot_Marshalls
           (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_base64_to_variant
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Marshalls_raw_to_base64
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "raw_to_base64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_raw_to_base64 #-}

instance Method "raw_to_base64" Godot_Marshalls
           (GodotPoolByteArray -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_raw_to_base64 (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Marshalls_base64_to_raw
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "base64_to_raw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_base64_to_raw #-}

instance Method "base64_to_raw" Godot_Marshalls
           (GodotString -> IO GodotPoolByteArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_base64_to_raw (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Marshalls_utf8_to_base64
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "utf8_to_base64" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_utf8_to_base64 #-}

instance Method "utf8_to_base64" Godot_Marshalls
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_utf8_to_base64 (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_Marshalls_base64_to_utf8
  = unsafePerformIO $
      withCString "_Marshalls" $
        \ clsNamePtr ->
          withCString "base64_to_utf8" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_Marshalls_base64_to_utf8 #-}

instance Method "base64_to_utf8" Godot_Marshalls
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_Marshalls_base64_to_utf8 (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype Godot_JSON = Godot_JSON GodotObject
                       deriving newtype AsVariant

instance HasBaseClass Godot_JSON where
        type BaseClass Godot_JSON = GodotObject
        super = coerce
bind_JSON_print
  = unsafePerformIO $
      withCString "_JSON" $
        \ clsNamePtr ->
          withCString "print" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_JSON_print #-}

instance Method "print" Godot_JSON
           (GodotVariant -> GodotString -> Bool -> IO GodotString)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_JSON_print (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bind_JSON_parse
  = unsafePerformIO $
      withCString "_JSON" $
        \ clsNamePtr ->
          withCString "parse" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bind_JSON_parse #-}

instance Method "parse" Godot_JSON
           (GodotString -> IO GodotJSONParseResult)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bind_JSON_parse (coerce cls) arrPtr len >>=
                   \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotProjectSettings = GodotProjectSettings GodotObject
                                 deriving newtype AsVariant

instance HasBaseClass GodotProjectSettings where
        type BaseClass GodotProjectSettings = GodotObject
        super = coerce
bindProjectSettings_has_setting
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "has_setting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_has_setting #-}

instance Method "has_setting" GodotProjectSettings
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_has_setting (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_set_setting
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "set_setting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_set_setting #-}

instance Method "set_setting" GodotProjectSettings
           (GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_set_setting (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_get_setting
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "get_setting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_get_setting #-}

instance Method "get_setting" GodotProjectSettings
           (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_get_setting (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_set_order
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "set_order" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_set_order #-}

instance Method "set_order" GodotProjectSettings
           (GodotString -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_set_order (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_get_order
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "get_order" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_get_order #-}

instance Method "get_order" GodotProjectSettings
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_get_order (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_set_initial_value
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "set_initial_value" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_set_initial_value #-}

instance Method "set_initial_value" GodotProjectSettings
           (GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_set_initial_value
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_add_property_info
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "add_property_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_add_property_info #-}

instance Method "add_property_info" GodotProjectSettings
           (GodotDictionary -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_add_property_info
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_clear
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_clear #-}

instance Method "clear" GodotProjectSettings (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_clear (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_localize_path
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "localize_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_localize_path #-}

instance Method "localize_path" GodotProjectSettings
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_localize_path
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_globalize_path
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "globalize_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_globalize_path #-}

instance Method "globalize_path" GodotProjectSettings
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_globalize_path
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_save
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "save" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_save #-}

instance Method "save" GodotProjectSettings (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_save (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_load_resource_pack
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "load_resource_pack" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_load_resource_pack #-}

instance Method "load_resource_pack" GodotProjectSettings
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_load_resource_pack
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_property_can_revert
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "property_can_revert" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_property_can_revert #-}

instance Method "property_can_revert" GodotProjectSettings
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_property_can_revert
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_property_get_revert
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "property_get_revert" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_property_get_revert #-}

instance Method "property_get_revert" GodotProjectSettings
           (GodotString -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_property_get_revert
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindProjectSettings_save_custom
  = unsafePerformIO $
      withCString "ProjectSettings" $
        \ clsNamePtr ->
          withCString "save_custom" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindProjectSettings_save_custom #-}

instance Method "save_custom" GodotProjectSettings
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindProjectSettings_save_custom (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputMap = GodotInputMap GodotObject
                          deriving newtype AsVariant

instance HasBaseClass GodotInputMap where
        type BaseClass GodotInputMap = GodotObject
        super = coerce
bindInputMap_has_action
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "has_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_has_action #-}

instance Method "has_action" GodotInputMap (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_has_action (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_get_actions
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "get_actions" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_get_actions #-}

instance Method "get_actions" GodotInputMap (IO GodotArray) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_get_actions (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_add_action
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "add_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_add_action #-}

instance Method "add_action" GodotInputMap
           (GodotString -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_add_action (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_erase_action
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "erase_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_erase_action #-}

instance Method "erase_action" GodotInputMap (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_erase_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_action_set_deadzone
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "action_set_deadzone" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_action_set_deadzone #-}

instance Method "action_set_deadzone" GodotInputMap
           (GodotString -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_action_set_deadzone
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_action_add_event
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "action_add_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_action_add_event #-}

instance Method "action_add_event" GodotInputMap
           (GodotString -> GodotInputEvent -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_action_add_event (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_action_has_event
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "action_has_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_action_has_event #-}

instance Method "action_has_event" GodotInputMap
           (GodotString -> GodotInputEvent -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_action_has_event (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_action_erase_event
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "action_erase_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_action_erase_event #-}

instance Method "action_erase_event" GodotInputMap
           (GodotString -> GodotInputEvent -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_action_erase_event (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_action_erase_events
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "action_erase_events" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_action_erase_events #-}

instance Method "action_erase_events" GodotInputMap
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_action_erase_events
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_get_action_list
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "get_action_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_get_action_list #-}

instance Method "get_action_list" GodotInputMap
           (GodotString -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_get_action_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_event_is_action
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "event_is_action" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_event_is_action #-}

instance Method "event_is_action" GodotInputMap
           (GodotInputEvent -> GodotString -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_event_is_action (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInputMap_load_from_globals
  = unsafePerformIO $
      withCString "InputMap" $
        \ clsNamePtr ->
          withCString "load_from_globals" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInputMap_load_from_globals #-}

instance Method "load_from_globals" GodotInputMap (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInputMap_load_from_globals (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotTranslationServer = GodotTranslationServer GodotObject
                                   deriving newtype AsVariant

instance HasBaseClass GodotTranslationServer where
        type BaseClass GodotTranslationServer = GodotObject
        super = coerce
bindTranslationServer_set_locale
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "set_locale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_set_locale #-}

instance Method "set_locale" GodotTranslationServer
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_set_locale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_get_locale
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "get_locale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_get_locale #-}

instance Method "get_locale" GodotTranslationServer
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_get_locale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_get_locale_name
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "get_locale_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_get_locale_name #-}

instance Method "get_locale_name" GodotTranslationServer
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_get_locale_name
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_translate
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "translate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_translate #-}

instance Method "translate" GodotTranslationServer
           (GodotString -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_translate (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_add_translation
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "add_translation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_add_translation #-}

instance Method "add_translation" GodotTranslationServer
           (GodotTranslation -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_add_translation
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_remove_translation
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "remove_translation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_remove_translation #-}

instance Method "remove_translation" GodotTranslationServer
           (GodotTranslation -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_remove_translation
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindTranslationServer_clear
  = unsafePerformIO $
      withCString "TranslationServer" $
        \ clsNamePtr ->
          withCString "clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindTranslationServer_clear #-}

instance Method "clear" GodotTranslationServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindTranslationServer_clear (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPerformance = GodotPerformance GodotObject
                             deriving newtype AsVariant

instance HasBaseClass GodotPerformance where
        type BaseClass GodotPerformance = GodotObject
        super = coerce
bindPerformance_get_monitor
  = unsafePerformIO $
      withCString "Performance" $
        \ clsNamePtr ->
          withCString "get_monitor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPerformance_get_monitor #-}

instance Method "get_monitor" GodotPerformance (Int -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPerformance_get_monitor (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotVisualServer = GodotVisualServer GodotObject
                              deriving newtype AsVariant

instance HasBaseClass GodotVisualServer where
        type BaseClass GodotVisualServer = GodotObject
        super = coerce
bindVisualServer_force_sync
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "force_sync" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_force_sync #-}

instance Method "force_sync" GodotVisualServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_force_sync (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_force_draw
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "force_draw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_force_draw #-}

instance Method "force_draw" GodotVisualServer
           (Bool -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_force_draw (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_sync
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "sync" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_sync #-}

instance Method "sync" GodotVisualServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_sync (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_draw
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "draw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_draw #-}

instance Method "draw" GodotVisualServer (Bool -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_draw (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_create #-}

instance Method "texture_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_create_from_image
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_create_from_image" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_create_from_image #-}

instance Method "texture_create_from_image" GodotVisualServer
           (GodotImage -> Int -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_create_from_image
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_allocate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_allocate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_allocate #-}

instance Method "texture_allocate" GodotVisualServer
           (GodotRid -> Int -> Int -> Int -> Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_allocate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_data #-}

instance Method "texture_set_data" GodotVisualServer
           (GodotRid -> GodotImage -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_set_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_data_partial
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_data_partial" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_data_partial #-}

instance Method "texture_set_data_partial" GodotVisualServer
           (GodotRid ->
              GodotImage ->
                Int -> Int -> Int -> Int -> Int -> Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9, toVariant arg10]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_set_data_partial
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_data #-}

instance Method "texture_get_data" GodotVisualServer
           (GodotRid -> Int -> IO GodotImage)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_flags
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_flags" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_flags #-}

instance Method "texture_set_flags" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_set_flags
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_flags
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_flags" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_flags #-}

instance Method "texture_get_flags" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_flags
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_format
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_format" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_format #-}

instance Method "texture_get_format" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_format
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_type
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_type #-}

instance Method "texture_get_type" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_texid
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_texid" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_texid #-}

instance Method "texture_get_texid" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_texid
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_width
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_width" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_width #-}

instance Method "texture_get_width" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_width
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_height
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_height" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_height #-}

instance Method "texture_get_height" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_height
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_depth
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_depth" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_depth #-}

instance Method "texture_get_depth" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_depth
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_size_override
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_size_override" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_size_override #-}

instance Method "texture_set_size_override" GodotVisualServer
           (GodotRid -> Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_set_size_override
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_path
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_path #-}

instance Method "texture_set_path" GodotVisualServer
           (GodotRid -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_set_path
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_get_path
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_get_path" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_get_path #-}

instance Method "texture_get_path" GodotVisualServer
           (GodotRid -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_get_path
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_set_shrink_all_x2_on_set_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_set_shrink_all_x2_on_set_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_set_shrink_all_x2_on_set_data
             #-}

instance Method "texture_set_shrink_all_x2_on_set_data"
           GodotVisualServer
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_texture_set_shrink_all_x2_on_set_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_texture_debug_usage
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "texture_debug_usage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_texture_debug_usage #-}

instance Method "texture_debug_usage" GodotVisualServer
           (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_texture_debug_usage
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_textures_keep_original
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "textures_keep_original" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_textures_keep_original #-}

instance Method "textures_keep_original" GodotVisualServer
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_textures_keep_original
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_sky_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "sky_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_sky_create #-}

instance Method "sky_create" GodotVisualServer (IO GodotRid) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_sky_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_sky_set_texture
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "sky_set_texture" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_sky_set_texture #-}

instance Method "sky_set_texture" GodotVisualServer
           (GodotRid -> GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_sky_set_texture
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_create #-}

instance Method "shader_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_shader_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_set_code
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_set_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_set_code #-}

instance Method "shader_set_code" GodotVisualServer
           (GodotRid -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_shader_set_code
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_get_code
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_get_code" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_get_code #-}

instance Method "shader_get_code" GodotVisualServer
           (GodotRid -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_shader_get_code
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_get_param_list
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_get_param_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_get_param_list #-}

instance Method "shader_get_param_list" GodotVisualServer
           (GodotRid -> IO GodotArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_shader_get_param_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_set_default_texture_param
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_set_default_texture_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_set_default_texture_param #-}

instance Method "shader_set_default_texture_param"
           GodotVisualServer
           (GodotRid -> GodotString -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_shader_set_default_texture_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_shader_get_default_texture_param
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "shader_get_default_texture_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_shader_get_default_texture_param #-}

instance Method "shader_get_default_texture_param"
           GodotVisualServer
           (GodotRid -> GodotString -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_shader_get_default_texture_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_create #-}

instance Method "material_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_set_shader
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_set_shader" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_set_shader #-}

instance Method "material_set_shader" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_set_shader
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_get_shader
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_get_shader" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_get_shader #-}

instance Method "material_get_shader" GodotVisualServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_get_shader
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_set_param
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_set_param #-}

instance Method "material_set_param" GodotVisualServer
           (GodotRid -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_get_param
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_get_param #-}

instance Method "material_get_param" GodotVisualServer
           (GodotRid -> GodotString -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_get_param_default
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_get_param_default" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_get_param_default #-}

instance Method "material_get_param_default" GodotVisualServer
           (GodotRid -> GodotString -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_get_param_default
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_set_render_priority
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_set_render_priority" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_set_render_priority #-}

instance Method "material_set_render_priority" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_material_set_render_priority
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_set_line_width
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_set_line_width" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_set_line_width #-}

instance Method "material_set_line_width" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_set_line_width
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_material_set_next_pass
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "material_set_next_pass" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_material_set_next_pass #-}

instance Method "material_set_next_pass" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_material_set_next_pass
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_create #-}

instance Method "mesh_create" GodotVisualServer (IO GodotRid) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_format_offset
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_format_offset" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_format_offset #-}

instance Method "mesh_surface_get_format_offset" GodotVisualServer
           (Int -> Int -> Int -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_format_offset
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_format_stride
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_format_stride" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_format_stride #-}

instance Method "mesh_surface_get_format_stride" GodotVisualServer
           (Int -> Int -> Int -> IO Int)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_format_stride
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_add_surface_from_arrays
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_add_surface_from_arrays" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_add_surface_from_arrays #-}

instance Method "mesh_add_surface_from_arrays" GodotVisualServer
           (GodotRid -> Int -> GodotArray -> GodotArray -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_add_surface_from_arrays
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_set_blend_shape_count
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_set_blend_shape_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_set_blend_shape_count #-}

instance Method "mesh_set_blend_shape_count" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_set_blend_shape_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_get_blend_shape_count
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_get_blend_shape_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_get_blend_shape_count #-}

instance Method "mesh_get_blend_shape_count" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_get_blend_shape_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_set_blend_shape_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_set_blend_shape_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_set_blend_shape_mode #-}

instance Method "mesh_set_blend_shape_mode" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_set_blend_shape_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_get_blend_shape_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_get_blend_shape_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_get_blend_shape_mode #-}

instance Method "mesh_get_blend_shape_mode" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_get_blend_shape_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_update_region
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_update_region" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_update_region #-}

instance Method "mesh_surface_update_region" GodotVisualServer
           (GodotRid -> Int -> Int -> GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_update_region
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_set_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_set_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_set_material #-}

instance Method "mesh_surface_set_material" GodotVisualServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_set_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_material #-}

instance Method "mesh_surface_get_material" GodotVisualServer
           (GodotRid -> Int -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_array_len
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_array_len" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_array_len #-}

instance Method "mesh_surface_get_array_len" GodotVisualServer
           (GodotRid -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_array_len
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_array_index_len
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_array_index_len" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_array_index_len #-}

instance Method "mesh_surface_get_array_index_len"
           GodotVisualServer
           (GodotRid -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_array_index_len
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_array
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_array #-}

instance Method "mesh_surface_get_array" GodotVisualServer
           (GodotRid -> Int -> IO GodotPoolByteArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_index_array
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_index_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_index_array #-}

instance Method "mesh_surface_get_index_array" GodotVisualServer
           (GodotRid -> Int -> IO GodotPoolByteArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_index_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_arrays
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_arrays" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_arrays #-}

instance Method "mesh_surface_get_arrays" GodotVisualServer
           (GodotRid -> Int -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_arrays
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_blend_shape_arrays
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_blend_shape_arrays" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_blend_shape_arrays
             #-}

instance Method "mesh_surface_get_blend_shape_arrays"
           GodotVisualServer
           (GodotRid -> Int -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_blend_shape_arrays
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_format
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_format" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_format #-}

instance Method "mesh_surface_get_format" GodotVisualServer
           (GodotRid -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_format
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_primitive_type
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_primitive_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_primitive_type #-}

instance Method "mesh_surface_get_primitive_type" GodotVisualServer
           (GodotRid -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_primitive_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_aabb #-}

instance Method "mesh_surface_get_aabb" GodotVisualServer
           (GodotRid -> Int -> IO GodotAabb)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_surface_get_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_surface_get_skeleton_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_surface_get_skeleton_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_surface_get_skeleton_aabb #-}

instance Method "mesh_surface_get_skeleton_aabb" GodotVisualServer
           (GodotRid -> Int -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_mesh_surface_get_skeleton_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_remove_surface
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_remove_surface" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_remove_surface #-}

instance Method "mesh_remove_surface" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_remove_surface
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_get_surface_count
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_get_surface_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_get_surface_count #-}

instance Method "mesh_get_surface_count" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_get_surface_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_set_custom_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_set_custom_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_set_custom_aabb #-}

instance Method "mesh_set_custom_aabb" GodotVisualServer
           (GodotRid -> GodotAabb -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_set_custom_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_get_custom_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_get_custom_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_get_custom_aabb #-}

instance Method "mesh_get_custom_aabb" GodotVisualServer
           (GodotRid -> IO GodotAabb)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_get_custom_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_mesh_clear
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "mesh_clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_mesh_clear #-}

instance Method "mesh_clear" GodotVisualServer (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_mesh_clear (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_allocate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_allocate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_allocate #-}

instance Method "multimesh_allocate" GodotVisualServer
           (GodotRid -> Int -> Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_multimesh_allocate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_get_instance_count
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_get_instance_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_get_instance_count #-}

instance Method "multimesh_get_instance_count" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_get_instance_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_set_mesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_set_mesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_set_mesh #-}

instance Method "multimesh_set_mesh" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_multimesh_set_mesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_set_transform #-}

instance Method "multimesh_instance_set_transform"
           GodotVisualServer
           (GodotRid -> Int -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_set_transform_2d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_set_transform_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_set_transform_2d
             #-}

instance Method "multimesh_instance_set_transform_2d"
           GodotVisualServer
           (GodotRid -> Int -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_set_transform_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_set_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_set_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_set_color #-}

instance Method "multimesh_instance_set_color" GodotVisualServer
           (GodotRid -> Int -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_set_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_set_custom_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_set_custom_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_set_custom_data
             #-}

instance Method "multimesh_instance_set_custom_data"
           GodotVisualServer
           (GodotRid -> Int -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_set_custom_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_get_mesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_get_mesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_get_mesh #-}

instance Method "multimesh_get_mesh" GodotVisualServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_multimesh_get_mesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_get_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_get_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_get_aabb #-}

instance Method "multimesh_get_aabb" GodotVisualServer
           (GodotRid -> IO GodotAabb)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_multimesh_get_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_get_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_get_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_get_transform #-}

instance Method "multimesh_instance_get_transform"
           GodotVisualServer
           (GodotRid -> Int -> IO GodotTransform)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_get_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_get_transform_2d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_get_transform_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_get_transform_2d
             #-}

instance Method "multimesh_instance_get_transform_2d"
           GodotVisualServer
           (GodotRid -> Int -> IO GodotTransform2d)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_get_transform_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_get_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_get_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_get_color #-}

instance Method "multimesh_instance_get_color" GodotVisualServer
           (GodotRid -> Int -> IO GodotColor)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_get_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_instance_get_custom_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_instance_get_custom_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_instance_get_custom_data
             #-}

instance Method "multimesh_instance_get_custom_data"
           GodotVisualServer
           (GodotRid -> Int -> IO GodotColor)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_instance_get_custom_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_set_visible_instances
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_set_visible_instances" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_set_visible_instances #-}

instance Method "multimesh_set_visible_instances" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_set_visible_instances
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_get_visible_instances
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_get_visible_instances" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_get_visible_instances #-}

instance Method "multimesh_get_visible_instances" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_multimesh_get_visible_instances
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_multimesh_set_as_bulk_array
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "multimesh_set_as_bulk_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_multimesh_set_as_bulk_array #-}

instance Method "multimesh_set_as_bulk_array" GodotVisualServer
           (GodotRid -> GodotPoolRealArray -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_multimesh_set_as_bulk_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_create #-}

instance Method "immediate_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_begin
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_begin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_begin #-}

instance Method "immediate_begin" GodotVisualServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_begin
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_vertex
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_vertex" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_vertex #-}

instance Method "immediate_vertex" GodotVisualServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_vertex
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_vertex_2d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_vertex_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_vertex_2d #-}

instance Method "immediate_vertex_2d" GodotVisualServer
           (GodotRid -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_vertex_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_normal
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_normal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_normal #-}

instance Method "immediate_normal" GodotVisualServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_normal
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_tangent
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_tangent" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_tangent #-}

instance Method "immediate_tangent" GodotVisualServer
           (GodotRid -> GodotPlane -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_tangent
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_color #-}

instance Method "immediate_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_uv
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_uv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_uv #-}

instance Method "immediate_uv" GodotVisualServer
           (GodotRid -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_uv (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_uv2
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_uv2" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_uv2 #-}

instance Method "immediate_uv2" GodotVisualServer
           (GodotRid -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_uv2 (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_end
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_end" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_end #-}

instance Method "immediate_end" GodotVisualServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_end (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_clear
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_clear #-}

instance Method "immediate_clear" GodotVisualServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_clear
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_set_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_set_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_set_material #-}

instance Method "immediate_set_material" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_set_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_immediate_get_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "immediate_get_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_immediate_get_material #-}

instance Method "immediate_get_material" GodotVisualServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_immediate_get_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_create #-}

instance Method "skeleton_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_skeleton_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_allocate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_allocate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_allocate #-}

instance Method "skeleton_allocate" GodotVisualServer
           (GodotRid -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_skeleton_allocate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_get_bone_count
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_get_bone_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_get_bone_count #-}

instance Method "skeleton_get_bone_count" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_skeleton_get_bone_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_bone_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_bone_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_bone_set_transform #-}

instance Method "skeleton_bone_set_transform" GodotVisualServer
           (GodotRid -> Int -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_skeleton_bone_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_bone_get_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_bone_get_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_bone_get_transform #-}

instance Method "skeleton_bone_get_transform" GodotVisualServer
           (GodotRid -> Int -> IO GodotTransform)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_skeleton_bone_get_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_bone_set_transform_2d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_bone_set_transform_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_bone_set_transform_2d #-}

instance Method "skeleton_bone_set_transform_2d" GodotVisualServer
           (GodotRid -> Int -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_skeleton_bone_set_transform_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_skeleton_bone_get_transform_2d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "skeleton_bone_get_transform_2d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_skeleton_bone_get_transform_2d #-}

instance Method "skeleton_bone_get_transform_2d" GodotVisualServer
           (GodotRid -> Int -> IO GodotTransform2d)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_skeleton_bone_get_transform_2d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_directional_light_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "directional_light_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_directional_light_create #-}

instance Method "directional_light_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_directional_light_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_omni_light_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "omni_light_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_omni_light_create #-}

instance Method "omni_light_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_omni_light_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_spot_light_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "spot_light_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_spot_light_create #-}

instance Method "spot_light_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_spot_light_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_color #-}

instance Method "light_set_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_param
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_param #-}

instance Method "light_set_param" GodotVisualServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_shadow
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_shadow" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_shadow #-}

instance Method "light_set_shadow" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_shadow
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_shadow_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_shadow_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_shadow_color #-}

instance Method "light_set_shadow_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_shadow_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_projector
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_projector" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_projector #-}

instance Method "light_set_projector" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_projector
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_negative
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_negative" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_negative #-}

instance Method "light_set_negative" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_negative
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_cull_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_cull_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_cull_mask #-}

instance Method "light_set_cull_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_set_cull_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_set_reverse_cull_face_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_set_reverse_cull_face_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_set_reverse_cull_face_mode #-}

instance Method "light_set_reverse_cull_face_mode"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_light_set_reverse_cull_face_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_omni_set_shadow_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_omni_set_shadow_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_omni_set_shadow_mode #-}

instance Method "light_omni_set_shadow_mode" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_light_omni_set_shadow_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_omni_set_shadow_detail
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_omni_set_shadow_detail" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_omni_set_shadow_detail #-}

instance Method "light_omni_set_shadow_detail" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_light_omni_set_shadow_detail
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_directional_set_shadow_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_directional_set_shadow_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_directional_set_shadow_mode #-}

instance Method "light_directional_set_shadow_mode"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_light_directional_set_shadow_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_directional_set_blend_splits
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_directional_set_blend_splits" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_directional_set_blend_splits
             #-}

instance Method "light_directional_set_blend_splits"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_light_directional_set_blend_splits
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_light_directional_set_shadow_depth_range_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "light_directional_set_shadow_depth_range_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_light_directional_set_shadow_depth_range_mode
             #-}

instance Method "light_directional_set_shadow_depth_range_mode"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_light_directional_set_shadow_depth_range_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_create #-}

instance Method "reflection_probe_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_reflection_probe_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_update_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_update_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_update_mode #-}

instance Method "reflection_probe_set_update_mode"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_update_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_intensity
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_intensity" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_intensity #-}

instance Method "reflection_probe_set_intensity" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_intensity
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_interior_ambient
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_interior_ambient" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_interior_ambient
             #-}

instance Method "reflection_probe_set_interior_ambient"
           GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_interior_ambient
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_interior_ambient_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_interior_ambient_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_interior_ambient_energy
             #-}

instance Method "reflection_probe_set_interior_ambient_energy"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_interior_ambient_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_interior_ambient_probe_contribution
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString
            "reflection_probe_set_interior_ambient_probe_contribution"
            $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_interior_ambient_probe_contribution
             #-}

instance Method
           "reflection_probe_set_interior_ambient_probe_contribution"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_interior_ambient_probe_contribution
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_max_distance
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_max_distance" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_max_distance #-}

instance Method "reflection_probe_set_max_distance"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_max_distance
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_extents
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_extents" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_extents #-}

instance Method "reflection_probe_set_extents" GodotVisualServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_extents
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_origin_offset
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_origin_offset" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_origin_offset
             #-}

instance Method "reflection_probe_set_origin_offset"
           GodotVisualServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_origin_offset
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_as_interior
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_as_interior" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_as_interior #-}

instance Method "reflection_probe_set_as_interior"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_as_interior
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_enable_box_projection
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_enable_box_projection" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_enable_box_projection
             #-}

instance Method "reflection_probe_set_enable_box_projection"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_enable_box_projection
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_enable_shadows
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_enable_shadows" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_enable_shadows
             #-}

instance Method "reflection_probe_set_enable_shadows"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_enable_shadows
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_reflection_probe_set_cull_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "reflection_probe_set_cull_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_reflection_probe_set_cull_mask #-}

instance Method "reflection_probe_set_cull_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_reflection_probe_set_cull_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_create #-}

instance Method "gi_probe_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_bounds
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_bounds" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_bounds #-}

instance Method "gi_probe_set_bounds" GodotVisualServer
           (GodotRid -> GodotAabb -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_bounds
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_bounds
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_bounds" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_bounds #-}

instance Method "gi_probe_get_bounds" GodotVisualServer
           (GodotRid -> IO GodotAabb)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_bounds
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_cell_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_cell_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_cell_size #-}

instance Method "gi_probe_set_cell_size" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_cell_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_cell_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_cell_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_cell_size #-}

instance Method "gi_probe_get_cell_size" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_cell_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_to_cell_xform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_to_cell_xform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_to_cell_xform #-}

instance Method "gi_probe_set_to_cell_xform" GodotVisualServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_to_cell_xform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_to_cell_xform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_to_cell_xform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_to_cell_xform #-}

instance Method "gi_probe_get_to_cell_xform" GodotVisualServer
           (GodotRid -> IO GodotTransform)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_to_cell_xform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_dynamic_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_dynamic_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_dynamic_data #-}

instance Method "gi_probe_set_dynamic_data" GodotVisualServer
           (GodotRid -> GodotPoolIntArray -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_dynamic_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_dynamic_data
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_dynamic_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_dynamic_data #-}

instance Method "gi_probe_get_dynamic_data" GodotVisualServer
           (GodotRid -> IO GodotPoolIntArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_dynamic_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_dynamic_range
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_dynamic_range" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_dynamic_range #-}

instance Method "gi_probe_set_dynamic_range" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_dynamic_range
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_dynamic_range
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_dynamic_range" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_dynamic_range #-}

instance Method "gi_probe_get_dynamic_range" GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_dynamic_range
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_energy #-}

instance Method "gi_probe_set_energy" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_energy #-}

instance Method "gi_probe_get_energy" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_bias
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_bias" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_bias #-}

instance Method "gi_probe_set_bias" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_bias
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_bias
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_bias" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_bias #-}

instance Method "gi_probe_get_bias" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_bias
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_normal_bias
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_normal_bias" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_normal_bias #-}

instance Method "gi_probe_set_normal_bias" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_normal_bias
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_normal_bias
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_normal_bias" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_normal_bias #-}

instance Method "gi_probe_get_normal_bias" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_normal_bias
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_propagation
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_propagation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_propagation #-}

instance Method "gi_probe_set_propagation" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_propagation
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_get_propagation
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_get_propagation" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_get_propagation #-}

instance Method "gi_probe_get_propagation" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_get_propagation
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_interior
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_interior" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_interior #-}

instance Method "gi_probe_set_interior" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_interior
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_is_interior
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_is_interior" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_is_interior #-}

instance Method "gi_probe_is_interior" GodotVisualServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_is_interior
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_set_compress
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_set_compress" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_set_compress #-}

instance Method "gi_probe_set_compress" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_set_compress
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_gi_probe_is_compressed
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "gi_probe_is_compressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_gi_probe_is_compressed #-}

instance Method "gi_probe_is_compressed" GodotVisualServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_gi_probe_is_compressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_create #-}

instance Method "lightmap_capture_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_set_bounds
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_set_bounds" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_set_bounds #-}

instance Method "lightmap_capture_set_bounds" GodotVisualServer
           (GodotRid -> GodotAabb -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_set_bounds
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_get_bounds
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_get_bounds" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_get_bounds #-}

instance Method "lightmap_capture_get_bounds" GodotVisualServer
           (GodotRid -> IO GodotAabb)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_get_bounds
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_set_octree
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_set_octree" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_set_octree #-}

instance Method "lightmap_capture_set_octree" GodotVisualServer
           (GodotRid -> GodotPoolByteArray -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_set_octree
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_set_octree_cell_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_set_octree_cell_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_set_octree_cell_transform
             #-}

instance Method "lightmap_capture_set_octree_cell_transform"
           GodotVisualServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_lightmap_capture_set_octree_cell_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_get_octree_cell_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_get_octree_cell_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_get_octree_cell_transform
             #-}

instance Method "lightmap_capture_get_octree_cell_transform"
           GodotVisualServer
           (GodotRid -> IO GodotTransform)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_lightmap_capture_get_octree_cell_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_set_octree_cell_subdiv
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_set_octree_cell_subdiv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_set_octree_cell_subdiv
             #-}

instance Method "lightmap_capture_set_octree_cell_subdiv"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_lightmap_capture_set_octree_cell_subdiv
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_get_octree_cell_subdiv
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_get_octree_cell_subdiv" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_get_octree_cell_subdiv
             #-}

instance Method "lightmap_capture_get_octree_cell_subdiv"
           GodotVisualServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_lightmap_capture_get_octree_cell_subdiv
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_get_octree
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_get_octree" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_get_octree #-}

instance Method "lightmap_capture_get_octree" GodotVisualServer
           (GodotRid -> IO GodotPoolByteArray)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_get_octree
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_set_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_set_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_set_energy #-}

instance Method "lightmap_capture_set_energy" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_set_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_lightmap_capture_get_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "lightmap_capture_get_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_lightmap_capture_get_energy #-}

instance Method "lightmap_capture_get_energy" GodotVisualServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_lightmap_capture_get_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_create #-}

instance Method "particles_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_emitting
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_emitting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_emitting #-}

instance Method "particles_set_emitting" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_emitting
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_get_emitting
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_get_emitting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_get_emitting #-}

instance Method "particles_get_emitting" GodotVisualServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_get_emitting
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_amount
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_amount" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_amount #-}

instance Method "particles_set_amount" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_amount
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_lifetime
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_lifetime" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_lifetime #-}

instance Method "particles_set_lifetime" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_lifetime
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_one_shot
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_one_shot" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_one_shot #-}

instance Method "particles_set_one_shot" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_one_shot
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_pre_process_time
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_pre_process_time" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_pre_process_time #-}

instance Method "particles_set_pre_process_time" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_pre_process_time
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_explosiveness_ratio
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_explosiveness_ratio" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_explosiveness_ratio #-}

instance Method "particles_set_explosiveness_ratio"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_explosiveness_ratio
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_randomness_ratio
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_randomness_ratio" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_randomness_ratio #-}

instance Method "particles_set_randomness_ratio" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_randomness_ratio
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_custom_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_custom_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_custom_aabb #-}

instance Method "particles_set_custom_aabb" GodotVisualServer
           (GodotRid -> GodotAabb -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_custom_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_speed_scale
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_speed_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_speed_scale #-}

instance Method "particles_set_speed_scale" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_speed_scale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_use_local_coordinates
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_use_local_coordinates" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_use_local_coordinates
             #-}

instance Method "particles_set_use_local_coordinates"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_use_local_coordinates
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_process_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_process_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_process_material #-}

instance Method "particles_set_process_material" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_process_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_fixed_fps
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_fixed_fps" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_fixed_fps #-}

instance Method "particles_set_fixed_fps" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_fixed_fps
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_fractional_delta
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_fractional_delta" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_fractional_delta #-}

instance Method "particles_set_fractional_delta" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_fractional_delta
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_restart
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_restart" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_restart #-}

instance Method "particles_restart" GodotVisualServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_restart
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_draw_order
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_draw_order" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_draw_order #-}

instance Method "particles_set_draw_order" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_draw_order
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_draw_passes
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_draw_passes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_draw_passes #-}

instance Method "particles_set_draw_passes" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_set_draw_passes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_draw_pass_mesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_draw_pass_mesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_draw_pass_mesh #-}

instance Method "particles_set_draw_pass_mesh" GodotVisualServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_draw_pass_mesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_get_current_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_get_current_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_get_current_aabb #-}

instance Method "particles_get_current_aabb" GodotVisualServer
           (GodotRid -> IO GodotAabb)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_particles_get_current_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_particles_set_emission_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "particles_set_emission_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_particles_set_emission_transform #-}

instance Method "particles_set_emission_transform"
           GodotVisualServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_particles_set_emission_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_create #-}

instance Method "camera_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_perspective
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_perspective" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_perspective #-}

instance Method "camera_set_perspective" GodotVisualServer
           (GodotRid -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_set_perspective
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_orthogonal
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_orthogonal" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_orthogonal #-}

instance Method "camera_set_orthogonal" GodotVisualServer
           (GodotRid -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_set_orthogonal
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_transform #-}

instance Method "camera_set_transform" GodotVisualServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_cull_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_cull_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_cull_mask #-}

instance Method "camera_set_cull_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_set_cull_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_environment
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_environment #-}

instance Method "camera_set_environment" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_camera_set_environment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_camera_set_use_vertical_aspect
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "camera_set_use_vertical_aspect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_camera_set_use_vertical_aspect #-}

instance Method "camera_set_use_vertical_aspect" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_camera_set_use_vertical_aspect
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_create #-}

instance Method "viewport_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_use_arvr
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_use_arvr" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_use_arvr #-}

instance Method "viewport_set_use_arvr" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_use_arvr
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_size #-}

instance Method "viewport_set_size" GodotVisualServer
           (GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_active
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_active" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_active #-}

instance Method "viewport_set_active" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_active
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_parent_viewport
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_parent_viewport" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_parent_viewport #-}

instance Method "viewport_set_parent_viewport" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_parent_viewport
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_attach_to_screen
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_attach_to_screen" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_attach_to_screen #-}

instance Method "viewport_attach_to_screen" GodotVisualServer
           (GodotRid -> GodotRect2 -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_attach_to_screen
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_detach
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_detach" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_detach #-}

instance Method "viewport_detach" GodotVisualServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_detach
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_update_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_update_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_update_mode #-}

instance Method "viewport_set_update_mode" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_update_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_vflip
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_vflip" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_vflip #-}

instance Method "viewport_set_vflip" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_vflip
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_clear_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_clear_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_clear_mode #-}

instance Method "viewport_set_clear_mode" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_clear_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_get_texture
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_get_texture" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_get_texture #-}

instance Method "viewport_get_texture" GodotVisualServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_get_texture
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_hide_scenario
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_hide_scenario" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_hide_scenario #-}

instance Method "viewport_set_hide_scenario" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_hide_scenario
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_hide_canvas
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_hide_canvas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_hide_canvas #-}

instance Method "viewport_set_hide_canvas" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_hide_canvas
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_disable_environment
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_disable_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_disable_environment #-}

instance Method "viewport_set_disable_environment"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_disable_environment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_disable_3d
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_disable_3d" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_disable_3d #-}

instance Method "viewport_set_disable_3d" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_disable_3d
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_attach_camera
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_attach_camera" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_attach_camera #-}

instance Method "viewport_attach_camera" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_attach_camera
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_scenario
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_scenario" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_scenario #-}

instance Method "viewport_set_scenario" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_scenario
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_attach_canvas
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_attach_canvas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_attach_canvas #-}

instance Method "viewport_attach_canvas" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_attach_canvas
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_remove_canvas
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_remove_canvas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_remove_canvas #-}

instance Method "viewport_remove_canvas" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_remove_canvas
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_canvas_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_canvas_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_canvas_transform #-}

instance Method "viewport_set_canvas_transform" GodotVisualServer
           (GodotRid -> GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_canvas_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_transparent_background
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_transparent_background" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_transparent_background
             #-}

instance Method "viewport_set_transparent_background"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_transparent_background
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_global_canvas_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_global_canvas_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_global_canvas_transform
             #-}

instance Method "viewport_set_global_canvas_transform"
           GodotVisualServer
           (GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_global_canvas_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_canvas_stacking
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_canvas_stacking" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_canvas_stacking #-}

instance Method "viewport_set_canvas_stacking" GodotVisualServer
           (GodotRid -> GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_canvas_stacking
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_shadow_atlas_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_shadow_atlas_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_shadow_atlas_size #-}

instance Method "viewport_set_shadow_atlas_size" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_shadow_atlas_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_shadow_atlas_quadrant_subdivision
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_shadow_atlas_quadrant_subdivision" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_shadow_atlas_quadrant_subdivision
             #-}

instance Method "viewport_set_shadow_atlas_quadrant_subdivision"
           GodotVisualServer
           (GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_viewport_set_shadow_atlas_quadrant_subdivision
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_msaa
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_msaa" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_msaa #-}

instance Method "viewport_set_msaa" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_msaa
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_hdr
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_hdr" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_hdr #-}

instance Method "viewport_set_hdr" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_hdr
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_usage
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_usage" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_usage #-}

instance Method "viewport_set_usage" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_usage
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_get_render_info
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_get_render_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_get_render_info #-}

instance Method "viewport_get_render_info" GodotVisualServer
           (GodotRid -> Int -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_get_render_info
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_viewport_set_debug_draw
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "viewport_set_debug_draw" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_viewport_set_debug_draw #-}

instance Method "viewport_set_debug_draw" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_viewport_set_debug_draw
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_create #-}

instance Method "environment_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_background
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_background" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_background #-}

instance Method "environment_set_background" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_background
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_sky
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_sky" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_sky #-}

instance Method "environment_set_sky" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_sky
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_sky_custom_fov
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_sky_custom_fov" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_sky_custom_fov #-}

instance Method "environment_set_sky_custom_fov" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_environment_set_sky_custom_fov
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_bg_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_bg_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_bg_color #-}

instance Method "environment_set_bg_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_bg_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_bg_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_bg_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_bg_energy #-}

instance Method "environment_set_bg_energy" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_bg_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_canvas_max_layer
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_canvas_max_layer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_canvas_max_layer #-}

instance Method "environment_set_canvas_max_layer"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_environment_set_canvas_max_layer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_ambient_light
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_ambient_light" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_ambient_light #-}

instance Method "environment_set_ambient_light" GodotVisualServer
           (GodotRid -> GodotColor -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_environment_set_ambient_light
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_dof_blur_near
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_dof_blur_near" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_dof_blur_near #-}

instance Method "environment_set_dof_blur_near" GodotVisualServer
           (GodotRid -> Bool -> Float -> Float -> Float -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_environment_set_dof_blur_near
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_dof_blur_far
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_dof_blur_far" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_dof_blur_far #-}

instance Method "environment_set_dof_blur_far" GodotVisualServer
           (GodotRid -> Bool -> Float -> Float -> Float -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_environment_set_dof_blur_far
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_glow
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_glow" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_glow #-}

instance Method "environment_set_glow" GodotVisualServer
           (GodotRid ->
              Bool ->
                Int ->
                  Float -> Float -> Float -> Int -> Float -> Float -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9, toVariant arg10]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_glow
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_tonemap
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_tonemap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_tonemap #-}

instance Method "environment_set_tonemap" GodotVisualServer
           (GodotRid ->
              Int ->
                Float ->
                  Float -> Bool -> Float -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_tonemap
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_adjustment
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_adjustment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_adjustment #-}

instance Method "environment_set_adjustment" GodotVisualServer
           (GodotRid -> Bool -> Float -> Float -> Float -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_adjustment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_ssr
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_ssr" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_ssr #-}

instance Method "environment_set_ssr" GodotVisualServer
           (GodotRid ->
              Bool -> Int -> Float -> Float -> Float -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_ssr
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_ssao
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_ssao" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_ssao #-}

instance Method "environment_set_ssao" GodotVisualServer
           (GodotRid ->
              Bool ->
                Float ->
                  Float ->
                    Float ->
                      Float ->
                        Float ->
                          Float -> Float -> GodotColor -> Int -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
          arg11 arg12 arg13
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9, toVariant arg10, toVariant arg11, toVariant arg12,
               toVariant arg13]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_ssao
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_fog
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_fog" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_fog #-}

instance Method "environment_set_fog" GodotVisualServer
           (GodotRid -> Bool -> GodotColor -> GodotColor -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_fog
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_fog_depth
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_fog_depth" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_fog_depth #-}

instance Method "environment_set_fog_depth" GodotVisualServer
           (GodotRid -> Bool -> Float -> Float -> Bool -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_fog_depth
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_environment_set_fog_height
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "environment_set_fog_height" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_environment_set_fog_height #-}

instance Method "environment_set_fog_height" GodotVisualServer
           (GodotRid -> Bool -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_environment_set_fog_height
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_scenario_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "scenario_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_scenario_create #-}

instance Method "scenario_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_scenario_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_scenario_set_debug
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "scenario_set_debug" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_scenario_set_debug #-}

instance Method "scenario_set_debug" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_scenario_set_debug
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_scenario_set_environment
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "scenario_set_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_scenario_set_environment #-}

instance Method "scenario_set_environment" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_scenario_set_environment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_scenario_set_reflection_atlas_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "scenario_set_reflection_atlas_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_scenario_set_reflection_atlas_size
             #-}

instance Method "scenario_set_reflection_atlas_size"
           GodotVisualServer
           (GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_scenario_set_reflection_atlas_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_scenario_set_fallback_environment
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "scenario_set_fallback_environment" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_scenario_set_fallback_environment #-}

instance Method "scenario_set_fallback_environment"
           GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_scenario_set_fallback_environment
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_create2
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_create2" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_create2 #-}

instance Method "instance_create2" GodotVisualServer
           (GodotRid -> GodotRid -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_create2
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_create #-}

instance Method "instance_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_base
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_base" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_base #-}

instance Method "instance_set_base" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_base
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_scenario
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_scenario" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_scenario #-}

instance Method "instance_set_scenario" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_scenario
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_layer_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_layer_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_layer_mask #-}

instance Method "instance_set_layer_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_layer_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_transform #-}

instance Method "instance_set_transform" GodotVisualServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_attach_object_instance_id
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_attach_object_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_attach_object_instance_id
             #-}

instance Method "instance_attach_object_instance_id"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_attach_object_instance_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_blend_shape_weight
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_blend_shape_weight" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_blend_shape_weight #-}

instance Method "instance_set_blend_shape_weight" GodotVisualServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_set_blend_shape_weight
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_surface_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_surface_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_surface_material #-}

instance Method "instance_set_surface_material" GodotVisualServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_set_surface_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_visible
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_visible" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_visible #-}

instance Method "instance_set_visible" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_visible
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_use_lightmap
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_use_lightmap" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_use_lightmap #-}

instance Method "instance_set_use_lightmap" GodotVisualServer
           (GodotRid -> GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_use_lightmap
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_custom_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_custom_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_custom_aabb #-}

instance Method "instance_set_custom_aabb" GodotVisualServer
           (GodotRid -> GodotAabb -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_custom_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_attach_skeleton
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_attach_skeleton" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_attach_skeleton #-}

instance Method "instance_attach_skeleton" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_attach_skeleton
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_exterior
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_exterior" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_exterior #-}

instance Method "instance_set_exterior" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_set_exterior
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_set_extra_visibility_margin
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_set_extra_visibility_margin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_set_extra_visibility_margin
             #-}

instance Method "instance_set_extra_visibility_margin"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_set_extra_visibility_margin
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_geometry_set_flag
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_geometry_set_flag" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_geometry_set_flag #-}

instance Method "instance_geometry_set_flag" GodotVisualServer
           (GodotRid -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instance_geometry_set_flag
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_geometry_set_cast_shadows_setting
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_geometry_set_cast_shadows_setting" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_geometry_set_cast_shadows_setting
             #-}

instance Method "instance_geometry_set_cast_shadows_setting"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_geometry_set_cast_shadows_setting
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_geometry_set_material_override
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_geometry_set_material_override" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_geometry_set_material_override
             #-}

instance Method "instance_geometry_set_material_override"
           GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_geometry_set_material_override
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_geometry_set_draw_range
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_geometry_set_draw_range" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_geometry_set_draw_range #-}

instance Method "instance_geometry_set_draw_range"
           GodotVisualServer
           (GodotRid -> Float -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_geometry_set_draw_range
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instance_geometry_set_as_instance_lod
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instance_geometry_set_as_instance_lod" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instance_geometry_set_as_instance_lod
             #-}

instance Method "instance_geometry_set_as_instance_lod"
           GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_instance_geometry_set_as_instance_lod
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instances_cull_aabb
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instances_cull_aabb" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instances_cull_aabb #-}

instance Method "instances_cull_aabb" GodotVisualServer
           (GodotAabb -> GodotRid -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instances_cull_aabb
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instances_cull_ray
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instances_cull_ray" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instances_cull_ray #-}

instance Method "instances_cull_ray" GodotVisualServer
           (GodotVector3 -> GodotVector3 -> GodotRid -> IO GodotArray)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instances_cull_ray
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_instances_cull_convex
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "instances_cull_convex" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_instances_cull_convex #-}

instance Method "instances_cull_convex" GodotVisualServer
           (GodotArray -> GodotRid -> IO GodotArray)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_instances_cull_convex
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_create #-}

instance Method "canvas_create" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_set_item_mirroring
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_set_item_mirroring" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_set_item_mirroring #-}

instance Method "canvas_set_item_mirroring" GodotVisualServer
           (GodotRid -> GodotRid -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_set_item_mirroring
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_set_modulate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_set_modulate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_set_modulate #-}

instance Method "canvas_set_modulate" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_set_modulate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_create #-}

instance Method "canvas_item_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_parent
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_parent" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_parent #-}

instance Method "canvas_item_set_parent" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_parent
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_visible
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_visible" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_visible #-}

instance Method "canvas_item_set_visible" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_visible
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_light_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_light_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_light_mask #-}

instance Method "canvas_item_set_light_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_light_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_transform #-}

instance Method "canvas_item_set_transform" GodotVisualServer
           (GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_clip
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_clip" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_clip #-}

instance Method "canvas_item_set_clip" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_clip
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_distance_field_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_distance_field_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_distance_field_mode
             #-}

instance Method "canvas_item_set_distance_field_mode"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_distance_field_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_custom_rect
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_custom_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_custom_rect #-}

instance Method "canvas_item_set_custom_rect" GodotVisualServer
           (GodotRid -> Bool -> GodotRect2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_custom_rect
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_modulate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_modulate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_modulate #-}

instance Method "canvas_item_set_modulate" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_modulate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_self_modulate
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_self_modulate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_self_modulate #-}

instance Method "canvas_item_set_self_modulate" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_self_modulate
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_draw_behind_parent
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_draw_behind_parent" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_draw_behind_parent
             #-}

instance Method "canvas_item_set_draw_behind_parent"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_draw_behind_parent
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_line
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_line" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_line #-}

instance Method "canvas_item_add_line" GodotVisualServer
           (GodotRid ->
              GodotVector2 ->
                GodotVector2 -> GodotColor -> Float -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_line
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_polyline
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_polyline" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_polyline #-}

instance Method "canvas_item_add_polyline" GodotVisualServer
           (GodotRid ->
              GodotPoolVector2Array ->
                GodotPoolColorArray -> Float -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_polyline
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_rect
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_rect #-}

instance Method "canvas_item_add_rect" GodotVisualServer
           (GodotRid -> GodotRect2 -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_rect
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_circle
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_circle" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_circle #-}

instance Method "canvas_item_add_circle" GodotVisualServer
           (GodotRid -> GodotVector2 -> Float -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_circle
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_texture_rect
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_texture_rect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_texture_rect #-}

instance Method "canvas_item_add_texture_rect" GodotVisualServer
           (GodotRid ->
              GodotRect2 ->
                GodotRid -> Bool -> GodotColor -> Bool -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_add_texture_rect
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_texture_rect_region
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_texture_rect_region" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_texture_rect_region
             #-}

instance Method "canvas_item_add_texture_rect_region"
           GodotVisualServer
           (GodotRid ->
              GodotRect2 ->
                GodotRid ->
                  GodotRect2 -> GodotColor -> Bool -> GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_add_texture_rect_region
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_nine_patch
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_nine_patch" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_nine_patch #-}

instance Method "canvas_item_add_nine_patch" GodotVisualServer
           (GodotRid ->
              GodotRect2 ->
                GodotRect2 ->
                  GodotRid ->
                    GodotVector2 ->
                      GodotVector2 ->
                        Int -> Int -> Bool -> GodotColor -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
          arg11
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9, toVariant arg10, toVariant arg11]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_nine_patch
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_primitive
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_primitive" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_primitive #-}

instance Method "canvas_item_add_primitive" GodotVisualServer
           (GodotRid ->
              GodotPoolVector2Array ->
                GodotPoolColorArray ->
                  GodotPoolVector2Array -> GodotRid -> Float -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_primitive
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_polygon
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_polygon" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_polygon #-}

instance Method "canvas_item_add_polygon" GodotVisualServer
           (GodotRid ->
              GodotPoolVector2Array ->
                GodotPoolColorArray ->
                  GodotPoolVector2Array -> GodotRid -> GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_polygon
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_triangle_array
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_triangle_array" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_triangle_array #-}

instance Method "canvas_item_add_triangle_array" GodotVisualServer
           (GodotRid ->
              GodotPoolIntArray ->
                GodotPoolVector2Array ->
                  GodotPoolColorArray ->
                    GodotPoolVector2Array ->
                      GodotPoolIntArray ->
                        GodotPoolRealArray -> GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6 arg7 arg8 arg9 arg10
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6, toVariant arg7, toVariant arg8,
               toVariant arg9, toVariant arg10]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_add_triangle_array
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_mesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_mesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_mesh #-}

instance Method "canvas_item_add_mesh" GodotVisualServer
           (GodotRid -> GodotRid -> GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_mesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_multimesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_multimesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_multimesh #-}

instance Method "canvas_item_add_multimesh" GodotVisualServer
           (GodotRid -> GodotRid -> GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_multimesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_particles
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_particles" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_particles #-}

instance Method "canvas_item_add_particles" GodotVisualServer
           (GodotRid ->
              GodotRid -> GodotRid -> GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4 arg5 arg6
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4,
               toVariant arg5, toVariant arg6]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_particles
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_set_transform #-}

instance Method "canvas_item_add_set_transform" GodotVisualServer
           (GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_add_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_add_clip_ignore
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_add_clip_ignore" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_add_clip_ignore #-}

instance Method "canvas_item_add_clip_ignore" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_add_clip_ignore
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_sort_children_by_y
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_sort_children_by_y" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_sort_children_by_y
             #-}

instance Method "canvas_item_set_sort_children_by_y"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_sort_children_by_y
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_z_index
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_z_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_z_index #-}

instance Method "canvas_item_set_z_index" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_z_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_z_as_relative_to_parent
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_z_as_relative_to_parent" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_z_as_relative_to_parent
             #-}

instance Method "canvas_item_set_z_as_relative_to_parent"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_z_as_relative_to_parent
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_copy_to_backbuffer
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_copy_to_backbuffer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_copy_to_backbuffer
             #-}

instance Method "canvas_item_set_copy_to_backbuffer"
           GodotVisualServer
           (GodotRid -> Bool -> GodotRect2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_copy_to_backbuffer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_clear
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_clear" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_clear #-}

instance Method "canvas_item_clear" GodotVisualServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_clear
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_draw_index
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_draw_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_draw_index #-}

instance Method "canvas_item_set_draw_index" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_draw_index
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_material #-}

instance Method "canvas_item_set_material" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_item_set_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_item_set_use_parent_material
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_item_set_use_parent_material" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_item_set_use_parent_material
             #-}

instance Method "canvas_item_set_use_parent_material"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_item_set_use_parent_material
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_create #-}

instance Method "canvas_light_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_attach_to_canvas
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_attach_to_canvas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_attach_to_canvas #-}

instance Method "canvas_light_attach_to_canvas" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_attach_to_canvas
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_enabled
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_enabled #-}

instance Method "canvas_light_set_enabled" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_scale
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_scale #-}

instance Method "canvas_light_set_scale" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_scale
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_transform #-}

instance Method "canvas_light_set_transform" GodotVisualServer
           (GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_texture
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_texture" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_texture #-}

instance Method "canvas_light_set_texture" GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_texture
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_texture_offset
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_texture_offset" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_texture_offset #-}

instance Method "canvas_light_set_texture_offset" GodotVisualServer
           (GodotRid -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_texture_offset
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_color #-}

instance Method "canvas_light_set_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_height
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_height" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_height #-}

instance Method "canvas_light_set_height" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_height
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_energy
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_energy" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_energy #-}

instance Method "canvas_light_set_energy" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_energy
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_z_range
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_z_range" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_z_range #-}

instance Method "canvas_light_set_z_range" GodotVisualServer
           (GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_z_range
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_layer_range
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_layer_range" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_layer_range #-}

instance Method "canvas_light_set_layer_range" GodotVisualServer
           (GodotRid -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_layer_range
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_item_cull_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_item_cull_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_item_cull_mask #-}

instance Method "canvas_light_set_item_cull_mask" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_item_cull_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_item_shadow_cull_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_item_shadow_cull_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_item_shadow_cull_mask
             #-}

instance Method "canvas_light_set_item_shadow_cull_mask"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_item_shadow_cull_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_mode #-}

instance Method "canvas_light_set_mode" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_canvas_light_set_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_enabled
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_enabled #-}

instance Method "canvas_light_set_shadow_enabled" GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_buffer_size
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_buffer_size" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_buffer_size
             #-}

instance Method "canvas_light_set_shadow_buffer_size"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_buffer_size
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_gradient_length
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_gradient_length" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_gradient_length
             #-}

instance Method "canvas_light_set_shadow_gradient_length"
           GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_gradient_length
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_filter
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_filter" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_filter #-}

instance Method "canvas_light_set_shadow_filter" GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_filter
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_color #-}

instance Method "canvas_light_set_shadow_color" GodotVisualServer
           (GodotRid -> GodotColor -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_set_shadow_smooth
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_set_shadow_smooth" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_set_shadow_smooth #-}

instance Method "canvas_light_set_shadow_smooth" GodotVisualServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_set_shadow_smooth
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_create #-}

instance Method "canvas_light_occluder_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_attach_to_canvas
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_attach_to_canvas" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_attach_to_canvas
             #-}

instance Method "canvas_light_occluder_attach_to_canvas"
           GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_attach_to_canvas
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_set_enabled
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_set_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_set_enabled #-}

instance Method "canvas_light_occluder_set_enabled"
           GodotVisualServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_set_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_set_polygon
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_set_polygon" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_set_polygon #-}

instance Method "canvas_light_occluder_set_polygon"
           GodotVisualServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_set_polygon
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_set_transform
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_set_transform
             #-}

instance Method "canvas_light_occluder_set_transform"
           GodotVisualServer
           (GodotRid -> GodotTransform2d -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_light_occluder_set_light_mask
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_light_occluder_set_light_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_light_occluder_set_light_mask
             #-}

instance Method "canvas_light_occluder_set_light_mask"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_light_occluder_set_light_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_occluder_polygon_create
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_occluder_polygon_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_occluder_polygon_create #-}

instance Method "canvas_occluder_polygon_create" GodotVisualServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_occluder_polygon_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_occluder_polygon_set_shape
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_occluder_polygon_set_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_occluder_polygon_set_shape #-}

instance Method "canvas_occluder_polygon_set_shape"
           GodotVisualServer
           (GodotRid -> GodotPoolVector2Array -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_occluder_polygon_set_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_occluder_polygon_set_shape_as_lines
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_occluder_polygon_set_shape_as_lines" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_occluder_polygon_set_shape_as_lines
             #-}

instance Method "canvas_occluder_polygon_set_shape_as_lines"
           GodotVisualServer
           (GodotRid -> GodotPoolVector2Array -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_occluder_polygon_set_shape_as_lines
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_canvas_occluder_polygon_set_cull_mode
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "canvas_occluder_polygon_set_cull_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_canvas_occluder_polygon_set_cull_mode
             #-}

instance Method "canvas_occluder_polygon_set_cull_mode"
           GodotVisualServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_canvas_occluder_polygon_set_cull_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_black_bars_set_margins
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "black_bars_set_margins" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_black_bars_set_margins #-}

instance Method "black_bars_set_margins" GodotVisualServer
           (Int -> Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_black_bars_set_margins
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_black_bars_set_images
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "black_bars_set_images" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_black_bars_set_images #-}

instance Method "black_bars_set_images" GodotVisualServer
           (GodotRid -> GodotRid -> GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_black_bars_set_images
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_free_rid
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "free_rid" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_free_rid #-}

instance Method "free_rid" GodotVisualServer (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_free_rid (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_request_frame_drawn_callback
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "request_frame_drawn_callback" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_request_frame_drawn_callback #-}

instance Method "request_frame_drawn_callback" GodotVisualServer
           (GodotObject -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_request_frame_drawn_callback
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_has_changed
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "has_changed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_has_changed #-}

instance Method "has_changed" GodotVisualServer (IO Bool) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_has_changed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_init
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "init" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_init #-}

instance Method "init" GodotVisualServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_init (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_finish
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "finish" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_finish #-}

instance Method "finish" GodotVisualServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_finish (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_get_render_info
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "get_render_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_get_render_info #-}

instance Method "get_render_info" GodotVisualServer (Int -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_get_render_info
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_make_sphere_mesh
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "make_sphere_mesh" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_make_sphere_mesh #-}

instance Method "make_sphere_mesh" GodotVisualServer
           (Int -> Int -> Float -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_make_sphere_mesh
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_get_test_cube
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "get_test_cube" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_get_test_cube #-}

instance Method "get_test_cube" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_get_test_cube (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_get_test_texture
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "get_test_texture" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_get_test_texture #-}

instance Method "get_test_texture" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_get_test_texture
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_get_white_texture
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "get_white_texture" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_get_white_texture #-}

instance Method "get_white_texture" GodotVisualServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_get_white_texture
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_set_boot_image
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "set_boot_image" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_set_boot_image #-}

instance Method "set_boot_image" GodotVisualServer
           (GodotImage -> GodotColor -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_set_boot_image (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_set_default_clear_color
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "set_default_clear_color" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_set_default_clear_color #-}

instance Method "set_default_clear_color" GodotVisualServer
           (GodotColor -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_set_default_clear_color
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_has_feature
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "has_feature" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_has_feature #-}

instance Method "has_feature" GodotVisualServer (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_has_feature (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_has_os_feature
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "has_os_feature" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_has_os_feature #-}

instance Method "has_os_feature" GodotVisualServer
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindVisualServer_has_os_feature (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindVisualServer_set_debug_generate_wireframes
  = unsafePerformIO $
      withCString "VisualServer" $
        \ clsNamePtr ->
          withCString "set_debug_generate_wireframes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindVisualServer_set_debug_generate_wireframes #-}

instance Method "set_debug_generate_wireframes" GodotVisualServer
           (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindVisualServer_set_debug_generate_wireframes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInput = GodotInput GodotObject
                       deriving newtype AsVariant

instance HasBaseClass GodotInput where
        type BaseClass GodotInput = GodotObject
        super = coerce
bindInput_is_key_pressed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_key_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_key_pressed #-}

instance Method "is_key_pressed" GodotInput (Int -> IO Bool) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_key_pressed (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_mouse_button_pressed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_mouse_button_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_mouse_button_pressed #-}

instance Method "is_mouse_button_pressed" GodotInput
           (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_mouse_button_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_joy_button_pressed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_joy_button_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_joy_button_pressed #-}

instance Method "is_joy_button_pressed" GodotInput
           (Int -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_joy_button_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_action_pressed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_action_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_action_pressed #-}

instance Method "is_action_pressed" GodotInput
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_action_pressed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_action_just_pressed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_action_just_pressed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_action_just_pressed #-}

instance Method "is_action_just_pressed" GodotInput
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_action_just_pressed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_action_just_released
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_action_just_released" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_action_just_released #-}

instance Method "is_action_just_released" GodotInput
           (GodotString -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_action_just_released
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_action_strength
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_action_strength" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_action_strength #-}

instance Method "get_action_strength" GodotInput
           (GodotString -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_action_strength (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_add_joy_mapping
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "add_joy_mapping" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_add_joy_mapping #-}

instance Method "add_joy_mapping" GodotInput
           (GodotString -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_add_joy_mapping (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_remove_joy_mapping
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "remove_joy_mapping" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_remove_joy_mapping #-}

instance Method "remove_joy_mapping" GodotInput
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_remove_joy_mapping (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_joy_connection_changed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "joy_connection_changed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_joy_connection_changed #-}

instance Method "joy_connection_changed" GodotInput
           (Int -> Bool -> GodotString -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_joy_connection_changed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_is_joy_known
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "is_joy_known" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_is_joy_known #-}

instance Method "is_joy_known" GodotInput (Int -> IO Bool) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_is_joy_known (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_axis
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_axis" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_axis #-}

instance Method "get_joy_axis" GodotInput (Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_axis (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_name
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_name #-}

instance Method "get_joy_name" GodotInput (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_name (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_guid
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_guid" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_guid #-}

instance Method "get_joy_guid" GodotInput (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_guid (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_connected_joypads
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_connected_joypads" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_connected_joypads #-}

instance Method "get_connected_joypads" GodotInput (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_connected_joypads (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_vibration_strength
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_vibration_strength" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_vibration_strength #-}

instance Method "get_joy_vibration_strength" GodotInput
           (Int -> IO GodotVector2)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_vibration_strength
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_vibration_duration
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_vibration_duration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_vibration_duration #-}

instance Method "get_joy_vibration_duration" GodotInput
           (Int -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_vibration_duration
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_button_string
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_button_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_button_string #-}

instance Method "get_joy_button_string" GodotInput
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_button_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_button_index_from_string
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_button_index_from_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_button_index_from_string #-}

instance Method "get_joy_button_index_from_string" GodotInput
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_button_index_from_string
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_axis_string
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_axis_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_axis_string #-}

instance Method "get_joy_axis_string" GodotInput
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_axis_string (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_joy_axis_index_from_string
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_joy_axis_index_from_string" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_joy_axis_index_from_string #-}

instance Method "get_joy_axis_index_from_string" GodotInput
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_joy_axis_index_from_string
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_start_joy_vibration
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "start_joy_vibration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_start_joy_vibration #-}

instance Method "start_joy_vibration" GodotInput
           (Int -> Float -> Float -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_start_joy_vibration (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_stop_joy_vibration
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "stop_joy_vibration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_stop_joy_vibration #-}

instance Method "stop_joy_vibration" GodotInput (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_stop_joy_vibration (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_gravity
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_gravity" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_gravity #-}

instance Method "get_gravity" GodotInput (IO GodotVector3) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_gravity (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_accelerometer
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_accelerometer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_accelerometer #-}

instance Method "get_accelerometer" GodotInput (IO GodotVector3)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_accelerometer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_magnetometer
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_magnetometer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_magnetometer #-}

instance Method "get_magnetometer" GodotInput (IO GodotVector3)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_magnetometer (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_gyroscope
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_gyroscope" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_gyroscope #-}

instance Method "get_gyroscope" GodotInput (IO GodotVector3) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_gyroscope (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_last_mouse_speed
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_last_mouse_speed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_last_mouse_speed #-}

instance Method "get_last_mouse_speed" GodotInput (IO GodotVector2)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_last_mouse_speed (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_mouse_button_mask
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_mouse_button_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_mouse_button_mask #-}

instance Method "get_mouse_button_mask" GodotInput (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_mouse_button_mask (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_set_mouse_mode
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "set_mouse_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_set_mouse_mode #-}

instance Method "set_mouse_mode" GodotInput (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_set_mouse_mode (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_get_mouse_mode
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "get_mouse_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_get_mouse_mode #-}

instance Method "get_mouse_mode" GodotInput (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_get_mouse_mode (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_warp_mouse_position
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "warp_mouse_position" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_warp_mouse_position #-}

instance Method "warp_mouse_position" GodotInput
           (GodotVector2 -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_warp_mouse_position (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_action_press
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "action_press" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_action_press #-}

instance Method "action_press" GodotInput (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_action_press (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_action_release
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "action_release" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_action_release #-}

instance Method "action_release" GodotInput (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_action_release (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_set_default_cursor_shape
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "set_default_cursor_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_set_default_cursor_shape #-}

instance Method "set_default_cursor_shape" GodotInput
           (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_set_default_cursor_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_set_custom_mouse_cursor
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "set_custom_mouse_cursor" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_set_custom_mouse_cursor #-}

instance Method "set_custom_mouse_cursor" GodotInput
           (GodotResource -> Int -> GodotVector2 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_set_custom_mouse_cursor
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindInput_parse_input_event
  = unsafePerformIO $
      withCString "Input" $
        \ clsNamePtr ->
          withCString "parse_input_event" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindInput_parse_input_event #-}

instance Method "parse_input_event" GodotInput
           (GodotInputEvent -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindInput_parse_input_event (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotInputDefault = GodotInputDefault GodotObject
                              deriving newtype AsVariant

instance HasBaseClass GodotInputDefault where
        type BaseClass GodotInputDefault = GodotInput
        super = coerce

newtype GodotAudioServer = GodotAudioServer GodotObject
                             deriving newtype AsVariant

instance HasBaseClass GodotAudioServer where
        type BaseClass GodotAudioServer = GodotObject
        super = coerce
bindAudioServer_set_bus_count
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_count #-}

instance Method "set_bus_count" GodotAudioServer (Int -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_count
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_count #-}

instance Method "get_bus_count" GodotAudioServer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_count (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_remove_bus
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "remove_bus" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_remove_bus #-}

instance Method "remove_bus" GodotAudioServer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_remove_bus (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_add_bus
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "add_bus" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_add_bus #-}

instance Method "add_bus" GodotAudioServer (Int -> IO ()) where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_add_bus (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_move_bus
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "move_bus" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_move_bus #-}

instance Method "move_bus" GodotAudioServer (Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_move_bus (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_name
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_name #-}

instance Method "set_bus_name" GodotAudioServer
           (Int -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_name (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_name
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_name" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_name #-}

instance Method "get_bus_name" GodotAudioServer
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_name (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_index
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_index" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_index #-}

instance Method "get_bus_index" GodotAudioServer
           (GodotString -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_index (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_volume_db
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_volume_db" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_volume_db #-}

instance Method "set_bus_volume_db" GodotAudioServer
           (Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_volume_db
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_volume_db
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_volume_db" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_volume_db #-}

instance Method "get_bus_volume_db" GodotAudioServer
           (Int -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_volume_db
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_send
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_send" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_send #-}

instance Method "set_bus_send" GodotAudioServer
           (Int -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_send (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_send
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_send" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_send #-}

instance Method "get_bus_send" GodotAudioServer
           (Int -> IO GodotString)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_send (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_solo
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_solo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_solo #-}

instance Method "set_bus_solo" GodotAudioServer
           (Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_solo (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_is_bus_solo
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "is_bus_solo" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_is_bus_solo #-}

instance Method "is_bus_solo" GodotAudioServer (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_is_bus_solo (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_mute
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_mute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_mute #-}

instance Method "set_bus_mute" GodotAudioServer
           (Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_mute (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_is_bus_mute
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "is_bus_mute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_is_bus_mute #-}

instance Method "is_bus_mute" GodotAudioServer (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_is_bus_mute (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_bypass_effects
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_bypass_effects" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_bypass_effects #-}

instance Method "set_bus_bypass_effects" GodotAudioServer
           (Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_bypass_effects
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_is_bus_bypassing_effects
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "is_bus_bypassing_effects" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_is_bus_bypassing_effects #-}

instance Method "is_bus_bypassing_effects" GodotAudioServer
           (Int -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_is_bus_bypassing_effects
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_add_bus_effect
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "add_bus_effect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_add_bus_effect #-}

instance Method "add_bus_effect" GodotAudioServer
           (Int -> GodotAudioEffect -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_add_bus_effect (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_remove_bus_effect
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "remove_bus_effect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_remove_bus_effect #-}

instance Method "remove_bus_effect" GodotAudioServer
           (Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_remove_bus_effect
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_effect_count
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_effect_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_effect_count #-}

instance Method "get_bus_effect_count" GodotAudioServer
           (Int -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_effect_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_effect
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_effect" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_effect #-}

instance Method "get_bus_effect" GodotAudioServer
           (Int -> Int -> IO GodotAudioEffect)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_effect (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_swap_bus_effects
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "swap_bus_effects" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_swap_bus_effects #-}

instance Method "swap_bus_effects" GodotAudioServer
           (Int -> Int -> Int -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_swap_bus_effects
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_effect_enabled
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_effect_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_effect_enabled #-}

instance Method "set_bus_effect_enabled" GodotAudioServer
           (Int -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_effect_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_is_bus_effect_enabled
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "is_bus_effect_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_is_bus_effect_enabled #-}

instance Method "is_bus_effect_enabled" GodotAudioServer
           (Int -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_is_bus_effect_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_peak_volume_left_db
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_peak_volume_left_db" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_peak_volume_left_db #-}

instance Method "get_bus_peak_volume_left_db" GodotAudioServer
           (Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_peak_volume_left_db
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_bus_peak_volume_right_db
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_bus_peak_volume_right_db" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_bus_peak_volume_right_db #-}

instance Method "get_bus_peak_volume_right_db" GodotAudioServer
           (Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_bus_peak_volume_right_db
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_lock
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "lock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_lock #-}

instance Method "lock" GodotAudioServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_lock (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_unlock
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "unlock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_unlock #-}

instance Method "unlock" GodotAudioServer (IO ()) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_unlock (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_speaker_mode
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_speaker_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_speaker_mode #-}

instance Method "get_speaker_mode" GodotAudioServer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_speaker_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_mix_rate
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_mix_rate" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_mix_rate #-}

instance Method "get_mix_rate" GodotAudioServer (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_mix_rate (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_device_list
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_device_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_device_list #-}

instance Method "get_device_list" GodotAudioServer (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_device_list (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_get_device
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "get_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_get_device #-}

instance Method "get_device" GodotAudioServer (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_get_device (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_device
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_device #-}

instance Method "set_device" GodotAudioServer
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_device (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_capture_get_device_list
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "capture_get_device_list" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_capture_get_device_list #-}

instance Method "capture_get_device_list" GodotAudioServer
           (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_capture_get_device_list
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_capture_get_device
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "capture_get_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_capture_get_device #-}

instance Method "capture_get_device" GodotAudioServer
           (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_capture_get_device
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_capture_set_device
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "capture_set_device" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_capture_set_device #-}

instance Method "capture_set_device" GodotAudioServer
           (GodotString -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_capture_set_device
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_set_bus_layout
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "set_bus_layout" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_set_bus_layout #-}

instance Method "set_bus_layout" GodotAudioServer
           (GodotAudioBusLayout -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_set_bus_layout (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindAudioServer_generate_bus_layout
  = unsafePerformIO $
      withCString "AudioServer" $
        \ clsNamePtr ->
          withCString "generate_bus_layout" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindAudioServer_generate_bus_layout #-}

instance Method "generate_bus_layout" GodotAudioServer
           (IO GodotAudioBusLayout)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindAudioServer_generate_bus_layout
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotARVRServer = GodotARVRServer GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotARVRServer where
        type BaseClass GodotARVRServer = GodotObject
        super = coerce
bindARVRServer_get_world_scale
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_world_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_world_scale #-}

instance Method "get_world_scale" GodotARVRServer (IO Float) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_world_scale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_set_world_scale
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "set_world_scale" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_set_world_scale #-}

instance Method "set_world_scale" GodotARVRServer (Float -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_set_world_scale (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_reference_frame
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_reference_frame" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_reference_frame #-}

instance Method "get_reference_frame" GodotARVRServer
           (IO GodotTransform)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_reference_frame
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_center_on_hmd
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "center_on_hmd" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_center_on_hmd #-}

instance Method "center_on_hmd" GodotARVRServer
           (Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_center_on_hmd (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_hmd_transform
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_hmd_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_hmd_transform #-}

instance Method "get_hmd_transform" GodotARVRServer
           (IO GodotTransform)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_hmd_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_interface_count
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_interface_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_interface_count #-}

instance Method "get_interface_count" GodotARVRServer (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_interface_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_interface
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_interface" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_interface #-}

instance Method "get_interface" GodotARVRServer
           (Int -> IO GodotARVRInterface)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_interface (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_interfaces
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_interfaces" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_interfaces #-}

instance Method "get_interfaces" GodotARVRServer (IO GodotArray)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_interfaces (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_find_interface
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "find_interface" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_find_interface #-}

instance Method "find_interface" GodotARVRServer
           (GodotString -> IO GodotARVRInterface)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_find_interface (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_tracker_count
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_tracker_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_tracker_count #-}

instance Method "get_tracker_count" GodotARVRServer (IO Int) where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_tracker_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_tracker
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_tracker" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_tracker #-}

instance Method "get_tracker" GodotARVRServer
           (Int -> IO GodotARVRPositionalTracker)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_tracker (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_primary_interface
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_primary_interface" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_primary_interface #-}

instance Method "get_primary_interface" GodotARVRServer
           (IO GodotARVRInterface)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_primary_interface
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_set_primary_interface
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "set_primary_interface" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_set_primary_interface #-}

instance Method "set_primary_interface" GodotARVRServer
           (GodotARVRInterface -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_set_primary_interface
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_last_process_usec
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_last_process_usec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_last_process_usec #-}

instance Method "get_last_process_usec" GodotARVRServer (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_last_process_usec
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_last_commit_usec
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_last_commit_usec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_last_commit_usec #-}

instance Method "get_last_commit_usec" GodotARVRServer (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_last_commit_usec
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindARVRServer_get_last_frame_usec
  = unsafePerformIO $
      withCString "ARVRServer" $
        \ clsNamePtr ->
          withCString "get_last_frame_usec" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindARVRServer_get_last_frame_usec #-}

instance Method "get_last_frame_usec" GodotARVRServer (IO Int)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindARVRServer_get_last_frame_usec
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotExpression = GodotExpression GodotObject
                            deriving newtype AsVariant

instance HasBaseClass GodotExpression where
        type BaseClass GodotExpression = GodotReference
        super = coerce
bindExpression_parse
  = unsafePerformIO $
      withCString "Expression" $
        \ clsNamePtr ->
          withCString "parse" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindExpression_parse #-}

instance Method "parse" GodotExpression
           (GodotString -> GodotPoolStringArray -> IO Int)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindExpression_parse (coerce cls) arrPtr len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindExpression_execute
  = unsafePerformIO $
      withCString "Expression" $
        \ clsNamePtr ->
          withCString "execute" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindExpression_execute #-}

instance Method "execute" GodotExpression
           (GodotArray -> GodotObject -> Bool -> IO GodotVariant)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindExpression_execute (coerce cls) arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindExpression_has_execute_failed
  = unsafePerformIO $
      withCString "Expression" $
        \ clsNamePtr ->
          withCString "has_execute_failed" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindExpression_has_execute_failed #-}

instance Method "has_execute_failed" GodotExpression (IO Bool)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindExpression_has_execute_failed
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindExpression_get_error_text
  = unsafePerformIO $
      withCString "Expression" $
        \ clsNamePtr ->
          withCString "get_error_text" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindExpression_get_error_text #-}

instance Method "get_error_text" GodotExpression (IO GodotString)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindExpression_get_error_text (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPhysicsServer = GodotPhysicsServer GodotObject
                               deriving newtype AsVariant

instance HasBaseClass GodotPhysicsServer where
        type BaseClass GodotPhysicsServer = GodotObject
        super = coerce
bindPhysicsServer_shape_create
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "shape_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_shape_create #-}

instance Method "shape_create" GodotPhysicsServer
           (Int -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_shape_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_shape_set_data
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "shape_set_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_shape_set_data #-}

instance Method "shape_set_data" GodotPhysicsServer
           (GodotRid -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_shape_set_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_shape_get_type
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "shape_get_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_shape_get_type #-}

instance Method "shape_get_type" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_shape_get_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_shape_get_data
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "shape_get_data" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_shape_get_data #-}

instance Method "shape_get_data" GodotPhysicsServer
           (GodotRid -> IO GodotVariant)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_shape_get_data
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_create
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_create #-}

instance Method "space_create" GodotPhysicsServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_set_active
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_set_active" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_set_active #-}

instance Method "space_set_active" GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_set_active
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_is_active
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_is_active" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_is_active #-}

instance Method "space_is_active" GodotPhysicsServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_is_active
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_set_param #-}

instance Method "space_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_get_param #-}

instance Method "space_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_space_get_direct_state
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "space_get_direct_state" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_space_get_direct_state #-}

instance Method "space_get_direct_state" GodotPhysicsServer
           (GodotRid -> IO GodotPhysicsDirectSpaceState)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_space_get_direct_state
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_create
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_create #-}

instance Method "area_create" GodotPhysicsServer (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_space
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_space" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_space #-}

instance Method "area_set_space" GodotPhysicsServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_space
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_space
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_space" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_space #-}

instance Method "area_get_space" GodotPhysicsServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_space
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_space_override_mode
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_space_override_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_space_override_mode #-}

instance Method "area_set_space_override_mode" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_area_set_space_override_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_space_override_mode
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_space_override_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_space_override_mode #-}

instance Method "area_get_space_override_mode" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_area_get_space_override_mode
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_add_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_add_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_add_shape #-}

instance Method "area_add_shape" GodotPhysicsServer
           (GodotRid -> GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_add_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_shape #-}

instance Method "area_set_shape" GodotPhysicsServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_shape_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_shape_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_shape_transform #-}

instance Method "area_set_shape_transform" GodotPhysicsServer
           (GodotRid -> Int -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_shape_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_shape_count
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_shape_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_shape_count #-}

instance Method "area_get_shape_count" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_shape_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_shape #-}

instance Method "area_get_shape" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_shape_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_shape_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_shape_transform #-}

instance Method "area_get_shape_transform" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotTransform)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_shape_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_remove_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_remove_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_remove_shape #-}

instance Method "area_remove_shape" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_remove_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_clear_shapes
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_clear_shapes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_clear_shapes #-}

instance Method "area_clear_shapes" GodotPhysicsServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_clear_shapes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_collision_layer
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_collision_layer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_collision_layer #-}

instance Method "area_set_collision_layer" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_collision_layer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_collision_mask
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_collision_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_collision_mask #-}

instance Method "area_set_collision_mask" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_collision_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_param #-}

instance Method "area_set_param" GodotPhysicsServer
           (GodotRid -> Int -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_transform #-}

instance Method "area_set_transform" GodotPhysicsServer
           (GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_param #-}

instance Method "area_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_transform #-}

instance Method "area_get_transform" GodotPhysicsServer
           (GodotRid -> IO GodotTransform)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_get_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_attach_object_instance_id
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_attach_object_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_attach_object_instance_id #-}

instance Method "area_attach_object_instance_id" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_area_attach_object_instance_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_get_object_instance_id
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_get_object_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_get_object_instance_id #-}

instance Method "area_get_object_instance_id" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_area_get_object_instance_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_monitor_callback
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_monitor_callback" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_monitor_callback #-}

instance Method "area_set_monitor_callback" GodotPhysicsServer
           (GodotRid -> GodotObject -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_monitor_callback
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_area_monitor_callback
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_area_monitor_callback" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_area_monitor_callback #-}

instance Method "area_set_area_monitor_callback" GodotPhysicsServer
           (GodotRid -> GodotObject -> GodotString -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_area_set_area_monitor_callback
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_monitorable
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_monitorable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_monitorable #-}

instance Method "area_set_monitorable" GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_monitorable
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_set_ray_pickable
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_set_ray_pickable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_set_ray_pickable #-}

instance Method "area_set_ray_pickable" GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_set_ray_pickable
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_area_is_ray_pickable
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "area_is_ray_pickable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_area_is_ray_pickable #-}

instance Method "area_is_ray_pickable" GodotPhysicsServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_area_is_ray_pickable
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_create
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_create #-}

instance Method "body_create" GodotPhysicsServer
           (Int -> Bool -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_create (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_space
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_space" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_space #-}

instance Method "body_set_space" GodotPhysicsServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_space
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_space
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_space" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_space #-}

instance Method "body_get_space" GodotPhysicsServer
           (GodotRid -> IO GodotRid)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_space
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_mode
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_mode #-}

instance Method "body_set_mode" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_mode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_mode
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_mode" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_mode #-}

instance Method "body_get_mode" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_mode (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_collision_layer
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_collision_layer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_collision_layer #-}

instance Method "body_set_collision_layer" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_collision_layer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_collision_layer
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_collision_layer" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_collision_layer #-}

instance Method "body_get_collision_layer" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_collision_layer
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_collision_mask
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_collision_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_collision_mask #-}

instance Method "body_set_collision_mask" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_collision_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_collision_mask
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_collision_mask" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_collision_mask #-}

instance Method "body_get_collision_mask" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_collision_mask
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_add_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_add_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_add_shape #-}

instance Method "body_add_shape" GodotPhysicsServer
           (GodotRid -> GodotRid -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_add_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_shape #-}

instance Method "body_set_shape" GodotPhysicsServer
           (GodotRid -> Int -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_shape_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_shape_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_shape_transform #-}

instance Method "body_set_shape_transform" GodotPhysicsServer
           (GodotRid -> Int -> GodotTransform -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_shape_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_shape_count
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_shape_count" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_shape_count #-}

instance Method "body_get_shape_count" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_shape_count
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_shape #-}

instance Method "body_get_shape" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotRid)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_shape_transform
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_shape_transform" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_shape_transform #-}

instance Method "body_get_shape_transform" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotTransform)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_shape_transform
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_remove_shape
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_remove_shape" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_remove_shape #-}

instance Method "body_remove_shape" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_remove_shape
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_clear_shapes
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_clear_shapes" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_clear_shapes #-}

instance Method "body_clear_shapes" GodotPhysicsServer
           (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_clear_shapes
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_attach_object_instance_id
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_attach_object_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_attach_object_instance_id #-}

instance Method "body_attach_object_instance_id" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_attach_object_instance_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_object_instance_id
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_object_instance_id" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_object_instance_id #-}

instance Method "body_get_object_instance_id" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_get_object_instance_id
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_enable_continuous_collision_detection
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_enable_continuous_collision_detection" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_enable_continuous_collision_detection
             #-}

instance Method "body_set_enable_continuous_collision_detection"
           GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_set_enable_continuous_collision_detection
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_is_continuous_collision_detection_enabled
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_is_continuous_collision_detection_enabled" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_is_continuous_collision_detection_enabled
             #-}

instance Method "body_is_continuous_collision_detection_enabled"
           GodotPhysicsServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_is_continuous_collision_detection_enabled
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_param #-}

instance Method "body_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_param #-}

instance Method "body_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_kinematic_safe_margin
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_kinematic_safe_margin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_kinematic_safe_margin #-}

instance Method "body_set_kinematic_safe_margin" GodotPhysicsServer
           (GodotRid -> Float -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_set_kinematic_safe_margin
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_kinematic_safe_margin
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_kinematic_safe_margin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_kinematic_safe_margin #-}

instance Method "body_get_kinematic_safe_margin" GodotPhysicsServer
           (GodotRid -> IO Float)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_get_kinematic_safe_margin
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_state
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_state" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_state #-}

instance Method "body_set_state" GodotPhysicsServer
           (GodotRid -> Int -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_state
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_state
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_state" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_state #-}

instance Method "body_get_state" GodotPhysicsServer
           (GodotRid -> Int -> IO GodotVariant)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_state
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_add_central_force
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_add_central_force" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_add_central_force #-}

instance Method "body_add_central_force" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_add_central_force
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_add_force
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_add_force" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_add_force #-}

instance Method "body_add_force" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_add_force
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_add_torque
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_add_torque" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_add_torque #-}

instance Method "body_add_torque" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_add_torque
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_apply_central_impulse
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_apply_central_impulse" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_apply_central_impulse #-}

instance Method "body_apply_central_impulse" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_apply_central_impulse
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_apply_impulse
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_apply_impulse" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_apply_impulse #-}

instance Method "body_apply_impulse" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_apply_impulse
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_apply_torque_impulse
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_apply_torque_impulse" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_apply_torque_impulse #-}

instance Method "body_apply_torque_impulse" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_apply_torque_impulse
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_axis_velocity
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_axis_velocity" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_axis_velocity #-}

instance Method "body_set_axis_velocity" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_axis_velocity
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_axis_lock
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_axis_lock" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_axis_lock #-}

instance Method "body_set_axis_lock" GodotPhysicsServer
           (GodotRid -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_axis_lock
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_is_axis_locked
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_is_axis_locked" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_is_axis_locked #-}

instance Method "body_is_axis_locked" GodotPhysicsServer
           (GodotRid -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_is_axis_locked
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_add_collision_exception
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_add_collision_exception" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_add_collision_exception #-}

instance Method "body_add_collision_exception" GodotPhysicsServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_add_collision_exception
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_remove_collision_exception
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_remove_collision_exception" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_remove_collision_exception #-}

instance Method "body_remove_collision_exception"
           GodotPhysicsServer
           (GodotRid -> GodotRid -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_remove_collision_exception
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_max_contacts_reported
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_max_contacts_reported" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_max_contacts_reported #-}

instance Method "body_set_max_contacts_reported" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_set_max_contacts_reported
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_max_contacts_reported
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_max_contacts_reported" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_max_contacts_reported #-}

instance Method "body_get_max_contacts_reported" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_get_max_contacts_reported
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_omit_force_integration
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_omit_force_integration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_omit_force_integration #-}

instance Method "body_set_omit_force_integration"
           GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_set_omit_force_integration
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_is_omitting_force_integration
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_is_omitting_force_integration" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_is_omitting_force_integration
             #-}

instance Method "body_is_omitting_force_integration"
           GodotPhysicsServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_is_omitting_force_integration
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_force_integration_callback
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_force_integration_callback" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_force_integration_callback
             #-}

instance Method "body_set_force_integration_callback"
           GodotPhysicsServer
           (GodotRid -> GodotObject -> GodotString -> GodotVariant -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_body_set_force_integration_callback
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_set_ray_pickable
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_set_ray_pickable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_set_ray_pickable #-}

instance Method "body_set_ray_pickable" GodotPhysicsServer
           (GodotRid -> Bool -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_set_ray_pickable
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_is_ray_pickable
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_is_ray_pickable" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_is_ray_pickable #-}

instance Method "body_is_ray_pickable" GodotPhysicsServer
           (GodotRid -> IO Bool)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_is_ray_pickable
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_body_get_direct_state
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "body_get_direct_state" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_body_get_direct_state #-}

instance Method "body_get_direct_state" GodotPhysicsServer
           (GodotRid -> IO GodotPhysicsDirectBodyState)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_body_get_direct_state
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_create_pin
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_create_pin" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_create_pin #-}

instance Method "joint_create_pin" GodotPhysicsServer
           (GodotRid ->
              GodotVector3 -> GodotRid -> GodotVector3 -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_create_pin
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_set_param #-}

instance Method "pin_joint_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_get_param #-}

instance Method "pin_joint_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_set_local_a
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_set_local_a" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_set_local_a #-}

instance Method "pin_joint_set_local_a" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_set_local_a
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_get_local_a
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_get_local_a" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_get_local_a #-}

instance Method "pin_joint_get_local_a" GodotPhysicsServer
           (GodotRid -> IO GodotVector3)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_get_local_a
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_set_local_b
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_set_local_b" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_set_local_b #-}

instance Method "pin_joint_set_local_b" GodotPhysicsServer
           (GodotRid -> GodotVector3 -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_set_local_b
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_pin_joint_get_local_b
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "pin_joint_get_local_b" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_pin_joint_get_local_b #-}

instance Method "pin_joint_get_local_b" GodotPhysicsServer
           (GodotRid -> IO GodotVector3)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_pin_joint_get_local_b
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_create_hinge
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_create_hinge" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_create_hinge #-}

instance Method "joint_create_hinge" GodotPhysicsServer
           (GodotRid ->
              GodotTransform -> GodotRid -> GodotTransform -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_create_hinge
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_hinge_joint_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "hinge_joint_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_hinge_joint_set_param #-}

instance Method "hinge_joint_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_hinge_joint_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_hinge_joint_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "hinge_joint_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_hinge_joint_get_param #-}

instance Method "hinge_joint_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_hinge_joint_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_hinge_joint_set_flag
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "hinge_joint_set_flag" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_hinge_joint_set_flag #-}

instance Method "hinge_joint_set_flag" GodotPhysicsServer
           (GodotRid -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_hinge_joint_set_flag
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_hinge_joint_get_flag
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "hinge_joint_get_flag" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_hinge_joint_get_flag #-}

instance Method "hinge_joint_get_flag" GodotPhysicsServer
           (GodotRid -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_hinge_joint_get_flag
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_create_slider
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_create_slider" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_create_slider #-}

instance Method "joint_create_slider" GodotPhysicsServer
           (GodotRid ->
              GodotTransform -> GodotRid -> GodotTransform -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_create_slider
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_slider_joint_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "slider_joint_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_slider_joint_set_param #-}

instance Method "slider_joint_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_slider_joint_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_slider_joint_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "slider_joint_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_slider_joint_get_param #-}

instance Method "slider_joint_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_slider_joint_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_create_cone_twist
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_create_cone_twist" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_create_cone_twist #-}

instance Method "joint_create_cone_twist" GodotPhysicsServer
           (GodotRid ->
              GodotTransform -> GodotRid -> GodotTransform -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_create_cone_twist
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_cone_twist_joint_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "cone_twist_joint_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_cone_twist_joint_set_param #-}

instance Method "cone_twist_joint_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_cone_twist_joint_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_cone_twist_joint_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "cone_twist_joint_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_cone_twist_joint_get_param #-}

instance Method "cone_twist_joint_get_param" GodotPhysicsServer
           (GodotRid -> Int -> IO Float)
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_cone_twist_joint_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_get_type
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_get_type" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_get_type #-}

instance Method "joint_get_type" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_get_type
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_set_solver_priority
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_set_solver_priority" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_set_solver_priority #-}

instance Method "joint_set_solver_priority" GodotPhysicsServer
           (GodotRid -> Int -> IO ())
         where
        runMethod cls arg1 arg2
          = withVariantArray [toVariant arg1, toVariant arg2]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_set_solver_priority
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_get_solver_priority
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_get_solver_priority" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_get_solver_priority #-}

instance Method "joint_get_solver_priority" GodotPhysicsServer
           (GodotRid -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_get_solver_priority
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_joint_create_generic_6dof
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "joint_create_generic_6dof" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_joint_create_generic_6dof #-}

instance Method "joint_create_generic_6dof" GodotPhysicsServer
           (GodotRid ->
              GodotTransform -> GodotRid -> GodotTransform -> IO GodotRid)
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_joint_create_generic_6dof
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_generic_6dof_joint_set_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "generic_6dof_joint_set_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_generic_6dof_joint_set_param #-}

instance Method "generic_6dof_joint_set_param" GodotPhysicsServer
           (GodotRid -> Int -> Int -> Float -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_generic_6dof_joint_set_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_generic_6dof_joint_get_param
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "generic_6dof_joint_get_param" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_generic_6dof_joint_get_param #-}

instance Method "generic_6dof_joint_get_param" GodotPhysicsServer
           (GodotRid -> Int -> Int -> IO Float)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_generic_6dof_joint_get_param
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_generic_6dof_joint_set_flag
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "generic_6dof_joint_set_flag" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_generic_6dof_joint_set_flag #-}

instance Method "generic_6dof_joint_set_flag" GodotPhysicsServer
           (GodotRid -> Int -> Int -> Bool -> IO ())
         where
        runMethod cls arg1 arg2 arg3 arg4
          = withVariantArray
              [toVariant arg1, toVariant arg2, toVariant arg3, toVariant arg4]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_generic_6dof_joint_set_flag
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_generic_6dof_joint_get_flag
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "generic_6dof_joint_get_flag" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_generic_6dof_joint_get_flag #-}

instance Method "generic_6dof_joint_get_flag" GodotPhysicsServer
           (GodotRid -> Int -> Int -> IO Bool)
         where
        runMethod cls arg1 arg2 arg3
          = withVariantArray [toVariant arg1, toVariant arg2, toVariant arg3]
              (\ (arrPtr, len) ->
                 godot_method_bind_call
                   bindPhysicsServer_generic_6dof_joint_get_flag
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_free_rid
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "free_rid" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_free_rid #-}

instance Method "free_rid" GodotPhysicsServer (GodotRid -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_free_rid (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_set_active
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "set_active" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_set_active #-}

instance Method "set_active" GodotPhysicsServer (Bool -> IO ())
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_set_active (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysicsServer_get_process_info
  = unsafePerformIO $
      withCString "PhysicsServer" $
        \ clsNamePtr ->
          withCString "get_process_info" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysicsServer_get_process_info #-}

instance Method "get_process_info" GodotPhysicsServer
           (Int -> IO Int)
         where
        runMethod cls arg1
          = withVariantArray [toVariant arg1]
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysicsServer_get_process_info
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)

newtype GodotPhysics2DServer = GodotPhysics2DServer GodotObject
                                 deriving newtype AsVariant

instance HasBaseClass GodotPhysics2DServer where
        type BaseClass GodotPhysics2DServer = GodotObject
        super = coerce
bindPhysics2DServer_line_shape_create
  = unsafePerformIO $
      withCString "Physics2DServer" $
        \ clsNamePtr ->
          withCString "line_shape_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysics2DServer_line_shape_create #-}

instance Method "line_shape_create" GodotPhysics2DServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysics2DServer_line_shape_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysics2DServer_ray_shape_create
  = unsafePerformIO $
      withCString "Physics2DServer" $
        \ clsNamePtr ->
          withCString "ray_shape_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysics2DServer_ray_shape_create #-}

instance Method "ray_shape_create" GodotPhysics2DServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysics2DServer_ray_shape_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysics2DServer_segment_shape_create
  = unsafePerformIO $
      withCString "Physics2DServer" $
        \ clsNamePtr ->
          withCString "segment_shape_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysics2DServer_segment_shape_create #-}

instance Method "segment_shape_create" GodotPhysics2DServer
           (IO GodotRid)
         where
        runMethod cls
          = withVariantArray []
              (\ (arrPtr, len) ->
                 godot_method_bind_call bindPhysics2DServer_segment_shape_create
                   (coerce cls)
                   arrPtr
                   len
                   >>= \ (err, res) -> throwIfErr err >> fromGodotVariant res)
bindPhysics2DServer_circle_shape_create
  = unsafePerformIO $
      withCString "Physics2DServer" $
        \ clsNamePtr ->
          withCString "circle_shape_create" $
            \ methodNamePtr ->
              godot_method_bind_get_method clsNamePtr methodNamePtr

{-# NOINLINE bindPhysics2DServer_circle_shape_create #-}

instance Method "circle_shap