module Godot.Methods where
import Godot.Internal.Dispatch
import Godot.Api.Auto

_action_pressed :: Method "_action_pressed" cls sig => cls -> sig
_action_pressed = runMethod @"_action_pressed"

_add_blend_point :: Method "_add_blend_point" cls sig => cls -> sig
_add_blend_point = runMethod @"_add_blend_point"

_add_callback :: Method "_add_callback" cls sig => cls -> sig
_add_callback = runMethod @"_add_callback"

_add_peer :: Method "_add_peer" cls sig => cls -> sig
_add_peer = runMethod @"_add_peer"

_add_preset_pressed ::
                      Method "_add_preset_pressed" cls sig => cls -> sig
_add_preset_pressed = runMethod @"_add_preset_pressed"

_animation_changed ::
                     Method "_animation_changed" cls sig => cls -> sig
_animation_changed = runMethod @"_animation_changed"

_area_enter_tree :: Method "_area_enter_tree" cls sig => cls -> sig
_area_enter_tree = runMethod @"_area_enter_tree"

_area_exit_tree :: Method "_area_exit_tree" cls sig => cls -> sig
_area_exit_tree = runMethod @"_area_exit_tree"

_area_inout :: Method "_area_inout" cls sig => cls -> sig
_area_inout = runMethod @"_area_inout"

_autosave_scripts ::
                    Method "_autosave_scripts" cls sig => cls -> sig
_autosave_scripts = runMethod @"_autosave_scripts"

_body_enter_tree :: Method "_body_enter_tree" cls sig => cls -> sig
_body_enter_tree = runMethod @"_body_enter_tree"

_body_exit_tree :: Method "_body_exit_tree" cls sig => cls -> sig
_body_exit_tree = runMethod @"_body_exit_tree"

_body_inout :: Method "_body_inout" cls sig => cls -> sig
_body_inout = runMethod @"_body_inout"

_breaked :: Method "_breaked" cls sig => cls -> sig
_breaked = runMethod @"_breaked"

_browse_path :: Method "_browse_path" cls sig => cls -> sig
_browse_path = runMethod @"_browse_path"

_built_in_pressed ::
                    Method "_built_in_pressed" cls sig => cls -> sig
_built_in_pressed = runMethod @"_built_in_pressed"

_builtin_text_entered ::
                        Method "_builtin_text_entered" cls sig => cls -> sig
_builtin_text_entered = runMethod @"_builtin_text_entered"

_bus_layout_changed ::
                      Method "_bus_layout_changed" cls sig => cls -> sig
_bus_layout_changed = runMethod @"_bus_layout_changed"

_camera_moved :: Method "_camera_moved" cls sig => cls -> sig
_camera_moved = runMethod @"_camera_moved"

_cancel_pressed :: Method "_cancel_pressed" cls sig => cls -> sig
_cancel_pressed = runMethod @"_cancel_pressed"

_change_scene :: Method "_change_scene" cls sig => cls -> sig
_change_scene = runMethod @"_change_scene"

_child_minsize_changed ::
                         Method "_child_minsize_changed" cls sig => cls -> sig
_child_minsize_changed = runMethod @"_child_minsize_changed"

_child_renamed_callback ::
                          Method "_child_renamed_callback" cls sig => cls -> sig
_child_renamed_callback = runMethod @"_child_renamed_callback"

_class_name_changed ::
                      Method "_class_name_changed" cls sig => cls -> sig
_class_name_changed = runMethod @"_class_name_changed"

_clear_caches :: Method "_clear_caches" cls sig => cls -> sig
_clear_caches = runMethod @"_clear_caches"

_clear_quadrants :: Method "_clear_quadrants" cls sig => cls -> sig
_clear_quadrants = runMethod @"_clear_quadrants"

_click_selection_held ::
                        Method "_click_selection_held" cls sig => cls -> sig
_click_selection_held = runMethod @"_click_selection_held"

_clips_input :: Method "_clips_input" cls sig => cls -> sig
_clips_input = runMethod @"_clips_input"

_close_all_tabs :: Method "_close_all_tabs" cls sig => cls -> sig
_close_all_tabs = runMethod @"_close_all_tabs"

_close_current_tab ::
                     Method "_close_current_tab" cls sig => cls -> sig
_close_current_tab = runMethod @"_close_current_tab"

_close_discard_current_tab ::
                             Method "_close_discard_current_tab" cls sig => cls -> sig
_close_discard_current_tab
  = runMethod @"_close_discard_current_tab"

_close_docs_tab :: Method "_close_docs_tab" cls sig => cls -> sig
_close_docs_tab = runMethod @"_close_docs_tab"

_close_other_tabs ::
                    Method "_close_other_tabs" cls sig => cls -> sig
_close_other_tabs = runMethod @"_close_other_tabs"

_closed :: Method "_closed" cls sig => cls -> sig
_closed = runMethod @"_closed"

_color_changed :: Method "_color_changed" cls sig => cls -> sig
_color_changed = runMethod @"_color_changed"

_compute_cost :: Method "_compute_cost" cls sig => cls -> sig
_compute_cost = runMethod @"_compute_cost"

_connected_to_server ::
                       Method "_connected_to_server" cls sig => cls -> sig
_connected_to_server = runMethod @"_connected_to_server"

_connection_failed ::
                     Method "_connection_failed" cls sig => cls -> sig
_connection_failed = runMethod @"_connection_failed"

_connections_layer_draw ::
                          Method "_connections_layer_draw" cls sig => cls -> sig
_connections_layer_draw = runMethod @"_connections_layer_draw"

_convert :: Method "_convert" cls sig => cls -> sig
_convert = runMethod @"_convert"

_converts_to :: Method "_converts_to" cls sig => cls -> sig
_converts_to = runMethod @"_converts_to"

_copy_script_path ::
                    Method "_copy_script_path" cls sig => cls -> sig
_copy_script_path = runMethod @"_copy_script_path"

_cursor_changed_emit ::
                       Method "_cursor_changed_emit" cls sig => cls -> sig
_cursor_changed_emit = runMethod @"_cursor_changed_emit"

_curve_changed :: Method "_curve_changed" cls sig => cls -> sig
_curve_changed = runMethod @"_curve_changed"

_custom_action :: Method "_custom_action" cls sig => cls -> sig
_custom_action = runMethod @"_custom_action"

_del_peer :: Method "_del_peer" cls sig => cls -> sig
_del_peer = runMethod @"_del_peer"

_dir_entered :: Method "_dir_entered" cls sig => cls -> sig
_dir_entered = runMethod @"_dir_entered"

_direct_state_changed ::
                        Method "_direct_state_changed" cls sig => cls -> sig
_direct_state_changed = runMethod @"_direct_state_changed"

_drag_node_exit :: Method "_drag_node_exit" cls sig => cls -> sig
_drag_node_exit = runMethod @"_drag_node_exit"

_drag_node_input :: Method "_drag_node_input" cls sig => cls -> sig
_drag_node_input = runMethod @"_drag_node_input"

_draw :: Method "_draw" cls sig => cls -> sig
_draw = runMethod @"_draw"

_draw_soft_mesh :: Method "_draw_soft_mesh" cls sig => cls -> sig
_draw_soft_mesh = runMethod @"_draw_soft_mesh"

_drop_files :: Method "_drop_files" cls sig => cls -> sig
_drop_files = runMethod @"_drop_files"

_edit_get_pivot :: Method "_edit_get_pivot" cls sig => cls -> sig
_edit_get_pivot = runMethod @"_edit_get_pivot"

_edit_get_position ::
                     Method "_edit_get_position" cls sig => cls -> sig
_edit_get_position = runMethod @"_edit_get_position"

_edit_get_rect :: Method "_edit_get_rect" cls sig => cls -> sig
_edit_get_rect = runMethod @"_edit_get_rect"

_edit_get_rotation ::
                     Method "_edit_get_rotation" cls sig => cls -> sig
_edit_get_rotation = runMethod @"_edit_get_rotation"

_edit_get_scale :: Method "_edit_get_scale" cls sig => cls -> sig
_edit_get_scale = runMethod @"_edit_get_scale"

_edit_get_state :: Method "_edit_get_state" cls sig => cls -> sig
_edit_get_state = runMethod @"_edit_get_state"

_edit_request_change ::
                       Method "_edit_request_change" cls sig => cls -> sig
_edit_request_change = runMethod @"_edit_request_change"

_edit_set_pivot :: Method "_edit_set_pivot" cls sig => cls -> sig
_edit_set_pivot = runMethod @"_edit_set_pivot"

_edit_set_position ::
                     Method "_edit_set_position" cls sig => cls -> sig
_edit_set_position = runMethod @"_edit_set_position"

_edit_set_rect :: Method "_edit_set_rect" cls sig => cls -> sig
_edit_set_rect = runMethod @"_edit_set_rect"

_edit_set_rotation ::
                     Method "_edit_set_rotation" cls sig => cls -> sig
_edit_set_rotation = runMethod @"_edit_set_rotation"

_edit_set_scale :: Method "_edit_set_scale" cls sig => cls -> sig
_edit_set_scale = runMethod @"_edit_set_scale"

_edit_set_state :: Method "_edit_set_state" cls sig => cls -> sig
_edit_set_state = runMethod @"_edit_set_state"

_edit_use_pivot :: Method "_edit_use_pivot" cls sig => cls -> sig
_edit_use_pivot = runMethod @"_edit_use_pivot"

_edit_use_rect :: Method "_edit_use_rect" cls sig => cls -> sig
_edit_use_rect = runMethod @"_edit_use_rect"

_edit_use_rotation ::
                     Method "_edit_use_rotation" cls sig => cls -> sig
_edit_use_rotation = runMethod @"_edit_use_rotation"

_editor_pause :: Method "_editor_pause" cls sig => cls -> sig
_editor_pause = runMethod @"_editor_pause"

_editor_play :: Method "_editor_play" cls sig => cls -> sig
_editor_play = runMethod @"_editor_play"

_editor_settings_changed ::
                           Method "_editor_settings_changed" cls sig => cls -> sig
_editor_settings_changed = runMethod @"_editor_settings_changed"

_editor_stop :: Method "_editor_stop" cls sig => cls -> sig
_editor_stop = runMethod @"_editor_stop"

_emit_change :: Method "_emit_change" cls sig => cls -> sig
_emit_change = runMethod @"_emit_change"

_emit_theme_changed ::
                      Method "_emit_theme_changed" cls sig => cls -> sig
_emit_theme_changed = runMethod @"_emit_theme_changed"

_enter_tree :: Method "_enter_tree" cls sig => cls -> sig
_enter_tree = runMethod @"_enter_tree"

_estimate_cost :: Method "_estimate_cost" cls sig => cls -> sig
_estimate_cost = runMethod @"_estimate_cost"

_exit_tree :: Method "_exit_tree" cls sig => cls -> sig
_exit_tree = runMethod @"_exit_tree"

_export_begin :: Method "_export_begin" cls sig => cls -> sig
_export_begin = runMethod @"_export_begin"

_export_file :: Method "_export_file" cls sig => cls -> sig
_export_file = runMethod @"_export_file"

_favorite_move_down ::
                      Method "_favorite_move_down" cls sig => cls -> sig
_favorite_move_down = runMethod @"_favorite_move_down"

_favorite_move_up ::
                    Method "_favorite_move_up" cls sig => cls -> sig
_favorite_move_up = runMethod @"_favorite_move_up"

_favorite_selected ::
                     Method "_favorite_selected" cls sig => cls -> sig
_favorite_selected = runMethod @"_favorite_selected"

_favorite_toggled ::
                    Method "_favorite_toggled" cls sig => cls -> sig
_favorite_toggled = runMethod @"_favorite_toggled"

_file_dialog_action ::
                      Method "_file_dialog_action" cls sig => cls -> sig
_file_dialog_action = runMethod @"_file_dialog_action"

_file_entered :: Method "_file_entered" cls sig => cls -> sig
_file_entered = runMethod @"_file_entered"

_file_selected :: Method "_file_selected" cls sig => cls -> sig
_file_selected = runMethod @"_file_selected"

_filter_changed :: Method "_filter_changed" cls sig => cls -> sig
_filter_changed = runMethod @"_filter_changed"

_filter_selected :: Method "_filter_selected" cls sig => cls -> sig
_filter_selected = runMethod @"_filter_selected"

_finalize :: Method "_finalize" cls sig => cls -> sig
_finalize = runMethod @"_finalize"

_focus_enter :: Method "_focus_enter" cls sig => cls -> sig
_focus_enter = runMethod @"_focus_enter"

_focus_exit :: Method "_focus_exit" cls sig => cls -> sig
_focus_exit = runMethod @"_focus_exit"

_focusable_focused ::
                     Method "_focusable_focused" cls sig => cls -> sig
_focusable_focused = runMethod @"_focusable_focused"

_focused :: Method "_focused" cls sig => cls -> sig
_focused = runMethod @"_focused"

_font_changed :: Method "_font_changed" cls sig => cls -> sig
_font_changed = runMethod @"_font_changed"

_forward_subtile_selection ::
                             Method "_forward_subtile_selection" cls sig => cls -> sig
_forward_subtile_selection
  = runMethod @"_forward_subtile_selection"

_generate_texture ::
                    Method "_generate_texture" cls sig => cls -> sig
_generate_texture = runMethod @"_generate_texture"

_get :: Method "_get" cls sig => cls -> sig
_get = runMethod @"_get"

_get_angular_hi_limit_x ::
                          Method "_get_angular_hi_limit_x" cls sig => cls -> sig
_get_angular_hi_limit_x = runMethod @"_get_angular_hi_limit_x"

_get_angular_hi_limit_y ::
                          Method "_get_angular_hi_limit_y" cls sig => cls -> sig
_get_angular_hi_limit_y = runMethod @"_get_angular_hi_limit_y"

_get_angular_hi_limit_z ::
                          Method "_get_angular_hi_limit_z" cls sig => cls -> sig
_get_angular_hi_limit_z = runMethod @"_get_angular_hi_limit_z"

_get_angular_lo_limit_x ::
                          Method "_get_angular_lo_limit_x" cls sig => cls -> sig
_get_angular_lo_limit_x = runMethod @"_get_angular_lo_limit_x"

_get_angular_lo_limit_y ::
                          Method "_get_angular_lo_limit_y" cls sig => cls -> sig
_get_angular_lo_limit_y = runMethod @"_get_angular_lo_limit_y"

_get_angular_lo_limit_z ::
                          Method "_get_angular_lo_limit_z" cls sig => cls -> sig
_get_angular_lo_limit_z = runMethod @"_get_angular_lo_limit_z"

_get_animations :: Method "_get_animations" cls sig => cls -> sig
_get_animations = runMethod @"_get_animations"

_get_argument_cache ::
                      Method "_get_argument_cache" cls sig => cls -> sig
_get_argument_cache = runMethod @"_get_argument_cache"

_get_bones :: Method "_get_bones" cls sig => cls -> sig
_get_bones = runMethod @"_get_bones"

_get_bundled_scene ::
                     Method "_get_bundled_scene" cls sig => cls -> sig
_get_bundled_scene = runMethod @"_get_bundled_scene"

_get_caption :: Method "_get_caption" cls sig => cls -> sig
_get_caption = runMethod @"_get_caption"

_get_category :: Method "_get_category" cls sig => cls -> sig
_get_category = runMethod @"_get_category"

_get_chars :: Method "_get_chars" cls sig => cls -> sig
_get_chars = runMethod @"_get_chars"

_get_color_array :: Method "_get_color_array" cls sig => cls -> sig
_get_color_array = runMethod @"_get_color_array"

_get_configuration_warning ::
                             Method "_get_configuration_warning" cls sig => cls -> sig
_get_configuration_warning
  = runMethod @"_get_configuration_warning"

_get_custom_data_array ::
                         Method "_get_custom_data_array" cls sig => cls -> sig
_get_custom_data_array = runMethod @"_get_custom_data_array"

_get_data :: Method "_get_data" cls sig => cls -> sig
_get_data = runMethod @"_get_data"

_get_debug_tooltip ::
                     Method "_get_debug_tooltip" cls sig => cls -> sig
_get_debug_tooltip = runMethod @"_get_debug_tooltip"

_get_default_input_values ::
                            Method "_get_default_input_values" cls sig => cls -> sig
_get_default_input_values = runMethod @"_get_default_input_values"

_get_elem_cache :: Method "_get_elem_cache" cls sig => cls -> sig
_get_elem_cache = runMethod @"_get_elem_cache"

_get_extensions :: Method "_get_extensions" cls sig => cls -> sig
_get_extensions = runMethod @"_get_extensions"

_get_filters :: Method "_get_filters" cls sig => cls -> sig
_get_filters = runMethod @"_get_filters"

_get_frames :: Method "_get_frames" cls sig => cls -> sig
_get_frames = runMethod @"_get_frames"

_get_import_flags ::
                    Method "_get_import_flags" cls sig => cls -> sig
_get_import_flags = runMethod @"_get_import_flags"

_get_import_path :: Method "_get_import_path" cls sig => cls -> sig
_get_import_path = runMethod @"_get_import_path"

_get_input_value_port_count ::
                              Method "_get_input_value_port_count" cls sig => cls -> sig
_get_input_value_port_count
  = runMethod @"_get_input_value_port_count"

_get_input_value_port_name ::
                             Method "_get_input_value_port_name" cls sig => cls -> sig
_get_input_value_port_name
  = runMethod @"_get_input_value_port_name"

_get_input_value_port_type ::
                             Method "_get_input_value_port_type" cls sig => cls -> sig
_get_input_value_port_type
  = runMethod @"_get_input_value_port_type"

_get_items :: Method "_get_items" cls sig => cls -> sig
_get_items = runMethod @"_get_items"

_get_kernings :: Method "_get_kernings" cls sig => cls -> sig
_get_kernings = runMethod @"_get_kernings"

_get_layers :: Method "_get_layers" cls sig => cls -> sig
_get_layers = runMethod @"_get_layers"

_get_lower_limit :: Method "_get_lower_limit" cls sig => cls -> sig
_get_lower_limit = runMethod @"_get_lower_limit"

_get_lower_limit_angular ::
                           Method "_get_lower_limit_angular" cls sig => cls -> sig
_get_lower_limit_angular = runMethod @"_get_lower_limit_angular"

_get_messages :: Method "_get_messages" cls sig => cls -> sig
_get_messages = runMethod @"_get_messages"

_get_minimum_size ::
                    Method "_get_minimum_size" cls sig => cls -> sig
_get_minimum_size = runMethod @"_get_minimum_size"

_get_old_cell_size ::
                     Method "_get_old_cell_size" cls sig => cls -> sig
_get_old_cell_size = runMethod @"_get_old_cell_size"

_get_outlines :: Method "_get_outlines" cls sig => cls -> sig
_get_outlines = runMethod @"_get_outlines"

_get_output_sequence_port_count ::
                                  Method "_get_output_sequence_port_count" cls sig => cls -> sig
_get_output_sequence_port_count
  = runMethod @"_get_output_sequence_port_count"

_get_output_sequence_port_text ::
                                 Method "_get_output_sequence_port_text" cls sig => cls -> sig
_get_output_sequence_port_text
  = runMethod @"_get_output_sequence_port_text"

_get_output_value_port_count ::
                               Method "_get_output_value_port_count" cls sig => cls -> sig
_get_output_value_port_count
  = runMethod @"_get_output_value_port_count"

_get_output_value_port_name ::
                              Method "_get_output_value_port_name" cls sig => cls -> sig
_get_output_value_port_name
  = runMethod @"_get_output_value_port_name"

_get_output_value_port_type ::
                              Method "_get_output_value_port_type" cls sig => cls -> sig
_get_output_value_port_type
  = runMethod @"_get_output_value_port_type"

_get_polygons :: Method "_get_polygons" cls sig => cls -> sig
_get_polygons = runMethod @"_get_polygons"

_get_property_list ::
                     Method "_get_property_list" cls sig => cls -> sig
_get_property_list = runMethod @"_get_property_list"

_get_resources :: Method "_get_resources" cls sig => cls -> sig
_get_resources = runMethod @"_get_resources"

_get_swing_span :: Method "_get_swing_span" cls sig => cls -> sig
_get_swing_span = runMethod @"_get_swing_span"

_get_text :: Method "_get_text" cls sig => cls -> sig
_get_text = runMethod @"_get_text"

_get_textures :: Method "_get_textures" cls sig => cls -> sig
_get_textures = runMethod @"_get_textures"

_get_tile_data :: Method "_get_tile_data" cls sig => cls -> sig
_get_tile_data = runMethod @"_get_tile_data"

_get_tooltip :: Method "_get_tooltip" cls sig => cls -> sig
_get_tooltip = runMethod @"_get_tooltip"

_get_transform_array ::
                       Method "_get_transform_array" cls sig => cls -> sig
_get_transform_array = runMethod @"_get_transform_array"

_get_triangles :: Method "_get_triangles" cls sig => cls -> sig
_get_triangles = runMethod @"_get_triangles"

_get_twist_span :: Method "_get_twist_span" cls sig => cls -> sig
_get_twist_span = runMethod @"_get_twist_span"

_get_type_cache :: Method "_get_type_cache" cls sig => cls -> sig
_get_type_cache = runMethod @"_get_type_cache"

_get_upper_limit :: Method "_get_upper_limit" cls sig => cls -> sig
_get_upper_limit = runMethod @"_get_upper_limit"

_get_upper_limit_angular ::
                           Method "_get_upper_limit_angular" cls sig => cls -> sig
_get_upper_limit_angular = runMethod @"_get_upper_limit_angular"

_get_user_data :: Method "_get_user_data" cls sig => cls -> sig
_get_user_data = runMethod @"_get_user_data"

_get_visual_instance_rid ::
                           Method "_get_visual_instance_rid" cls sig => cls -> sig
_get_visual_instance_rid = runMethod @"_get_visual_instance_rid"

_get_working_memory_size ::
                           Method "_get_working_memory_size" cls sig => cls -> sig
_get_working_memory_size = runMethod @"_get_working_memory_size"

_go_back :: Method "_go_back" cls sig => cls -> sig
_go_back = runMethod @"_go_back"

_go_forward :: Method "_go_forward" cls sig => cls -> sig
_go_forward = runMethod @"_go_forward"

_go_up :: Method "_go_up" cls sig => cls -> sig
_go_up = runMethod @"_go_up"

_goto_script_line ::
                    Method "_goto_script_line" cls sig => cls -> sig
_goto_script_line = runMethod @"_goto_script_line"

_goto_script_line2 ::
                     Method "_goto_script_line2" cls sig => cls -> sig
_goto_script_line2 = runMethod @"_goto_script_line2"

_gradient_changed ::
                    Method "_gradient_changed" cls sig => cls -> sig
_gradient_changed = runMethod @"_gradient_changed"

_graph_node_moved ::
                    Method "_graph_node_moved" cls sig => cls -> sig
_graph_node_moved = runMethod @"_graph_node_moved"

_graph_node_raised ::
                     Method "_graph_node_raised" cls sig => cls -> sig
_graph_node_raised = runMethod @"_graph_node_raised"

_gui_input :: Method "_gui_input" cls sig => cls -> sig
_gui_input = runMethod @"_gui_input"

_gui_remove_focus ::
                    Method "_gui_remove_focus" cls sig => cls -> sig
_gui_remove_focus = runMethod @"_gui_remove_focus"

_gui_show_tooltip ::
                    Method "_gui_show_tooltip" cls sig => cls -> sig
_gui_show_tooltip = runMethod @"_gui_show_tooltip"

_has_editable_3d_polygon_no_depth ::
                                    Method "_has_editable_3d_polygon_no_depth" cls sig => cls -> sig
_has_editable_3d_polygon_no_depth
  = runMethod @"_has_editable_3d_polygon_no_depth"

_has_input_sequence_port ::
                           Method "_has_input_sequence_port" cls sig => cls -> sig
_has_input_sequence_port = runMethod @"_has_input_sequence_port"

_help_class_goto :: Method "_help_class_goto" cls sig => cls -> sig
_help_class_goto = runMethod @"_help_class_goto"

_help_class_open :: Method "_help_class_open" cls sig => cls -> sig
_help_class_open = runMethod @"_help_class_open"

_help_index :: Method "_help_index" cls sig => cls -> sig
_help_index = runMethod @"_help_index"

_help_overview_selected ::
                          Method "_help_overview_selected" cls sig => cls -> sig
_help_overview_selected = runMethod @"_help_overview_selected"

_help_search :: Method "_help_search" cls sig => cls -> sig
_help_search = runMethod @"_help_search"

_history_back :: Method "_history_back" cls sig => cls -> sig
_history_back = runMethod @"_history_back"

_history_forward :: Method "_history_forward" cls sig => cls -> sig
_history_forward = runMethod @"_history_forward"

_hsv_draw :: Method "_hsv_draw" cls sig => cls -> sig
_hsv_draw = runMethod @"_hsv_draw"

_html_entered :: Method "_html_entered" cls sig => cls -> sig
_html_entered = runMethod @"_html_entered"

_html_focus_exit :: Method "_html_focus_exit" cls sig => cls -> sig
_html_focus_exit = runMethod @"_html_focus_exit"

_idle :: Method "_idle" cls sig => cls -> sig
_idle = runMethod @"_idle"

_im_update :: Method "_im_update" cls sig => cls -> sig
_im_update = runMethod @"_im_update"

_import_animation ::
                    Method "_import_animation" cls sig => cls -> sig
_import_animation = runMethod @"_import_animation"

_import_scene :: Method "_import_scene" cls sig => cls -> sig
_import_scene = runMethod @"_import_scene"

_init :: Method "_init" cls sig => cls -> sig
_init = runMethod @"_init"

_initialize :: Method "_initialize" cls sig => cls -> sig
_initialize = runMethod @"_initialize"

_input :: Method "_input" cls sig => cls -> sig
_input = runMethod @"_input"

_input_event :: Method "_input_event" cls sig => cls -> sig
_input_event = runMethod @"_input_event"

_input_text :: Method "_input_text" cls sig => cls -> sig
_input_text = runMethod @"_input_text"

_input_type_changed ::
                      Method "_input_type_changed" cls sig => cls -> sig
_input_type_changed = runMethod @"_input_type_changed"

_integrate_forces ::
                    Method "_integrate_forces" cls sig => cls -> sig
_integrate_forces = runMethod @"_integrate_forces"

_is_active :: Method "_is_active" cls sig => cls -> sig
_is_active = runMethod @"_is_active"

_is_dictionary :: Method "_is_dictionary" cls sig => cls -> sig
_is_dictionary = runMethod @"_is_dictionary"

_is_editable_3d_polygon ::
                          Method "_is_editable_3d_polygon" cls sig => cls -> sig
_is_editable_3d_polygon = runMethod @"_is_editable_3d_polygon"

_is_on_top :: Method "_is_on_top" cls sig => cls -> sig
_is_on_top = runMethod @"_is_on_top"

_is_playing :: Method "_is_playing" cls sig => cls -> sig
_is_playing = runMethod @"_is_playing"

_is_tile_bound :: Method "_is_tile_bound" cls sig => cls -> sig
_is_tile_bound = runMethod @"_is_tile_bound"

_item_db_selected ::
                    Method "_item_db_selected" cls sig => cls -> sig
_item_db_selected = runMethod @"_item_db_selected"

_item_list_item_rmb_selected ::
                               Method "_item_list_item_rmb_selected" cls sig => cls -> sig
_item_list_item_rmb_selected
  = runMethod @"_item_list_item_rmb_selected"

_item_list_rmb_clicked ::
                         Method "_item_list_rmb_clicked" cls sig => cls -> sig
_item_list_rmb_clicked = runMethod @"_item_list_rmb_clicked"

_item_menu_id_pressed ::
                        Method "_item_menu_id_pressed" cls sig => cls -> sig
_item_menu_id_pressed = runMethod @"_item_menu_id_pressed"

_item_selected :: Method "_item_selected" cls sig => cls -> sig
_item_selected = runMethod @"_item_selected"

_items_clear_selection ::
                         Method "_items_clear_selection" cls sig => cls -> sig
_items_clear_selection = runMethod @"_items_clear_selection"

_iter_get :: Method "_iter_get" cls sig => cls -> sig
_iter_get = runMethod @"_iter_get"

_iter_init :: Method "_iter_init" cls sig => cls -> sig
_iter_init = runMethod @"_iter_init"

_iter_next :: Method "_iter_next" cls sig => cls -> sig
_iter_next = runMethod @"_iter_next"

_iteration :: Method "_iteration" cls sig => cls -> sig
_iteration = runMethod @"_iteration"

_lang_changed :: Method "_lang_changed" cls sig => cls -> sig
_lang_changed = runMethod @"_lang_changed"

_line_edit_focus_exit ::
                        Method "_line_edit_focus_exit" cls sig => cls -> sig
_line_edit_focus_exit = runMethod @"_line_edit_focus_exit"

_line_edit_input :: Method "_line_edit_input" cls sig => cls -> sig
_line_edit_input = runMethod @"_line_edit_input"

_live_auto_reload_running_scripts ::
                                    Method "_live_auto_reload_running_scripts" cls sig => cls -> sig
_live_auto_reload_running_scripts
  = runMethod @"_live_auto_reload_running_scripts"

_make_current :: Method "_make_current" cls sig => cls -> sig
_make_current = runMethod @"_make_current"

_make_custom_tooltip ::
                       Method "_make_custom_tooltip" cls sig => cls -> sig
_make_custom_tooltip = runMethod @"_make_custom_tooltip"

_make_dir :: Method "_make_dir" cls sig => cls -> sig
_make_dir = runMethod @"_make_dir"

_make_dir_confirm ::
                    Method "_make_dir_confirm" cls sig => cls -> sig
_make_dir_confirm = runMethod @"_make_dir_confirm"

_members_overview_selected ::
                             Method "_members_overview_selected" cls sig => cls -> sig
_members_overview_selected
  = runMethod @"_members_overview_selected"

_menu_option :: Method "_menu_option" cls sig => cls -> sig
_menu_option = runMethod @"_menu_option"

_mesh_changed :: Method "_mesh_changed" cls sig => cls -> sig
_mesh_changed = runMethod @"_mesh_changed"

_modal_closed :: Method "_modal_closed" cls sig => cls -> sig
_modal_closed = runMethod @"_modal_closed"

_multi_selected :: Method "_multi_selected" cls sig => cls -> sig
_multi_selected = runMethod @"_multi_selected"

_multiple_properties_changed ::
                               Method "_multiple_properties_changed" cls sig => cls -> sig
_multiple_properties_changed
  = runMethod @"_multiple_properties_changed"

_navpoly_changed :: Method "_navpoly_changed" cls sig => cls -> sig
_navpoly_changed = runMethod @"_navpoly_changed"

_network_peer_connected ::
                          Method "_network_peer_connected" cls sig => cls -> sig
_network_peer_connected = runMethod @"_network_peer_connected"

_network_peer_disconnected ::
                             Method "_network_peer_disconnected" cls sig => cls -> sig
_network_peer_disconnected
  = runMethod @"_network_peer_disconnected"

_node_changed :: Method "_node_changed" cls sig => cls -> sig
_node_changed = runMethod @"_node_changed"

_node_ports_changed ::
                      Method "_node_ports_changed" cls sig => cls -> sig
_node_ports_changed = runMethod @"_node_ports_changed"

_node_removed :: Method "_node_removed" cls sig => cls -> sig
_node_removed = runMethod @"_node_removed"

_notification :: Method "_notification" cls sig => cls -> sig
_notification = runMethod @"_notification"

_object_id_selected ::
                      Method "_object_id_selected" cls sig => cls -> sig
_object_id_selected = runMethod @"_object_id_selected"

_ok :: Method "_ok" cls sig => cls -> sig
_ok = runMethod @"_ok"

_on_find_in_files_modified_files ::
                                   Method "_on_find_in_files_modified_files" cls sig => cls -> sig
_on_find_in_files_modified_files
  = runMethod @"_on_find_in_files_modified_files"

_on_find_in_files_requested ::
                              Method "_on_find_in_files_requested" cls sig => cls -> sig
_on_find_in_files_requested
  = runMethod @"_on_find_in_files_requested"

_on_find_in_files_result_selected ::
                                    Method "_on_find_in_files_result_selected" cls sig => cls -> sig
_on_find_in_files_result_selected
  = runMethod @"_on_find_in_files_result_selected"

_on_theme_changed ::
                    Method "_on_theme_changed" cls sig => cls -> sig
_on_theme_changed = runMethod @"_on_theme_changed"

_open_recent_script ::
                      Method "_open_recent_script" cls sig => cls -> sig
_open_recent_script = runMethod @"_open_recent_script"

_parent_name_changed ::
                       Method "_parent_name_changed" cls sig => cls -> sig
_parent_name_changed = runMethod @"_parent_name_changed"

_path_changed :: Method "_path_changed" cls sig => cls -> sig
_path_changed = runMethod @"_path_changed"

_path_entered :: Method "_path_entered" cls sig => cls -> sig
_path_entered = runMethod @"_path_entered"

_path_exited :: Method "_path_exited" cls sig => cls -> sig
_path_exited = runMethod @"_path_exited"

_physics_process :: Method "_physics_process" cls sig => cls -> sig
_physics_process = runMethod @"_physics_process"

_poly_changed :: Method "_poly_changed" cls sig => cls -> sig
_poly_changed = runMethod @"_poly_changed"

_popup_select :: Method "_popup_select" cls sig => cls -> sig
_popup_select = runMethod @"_popup_select"

_post_gui_grab_click_focus ::
                             Method "_post_gui_grab_click_focus" cls sig => cls -> sig
_post_gui_grab_click_focus
  = runMethod @"_post_gui_grab_click_focus"

_preset_input :: Method "_preset_input" cls sig => cls -> sig
_preset_input = runMethod @"_preset_input"

_pressed :: Method "_pressed" cls sig => cls -> sig
_pressed = runMethod @"_pressed"

_preview_ready :: Method "_preview_ready" cls sig => cls -> sig
_preview_ready = runMethod @"_preview_ready"

_process :: Method "_process" cls sig => cls -> sig
_process = runMethod @"_process"

_property_changed ::
                    Method "_property_changed" cls sig => cls -> sig
_property_changed = runMethod @"_property_changed"

_property_changed_update_all ::
                               Method "_property_changed_update_all" cls sig => cls -> sig
_property_changed_update_all
  = runMethod @"_property_changed_update_all"

_property_checked ::
                    Method "_property_checked" cls sig => cls -> sig
_property_checked = runMethod @"_property_checked"

_property_keyed :: Method "_property_keyed" cls sig => cls -> sig
_property_keyed = runMethod @"_property_keyed"

_property_keyed_with_value ::
                             Method "_property_keyed_with_value" cls sig => cls -> sig
_property_keyed_with_value
  = runMethod @"_property_keyed_with_value"

_property_selected ::
                     Method "_property_selected" cls sig => cls -> sig
_property_selected = runMethod @"_property_selected"

_proximity_group_broadcast ::
                             Method "_proximity_group_broadcast" cls sig => cls -> sig
_proximity_group_broadcast
  = runMethod @"_proximity_group_broadcast"

_push_current_op :: Method "_push_current_op" cls sig => cls -> sig
_push_current_op = runMethod @"_push_current_op"

_queue_update :: Method "_queue_update" cls sig => cls -> sig
_queue_update = runMethod @"_queue_update"

_range_click_timeout ::
                       Method "_range_click_timeout" cls sig => cls -> sig
_range_click_timeout = runMethod @"_range_click_timeout"

_ready :: Method "_ready" cls sig => cls -> sig
_ready = runMethod @"_ready"

_recent_selected :: Method "_recent_selected" cls sig => cls -> sig
_recent_selected = runMethod @"_recent_selected"

_recreate_quadrants ::
                      Method "_recreate_quadrants" cls sig => cls -> sig
_recreate_quadrants = runMethod @"_recreate_quadrants"

_redirect_request ::
                    Method "_redirect_request" cls sig => cls -> sig
_redirect_request = runMethod @"_redirect_request"

_reload_hook :: Method "_reload_hook" cls sig => cls -> sig
_reload_hook = runMethod @"_reload_hook"

_reload_physics_characteristics ::
                                  Method "_reload_physics_characteristics" cls sig => cls -> sig
_reload_physics_characteristics
  = runMethod @"_reload_physics_characteristics"

_reload_scripts :: Method "_reload_scripts" cls sig => cls -> sig
_reload_scripts = runMethod @"_reload_scripts"

_remove_by_uid :: Method "_remove_by_uid" cls sig => cls -> sig
_remove_by_uid = runMethod @"_remove_by_uid"

_request_done :: Method "_request_done" cls sig => cls -> sig
_request_done = runMethod @"_request_done"

_request_help :: Method "_request_help" cls sig => cls -> sig
_request_help = runMethod @"_request_help"

_res_changed :: Method "_res_changed" cls sig => cls -> sig
_res_changed = runMethod @"_res_changed"

_res_saved_callback ::
                      Method "_res_saved_callback" cls sig => cls -> sig
_res_saved_callback = runMethod @"_res_saved_callback"

_resave_scripts :: Method "_resave_scripts" cls sig => cls -> sig
_resave_scripts = runMethod @"_resave_scripts"

_resource_selected ::
                     Method "_resource_selected" cls sig => cls -> sig
_resource_selected = runMethod @"_resource_selected"

_run :: Method "_run" cls sig => cls -> sig
_run = runMethod @"_run"

_sample_draw :: Method "_sample_draw" cls sig => cls -> sig
_sample_draw = runMethod @"_sample_draw"

_save_confirm_pressed ::
                        Method "_save_confirm_pressed" cls sig => cls -> sig
_save_confirm_pressed = runMethod @"_save_confirm_pressed"

_save_history :: Method "_save_history" cls sig => cls -> sig
_save_history = runMethod @"_save_history"

_screen_input :: Method "_screen_input" cls sig => cls -> sig
_screen_input = runMethod @"_screen_input"

_screen_pick_pressed ::
                       Method "_screen_pick_pressed" cls sig => cls -> sig
_screen_pick_pressed = runMethod @"_screen_pick_pressed"

_script_changed :: Method "_script_changed" cls sig => cls -> sig
_script_changed = runMethod @"_script_changed"

_script_created :: Method "_script_created" cls sig => cls -> sig
_script_created = runMethod @"_script_created"

_script_list_gui_input ::
                         Method "_script_list_gui_input" cls sig => cls -> sig
_script_list_gui_input = runMethod @"_script_list_gui_input"

_script_selected :: Method "_script_selected" cls sig => cls -> sig
_script_selected = runMethod @"_script_selected"

_script_split_dragged ::
                        Method "_script_split_dragged" cls sig => cls -> sig
_script_split_dragged = runMethod @"_script_split_dragged"

_scroll_changed :: Method "_scroll_changed" cls sig => cls -> sig
_scroll_changed = runMethod @"_scroll_changed"

_scroll_moved :: Method "_scroll_moved" cls sig => cls -> sig
_scroll_moved = runMethod @"_scroll_moved"

_select_drive :: Method "_select_drive" cls sig => cls -> sig
_select_drive = runMethod @"_select_drive"

_select_int :: Method "_select_int" cls sig => cls -> sig
_select_int = runMethod @"_select_int"

_selected :: Method "_selected" cls sig => cls -> sig
_selected = runMethod @"_selected"

_server_disconnected ::
                       Method "_server_disconnected" cls sig => cls -> sig
_server_disconnected = runMethod @"_server_disconnected"

_set :: Method "_set" cls sig => cls -> sig
_set = runMethod @"_set"

_set_anchor :: Method "_set_anchor" cls sig => cls -> sig
_set_anchor = runMethod @"_set_anchor"

_set_angular_hi_limit_x ::
                          Method "_set_angular_hi_limit_x" cls sig => cls -> sig
_set_angular_hi_limit_x = runMethod @"_set_angular_hi_limit_x"

_set_angular_hi_limit_y ::
                          Method "_set_angular_hi_limit_y" cls sig => cls -> sig
_set_angular_hi_limit_y = runMethod @"_set_angular_hi_limit_y"

_set_angular_hi_limit_z ::
                          Method "_set_angular_hi_limit_z" cls sig => cls -> sig
_set_angular_hi_limit_z = runMethod @"_set_angular_hi_limit_z"

_set_angular_lo_limit_x ::
                          Method "_set_angular_lo_limit_x" cls sig => cls -> sig
_set_angular_lo_limit_x = runMethod @"_set_angular_lo_limit_x"

_set_angular_lo_limit_y ::
                          Method "_set_angular_lo_limit_y" cls sig => cls -> sig
_set_angular_lo_limit_y = runMethod @"_set_angular_lo_limit_y"

_set_angular_lo_limit_z ::
                          Method "_set_angular_lo_limit_z" cls sig => cls -> sig
_set_angular_lo_limit_z = runMethod @"_set_angular_lo_limit_z"

_set_animations :: Method "_set_animations" cls sig => cls -> sig
_set_animations = runMethod @"_set_animations"

_set_argument_cache ::
                      Method "_set_argument_cache" cls sig => cls -> sig
_set_argument_cache = runMethod @"_set_argument_cache"

_set_bones :: Method "_set_bones" cls sig => cls -> sig
_set_bones = runMethod @"_set_bones"

_set_bundled_scene ::
                     Method "_set_bundled_scene" cls sig => cls -> sig
_set_bundled_scene = runMethod @"_set_bundled_scene"

_set_celld :: Method "_set_celld" cls sig => cls -> sig
_set_celld = runMethod @"_set_celld"

_set_chars :: Method "_set_chars" cls sig => cls -> sig
_set_chars = runMethod @"_set_chars"

_set_color_array :: Method "_set_color_array" cls sig => cls -> sig
_set_color_array = runMethod @"_set_color_array"

_set_current :: Method "_set_current" cls sig => cls -> sig
_set_current = runMethod @"_set_current"

_set_custom_data_array ::
                         Method "_set_custom_data_array" cls sig => cls -> sig
_set_custom_data_array = runMethod @"_set_custom_data_array"

_set_data :: Method "_set_data" cls sig => cls -> sig
_set_data = runMethod @"_set_data"

_set_default_input_values ::
                            Method "_set_default_input_values" cls sig => cls -> sig
_set_default_input_values = runMethod @"_set_default_input_values"

_set_elem_cache :: Method "_set_elem_cache" cls sig => cls -> sig
_set_elem_cache = runMethod @"_set_elem_cache"

_set_filters :: Method "_set_filters" cls sig => cls -> sig
_set_filters = runMethod @"_set_filters"

_set_frames :: Method "_set_frames" cls sig => cls -> sig
_set_frames = runMethod @"_set_frames"

_set_import_path :: Method "_set_import_path" cls sig => cls -> sig
_set_import_path = runMethod @"_set_import_path"

_set_items :: Method "_set_items" cls sig => cls -> sig
_set_items = runMethod @"_set_items"

_set_joy_id :: Method "_set_joy_id" cls sig => cls -> sig
_set_joy_id = runMethod @"_set_joy_id"

_set_kernings :: Method "_set_kernings" cls sig => cls -> sig
_set_kernings = runMethod @"_set_kernings"

_set_layers :: Method "_set_layers" cls sig => cls -> sig
_set_layers = runMethod @"_set_layers"

_set_lower_limit :: Method "_set_lower_limit" cls sig => cls -> sig
_set_lower_limit = runMethod @"_set_lower_limit"

_set_lower_limit_angular ::
                           Method "_set_lower_limit_angular" cls sig => cls -> sig
_set_lower_limit_angular = runMethod @"_set_lower_limit_angular"

_set_messages :: Method "_set_messages" cls sig => cls -> sig
_set_messages = runMethod @"_set_messages"

_set_name :: Method "_set_name" cls sig => cls -> sig
_set_name = runMethod @"_set_name"

_set_old_cell_size ::
                     Method "_set_old_cell_size" cls sig => cls -> sig
_set_old_cell_size = runMethod @"_set_old_cell_size"

_set_old_smoothing ::
                     Method "_set_old_smoothing" cls sig => cls -> sig
_set_old_smoothing = runMethod @"_set_old_smoothing"

_set_on_top :: Method "_set_on_top" cls sig => cls -> sig
_set_on_top = runMethod @"_set_on_top"

_set_orientation :: Method "_set_orientation" cls sig => cls -> sig
_set_orientation = runMethod @"_set_orientation"

_set_outlines :: Method "_set_outlines" cls sig => cls -> sig
_set_outlines = runMethod @"_set_outlines"

_set_playing :: Method "_set_playing" cls sig => cls -> sig
_set_playing = runMethod @"_set_playing"

_set_polygons :: Method "_set_polygons" cls sig => cls -> sig
_set_polygons = runMethod @"_set_polygons"

_set_resources :: Method "_set_resources" cls sig => cls -> sig
_set_resources = runMethod @"_set_resources"

_set_rw_position :: Method "_set_rw_position" cls sig => cls -> sig
_set_rw_position = runMethod @"_set_rw_position"

_set_swing_span :: Method "_set_swing_span" cls sig => cls -> sig
_set_swing_span = runMethod @"_set_swing_span"

_set_textures :: Method "_set_textures" cls sig => cls -> sig
_set_textures = runMethod @"_set_textures"

_set_tile_data :: Method "_set_tile_data" cls sig => cls -> sig
_set_tile_data = runMethod @"_set_tile_data"

_set_transform_array ::
                       Method "_set_transform_array" cls sig => cls -> sig
_set_transform_array = runMethod @"_set_transform_array"

_set_triangles :: Method "_set_triangles" cls sig => cls -> sig
_set_triangles = runMethod @"_set_triangles"

_set_twist_span :: Method "_set_twist_span" cls sig => cls -> sig
_set_twist_span = runMethod @"_set_twist_span"

_set_type :: Method "_set_type" cls sig => cls -> sig
_set_type = runMethod @"_set_type"

_set_type_cache :: Method "_set_type_cache" cls sig => cls -> sig
_set_type_cache = runMethod @"_set_type_cache"

_set_upper_limit :: Method "_set_upper_limit" cls sig => cls -> sig
_set_upper_limit = runMethod @"_set_upper_limit"

_set_upper_limit_angular ::
                           Method "_set_upper_limit_angular" cls sig => cls -> sig
_set_upper_limit_angular = runMethod @"_set_upper_limit_angular"

_set_user_data :: Method "_set_user_data" cls sig => cls -> sig
_set_user_data = runMethod @"_set_user_data"

_setup_local_to_scene ::
                        Method "_setup_local_to_scene" cls sig => cls -> sig
_setup_local_to_scene = runMethod @"_setup_local_to_scene"

_shader_changed :: Method "_shader_changed" cls sig => cls -> sig
_shader_changed = runMethod @"_shader_changed"

_shape_changed :: Method "_shape_changed" cls sig => cls -> sig
_shape_changed = runMethod @"_shape_changed"

_show_debugger :: Method "_show_debugger" cls sig => cls -> sig
_show_debugger = runMethod @"_show_debugger"

_signal_callback :: Method "_signal_callback" cls sig => cls -> sig
_signal_callback = runMethod @"_signal_callback"

_size_changed :: Method "_size_changed" cls sig => cls -> sig
_size_changed = runMethod @"_size_changed"

_snap_toggled :: Method "_snap_toggled" cls sig => cls -> sig
_snap_toggled = runMethod @"_snap_toggled"

_snap_value_changed ::
                      Method "_snap_value_changed" cls sig => cls -> sig
_snap_value_changed = runMethod @"_snap_value_changed"

_sort_children :: Method "_sort_children" cls sig => cls -> sig
_sort_children = runMethod @"_sort_children"

_start_find_in_files ::
                       Method "_start_find_in_files" cls sig => cls -> sig
_start_find_in_files = runMethod @"_start_find_in_files"

_step :: Method "_step" cls sig => cls -> sig
_step = runMethod @"_step"

_subcall :: Method "_subcall" cls sig => cls -> sig
_subcall = runMethod @"_subcall"

_submenu_timeout :: Method "_submenu_timeout" cls sig => cls -> sig
_submenu_timeout = runMethod @"_submenu_timeout"

_subwindow_visibility_changed ::
                                Method "_subwindow_visibility_changed" cls sig => cls -> sig
_subwindow_visibility_changed
  = runMethod @"_subwindow_visibility_changed"

_tab_changed :: Method "_tab_changed" cls sig => cls -> sig
_tab_changed = runMethod @"_tab_changed"

_template_changed ::
                    Method "_template_changed" cls sig => cls -> sig
_template_changed = runMethod @"_template_changed"

_text_changed :: Method "_text_changed" cls sig => cls -> sig
_text_changed = runMethod @"_text_changed"

_text_changed_emit ::
                     Method "_text_changed_emit" cls sig => cls -> sig
_text_changed_emit = runMethod @"_text_changed_emit"

_text_editor_enter ::
                     Method "_text_editor_enter" cls sig => cls -> sig
_text_editor_enter = runMethod @"_text_editor_enter"

_text_editor_modal_close ::
                           Method "_text_editor_modal_close" cls sig => cls -> sig
_text_editor_modal_close = runMethod @"_text_editor_modal_close"

_text_entered :: Method "_text_entered" cls sig => cls -> sig
_text_entered = runMethod @"_text_entered"

_text_type_toggled ::
                     Method "_text_type_toggled" cls sig => cls -> sig
_text_type_toggled = runMethod @"_text_type_toggled"

_theme_changed :: Method "_theme_changed" cls sig => cls -> sig
_theme_changed = runMethod @"_theme_changed"

_theme_option :: Method "_theme_option" cls sig => cls -> sig
_theme_option = runMethod @"_theme_option"

_thread_done :: Method "_thread_done" cls sig => cls -> sig
_thread_done = runMethod @"_thread_done"

_thumbnail_done :: Method "_thumbnail_done" cls sig => cls -> sig
_thumbnail_done = runMethod @"_thumbnail_done"

_thumbnail_result ::
                    Method "_thumbnail_result" cls sig => cls -> sig
_thumbnail_result = runMethod @"_thumbnail_result"

_toggle_draw_caret ::
                     Method "_toggle_draw_caret" cls sig => cls -> sig
_toggle_draw_caret = runMethod @"_toggle_draw_caret"

_toggle_members_overview_alpha_sort ::
                                      Method "_toggle_members_overview_alpha_sort" cls sig =>
                                      cls -> sig
_toggle_members_overview_alpha_sort
  = runMethod @"_toggle_members_overview_alpha_sort"

_toggled :: Method "_toggled" cls sig => cls -> sig
_toggled = runMethod @"_toggled"

_top_layer_draw :: Method "_top_layer_draw" cls sig => cls -> sig
_top_layer_draw = runMethod @"_top_layer_draw"

_top_layer_input :: Method "_top_layer_input" cls sig => cls -> sig
_top_layer_input = runMethod @"_top_layer_input"

_toplevel_raise_self ::
                       Method "_toplevel_raise_self" cls sig => cls -> sig
_toplevel_raise_self = runMethod @"_toplevel_raise_self"

_tree_changed :: Method "_tree_changed" cls sig => cls -> sig
_tree_changed = runMethod @"_tree_changed"

_tree_item_activated ::
                       Method "_tree_item_activated" cls sig => cls -> sig
_tree_item_activated = runMethod @"_tree_item_activated"

_tree_multi_selected ::
                       Method "_tree_multi_selected" cls sig => cls -> sig
_tree_multi_selected = runMethod @"_tree_multi_selected"

_tree_selected :: Method "_tree_selected" cls sig => cls -> sig
_tree_selected = runMethod @"_tree_selected"

_unhandled_input :: Method "_unhandled_input" cls sig => cls -> sig
_unhandled_input = runMethod @"_unhandled_input"

_unhandled_key_input ::
                       Method "_unhandled_key_input" cls sig => cls -> sig
_unhandled_key_input = runMethod @"_unhandled_key_input"

_update :: Method "_update" cls sig => cls -> sig
_update = runMethod @"_update"

_update_bone_setup ::
                     Method "_update_bone_setup" cls sig => cls -> sig
_update_bone_setup = runMethod @"_update_bone_setup"

_update_callback :: Method "_update_callback" cls sig => cls -> sig
_update_callback = runMethod @"_update_callback"

_update_current_tab ::
                      Method "_update_current_tab" cls sig => cls -> sig
_update_current_tab = runMethod @"_update_current_tab"

_update_dir :: Method "_update_dir" cls sig => cls -> sig
_update_dir = runMethod @"_update_dir"

_update_file_list ::
                    Method "_update_file_list" cls sig => cls -> sig
_update_file_list = runMethod @"_update_file_list"

_update_gizmo :: Method "_update_gizmo" cls sig => cls -> sig
_update_gizmo = runMethod @"_update_gizmo"

_update_hover :: Method "_update_hover" cls sig => cls -> sig
_update_hover = runMethod @"_update_hover"

_update_members_overview ::
                           Method "_update_members_overview" cls sig => cls -> sig
_update_members_overview = runMethod @"_update_members_overview"

_update_minimum_size ::
                       Method "_update_minimum_size" cls sig => cls -> sig
_update_minimum_size = runMethod @"_update_minimum_size"

_update_octants_callback ::
                           Method "_update_octants_callback" cls sig => cls -> sig
_update_octants_callback = runMethod @"_update_octants_callback"

_update_presets :: Method "_update_presets" cls sig => cls -> sig
_update_presets = runMethod @"_update_presets"

_update_properties ::
                     Method "_update_properties" cls sig => cls -> sig
_update_properties = runMethod @"_update_properties"

_update_proxy :: Method "_update_proxy" cls sig => cls -> sig
_update_proxy = runMethod @"_update_proxy"

_update_recent_scripts ::
                         Method "_update_recent_scripts" cls sig => cls -> sig
_update_recent_scripts = runMethod @"_update_recent_scripts"

_update_render_thread ::
                        Method "_update_render_thread" cls sig => cls -> sig
_update_render_thread = runMethod @"_update_render_thread"

_update_script_names ::
                       Method "_update_script_names" cls sig => cls -> sig
_update_script_names = runMethod @"_update_script_names"

_update_scroll :: Method "_update_scroll" cls sig => cls -> sig
_update_scroll = runMethod @"_update_scroll"

_update_scroll_offset ::
                        Method "_update_scroll_offset" cls sig => cls -> sig
_update_scroll_offset = runMethod @"_update_scroll_offset"

_update_scrollbar_position ::
                             Method "_update_scrollbar_position" cls sig => cls -> sig
_update_scrollbar_position
  = runMethod @"_update_scrollbar_position"

_update_shader :: Method "_update_shader" cls sig => cls -> sig
_update_shader = runMethod @"_update_shader"

_update_shape :: Method "_update_shape" cls sig => cls -> sig
_update_shape = runMethod @"_update_shape"

_update_sky :: Method "_update_sky" cls sig => cls -> sig
_update_sky = runMethod @"_update_sky"

_update_texture :: Method "_update_texture" cls sig => cls -> sig
_update_texture = runMethod @"_update_texture"

_update_transform ::
                    Method "_update_transform" cls sig => cls -> sig
_update_transform = runMethod @"_update_transform"

_uv_input :: Method "_uv_input" cls sig => cls -> sig
_uv_input = runMethod @"_uv_input"

_v_scroll_input :: Method "_v_scroll_input" cls sig => cls -> sig
_v_scroll_input = runMethod @"_v_scroll_input"

_value_changed :: Method "_value_changed" cls sig => cls -> sig
_value_changed = runMethod @"_value_changed"

_value_editor_changed ::
                        Method "_value_editor_changed" cls sig => cls -> sig
_value_editor_changed = runMethod @"_value_editor_changed"

_vp_input :: Method "_vp_input" cls sig => cls -> sig
_vp_input = runMethod @"_vp_input"

_vp_input_text :: Method "_vp_input_text" cls sig => cls -> sig
_vp_input_text = runMethod @"_vp_input_text"

_vp_unhandled_input ::
                      Method "_vp_unhandled_input" cls sig => cls -> sig
_vp_unhandled_input = runMethod @"_vp_unhandled_input"

_vscroll_changed :: Method "_vscroll_changed" cls sig => cls -> sig
_vscroll_changed = runMethod @"_vscroll_changed"

_w_input :: Method "_w_input" cls sig => cls -> sig
_w_input = runMethod @"_w_input"

_zoom_minus :: Method "_zoom_minus" cls sig => cls -> sig
_zoom_minus = runMethod @"_zoom_minus"

_zoom_plus :: Method "_zoom_plus" cls sig => cls -> sig
_zoom_plus = runMethod @"_zoom_plus"

_zoom_reset :: Method "_zoom_reset" cls sig => cls -> sig
_zoom_reset = runMethod @"_zoom_reset"

accept_event :: Method "accept_event" cls sig => cls -> sig
accept_event = runMethod @"accept_event"

accept_stream :: Method "accept_stream" cls sig => cls -> sig
accept_stream = runMethod @"accept_stream"

action_add_event :: Method "action_add_event" cls sig => cls -> sig
action_add_event = runMethod @"action_add_event"

action_erase_event ::
                     Method "action_erase_event" cls sig => cls -> sig
action_erase_event = runMethod @"action_erase_event"

action_erase_events ::
                      Method "action_erase_events" cls sig => cls -> sig
action_erase_events = runMethod @"action_erase_events"

action_has_event :: Method "action_has_event" cls sig => cls -> sig
action_has_event = runMethod @"action_has_event"

action_press :: Method "action_press" cls sig => cls -> sig
action_press = runMethod @"action_press"

action_release :: Method "action_release" cls sig => cls -> sig
action_release = runMethod @"action_release"

action_set_deadzone ::
                      Method "action_set_deadzone" cls sig => cls -> sig
action_set_deadzone = runMethod @"action_set_deadzone"

add_action :: Method "add_action" cls sig => cls -> sig
add_action = runMethod @"add_action"

add_animation :: Method "add_animation" cls sig => cls -> sig
add_animation = runMethod @"add_animation"

add_autoload_singleton ::
                         Method "add_autoload_singleton" cls sig => cls -> sig
add_autoload_singleton = runMethod @"add_autoload_singleton"

add_blend_point :: Method "add_blend_point" cls sig => cls -> sig
add_blend_point = runMethod @"add_blend_point"

add_blend_shape :: Method "add_blend_shape" cls sig => cls -> sig
add_blend_shape = runMethod @"add_blend_shape"

add_bone :: Method "add_bone" cls sig => cls -> sig
add_bone = runMethod @"add_bone"

add_bones :: Method "add_bones" cls sig => cls -> sig
add_bones = runMethod @"add_bones"

add_bus :: Method "add_bus" cls sig => cls -> sig
add_bus = runMethod @"add_bus"

add_bus_effect :: Method "add_bus_effect" cls sig => cls -> sig
add_bus_effect = runMethod @"add_bus_effect"

add_button :: Method "add_button" cls sig => cls -> sig
add_button = runMethod @"add_button"

add_cancel :: Method "add_cancel" cls sig => cls -> sig
add_cancel = runMethod @"add_cancel"

add_central_force ::
                    Method "add_central_force" cls sig => cls -> sig
add_central_force = runMethod @"add_central_force"

add_char :: Method "add_char" cls sig => cls -> sig
add_char = runMethod @"add_char"

add_check_item :: Method "add_check_item" cls sig => cls -> sig
add_check_item = runMethod @"add_check_item"

add_check_shortcut ::
                     Method "add_check_shortcut" cls sig => cls -> sig
add_check_shortcut = runMethod @"add_check_shortcut"

add_child :: Method "add_child" cls sig => cls -> sig
add_child = runMethod @"add_child"

add_child_below_node ::
                       Method "add_child_below_node" cls sig => cls -> sig
add_child_below_node = runMethod @"add_child_below_node"

add_collision_exception_with ::
                               Method "add_collision_exception_with" cls sig => cls -> sig
add_collision_exception_with
  = runMethod @"add_collision_exception_with"

add_collision_segments ::
                         Method "add_collision_segments" cls sig => cls -> sig
add_collision_segments = runMethod @"add_collision_segments"

add_collision_triangles ::
                          Method "add_collision_triangles" cls sig => cls -> sig
add_collision_triangles = runMethod @"add_collision_triangles"

add_color :: Method "add_color" cls sig => cls -> sig
add_color = runMethod @"add_color"

add_color_override ::
                     Method "add_color_override" cls sig => cls -> sig
add_color_override = runMethod @"add_color_override"

add_color_region :: Method "add_color_region" cls sig => cls -> sig
add_color_region = runMethod @"add_color_region"

add_constant_override ::
                        Method "add_constant_override" cls sig => cls -> sig
add_constant_override = runMethod @"add_constant_override"

add_control_to_bottom_panel ::
                              Method "add_control_to_bottom_panel" cls sig => cls -> sig
add_control_to_bottom_panel
  = runMethod @"add_control_to_bottom_panel"

add_control_to_container ::
                           Method "add_control_to_container" cls sig => cls -> sig
add_control_to_container = runMethod @"add_control_to_container"

add_control_to_dock ::
                      Method "add_control_to_dock" cls sig => cls -> sig
add_control_to_dock = runMethod @"add_control_to_dock"

add_custom_control ::
                     Method "add_custom_control" cls sig => cls -> sig
add_custom_control = runMethod @"add_custom_control"

add_custom_node :: Method "add_custom_node" cls sig => cls -> sig
add_custom_node = runMethod @"add_custom_node"

add_custom_signal ::
                    Method "add_custom_signal" cls sig => cls -> sig
add_custom_signal = runMethod @"add_custom_signal"

add_custom_type :: Method "add_custom_type" cls sig => cls -> sig
add_custom_type = runMethod @"add_custom_type"

add_device :: Method "add_device" cls sig => cls -> sig
add_device = runMethod @"add_device"

add_do_method :: Method "add_do_method" cls sig => cls -> sig
add_do_method = runMethod @"add_do_method"

add_do_property :: Method "add_do_property" cls sig => cls -> sig
add_do_property = runMethod @"add_do_property"

add_do_reference :: Method "add_do_reference" cls sig => cls -> sig
add_do_reference = runMethod @"add_do_reference"

add_exception :: Method "add_exception" cls sig => cls -> sig
add_exception = runMethod @"add_exception"

add_exception_rid ::
                    Method "add_exception_rid" cls sig => cls -> sig
add_exception_rid = runMethod @"add_exception_rid"

add_excluded_object ::
                      Method "add_excluded_object" cls sig => cls -> sig
add_excluded_object = runMethod @"add_excluded_object"

add_export_plugin ::
                    Method "add_export_plugin" cls sig => cls -> sig
add_export_plugin = runMethod @"add_export_plugin"

add_fallback :: Method "add_fallback" cls sig => cls -> sig
add_fallback = runMethod @"add_fallback"

add_file :: Method "add_file" cls sig => cls -> sig
add_file = runMethod @"add_file"

add_filter :: Method "add_filter" cls sig => cls -> sig
add_filter = runMethod @"add_filter"

add_font_override ::
                    Method "add_font_override" cls sig => cls -> sig
add_font_override = runMethod @"add_font_override"

add_force :: Method "add_force" cls sig => cls -> sig
add_force = runMethod @"add_force"

add_frame :: Method "add_frame" cls sig => cls -> sig
add_frame = runMethod @"add_frame"

add_function :: Method "add_function" cls sig => cls -> sig
add_function = runMethod @"add_function"

add_handles :: Method "add_handles" cls sig => cls -> sig
add_handles = runMethod @"add_handles"

add_icon_check_item ::
                      Method "add_icon_check_item" cls sig => cls -> sig
add_icon_check_item = runMethod @"add_icon_check_item"

add_icon_check_shortcut ::
                          Method "add_icon_check_shortcut" cls sig => cls -> sig
add_icon_check_shortcut = runMethod @"add_icon_check_shortcut"

add_icon_item :: Method "add_icon_item" cls sig => cls -> sig
add_icon_item = runMethod @"add_icon_item"

add_icon_override ::
                    Method "add_icon_override" cls sig => cls -> sig
add_icon_override = runMethod @"add_icon_override"

add_icon_shortcut ::
                    Method "add_icon_shortcut" cls sig => cls -> sig
add_icon_shortcut = runMethod @"add_icon_shortcut"

add_image :: Method "add_image" cls sig => cls -> sig
add_image = runMethod @"add_image"

add_import_plugin ::
                    Method "add_import_plugin" cls sig => cls -> sig
add_import_plugin = runMethod @"add_import_plugin"

add_index :: Method "add_index" cls sig => cls -> sig
add_index = runMethod @"add_index"

add_input :: Method "add_input" cls sig => cls -> sig
add_input = runMethod @"add_input"

add_inspector_plugin ::
                       Method "add_inspector_plugin" cls sig => cls -> sig
add_inspector_plugin = runMethod @"add_inspector_plugin"

add_ios_bundle_file ::
                      Method "add_ios_bundle_file" cls sig => cls -> sig
add_ios_bundle_file = runMethod @"add_ios_bundle_file"

add_ios_cpp_code :: Method "add_ios_cpp_code" cls sig => cls -> sig
add_ios_cpp_code = runMethod @"add_ios_cpp_code"

add_ios_framework ::
                    Method "add_ios_framework" cls sig => cls -> sig
add_ios_framework = runMethod @"add_ios_framework"

add_ios_linker_flags ::
                       Method "add_ios_linker_flags" cls sig => cls -> sig
add_ios_linker_flags = runMethod @"add_ios_linker_flags"

add_ios_plist_content ::
                        Method "add_ios_plist_content" cls sig => cls -> sig
add_ios_plist_content = runMethod @"add_ios_plist_content"

add_item :: Method "add_item" cls sig => cls -> sig
add_item = runMethod @"add_item"

add_joy_mapping :: Method "add_joy_mapping" cls sig => cls -> sig
add_joy_mapping = runMethod @"add_joy_mapping"

add_kerning_pair :: Method "add_kerning_pair" cls sig => cls -> sig
add_kerning_pair = runMethod @"add_kerning_pair"

add_keyword_color ::
                    Method "add_keyword_color" cls sig => cls -> sig
add_keyword_color = runMethod @"add_keyword_color"

add_lines :: Method "add_lines" cls sig => cls -> sig
add_lines = runMethod @"add_lines"

add_mesh :: Method "add_mesh" cls sig => cls -> sig
add_mesh = runMethod @"add_mesh"

add_message :: Method "add_message" cls sig => cls -> sig
add_message = runMethod @"add_message"

add_node :: Method "add_node" cls sig => cls -> sig
add_node = runMethod @"add_node"

add_normal :: Method "add_normal" cls sig => cls -> sig
add_normal = runMethod @"add_normal"

add_outline :: Method "add_outline" cls sig => cls -> sig
add_outline = runMethod @"add_outline"

add_outline_at_index ::
                       Method "add_outline_at_index" cls sig => cls -> sig
add_outline_at_index = runMethod @"add_outline_at_index"

add_piece :: Method "add_piece" cls sig => cls -> sig
add_piece = runMethod @"add_piece"

add_point :: Method "add_point" cls sig => cls -> sig
add_point = runMethod @"add_point"

add_polygon :: Method "add_polygon" cls sig => cls -> sig
add_polygon = runMethod @"add_polygon"

add_port_mapping :: Method "add_port_mapping" cls sig => cls -> sig
add_port_mapping = runMethod @"add_port_mapping"

add_preset :: Method "add_preset" cls sig => cls -> sig
add_preset = runMethod @"add_preset"

add_preview_generator ::
                        Method "add_preview_generator" cls sig => cls -> sig
add_preview_generator = runMethod @"add_preview_generator"

add_property_editor ::
                      Method "add_property_editor" cls sig => cls -> sig
add_property_editor = runMethod @"add_property_editor"

add_property_editor_for_multiple_properties ::
                                              Method "add_property_editor_for_multiple_properties"
                                                cls sig =>
                                              cls -> sig
add_property_editor_for_multiple_properties
  = runMethod @"add_property_editor_for_multiple_properties"

add_property_info ::
                    Method "add_property_info" cls sig => cls -> sig
add_property_info = runMethod @"add_property_info"

add_radio_check_item ::
                       Method "add_radio_check_item" cls sig => cls -> sig
add_radio_check_item = runMethod @"add_radio_check_item"

add_radio_check_shortcut ::
                           Method "add_radio_check_shortcut" cls sig => cls -> sig
add_radio_check_shortcut = runMethod @"add_radio_check_shortcut"

add_resource :: Method "add_resource" cls sig => cls -> sig
add_resource = runMethod @"add_resource"

add_root_node :: Method "add_root_node" cls sig => cls -> sig
add_root_node = runMethod @"add_root_node"

add_scene_import_plugin ::
                          Method "add_scene_import_plugin" cls sig => cls -> sig
add_scene_import_plugin = runMethod @"add_scene_import_plugin"

add_separator :: Method "add_separator" cls sig => cls -> sig
add_separator = runMethod @"add_separator"

add_shader_override ::
                      Method "add_shader_override" cls sig => cls -> sig
add_shader_override = runMethod @"add_shader_override"

add_shared_object ::
                    Method "add_shared_object" cls sig => cls -> sig
add_shared_object = runMethod @"add_shared_object"

add_shortcut :: Method "add_shortcut" cls sig => cls -> sig
add_shortcut = runMethod @"add_shortcut"

add_smooth_group :: Method "add_smooth_group" cls sig => cls -> sig
add_smooth_group = runMethod @"add_smooth_group"

add_spacer :: Method "add_spacer" cls sig => cls -> sig
add_spacer = runMethod @"add_spacer"

add_sphere :: Method "add_sphere" cls sig => cls -> sig
add_sphere = runMethod @"add_sphere"

add_stylebox_override ::
                        Method "add_stylebox_override" cls sig => cls -> sig
add_stylebox_override = runMethod @"add_stylebox_override"

add_submenu_item :: Method "add_submenu_item" cls sig => cls -> sig
add_submenu_item = runMethod @"add_submenu_item"

add_surface_from_arrays ::
                          Method "add_surface_from_arrays" cls sig => cls -> sig
add_surface_from_arrays = runMethod @"add_surface_from_arrays"

add_tab :: Method "add_tab" cls sig => cls -> sig
add_tab = runMethod @"add_tab"

add_tangent :: Method "add_tangent" cls sig => cls -> sig
add_tangent = runMethod @"add_tangent"

add_text :: Method "add_text" cls sig => cls -> sig
add_text = runMethod @"add_text"

add_texture :: Method "add_texture" cls sig => cls -> sig
add_texture = runMethod @"add_texture"

add_to_format :: Method "add_to_format" cls sig => cls -> sig
add_to_format = runMethod @"add_to_format"

add_to_group :: Method "add_to_group" cls sig => cls -> sig
add_to_group = runMethod @"add_to_group"

add_tool_menu_item ::
                     Method "add_tool_menu_item" cls sig => cls -> sig
add_tool_menu_item = runMethod @"add_tool_menu_item"

add_tool_submenu_item ::
                        Method "add_tool_submenu_item" cls sig => cls -> sig
add_tool_submenu_item = runMethod @"add_tool_submenu_item"

add_torque :: Method "add_torque" cls sig => cls -> sig
add_torque = runMethod @"add_torque"

add_track :: Method "add_track" cls sig => cls -> sig
add_track = runMethod @"add_track"

add_transition :: Method "add_transition" cls sig => cls -> sig
add_transition = runMethod @"add_transition"

add_translation :: Method "add_translation" cls sig => cls -> sig
add_translation = runMethod @"add_translation"

add_triangle :: Method "add_triangle" cls sig => cls -> sig
add_triangle = runMethod @"add_triangle"

add_triangle_fan :: Method "add_triangle_fan" cls sig => cls -> sig
add_triangle_fan = runMethod @"add_triangle_fan"

add_undo_method :: Method "add_undo_method" cls sig => cls -> sig
add_undo_method = runMethod @"add_undo_method"

add_undo_property ::
                    Method "add_undo_property" cls sig => cls -> sig
add_undo_property = runMethod @"add_undo_property"

add_undo_reference ::
                     Method "add_undo_reference" cls sig => cls -> sig
add_undo_reference = runMethod @"add_undo_reference"

add_unscaled_billboard ::
                         Method "add_unscaled_billboard" cls sig => cls -> sig
add_unscaled_billboard = runMethod @"add_unscaled_billboard"

add_user :: Method "add_user" cls sig => cls -> sig
add_user = runMethod @"add_user"

add_user_signal :: Method "add_user_signal" cls sig => cls -> sig
add_user_signal = runMethod @"add_user_signal"

add_uv :: Method "add_uv" cls sig => cls -> sig
add_uv = runMethod @"add_uv"

add_uv2 :: Method "add_uv2" cls sig => cls -> sig
add_uv2 = runMethod @"add_uv2"

add_valid_connection_type ::
                            Method "add_valid_connection_type" cls sig => cls -> sig
add_valid_connection_type = runMethod @"add_valid_connection_type"

add_valid_left_disconnect_type ::
                                 Method "add_valid_left_disconnect_type" cls sig => cls -> sig
add_valid_left_disconnect_type
  = runMethod @"add_valid_left_disconnect_type"

add_valid_right_disconnect_type ::
                                  Method "add_valid_right_disconnect_type" cls sig => cls -> sig
add_valid_right_disconnect_type
  = runMethod @"add_valid_right_disconnect_type"

add_variable :: Method "add_variable" cls sig => cls -> sig
add_variable = runMethod @"add_variable"

add_vertex :: Method "add_vertex" cls sig => cls -> sig
add_vertex = runMethod @"add_vertex"

add_weights :: Method "add_weights" cls sig => cls -> sig
add_weights = runMethod @"add_weights"

advance :: Method "advance" cls sig => cls -> sig
advance = runMethod @"advance"

alert :: Method "alert" cls sig => cls -> sig
alert = runMethod @"alert"

align :: Method "align" cls sig => cls -> sig
align = runMethod @"align"

animation_get_next ::
                     Method "animation_get_next" cls sig => cls -> sig
animation_get_next = runMethod @"animation_get_next"

animation_node_get_animation ::
                               Method "animation_node_get_animation" cls sig => cls -> sig
animation_node_get_animation
  = runMethod @"animation_node_get_animation"

animation_node_get_master_animation ::
                                      Method "animation_node_get_master_animation" cls sig =>
                                      cls -> sig
animation_node_get_master_animation
  = runMethod @"animation_node_get_master_animation"

animation_node_get_position ::
                              Method "animation_node_get_position" cls sig => cls -> sig
animation_node_get_position
  = runMethod @"animation_node_get_position"

animation_node_set_animation ::
                               Method "animation_node_set_animation" cls sig => cls -> sig
animation_node_set_animation
  = runMethod @"animation_node_set_animation"

animation_node_set_filter_path ::
                                 Method "animation_node_set_filter_path" cls sig => cls -> sig
animation_node_set_filter_path
  = runMethod @"animation_node_set_filter_path"

animation_node_set_master_animation ::
                                      Method "animation_node_set_master_animation" cls sig =>
                                      cls -> sig
animation_node_set_master_animation
  = runMethod @"animation_node_set_master_animation"

animation_set_next ::
                     Method "animation_set_next" cls sig => cls -> sig
animation_set_next = runMethod @"animation_set_next"

animation_track_get_key_animation ::
                                    Method "animation_track_get_key_animation" cls sig => cls -> sig
animation_track_get_key_animation
  = runMethod @"animation_track_get_key_animation"

animation_track_insert_key ::
                             Method "animation_track_insert_key" cls sig => cls -> sig
animation_track_insert_key
  = runMethod @"animation_track_insert_key"

animation_track_set_key_animation ::
                                    Method "animation_track_set_key_animation" cls sig => cls -> sig
animation_track_set_key_animation
  = runMethod @"animation_track_set_key_animation"

append_at_cursor :: Method "append_at_cursor" cls sig => cls -> sig
append_at_cursor = runMethod @"append_at_cursor"

append_bbcode :: Method "append_bbcode" cls sig => cls -> sig
append_bbcode = runMethod @"append_bbcode"

append_from :: Method "append_from" cls sig => cls -> sig
append_from = runMethod @"append_from"

apply_central_impulse ::
                        Method "apply_central_impulse" cls sig => cls -> sig
apply_central_impulse = runMethod @"apply_central_impulse"

apply_changes :: Method "apply_changes" cls sig => cls -> sig
apply_changes = runMethod @"apply_changes"

apply_impulse :: Method "apply_impulse" cls sig => cls -> sig
apply_impulse = runMethod @"apply_impulse"

apply_rest :: Method "apply_rest" cls sig => cls -> sig
apply_rest = runMethod @"apply_rest"

apply_scale :: Method "apply_scale" cls sig => cls -> sig
apply_scale = runMethod @"apply_scale"

apply_torque_impulse ::
                       Method "apply_torque_impulse" cls sig => cls -> sig
apply_torque_impulse = runMethod @"apply_torque_impulse"

are_column_titles_visible ::
                            Method "are_column_titles_visible" cls sig => cls -> sig
are_column_titles_visible = runMethod @"are_column_titles_visible"

are_nodes_connected ::
                      Method "are_nodes_connected" cls sig => cls -> sig
are_nodes_connected = runMethod @"are_nodes_connected"

are_points_connected ::
                       Method "are_points_connected" cls sig => cls -> sig
are_points_connected = runMethod @"are_points_connected"

are_shadows_enabled ::
                      Method "are_shadows_enabled" cls sig => cls -> sig
are_shadows_enabled = runMethod @"are_shadows_enabled"

are_tabs_visible :: Method "are_tabs_visible" cls sig => cls -> sig
are_tabs_visible = runMethod @"are_tabs_visible"

area_add_shape :: Method "area_add_shape" cls sig => cls -> sig
area_add_shape = runMethod @"area_add_shape"

area_attach_object_instance_id ::
                                 Method "area_attach_object_instance_id" cls sig => cls -> sig
area_attach_object_instance_id
  = runMethod @"area_attach_object_instance_id"

area_clear_shapes ::
                    Method "area_clear_shapes" cls sig => cls -> sig
area_clear_shapes = runMethod @"area_clear_shapes"

area_create :: Method "area_create" cls sig => cls -> sig
area_create = runMethod @"area_create"

area_get_object_instance_id ::
                              Method "area_get_object_instance_id" cls sig => cls -> sig
area_get_object_instance_id
  = runMethod @"area_get_object_instance_id"

area_get_param :: Method "area_get_param" cls sig => cls -> sig
area_get_param = runMethod @"area_get_param"

area_get_shape :: Method "area_get_shape" cls sig => cls -> sig
area_get_shape = runMethod @"area_get_shape"

area_get_shape_count ::
                       Method "area_get_shape_count" cls sig => cls -> sig
area_get_shape_count = runMethod @"area_get_shape_count"

area_get_shape_transform ::
                           Method "area_get_shape_transform" cls sig => cls -> sig
area_get_shape_transform = runMethod @"area_get_shape_transform"

area_get_space :: Method "area_get_space" cls sig => cls -> sig
area_get_space = runMethod @"area_get_space"

area_get_space_override_mode ::
                               Method "area_get_space_override_mode" cls sig => cls -> sig
area_get_space_override_mode
  = runMethod @"area_get_space_override_mode"

area_get_transform ::
                     Method "area_get_transform" cls sig => cls -> sig
area_get_transform = runMethod @"area_get_transform"

area_is_ray_pickable ::
                       Method "area_is_ray_pickable" cls sig => cls -> sig
area_is_ray_pickable = runMethod @"area_is_ray_pickable"

area_remove_shape ::
                    Method "area_remove_shape" cls sig => cls -> sig
area_remove_shape = runMethod @"area_remove_shape"

area_set_area_monitor_callback ::
                                 Method "area_set_area_monitor_callback" cls sig => cls -> sig
area_set_area_monitor_callback
  = runMethod @"area_set_area_monitor_callback"

area_set_collision_layer ::
                           Method "area_set_collision_layer" cls sig => cls -> sig
area_set_collision_layer = runMethod @"area_set_collision_layer"

area_set_collision_mask ::
                          Method "area_set_collision_mask" cls sig => cls -> sig
area_set_collision_mask = runMethod @"area_set_collision_mask"

area_set_monitor_callback ::
                            Method "area_set_monitor_callback" cls sig => cls -> sig
area_set_monitor_callback = runMethod @"area_set_monitor_callback"

area_set_monitorable ::
                       Method "area_set_monitorable" cls sig => cls -> sig
area_set_monitorable = runMethod @"area_set_monitorable"

area_set_param :: Method "area_set_param" cls sig => cls -> sig
area_set_param = runMethod @"area_set_param"

area_set_ray_pickable ::
                        Method "area_set_ray_pickable" cls sig => cls -> sig
area_set_ray_pickable = runMethod @"area_set_ray_pickable"

area_set_shape :: Method "area_set_shape" cls sig => cls -> sig
area_set_shape = runMethod @"area_set_shape"

area_set_shape_disabled ::
                          Method "area_set_shape_disabled" cls sig => cls -> sig
area_set_shape_disabled = runMethod @"area_set_shape_disabled"

area_set_shape_transform ::
                           Method "area_set_shape_transform" cls sig => cls -> sig
area_set_shape_transform = runMethod @"area_set_shape_transform"

area_set_space :: Method "area_set_space" cls sig => cls -> sig
area_set_space = runMethod @"area_set_space"

area_set_space_override_mode ::
                               Method "area_set_space_override_mode" cls sig => cls -> sig
area_set_space_override_mode
  = runMethod @"area_set_space_override_mode"

area_set_transform ::
                     Method "area_set_transform" cls sig => cls -> sig
area_set_transform = runMethod @"area_set_transform"

as_text :: Method "as_text" cls sig => cls -> sig
as_text = runMethod @"as_text"

audio_track_get_key_end_offset ::
                                 Method "audio_track_get_key_end_offset" cls sig => cls -> sig
audio_track_get_key_end_offset
  = runMethod @"audio_track_get_key_end_offset"

audio_track_get_key_start_offset ::
                                   Method "audio_track_get_key_start_offset" cls sig => cls -> sig
audio_track_get_key_start_offset
  = runMethod @"audio_track_get_key_start_offset"

audio_track_get_key_stream ::
                             Method "audio_track_get_key_stream" cls sig => cls -> sig
audio_track_get_key_stream
  = runMethod @"audio_track_get_key_stream"

audio_track_insert_key ::
                         Method "audio_track_insert_key" cls sig => cls -> sig
audio_track_insert_key = runMethod @"audio_track_insert_key"

audio_track_set_key_end_offset ::
                                 Method "audio_track_set_key_end_offset" cls sig => cls -> sig
audio_track_set_key_end_offset
  = runMethod @"audio_track_set_key_end_offset"

audio_track_set_key_start_offset ::
                                   Method "audio_track_set_key_start_offset" cls sig => cls -> sig
audio_track_set_key_start_offset
  = runMethod @"audio_track_set_key_start_offset"

audio_track_set_key_stream ::
                             Method "audio_track_set_key_stream" cls sig => cls -> sig
audio_track_set_key_stream
  = runMethod @"audio_track_set_key_stream"

autotile_get_bitmask_mode ::
                            Method "autotile_get_bitmask_mode" cls sig => cls -> sig
autotile_get_bitmask_mode = runMethod @"autotile_get_bitmask_mode"

autotile_get_size ::
                    Method "autotile_get_size" cls sig => cls -> sig
autotile_get_size = runMethod @"autotile_get_size"

autotile_set_bitmask_mode ::
                            Method "autotile_set_bitmask_mode" cls sig => cls -> sig
autotile_set_bitmask_mode = runMethod @"autotile_set_bitmask_mode"

autotile_set_size ::
                    Method "autotile_set_size" cls sig => cls -> sig
autotile_set_size = runMethod @"autotile_set_size"

bake :: Method "bake" cls sig => cls -> sig
bake = runMethod @"bake"

base64_to_raw :: Method "base64_to_raw" cls sig => cls -> sig
base64_to_raw = runMethod @"base64_to_raw"

base64_to_utf8 :: Method "base64_to_utf8" cls sig => cls -> sig
base64_to_utf8 = runMethod @"base64_to_utf8"

base64_to_variant ::
                    Method "base64_to_variant" cls sig => cls -> sig
base64_to_variant = runMethod @"base64_to_variant"

begin :: Method "begin" cls sig => cls -> sig
begin = runMethod @"begin"

bezier_track_get_key_in_handle ::
                                 Method "bezier_track_get_key_in_handle" cls sig => cls -> sig
bezier_track_get_key_in_handle
  = runMethod @"bezier_track_get_key_in_handle"

bezier_track_get_key_out_handle ::
                                  Method "bezier_track_get_key_out_handle" cls sig => cls -> sig
bezier_track_get_key_out_handle
  = runMethod @"bezier_track_get_key_out_handle"

bezier_track_get_key_value ::
                             Method "bezier_track_get_key_value" cls sig => cls -> sig
bezier_track_get_key_value
  = runMethod @"bezier_track_get_key_value"

bezier_track_insert_key ::
                          Method "bezier_track_insert_key" cls sig => cls -> sig
bezier_track_insert_key = runMethod @"bezier_track_insert_key"

bezier_track_interpolate ::
                           Method "bezier_track_interpolate" cls sig => cls -> sig
bezier_track_interpolate = runMethod @"bezier_track_interpolate"

bezier_track_set_key_in_handle ::
                                 Method "bezier_track_set_key_in_handle" cls sig => cls -> sig
bezier_track_set_key_in_handle
  = runMethod @"bezier_track_set_key_in_handle"

bezier_track_set_key_out_handle ::
                                  Method "bezier_track_set_key_out_handle" cls sig => cls -> sig
bezier_track_set_key_out_handle
  = runMethod @"bezier_track_set_key_out_handle"

bezier_track_set_key_value ::
                             Method "bezier_track_set_key_value" cls sig => cls -> sig
bezier_track_set_key_value
  = runMethod @"bezier_track_set_key_value"

bind_child_node_to_bone ::
                          Method "bind_child_node_to_bone" cls sig => cls -> sig
bind_child_node_to_bone = runMethod @"bind_child_node_to_bone"

black_bars_set_images ::
                        Method "black_bars_set_images" cls sig => cls -> sig
black_bars_set_images = runMethod @"black_bars_set_images"

black_bars_set_margins ::
                         Method "black_bars_set_margins" cls sig => cls -> sig
black_bars_set_margins = runMethod @"black_bars_set_margins"

blend2_node_get_amount ::
                         Method "blend2_node_get_amount" cls sig => cls -> sig
blend2_node_get_amount = runMethod @"blend2_node_get_amount"

blend2_node_set_amount ::
                         Method "blend2_node_set_amount" cls sig => cls -> sig
blend2_node_set_amount = runMethod @"blend2_node_set_amount"

blend2_node_set_filter_path ::
                              Method "blend2_node_set_filter_path" cls sig => cls -> sig
blend2_node_set_filter_path
  = runMethod @"blend2_node_set_filter_path"

blend3_node_get_amount ::
                         Method "blend3_node_get_amount" cls sig => cls -> sig
blend3_node_get_amount = runMethod @"blend3_node_get_amount"

blend3_node_set_amount ::
                         Method "blend3_node_set_amount" cls sig => cls -> sig
blend3_node_set_amount = runMethod @"blend3_node_set_amount"

blend4_node_get_amount ::
                         Method "blend4_node_get_amount" cls sig => cls -> sig
blend4_node_get_amount = runMethod @"blend4_node_get_amount"

blend4_node_set_amount ::
                         Method "blend4_node_set_amount" cls sig => cls -> sig
blend4_node_set_amount = runMethod @"blend4_node_set_amount"

blend_animation :: Method "blend_animation" cls sig => cls -> sig
blend_animation = runMethod @"blend_animation"

blend_input :: Method "blend_input" cls sig => cls -> sig
blend_input = runMethod @"blend_input"

blend_node :: Method "blend_node" cls sig => cls -> sig
blend_node = runMethod @"blend_node"

blend_rect :: Method "blend_rect" cls sig => cls -> sig
blend_rect = runMethod @"blend_rect"

blend_rect_mask :: Method "blend_rect_mask" cls sig => cls -> sig
blend_rect_mask = runMethod @"blend_rect_mask"

blit_rect :: Method "blit_rect" cls sig => cls -> sig
blit_rect = runMethod @"blit_rect"

blit_rect_mask :: Method "blit_rect_mask" cls sig => cls -> sig
blit_rect_mask = runMethod @"blit_rect_mask"

body_add_central_force ::
                         Method "body_add_central_force" cls sig => cls -> sig
body_add_central_force = runMethod @"body_add_central_force"

body_add_collision_exception ::
                               Method "body_add_collision_exception" cls sig => cls -> sig
body_add_collision_exception
  = runMethod @"body_add_collision_exception"

body_add_force :: Method "body_add_force" cls sig => cls -> sig
body_add_force = runMethod @"body_add_force"

body_add_shape :: Method "body_add_shape" cls sig => cls -> sig
body_add_shape = runMethod @"body_add_shape"

body_add_torque :: Method "body_add_torque" cls sig => cls -> sig
body_add_torque = runMethod @"body_add_torque"

body_apply_central_impulse ::
                             Method "body_apply_central_impulse" cls sig => cls -> sig
body_apply_central_impulse
  = runMethod @"body_apply_central_impulse"

body_apply_impulse ::
                     Method "body_apply_impulse" cls sig => cls -> sig
body_apply_impulse = runMethod @"body_apply_impulse"

body_apply_torque_impulse ::
                            Method "body_apply_torque_impulse" cls sig => cls -> sig
body_apply_torque_impulse = runMethod @"body_apply_torque_impulse"

body_attach_object_instance_id ::
                                 Method "body_attach_object_instance_id" cls sig => cls -> sig
body_attach_object_instance_id
  = runMethod @"body_attach_object_instance_id"

body_clear_shapes ::
                    Method "body_clear_shapes" cls sig => cls -> sig
body_clear_shapes = runMethod @"body_clear_shapes"

body_create :: Method "body_create" cls sig => cls -> sig
body_create = runMethod @"body_create"

body_get_collision_layer ::
                           Method "body_get_collision_layer" cls sig => cls -> sig
body_get_collision_layer = runMethod @"body_get_collision_layer"

body_get_collision_mask ::
                          Method "body_get_collision_mask" cls sig => cls -> sig
body_get_collision_mask = runMethod @"body_get_collision_mask"

body_get_continuous_collision_detection_mode ::
                                               Method "body_get_continuous_collision_detection_mode"
                                                 cls sig =>
                                               cls -> sig
body_get_continuous_collision_detection_mode
  = runMethod @"body_get_continuous_collision_detection_mode"

body_get_direct_state ::
                        Method "body_get_direct_state" cls sig => cls -> sig
body_get_direct_state = runMethod @"body_get_direct_state"

body_get_kinematic_safe_margin ::
                                 Method "body_get_kinematic_safe_margin" cls sig => cls -> sig
body_get_kinematic_safe_margin
  = runMethod @"body_get_kinematic_safe_margin"

body_get_max_contacts_reported ::
                                 Method "body_get_max_contacts_reported" cls sig => cls -> sig
body_get_max_contacts_reported
  = runMethod @"body_get_max_contacts_reported"

body_get_mode :: Method "body_get_mode" cls sig => cls -> sig
body_get_mode = runMethod @"body_get_mode"

body_get_object_instance_id ::
                              Method "body_get_object_instance_id" cls sig => cls -> sig
body_get_object_instance_id
  = runMethod @"body_get_object_instance_id"

body_get_param :: Method "body_get_param" cls sig => cls -> sig
body_get_param = runMethod @"body_get_param"

body_get_shape :: Method "body_get_shape" cls sig => cls -> sig
body_get_shape = runMethod @"body_get_shape"

body_get_shape_count ::
                       Method "body_get_shape_count" cls sig => cls -> sig
body_get_shape_count = runMethod @"body_get_shape_count"

body_get_shape_metadata ::
                          Method "body_get_shape_metadata" cls sig => cls -> sig
body_get_shape_metadata = runMethod @"body_get_shape_metadata"

body_get_shape_transform ::
                           Method "body_get_shape_transform" cls sig => cls -> sig
body_get_shape_transform = runMethod @"body_get_shape_transform"

body_get_space :: Method "body_get_space" cls sig => cls -> sig
body_get_space = runMethod @"body_get_space"

body_get_state :: Method "body_get_state" cls sig => cls -> sig
body_get_state = runMethod @"body_get_state"

body_is_axis_locked ::
                      Method "body_is_axis_locked" cls sig => cls -> sig
body_is_axis_locked = runMethod @"body_is_axis_locked"

body_is_continuous_collision_detection_enabled ::
                                                 Method
                                                   "body_is_continuous_collision_detection_enabled"
                                                   cls sig =>
                                                 cls -> sig
body_is_continuous_collision_detection_enabled
  = runMethod @"body_is_continuous_collision_detection_enabled"

body_is_omitting_force_integration ::
                                     Method "body_is_omitting_force_integration" cls sig =>
                                     cls -> sig
body_is_omitting_force_integration
  = runMethod @"body_is_omitting_force_integration"

body_is_ray_pickable ::
                       Method "body_is_ray_pickable" cls sig => cls -> sig
body_is_ray_pickable = runMethod @"body_is_ray_pickable"

body_remove_collision_exception ::
                                  Method "body_remove_collision_exception" cls sig => cls -> sig
body_remove_collision_exception
  = runMethod @"body_remove_collision_exception"

body_remove_shape ::
                    Method "body_remove_shape" cls sig => cls -> sig
body_remove_shape = runMethod @"body_remove_shape"

body_set_axis_lock ::
                     Method "body_set_axis_lock" cls sig => cls -> sig
body_set_axis_lock = runMethod @"body_set_axis_lock"

body_set_axis_velocity ::
                         Method "body_set_axis_velocity" cls sig => cls -> sig
body_set_axis_velocity = runMethod @"body_set_axis_velocity"

body_set_collision_layer ::
                           Method "body_set_collision_layer" cls sig => cls -> sig
body_set_collision_layer = runMethod @"body_set_collision_layer"

body_set_collision_mask ::
                          Method "body_set_collision_mask" cls sig => cls -> sig
body_set_collision_mask = runMethod @"body_set_collision_mask"

body_set_continuous_collision_detection_mode ::
                                               Method "body_set_continuous_collision_detection_mode"
                                                 cls sig =>
                                               cls -> sig
body_set_continuous_collision_detection_mode
  = runMethod @"body_set_continuous_collision_detection_mode"

body_set_enable_continuous_collision_detection ::
                                                 Method
                                                   "body_set_enable_continuous_collision_detection"
                                                   cls sig =>
                                                 cls -> sig
body_set_enable_continuous_collision_detection
  = runMethod @"body_set_enable_continuous_collision_detection"

body_set_force_integration_callback ::
                                      Method "body_set_force_integration_callback" cls sig =>
                                      cls -> sig
body_set_force_integration_callback
  = runMethod @"body_set_force_integration_callback"

body_set_kinematic_safe_margin ::
                                 Method "body_set_kinematic_safe_margin" cls sig => cls -> sig
body_set_kinematic_safe_margin
  = runMethod @"body_set_kinematic_safe_margin"

body_set_max_contacts_reported ::
                                 Method "body_set_max_contacts_reported" cls sig => cls -> sig
body_set_max_contacts_reported
  = runMethod @"body_set_max_contacts_reported"

body_set_mode :: Method "body_set_mode" cls sig => cls -> sig
body_set_mode = runMethod @"body_set_mode"

body_set_omit_force_integration ::
                                  Method "body_set_omit_force_integration" cls sig => cls -> sig
body_set_omit_force_integration
  = runMethod @"body_set_omit_force_integration"

body_set_param :: Method "body_set_param" cls sig => cls -> sig
body_set_param = runMethod @"body_set_param"

body_set_ray_pickable ::
                        Method "body_set_ray_pickable" cls sig => cls -> sig
body_set_ray_pickable = runMethod @"body_set_ray_pickable"

body_set_shape :: Method "body_set_shape" cls sig => cls -> sig
body_set_shape = runMethod @"body_set_shape"

body_set_shape_as_one_way_collision ::
                                      Method "body_set_shape_as_one_way_collision" cls sig =>
                                      cls -> sig
body_set_shape_as_one_way_collision
  = runMethod @"body_set_shape_as_one_way_collision"

body_set_shape_disabled ::
                          Method "body_set_shape_disabled" cls sig => cls -> sig
body_set_shape_disabled = runMethod @"body_set_shape_disabled"

body_set_shape_metadata ::
                          Method "body_set_shape_metadata" cls sig => cls -> sig
body_set_shape_metadata = runMethod @"body_set_shape_metadata"

body_set_shape_transform ::
                           Method "body_set_shape_transform" cls sig => cls -> sig
body_set_shape_transform = runMethod @"body_set_shape_transform"

body_set_space :: Method "body_set_space" cls sig => cls -> sig
body_set_space = runMethod @"body_set_space"

body_set_state :: Method "body_set_state" cls sig => cls -> sig
body_set_state = runMethod @"body_set_state"

body_test_motion :: Method "body_test_motion" cls sig => cls -> sig
body_test_motion = runMethod @"body_test_motion"

broadcast :: Method "broadcast" cls sig => cls -> sig
broadcast = runMethod @"broadcast"

build :: Method "build" cls sig => cls -> sig
build = runMethod @"build"

build_box_planes :: Method "build_box_planes" cls sig => cls -> sig
build_box_planes = runMethod @"build_box_planes"

build_capsule_planes ::
                       Method "build_capsule_planes" cls sig => cls -> sig
build_capsule_planes = runMethod @"build_capsule_planes"

build_cylinder_planes ::
                        Method "build_cylinder_planes" cls sig => cls -> sig
build_cylinder_planes = runMethod @"build_cylinder_planes"

bumpmap_to_normalmap ::
                       Method "bumpmap_to_normalmap" cls sig => cls -> sig
bumpmap_to_normalmap = runMethod @"bumpmap_to_normalmap"

call :: Method "call" cls sig => cls -> sig
call = runMethod @"call"

call_deferred :: Method "call_deferred" cls sig => cls -> sig
call_deferred = runMethod @"call_deferred"

call_func :: Method "call_func" cls sig => cls -> sig
call_func = runMethod @"call_func"

call_group :: Method "call_group" cls sig => cls -> sig
call_group = runMethod @"call_group"

call_group_flags :: Method "call_group_flags" cls sig => cls -> sig
call_group_flags = runMethod @"call_group_flags"

call_native :: Method "call_native" cls sig => cls -> sig
call_native = runMethod @"call_native"

callv :: Method "callv" cls sig => cls -> sig
callv = runMethod @"callv"

camera_create :: Method "camera_create" cls sig => cls -> sig
camera_create = runMethod @"camera_create"

camera_set_cull_mask ::
                       Method "camera_set_cull_mask" cls sig => cls -> sig
camera_set_cull_mask = runMethod @"camera_set_cull_mask"

camera_set_environment ::
                         Method "camera_set_environment" cls sig => cls -> sig
camera_set_environment = runMethod @"camera_set_environment"

camera_set_orthogonal ::
                        Method "camera_set_orthogonal" cls sig => cls -> sig
camera_set_orthogonal = runMethod @"camera_set_orthogonal"

camera_set_perspective ::
                         Method "camera_set_perspective" cls sig => cls -> sig
camera_set_perspective = runMethod @"camera_set_perspective"

camera_set_transform ::
                       Method "camera_set_transform" cls sig => cls -> sig
camera_set_transform = runMethod @"camera_set_transform"

camera_set_use_vertical_aspect ::
                                 Method "camera_set_use_vertical_aspect" cls sig => cls -> sig
camera_set_use_vertical_aspect
  = runMethod @"camera_set_use_vertical_aspect"

can_connect_nodes ::
                    Method "can_connect_nodes" cls sig => cls -> sig
can_connect_nodes = runMethod @"can_connect_nodes"

can_draw :: Method "can_draw" cls sig => cls -> sig
can_draw = runMethod @"can_draw"

can_drop_data :: Method "can_drop_data" cls sig => cls -> sig
can_drop_data = runMethod @"can_drop_data"

can_drop_data_fw :: Method "can_drop_data_fw" cls sig => cls -> sig
can_drop_data_fw = runMethod @"can_drop_data_fw"

can_fold :: Method "can_fold" cls sig => cls -> sig
can_fold = runMethod @"can_fold"

can_handle :: Method "can_handle" cls sig => cls -> sig
can_handle = runMethod @"can_handle"

can_instance :: Method "can_instance" cls sig => cls -> sig
can_instance = runMethod @"can_instance"

can_process :: Method "can_process" cls sig => cls -> sig
can_process = runMethod @"can_process"

can_translate_messages ::
                         Method "can_translate_messages" cls sig => cls -> sig
can_translate_messages = runMethod @"can_translate_messages"

can_use_threads :: Method "can_use_threads" cls sig => cls -> sig
can_use_threads = runMethod @"can_use_threads"

cancel_request :: Method "cancel_request" cls sig => cls -> sig
cancel_request = runMethod @"cancel_request"

canvas_create :: Method "canvas_create" cls sig => cls -> sig
canvas_create = runMethod @"canvas_create"

canvas_item_add_circle ::
                         Method "canvas_item_add_circle" cls sig => cls -> sig
canvas_item_add_circle = runMethod @"canvas_item_add_circle"

canvas_item_add_clip_ignore ::
                              Method "canvas_item_add_clip_ignore" cls sig => cls -> sig
canvas_item_add_clip_ignore
  = runMethod @"canvas_item_add_clip_ignore"

canvas_item_add_line ::
                       Method "canvas_item_add_line" cls sig => cls -> sig
canvas_item_add_line = runMethod @"canvas_item_add_line"

canvas_item_add_mesh ::
                       Method "canvas_item_add_mesh" cls sig => cls -> sig
canvas_item_add_mesh = runMethod @"canvas_item_add_mesh"

canvas_item_add_multimesh ::
                            Method "canvas_item_add_multimesh" cls sig => cls -> sig
canvas_item_add_multimesh = runMethod @"canvas_item_add_multimesh"

canvas_item_add_nine_patch ::
                             Method "canvas_item_add_nine_patch" cls sig => cls -> sig
canvas_item_add_nine_patch
  = runMethod @"canvas_item_add_nine_patch"

canvas_item_add_particles ::
                            Method "canvas_item_add_particles" cls sig => cls -> sig
canvas_item_add_particles = runMethod @"canvas_item_add_particles"

canvas_item_add_polygon ::
                          Method "canvas_item_add_polygon" cls sig => cls -> sig
canvas_item_add_polygon = runMethod @"canvas_item_add_polygon"

canvas_item_add_polyline ::
                           Method "canvas_item_add_polyline" cls sig => cls -> sig
canvas_item_add_polyline = runMethod @"canvas_item_add_polyline"

canvas_item_add_primitive ::
                            Method "canvas_item_add_primitive" cls sig => cls -> sig
canvas_item_add_primitive = runMethod @"canvas_item_add_primitive"

canvas_item_add_rect ::
                       Method "canvas_item_add_rect" cls sig => cls -> sig
canvas_item_add_rect = runMethod @"canvas_item_add_rect"

canvas_item_add_set_transform ::
                                Method "canvas_item_add_set_transform" cls sig => cls -> sig
canvas_item_add_set_transform
  = runMethod @"canvas_item_add_set_transform"

canvas_item_add_texture_rect ::
                               Method "canvas_item_add_texture_rect" cls sig => cls -> sig
canvas_item_add_texture_rect
  = runMethod @"canvas_item_add_texture_rect"

canvas_item_add_texture_rect_region ::
                                      Method "canvas_item_add_texture_rect_region" cls sig =>
                                      cls -> sig
canvas_item_add_texture_rect_region
  = runMethod @"canvas_item_add_texture_rect_region"

canvas_item_add_triangle_array ::
                                 Method "canvas_item_add_triangle_array" cls sig => cls -> sig
canvas_item_add_triangle_array
  = runMethod @"canvas_item_add_triangle_array"

canvas_item_clear ::
                    Method "canvas_item_clear" cls sig => cls -> sig
canvas_item_clear = runMethod @"canvas_item_clear"

canvas_item_create ::
                     Method "canvas_item_create" cls sig => cls -> sig
canvas_item_create = runMethod @"canvas_item_create"

canvas_item_set_clip ::
                       Method "canvas_item_set_clip" cls sig => cls -> sig
canvas_item_set_clip = runMethod @"canvas_item_set_clip"

canvas_item_set_copy_to_backbuffer ::
                                     Method "canvas_item_set_copy_to_backbuffer" cls sig =>
                                     cls -> sig
canvas_item_set_copy_to_backbuffer
  = runMethod @"canvas_item_set_copy_to_backbuffer"

canvas_item_set_custom_rect ::
                              Method "canvas_item_set_custom_rect" cls sig => cls -> sig
canvas_item_set_custom_rect
  = runMethod @"canvas_item_set_custom_rect"

canvas_item_set_distance_field_mode ::
                                      Method "canvas_item_set_distance_field_mode" cls sig =>
                                      cls -> sig
canvas_item_set_distance_field_mode
  = runMethod @"canvas_item_set_distance_field_mode"

canvas_item_set_draw_behind_parent ::
                                     Method "canvas_item_set_draw_behind_parent" cls sig =>
                                     cls -> sig
canvas_item_set_draw_behind_parent
  = runMethod @"canvas_item_set_draw_behind_parent"

canvas_item_set_draw_index ::
                             Method "canvas_item_set_draw_index" cls sig => cls -> sig
canvas_item_set_draw_index
  = runMethod @"canvas_item_set_draw_index"

canvas_item_set_light_mask ::
                             Method "canvas_item_set_light_mask" cls sig => cls -> sig
canvas_item_set_light_mask
  = runMethod @"canvas_item_set_light_mask"

canvas_item_set_material ::
                           Method "canvas_item_set_material" cls sig => cls -> sig
canvas_item_set_material = runMethod @"canvas_item_set_material"

canvas_item_set_modulate ::
                           Method "canvas_item_set_modulate" cls sig => cls -> sig
canvas_item_set_modulate = runMethod @"canvas_item_set_modulate"

canvas_item_set_parent ::
                         Method "canvas_item_set_parent" cls sig => cls -> sig
canvas_item_set_parent = runMethod @"canvas_item_set_parent"

canvas_item_set_self_modulate ::
                                Method "canvas_item_set_self_modulate" cls sig => cls -> sig
canvas_item_set_self_modulate
  = runMethod @"canvas_item_set_self_modulate"

canvas_item_set_sort_children_by_y ::
                                     Method "canvas_item_set_sort_children_by_y" cls sig =>
                                     cls -> sig
canvas_item_set_sort_children_by_y
  = runMethod @"canvas_item_set_sort_children_by_y"

canvas_item_set_transform ::
                            Method "canvas_item_set_transform" cls sig => cls -> sig
canvas_item_set_transform = runMethod @"canvas_item_set_transform"

canvas_item_set_use_parent_material ::
                                      Method "canvas_item_set_use_parent_material" cls sig =>
                                      cls -> sig
canvas_item_set_use_parent_material
  = runMethod @"canvas_item_set_use_parent_material"

canvas_item_set_visible ::
                          Method "canvas_item_set_visible" cls sig => cls -> sig
canvas_item_set_visible = runMethod @"canvas_item_set_visible"

canvas_item_set_z_as_relative_to_parent ::
                                          Method "canvas_item_set_z_as_relative_to_parent" cls
                                            sig =>
                                          cls -> sig
canvas_item_set_z_as_relative_to_parent
  = runMethod @"canvas_item_set_z_as_relative_to_parent"

canvas_item_set_z_index ::
                          Method "canvas_item_set_z_index" cls sig => cls -> sig
canvas_item_set_z_index = runMethod @"canvas_item_set_z_index"

canvas_light_attach_to_canvas ::
                                Method "canvas_light_attach_to_canvas" cls sig => cls -> sig
canvas_light_attach_to_canvas
  = runMethod @"canvas_light_attach_to_canvas"

canvas_light_create ::
                      Method "canvas_light_create" cls sig => cls -> sig
canvas_light_create = runMethod @"canvas_light_create"

canvas_light_occluder_attach_to_canvas ::
                                         Method "canvas_light_occluder_attach_to_canvas" cls sig =>
                                         cls -> sig
canvas_light_occluder_attach_to_canvas
  = runMethod @"canvas_light_occluder_attach_to_canvas"

canvas_light_occluder_create ::
                               Method "canvas_light_occluder_create" cls sig => cls -> sig
canvas_light_occluder_create
  = runMethod @"canvas_light_occluder_create"

canvas_light_occluder_set_enabled ::
                                    Method "canvas_light_occluder_set_enabled" cls sig => cls -> sig
canvas_light_occluder_set_enabled
  = runMethod @"canvas_light_occluder_set_enabled"

canvas_light_occluder_set_light_mask ::
                                       Method "canvas_light_occluder_set_light_mask" cls sig =>
                                       cls -> sig
canvas_light_occluder_set_light_mask
  = runMethod @"canvas_light_occluder_set_light_mask"

canvas_light_occluder_set_polygon ::
                                    Method "canvas_light_occluder_set_polygon" cls sig => cls -> sig
canvas_light_occluder_set_polygon
  = runMethod @"canvas_light_occluder_set_polygon"

canvas_light_occluder_set_transform ::
                                      Method "canvas_light_occluder_set_transform" cls sig =>
                                      cls -> sig
canvas_light_occluder_set_transform
  = runMethod @"canvas_light_occluder_set_transform"

canvas_light_set_color ::
                         Method "canvas_light_set_color" cls sig => cls -> sig
canvas_light_set_color = runMethod @"canvas_light_set_color"

canvas_light_set_enabled ::
                           Method "canvas_light_set_enabled" cls sig => cls -> sig
canvas_light_set_enabled = runMethod @"canvas_light_set_enabled"

canvas_light_set_energy ::
                          Method "canvas_light_set_energy" cls sig => cls -> sig
canvas_light_set_energy = runMethod @"canvas_light_set_energy"

canvas_light_set_height ::
                          Method "canvas_light_set_height" cls sig => cls -> sig
canvas_light_set_height = runMethod @"canvas_light_set_height"

canvas_light_set_item_cull_mask ::
                                  Method "canvas_light_set_item_cull_mask" cls sig => cls -> sig
canvas_light_set_item_cull_mask
  = runMethod @"canvas_light_set_item_cull_mask"

canvas_light_set_item_shadow_cull_mask ::
                                         Method "canvas_light_set_item_shadow_cull_mask" cls sig =>
                                         cls -> sig
canvas_light_set_item_shadow_cull_mask
  = runMethod @"canvas_light_set_item_shadow_cull_mask"

canvas_light_set_layer_range ::
                               Method "canvas_light_set_layer_range" cls sig => cls -> sig
canvas_light_set_layer_range
  = runMethod @"canvas_light_set_layer_range"

canvas_light_set_mode ::
                        Method "canvas_light_set_mode" cls sig => cls -> sig
canvas_light_set_mode = runMethod @"canvas_light_set_mode"

canvas_light_set_scale ::
                         Method "canvas_light_set_scale" cls sig => cls -> sig
canvas_light_set_scale = runMethod @"canvas_light_set_scale"

canvas_light_set_shadow_buffer_size ::
                                      Method "canvas_light_set_shadow_buffer_size" cls sig =>
                                      cls -> sig
canvas_light_set_shadow_buffer_size
  = runMethod @"canvas_light_set_shadow_buffer_size"

canvas_light_set_shadow_color ::
                                Method "canvas_light_set_shadow_color" cls sig => cls -> sig
canvas_light_set_shadow_color
  = runMethod @"canvas_light_set_shadow_color"

canvas_light_set_shadow_enabled ::
                                  Method "canvas_light_set_shadow_enabled" cls sig => cls -> sig
canvas_light_set_shadow_enabled
  = runMethod @"canvas_light_set_shadow_enabled"

canvas_light_set_shadow_filter ::
                                 Method "canvas_light_set_shadow_filter" cls sig => cls -> sig
canvas_light_set_shadow_filter
  = runMethod @"canvas_light_set_shadow_filter"

canvas_light_set_shadow_gradient_length ::
                                          Method "canvas_light_set_shadow_gradient_length" cls
                                            sig =>
                                          cls -> sig
canvas_light_set_shadow_gradient_length
  = runMethod @"canvas_light_set_shadow_gradient_length"

canvas_light_set_shadow_smooth ::
                                 Method "canvas_light_set_shadow_smooth" cls sig => cls -> sig
canvas_light_set_shadow_smooth
  = runMethod @"canvas_light_set_shadow_smooth"

canvas_light_set_texture ::
                           Method "canvas_light_set_texture" cls sig => cls -> sig
canvas_light_set_texture = runMethod @"canvas_light_set_texture"

canvas_light_set_texture_offset ::
                                  Method "canvas_light_set_texture_offset" cls sig => cls -> sig
canvas_light_set_texture_offset
  = runMethod @"canvas_light_set_texture_offset"

canvas_light_set_transform ::
                             Method "canvas_light_set_transform" cls sig => cls -> sig
canvas_light_set_transform
  = runMethod @"canvas_light_set_transform"

canvas_light_set_z_range ::
                           Method "canvas_light_set_z_range" cls sig => cls -> sig
canvas_light_set_z_range = runMethod @"canvas_light_set_z_range"

canvas_occluder_polygon_create ::
                                 Method "canvas_occluder_polygon_create" cls sig => cls -> sig
canvas_occluder_polygon_create
  = runMethod @"canvas_occluder_polygon_create"

canvas_occluder_polygon_set_cull_mode ::
                                        Method "canvas_occluder_polygon_set_cull_mode" cls sig =>
                                        cls -> sig
canvas_occluder_polygon_set_cull_mode
  = runMethod @"canvas_occluder_polygon_set_cull_mode"

canvas_occluder_polygon_set_shape ::
                                    Method "canvas_occluder_polygon_set_shape" cls sig => cls -> sig
canvas_occluder_polygon_set_shape
  = runMethod @"canvas_occluder_polygon_set_shape"

canvas_occluder_polygon_set_shape_as_lines ::
                                             Method "canvas_occluder_polygon_set_shape_as_lines" cls
                                               sig =>
                                             cls -> sig
canvas_occluder_polygon_set_shape_as_lines
  = runMethod @"canvas_occluder_polygon_set_shape_as_lines"

canvas_set_item_mirroring ::
                            Method "canvas_set_item_mirroring" cls sig => cls -> sig
canvas_set_item_mirroring = runMethod @"canvas_set_item_mirroring"

canvas_set_modulate ::
                      Method "canvas_set_modulate" cls sig => cls -> sig
canvas_set_modulate = runMethod @"canvas_set_modulate"

capsule_shape_create ::
                       Method "capsule_shape_create" cls sig => cls -> sig
capsule_shape_create = runMethod @"capsule_shape_create"

capture_aabb :: Method "capture_aabb" cls sig => cls -> sig
capture_aabb = runMethod @"capture_aabb"

capture_get_device ::
                     Method "capture_get_device" cls sig => cls -> sig
capture_get_device = runMethod @"capture_get_device"

capture_get_device_list ::
                          Method "capture_get_device_list" cls sig => cls -> sig
capture_get_device_list = runMethod @"capture_get_device_list"

capture_rect :: Method "capture_rect" cls sig => cls -> sig
capture_rect = runMethod @"capture_rect"

capture_set_device ::
                     Method "capture_set_device" cls sig => cls -> sig
capture_set_device = runMethod @"capture_set_device"

cast_motion :: Method "cast_motion" cls sig => cls -> sig
cast_motion = runMethod @"cast_motion"

center_geometry :: Method "center_geometry" cls sig => cls -> sig
center_geometry = runMethod @"center_geometry"

center_on_hmd :: Method "center_on_hmd" cls sig => cls -> sig
center_on_hmd = runMethod @"center_on_hmd"

center_window :: Method "center_window" cls sig => cls -> sig
center_window = runMethod @"center_window"

change_dir :: Method "change_dir" cls sig => cls -> sig
change_dir = runMethod @"change_dir"

change_scene :: Method "change_scene" cls sig => cls -> sig
change_scene = runMethod @"change_scene"

change_scene_to :: Method "change_scene_to" cls sig => cls -> sig
change_scene_to = runMethod @"change_scene_to"

check_for_invalidation ::
                         Method "check_for_invalidation" cls sig => cls -> sig
check_for_invalidation = runMethod @"check_for_invalidation"

circle_shape_create ::
                      Method "circle_shape_create" cls sig => cls -> sig
circle_shape_create = runMethod @"circle_shape_create"

class_exists :: Method "class_exists" cls sig => cls -> sig
class_exists = runMethod @"class_exists"

class_get_category ::
                     Method "class_get_category" cls sig => cls -> sig
class_get_category = runMethod @"class_get_category"

class_get_integer_constant ::
                             Method "class_get_integer_constant" cls sig => cls -> sig
class_get_integer_constant
  = runMethod @"class_get_integer_constant"

class_get_integer_constant_list ::
                                  Method "class_get_integer_constant_list" cls sig => cls -> sig
class_get_integer_constant_list
  = runMethod @"class_get_integer_constant_list"

class_get_method_list ::
                        Method "class_get_method_list" cls sig => cls -> sig
class_get_method_list = runMethod @"class_get_method_list"

class_get_property ::
                     Method "class_get_property" cls sig => cls -> sig
class_get_property = runMethod @"class_get_property"

class_get_property_list ::
                          Method "class_get_property_list" cls sig => cls -> sig
class_get_property_list = runMethod @"class_get_property_list"

class_get_signal :: Method "class_get_signal" cls sig => cls -> sig
class_get_signal = runMethod @"class_get_signal"

class_get_signal_list ::
                        Method "class_get_signal_list" cls sig => cls -> sig
class_get_signal_list = runMethod @"class_get_signal_list"

class_has_integer_constant ::
                             Method "class_has_integer_constant" cls sig => cls -> sig
class_has_integer_constant
  = runMethod @"class_has_integer_constant"

class_has_method :: Method "class_has_method" cls sig => cls -> sig
class_has_method = runMethod @"class_has_method"

class_has_signal :: Method "class_has_signal" cls sig => cls -> sig
class_has_signal = runMethod @"class_has_signal"

class_set_property ::
                     Method "class_set_property" cls sig => cls -> sig
class_set_property = runMethod @"class_set_property"

clean_dupes :: Method "clean_dupes" cls sig => cls -> sig
clean_dupes = runMethod @"clean_dupes"

clear :: Method "clear" cls sig => cls -> sig
clear = runMethod @"clear"

clear_all :: Method "clear_all" cls sig => cls -> sig
clear_all = runMethod @"clear_all"

clear_all_slots :: Method "clear_all_slots" cls sig => cls -> sig
clear_all_slots = runMethod @"clear_all_slots"

clear_baked_meshes ::
                     Method "clear_baked_meshes" cls sig => cls -> sig
clear_baked_meshes = runMethod @"clear_baked_meshes"

clear_blend_shapes ::
                     Method "clear_blend_shapes" cls sig => cls -> sig
clear_blend_shapes = runMethod @"clear_blend_shapes"

clear_bones :: Method "clear_bones" cls sig => cls -> sig
clear_bones = runMethod @"clear_bones"

clear_cache :: Method "clear_cache" cls sig => cls -> sig
clear_cache = runMethod @"clear_cache"

clear_caches :: Method "clear_caches" cls sig => cls -> sig
clear_caches = runMethod @"clear_caches"

clear_color :: Method "clear_color" cls sig => cls -> sig
clear_color = runMethod @"clear_color"

clear_colors :: Method "clear_colors" cls sig => cls -> sig
clear_colors = runMethod @"clear_colors"

clear_connections ::
                    Method "clear_connections" cls sig => cls -> sig
clear_connections = runMethod @"clear_connections"

clear_constant :: Method "clear_constant" cls sig => cls -> sig
clear_constant = runMethod @"clear_constant"

clear_current :: Method "clear_current" cls sig => cls -> sig
clear_current = runMethod @"clear_current"

clear_custom_bg_color ::
                        Method "clear_custom_bg_color" cls sig => cls -> sig
clear_custom_bg_color = runMethod @"clear_custom_bg_color"

clear_custom_color ::
                     Method "clear_custom_color" cls sig => cls -> sig
clear_custom_color = runMethod @"clear_custom_color"

clear_devices :: Method "clear_devices" cls sig => cls -> sig
clear_devices = runMethod @"clear_devices"

clear_exceptions :: Method "clear_exceptions" cls sig => cls -> sig
clear_exceptions = runMethod @"clear_exceptions"

clear_excluded_objects ::
                         Method "clear_excluded_objects" cls sig => cls -> sig
clear_excluded_objects = runMethod @"clear_excluded_objects"

clear_filters :: Method "clear_filters" cls sig => cls -> sig
clear_filters = runMethod @"clear_filters"

clear_font :: Method "clear_font" cls sig => cls -> sig
clear_font = runMethod @"clear_font"

clear_history :: Method "clear_history" cls sig => cls -> sig
clear_history = runMethod @"clear_history"

clear_icon :: Method "clear_icon" cls sig => cls -> sig
clear_icon = runMethod @"clear_icon"

clear_mipmaps :: Method "clear_mipmaps" cls sig => cls -> sig
clear_mipmaps = runMethod @"clear_mipmaps"

clear_outlines :: Method "clear_outlines" cls sig => cls -> sig
clear_outlines = runMethod @"clear_outlines"

clear_points :: Method "clear_points" cls sig => cls -> sig
clear_points = runMethod @"clear_points"

clear_polygons :: Method "clear_polygons" cls sig => cls -> sig
clear_polygons = runMethod @"clear_polygons"

clear_queue :: Method "clear_queue" cls sig => cls -> sig
clear_queue = runMethod @"clear_queue"

clear_slot :: Method "clear_slot" cls sig => cls -> sig
clear_slot = runMethod @"clear_slot"

clear_stylebox :: Method "clear_stylebox" cls sig => cls -> sig
clear_stylebox = runMethod @"clear_stylebox"

clear_undo_history ::
                     Method "clear_undo_history" cls sig => cls -> sig
clear_undo_history = runMethod @"clear_undo_history"

clear_users :: Method "clear_users" cls sig => cls -> sig
clear_users = runMethod @"clear_users"

clip_polygon :: Method "clip_polygon" cls sig => cls -> sig
clip_polygon = runMethod @"clip_polygon"

close :: Method "close" cls sig => cls -> sig
close = runMethod @"close"

close_connection :: Method "close_connection" cls sig => cls -> sig
close_connection = runMethod @"close_connection"

close_midi_inputs ::
                    Method "close_midi_inputs" cls sig => cls -> sig
close_midi_inputs = runMethod @"close_midi_inputs"

collide :: Method "collide" cls sig => cls -> sig
collide = runMethod @"collide"

collide_and_get_contacts ::
                           Method "collide_and_get_contacts" cls sig => cls -> sig
collide_and_get_contacts = runMethod @"collide_and_get_contacts"

collide_shape :: Method "collide_shape" cls sig => cls -> sig
collide_shape = runMethod @"collide_shape"

collide_with_motion ::
                      Method "collide_with_motion" cls sig => cls -> sig
collide_with_motion = runMethod @"collide_with_motion"

collide_with_motion_and_get_contacts ::
                                       Method "collide_with_motion_and_get_contacts" cls sig =>
                                       cls -> sig
collide_with_motion_and_get_contacts
  = runMethod @"collide_with_motion_and_get_contacts"

commit :: Method "commit" cls sig => cls -> sig
commit = runMethod @"commit"

commit_action :: Method "commit_action" cls sig => cls -> sig
commit_action = runMethod @"commit_action"

commit_handle :: Method "commit_handle" cls sig => cls -> sig
commit_handle = runMethod @"commit_handle"

commit_to_surface ::
                    Method "commit_to_surface" cls sig => cls -> sig
commit_to_surface = runMethod @"commit_to_surface"

compile :: Method "compile" cls sig => cls -> sig
compile = runMethod @"compile"

compress :: Method "compress" cls sig => cls -> sig
compress = runMethod @"compress"

concave_polygon_shape_create ::
                               Method "concave_polygon_shape_create" cls sig => cls -> sig
concave_polygon_shape_create
  = runMethod @"concave_polygon_shape_create"

cone_twist_joint_get_param ::
                             Method "cone_twist_joint_get_param" cls sig => cls -> sig
cone_twist_joint_get_param
  = runMethod @"cone_twist_joint_get_param"

cone_twist_joint_set_param ::
                             Method "cone_twist_joint_set_param" cls sig => cls -> sig
cone_twist_joint_set_param
  = runMethod @"cone_twist_joint_set_param"

config :: Method "config" cls sig => cls -> sig
config = runMethod @"config"

connect :: Method "connect" cls sig => cls -> sig
connect = runMethod @"connect"

connect_node :: Method "connect_node" cls sig => cls -> sig
connect_node = runMethod @"connect_node"

connect_nodes :: Method "connect_nodes" cls sig => cls -> sig
connect_nodes = runMethod @"connect_nodes"

connect_points :: Method "connect_points" cls sig => cls -> sig
connect_points = runMethod @"connect_points"

connect_to_host :: Method "connect_to_host" cls sig => cls -> sig
connect_to_host = runMethod @"connect_to_host"

connect_to_signal ::
                    Method "connect_to_signal" cls sig => cls -> sig
connect_to_signal = runMethod @"connect_to_signal"

connect_to_stream ::
                    Method "connect_to_stream" cls sig => cls -> sig
connect_to_stream = runMethod @"connect_to_stream"

connect_to_url :: Method "connect_to_url" cls sig => cls -> sig
connect_to_url = runMethod @"connect_to_url"

convert :: Method "convert" cls sig => cls -> sig
convert = runMethod @"convert"

convert_from_particles ::
                         Method "convert_from_particles" cls sig => cls -> sig
convert_from_particles = runMethod @"convert_from_particles"

convex_hull_2d :: Method "convex_hull_2d" cls sig => cls -> sig
convex_hull_2d = runMethod @"convex_hull_2d"

convex_polygon_shape_create ::
                              Method "convex_polygon_shape_create" cls sig => cls -> sig
convex_polygon_shape_create
  = runMethod @"convex_polygon_shape_create"

copy :: Method "copy" cls sig => cls -> sig
copy = runMethod @"copy"

copy_default_theme ::
                     Method "copy_default_theme" cls sig => cls -> sig
copy_default_theme = runMethod @"copy_default_theme"

copy_from :: Method "copy_from" cls sig => cls -> sig
copy_from = runMethod @"copy_from"

copy_track :: Method "copy_track" cls sig => cls -> sig
copy_track = runMethod @"copy_track"

create :: Method "create" cls sig => cls -> sig
create = runMethod @"create"

create_action :: Method "create_action" cls sig => cls -> sig
create_action = runMethod @"create_action"

create_client :: Method "create_client" cls sig => cls -> sig
create_client = runMethod @"create_client"

create_convex_collision ::
                          Method "create_convex_collision" cls sig => cls -> sig
create_convex_collision = runMethod @"create_convex_collision"

create_convex_shape ::
                      Method "create_convex_shape" cls sig => cls -> sig
create_convex_shape = runMethod @"create_convex_shape"

create_debug_tangents ::
                        Method "create_debug_tangents" cls sig => cls -> sig
create_debug_tangents = runMethod @"create_debug_tangents"

create_from :: Method "create_from" cls sig => cls -> sig
create_from = runMethod @"create_from"

create_from_data :: Method "create_from_data" cls sig => cls -> sig
create_from_data = runMethod @"create_from_data"

create_from_fnt :: Method "create_from_fnt" cls sig => cls -> sig
create_from_fnt = runMethod @"create_from_fnt"

create_from_image ::
                    Method "create_from_image" cls sig => cls -> sig
create_from_image = runMethod @"create_from_image"

create_from_image_alpha ::
                          Method "create_from_image_alpha" cls sig => cls -> sig
create_from_image_alpha = runMethod @"create_from_image_alpha"

create_from_mesh :: Method "create_from_mesh" cls sig => cls -> sig
create_from_mesh = runMethod @"create_from_mesh"

create_from_surface ::
                      Method "create_from_surface" cls sig => cls -> sig
create_from_surface = runMethod @"create_from_surface"

create_instance :: Method "create_instance" cls sig => cls -> sig
create_instance = runMethod @"create_instance"

create_item :: Method "create_item" cls sig => cls -> sig
create_item = runMethod @"create_item"

create_outline :: Method "create_outline" cls sig => cls -> sig
create_outline = runMethod @"create_outline"

create_server :: Method "create_server" cls sig => cls -> sig
create_server = runMethod @"create_server"

create_shape_owner ::
                     Method "create_shape_owner" cls sig => cls -> sig
create_shape_owner = runMethod @"create_shape_owner"

create_tile :: Method "create_tile" cls sig => cls -> sig
create_tile = runMethod @"create_tile"

create_timer :: Method "create_timer" cls sig => cls -> sig
create_timer = runMethod @"create_timer"

create_trimesh_collision ::
                           Method "create_trimesh_collision" cls sig => cls -> sig
create_trimesh_collision = runMethod @"create_trimesh_collision"

create_trimesh_shape ::
                       Method "create_trimesh_shape" cls sig => cls -> sig
create_trimesh_shape = runMethod @"create_trimesh_shape"

crop :: Method "crop" cls sig => cls -> sig
crop = runMethod @"crop"

current_is_dir :: Method "current_is_dir" cls sig => cls -> sig
current_is_dir = runMethod @"current_is_dir"

cursor_get_blink_enabled ::
                           Method "cursor_get_blink_enabled" cls sig => cls -> sig
cursor_get_blink_enabled = runMethod @"cursor_get_blink_enabled"

cursor_get_blink_speed ::
                         Method "cursor_get_blink_speed" cls sig => cls -> sig
cursor_get_blink_speed = runMethod @"cursor_get_blink_speed"

cursor_get_column ::
                    Method "cursor_get_column" cls sig => cls -> sig
cursor_get_column = runMethod @"cursor_get_column"

cursor_get_line :: Method "cursor_get_line" cls sig => cls -> sig
cursor_get_line = runMethod @"cursor_get_line"

cursor_is_block_mode ::
                       Method "cursor_is_block_mode" cls sig => cls -> sig
cursor_is_block_mode = runMethod @"cursor_is_block_mode"

cursor_set_blink_enabled ::
                           Method "cursor_set_blink_enabled" cls sig => cls -> sig
cursor_set_blink_enabled = runMethod @"cursor_set_blink_enabled"

cursor_set_blink_speed ::
                         Method "cursor_set_blink_speed" cls sig => cls -> sig
cursor_set_blink_speed = runMethod @"cursor_set_blink_speed"

cursor_set_block_mode ::
                        Method "cursor_set_block_mode" cls sig => cls -> sig
cursor_set_block_mode = runMethod @"cursor_set_block_mode"

cursor_set_column ::
                    Method "cursor_set_column" cls sig => cls -> sig
cursor_set_column = runMethod @"cursor_set_column"

cursor_set_line :: Method "cursor_set_line" cls sig => cls -> sig
cursor_set_line = runMethod @"cursor_set_line"

custom_signal_add_argument ::
                             Method "custom_signal_add_argument" cls sig => cls -> sig
custom_signal_add_argument
  = runMethod @"custom_signal_add_argument"

custom_signal_get_argument_count ::
                                   Method "custom_signal_get_argument_count" cls sig => cls -> sig
custom_signal_get_argument_count
  = runMethod @"custom_signal_get_argument_count"

custom_signal_get_argument_name ::
                                  Method "custom_signal_get_argument_name" cls sig => cls -> sig
custom_signal_get_argument_name
  = runMethod @"custom_signal_get_argument_name"

custom_signal_get_argument_type ::
                                  Method "custom_signal_get_argument_type" cls sig => cls -> sig
custom_signal_get_argument_type
  = runMethod @"custom_signal_get_argument_type"

custom_signal_remove_argument ::
                                Method "custom_signal_remove_argument" cls sig => cls -> sig
custom_signal_remove_argument
  = runMethod @"custom_signal_remove_argument"

custom_signal_set_argument_name ::
                                  Method "custom_signal_set_argument_name" cls sig => cls -> sig
custom_signal_set_argument_name
  = runMethod @"custom_signal_set_argument_name"

custom_signal_set_argument_type ::
                                  Method "custom_signal_set_argument_type" cls sig => cls -> sig
custom_signal_set_argument_type
  = runMethod @"custom_signal_set_argument_type"

custom_signal_swap_argument ::
                              Method "custom_signal_swap_argument" cls sig => cls -> sig
custom_signal_swap_argument
  = runMethod @"custom_signal_swap_argument"

cut :: Method "cut" cls sig => cls -> sig
cut = runMethod @"cut"

damped_spring_joint_create ::
                             Method "damped_spring_joint_create" cls sig => cls -> sig
damped_spring_joint_create
  = runMethod @"damped_spring_joint_create"

damped_string_joint_get_param ::
                                Method "damped_string_joint_get_param" cls sig => cls -> sig
damped_string_joint_get_param
  = runMethod @"damped_string_joint_get_param"

damped_string_joint_set_param ::
                                Method "damped_string_joint_set_param" cls sig => cls -> sig
damped_string_joint_set_param
  = runMethod @"damped_string_joint_set_param"

data_connect :: Method "data_connect" cls sig => cls -> sig
data_connect = runMethod @"data_connect"

data_disconnect :: Method "data_disconnect" cls sig => cls -> sig
data_disconnect = runMethod @"data_disconnect"

debug_bake :: Method "debug_bake" cls sig => cls -> sig
debug_bake = runMethod @"debug_bake"

decompress :: Method "decompress" cls sig => cls -> sig
decompress = runMethod @"decompress"

deindex :: Method "deindex" cls sig => cls -> sig
deindex = runMethod @"deindex"

delay_msec :: Method "delay_msec" cls sig => cls -> sig
delay_msec = runMethod @"delay_msec"

delay_usec :: Method "delay_usec" cls sig => cls -> sig
delay_usec = runMethod @"delay_usec"

delete_port_mapping ::
                      Method "delete_port_mapping" cls sig => cls -> sig
delete_port_mapping = runMethod @"delete_port_mapping"

deselect :: Method "deselect" cls sig => cls -> sig
deselect = runMethod @"deselect"

deselect_items :: Method "deselect_items" cls sig => cls -> sig
deselect_items = runMethod @"deselect_items"

detect_alpha :: Method "detect_alpha" cls sig => cls -> sig
detect_alpha = runMethod @"detect_alpha"

dir_exists :: Method "dir_exists" cls sig => cls -> sig
dir_exists = runMethod @"dir_exists"

directional_light_create ::
                           Method "directional_light_create" cls sig => cls -> sig
directional_light_create = runMethod @"directional_light_create"

disconnect :: Method "disconnect" cls sig => cls -> sig
disconnect = runMethod @"disconnect"

disconnect_from_host ::
                       Method "disconnect_from_host" cls sig => cls -> sig
disconnect_from_host = runMethod @"disconnect_from_host"

disconnect_from_stream ::
                         Method "disconnect_from_stream" cls sig => cls -> sig
disconnect_from_stream = runMethod @"disconnect_from_stream"

disconnect_node :: Method "disconnect_node" cls sig => cls -> sig
disconnect_node = runMethod @"disconnect_node"

disconnect_nodes :: Method "disconnect_nodes" cls sig => cls -> sig
disconnect_nodes = runMethod @"disconnect_nodes"

disconnect_peer :: Method "disconnect_peer" cls sig => cls -> sig
disconnect_peer = runMethod @"disconnect_peer"

disconnect_points ::
                    Method "disconnect_points" cls sig => cls -> sig
disconnect_points = runMethod @"disconnect_points"

discover :: Method "discover" cls sig => cls -> sig
discover = runMethod @"discover"

draw :: Method "draw" cls sig => cls -> sig
draw = runMethod @"draw"

draw_char :: Method "draw_char" cls sig => cls -> sig
draw_char = runMethod @"draw_char"

draw_circle :: Method "draw_circle" cls sig => cls -> sig
draw_circle = runMethod @"draw_circle"

draw_colored_polygon ::
                       Method "draw_colored_polygon" cls sig => cls -> sig
draw_colored_polygon = runMethod @"draw_colored_polygon"

draw_line :: Method "draw_line" cls sig => cls -> sig
draw_line = runMethod @"draw_line"

draw_mesh :: Method "draw_mesh" cls sig => cls -> sig
draw_mesh = runMethod @"draw_mesh"

draw_multiline :: Method "draw_multiline" cls sig => cls -> sig
draw_multiline = runMethod @"draw_multiline"

draw_multiline_colors ::
                        Method "draw_multiline_colors" cls sig => cls -> sig
draw_multiline_colors = runMethod @"draw_multiline_colors"

draw_multimesh :: Method "draw_multimesh" cls sig => cls -> sig
draw_multimesh = runMethod @"draw_multimesh"

draw_polygon :: Method "draw_polygon" cls sig => cls -> sig
draw_polygon = runMethod @"draw_polygon"

draw_polyline :: Method "draw_polyline" cls sig => cls -> sig
draw_polyline = runMethod @"draw_polyline"

draw_polyline_colors ::
                       Method "draw_polyline_colors" cls sig => cls -> sig
draw_polyline_colors = runMethod @"draw_polyline_colors"

draw_primitive :: Method "draw_primitive" cls sig => cls -> sig
draw_primitive = runMethod @"draw_primitive"

draw_rect :: Method "draw_rect" cls sig => cls -> sig
draw_rect = runMethod @"draw_rect"

draw_rect_region :: Method "draw_rect_region" cls sig => cls -> sig
draw_rect_region = runMethod @"draw_rect_region"

draw_set_transform ::
                     Method "draw_set_transform" cls sig => cls -> sig
draw_set_transform = runMethod @"draw_set_transform"

draw_set_transform_matrix ::
                            Method "draw_set_transform_matrix" cls sig => cls -> sig
draw_set_transform_matrix = runMethod @"draw_set_transform_matrix"

draw_string :: Method "draw_string" cls sig => cls -> sig
draw_string = runMethod @"draw_string"

draw_style_box :: Method "draw_style_box" cls sig => cls -> sig
draw_style_box = runMethod @"draw_style_box"

draw_texture :: Method "draw_texture" cls sig => cls -> sig
draw_texture = runMethod @"draw_texture"

draw_texture_rect ::
                    Method "draw_texture_rect" cls sig => cls -> sig
draw_texture_rect = runMethod @"draw_texture_rect"

draw_texture_rect_region ::
                           Method "draw_texture_rect_region" cls sig => cls -> sig
draw_texture_rect_region = runMethod @"draw_texture_rect_region"

drop_data :: Method "drop_data" cls sig => cls -> sig
drop_data = runMethod @"drop_data"

drop_data_fw :: Method "drop_data_fw" cls sig => cls -> sig
drop_data_fw = runMethod @"drop_data_fw"

dump_memory_to_file ::
                      Method "dump_memory_to_file" cls sig => cls -> sig
dump_memory_to_file = runMethod @"dump_memory_to_file"

dump_resources_to_file ::
                         Method "dump_resources_to_file" cls sig => cls -> sig
dump_resources_to_file = runMethod @"dump_resources_to_file"

duplicate :: Method "duplicate" cls sig => cls -> sig
duplicate = runMethod @"duplicate"

edit :: Method "edit" cls sig => cls -> sig
edit = runMethod @"edit"

edit_resource :: Method "edit_resource" cls sig => cls -> sig
edit_resource = runMethod @"edit_resource"

emit_signal :: Method "emit_signal" cls sig => cls -> sig
emit_signal = runMethod @"emit_signal"

end :: Method "end" cls sig => cls -> sig
end = runMethod @"end"

ensure_current_is_visible ::
                            Method "ensure_current_is_visible" cls sig => cls -> sig
ensure_current_is_visible = runMethod @"ensure_current_is_visible"

ensure_cursor_is_visible ::
                           Method "ensure_cursor_is_visible" cls sig => cls -> sig
ensure_cursor_is_visible = runMethod @"ensure_cursor_is_visible"

ensure_tab_visible ::
                     Method "ensure_tab_visible" cls sig => cls -> sig
ensure_tab_visible = runMethod @"ensure_tab_visible"

environment_create ::
                     Method "environment_create" cls sig => cls -> sig
environment_create = runMethod @"environment_create"

environment_set_adjustment ::
                             Method "environment_set_adjustment" cls sig => cls -> sig
environment_set_adjustment
  = runMethod @"environment_set_adjustment"

environment_set_ambient_light ::
                                Method "environment_set_ambient_light" cls sig => cls -> sig
environment_set_ambient_light
  = runMethod @"environment_set_ambient_light"

environment_set_background ::
                             Method "environment_set_background" cls sig => cls -> sig
environment_set_background
  = runMethod @"environment_set_background"

environment_set_bg_color ::
                           Method "environment_set_bg_color" cls sig => cls -> sig
environment_set_bg_color = runMethod @"environment_set_bg_color"

environment_set_bg_energy ::
                            Method "environment_set_bg_energy" cls sig => cls -> sig
environment_set_bg_energy = runMethod @"environment_set_bg_energy"

environment_set_canvas_max_layer ::
                                   Method "environment_set_canvas_max_layer" cls sig => cls -> sig
environment_set_canvas_max_layer
  = runMethod @"environment_set_canvas_max_layer"

environment_set_dof_blur_far ::
                               Method "environment_set_dof_blur_far" cls sig => cls -> sig
environment_set_dof_blur_far
  = runMethod @"environment_set_dof_blur_far"

environment_set_dof_blur_near ::
                                Method "environment_set_dof_blur_near" cls sig => cls -> sig
environment_set_dof_blur_near
  = runMethod @"environment_set_dof_blur_near"

environment_set_fog ::
                      Method "environment_set_fog" cls sig => cls -> sig
environment_set_fog = runMethod @"environment_set_fog"

environment_set_fog_depth ::
                            Method "environment_set_fog_depth" cls sig => cls -> sig
environment_set_fog_depth = runMethod @"environment_set_fog_depth"

environment_set_fog_height ::
                             Method "environment_set_fog_height" cls sig => cls -> sig
environment_set_fog_height
  = runMethod @"environment_set_fog_height"

environment_set_glow ::
                       Method "environment_set_glow" cls sig => cls -> sig
environment_set_glow = runMethod @"environment_set_glow"

environment_set_sky ::
                      Method "environment_set_sky" cls sig => cls -> sig
environment_set_sky = runMethod @"environment_set_sky"

environment_set_sky_custom_fov ::
                                 Method "environment_set_sky_custom_fov" cls sig => cls -> sig
environment_set_sky_custom_fov
  = runMethod @"environment_set_sky_custom_fov"

environment_set_ssao ::
                       Method "environment_set_ssao" cls sig => cls -> sig
environment_set_ssao = runMethod @"environment_set_ssao"

environment_set_ssr ::
                      Method "environment_set_ssr" cls sig => cls -> sig
environment_set_ssr = runMethod @"environment_set_ssr"

environment_set_tonemap ::
                          Method "environment_set_tonemap" cls sig => cls -> sig
environment_set_tonemap = runMethod @"environment_set_tonemap"

eof_reached :: Method "eof_reached" cls sig => cls -> sig
eof_reached = runMethod @"eof_reached"

erase :: Method "erase" cls sig => cls -> sig
erase = runMethod @"erase"

erase_action :: Method "erase_action" cls sig => cls -> sig
erase_action = runMethod @"erase_action"

erase_bone :: Method "erase_bone" cls sig => cls -> sig
erase_bone = runMethod @"erase_bone"

erase_button :: Method "erase_button" cls sig => cls -> sig
erase_button = runMethod @"erase_button"

erase_message :: Method "erase_message" cls sig => cls -> sig
erase_message = runMethod @"erase_message"

erase_resolve_item ::
                     Method "erase_resolve_item" cls sig => cls -> sig
erase_resolve_item = runMethod @"erase_resolve_item"

erase_section :: Method "erase_section" cls sig => cls -> sig
erase_section = runMethod @"erase_section"

eval :: Method "eval" cls sig => cls -> sig
eval = runMethod @"eval"

event_is_action :: Method "event_is_action" cls sig => cls -> sig
event_is_action = runMethod @"event_is_action"

execute :: Method "execute" cls sig => cls -> sig
execute = runMethod @"execute"

exists :: Method "exists" cls sig => cls -> sig
exists = runMethod @"exists"

expand_x2_hq2x :: Method "expand_x2_hq2x" cls sig => cls -> sig
expand_x2_hq2x = runMethod @"expand_x2_hq2x"

file_exists :: Method "file_exists" cls sig => cls -> sig
file_exists = runMethod @"file_exists"

fill :: Method "fill" cls sig => cls -> sig
fill = runMethod @"fill"

find_animation :: Method "find_animation" cls sig => cls -> sig
find_animation = runMethod @"find_animation"

find_bone :: Method "find_bone" cls sig => cls -> sig
find_bone = runMethod @"find_bone"

find_dir_index :: Method "find_dir_index" cls sig => cls -> sig
find_dir_index = runMethod @"find_dir_index"

find_file_index :: Method "find_file_index" cls sig => cls -> sig
find_file_index = runMethod @"find_file_index"

find_interface :: Method "find_interface" cls sig => cls -> sig
find_interface = runMethod @"find_interface"

find_item_by_name ::
                    Method "find_item_by_name" cls sig => cls -> sig
find_item_by_name = runMethod @"find_item_by_name"

find_node :: Method "find_node" cls sig => cls -> sig
find_node = runMethod @"find_node"

find_parent :: Method "find_parent" cls sig => cls -> sig
find_parent = runMethod @"find_parent"

find_path :: Method "find_path" cls sig => cls -> sig
find_path = runMethod @"find_path"

find_scancode_from_string ::
                            Method "find_scancode_from_string" cls sig => cls -> sig
find_scancode_from_string = runMethod @"find_scancode_from_string"

find_tile_by_name ::
                    Method "find_tile_by_name" cls sig => cls -> sig
find_tile_by_name = runMethod @"find_tile_by_name"

find_track :: Method "find_track" cls sig => cls -> sig
find_track = runMethod @"find_track"

find_world :: Method "find_world" cls sig => cls -> sig
find_world = runMethod @"find_world"

find_world_2d :: Method "find_world_2d" cls sig => cls -> sig
find_world_2d = runMethod @"find_world_2d"

finish :: Method "finish" cls sig => cls -> sig
finish = runMethod @"finish"

fit_child_in_rect ::
                    Method "fit_child_in_rect" cls sig => cls -> sig
fit_child_in_rect = runMethod @"fit_child_in_rect"

fix_alpha_edges :: Method "fix_alpha_edges" cls sig => cls -> sig
fix_alpha_edges = runMethod @"fix_alpha_edges"

fix_invalid_tiles ::
                    Method "fix_invalid_tiles" cls sig => cls -> sig
fix_invalid_tiles = runMethod @"fix_invalid_tiles"

flip_x :: Method "flip_x" cls sig => cls -> sig
flip_x = runMethod @"flip_x"

flip_y :: Method "flip_y" cls sig => cls -> sig
flip_y = runMethod @"flip_y"

flush :: Method "flush" cls sig => cls -> sig
flush = runMethod @"flush"

fold_all_lines :: Method "fold_all_lines" cls sig => cls -> sig
fold_all_lines = runMethod @"fold_all_lines"

fold_line :: Method "fold_line" cls sig => cls -> sig
fold_line = runMethod @"fold_line"

follow_method :: Method "follow_method" cls sig => cls -> sig
follow_method = runMethod @"follow_method"

follow_property :: Method "follow_property" cls sig => cls -> sig
follow_property = runMethod @"follow_property"

force_drag :: Method "force_drag" cls sig => cls -> sig
force_drag = runMethod @"force_drag"

force_draw :: Method "force_draw" cls sig => cls -> sig
force_draw = runMethod @"force_draw"

force_raycast_update ::
                       Method "force_raycast_update" cls sig => cls -> sig
force_raycast_update = runMethod @"force_raycast_update"

force_sync :: Method "force_sync" cls sig => cls -> sig
force_sync = runMethod @"force_sync"

force_update_scroll ::
                      Method "force_update_scroll" cls sig => cls -> sig
force_update_scroll = runMethod @"force_update_scroll"

force_update_transform ::
                         Method "force_update_transform" cls sig => cls -> sig
force_update_transform = runMethod @"force_update_transform"

forward_canvas_draw_over_viewport ::
                                    Method "forward_canvas_draw_over_viewport" cls sig => cls -> sig
forward_canvas_draw_over_viewport
  = runMethod @"forward_canvas_draw_over_viewport"

forward_canvas_force_draw_over_viewport ::
                                          Method "forward_canvas_force_draw_over_viewport" cls
                                            sig =>
                                          cls -> sig
forward_canvas_force_draw_over_viewport
  = runMethod @"forward_canvas_force_draw_over_viewport"

forward_canvas_gui_input ::
                           Method "forward_canvas_gui_input" cls sig => cls -> sig
forward_canvas_gui_input = runMethod @"forward_canvas_gui_input"

forward_spatial_gui_input ::
                            Method "forward_spatial_gui_input" cls sig => cls -> sig
forward_spatial_gui_input = runMethod @"forward_spatial_gui_input"

free :: Method "free" cls sig => cls -> sig
free = runMethod @"free"

free_rid :: Method "free_rid" cls sig => cls -> sig
free_rid = runMethod @"free_rid"

generate :: Method "generate" cls sig => cls -> sig
generate = runMethod @"generate"

generate_bus_layout ::
                      Method "generate_bus_layout" cls sig => cls -> sig
generate_bus_layout = runMethod @"generate_bus_layout"

generate_from_path ::
                     Method "generate_from_path" cls sig => cls -> sig
generate_from_path = runMethod @"generate_from_path"

generate_mipmaps :: Method "generate_mipmaps" cls sig => cls -> sig
generate_mipmaps = runMethod @"generate_mipmaps"

generate_normals :: Method "generate_normals" cls sig => cls -> sig
generate_normals = runMethod @"generate_normals"

generate_tangents ::
                    Method "generate_tangents" cls sig => cls -> sig
generate_tangents = runMethod @"generate_tangents"

generate_triangle_mesh ::
                         Method "generate_triangle_mesh" cls sig => cls -> sig
generate_triangle_mesh = runMethod @"generate_triangle_mesh"

generic_6dof_joint_get_flag ::
                              Method "generic_6dof_joint_get_flag" cls sig => cls -> sig
generic_6dof_joint_get_flag
  = runMethod @"generic_6dof_joint_get_flag"

generic_6dof_joint_get_param ::
                               Method "generic_6dof_joint_get_param" cls sig => cls -> sig
generic_6dof_joint_get_param
  = runMethod @"generic_6dof_joint_get_param"

generic_6dof_joint_set_flag ::
                              Method "generic_6dof_joint_set_flag" cls sig => cls -> sig
generic_6dof_joint_set_flag
  = runMethod @"generic_6dof_joint_set_flag"

generic_6dof_joint_set_param ::
                               Method "generic_6dof_joint_set_param" cls sig => cls -> sig
generic_6dof_joint_set_param
  = runMethod @"generic_6dof_joint_set_param"

get :: Method "get" cls sig => cls -> sig
get = runMethod @"get"

get_16 :: Method "get_16" cls sig => cls -> sig
get_16 = runMethod @"get_16"

get_32 :: Method "get_32" cls sig => cls -> sig
get_32 = runMethod @"get_32"

get_64 :: Method "get_64" cls sig => cls -> sig
get_64 = runMethod @"get_64"

get_8 :: Method "get_8" cls sig => cls -> sig
get_8 = runMethod @"get_8"

get_a :: Method "get_a" cls sig => cls -> sig
get_a = runMethod @"get_a"

get_aa_size :: Method "get_aa_size" cls sig => cls -> sig
get_aa_size = runMethod @"get_aa_size"

get_aabb :: Method "get_aabb" cls sig => cls -> sig
get_aabb = runMethod @"get_aabb"

get_accelerometer ::
                    Method "get_accelerometer" cls sig => cls -> sig
get_accelerometer = runMethod @"get_accelerometer"

get_access :: Method "get_access" cls sig => cls -> sig
get_access = runMethod @"get_access"

get_action :: Method "get_action" cls sig => cls -> sig
get_action = runMethod @"get_action"

get_action_list :: Method "get_action_list" cls sig => cls -> sig
get_action_list = runMethod @"get_action_list"

get_action_mode :: Method "get_action_mode" cls sig => cls -> sig
get_action_mode = runMethod @"get_action_mode"

get_action_name :: Method "get_action_name" cls sig => cls -> sig
get_action_name = runMethod @"get_action_name"

get_action_strength ::
                      Method "get_action_strength" cls sig => cls -> sig
get_action_strength = runMethod @"get_action_strength"

get_actions :: Method "get_actions" cls sig => cls -> sig
get_actions = runMethod @"get_actions"

get_adjustment_brightness ::
                            Method "get_adjustment_brightness" cls sig => cls -> sig
get_adjustment_brightness = runMethod @"get_adjustment_brightness"

get_adjustment_color_correction ::
                                  Method "get_adjustment_color_correction" cls sig => cls -> sig
get_adjustment_color_correction
  = runMethod @"get_adjustment_color_correction"

get_adjustment_contrast ::
                          Method "get_adjustment_contrast" cls sig => cls -> sig
get_adjustment_contrast = runMethod @"get_adjustment_contrast"

get_adjustment_saturation ::
                            Method "get_adjustment_saturation" cls sig => cls -> sig
get_adjustment_saturation = runMethod @"get_adjustment_saturation"

get_advance_condition ::
                        Method "get_advance_condition" cls sig => cls -> sig
get_advance_condition = runMethod @"get_advance_condition"

get_agent_height :: Method "get_agent_height" cls sig => cls -> sig
get_agent_height = runMethod @"get_agent_height"

get_agent_max_climb ::
                      Method "get_agent_max_climb" cls sig => cls -> sig
get_agent_max_climb = runMethod @"get_agent_max_climb"

get_agent_max_slope ::
                      Method "get_agent_max_slope" cls sig => cls -> sig
get_agent_max_slope = runMethod @"get_agent_max_slope"

get_agent_radius :: Method "get_agent_radius" cls sig => cls -> sig
get_agent_radius = runMethod @"get_agent_radius"

get_albedo :: Method "get_albedo" cls sig => cls -> sig
get_albedo = runMethod @"get_albedo"

get_align :: Method "get_align" cls sig => cls -> sig
get_align = runMethod @"get_align"

get_alignment :: Method "get_alignment" cls sig => cls -> sig
get_alignment = runMethod @"get_alignment"

get_allow_reselect ::
                     Method "get_allow_reselect" cls sig => cls -> sig
get_allow_reselect = runMethod @"get_allow_reselect"

get_allow_rmb_select ::
                       Method "get_allow_rmb_select" cls sig => cls -> sig
get_allow_rmb_select = runMethod @"get_allow_rmb_select"

get_alpha_cut_mode ::
                     Method "get_alpha_cut_mode" cls sig => cls -> sig
get_alpha_cut_mode = runMethod @"get_alpha_cut_mode"

get_alpha_scissor_threshold ::
                              Method "get_alpha_scissor_threshold" cls sig => cls -> sig
get_alpha_scissor_threshold
  = runMethod @"get_alpha_scissor_threshold"

get_alt :: Method "get_alt" cls sig => cls -> sig
get_alt = runMethod @"get_alt"

get_ambient_light_color ::
                          Method "get_ambient_light_color" cls sig => cls -> sig
get_ambient_light_color = runMethod @"get_ambient_light_color"

get_ambient_light_energy ::
                           Method "get_ambient_light_energy" cls sig => cls -> sig
get_ambient_light_energy = runMethod @"get_ambient_light_energy"

get_ambient_light_sky_contribution ::
                                     Method "get_ambient_light_sky_contribution" cls sig =>
                                     cls -> sig
get_ambient_light_sky_contribution
  = runMethod @"get_ambient_light_sky_contribution"

get_amount :: Method "get_amount" cls sig => cls -> sig
get_amount = runMethod @"get_amount"

get_anchor :: Method "get_anchor" cls sig => cls -> sig
get_anchor = runMethod @"get_anchor"

get_anchor_detection_is_enabled ::
                                  Method "get_anchor_detection_is_enabled" cls sig => cls -> sig
get_anchor_detection_is_enabled
  = runMethod @"get_anchor_detection_is_enabled"

get_anchor_id :: Method "get_anchor_id" cls sig => cls -> sig
get_anchor_id = runMethod @"get_anchor_id"

get_anchor_mode :: Method "get_anchor_mode" cls sig => cls -> sig
get_anchor_mode = runMethod @"get_anchor_mode"

get_anchor_name :: Method "get_anchor_name" cls sig => cls -> sig
get_anchor_name = runMethod @"get_anchor_name"

get_angle_to :: Method "get_angle_to" cls sig => cls -> sig
get_angle_to = runMethod @"get_angle_to"

get_angular_damp :: Method "get_angular_damp" cls sig => cls -> sig
get_angular_damp = runMethod @"get_angular_damp"

get_angular_velocity ::
                       Method "get_angular_velocity" cls sig => cls -> sig
get_angular_velocity = runMethod @"get_angular_velocity"

get_animation :: Method "get_animation" cls sig => cls -> sig
get_animation = runMethod @"get_animation"

get_animation_list ::
                     Method "get_animation_list" cls sig => cls -> sig
get_animation_list = runMethod @"get_animation_list"

get_animation_loop ::
                     Method "get_animation_loop" cls sig => cls -> sig
get_animation_loop = runMethod @"get_animation_loop"

get_animation_names ::
                      Method "get_animation_names" cls sig => cls -> sig
get_animation_names = runMethod @"get_animation_names"

get_animation_path ::
                     Method "get_animation_path" cls sig => cls -> sig
get_animation_path = runMethod @"get_animation_path"

get_animation_player ::
                       Method "get_animation_player" cls sig => cls -> sig
get_animation_player = runMethod @"get_animation_player"

get_animation_process_mode ::
                             Method "get_animation_process_mode" cls sig => cls -> sig
get_animation_process_mode
  = runMethod @"get_animation_process_mode"

get_animation_speed ::
                      Method "get_animation_speed" cls sig => cls -> sig
get_animation_speed = runMethod @"get_animation_speed"

get_anisotropy :: Method "get_anisotropy" cls sig => cls -> sig
get_anisotropy = runMethod @"get_anisotropy"

get_antialiased :: Method "get_antialiased" cls sig => cls -> sig
get_antialiased = runMethod @"get_antialiased"

get_ao_light_affect ::
                      Method "get_ao_light_affect" cls sig => cls -> sig
get_ao_light_affect = runMethod @"get_ao_light_affect"

get_ao_texture_channel ::
                         Method "get_ao_texture_channel" cls sig => cls -> sig
get_ao_texture_channel = runMethod @"get_ao_texture_channel"

get_applied_force ::
                    Method "get_applied_force" cls sig => cls -> sig
get_applied_force = runMethod @"get_applied_force"

get_applied_torque ::
                     Method "get_applied_torque" cls sig => cls -> sig
get_applied_torque = runMethod @"get_applied_torque"

get_areaAngular_stiffness ::
                            Method "get_areaAngular_stiffness" cls sig => cls -> sig
get_areaAngular_stiffness = runMethod @"get_areaAngular_stiffness"

get_area_mask :: Method "get_area_mask" cls sig => cls -> sig
get_area_mask = runMethod @"get_area_mask"

get_as_byte_code :: Method "get_as_byte_code" cls sig => cls -> sig
get_as_byte_code = runMethod @"get_as_byte_code"

get_as_ratio :: Method "get_as_ratio" cls sig => cls -> sig
get_as_ratio = runMethod @"get_as_ratio"

get_as_text :: Method "get_as_text" cls sig => cls -> sig
get_as_text = runMethod @"get_as_text"

get_ascent :: Method "get_ascent" cls sig => cls -> sig
get_ascent = runMethod @"get_ascent"

get_assign_op :: Method "get_assign_op" cls sig => cls -> sig
get_assign_op = runMethod @"get_assign_op"

get_assigned_animation ::
                         Method "get_assigned_animation" cls sig => cls -> sig
get_assigned_animation = runMethod @"get_assigned_animation"

get_atlas :: Method "get_atlas" cls sig => cls -> sig
get_atlas = runMethod @"get_atlas"

get_attack_us :: Method "get_attack_us" cls sig => cls -> sig
get_attack_us = runMethod @"get_attack_us"

get_attenuation :: Method "get_attenuation" cls sig => cls -> sig
get_attenuation = runMethod @"get_attenuation"

get_attenuation_filter_cutoff_hz ::
                                   Method "get_attenuation_filter_cutoff_hz" cls sig => cls -> sig
get_attenuation_filter_cutoff_hz
  = runMethod @"get_attenuation_filter_cutoff_hz"

get_attenuation_filter_db ::
                            Method "get_attenuation_filter_db" cls sig => cls -> sig
get_attenuation_filter_db = runMethod @"get_attenuation_filter_db"

get_attenuation_model ::
                        Method "get_attenuation_model" cls sig => cls -> sig
get_attenuation_model = runMethod @"get_attenuation_model"

get_attribute_count ::
                      Method "get_attribute_count" cls sig => cls -> sig
get_attribute_count = runMethod @"get_attribute_count"

get_attribute_name ::
                     Method "get_attribute_name" cls sig => cls -> sig
get_attribute_name = runMethod @"get_attribute_name"

get_attribute_value ::
                      Method "get_attribute_value" cls sig => cls -> sig
get_attribute_value = runMethod @"get_attribute_value"

get_audio_bus :: Method "get_audio_bus" cls sig => cls -> sig
get_audio_bus = runMethod @"get_audio_bus"

get_audio_bus_name ::
                     Method "get_audio_bus_name" cls sig => cls -> sig
get_audio_bus_name = runMethod @"get_audio_bus_name"

get_audio_driver_count ::
                         Method "get_audio_driver_count" cls sig => cls -> sig
get_audio_driver_count = runMethod @"get_audio_driver_count"

get_audio_driver_name ::
                        Method "get_audio_driver_name" cls sig => cls -> sig
get_audio_driver_name = runMethod @"get_audio_driver_name"

get_audio_stream :: Method "get_audio_stream" cls sig => cls -> sig
get_audio_stream = runMethod @"get_audio_stream"

get_audio_track :: Method "get_audio_track" cls sig => cls -> sig
get_audio_track = runMethod @"get_audio_track"

get_author_info :: Method "get_author_info" cls sig => cls -> sig
get_author_info = runMethod @"get_author_info"

get_auto_triangles ::
                     Method "get_auto_triangles" cls sig => cls -> sig
get_auto_triangles = runMethod @"get_auto_triangles"

get_autoplay :: Method "get_autoplay" cls sig => cls -> sig
get_autoplay = runMethod @"get_autoplay"

get_autorestart_delay ::
                        Method "get_autorestart_delay" cls sig => cls -> sig
get_autorestart_delay = runMethod @"get_autorestart_delay"

get_autorestart_random_delay ::
                               Method "get_autorestart_random_delay" cls sig => cls -> sig
get_autorestart_random_delay
  = runMethod @"get_autorestart_random_delay"

get_available_bytes ::
                      Method "get_available_bytes" cls sig => cls -> sig
get_available_bytes = runMethod @"get_available_bytes"

get_available_packet_count ::
                             Method "get_available_packet_count" cls sig => cls -> sig
get_available_packet_count
  = runMethod @"get_available_packet_count"

get_available_point_id ::
                         Method "get_available_point_id" cls sig => cls -> sig
get_available_point_id = runMethod @"get_available_point_id"

get_axis :: Method "get_axis" cls sig => cls -> sig
get_axis = runMethod @"get_axis"

get_axis_lock :: Method "get_axis_lock" cls sig => cls -> sig
get_axis_lock = runMethod @"get_axis_lock"

get_axis_value :: Method "get_axis_value" cls sig => cls -> sig
get_axis_value = runMethod @"get_axis_value"

get_b :: Method "get_b" cls sig => cls -> sig
get_b = runMethod @"get_b"

get_background :: Method "get_background" cls sig => cls -> sig
get_background = runMethod @"get_background"

get_bake_cell_size ::
                     Method "get_bake_cell_size" cls sig => cls -> sig
get_bake_cell_size = runMethod @"get_bake_cell_size"

get_bake_interval ::
                    Method "get_bake_interval" cls sig => cls -> sig
get_bake_interval = runMethod @"get_bake_interval"

get_bake_mesh_instance ::
                         Method "get_bake_mesh_instance" cls sig => cls -> sig
get_bake_mesh_instance = runMethod @"get_bake_mesh_instance"

get_bake_meshes :: Method "get_bake_meshes" cls sig => cls -> sig
get_bake_meshes = runMethod @"get_bake_meshes"

get_bake_mode :: Method "get_bake_mode" cls sig => cls -> sig
get_bake_mode = runMethod @"get_bake_mode"

get_bake_quality :: Method "get_bake_quality" cls sig => cls -> sig
get_bake_quality = runMethod @"get_bake_quality"

get_bake_resolution ::
                      Method "get_bake_resolution" cls sig => cls -> sig
get_bake_resolution = runMethod @"get_bake_resolution"

get_baked_length :: Method "get_baked_length" cls sig => cls -> sig
get_baked_length = runMethod @"get_baked_length"

get_baked_points :: Method "get_baked_points" cls sig => cls -> sig
get_baked_points = runMethod @"get_baked_points"

get_baked_tilts :: Method "get_baked_tilts" cls sig => cls -> sig
get_baked_tilts = runMethod @"get_baked_tilts"

get_baked_up_vectors ::
                       Method "get_baked_up_vectors" cls sig => cls -> sig
get_baked_up_vectors = runMethod @"get_baked_up_vectors"

get_band_count :: Method "get_band_count" cls sig => cls -> sig
get_band_count = runMethod @"get_band_count"

get_band_gain_db :: Method "get_band_gain_db" cls sig => cls -> sig
get_band_gain_db = runMethod @"get_band_gain_db"

get_base :: Method "get_base" cls sig => cls -> sig
get_base = runMethod @"get_base"

get_base_control :: Method "get_base_control" cls sig => cls -> sig
get_base_control = runMethod @"get_base_control"

get_base_path :: Method "get_base_path" cls sig => cls -> sig
get_base_path = runMethod @"get_base_path"

get_base_script :: Method "get_base_script" cls sig => cls -> sig
get_base_script = runMethod @"get_base_script"

get_base_type :: Method "get_base_type" cls sig => cls -> sig
get_base_type = runMethod @"get_base_type"

get_basic_type :: Method "get_basic_type" cls sig => cls -> sig
get_basic_type = runMethod @"get_basic_type"

get_basic_type_constant ::
                          Method "get_basic_type_constant" cls sig => cls -> sig
get_basic_type_constant = runMethod @"get_basic_type_constant"

get_bbcode :: Method "get_bbcode" cls sig => cls -> sig
get_bbcode = runMethod @"get_bbcode"

get_begin :: Method "get_begin" cls sig => cls -> sig
get_begin = runMethod @"get_begin"

get_begin_cap_mode ::
                     Method "get_begin_cap_mode" cls sig => cls -> sig
get_begin_cap_mode = runMethod @"get_begin_cap_mode"

get_bg_color :: Method "get_bg_color" cls sig => cls -> sig
get_bg_color = runMethod @"get_bg_color"

get_bg_energy :: Method "get_bg_energy" cls sig => cls -> sig
get_bg_energy = runMethod @"get_bg_energy"

get_bias :: Method "get_bias" cls sig => cls -> sig
get_bias = runMethod @"get_bias"

get_billboard_mode ::
                     Method "get_billboard_mode" cls sig => cls -> sig
get_billboard_mode = runMethod @"get_billboard_mode"

get_bit :: Method "get_bit" cls sig => cls -> sig
get_bit = runMethod @"get_bit"

get_bitmask :: Method "get_bitmask" cls sig => cls -> sig
get_bitmask = runMethod @"get_bitmask"

get_blend_mode :: Method "get_blend_mode" cls sig => cls -> sig
get_blend_mode = runMethod @"get_blend_mode"

get_blend_point_count ::
                        Method "get_blend_point_count" cls sig => cls -> sig
get_blend_point_count = runMethod @"get_blend_point_count"

get_blend_point_node ::
                       Method "get_blend_point_node" cls sig => cls -> sig
get_blend_point_node = runMethod @"get_blend_point_node"

get_blend_point_position ::
                           Method "get_blend_point_position" cls sig => cls -> sig
get_blend_point_position = runMethod @"get_blend_point_position"

get_blend_shape_count ::
                        Method "get_blend_shape_count" cls sig => cls -> sig
get_blend_shape_count = runMethod @"get_blend_shape_count"

get_blend_shape_mode ::
                       Method "get_blend_shape_mode" cls sig => cls -> sig
get_blend_shape_mode = runMethod @"get_blend_shape_mode"

get_blend_shape_name ::
                       Method "get_blend_shape_name" cls sig => cls -> sig
get_blend_shape_name = runMethod @"get_blend_shape_name"

get_blend_time :: Method "get_blend_time" cls sig => cls -> sig
get_blend_time = runMethod @"get_blend_time"

get_body_offset :: Method "get_body_offset" cls sig => cls -> sig
get_body_offset = runMethod @"get_body_offset"

get_body_size :: Method "get_body_size" cls sig => cls -> sig
get_body_size = runMethod @"get_body_size"

get_body_size_limit ::
                      Method "get_body_size_limit" cls sig => cls -> sig
get_body_size_limit = runMethod @"get_body_size_limit"

get_bone :: Method "get_bone" cls sig => cls -> sig
get_bone = runMethod @"get_bone"

get_bone_count :: Method "get_bone_count" cls sig => cls -> sig
get_bone_count = runMethod @"get_bone_count"

get_bone_custom_pose ::
                       Method "get_bone_custom_pose" cls sig => cls -> sig
get_bone_custom_pose = runMethod @"get_bone_custom_pose"

get_bone_global_pose ::
                       Method "get_bone_global_pose" cls sig => cls -> sig
get_bone_global_pose = runMethod @"get_bone_global_pose"

get_bone_id :: Method "get_bone_id" cls sig => cls -> sig
get_bone_id = runMethod @"get_bone_id"

get_bone_name :: Method "get_bone_name" cls sig => cls -> sig
get_bone_name = runMethod @"get_bone_name"

get_bone_parent :: Method "get_bone_parent" cls sig => cls -> sig
get_bone_parent = runMethod @"get_bone_parent"

get_bone_path :: Method "get_bone_path" cls sig => cls -> sig
get_bone_path = runMethod @"get_bone_path"

get_bone_pose :: Method "get_bone_pose" cls sig => cls -> sig
get_bone_pose = runMethod @"get_bone_pose"

get_bone_rest :: Method "get_bone_rest" cls sig => cls -> sig
get_bone_rest = runMethod @"get_bone_rest"

get_bone_transform ::
                     Method "get_bone_transform" cls sig => cls -> sig
get_bone_transform = runMethod @"get_bone_transform"

get_bone_weights :: Method "get_bone_weights" cls sig => cls -> sig
get_bone_weights = runMethod @"get_bone_weights"

get_border_blend :: Method "get_border_blend" cls sig => cls -> sig
get_border_blend = runMethod @"get_border_blend"

get_border_color :: Method "get_border_color" cls sig => cls -> sig
get_border_color = runMethod @"get_border_color"

get_border_width :: Method "get_border_width" cls sig => cls -> sig
get_border_width = runMethod @"get_border_width"

get_border_width_min ::
                       Method "get_border_width_min" cls sig => cls -> sig
get_border_width_min = runMethod @"get_border_width_min"

get_borderless_window ::
                        Method "get_borderless_window" cls sig => cls -> sig
get_borderless_window = runMethod @"get_borderless_window"

get_bottom_radius ::
                    Method "get_bottom_radius" cls sig => cls -> sig
get_bottom_radius = runMethod @"get_bottom_radius"

get_bounce :: Method "get_bounce" cls sig => cls -> sig
get_bounce = runMethod @"get_bounce"

get_bound_child_nodes_to_bone ::
                                Method "get_bound_child_nodes_to_bone" cls sig => cls -> sig
get_bound_child_nodes_to_bone
  = runMethod @"get_bound_child_nodes_to_bone"

get_bounds :: Method "get_bounds" cls sig => cls -> sig
get_bounds = runMethod @"get_bounds"

get_brake :: Method "get_brake" cls sig => cls -> sig
get_brake = runMethod @"get_brake"

get_breakpoints :: Method "get_breakpoints" cls sig => cls -> sig
get_breakpoints = runMethod @"get_breakpoints"

get_buffer :: Method "get_buffer" cls sig => cls -> sig
get_buffer = runMethod @"get_buffer"

get_buffering_msec ::
                     Method "get_buffering_msec" cls sig => cls -> sig
get_buffering_msec = runMethod @"get_buffering_msec"

get_build_mode :: Method "get_build_mode" cls sig => cls -> sig
get_build_mode = runMethod @"get_build_mode"

get_bus :: Method "get_bus" cls sig => cls -> sig
get_bus = runMethod @"get_bus"

get_bus_count :: Method "get_bus_count" cls sig => cls -> sig
get_bus_count = runMethod @"get_bus_count"

get_bus_effect :: Method "get_bus_effect" cls sig => cls -> sig
get_bus_effect = runMethod @"get_bus_effect"

get_bus_effect_count ::
                       Method "get_bus_effect_count" cls sig => cls -> sig
get_bus_effect_count = runMethod @"get_bus_effect_count"

get_bus_index :: Method "get_bus_index" cls sig => cls -> sig
get_bus_index = runMethod @"get_bus_index"

get_bus_name :: Method "get_bus_name" cls sig => cls -> sig
get_bus_name = runMethod @"get_bus_name"

get_bus_peak_volume_left_db ::
                              Method "get_bus_peak_volume_left_db" cls sig => cls -> sig
get_bus_peak_volume_left_db
  = runMethod @"get_bus_peak_volume_left_db"

get_bus_peak_volume_right_db ::
                               Method "get_bus_peak_volume_right_db" cls sig => cls -> sig
get_bus_peak_volume_right_db
  = runMethod @"get_bus_peak_volume_right_db"

get_bus_send :: Method "get_bus_send" cls sig => cls -> sig
get_bus_send = runMethod @"get_bus_send"

get_bus_volume_db ::
                    Method "get_bus_volume_db" cls sig => cls -> sig
get_bus_volume_db = runMethod @"get_bus_volume_db"

get_button :: Method "get_button" cls sig => cls -> sig
get_button = runMethod @"get_button"

get_button_count :: Method "get_button_count" cls sig => cls -> sig
get_button_count = runMethod @"get_button_count"

get_button_group :: Method "get_button_group" cls sig => cls -> sig
get_button_group = runMethod @"get_button_group"

get_button_icon :: Method "get_button_icon" cls sig => cls -> sig
get_button_icon = runMethod @"get_button_icon"

get_button_index :: Method "get_button_index" cls sig => cls -> sig
get_button_index = runMethod @"get_button_index"

get_button_mask :: Method "get_button_mask" cls sig => cls -> sig
get_button_mask = runMethod @"get_button_mask"

get_call_mode :: Method "get_call_mode" cls sig => cls -> sig
get_call_mode = runMethod @"get_call_mode"

get_camera :: Method "get_camera" cls sig => cls -> sig
get_camera = runMethod @"get_camera"

get_camera_position ::
                      Method "get_camera_position" cls sig => cls -> sig
get_camera_position = runMethod @"get_camera_position"

get_camera_screen_center ::
                           Method "get_camera_screen_center" cls sig => cls -> sig
get_camera_screen_center = runMethod @"get_camera_screen_center"

get_camera_transform ::
                       Method "get_camera_transform" cls sig => cls -> sig
get_camera_transform = runMethod @"get_camera_transform"

get_cancel :: Method "get_cancel" cls sig => cls -> sig
get_cancel = runMethod @"get_cancel"

get_canvas :: Method "get_canvas" cls sig => cls -> sig
get_canvas = runMethod @"get_canvas"

get_canvas_item :: Method "get_canvas_item" cls sig => cls -> sig
get_canvas_item = runMethod @"get_canvas_item"

get_canvas_max_layer ::
                       Method "get_canvas_max_layer" cls sig => cls -> sig
get_canvas_max_layer = runMethod @"get_canvas_max_layer"

get_canvas_transform ::
                       Method "get_canvas_transform" cls sig => cls -> sig
get_canvas_transform = runMethod @"get_canvas_transform"

get_capabilities :: Method "get_capabilities" cls sig => cls -> sig
get_capabilities = runMethod @"get_capabilities"

get_caption :: Method "get_caption" cls sig => cls -> sig
get_caption = runMethod @"get_caption"

get_capture_cell_size ::
                        Method "get_capture_cell_size" cls sig => cls -> sig
get_capture_cell_size = runMethod @"get_capture_cell_size"

get_capture_input_on_drag ::
                            Method "get_capture_input_on_drag" cls sig => cls -> sig
get_capture_input_on_drag = runMethod @"get_capture_input_on_drag"

get_cast_shadows_setting ::
                           Method "get_cast_shadows_setting" cls sig => cls -> sig
get_cast_shadows_setting = runMethod @"get_cast_shadows_setting"

get_cast_to :: Method "get_cast_to" cls sig => cls -> sig
get_cast_to = runMethod @"get_cast_to"

get_ceiling_db :: Method "get_ceiling_db" cls sig => cls -> sig
get_ceiling_db = runMethod @"get_ceiling_db"

get_cell :: Method "get_cell" cls sig => cls -> sig
get_cell = runMethod @"get_cell"

get_cell_height :: Method "get_cell_height" cls sig => cls -> sig
get_cell_height = runMethod @"get_cell_height"

get_cell_item :: Method "get_cell_item" cls sig => cls -> sig
get_cell_item = runMethod @"get_cell_item"

get_cell_item_orientation ::
                            Method "get_cell_item_orientation" cls sig => cls -> sig
get_cell_item_orientation = runMethod @"get_cell_item_orientation"

get_cell_mode :: Method "get_cell_mode" cls sig => cls -> sig
get_cell_mode = runMethod @"get_cell_mode"

get_cell_scale :: Method "get_cell_scale" cls sig => cls -> sig
get_cell_scale = runMethod @"get_cell_scale"

get_cell_size :: Method "get_cell_size" cls sig => cls -> sig
get_cell_size = runMethod @"get_cell_size"

get_cell_space_transform ::
                           Method "get_cell_space_transform" cls sig => cls -> sig
get_cell_space_transform = runMethod @"get_cell_space_transform"

get_cell_subdiv :: Method "get_cell_subdiv" cls sig => cls -> sig
get_cell_subdiv = runMethod @"get_cell_subdiv"

get_cellv :: Method "get_cellv" cls sig => cls -> sig
get_cellv = runMethod @"get_cellv"

get_center_of_mass ::
                     Method "get_center_of_mass" cls sig => cls -> sig
get_center_of_mass = runMethod @"get_center_of_mass"

get_center_size :: Method "get_center_size" cls sig => cls -> sig
get_center_size = runMethod @"get_center_size"

get_center_x :: Method "get_center_x" cls sig => cls -> sig
get_center_x = runMethod @"get_center_x"

get_center_y :: Method "get_center_y" cls sig => cls -> sig
get_center_y = runMethod @"get_center_y"

get_center_z :: Method "get_center_z" cls sig => cls -> sig
get_center_z = runMethod @"get_center_z"

get_channel_count ::
                    Method "get_channel_count" cls sig => cls -> sig
get_channel_count = runMethod @"get_channel_count"

get_char_size :: Method "get_char_size" cls sig => cls -> sig
get_char_size = runMethod @"get_char_size"

get_child :: Method "get_child" cls sig => cls -> sig
get_child = runMethod @"get_child"

get_child_count :: Method "get_child_count" cls sig => cls -> sig
get_child_count = runMethod @"get_child_count"

get_children :: Method "get_children" cls sig => cls -> sig
get_children = runMethod @"get_children"

get_class :: Method "get_class" cls sig => cls -> sig
get_class = runMethod @"get_class"

get_class_constant ::
                     Method "get_class_constant" cls sig => cls -> sig
get_class_constant = runMethod @"get_class_constant"

get_class_documentation ::
                          Method "get_class_documentation" cls sig => cls -> sig
get_class_documentation = runMethod @"get_class_documentation"

get_class_list :: Method "get_class_list" cls sig => cls -> sig
get_class_list = runMethod @"get_class_list"

get_class_name :: Method "get_class_name" cls sig => cls -> sig
get_class_name = runMethod @"get_class_name"

get_clear_mode :: Method "get_clear_mode" cls sig => cls -> sig
get_clear_mode = runMethod @"get_clear_mode"

get_clearcoat :: Method "get_clearcoat" cls sig => cls -> sig
get_clearcoat = runMethod @"get_clearcoat"

get_clearcoat_gloss ::
                      Method "get_clearcoat_gloss" cls sig => cls -> sig
get_clearcoat_gloss = runMethod @"get_clearcoat_gloss"

get_click_mask :: Method "get_click_mask" cls sig => cls -> sig
get_click_mask = runMethod @"get_click_mask"

get_clip_text :: Method "get_clip_text" cls sig => cls -> sig
get_clip_text = runMethod @"get_clip_text"

get_clip_uv :: Method "get_clip_uv" cls sig => cls -> sig
get_clip_uv = runMethod @"get_clip_uv"

get_clipboard :: Method "get_clipboard" cls sig => cls -> sig
get_clipboard = runMethod @"get_clipboard"

get_close_button :: Method "get_close_button" cls sig => cls -> sig
get_close_button = runMethod @"get_close_button"

get_closest_offset ::
                     Method "get_closest_offset" cls sig => cls -> sig
get_closest_offset = runMethod @"get_closest_offset"

get_closest_point ::
                    Method "get_closest_point" cls sig => cls -> sig
get_closest_point = runMethod @"get_closest_point"

get_closest_point_normal ::
                           Method "get_closest_point_normal" cls sig => cls -> sig
get_closest_point_normal = runMethod @"get_closest_point_normal"

get_closest_point_owner ::
                          Method "get_closest_point_owner" cls sig => cls -> sig
get_closest_point_owner = runMethod @"get_closest_point_owner"

get_closest_point_to_segment ::
                               Method "get_closest_point_to_segment" cls sig => cls -> sig
get_closest_point_to_segment
  = runMethod @"get_closest_point_to_segment"

get_closest_point_to_segment_2d ::
                                  Method "get_closest_point_to_segment_2d" cls sig => cls -> sig
get_closest_point_to_segment_2d
  = runMethod @"get_closest_point_to_segment_2d"

get_closest_point_to_segment_uncapped ::
                                        Method "get_closest_point_to_segment_uncapped" cls sig =>
                                        cls -> sig
get_closest_point_to_segment_uncapped
  = runMethod @"get_closest_point_to_segment_uncapped"

get_closest_point_to_segment_uncapped_2d ::
                                           Method "get_closest_point_to_segment_uncapped_2d" cls
                                             sig =>
                                           cls -> sig
get_closest_point_to_segment_uncapped_2d
  = runMethod @"get_closest_point_to_segment_uncapped_2d"

get_closest_points_between_segments ::
                                      Method "get_closest_points_between_segments" cls sig =>
                                      cls -> sig
get_closest_points_between_segments
  = runMethod @"get_closest_points_between_segments"

get_closest_points_between_segments_2d ::
                                         Method "get_closest_points_between_segments_2d" cls sig =>
                                         cls -> sig
get_closest_points_between_segments_2d
  = runMethod @"get_closest_points_between_segments_2d"

get_closest_position_in_segment ::
                                  Method "get_closest_position_in_segment" cls sig => cls -> sig
get_closest_position_in_segment
  = runMethod @"get_closest_position_in_segment"

get_cmdline_args :: Method "get_cmdline_args" cls sig => cls -> sig
get_cmdline_args = runMethod @"get_cmdline_args"

get_code :: Method "get_code" cls sig => cls -> sig
get_code = runMethod @"get_code"

get_collider :: Method "get_collider" cls sig => cls -> sig
get_collider = runMethod @"get_collider"

get_collider_id :: Method "get_collider_id" cls sig => cls -> sig
get_collider_id = runMethod @"get_collider_id"

get_collider_metadata ::
                        Method "get_collider_metadata" cls sig => cls -> sig
get_collider_metadata = runMethod @"get_collider_metadata"

get_collider_rid :: Method "get_collider_rid" cls sig => cls -> sig
get_collider_rid = runMethod @"get_collider_rid"

get_collider_shape ::
                     Method "get_collider_shape" cls sig => cls -> sig
get_collider_shape = runMethod @"get_collider_shape"

get_collider_shape_index ::
                           Method "get_collider_shape_index" cls sig => cls -> sig
get_collider_shape_index = runMethod @"get_collider_shape_index"

get_collider_velocity ::
                        Method "get_collider_velocity" cls sig => cls -> sig
get_collider_velocity = runMethod @"get_collider_velocity"

get_colliding_bodies ::
                       Method "get_colliding_bodies" cls sig => cls -> sig
get_colliding_bodies = runMethod @"get_colliding_bodies"

get_collision_bounce ::
                       Method "get_collision_bounce" cls sig => cls -> sig
get_collision_bounce = runMethod @"get_collision_bounce"

get_collision_exceptions ::
                           Method "get_collision_exceptions" cls sig => cls -> sig
get_collision_exceptions = runMethod @"get_collision_exceptions"

get_collision_friction ::
                         Method "get_collision_friction" cls sig => cls -> sig
get_collision_friction = runMethod @"get_collision_friction"

get_collision_layer ::
                      Method "get_collision_layer" cls sig => cls -> sig
get_collision_layer = runMethod @"get_collision_layer"

get_collision_layer_bit ::
                          Method "get_collision_layer_bit" cls sig => cls -> sig
get_collision_layer_bit = runMethod @"get_collision_layer_bit"

get_collision_mask ::
                     Method "get_collision_mask" cls sig => cls -> sig
get_collision_mask = runMethod @"get_collision_mask"

get_collision_mask_bit ::
                         Method "get_collision_mask_bit" cls sig => cls -> sig
get_collision_mask_bit = runMethod @"get_collision_mask_bit"

get_collision_normal ::
                       Method "get_collision_normal" cls sig => cls -> sig
get_collision_normal = runMethod @"get_collision_normal"

get_collision_point ::
                      Method "get_collision_point" cls sig => cls -> sig
get_collision_point = runMethod @"get_collision_point"

get_collision_use_kinematic ::
                              Method "get_collision_use_kinematic" cls sig => cls -> sig
get_collision_use_kinematic
  = runMethod @"get_collision_use_kinematic"

get_color :: Method "get_color" cls sig => cls -> sig
get_color = runMethod @"get_color"

get_color_default ::
                    Method "get_color_default" cls sig => cls -> sig
get_color_default = runMethod @"get_color_default"

get_color_format :: Method "get_color_format" cls sig => cls -> sig
get_color_format = runMethod @"get_color_format"

get_color_list :: Method "get_color_list" cls sig => cls -> sig
get_color_list = runMethod @"get_color_list"

get_color_ramp :: Method "get_color_ramp" cls sig => cls -> sig
get_color_ramp = runMethod @"get_color_ramp"

get_colors :: Method "get_colors" cls sig => cls -> sig
get_colors = runMethod @"get_colors"

get_column_at_position ::
                         Method "get_column_at_position" cls sig => cls -> sig
get_column_at_position = runMethod @"get_column_at_position"

get_column_title :: Method "get_column_title" cls sig => cls -> sig
get_column_title = runMethod @"get_column_title"

get_column_width :: Method "get_column_width" cls sig => cls -> sig
get_column_width = runMethod @"get_column_width"

get_columns :: Method "get_columns" cls sig => cls -> sig
get_columns = runMethod @"get_columns"

get_combined_minimum_size ::
                            Method "get_combined_minimum_size" cls sig => cls -> sig
get_combined_minimum_size = runMethod @"get_combined_minimum_size"

get_command :: Method "get_command" cls sig => cls -> sig
get_command = runMethod @"get_command"

get_compression_mode ::
                       Method "get_compression_mode" cls sig => cls -> sig
get_compression_mode = runMethod @"get_compression_mode"

get_config_file :: Method "get_config_file" cls sig => cls -> sig
get_config_file = runMethod @"get_config_file"

get_connected_host ::
                     Method "get_connected_host" cls sig => cls -> sig
get_connected_host = runMethod @"get_connected_host"

get_connected_joypads ::
                        Method "get_connected_joypads" cls sig => cls -> sig
get_connected_joypads = runMethod @"get_connected_joypads"

get_connected_midi_inputs ::
                            Method "get_connected_midi_inputs" cls sig => cls -> sig
get_connected_midi_inputs = runMethod @"get_connected_midi_inputs"

get_connected_port ::
                     Method "get_connected_port" cls sig => cls -> sig
get_connected_port = runMethod @"get_connected_port"

get_connection :: Method "get_connection" cls sig => cls -> sig
get_connection = runMethod @"get_connection"

get_connection_binds ::
                       Method "get_connection_binds" cls sig => cls -> sig
get_connection_binds = runMethod @"get_connection_binds"

get_connection_count ::
                       Method "get_connection_count" cls sig => cls -> sig
get_connection_count = runMethod @"get_connection_count"

get_connection_flags ::
                       Method "get_connection_flags" cls sig => cls -> sig
get_connection_flags = runMethod @"get_connection_flags"

get_connection_input_color ::
                             Method "get_connection_input_color" cls sig => cls -> sig
get_connection_input_color
  = runMethod @"get_connection_input_color"

get_connection_input_count ::
                             Method "get_connection_input_count" cls sig => cls -> sig
get_connection_input_count
  = runMethod @"get_connection_input_count"

get_connection_input_position ::
                                Method "get_connection_input_position" cls sig => cls -> sig
get_connection_input_position
  = runMethod @"get_connection_input_position"

get_connection_input_type ::
                            Method "get_connection_input_type" cls sig => cls -> sig
get_connection_input_type = runMethod @"get_connection_input_type"

get_connection_list ::
                      Method "get_connection_list" cls sig => cls -> sig
get_connection_list = runMethod @"get_connection_list"

get_connection_method ::
                        Method "get_connection_method" cls sig => cls -> sig
get_connection_method = runMethod @"get_connection_method"

get_connection_output_color ::
                              Method "get_connection_output_color" cls sig => cls -> sig
get_connection_output_color
  = runMethod @"get_connection_output_color"

get_connection_output_count ::
                              Method "get_connection_output_count" cls sig => cls -> sig
get_connection_output_count
  = runMethod @"get_connection_output_count"

get_connection_output_position ::
                                 Method "get_connection_output_position" cls sig => cls -> sig
get_connection_output_position
  = runMethod @"get_connection_output_position"

get_connection_output_type ::
                             Method "get_connection_output_type" cls sig => cls -> sig
get_connection_output_type
  = runMethod @"get_connection_output_type"

get_connection_signal ::
                        Method "get_connection_signal" cls sig => cls -> sig
get_connection_signal = runMethod @"get_connection_signal"

get_connection_source ::
                        Method "get_connection_source" cls sig => cls -> sig
get_connection_source = runMethod @"get_connection_source"

get_connection_status ::
                        Method "get_connection_status" cls sig => cls -> sig
get_connection_status = runMethod @"get_connection_status"

get_connection_target ::
                        Method "get_connection_target" cls sig => cls -> sig
get_connection_target = runMethod @"get_connection_target"

get_constant :: Method "get_constant" cls sig => cls -> sig
get_constant = runMethod @"get_constant"

get_constant_angular_velocity ::
                                Method "get_constant_angular_velocity" cls sig => cls -> sig
get_constant_angular_velocity
  = runMethod @"get_constant_angular_velocity"

get_constant_linear_velocity ::
                               Method "get_constant_linear_velocity" cls sig => cls -> sig
get_constant_linear_velocity
  = runMethod @"get_constant_linear_velocity"

get_constant_list ::
                    Method "get_constant_list" cls sig => cls -> sig
get_constant_list = runMethod @"get_constant_list"

get_constant_type ::
                    Method "get_constant_type" cls sig => cls -> sig
get_constant_type = runMethod @"get_constant_type"

get_constant_value ::
                     Method "get_constant_value" cls sig => cls -> sig
get_constant_value = runMethod @"get_constant_value"

get_constructor :: Method "get_constructor" cls sig => cls -> sig
get_constructor = runMethod @"get_constructor"

get_constructor_type ::
                       Method "get_constructor_type" cls sig => cls -> sig
get_constructor_type = runMethod @"get_constructor_type"

get_contact_collider ::
                       Method "get_contact_collider" cls sig => cls -> sig
get_contact_collider = runMethod @"get_contact_collider"

get_contact_collider_id ::
                          Method "get_contact_collider_id" cls sig => cls -> sig
get_contact_collider_id = runMethod @"get_contact_collider_id"

get_contact_collider_object ::
                              Method "get_contact_collider_object" cls sig => cls -> sig
get_contact_collider_object
  = runMethod @"get_contact_collider_object"

get_contact_collider_position ::
                                Method "get_contact_collider_position" cls sig => cls -> sig
get_contact_collider_position
  = runMethod @"get_contact_collider_position"

get_contact_collider_shape ::
                             Method "get_contact_collider_shape" cls sig => cls -> sig
get_contact_collider_shape
  = runMethod @"get_contact_collider_shape"

get_contact_collider_shape_metadata ::
                                      Method "get_contact_collider_shape_metadata" cls sig =>
                                      cls -> sig
get_contact_collider_shape_metadata
  = runMethod @"get_contact_collider_shape_metadata"

get_contact_collider_velocity_at_position ::
                                            Method "get_contact_collider_velocity_at_position" cls
                                              sig =>
                                            cls -> sig
get_contact_collider_velocity_at_position
  = runMethod @"get_contact_collider_velocity_at_position"

get_contact_count ::
                    Method "get_contact_count" cls sig => cls -> sig
get_contact_count = runMethod @"get_contact_count"

get_contact_impulse ::
                      Method "get_contact_impulse" cls sig => cls -> sig
get_contact_impulse = runMethod @"get_contact_impulse"

get_contact_local_normal ::
                           Method "get_contact_local_normal" cls sig => cls -> sig
get_contact_local_normal = runMethod @"get_contact_local_normal"

get_contact_local_position ::
                             Method "get_contact_local_position" cls sig => cls -> sig
get_contact_local_position
  = runMethod @"get_contact_local_position"

get_contact_local_shape ::
                          Method "get_contact_local_shape" cls sig => cls -> sig
get_contact_local_shape = runMethod @"get_contact_local_shape"

get_content_height ::
                     Method "get_content_height" cls sig => cls -> sig
get_content_height = runMethod @"get_content_height"

get_continuous_collision_detection_mode ::
                                          Method "get_continuous_collision_detection_mode" cls
                                            sig =>
                                          cls -> sig
get_continuous_collision_detection_mode
  = runMethod @"get_continuous_collision_detection_mode"

get_control :: Method "get_control" cls sig => cls -> sig
get_control = runMethod @"get_control"

get_controller_id ::
                    Method "get_controller_id" cls sig => cls -> sig
get_controller_id = runMethod @"get_controller_id"

get_controller_name ::
                      Method "get_controller_name" cls sig => cls -> sig
get_controller_name = runMethod @"get_controller_name"

get_copy_mode :: Method "get_copy_mode" cls sig => cls -> sig
get_copy_mode = runMethod @"get_copy_mode"

get_copyright_info ::
                     Method "get_copyright_info" cls sig => cls -> sig
get_copyright_info = runMethod @"get_copyright_info"

get_corner_detail ::
                    Method "get_corner_detail" cls sig => cls -> sig
get_corner_detail = runMethod @"get_corner_detail"

get_corner_radius ::
                    Method "get_corner_radius" cls sig => cls -> sig
get_corner_radius = runMethod @"get_corner_radius"

get_cross_fade_time ::
                      Method "get_cross_fade_time" cls sig => cls -> sig
get_cross_fade_time = runMethod @"get_cross_fade_time"

get_csv_line :: Method "get_csv_line" cls sig => cls -> sig
get_csv_line = runMethod @"get_csv_line"

get_cube_map :: Method "get_cube_map" cls sig => cls -> sig
get_cube_map = runMethod @"get_cube_map"

get_cubic_interpolation ::
                          Method "get_cubic_interpolation" cls sig => cls -> sig
get_cubic_interpolation = runMethod @"get_cubic_interpolation"

get_cull_mask :: Method "get_cull_mask" cls sig => cls -> sig
get_cull_mask = runMethod @"get_cull_mask"

get_cull_mask_bit ::
                    Method "get_cull_mask_bit" cls sig => cls -> sig
get_cull_mask_bit = runMethod @"get_cull_mask_bit"

get_cull_mode :: Method "get_cull_mode" cls sig => cls -> sig
get_cull_mode = runMethod @"get_cull_mode"

get_current_action_name ::
                          Method "get_current_action_name" cls sig => cls -> sig
get_current_action_name = runMethod @"get_current_action_name"

get_current_animation ::
                        Method "get_current_animation" cls sig => cls -> sig
get_current_animation = runMethod @"get_current_animation"

get_current_animation_length ::
                               Method "get_current_animation_length" cls sig => cls -> sig
get_current_animation_length
  = runMethod @"get_current_animation_length"

get_current_animation_position ::
                                 Method "get_current_animation_position" cls sig => cls -> sig
get_current_animation_position
  = runMethod @"get_current_animation_position"

get_current_dependencies ::
                           Method "get_current_dependencies" cls sig => cls -> sig
get_current_dependencies = runMethod @"get_current_dependencies"

get_current_dir :: Method "get_current_dir" cls sig => cls -> sig
get_current_dir = runMethod @"get_current_dir"

get_current_drive ::
                    Method "get_current_drive" cls sig => cls -> sig
get_current_drive = runMethod @"get_current_drive"

get_current_file :: Method "get_current_file" cls sig => cls -> sig
get_current_file = runMethod @"get_current_file"

get_current_library_path ::
                           Method "get_current_library_path" cls sig => cls -> sig
get_current_library_path = runMethod @"get_current_library_path"

get_current_line :: Method "get_current_line" cls sig => cls -> sig
get_current_line = runMethod @"get_current_line"

get_current_node :: Method "get_current_node" cls sig => cls -> sig
get_current_node = runMethod @"get_current_node"

get_current_path :: Method "get_current_path" cls sig => cls -> sig
get_current_path = runMethod @"get_current_path"

get_current_scene ::
                    Method "get_current_scene" cls sig => cls -> sig
get_current_scene = runMethod @"get_current_scene"

get_current_screen ::
                     Method "get_current_screen" cls sig => cls -> sig
get_current_screen = runMethod @"get_current_screen"

get_current_script ::
                     Method "get_current_script" cls sig => cls -> sig
get_current_script = runMethod @"get_current_script"

get_current_tab :: Method "get_current_tab" cls sig => cls -> sig
get_current_tab = runMethod @"get_current_tab"

get_current_tab_control ::
                          Method "get_current_tab_control" cls sig => cls -> sig
get_current_tab_control = runMethod @"get_current_tab_control"

get_cursor_position ::
                      Method "get_cursor_position" cls sig => cls -> sig
get_cursor_position = runMethod @"get_cursor_position"

get_cursor_shape :: Method "get_cursor_shape" cls sig => cls -> sig
get_cursor_shape = runMethod @"get_cursor_shape"

get_curve :: Method "get_curve" cls sig => cls -> sig
get_curve = runMethod @"get_curve"

get_custom_aabb :: Method "get_custom_aabb" cls sig => cls -> sig
get_custom_aabb = runMethod @"get_custom_aabb"

get_custom_bg_color ::
                      Method "get_custom_bg_color" cls sig => cls -> sig
get_custom_bg_color = runMethod @"get_custom_bg_color"

get_custom_data_format ::
                         Method "get_custom_data_format" cls sig => cls -> sig
get_custom_data_format = runMethod @"get_custom_data_format"

get_custom_minimum_height ::
                            Method "get_custom_minimum_height" cls sig => cls -> sig
get_custom_minimum_height = runMethod @"get_custom_minimum_height"

get_custom_minimum_size ::
                          Method "get_custom_minimum_size" cls sig => cls -> sig
get_custom_minimum_size = runMethod @"get_custom_minimum_size"

get_custom_multiplayer ::
                         Method "get_custom_multiplayer" cls sig => cls -> sig
get_custom_multiplayer = runMethod @"get_custom_multiplayer"

get_custom_popup_rect ::
                        Method "get_custom_popup_rect" cls sig => cls -> sig
get_custom_popup_rect = runMethod @"get_custom_popup_rect"

get_custom_solver_bias ::
                         Method "get_custom_solver_bias" cls sig => cls -> sig
get_custom_solver_bias = runMethod @"get_custom_solver_bias"

get_custom_step :: Method "get_custom_step" cls sig => cls -> sig
get_custom_step = runMethod @"get_custom_step"

get_custom_transform ::
                       Method "get_custom_transform" cls sig => cls -> sig
get_custom_transform = runMethod @"get_custom_transform"

get_custom_viewport ::
                      Method "get_custom_viewport" cls sig => cls -> sig
get_custom_viewport = runMethod @"get_custom_viewport"

get_cutoff :: Method "get_cutoff" cls sig => cls -> sig
get_cutoff = runMethod @"get_cutoff"

get_d :: Method "get_d" cls sig => cls -> sig
get_d = runMethod @"get_d"

get_damping :: Method "get_damping" cls sig => cls -> sig
get_damping = runMethod @"get_damping"

get_damping_coefficient ::
                          Method "get_damping_coefficient" cls sig => cls -> sig
get_damping_coefficient = runMethod @"get_damping_coefficient"

get_damping_compression ::
                          Method "get_damping_compression" cls sig => cls -> sig
get_damping_compression = runMethod @"get_damping_compression"

get_damping_relaxation ::
                         Method "get_damping_relaxation" cls sig => cls -> sig
get_damping_relaxation = runMethod @"get_damping_relaxation"

get_data :: Method "get_data" cls sig => cls -> sig
get_data = runMethod @"get_data"

get_data_array :: Method "get_data_array" cls sig => cls -> sig
get_data_array = runMethod @"get_data_array"

get_date :: Method "get_date" cls sig => cls -> sig
get_date = runMethod @"get_date"

get_datetime :: Method "get_datetime" cls sig => cls -> sig
get_datetime = runMethod @"get_datetime"

get_datetime_from_unix_time ::
                              Method "get_datetime_from_unix_time" cls sig => cls -> sig
get_datetime_from_unix_time
  = runMethod @"get_datetime_from_unix_time"

get_db :: Method "get_db" cls sig => cls -> sig
get_db = runMethod @"get_db"

get_deadzone :: Method "get_deadzone" cls sig => cls -> sig
get_deadzone = runMethod @"get_deadzone"

get_debug_draw :: Method "get_debug_draw" cls sig => cls -> sig
get_debug_draw = runMethod @"get_debug_draw"

get_deconstruct_type ::
                       Method "get_deconstruct_type" cls sig => cls -> sig
get_deconstruct_type = runMethod @"get_deconstruct_type"

get_default_blend_time ::
                         Method "get_default_blend_time" cls sig => cls -> sig
get_default_blend_time = runMethod @"get_default_blend_time"

get_default_color ::
                    Method "get_default_color" cls sig => cls -> sig
get_default_color = runMethod @"get_default_color"

get_default_cursor_shape ::
                           Method "get_default_cursor_shape" cls sig => cls -> sig
get_default_cursor_shape = runMethod @"get_default_cursor_shape"

get_default_font :: Method "get_default_font" cls sig => cls -> sig
get_default_font = runMethod @"get_default_font"

get_default_input_value ::
                          Method "get_default_input_value" cls sig => cls -> sig
get_default_input_value = runMethod @"get_default_input_value"

get_default_length ::
                     Method "get_default_length" cls sig => cls -> sig
get_default_length = runMethod @"get_default_length"

get_default_margin ::
                     Method "get_default_margin" cls sig => cls -> sig
get_default_margin = runMethod @"get_default_margin"

get_default_texture_param ::
                            Method "get_default_texture_param" cls sig => cls -> sig
get_default_texture_param = runMethod @"get_default_texture_param"

get_delta :: Method "get_delta" cls sig => cls -> sig
get_delta = runMethod @"get_delta"

get_dependencies :: Method "get_dependencies" cls sig => cls -> sig
get_dependencies = runMethod @"get_dependencies"

get_depth :: Method "get_depth" cls sig => cls -> sig
get_depth = runMethod @"get_depth"

get_depth_deep_parallax_max_layers ::
                                     Method "get_depth_deep_parallax_max_layers" cls sig =>
                                     cls -> sig
get_depth_deep_parallax_max_layers
  = runMethod @"get_depth_deep_parallax_max_layers"

get_depth_deep_parallax_min_layers ::
                                     Method "get_depth_deep_parallax_min_layers" cls sig =>
                                     cls -> sig
get_depth_deep_parallax_min_layers
  = runMethod @"get_depth_deep_parallax_min_layers"

get_depth_draw_mode ::
                      Method "get_depth_draw_mode" cls sig => cls -> sig
get_depth_draw_mode = runMethod @"get_depth_draw_mode"

get_depth_scale :: Method "get_depth_scale" cls sig => cls -> sig
get_depth_scale = runMethod @"get_depth_scale"

get_descent :: Method "get_descent" cls sig => cls -> sig
get_descent = runMethod @"get_descent"

get_description :: Method "get_description" cls sig => cls -> sig
get_description = runMethod @"get_description"

get_description_url ::
                      Method "get_description_url" cls sig => cls -> sig
get_description_url = runMethod @"get_description_url"

get_detail_blend_mode ::
                        Method "get_detail_blend_mode" cls sig => cls -> sig
get_detail_blend_mode = runMethod @"get_detail_blend_mode"

get_detail_sample_distance ::
                             Method "get_detail_sample_distance" cls sig => cls -> sig
get_detail_sample_distance
  = runMethod @"get_detail_sample_distance"

get_detail_sample_max_error ::
                              Method "get_detail_sample_max_error" cls sig => cls -> sig
get_detail_sample_max_error
  = runMethod @"get_detail_sample_max_error"

get_detail_uv :: Method "get_detail_uv" cls sig => cls -> sig
get_detail_uv = runMethod @"get_detail_uv"

get_device :: Method "get_device" cls sig => cls -> sig
get_device = runMethod @"get_device"

get_device_count :: Method "get_device_count" cls sig => cls -> sig
get_device_count = runMethod @"get_device_count"

get_device_list :: Method "get_device_list" cls sig => cls -> sig
get_device_list = runMethod @"get_device_list"

get_diffuse_mode :: Method "get_diffuse_mode" cls sig => cls -> sig
get_diffuse_mode = runMethod @"get_diffuse_mode"

get_direct_space_state ::
                         Method "get_direct_space_state" cls sig => cls -> sig
get_direct_space_state = runMethod @"get_direct_space_state"

get_disabled_texture ::
                       Method "get_disabled_texture" cls sig => cls -> sig
get_disabled_texture = runMethod @"get_disabled_texture"

get_discover_local_port ::
                          Method "get_discover_local_port" cls sig => cls -> sig
get_discover_local_port = runMethod @"get_discover_local_port"

get_discover_multicast_if ::
                            Method "get_discover_multicast_if" cls sig => cls -> sig
get_discover_multicast_if = runMethod @"get_discover_multicast_if"

get_dispatch_mode ::
                    Method "get_dispatch_mode" cls sig => cls -> sig
get_dispatch_mode = runMethod @"get_dispatch_mode"

get_display_mode :: Method "get_display_mode" cls sig => cls -> sig
get_display_mode = runMethod @"get_display_mode"

get_display_to_lens ::
                      Method "get_display_to_lens" cls sig => cls -> sig
get_display_to_lens = runMethod @"get_display_to_lens"

get_display_width ::
                    Method "get_display_width" cls sig => cls -> sig
get_display_width = runMethod @"get_display_width"

get_distance_fade ::
                    Method "get_distance_fade" cls sig => cls -> sig
get_distance_fade = runMethod @"get_distance_fade"

get_distance_fade_max_distance ::
                                 Method "get_distance_fade_max_distance" cls sig => cls -> sig
get_distance_fade_max_distance
  = runMethod @"get_distance_fade_max_distance"

get_distance_fade_min_distance ::
                                 Method "get_distance_fade_min_distance" cls sig => cls -> sig
get_distance_fade_min_distance
  = runMethod @"get_distance_fade_min_distance"

get_dof_blur_far_amount ::
                          Method "get_dof_blur_far_amount" cls sig => cls -> sig
get_dof_blur_far_amount = runMethod @"get_dof_blur_far_amount"

get_dof_blur_far_distance ::
                            Method "get_dof_blur_far_distance" cls sig => cls -> sig
get_dof_blur_far_distance = runMethod @"get_dof_blur_far_distance"

get_dof_blur_far_quality ::
                           Method "get_dof_blur_far_quality" cls sig => cls -> sig
get_dof_blur_far_quality = runMethod @"get_dof_blur_far_quality"

get_dof_blur_far_transition ::
                              Method "get_dof_blur_far_transition" cls sig => cls -> sig
get_dof_blur_far_transition
  = runMethod @"get_dof_blur_far_transition"

get_dof_blur_near_amount ::
                           Method "get_dof_blur_near_amount" cls sig => cls -> sig
get_dof_blur_near_amount = runMethod @"get_dof_blur_near_amount"

get_dof_blur_near_distance ::
                             Method "get_dof_blur_near_distance" cls sig => cls -> sig
get_dof_blur_near_distance
  = runMethod @"get_dof_blur_near_distance"

get_dof_blur_near_quality ::
                            Method "get_dof_blur_near_quality" cls sig => cls -> sig
get_dof_blur_near_quality = runMethod @"get_dof_blur_near_quality"

get_dof_blur_near_transition ::
                               Method "get_dof_blur_near_transition" cls sig => cls -> sig
get_dof_blur_near_transition
  = runMethod @"get_dof_blur_near_transition"

get_donor_info :: Method "get_donor_info" cls sig => cls -> sig
get_donor_info = runMethod @"get_donor_info"

get_doppler_tracking ::
                       Method "get_doppler_tracking" cls sig => cls -> sig
get_doppler_tracking = runMethod @"get_doppler_tracking"

get_double :: Method "get_double" cls sig => cls -> sig
get_double = runMethod @"get_double"

get_download_file ::
                    Method "get_download_file" cls sig => cls -> sig
get_download_file = runMethod @"get_download_file"

get_downloaded_bytes ::
                       Method "get_downloaded_bytes" cls sig => cls -> sig
get_downloaded_bytes = runMethod @"get_downloaded_bytes"

get_drag_coefficient ::
                       Method "get_drag_coefficient" cls sig => cls -> sig
get_drag_coefficient = runMethod @"get_drag_coefficient"

get_drag_data :: Method "get_drag_data" cls sig => cls -> sig
get_drag_data = runMethod @"get_drag_data"

get_drag_data_fw :: Method "get_drag_data_fw" cls sig => cls -> sig
get_drag_data_fw = runMethod @"get_drag_data_fw"

get_drag_margin :: Method "get_drag_margin" cls sig => cls -> sig
get_drag_margin = runMethod @"get_drag_margin"

get_drag_to_rearrange_enabled ::
                                Method "get_drag_to_rearrange_enabled" cls sig => cls -> sig
get_drag_to_rearrange_enabled
  = runMethod @"get_drag_to_rearrange_enabled"

get_dragger_visibility ::
                         Method "get_dragger_visibility" cls sig => cls -> sig
get_dragger_visibility = runMethod @"get_dragger_visibility"

get_draw_flag :: Method "get_draw_flag" cls sig => cls -> sig
get_draw_flag = runMethod @"get_draw_flag"

get_draw_mode :: Method "get_draw_mode" cls sig => cls -> sig
get_draw_mode = runMethod @"get_draw_mode"

get_draw_order :: Method "get_draw_order" cls sig => cls -> sig
get_draw_order = runMethod @"get_draw_order"

get_draw_pass_mesh ::
                     Method "get_draw_pass_mesh" cls sig => cls -> sig
get_draw_pass_mesh = runMethod @"get_draw_pass_mesh"

get_draw_passes :: Method "get_draw_passes" cls sig => cls -> sig
get_draw_passes = runMethod @"get_draw_passes"

get_drive :: Method "get_drive" cls sig => cls -> sig
get_drive = runMethod @"get_drive"

get_drive_count :: Method "get_drive_count" cls sig => cls -> sig
get_drive_count = runMethod @"get_drive_count"

get_drop_mode_flags ::
                      Method "get_drop_mode_flags" cls sig => cls -> sig
get_drop_mode_flags = runMethod @"get_drop_mode_flags"

get_drop_section_at_position ::
                               Method "get_drop_section_at_position" cls sig => cls -> sig
get_drop_section_at_position
  = runMethod @"get_drop_section_at_position"

get_dry :: Method "get_dry" cls sig => cls -> sig
get_dry = runMethod @"get_dry"

get_dynamic_data :: Method "get_dynamic_data" cls sig => cls -> sig
get_dynamic_data = runMethod @"get_dynamic_data"

get_dynamic_memory_usage ::
                           Method "get_dynamic_memory_usage" cls sig => cls -> sig
get_dynamic_memory_usage = runMethod @"get_dynamic_memory_usage"

get_dynamic_range ::
                    Method "get_dynamic_range" cls sig => cls -> sig
get_dynamic_range = runMethod @"get_dynamic_range"

get_edge_count :: Method "get_edge_count" cls sig => cls -> sig
get_edge_count = runMethod @"get_edge_count"

get_edge_faces :: Method "get_edge_faces" cls sig => cls -> sig
get_edge_faces = runMethod @"get_edge_faces"

get_edge_max_error ::
                     Method "get_edge_max_error" cls sig => cls -> sig
get_edge_max_error = runMethod @"get_edge_max_error"

get_edge_max_length ::
                      Method "get_edge_max_length" cls sig => cls -> sig
get_edge_max_length = runMethod @"get_edge_max_length"

get_edge_meta :: Method "get_edge_meta" cls sig => cls -> sig
get_edge_meta = runMethod @"get_edge_meta"

get_edge_vertex :: Method "get_edge_vertex" cls sig => cls -> sig
get_edge_vertex = runMethod @"get_edge_vertex"

get_edited :: Method "get_edited" cls sig => cls -> sig
get_edited = runMethod @"get_edited"

get_edited_column ::
                    Method "get_edited_column" cls sig => cls -> sig
get_edited_column = runMethod @"get_edited_column"

get_edited_object ::
                    Method "get_edited_object" cls sig => cls -> sig
get_edited_object = runMethod @"get_edited_object"

get_edited_property ::
                      Method "get_edited_property" cls sig => cls -> sig
get_edited_property = runMethod @"get_edited_property"

get_edited_scene_root ::
                        Method "get_edited_scene_root" cls sig => cls -> sig
get_edited_scene_root = runMethod @"get_edited_scene_root"

get_editor_interface ::
                       Method "get_editor_interface" cls sig => cls -> sig
get_editor_interface = runMethod @"get_editor_interface"

get_editor_settings ::
                      Method "get_editor_settings" cls sig => cls -> sig
get_editor_settings = runMethod @"get_editor_settings"

get_editor_viewport ::
                      Method "get_editor_viewport" cls sig => cls -> sig
get_editor_viewport = runMethod @"get_editor_viewport"

get_emission :: Method "get_emission" cls sig => cls -> sig
get_emission = runMethod @"get_emission"

get_emission_angle ::
                     Method "get_emission_angle" cls sig => cls -> sig
get_emission_angle = runMethod @"get_emission_angle"

get_emission_angle_filter_attenuation_db ::
                                           Method "get_emission_angle_filter_attenuation_db" cls
                                             sig =>
                                           cls -> sig
get_emission_angle_filter_attenuation_db
  = runMethod @"get_emission_angle_filter_attenuation_db"

get_emission_box_extents ::
                           Method "get_emission_box_extents" cls sig => cls -> sig
get_emission_box_extents = runMethod @"get_emission_box_extents"

get_emission_color_texture ::
                             Method "get_emission_color_texture" cls sig => cls -> sig
get_emission_color_texture
  = runMethod @"get_emission_color_texture"

get_emission_colors ::
                      Method "get_emission_colors" cls sig => cls -> sig
get_emission_colors = runMethod @"get_emission_colors"

get_emission_energy ::
                      Method "get_emission_energy" cls sig => cls -> sig
get_emission_energy = runMethod @"get_emission_energy"

get_emission_normal_texture ::
                              Method "get_emission_normal_texture" cls sig => cls -> sig
get_emission_normal_texture
  = runMethod @"get_emission_normal_texture"

get_emission_normals ::
                       Method "get_emission_normals" cls sig => cls -> sig
get_emission_normals = runMethod @"get_emission_normals"

get_emission_operator ::
                        Method "get_emission_operator" cls sig => cls -> sig
get_emission_operator = runMethod @"get_emission_operator"

get_emission_point_count ::
                           Method "get_emission_point_count" cls sig => cls -> sig
get_emission_point_count = runMethod @"get_emission_point_count"

get_emission_point_texture ::
                             Method "get_emission_point_texture" cls sig => cls -> sig
get_emission_point_texture
  = runMethod @"get_emission_point_texture"

get_emission_points ::
                      Method "get_emission_points" cls sig => cls -> sig
get_emission_points = runMethod @"get_emission_points"

get_emission_rect_extents ::
                            Method "get_emission_rect_extents" cls sig => cls -> sig
get_emission_rect_extents = runMethod @"get_emission_rect_extents"

get_emission_shape ::
                     Method "get_emission_shape" cls sig => cls -> sig
get_emission_shape = runMethod @"get_emission_shape"

get_emission_sphere_radius ::
                             Method "get_emission_sphere_radius" cls sig => cls -> sig
get_emission_sphere_radius
  = runMethod @"get_emission_sphere_radius"

get_enabled_focus_mode ::
                         Method "get_enabled_focus_mode" cls sig => cls -> sig
get_enabled_focus_mode = runMethod @"get_enabled_focus_mode"

get_enabled_inputs ::
                     Method "get_enabled_inputs" cls sig => cls -> sig
get_enabled_inputs = runMethod @"get_enabled_inputs"

get_end :: Method "get_end" cls sig => cls -> sig
get_end = runMethod @"get_end"

get_end_cap_mode :: Method "get_end_cap_mode" cls sig => cls -> sig
get_end_cap_mode = runMethod @"get_end_cap_mode"

get_end_node :: Method "get_end_node" cls sig => cls -> sig
get_end_node = runMethod @"get_end_node"

get_endian_swap :: Method "get_endian_swap" cls sig => cls -> sig
get_endian_swap = runMethod @"get_endian_swap"

get_energy :: Method "get_energy" cls sig => cls -> sig
get_energy = runMethod @"get_energy"

get_engine_force :: Method "get_engine_force" cls sig => cls -> sig
get_engine_force = runMethod @"get_engine_force"

get_environment :: Method "get_environment" cls sig => cls -> sig
get_environment = runMethod @"get_environment"

get_error :: Method "get_error" cls sig => cls -> sig
get_error = runMethod @"get_error"

get_error_line :: Method "get_error_line" cls sig => cls -> sig
get_error_line = runMethod @"get_error_line"

get_error_string :: Method "get_error_string" cls sig => cls -> sig
get_error_string = runMethod @"get_error_string"

get_error_text :: Method "get_error_text" cls sig => cls -> sig
get_error_text = runMethod @"get_error_text"

get_exclude :: Method "get_exclude" cls sig => cls -> sig
get_exclude = runMethod @"get_exclude"

get_exclude_nodes_from_collision ::
                                   Method "get_exclude_nodes_from_collision" cls sig => cls -> sig
get_exclude_nodes_from_collision
  = runMethod @"get_exclude_nodes_from_collision"

get_exclude_parent_body ::
                          Method "get_exclude_parent_body" cls sig => cls -> sig
get_exclude_parent_body = runMethod @"get_exclude_parent_body"

get_executable_path ::
                      Method "get_executable_path" cls sig => cls -> sig
get_executable_path = runMethod @"get_executable_path"

get_exit_code :: Method "get_exit_code" cls sig => cls -> sig
get_exit_code = runMethod @"get_exit_code"

get_expand :: Method "get_expand" cls sig => cls -> sig
get_expand = runMethod @"get_expand"

get_expand_margin ::
                    Method "get_expand_margin" cls sig => cls -> sig
get_expand_margin = runMethod @"get_expand_margin"

get_expand_margin_size ::
                         Method "get_expand_margin_size" cls sig => cls -> sig
get_expand_margin_size = runMethod @"get_expand_margin_size"

get_expand_right :: Method "get_expand_right" cls sig => cls -> sig
get_expand_right = runMethod @"get_expand_right"

get_expand_to_text_length ::
                            Method "get_expand_to_text_length" cls sig => cls -> sig
get_expand_to_text_length = runMethod @"get_expand_to_text_length"

get_explosiveness_ratio ::
                          Method "get_explosiveness_ratio" cls sig => cls -> sig
get_explosiveness_ratio = runMethod @"get_explosiveness_ratio"

get_extents :: Method "get_extents" cls sig => cls -> sig
get_extents = runMethod @"get_extents"

get_extra_cull_margin ::
                        Method "get_extra_cull_margin" cls sig => cls -> sig
get_extra_cull_margin = runMethod @"get_extra_cull_margin"

get_face_count :: Method "get_face_count" cls sig => cls -> sig
get_face_count = runMethod @"get_face_count"

get_face_edge :: Method "get_face_edge" cls sig => cls -> sig
get_face_edge = runMethod @"get_face_edge"

get_face_meta :: Method "get_face_meta" cls sig => cls -> sig
get_face_meta = runMethod @"get_face_meta"

get_face_normal :: Method "get_face_normal" cls sig => cls -> sig
get_face_normal = runMethod @"get_face_normal"

get_face_vertex :: Method "get_face_vertex" cls sig => cls -> sig
get_face_vertex = runMethod @"get_face_vertex"

get_faces :: Method "get_faces" cls sig => cls -> sig
get_faces = runMethod @"get_faces"

get_factor :: Method "get_factor" cls sig => cls -> sig
get_factor = runMethod @"get_factor"

get_fadein_time :: Method "get_fadein_time" cls sig => cls -> sig
get_fadein_time = runMethod @"get_fadein_time"

get_fadeout_time :: Method "get_fadeout_time" cls sig => cls -> sig
get_fadeout_time = runMethod @"get_fadeout_time"

get_fallback :: Method "get_fallback" cls sig => cls -> sig
get_fallback = runMethod @"get_fallback"

get_fallback_count ::
                     Method "get_fallback_count" cls sig => cls -> sig
get_fallback_count = runMethod @"get_fallback_count"

get_fallback_environment ::
                           Method "get_fallback_environment" cls sig => cls -> sig
get_fallback_environment = runMethod @"get_fallback_environment"

get_favorites :: Method "get_favorites" cls sig => cls -> sig
get_favorites = runMethod @"get_favorites"

get_feature :: Method "get_feature" cls sig => cls -> sig
get_feature = runMethod @"get_feature"

get_feedback :: Method "get_feedback" cls sig => cls -> sig
get_feedback = runMethod @"get_feedback"

get_feedback_delay_ms ::
                        Method "get_feedback_delay_ms" cls sig => cls -> sig
get_feedback_delay_ms = runMethod @"get_feedback_delay_ms"

get_feedback_level_db ::
                        Method "get_feedback_level_db" cls sig => cls -> sig
get_feedback_level_db = runMethod @"get_feedback_level_db"

get_feedback_lowpass ::
                       Method "get_feedback_lowpass" cls sig => cls -> sig
get_feedback_lowpass = runMethod @"get_feedback_lowpass"

get_file :: Method "get_file" cls sig => cls -> sig
get_file = runMethod @"get_file"

get_file_count :: Method "get_file_count" cls sig => cls -> sig
get_file_count = runMethod @"get_file_count"

get_file_import_is_valid ::
                           Method "get_file_import_is_valid" cls sig => cls -> sig
get_file_import_is_valid = runMethod @"get_file_import_is_valid"

get_file_path :: Method "get_file_path" cls sig => cls -> sig
get_file_path = runMethod @"get_file_path"

get_file_script_class_extends ::
                                Method "get_file_script_class_extends" cls sig => cls -> sig
get_file_script_class_extends
  = runMethod @"get_file_script_class_extends"

get_file_script_class_name ::
                             Method "get_file_script_class_name" cls sig => cls -> sig
get_file_script_class_name
  = runMethod @"get_file_script_class_name"

get_file_type :: Method "get_file_type" cls sig => cls -> sig
get_file_type = runMethod @"get_file_type"

get_filename :: Method "get_filename" cls sig => cls -> sig
get_filename = runMethod @"get_filename"

get_filesystem :: Method "get_filesystem" cls sig => cls -> sig
get_filesystem = runMethod @"get_filesystem"

get_filesystem_path ::
                      Method "get_filesystem_path" cls sig => cls -> sig
get_filesystem_path = runMethod @"get_filesystem_path"

get_fill_degrees :: Method "get_fill_degrees" cls sig => cls -> sig
get_fill_degrees = runMethod @"get_fill_degrees"

get_fill_mode :: Method "get_fill_mode" cls sig => cls -> sig
get_fill_mode = runMethod @"get_fill_mode"

get_filter_ledge_spans ::
                         Method "get_filter_ledge_spans" cls sig => cls -> sig
get_filter_ledge_spans = runMethod @"get_filter_ledge_spans"

get_filter_low_hanging_obstacles ::
                                   Method "get_filter_low_hanging_obstacles" cls sig => cls -> sig
get_filter_low_hanging_obstacles
  = runMethod @"get_filter_low_hanging_obstacles"

get_filter_walkable_low_height_spans ::
                                       Method "get_filter_walkable_low_height_spans" cls sig =>
                                       cls -> sig
get_filter_walkable_low_height_spans
  = runMethod @"get_filter_walkable_low_height_spans"

get_filters :: Method "get_filters" cls sig => cls -> sig
get_filters = runMethod @"get_filters"

get_final_transform ::
                      Method "get_final_transform" cls sig => cls -> sig
get_final_transform = runMethod @"get_final_transform"

get_fixed_column_width ::
                         Method "get_fixed_column_width" cls sig => cls -> sig
get_fixed_column_width = runMethod @"get_fixed_column_width"

get_fixed_fps :: Method "get_fixed_fps" cls sig => cls -> sig
get_fixed_fps = runMethod @"get_fixed_fps"

get_fixed_icon_size ::
                      Method "get_fixed_icon_size" cls sig => cls -> sig
get_fixed_icon_size = runMethod @"get_fixed_icon_size"

get_flag :: Method "get_flag" cls sig => cls -> sig
get_flag = runMethod @"get_flag"

get_flag_x :: Method "get_flag_x" cls sig => cls -> sig
get_flag_x = runMethod @"get_flag_x"

get_flag_y :: Method "get_flag_y" cls sig => cls -> sig
get_flag_y = runMethod @"get_flag_y"

get_flag_z :: Method "get_flag_z" cls sig => cls -> sig
get_flag_z = runMethod @"get_flag_z"

get_flags :: Method "get_flags" cls sig => cls -> sig
get_flags = runMethod @"get_flags"

get_flatness :: Method "get_flatness" cls sig => cls -> sig
get_flatness = runMethod @"get_flatness"

get_flip_faces :: Method "get_flip_faces" cls sig => cls -> sig
get_flip_faces = runMethod @"get_flip_faces"

get_float :: Method "get_float" cls sig => cls -> sig
get_float = runMethod @"get_float"

get_floor_velocity ::
                     Method "get_floor_velocity" cls sig => cls -> sig
get_floor_velocity = runMethod @"get_floor_velocity"

get_focus_mode :: Method "get_focus_mode" cls sig => cls -> sig
get_focus_mode = runMethod @"get_focus_mode"

get_focus_neighbour ::
                      Method "get_focus_neighbour" cls sig => cls -> sig
get_focus_neighbour = runMethod @"get_focus_neighbour"

get_focus_next :: Method "get_focus_next" cls sig => cls -> sig
get_focus_next = runMethod @"get_focus_next"

get_focus_owner :: Method "get_focus_owner" cls sig => cls -> sig
get_focus_owner = runMethod @"get_focus_owner"

get_focus_previous ::
                     Method "get_focus_previous" cls sig => cls -> sig
get_focus_previous = runMethod @"get_focus_previous"

get_focused_texture ::
                      Method "get_focused_texture" cls sig => cls -> sig
get_focused_texture = runMethod @"get_focused_texture"

get_fog_color :: Method "get_fog_color" cls sig => cls -> sig
get_fog_color = runMethod @"get_fog_color"

get_fog_depth_begin ::
                      Method "get_fog_depth_begin" cls sig => cls -> sig
get_fog_depth_begin = runMethod @"get_fog_depth_begin"

get_fog_depth_curve ::
                      Method "get_fog_depth_curve" cls sig => cls -> sig
get_fog_depth_curve = runMethod @"get_fog_depth_curve"

get_fog_height_curve ::
                       Method "get_fog_height_curve" cls sig => cls -> sig
get_fog_height_curve = runMethod @"get_fog_height_curve"

get_fog_height_max ::
                     Method "get_fog_height_max" cls sig => cls -> sig
get_fog_height_max = runMethod @"get_fog_height_max"

get_fog_height_min ::
                     Method "get_fog_height_min" cls sig => cls -> sig
get_fog_height_min = runMethod @"get_fog_height_min"

get_fog_sun_amount ::
                     Method "get_fog_sun_amount" cls sig => cls -> sig
get_fog_sun_amount = runMethod @"get_fog_sun_amount"

get_fog_sun_color ::
                    Method "get_fog_sun_color" cls sig => cls -> sig
get_fog_sun_color = runMethod @"get_fog_sun_color"

get_fog_transmit_curve ::
                         Method "get_fog_transmit_curve" cls sig => cls -> sig
get_fog_transmit_curve = runMethod @"get_fog_transmit_curve"

get_follow_smoothing ::
                       Method "get_follow_smoothing" cls sig => cls -> sig
get_follow_smoothing = runMethod @"get_follow_smoothing"

get_font :: Method "get_font" cls sig => cls -> sig
get_font = runMethod @"get_font"

get_font_data :: Method "get_font_data" cls sig => cls -> sig
get_font_data = runMethod @"get_font_data"

get_font_list :: Method "get_font_list" cls sig => cls -> sig
get_font_list = runMethod @"get_font_list"

get_font_path :: Method "get_font_path" cls sig => cls -> sig
get_font_path = runMethod @"get_font_path"

get_format :: Method "get_format" cls sig => cls -> sig
get_format = runMethod @"get_format"

get_fov :: Method "get_fov" cls sig => cls -> sig
get_fov = runMethod @"get_fov"

get_fps :: Method "get_fps" cls sig => cls -> sig
get_fps = runMethod @"get_fps"

get_fractional_delta ::
                       Method "get_fractional_delta" cls sig => cls -> sig
get_fractional_delta = runMethod @"get_fractional_delta"

get_frame :: Method "get_frame" cls sig => cls -> sig
get_frame = runMethod @"get_frame"

get_frame_color :: Method "get_frame_color" cls sig => cls -> sig
get_frame_color = runMethod @"get_frame_color"

get_frame_count :: Method "get_frame_count" cls sig => cls -> sig
get_frame_count = runMethod @"get_frame_count"

get_frame_delay :: Method "get_frame_delay" cls sig => cls -> sig
get_frame_delay = runMethod @"get_frame_delay"

get_frame_texture ::
                    Method "get_frame_texture" cls sig => cls -> sig
get_frame_texture = runMethod @"get_frame_texture"

get_frames :: Method "get_frames" cls sig => cls -> sig
get_frames = runMethod @"get_frames"

get_frames_drawn :: Method "get_frames_drawn" cls sig => cls -> sig
get_frames_drawn = runMethod @"get_frames_drawn"

get_frames_per_second ::
                        Method "get_frames_per_second" cls sig => cls -> sig
get_frames_per_second = runMethod @"get_frames_per_second"

get_friction :: Method "get_friction" cls sig => cls -> sig
get_friction = runMethod @"get_friction"

get_friction_slip ::
                    Method "get_friction_slip" cls sig => cls -> sig
get_friction_slip = runMethod @"get_friction_slip"

get_func :: Method "get_func" cls sig => cls -> sig
get_func = runMethod @"get_func"

get_function :: Method "get_function" cls sig => cls -> sig
get_function = runMethod @"get_function"

get_function_node_id ::
                       Method "get_function_node_id" cls sig => cls -> sig
get_function_node_id = runMethod @"get_function_node_id"

get_function_scroll ::
                      Method "get_function_scroll" cls sig => cls -> sig
get_function_scroll = runMethod @"get_function_scroll"

get_gain :: Method "get_gain" cls sig => cls -> sig
get_gain = runMethod @"get_gain"

get_gateway :: Method "get_gateway" cls sig => cls -> sig
get_gateway = runMethod @"get_gateway"

get_gizmo :: Method "get_gizmo" cls sig => cls -> sig
get_gizmo = runMethod @"get_gizmo"

get_global_canvas_transform ::
                              Method "get_global_canvas_transform" cls sig => cls -> sig
get_global_canvas_transform
  = runMethod @"get_global_canvas_transform"

get_global_constant ::
                      Method "get_global_constant" cls sig => cls -> sig
get_global_constant = runMethod @"get_global_constant"

get_global_mouse_position ::
                            Method "get_global_mouse_position" cls sig => cls -> sig
get_global_mouse_position = runMethod @"get_global_mouse_position"

get_global_position ::
                      Method "get_global_position" cls sig => cls -> sig
get_global_position = runMethod @"get_global_position"

get_global_rect :: Method "get_global_rect" cls sig => cls -> sig
get_global_rect = runMethod @"get_global_rect"

get_global_rotation ::
                      Method "get_global_rotation" cls sig => cls -> sig
get_global_rotation = runMethod @"get_global_rotation"

get_global_rotation_degrees ::
                              Method "get_global_rotation_degrees" cls sig => cls -> sig
get_global_rotation_degrees
  = runMethod @"get_global_rotation_degrees"

get_global_scale :: Method "get_global_scale" cls sig => cls -> sig
get_global_scale = runMethod @"get_global_scale"

get_global_transform ::
                       Method "get_global_transform" cls sig => cls -> sig
get_global_transform = runMethod @"get_global_transform"

get_global_transform_with_canvas ::
                                   Method "get_global_transform_with_canvas" cls sig => cls -> sig
get_global_transform_with_canvas
  = runMethod @"get_global_transform_with_canvas"

get_glow_blend_mode ::
                      Method "get_glow_blend_mode" cls sig => cls -> sig
get_glow_blend_mode = runMethod @"get_glow_blend_mode"

get_glow_bloom :: Method "get_glow_bloom" cls sig => cls -> sig
get_glow_bloom = runMethod @"get_glow_bloom"

get_glow_hdr_bleed_scale ::
                           Method "get_glow_hdr_bleed_scale" cls sig => cls -> sig
get_glow_hdr_bleed_scale = runMethod @"get_glow_hdr_bleed_scale"

get_glow_hdr_bleed_threshold ::
                               Method "get_glow_hdr_bleed_threshold" cls sig => cls -> sig
get_glow_hdr_bleed_threshold
  = runMethod @"get_glow_hdr_bleed_threshold"

get_glow_intensity ::
                     Method "get_glow_intensity" cls sig => cls -> sig
get_glow_intensity = runMethod @"get_glow_intensity"

get_glow_strength ::
                    Method "get_glow_strength" cls sig => cls -> sig
get_glow_strength = runMethod @"get_glow_strength"

get_gradient :: Method "get_gradient" cls sig => cls -> sig
get_gradient = runMethod @"get_gradient"

get_graph_offset :: Method "get_graph_offset" cls sig => cls -> sig
get_graph_offset = runMethod @"get_graph_offset"

get_gravity :: Method "get_gravity" cls sig => cls -> sig
get_gravity = runMethod @"get_gravity"

get_gravity_distance_scale ::
                             Method "get_gravity_distance_scale" cls sig => cls -> sig
get_gravity_distance_scale
  = runMethod @"get_gravity_distance_scale"

get_gravity_scale ::
                    Method "get_gravity_scale" cls sig => cls -> sig
get_gravity_scale = runMethod @"get_gravity_scale"

get_gravity_vector ::
                     Method "get_gravity_vector" cls sig => cls -> sig
get_gravity_vector = runMethod @"get_gravity_vector"

get_grid_radius :: Method "get_grid_radius" cls sig => cls -> sig
get_grid_radius = runMethod @"get_grid_radius"

get_ground_bottom_color ::
                          Method "get_ground_bottom_color" cls sig => cls -> sig
get_ground_bottom_color = runMethod @"get_ground_bottom_color"

get_ground_curve :: Method "get_ground_curve" cls sig => cls -> sig
get_ground_curve = runMethod @"get_ground_curve"

get_ground_energy ::
                    Method "get_ground_energy" cls sig => cls -> sig
get_ground_energy = runMethod @"get_ground_energy"

get_ground_horizon_color ::
                           Method "get_ground_horizon_color" cls sig => cls -> sig
get_ground_horizon_color = runMethod @"get_ground_horizon_color"

get_group_count :: Method "get_group_count" cls sig => cls -> sig
get_group_count = runMethod @"get_group_count"

get_group_name :: Method "get_group_name" cls sig => cls -> sig
get_group_name = runMethod @"get_group_name"

get_groups :: Method "get_groups" cls sig => cls -> sig
get_groups = runMethod @"get_groups"

get_grow :: Method "get_grow" cls sig => cls -> sig
get_grow = runMethod @"get_grow"

get_grow_begin :: Method "get_grow_begin" cls sig => cls -> sig
get_grow_begin = runMethod @"get_grow_begin"

get_grow_end :: Method "get_grow_end" cls sig => cls -> sig
get_grow_end = runMethod @"get_grow_end"

get_gyroscope :: Method "get_gyroscope" cls sig => cls -> sig
get_gyroscope = runMethod @"get_gyroscope"

get_h_axis_stretch_mode ::
                          Method "get_h_axis_stretch_mode" cls sig => cls -> sig
get_h_axis_stretch_mode = runMethod @"get_h_axis_stretch_mode"

get_h_frames :: Method "get_h_frames" cls sig => cls -> sig
get_h_frames = runMethod @"get_h_frames"

get_h_grow_direction ::
                       Method "get_h_grow_direction" cls sig => cls -> sig
get_h_grow_direction = runMethod @"get_h_grow_direction"

get_h_offset :: Method "get_h_offset" cls sig => cls -> sig
get_h_offset = runMethod @"get_h_offset"

get_h_scroll :: Method "get_h_scroll" cls sig => cls -> sig
get_h_scroll = runMethod @"get_h_scroll"

get_h_scrollbar :: Method "get_h_scrollbar" cls sig => cls -> sig
get_h_scrollbar = runMethod @"get_h_scrollbar"

get_h_size_flags :: Method "get_h_size_flags" cls sig => cls -> sig
get_h_size_flags = runMethod @"get_h_size_flags"

get_half_offset :: Method "get_half_offset" cls sig => cls -> sig
get_half_offset = runMethod @"get_half_offset"

get_hand :: Method "get_hand" cls sig => cls -> sig
get_hand = runMethod @"get_hand"

get_handle_name :: Method "get_handle_name" cls sig => cls -> sig
get_handle_name = runMethod @"get_handle_name"

get_handle_value :: Method "get_handle_value" cls sig => cls -> sig
get_handle_value = runMethod @"get_handle_value"

get_hdr :: Method "get_hdr" cls sig => cls -> sig
get_hdr = runMethod @"get_hdr"

get_height :: Method "get_height" cls sig => cls -> sig
get_height = runMethod @"get_height"

get_hframes :: Method "get_hframes" cls sig => cls -> sig
get_hframes = runMethod @"get_hframes"

get_hide_on_ok :: Method "get_hide_on_ok" cls sig => cls -> sig
get_hide_on_ok = runMethod @"get_hide_on_ok"

get_hinting :: Method "get_hinting" cls sig => cls -> sig
get_hinting = runMethod @"get_hinting"

get_hit_length :: Method "get_hit_length" cls sig => cls -> sig
get_hit_length = runMethod @"get_hit_length"

get_hmd_transform ::
                    Method "get_hmd_transform" cls sig => cls -> sig
get_hmd_transform = runMethod @"get_hmd_transform"

get_hover_texture ::
                    Method "get_hover_texture" cls sig => cls -> sig
get_hover_texture = runMethod @"get_hover_texture"

get_hpf :: Method "get_hpf" cls sig => cls -> sig
get_hpf = runMethod @"get_hpf"

get_http_client_status ::
                         Method "get_http_client_status" cls sig => cls -> sig
get_http_client_status = runMethod @"get_http_client_status"

get_icon :: Method "get_icon" cls sig => cls -> sig
get_icon = runMethod @"get_icon"

get_icon_list :: Method "get_icon_list" cls sig => cls -> sig
get_icon_list = runMethod @"get_icon_list"

get_icon_max_width ::
                     Method "get_icon_max_width" cls sig => cls -> sig
get_icon_max_width = runMethod @"get_icon_max_width"

get_icon_mode :: Method "get_icon_mode" cls sig => cls -> sig
get_icon_mode = runMethod @"get_icon_mode"

get_icon_region :: Method "get_icon_region" cls sig => cls -> sig
get_icon_region = runMethod @"get_icon_region"

get_icon_scale :: Method "get_icon_scale" cls sig => cls -> sig
get_icon_scale = runMethod @"get_icon_scale"

get_id :: Method "get_id" cls sig => cls -> sig
get_id = runMethod @"get_id"

get_id_path :: Method "get_id_path" cls sig => cls -> sig
get_id_path = runMethod @"get_id_path"

get_igd_control_url ::
                      Method "get_igd_control_url" cls sig => cls -> sig
get_igd_control_url = runMethod @"get_igd_control_url"

get_igd_our_addr :: Method "get_igd_our_addr" cls sig => cls -> sig
get_igd_our_addr = runMethod @"get_igd_our_addr"

get_igd_service_type ::
                       Method "get_igd_service_type" cls sig => cls -> sig
get_igd_service_type = runMethod @"get_igd_service_type"

get_igd_status :: Method "get_igd_status" cls sig => cls -> sig
get_igd_status = runMethod @"get_igd_status"

get_image :: Method "get_image" cls sig => cls -> sig
get_image = runMethod @"get_image"

get_image_path :: Method "get_image_path" cls sig => cls -> sig
get_image_path = runMethod @"get_image_path"

get_import_options ::
                     Method "get_import_options" cls sig => cls -> sig
get_import_options = runMethod @"get_import_options"

get_import_order :: Method "get_import_order" cls sig => cls -> sig
get_import_order = runMethod @"get_import_order"

get_importer_name ::
                    Method "get_importer_name" cls sig => cls -> sig
get_importer_name = runMethod @"get_importer_name"

get_incoming_connections ::
                           Method "get_incoming_connections" cls sig => cls -> sig
get_incoming_connections = runMethod @"get_incoming_connections"

get_index :: Method "get_index" cls sig => cls -> sig
get_index = runMethod @"get_index"

get_index_in_skeleton ::
                        Method "get_index_in_skeleton" cls sig => cls -> sig
get_index_in_skeleton = runMethod @"get_index_in_skeleton"

get_indexed :: Method "get_indexed" cls sig => cls -> sig
get_indexed = runMethod @"get_indexed"

get_inertia :: Method "get_inertia" cls sig => cls -> sig
get_inertia = runMethod @"get_inertia"

get_inheriters_from_class ::
                            Method "get_inheriters_from_class" cls sig => cls -> sig
get_inheriters_from_class = runMethod @"get_inheriters_from_class"

get_initial_offset ::
                     Method "get_initial_offset" cls sig => cls -> sig
get_initial_offset = runMethod @"get_initial_offset"

get_inner_radius :: Method "get_inner_radius" cls sig => cls -> sig
get_inner_radius = runMethod @"get_inner_radius"

get_input_buffer_max_size ::
                            Method "get_input_buffer_max_size" cls sig => cls -> sig
get_input_buffer_max_size = runMethod @"get_input_buffer_max_size"

get_input_caption ::
                    Method "get_input_caption" cls sig => cls -> sig
get_input_caption = runMethod @"get_input_caption"

get_input_count :: Method "get_input_count" cls sig => cls -> sig
get_input_count = runMethod @"get_input_count"

get_input_name :: Method "get_input_name" cls sig => cls -> sig
get_input_name = runMethod @"get_input_name"

get_input_port_default_value ::
                               Method "get_input_port_default_value" cls sig => cls -> sig
get_input_port_default_value
  = runMethod @"get_input_port_default_value"

get_instance_base_type ::
                         Method "get_instance_base_type" cls sig => cls -> sig
get_instance_base_type = runMethod @"get_instance_base_type"

get_instance_color ::
                     Method "get_instance_color" cls sig => cls -> sig
get_instance_color = runMethod @"get_instance_color"

get_instance_count ::
                     Method "get_instance_count" cls sig => cls -> sig
get_instance_count = runMethod @"get_instance_count"

get_instance_custom_data ::
                           Method "get_instance_custom_data" cls sig => cls -> sig
get_instance_custom_data = runMethod @"get_instance_custom_data"

get_instance_id :: Method "get_instance_id" cls sig => cls -> sig
get_instance_id = runMethod @"get_instance_id"

get_instance_path ::
                    Method "get_instance_path" cls sig => cls -> sig
get_instance_path = runMethod @"get_instance_path"

get_instance_transform ::
                         Method "get_instance_transform" cls sig => cls -> sig
get_instance_transform = runMethod @"get_instance_transform"

get_intensity :: Method "get_intensity" cls sig => cls -> sig
get_intensity = runMethod @"get_intensity"

get_interface :: Method "get_interface" cls sig => cls -> sig
get_interface = runMethod @"get_interface"

get_interface_count ::
                      Method "get_interface_count" cls sig => cls -> sig
get_interface_count = runMethod @"get_interface_count"

get_interfaces :: Method "get_interfaces" cls sig => cls -> sig
get_interfaces = runMethod @"get_interfaces"

get_interior_ambient ::
                       Method "get_interior_ambient" cls sig => cls -> sig
get_interior_ambient = runMethod @"get_interior_ambient"

get_interior_ambient_energy ::
                              Method "get_interior_ambient_energy" cls sig => cls -> sig
get_interior_ambient_energy
  = runMethod @"get_interior_ambient_energy"

get_interior_ambient_probe_contribution ::
                                          Method "get_interior_ambient_probe_contribution" cls
                                            sig =>
                                          cls -> sig
get_interior_ambient_probe_contribution
  = runMethod @"get_interior_ambient_probe_contribution"

get_interpolation ::
                    Method "get_interpolation" cls sig => cls -> sig
get_interpolation = runMethod @"get_interpolation"

get_intersections ::
                    Method "get_intersections" cls sig => cls -> sig
get_intersections = runMethod @"get_intersections"

get_inverse_inertia ::
                      Method "get_inverse_inertia" cls sig => cls -> sig
get_inverse_inertia = runMethod @"get_inverse_inertia"

get_inverse_mass :: Method "get_inverse_mass" cls sig => cls -> sig
get_inverse_mass = runMethod @"get_inverse_mass"

get_invert :: Method "get_invert" cls sig => cls -> sig
get_invert = runMethod @"get_invert"

get_invert_border ::
                    Method "get_invert_border" cls sig => cls -> sig
get_invert_border = runMethod @"get_invert_border"

get_iod :: Method "get_iod" cls sig => cls -> sig
get_iod = runMethod @"get_iod"

get_is_active :: Method "get_is_active" cls sig => cls -> sig
get_is_active = runMethod @"get_is_active"

get_is_hemisphere ::
                    Method "get_is_hemisphere" cls sig => cls -> sig
get_is_hemisphere = runMethod @"get_is_hemisphere"

get_item_accelerator ::
                       Method "get_item_accelerator" cls sig => cls -> sig
get_item_accelerator = runMethod @"get_item_accelerator"

get_item_area_rect ::
                     Method "get_item_area_rect" cls sig => cls -> sig
get_item_area_rect = runMethod @"get_item_area_rect"

get_item_at_position ::
                       Method "get_item_at_position" cls sig => cls -> sig
get_item_at_position = runMethod @"get_item_at_position"

get_item_count :: Method "get_item_count" cls sig => cls -> sig
get_item_count = runMethod @"get_item_count"

get_item_cull_mask ::
                     Method "get_item_cull_mask" cls sig => cls -> sig
get_item_cull_mask = runMethod @"get_item_cull_mask"

get_item_custom_bg_color ::
                           Method "get_item_custom_bg_color" cls sig => cls -> sig
get_item_custom_bg_color = runMethod @"get_item_custom_bg_color"

get_item_custom_fg_color ::
                           Method "get_item_custom_fg_color" cls sig => cls -> sig
get_item_custom_fg_color = runMethod @"get_item_custom_fg_color"

get_item_icon :: Method "get_item_icon" cls sig => cls -> sig
get_item_icon = runMethod @"get_item_icon"

get_item_icon_modulate ::
                         Method "get_item_icon_modulate" cls sig => cls -> sig
get_item_icon_modulate = runMethod @"get_item_icon_modulate"

get_item_icon_region ::
                       Method "get_item_icon_region" cls sig => cls -> sig
get_item_icon_region = runMethod @"get_item_icon_region"

get_item_id :: Method "get_item_id" cls sig => cls -> sig
get_item_id = runMethod @"get_item_id"

get_item_index :: Method "get_item_index" cls sig => cls -> sig
get_item_index = runMethod @"get_item_index"

get_item_list :: Method "get_item_list" cls sig => cls -> sig
get_item_list = runMethod @"get_item_list"

get_item_mesh :: Method "get_item_mesh" cls sig => cls -> sig
get_item_mesh = runMethod @"get_item_mesh"

get_item_metadata ::
                    Method "get_item_metadata" cls sig => cls -> sig
get_item_metadata = runMethod @"get_item_metadata"

get_item_name :: Method "get_item_name" cls sig => cls -> sig
get_item_name = runMethod @"get_item_name"

get_item_navmesh :: Method "get_item_navmesh" cls sig => cls -> sig
get_item_navmesh = runMethod @"get_item_navmesh"

get_item_preview :: Method "get_item_preview" cls sig => cls -> sig
get_item_preview = runMethod @"get_item_preview"

get_item_rect :: Method "get_item_rect" cls sig => cls -> sig
get_item_rect = runMethod @"get_item_rect"

get_item_shadow_cull_mask ::
                            Method "get_item_shadow_cull_mask" cls sig => cls -> sig
get_item_shadow_cull_mask = runMethod @"get_item_shadow_cull_mask"

get_item_shapes :: Method "get_item_shapes" cls sig => cls -> sig
get_item_shapes = runMethod @"get_item_shapes"

get_item_shortcut ::
                    Method "get_item_shortcut" cls sig => cls -> sig
get_item_shortcut = runMethod @"get_item_shortcut"

get_item_submenu :: Method "get_item_submenu" cls sig => cls -> sig
get_item_submenu = runMethod @"get_item_submenu"

get_item_text :: Method "get_item_text" cls sig => cls -> sig
get_item_text = runMethod @"get_item_text"

get_item_tooltip :: Method "get_item_tooltip" cls sig => cls -> sig
get_item_tooltip = runMethod @"get_item_tooltip"

get_iterations_per_second ::
                            Method "get_iterations_per_second" cls sig => cls -> sig
get_iterations_per_second = runMethod @"get_iterations_per_second"

get_joint_mode :: Method "get_joint_mode" cls sig => cls -> sig
get_joint_mode = runMethod @"get_joint_mode"

get_joint_offset :: Method "get_joint_offset" cls sig => cls -> sig
get_joint_offset = runMethod @"get_joint_offset"

get_joint_type :: Method "get_joint_type" cls sig => cls -> sig
get_joint_type = runMethod @"get_joint_type"

get_joy_axis :: Method "get_joy_axis" cls sig => cls -> sig
get_joy_axis = runMethod @"get_joy_axis"

get_joy_axis_index_from_string ::
                                 Method "get_joy_axis_index_from_string" cls sig => cls -> sig
get_joy_axis_index_from_string
  = runMethod @"get_joy_axis_index_from_string"

get_joy_axis_string ::
                      Method "get_joy_axis_string" cls sig => cls -> sig
get_joy_axis_string = runMethod @"get_joy_axis_string"

get_joy_button_index_from_string ::
                                   Method "get_joy_button_index_from_string" cls sig => cls -> sig
get_joy_button_index_from_string
  = runMethod @"get_joy_button_index_from_string"

get_joy_button_string ::
                        Method "get_joy_button_string" cls sig => cls -> sig
get_joy_button_string = runMethod @"get_joy_button_string"

get_joy_guid :: Method "get_joy_guid" cls sig => cls -> sig
get_joy_guid = runMethod @"get_joy_guid"

get_joy_id :: Method "get_joy_id" cls sig => cls -> sig
get_joy_id = runMethod @"get_joy_id"

get_joy_name :: Method "get_joy_name" cls sig => cls -> sig
get_joy_name = runMethod @"get_joy_name"

get_joy_vibration_duration ::
                             Method "get_joy_vibration_duration" cls sig => cls -> sig
get_joy_vibration_duration
  = runMethod @"get_joy_vibration_duration"

get_joy_vibration_strength ::
                             Method "get_joy_vibration_strength" cls sig => cls -> sig
get_joy_vibration_strength
  = runMethod @"get_joy_vibration_strength"

get_joystick_axis ::
                    Method "get_joystick_axis" cls sig => cls -> sig
get_joystick_axis = runMethod @"get_joystick_axis"

get_joystick_id :: Method "get_joystick_id" cls sig => cls -> sig
get_joystick_id = runMethod @"get_joystick_id"

get_k1 :: Method "get_k1" cls sig => cls -> sig
get_k1 = runMethod @"get_k1"

get_k2 :: Method "get_k2" cls sig => cls -> sig
get_k2 = runMethod @"get_k2"

get_keep_3d_linear ::
                     Method "get_keep_3d_linear" cls sig => cls -> sig
get_keep_3d_linear = runMethod @"get_keep_3d_linear"

get_keep_aspect_mode ::
                       Method "get_keep_aspect_mode" cls sig => cls -> sig
get_keep_aspect_mode = runMethod @"get_keep_aspect_mode"

get_keep_hf_hz :: Method "get_keep_hf_hz" cls sig => cls -> sig
get_keep_hf_hz = runMethod @"get_keep_hf_hz"

get_kerning_pair :: Method "get_kerning_pair" cls sig => cls -> sig
get_kerning_pair = runMethod @"get_kerning_pair"

get_keyword_color ::
                    Method "get_keyword_color" cls sig => cls -> sig
get_keyword_color = runMethod @"get_keyword_color"

get_label :: Method "get_label" cls sig => cls -> sig
get_label = runMethod @"get_label"

get_lacunarity :: Method "get_lacunarity" cls sig => cls -> sig
get_lacunarity = runMethod @"get_lacunarity"

get_last_commit_usec ::
                       Method "get_last_commit_usec" cls sig => cls -> sig
get_last_commit_usec = runMethod @"get_last_commit_usec"

get_last_frame_usec ::
                      Method "get_last_frame_usec" cls sig => cls -> sig
get_last_frame_usec = runMethod @"get_last_frame_usec"

get_last_mouse_speed ::
                       Method "get_last_mouse_speed" cls sig => cls -> sig
get_last_mouse_speed = runMethod @"get_last_mouse_speed"

get_last_packet_channel ::
                          Method "get_last_packet_channel" cls sig => cls -> sig
get_last_packet_channel = runMethod @"get_last_packet_channel"

get_last_process_usec ::
                        Method "get_last_process_usec" cls sig => cls -> sig
get_last_process_usec = runMethod @"get_last_process_usec"

get_last_unused_item_id ::
                          Method "get_last_unused_item_id" cls sig => cls -> sig
get_last_unused_item_id = runMethod @"get_last_unused_item_id"

get_last_unused_tile_id ::
                          Method "get_last_unused_tile_id" cls sig => cls -> sig
get_last_unused_tile_id = runMethod @"get_last_unused_tile_id"

get_latin_keyboard_variant ::
                             Method "get_latin_keyboard_variant" cls sig => cls -> sig
get_latin_keyboard_variant
  = runMethod @"get_latin_keyboard_variant"

get_layer :: Method "get_layer" cls sig => cls -> sig
get_layer = runMethod @"get_layer"

get_layer_data :: Method "get_layer_data" cls sig => cls -> sig
get_layer_data = runMethod @"get_layer_data"

get_layer_mask :: Method "get_layer_mask" cls sig => cls -> sig
get_layer_mask = runMethod @"get_layer_mask"

get_layer_mask_bit ::
                     Method "get_layer_mask_bit" cls sig => cls -> sig
get_layer_mask_bit = runMethod @"get_layer_mask_bit"

get_layer_range_max ::
                      Method "get_layer_range_max" cls sig => cls -> sig
get_layer_range_max = runMethod @"get_layer_range_max"

get_layer_range_min ::
                      Method "get_layer_range_min" cls sig => cls -> sig
get_layer_range_min = runMethod @"get_layer_range_min"

get_left_to_right ::
                    Method "get_left_to_right" cls sig => cls -> sig
get_left_to_right = runMethod @"get_left_to_right"

get_len :: Method "get_len" cls sig => cls -> sig
get_len = runMethod @"get_len"

get_length :: Method "get_length" cls sig => cls -> sig
get_length = runMethod @"get_length"

get_library :: Method "get_library" cls sig => cls -> sig
get_library = runMethod @"get_library"

get_license_info :: Method "get_license_info" cls sig => cls -> sig
get_license_info = runMethod @"get_license_info"

get_license_text :: Method "get_license_text" cls sig => cls -> sig
get_license_text = runMethod @"get_license_text"

get_lifetime :: Method "get_lifetime" cls sig => cls -> sig
get_lifetime = runMethod @"get_lifetime"

get_light_data :: Method "get_light_data" cls sig => cls -> sig
get_light_data = runMethod @"get_light_data"

get_light_mask :: Method "get_light_mask" cls sig => cls -> sig
get_light_mask = runMethod @"get_light_mask"

get_light_mode :: Method "get_light_mode" cls sig => cls -> sig
get_light_mode = runMethod @"get_light_mode"

get_lightmap_size_hint ::
                         Method "get_lightmap_size_hint" cls sig => cls -> sig
get_lightmap_size_hint = runMethod @"get_lightmap_size_hint"

get_limit :: Method "get_limit" cls sig => cls -> sig
get_limit = runMethod @"get_limit"

get_limit_begin :: Method "get_limit_begin" cls sig => cls -> sig
get_limit_begin = runMethod @"get_limit_begin"

get_limit_end :: Method "get_limit_end" cls sig => cls -> sig
get_limit_end = runMethod @"get_limit_end"

get_line :: Method "get_line" cls sig => cls -> sig
get_line = runMethod @"get_line"

get_line_count :: Method "get_line_count" cls sig => cls -> sig
get_line_count = runMethod @"get_line_count"

get_line_edit :: Method "get_line_edit" cls sig => cls -> sig
get_line_edit = runMethod @"get_line_edit"

get_line_height :: Method "get_line_height" cls sig => cls -> sig
get_line_height = runMethod @"get_line_height"

get_line_width :: Method "get_line_width" cls sig => cls -> sig
get_line_width = runMethod @"get_line_width"

get_linear_damp :: Method "get_linear_damp" cls sig => cls -> sig
get_linear_damp = runMethod @"get_linear_damp"

get_linear_stiffness ::
                       Method "get_linear_stiffness" cls sig => cls -> sig
get_linear_stiffness = runMethod @"get_linear_stiffness"

get_linear_velocity ::
                      Method "get_linear_velocity" cls sig => cls -> sig
get_linear_velocity = runMethod @"get_linear_velocity"

get_lines_skipped ::
                    Method "get_lines_skipped" cls sig => cls -> sig
get_lines_skipped = runMethod @"get_lines_skipped"

get_listener_transform ::
                         Method "get_listener_transform" cls sig => cls -> sig
get_listener_transform = runMethod @"get_listener_transform"

get_load_path :: Method "get_load_path" cls sig => cls -> sig
get_load_path = runMethod @"get_load_path"

get_local_addresses ::
                      Method "get_local_addresses" cls sig => cls -> sig
get_local_addresses = runMethod @"get_local_addresses"

get_local_mouse_position ::
                           Method "get_local_mouse_position" cls sig => cls -> sig
get_local_mouse_position = runMethod @"get_local_mouse_position"

get_local_scene :: Method "get_local_scene" cls sig => cls -> sig
get_local_scene = runMethod @"get_local_scene"

get_local_shape :: Method "get_local_shape" cls sig => cls -> sig
get_local_shape = runMethod @"get_local_shape"

get_locale :: Method "get_locale" cls sig => cls -> sig
get_locale = runMethod @"get_locale"

get_locale_name :: Method "get_locale_name" cls sig => cls -> sig
get_locale_name = runMethod @"get_locale_name"

get_lod_max_distance ::
                       Method "get_lod_max_distance" cls sig => cls -> sig
get_lod_max_distance = runMethod @"get_lod_max_distance"

get_lod_max_hysteresis ::
                         Method "get_lod_max_hysteresis" cls sig => cls -> sig
get_lod_max_hysteresis = runMethod @"get_lod_max_hysteresis"

get_lod_min_distance ::
                       Method "get_lod_min_distance" cls sig => cls -> sig
get_lod_min_distance = runMethod @"get_lod_min_distance"

get_lod_min_hysteresis ::
                         Method "get_lod_min_hysteresis" cls sig => cls -> sig
get_lod_min_hysteresis = runMethod @"get_lod_min_hysteresis"

get_lookahead :: Method "get_lookahead" cls sig => cls -> sig
get_lookahead = runMethod @"get_lookahead"

get_loop_begin :: Method "get_loop_begin" cls sig => cls -> sig
get_loop_begin = runMethod @"get_loop_begin"

get_loop_end :: Method "get_loop_end" cls sig => cls -> sig
get_loop_end = runMethod @"get_loop_end"

get_loop_mode :: Method "get_loop_mode" cls sig => cls -> sig
get_loop_mode = runMethod @"get_loop_mode"

get_loop_offset :: Method "get_loop_offset" cls sig => cls -> sig
get_loop_offset = runMethod @"get_loop_offset"

get_lossy_storage_quality ::
                            Method "get_lossy_storage_quality" cls sig => cls -> sig
get_lossy_storage_quality = runMethod @"get_lossy_storage_quality"

get_magnet_position ::
                      Method "get_magnet_position" cls sig => cls -> sig
get_magnet_position = runMethod @"get_magnet_position"

get_magnetometer :: Method "get_magnetometer" cls sig => cls -> sig
get_magnetometer = runMethod @"get_magnetometer"

get_main_loop :: Method "get_main_loop" cls sig => cls -> sig
get_main_loop = runMethod @"get_main_loop"

get_margin :: Method "get_margin" cls sig => cls -> sig
get_margin = runMethod @"get_margin"

get_margin_size :: Method "get_margin_size" cls sig => cls -> sig
get_margin_size = runMethod @"get_margin_size"

get_mass :: Method "get_mass" cls sig => cls -> sig
get_mass = runMethod @"get_mass"

get_master_player ::
                    Method "get_master_player" cls sig => cls -> sig
get_master_player = runMethod @"get_master_player"

get_material :: Method "get_material" cls sig => cls -> sig
get_material = runMethod @"get_material"

get_material_override ::
                        Method "get_material_override" cls sig => cls -> sig
get_material_override = runMethod @"get_material_override"

get_math_constant ::
                    Method "get_math_constant" cls sig => cls -> sig
get_math_constant = runMethod @"get_math_constant"

get_max :: Method "get_max" cls sig => cls -> sig
get_max = runMethod @"get_max"

get_max_columns :: Method "get_max_columns" cls sig => cls -> sig
get_max_columns = runMethod @"get_max_columns"

get_max_contacts_reported ::
                            Method "get_max_contacts_reported" cls sig => cls -> sig
get_max_contacts_reported = runMethod @"get_max_contacts_reported"

get_max_db :: Method "get_max_db" cls sig => cls -> sig
get_max_db = runMethod @"get_max_db"

get_max_distance :: Method "get_max_distance" cls sig => cls -> sig
get_max_distance = runMethod @"get_max_distance"

get_max_iterations ::
                     Method "get_max_iterations" cls sig => cls -> sig
get_max_iterations = runMethod @"get_max_iterations"

get_max_length :: Method "get_max_length" cls sig => cls -> sig
get_max_length = runMethod @"get_max_length"

get_max_lines_visible ::
                        Method "get_max_lines_visible" cls sig => cls -> sig
get_max_lines_visible = runMethod @"get_max_lines_visible"

get_max_redirects ::
                    Method "get_max_redirects" cls sig => cls -> sig
get_max_redirects = runMethod @"get_max_redirects"

get_max_space :: Method "get_max_space" cls sig => cls -> sig
get_max_space = runMethod @"get_max_space"

get_max_text_lines ::
                     Method "get_max_text_lines" cls sig => cls -> sig
get_max_text_lines = runMethod @"get_max_text_lines"

get_max_value :: Method "get_max_value" cls sig => cls -> sig
get_max_value = runMethod @"get_max_value"

get_md5 :: Method "get_md5" cls sig => cls -> sig
get_md5 = runMethod @"get_md5"

get_menu :: Method "get_menu" cls sig => cls -> sig
get_menu = runMethod @"get_menu"

get_mesh :: Method "get_mesh" cls sig => cls -> sig
get_mesh = runMethod @"get_mesh"

get_mesh_arrays :: Method "get_mesh_arrays" cls sig => cls -> sig
get_mesh_arrays = runMethod @"get_mesh_arrays"

get_mesh_library :: Method "get_mesh_library" cls sig => cls -> sig
get_mesh_library = runMethod @"get_mesh_library"

get_meshes :: Method "get_meshes" cls sig => cls -> sig
get_meshes = runMethod @"get_meshes"

get_message :: Method "get_message" cls sig => cls -> sig
get_message = runMethod @"get_message"

get_message_count ::
                    Method "get_message_count" cls sig => cls -> sig
get_message_count = runMethod @"get_message_count"

get_message_list :: Method "get_message_list" cls sig => cls -> sig
get_message_list = runMethod @"get_message_list"

get_meta :: Method "get_meta" cls sig => cls -> sig
get_meta = runMethod @"get_meta"

get_meta_list :: Method "get_meta_list" cls sig => cls -> sig
get_meta_list = runMethod @"get_meta_list"

get_metadata :: Method "get_metadata" cls sig => cls -> sig
get_metadata = runMethod @"get_metadata"

get_metakey :: Method "get_metakey" cls sig => cls -> sig
get_metakey = runMethod @"get_metakey"

get_metallic :: Method "get_metallic" cls sig => cls -> sig
get_metallic = runMethod @"get_metallic"

get_metallic_texture_channel ::
                               Method "get_metallic_texture_channel" cls sig => cls -> sig
get_metallic_texture_channel
  = runMethod @"get_metallic_texture_channel"

get_method_documentation ::
                           Method "get_method_documentation" cls sig => cls -> sig
get_method_documentation = runMethod @"get_method_documentation"

get_method_list :: Method "get_method_list" cls sig => cls -> sig
get_method_list = runMethod @"get_method_list"

get_mid_height :: Method "get_mid_height" cls sig => cls -> sig
get_mid_height = runMethod @"get_mid_height"

get_min :: Method "get_min" cls sig => cls -> sig
get_min = runMethod @"get_min"

get_min_distance :: Method "get_min_distance" cls sig => cls -> sig
get_min_distance = runMethod @"get_min_distance"

get_min_space :: Method "get_min_space" cls sig => cls -> sig
get_min_space = runMethod @"get_min_space"

get_min_value :: Method "get_min_value" cls sig => cls -> sig
get_min_value = runMethod @"get_min_value"

get_minimum_size :: Method "get_minimum_size" cls sig => cls -> sig
get_minimum_size = runMethod @"get_minimum_size"

get_mipmap_offset ::
                    Method "get_mipmap_offset" cls sig => cls -> sig
get_mipmap_offset = runMethod @"get_mipmap_offset"

get_mirroring :: Method "get_mirroring" cls sig => cls -> sig
get_mirroring = runMethod @"get_mirroring"

get_mix :: Method "get_mix" cls sig => cls -> sig
get_mix = runMethod @"get_mix"

get_mix_mode :: Method "get_mix_mode" cls sig => cls -> sig
get_mix_mode = runMethod @"get_mix_mode"

get_mix_rate :: Method "get_mix_rate" cls sig => cls -> sig
get_mix_rate = runMethod @"get_mix_rate"

get_mix_target :: Method "get_mix_target" cls sig => cls -> sig
get_mix_target = runMethod @"get_mix_target"

get_modal_stack_top ::
                      Method "get_modal_stack_top" cls sig => cls -> sig
get_modal_stack_top = runMethod @"get_modal_stack_top"

get_mode :: Method "get_mode" cls sig => cls -> sig
get_mode = runMethod @"get_mode"

get_model_name :: Method "get_model_name" cls sig => cls -> sig
get_model_name = runMethod @"get_model_name"

get_modified_time ::
                    Method "get_modified_time" cls sig => cls -> sig
get_modified_time = runMethod @"get_modified_time"

get_modulate :: Method "get_modulate" cls sig => cls -> sig
get_modulate = runMethod @"get_modulate"

get_monitor :: Method "get_monitor" cls sig => cls -> sig
get_monitor = runMethod @"get_monitor"

get_motion :: Method "get_motion" cls sig => cls -> sig
get_motion = runMethod @"get_motion"

get_motion_offset ::
                    Method "get_motion_offset" cls sig => cls -> sig
get_motion_offset = runMethod @"get_motion_offset"

get_motion_remainder ::
                       Method "get_motion_remainder" cls sig => cls -> sig
get_motion_remainder = runMethod @"get_motion_remainder"

get_motion_scale :: Method "get_motion_scale" cls sig => cls -> sig
get_motion_scale = runMethod @"get_motion_scale"

get_mouse_button_mask ::
                        Method "get_mouse_button_mask" cls sig => cls -> sig
get_mouse_button_mask = runMethod @"get_mouse_button_mask"

get_mouse_filter :: Method "get_mouse_filter" cls sig => cls -> sig
get_mouse_filter = runMethod @"get_mouse_filter"

get_mouse_mode :: Method "get_mouse_mode" cls sig => cls -> sig
get_mouse_mode = runMethod @"get_mouse_mode"

get_mouse_position ::
                     Method "get_mouse_position" cls sig => cls -> sig
get_mouse_position = runMethod @"get_mouse_position"

get_msaa :: Method "get_msaa" cls sig => cls -> sig
get_msaa = runMethod @"get_msaa"

get_multimesh :: Method "get_multimesh" cls sig => cls -> sig
get_multimesh = runMethod @"get_multimesh"

get_multiplayer :: Method "get_multiplayer" cls sig => cls -> sig
get_multiplayer = runMethod @"get_multiplayer"

get_name :: Method "get_name" cls sig => cls -> sig
get_name = runMethod @"get_name"

get_named_attribute_value ::
                            Method "get_named_attribute_value" cls sig => cls -> sig
get_named_attribute_value = runMethod @"get_named_attribute_value"

get_named_attribute_value_safe ::
                                 Method "get_named_attribute_value_safe" cls sig => cls -> sig
get_named_attribute_value_safe
  = runMethod @"get_named_attribute_value_safe"

get_names :: Method "get_names" cls sig => cls -> sig
get_names = runMethod @"get_names"

get_navigation_mesh ::
                      Method "get_navigation_mesh" cls sig => cls -> sig
get_navigation_mesh = runMethod @"get_navigation_mesh"

get_navigation_polygon ::
                         Method "get_navigation_polygon" cls sig => cls -> sig
get_navigation_polygon = runMethod @"get_navigation_polygon"

get_network_connected_peers ::
                              Method "get_network_connected_peers" cls sig => cls -> sig
get_network_connected_peers
  = runMethod @"get_network_connected_peers"

get_network_master ::
                     Method "get_network_master" cls sig => cls -> sig
get_network_master = runMethod @"get_network_master"

get_network_peer :: Method "get_network_peer" cls sig => cls -> sig
get_network_peer = runMethod @"get_network_peer"

get_network_unique_id ::
                        Method "get_network_unique_id" cls sig => cls -> sig
get_network_unique_id = runMethod @"get_network_unique_id"

get_next :: Method "get_next" cls sig => cls -> sig
get_next = runMethod @"get_next"

get_next_pass :: Method "get_next_pass" cls sig => cls -> sig
get_next_pass = runMethod @"get_next_pass"

get_next_selected ::
                    Method "get_next_selected" cls sig => cls -> sig
get_next_selected = runMethod @"get_next_selected"

get_next_visible :: Method "get_next_visible" cls sig => cls -> sig
get_next_visible = runMethod @"get_next_visible"

get_nine_patch_stretch ::
                         Method "get_nine_patch_stretch" cls sig => cls -> sig
get_nine_patch_stretch = runMethod @"get_nine_patch_stretch"

get_node :: Method "get_node" cls sig => cls -> sig
get_node = runMethod @"get_node"

get_node_a :: Method "get_node_a" cls sig => cls -> sig
get_node_a = runMethod @"get_node_a"

get_node_and_resource ::
                        Method "get_node_and_resource" cls sig => cls -> sig
get_node_and_resource = runMethod @"get_node_and_resource"

get_node_b :: Method "get_node_b" cls sig => cls -> sig
get_node_b = runMethod @"get_node_b"

get_node_connections ::
                       Method "get_node_connections" cls sig => cls -> sig
get_node_connections = runMethod @"get_node_connections"

get_node_count :: Method "get_node_count" cls sig => cls -> sig
get_node_count = runMethod @"get_node_count"

get_node_data :: Method "get_node_data" cls sig => cls -> sig
get_node_data = runMethod @"get_node_data"

get_node_groups :: Method "get_node_groups" cls sig => cls -> sig
get_node_groups = runMethod @"get_node_groups"

get_node_index :: Method "get_node_index" cls sig => cls -> sig
get_node_index = runMethod @"get_node_index"

get_node_instance ::
                    Method "get_node_instance" cls sig => cls -> sig
get_node_instance = runMethod @"get_node_instance"

get_node_instance_placeholder ::
                                Method "get_node_instance_placeholder" cls sig => cls -> sig
get_node_instance_placeholder
  = runMethod @"get_node_instance_placeholder"

get_node_list :: Method "get_node_list" cls sig => cls -> sig
get_node_list = runMethod @"get_node_list"

get_node_name :: Method "get_node_name" cls sig => cls -> sig
get_node_name = runMethod @"get_node_name"

get_node_offset :: Method "get_node_offset" cls sig => cls -> sig
get_node_offset = runMethod @"get_node_offset"

get_node_owner_path ::
                      Method "get_node_owner_path" cls sig => cls -> sig
get_node_owner_path = runMethod @"get_node_owner_path"

get_node_path :: Method "get_node_path" cls sig => cls -> sig
get_node_path = runMethod @"get_node_path"

get_node_position ::
                    Method "get_node_position" cls sig => cls -> sig
get_node_position = runMethod @"get_node_position"

get_node_property_count ::
                          Method "get_node_property_count" cls sig => cls -> sig
get_node_property_count = runMethod @"get_node_property_count"

get_node_property_name ::
                         Method "get_node_property_name" cls sig => cls -> sig
get_node_property_name = runMethod @"get_node_property_name"

get_node_property_value ::
                          Method "get_node_property_value" cls sig => cls -> sig
get_node_property_value = runMethod @"get_node_property_value"

get_node_type :: Method "get_node_type" cls sig => cls -> sig
get_node_type = runMethod @"get_node_type"

get_nodes_in_group ::
                     Method "get_nodes_in_group" cls sig => cls -> sig
get_nodes_in_group = runMethod @"get_nodes_in_group"

get_noise :: Method "get_noise" cls sig => cls -> sig
get_noise = runMethod @"get_noise"

get_noise_2d :: Method "get_noise_2d" cls sig => cls -> sig
get_noise_2d = runMethod @"get_noise_2d"

get_noise_2dv :: Method "get_noise_2dv" cls sig => cls -> sig
get_noise_2dv = runMethod @"get_noise_2dv"

get_noise_3d :: Method "get_noise_3d" cls sig => cls -> sig
get_noise_3d = runMethod @"get_noise_3d"

get_noise_3dv :: Method "get_noise_3dv" cls sig => cls -> sig
get_noise_3dv = runMethod @"get_noise_3dv"

get_noise_4d :: Method "get_noise_4d" cls sig => cls -> sig
get_noise_4d = runMethod @"get_noise_4d"

get_normal :: Method "get_normal" cls sig => cls -> sig
get_normal = runMethod @"get_normal"

get_normal_bias :: Method "get_normal_bias" cls sig => cls -> sig
get_normal_bias = runMethod @"get_normal_bias"

get_normal_map :: Method "get_normal_map" cls sig => cls -> sig
get_normal_map = runMethod @"get_normal_map"

get_normal_scale :: Method "get_normal_scale" cls sig => cls -> sig
get_normal_scale = runMethod @"get_normal_scale"

get_normal_texture ::
                     Method "get_normal_texture" cls sig => cls -> sig
get_normal_texture = runMethod @"get_normal_texture"

get_normalmap :: Method "get_normalmap" cls sig => cls -> sig
get_normalmap = runMethod @"get_normalmap"

get_object_id :: Method "get_object_id" cls sig => cls -> sig
get_object_id = runMethod @"get_object_id"

get_occluder_light_mask ::
                          Method "get_occluder_light_mask" cls sig => cls -> sig
get_occluder_light_mask = runMethod @"get_occluder_light_mask"

get_occluder_polygon ::
                       Method "get_occluder_polygon" cls sig => cls -> sig
get_occluder_polygon = runMethod @"get_occluder_polygon"

get_octant_size :: Method "get_octant_size" cls sig => cls -> sig
get_octant_size = runMethod @"get_octant_size"

get_octaves :: Method "get_octaves" cls sig => cls -> sig
get_octaves = runMethod @"get_octaves"

get_octree :: Method "get_octree" cls sig => cls -> sig
get_octree = runMethod @"get_octree"

get_offset :: Method "get_offset" cls sig => cls -> sig
get_offset = runMethod @"get_offset"

get_offset_buttons_visible ::
                             Method "get_offset_buttons_visible" cls sig => cls -> sig
get_offset_buttons_visible
  = runMethod @"get_offset_buttons_visible"

get_offsets :: Method "get_offsets" cls sig => cls -> sig
get_offsets = runMethod @"get_offsets"

get_ok :: Method "get_ok" cls sig => cls -> sig
get_ok = runMethod @"get_ok"

get_one_shot :: Method "get_one_shot" cls sig => cls -> sig
get_one_shot = runMethod @"get_one_shot"

get_opacity :: Method "get_opacity" cls sig => cls -> sig
get_opacity = runMethod @"get_opacity"

get_open_scenes :: Method "get_open_scenes" cls sig => cls -> sig
get_open_scenes = runMethod @"get_open_scenes"

get_open_scripts :: Method "get_open_scripts" cls sig => cls -> sig
get_open_scripts = runMethod @"get_open_scripts"

get_operation :: Method "get_operation" cls sig => cls -> sig
get_operation = runMethod @"get_operation"

get_operator :: Method "get_operator" cls sig => cls -> sig
get_operator = runMethod @"get_operator"

get_option_visibility ::
                        Method "get_option_visibility" cls sig => cls -> sig
get_option_visibility = runMethod @"get_option_visibility"

get_order :: Method "get_order" cls sig => cls -> sig
get_order = runMethod @"get_order"

get_orientation :: Method "get_orientation" cls sig => cls -> sig
get_orientation = runMethod @"get_orientation"

get_origin_offset ::
                    Method "get_origin_offset" cls sig => cls -> sig
get_origin_offset = runMethod @"get_origin_offset"

get_out_of_range_mode ::
                        Method "get_out_of_range_mode" cls sig => cls -> sig
get_out_of_range_mode = runMethod @"get_out_of_range_mode"

get_outer_radius :: Method "get_outer_radius" cls sig => cls -> sig
get_outer_radius = runMethod @"get_outer_radius"

get_outline :: Method "get_outline" cls sig => cls -> sig
get_outline = runMethod @"get_outline"

get_outline_color ::
                    Method "get_outline_color" cls sig => cls -> sig
get_outline_color = runMethod @"get_outline_color"

get_outline_count ::
                    Method "get_outline_count" cls sig => cls -> sig
get_outline_count = runMethod @"get_outline_count"

get_outline_size :: Method "get_outline_size" cls sig => cls -> sig
get_outline_size = runMethod @"get_outline_size"

get_output_buffer_max_size ::
                             Method "get_output_buffer_max_size" cls sig => cls -> sig
get_output_buffer_max_size
  = runMethod @"get_output_buffer_max_size"

get_output_port_for_preview ::
                              Method "get_output_port_for_preview" cls sig => cls -> sig
get_output_port_for_preview
  = runMethod @"get_output_port_for_preview"

get_over_texture :: Method "get_over_texture" cls sig => cls -> sig
get_over_texture = runMethod @"get_over_texture"

get_overlapping_areas ::
                        Method "get_overlapping_areas" cls sig => cls -> sig
get_overlapping_areas = runMethod @"get_overlapping_areas"

get_overlapping_bodies ::
                         Method "get_overlapping_bodies" cls sig => cls -> sig
get_overlapping_bodies = runMethod @"get_overlapping_bodies"

get_overlay :: Method "get_overlay" cls sig => cls -> sig
get_overlay = runMethod @"get_overlay"

get_oversample :: Method "get_oversample" cls sig => cls -> sig
get_oversample = runMethod @"get_oversample"

get_owner :: Method "get_owner" cls sig => cls -> sig
get_owner = runMethod @"get_owner"

get_packet :: Method "get_packet" cls sig => cls -> sig
get_packet = runMethod @"get_packet"

get_packet_channel ::
                     Method "get_packet_channel" cls sig => cls -> sig
get_packet_channel = runMethod @"get_packet_channel"

get_packet_error :: Method "get_packet_error" cls sig => cls -> sig
get_packet_error = runMethod @"get_packet_error"

get_packet_ip :: Method "get_packet_ip" cls sig => cls -> sig
get_packet_ip = runMethod @"get_packet_ip"

get_packet_peer :: Method "get_packet_peer" cls sig => cls -> sig
get_packet_peer = runMethod @"get_packet_peer"

get_packet_port :: Method "get_packet_port" cls sig => cls -> sig
get_packet_port = runMethod @"get_packet_port"

get_page :: Method "get_page" cls sig => cls -> sig
get_page = runMethod @"get_page"

get_pan :: Method "get_pan" cls sig => cls -> sig
get_pan = runMethod @"get_pan"

get_pan_pullout :: Method "get_pan_pullout" cls sig => cls -> sig
get_pan_pullout = runMethod @"get_pan_pullout"

get_panorama :: Method "get_panorama" cls sig => cls -> sig
get_panorama = runMethod @"get_panorama"

get_param :: Method "get_param" cls sig => cls -> sig
get_param = runMethod @"get_param"

get_param_curve :: Method "get_param_curve" cls sig => cls -> sig
get_param_curve = runMethod @"get_param_curve"

get_param_randomness ::
                       Method "get_param_randomness" cls sig => cls -> sig
get_param_randomness = runMethod @"get_param_randomness"

get_param_texture ::
                    Method "get_param_texture" cls sig => cls -> sig
get_param_texture = runMethod @"get_param_texture"

get_param_x :: Method "get_param_x" cls sig => cls -> sig
get_param_x = runMethod @"get_param_x"

get_param_y :: Method "get_param_y" cls sig => cls -> sig
get_param_y = runMethod @"get_param_y"

get_param_z :: Method "get_param_z" cls sig => cls -> sig
get_param_z = runMethod @"get_param_z"

get_parameter :: Method "get_parameter" cls sig => cls -> sig
get_parameter = runMethod @"get_parameter"

get_parent :: Method "get_parent" cls sig => cls -> sig
get_parent = runMethod @"get_parent"

get_parent_area_size ::
                       Method "get_parent_area_size" cls sig => cls -> sig
get_parent_area_size = runMethod @"get_parent_area_size"

get_parent_class :: Method "get_parent_class" cls sig => cls -> sig
get_parent_class = runMethod @"get_parent_class"

get_parent_collision_ignore ::
                              Method "get_parent_collision_ignore" cls sig => cls -> sig
get_parent_collision_ignore
  = runMethod @"get_parent_collision_ignore"

get_parent_control ::
                     Method "get_parent_control" cls sig => cls -> sig
get_parent_control = runMethod @"get_parent_control"

get_parent_skeleton ::
                      Method "get_parent_skeleton" cls sig => cls -> sig
get_parent_skeleton = runMethod @"get_parent_skeleton"

get_parent_spatial ::
                     Method "get_parent_spatial" cls sig => cls -> sig
get_parent_spatial = runMethod @"get_parent_spatial"

get_partial_data :: Method "get_partial_data" cls sig => cls -> sig
get_partial_data = runMethod @"get_partial_data"

get_particle_flag ::
                    Method "get_particle_flag" cls sig => cls -> sig
get_particle_flag = runMethod @"get_particle_flag"

get_particles_anim_h_frames ::
                              Method "get_particles_anim_h_frames" cls sig => cls -> sig
get_particles_anim_h_frames
  = runMethod @"get_particles_anim_h_frames"

get_particles_anim_loop ::
                          Method "get_particles_anim_loop" cls sig => cls -> sig
get_particles_anim_loop = runMethod @"get_particles_anim_loop"

get_particles_anim_v_frames ::
                              Method "get_particles_anim_v_frames" cls sig => cls -> sig
get_particles_anim_v_frames
  = runMethod @"get_particles_anim_v_frames"

get_pascal_string ::
                    Method "get_pascal_string" cls sig => cls -> sig
get_pascal_string = runMethod @"get_pascal_string"

get_patch_margin :: Method "get_patch_margin" cls sig => cls -> sig
get_patch_margin = runMethod @"get_patch_margin"

get_path :: Method "get_path" cls sig => cls -> sig
get_path = runMethod @"get_path"

get_path_absolute ::
                    Method "get_path_absolute" cls sig => cls -> sig
get_path_absolute = runMethod @"get_path_absolute"

get_path_interval ::
                    Method "get_path_interval" cls sig => cls -> sig
get_path_interval = runMethod @"get_path_interval"

get_path_node :: Method "get_path_node" cls sig => cls -> sig
get_path_node = runMethod @"get_path_node"

get_path_rotation ::
                    Method "get_path_rotation" cls sig => cls -> sig
get_path_rotation = runMethod @"get_path_rotation"

get_path_to :: Method "get_path_to" cls sig => cls -> sig
get_path_to = runMethod @"get_path_to"

get_pattern :: Method "get_pattern" cls sig => cls -> sig
get_pattern = runMethod @"get_pattern"

get_pause_mode :: Method "get_pause_mode" cls sig => cls -> sig
get_pause_mode = runMethod @"get_pause_mode"

get_peer :: Method "get_peer" cls sig => cls -> sig
get_peer = runMethod @"get_peer"

get_peer_address :: Method "get_peer_address" cls sig => cls -> sig
get_peer_address = runMethod @"get_peer_address"

get_peer_port :: Method "get_peer_port" cls sig => cls -> sig
get_peer_port = runMethod @"get_peer_port"

get_percent_visible ::
                      Method "get_percent_visible" cls sig => cls -> sig
get_percent_visible = runMethod @"get_percent_visible"

get_period :: Method "get_period" cls sig => cls -> sig
get_period = runMethod @"get_period"

get_persistence :: Method "get_persistence" cls sig => cls -> sig
get_persistence = runMethod @"get_persistence"

get_physics_jitter_fix ::
                         Method "get_physics_jitter_fix" cls sig => cls -> sig
get_physics_jitter_fix = runMethod @"get_physics_jitter_fix"

get_physics_material_override ::
                                Method "get_physics_material_override" cls sig => cls -> sig
get_physics_material_override
  = runMethod @"get_physics_material_override"

get_physics_object_picking ::
                             Method "get_physics_object_picking" cls sig => cls -> sig
get_physics_object_picking
  = runMethod @"get_physics_object_picking"

get_physics_process_delta_time ::
                                 Method "get_physics_process_delta_time" cls sig => cls -> sig
get_physics_process_delta_time
  = runMethod @"get_physics_process_delta_time"

get_pick_color :: Method "get_pick_color" cls sig => cls -> sig
get_pick_color = runMethod @"get_pick_color"

get_picker :: Method "get_picker" cls sig => cls -> sig
get_picker = runMethod @"get_picker"

get_piece_count :: Method "get_piece_count" cls sig => cls -> sig
get_piece_count = runMethod @"get_piece_count"

get_piece_offset :: Method "get_piece_offset" cls sig => cls -> sig
get_piece_offset = runMethod @"get_piece_offset"

get_piece_texture ::
                    Method "get_piece_texture" cls sig => cls -> sig
get_piece_texture = runMethod @"get_piece_texture"

get_pitch_scale :: Method "get_pitch_scale" cls sig => cls -> sig
get_pitch_scale = runMethod @"get_pitch_scale"

get_pivot_offset :: Method "get_pivot_offset" cls sig => cls -> sig
get_pivot_offset = runMethod @"get_pivot_offset"

get_pixel :: Method "get_pixel" cls sig => cls -> sig
get_pixel = runMethod @"get_pixel"

get_pixel_size :: Method "get_pixel_size" cls sig => cls -> sig
get_pixel_size = runMethod @"get_pixel_size"

get_pixelv :: Method "get_pixelv" cls sig => cls -> sig
get_pixelv = runMethod @"get_pixelv"

get_placeholder :: Method "get_placeholder" cls sig => cls -> sig
get_placeholder = runMethod @"get_placeholder"

get_placeholder_alpha ::
                        Method "get_placeholder_alpha" cls sig => cls -> sig
get_placeholder_alpha = runMethod @"get_placeholder_alpha"

get_plane :: Method "get_plane" cls sig => cls -> sig
get_plane = runMethod @"get_plane"

get_playback_position ::
                        Method "get_playback_position" cls sig => cls -> sig
get_playback_position = runMethod @"get_playback_position"

get_playback_time ::
                    Method "get_playback_time" cls sig => cls -> sig
get_playback_time = runMethod @"get_playback_time"

get_playing_speed ::
                    Method "get_playing_speed" cls sig => cls -> sig
get_playing_speed = runMethod @"get_playing_speed"

get_plugin_icon :: Method "get_plugin_icon" cls sig => cls -> sig
get_plugin_icon = runMethod @"get_plugin_icon"

get_plugin_name :: Method "get_plugin_name" cls sig => cls -> sig
get_plugin_name = runMethod @"get_plugin_name"

get_point_connections ::
                        Method "get_point_connections" cls sig => cls -> sig
get_point_connections = runMethod @"get_point_connections"

get_point_count :: Method "get_point_count" cls sig => cls -> sig
get_point_count = runMethod @"get_point_count"

get_point_in :: Method "get_point_in" cls sig => cls -> sig
get_point_in = runMethod @"get_point_in"

get_point_left_mode ::
                      Method "get_point_left_mode" cls sig => cls -> sig
get_point_left_mode = runMethod @"get_point_left_mode"

get_point_left_tangent ::
                         Method "get_point_left_tangent" cls sig => cls -> sig
get_point_left_tangent = runMethod @"get_point_left_tangent"

get_point_out :: Method "get_point_out" cls sig => cls -> sig
get_point_out = runMethod @"get_point_out"

get_point_path :: Method "get_point_path" cls sig => cls -> sig
get_point_path = runMethod @"get_point_path"

get_point_penalty ::
                    Method "get_point_penalty" cls sig => cls -> sig
get_point_penalty = runMethod @"get_point_penalty"

get_point_position ::
                     Method "get_point_position" cls sig => cls -> sig
get_point_position = runMethod @"get_point_position"

get_point_right_mode ::
                       Method "get_point_right_mode" cls sig => cls -> sig
get_point_right_mode = runMethod @"get_point_right_mode"

get_point_right_tangent ::
                          Method "get_point_right_tangent" cls sig => cls -> sig
get_point_right_tangent = runMethod @"get_point_right_tangent"

get_point_size :: Method "get_point_size" cls sig => cls -> sig
get_point_size = runMethod @"get_point_size"

get_point_tilt :: Method "get_point_tilt" cls sig => cls -> sig
get_point_tilt = runMethod @"get_point_tilt"

get_point_weight_scale ::
                         Method "get_point_weight_scale" cls sig => cls -> sig
get_point_weight_scale = runMethod @"get_point_weight_scale"

get_points :: Method "get_points" cls sig => cls -> sig
get_points = runMethod @"get_points"

get_polygon :: Method "get_polygon" cls sig => cls -> sig
get_polygon = runMethod @"get_polygon"

get_polygon_count ::
                    Method "get_polygon_count" cls sig => cls -> sig
get_polygon_count = runMethod @"get_polygon_count"

get_popup :: Method "get_popup" cls sig => cls -> sig
get_popup = runMethod @"get_popup"

get_pose_matching_coefficient ::
                                Method "get_pose_matching_coefficient" cls sig => cls -> sig
get_pose_matching_coefficient
  = runMethod @"get_pose_matching_coefficient"

get_position :: Method "get_position" cls sig => cls -> sig
get_position = runMethod @"get_position"

get_position_in_parent ::
                         Method "get_position_in_parent" cls sig => cls -> sig
get_position_in_parent = runMethod @"get_position_in_parent"

get_post_gain :: Method "get_post_gain" cls sig => cls -> sig
get_post_gain = runMethod @"get_post_gain"

get_power_percent_left ::
                         Method "get_power_percent_left" cls sig => cls -> sig
get_power_percent_left = runMethod @"get_power_percent_left"

get_power_seconds_left ::
                         Method "get_power_seconds_left" cls sig => cls -> sig
get_power_seconds_left = runMethod @"get_power_seconds_left"

get_power_state :: Method "get_power_state" cls sig => cls -> sig
get_power_state = runMethod @"get_power_state"

get_pre_gain :: Method "get_pre_gain" cls sig => cls -> sig
get_pre_gain = runMethod @"get_pre_gain"

get_pre_process_time ::
                       Method "get_pre_process_time" cls sig => cls -> sig
get_pre_process_time = runMethod @"get_pre_process_time"

get_predelay_feedback ::
                        Method "get_predelay_feedback" cls sig => cls -> sig
get_predelay_feedback = runMethod @"get_predelay_feedback"

get_predelay_msec ::
                    Method "get_predelay_msec" cls sig => cls -> sig
get_predelay_msec = runMethod @"get_predelay_msec"

get_prefix :: Method "get_prefix" cls sig => cls -> sig
get_prefix = runMethod @"get_prefix"

get_preload :: Method "get_preload" cls sig => cls -> sig
get_preload = runMethod @"get_preload"

get_preset_count :: Method "get_preset_count" cls sig => cls -> sig
get_preset_count = runMethod @"get_preset_count"

get_preset_name :: Method "get_preset_name" cls sig => cls -> sig
get_preset_name = runMethod @"get_preset_name"

get_pressed_button ::
                     Method "get_pressed_button" cls sig => cls -> sig
get_pressed_button = runMethod @"get_pressed_button"

get_pressed_texture ::
                      Method "get_pressed_texture" cls sig => cls -> sig
get_pressed_texture = runMethod @"get_pressed_texture"

get_pressure :: Method "get_pressure" cls sig => cls -> sig
get_pressure = runMethod @"get_pressure"

get_pressure_coefficient ::
                           Method "get_pressure_coefficient" cls sig => cls -> sig
get_pressure_coefficient = runMethod @"get_pressure_coefficient"

get_prev :: Method "get_prev" cls sig => cls -> sig
get_prev = runMethod @"get_prev"

get_prev_visible :: Method "get_prev_visible" cls sig => cls -> sig
get_prev_visible = runMethod @"get_prev_visible"

get_previous_tab :: Method "get_previous_tab" cls sig => cls -> sig
get_previous_tab = runMethod @"get_previous_tab"

get_primary_interface ::
                        Method "get_primary_interface" cls sig => cls -> sig
get_primary_interface = runMethod @"get_primary_interface"

get_principal_inertia_axes ::
                             Method "get_principal_inertia_axes" cls sig => cls -> sig
get_principal_inertia_axes
  = runMethod @"get_principal_inertia_axes"

get_priority :: Method "get_priority" cls sig => cls -> sig
get_priority = runMethod @"get_priority"

get_probe_data :: Method "get_probe_data" cls sig => cls -> sig
get_probe_data = runMethod @"get_probe_data"

get_process_delta_time ::
                         Method "get_process_delta_time" cls sig => cls -> sig
get_process_delta_time = runMethod @"get_process_delta_time"

get_process_id :: Method "get_process_id" cls sig => cls -> sig
get_process_id = runMethod @"get_process_id"

get_process_info :: Method "get_process_info" cls sig => cls -> sig
get_process_info = runMethod @"get_process_info"

get_process_material ::
                       Method "get_process_material" cls sig => cls -> sig
get_process_material = runMethod @"get_process_material"

get_process_mode :: Method "get_process_mode" cls sig => cls -> sig
get_process_mode = runMethod @"get_process_mode"

get_processor_count ::
                      Method "get_processor_count" cls sig => cls -> sig
get_processor_count = runMethod @"get_processor_count"

get_progress_texture ::
                       Method "get_progress_texture" cls sig => cls -> sig
get_progress_texture = runMethod @"get_progress_texture"

get_project_metadata ::
                       Method "get_project_metadata" cls sig => cls -> sig
get_project_metadata = runMethod @"get_project_metadata"

get_project_settings_dir ::
                           Method "get_project_settings_dir" cls sig => cls -> sig
get_project_settings_dir = runMethod @"get_project_settings_dir"

get_projection :: Method "get_projection" cls sig => cls -> sig
get_projection = runMethod @"get_projection"

get_propagation :: Method "get_propagation" cls sig => cls -> sig
get_propagation = runMethod @"get_propagation"

get_property :: Method "get_property" cls sig => cls -> sig
get_property = runMethod @"get_property"

get_property_documentation ::
                             Method "get_property_documentation" cls sig => cls -> sig
get_property_documentation
  = runMethod @"get_property_documentation"

get_property_list ::
                    Method "get_property_list" cls sig => cls -> sig
get_property_list = runMethod @"get_property_list"

get_proximity_fade_distance ::
                              Method "get_proximity_fade_distance" cls sig => cls -> sig
get_proximity_fade_distance
  = runMethod @"get_proximity_fade_distance"

get_quadrant_size ::
                    Method "get_quadrant_size" cls sig => cls -> sig
get_quadrant_size = runMethod @"get_quadrant_size"

get_radial_center_offset ::
                           Method "get_radial_center_offset" cls sig => cls -> sig
get_radial_center_offset = runMethod @"get_radial_center_offset"

get_radial_initial_angle ::
                           Method "get_radial_initial_angle" cls sig => cls -> sig
get_radial_initial_angle = runMethod @"get_radial_initial_angle"

get_radial_segments ::
                      Method "get_radial_segments" cls sig => cls -> sig
get_radial_segments = runMethod @"get_radial_segments"

get_radiance_size ::
                    Method "get_radiance_size" cls sig => cls -> sig
get_radiance_size = runMethod @"get_radiance_size"

get_radius :: Method "get_radius" cls sig => cls -> sig
get_radius = runMethod @"get_radius"

get_random_pitch :: Method "get_random_pitch" cls sig => cls -> sig
get_random_pitch = runMethod @"get_random_pitch"

get_randomness_ratio ::
                       Method "get_randomness_ratio" cls sig => cls -> sig
get_randomness_ratio = runMethod @"get_randomness_ratio"

get_range :: Method "get_range" cls sig => cls -> sig
get_range = runMethod @"get_range"

get_range_config :: Method "get_range_config" cls sig => cls -> sig
get_range_config = runMethod @"get_range_config"

get_range_max_hz :: Method "get_range_max_hz" cls sig => cls -> sig
get_range_max_hz = runMethod @"get_range_max_hz"

get_range_min_hz :: Method "get_range_min_hz" cls sig => cls -> sig
get_range_min_hz = runMethod @"get_range_min_hz"

get_rate_hz :: Method "get_rate_hz" cls sig => cls -> sig
get_rate_hz = runMethod @"get_rate_hz"

get_ratio :: Method "get_ratio" cls sig => cls -> sig
get_ratio = runMethod @"get_ratio"

get_real :: Method "get_real" cls sig => cls -> sig
get_real = runMethod @"get_real"

get_real_window_size ::
                       Method "get_real_window_size" cls sig => cls -> sig
get_real_window_size = runMethod @"get_real_window_size"

get_recent_dirs :: Method "get_recent_dirs" cls sig => cls -> sig
get_recent_dirs = runMethod @"get_recent_dirs"

get_recognized_extensions ::
                            Method "get_recognized_extensions" cls sig => cls -> sig
get_recognized_extensions = runMethod @"get_recognized_extensions"

get_recognized_extensions_for_type ::
                                     Method "get_recognized_extensions_for_type" cls sig =>
                                     cls -> sig
get_recognized_extensions_for_type
  = runMethod @"get_recognized_extensions_for_type"

get_recording :: Method "get_recording" cls sig => cls -> sig
get_recording = runMethod @"get_recording"

get_rect :: Method "get_rect" cls sig => cls -> sig
get_rect = runMethod @"get_rect"

get_ref :: Method "get_ref" cls sig => cls -> sig
get_ref = runMethod @"get_ref"

get_reference_frame ::
                      Method "get_reference_frame" cls sig => cls -> sig
get_reference_frame = runMethod @"get_reference_frame"

get_refraction :: Method "get_refraction" cls sig => cls -> sig
get_refraction = runMethod @"get_refraction"

get_refraction_texture_channel ::
                                 Method "get_refraction_texture_channel" cls sig => cls -> sig
get_refraction_texture_channel
  = runMethod @"get_refraction_texture_channel"

get_region :: Method "get_region" cls sig => cls -> sig
get_region = runMethod @"get_region"

get_region_merge_size ::
                        Method "get_region_merge_size" cls sig => cls -> sig
get_region_merge_size = runMethod @"get_region_merge_size"

get_region_min_size ::
                      Method "get_region_min_size" cls sig => cls -> sig
get_region_min_size = runMethod @"get_region_min_size"

get_region_rect :: Method "get_region_rect" cls sig => cls -> sig
get_region_rect = runMethod @"get_region_rect"

get_relative :: Method "get_relative" cls sig => cls -> sig
get_relative = runMethod @"get_relative"

get_relative_transform_to_parent ::
                                   Method "get_relative_transform_to_parent" cls sig => cls -> sig
get_relative_transform_to_parent
  = runMethod @"get_relative_transform_to_parent"

get_release_ms :: Method "get_release_ms" cls sig => cls -> sig
get_release_ms = runMethod @"get_release_ms"

get_remainder :: Method "get_remainder" cls sig => cls -> sig
get_remainder = runMethod @"get_remainder"

get_remote_node :: Method "get_remote_node" cls sig => cls -> sig
get_remote_node = runMethod @"get_remote_node"

get_render_info :: Method "get_render_info" cls sig => cls -> sig
get_render_info = runMethod @"get_render_info"

get_render_priority ::
                      Method "get_render_priority" cls sig => cls -> sig
get_render_priority = runMethod @"get_render_priority"

get_render_targetsize ::
                        Method "get_render_targetsize" cls sig => cls -> sig
get_render_targetsize = runMethod @"get_render_targetsize"

get_resizable :: Method "get_resizable" cls sig => cls -> sig
get_resizable = runMethod @"get_resizable"

get_resolve_item_address ::
                           Method "get_resolve_item_address" cls sig => cls -> sig
get_resolve_item_address = runMethod @"get_resolve_item_address"

get_resolve_item_status ::
                          Method "get_resolve_item_status" cls sig => cls -> sig
get_resolve_item_status = runMethod @"get_resolve_item_status"

get_resonance :: Method "get_resonance" cls sig => cls -> sig
get_resonance = runMethod @"get_resonance"

get_resource :: Method "get_resource" cls sig => cls -> sig
get_resource = runMethod @"get_resource"

get_resource_filesystem ::
                          Method "get_resource_filesystem" cls sig => cls -> sig
get_resource_filesystem = runMethod @"get_resource_filesystem"

get_resource_list ::
                    Method "get_resource_list" cls sig => cls -> sig
get_resource_list = runMethod @"get_resource_list"

get_resource_path ::
                    Method "get_resource_path" cls sig => cls -> sig
get_resource_path = runMethod @"get_resource_path"

get_resource_previewer ::
                         Method "get_resource_previewer" cls sig => cls -> sig
get_resource_previewer = runMethod @"get_resource_previewer"

get_resource_type ::
                    Method "get_resource_type" cls sig => cls -> sig
get_resource_type = runMethod @"get_resource_type"

get_response_body_length ::
                           Method "get_response_body_length" cls sig => cls -> sig
get_response_body_length = runMethod @"get_response_body_length"

get_response_code ::
                    Method "get_response_code" cls sig => cls -> sig
get_response_code = runMethod @"get_response_code"

get_response_headers ::
                       Method "get_response_headers" cls sig => cls -> sig
get_response_headers = runMethod @"get_response_headers"

get_response_headers_as_dictionary ::
                                     Method "get_response_headers_as_dictionary" cls sig =>
                                     cls -> sig
get_response_headers_as_dictionary
  = runMethod @"get_response_headers_as_dictionary"

get_rest :: Method "get_rest" cls sig => cls -> sig
get_rest = runMethod @"get_rest"

get_rest_info :: Method "get_rest_info" cls sig => cls -> sig
get_rest_info = runMethod @"get_rest_info"

get_rest_length :: Method "get_rest_length" cls sig => cls -> sig
get_rest_length = runMethod @"get_rest_length"

get_result :: Method "get_result" cls sig => cls -> sig
get_result = runMethod @"get_result"

get_result_count :: Method "get_result_count" cls sig => cls -> sig
get_result_count = runMethod @"get_result_count"

get_result_object ::
                    Method "get_result_object" cls sig => cls -> sig
get_result_object = runMethod @"get_result_object"

get_result_object_id ::
                       Method "get_result_object_id" cls sig => cls -> sig
get_result_object_id = runMethod @"get_result_object_id"

get_result_object_shape ::
                          Method "get_result_object_shape" cls sig => cls -> sig
get_result_object_shape = runMethod @"get_result_object_shape"

get_result_rid :: Method "get_result_rid" cls sig => cls -> sig
get_result_rid = runMethod @"get_result_rid"

get_return_type :: Method "get_return_type" cls sig => cls -> sig
get_return_type = runMethod @"get_return_type"

get_reverb_amount ::
                    Method "get_reverb_amount" cls sig => cls -> sig
get_reverb_amount = runMethod @"get_reverb_amount"

get_reverb_bus :: Method "get_reverb_bus" cls sig => cls -> sig
get_reverb_bus = runMethod @"get_reverb_bus"

get_reverb_uniformity ::
                        Method "get_reverb_uniformity" cls sig => cls -> sig
get_reverb_uniformity = runMethod @"get_reverb_uniformity"

get_rid :: Method "get_rid" cls sig => cls -> sig
get_rid = runMethod @"get_rid"

get_rim :: Method "get_rim" cls sig => cls -> sig
get_rim = runMethod @"get_rim"

get_rim_tint :: Method "get_rim_tint" cls sig => cls -> sig
get_rim_tint = runMethod @"get_rim_tint"

get_ring_sides :: Method "get_ring_sides" cls sig => cls -> sig
get_ring_sides = runMethod @"get_ring_sides"

get_rings :: Method "get_rings" cls sig => cls -> sig
get_rings = runMethod @"get_rings"

get_roll_influence ::
                     Method "get_roll_influence" cls sig => cls -> sig
get_roll_influence = runMethod @"get_roll_influence"

get_room_size :: Method "get_room_size" cls sig => cls -> sig
get_room_size = runMethod @"get_room_size"

get_root :: Method "get_root" cls sig => cls -> sig
get_root = runMethod @"get_root"

get_root_bone :: Method "get_root_bone" cls sig => cls -> sig
get_root_bone = runMethod @"get_root_bone"

get_root_motion_track ::
                        Method "get_root_motion_track" cls sig => cls -> sig
get_root_motion_track = runMethod @"get_root_motion_track"

get_root_motion_transform ::
                            Method "get_root_motion_transform" cls sig => cls -> sig
get_root_motion_transform = runMethod @"get_root_motion_transform"

get_rotation :: Method "get_rotation" cls sig => cls -> sig
get_rotation = runMethod @"get_rotation"

get_rotation_degrees ::
                       Method "get_rotation_degrees" cls sig => cls -> sig
get_rotation_degrees = runMethod @"get_rotation_degrees"

get_rotation_mode ::
                    Method "get_rotation_mode" cls sig => cls -> sig
get_rotation_mode = runMethod @"get_rotation_mode"

get_roughness :: Method "get_roughness" cls sig => cls -> sig
get_roughness = runMethod @"get_roughness"

get_roughness_texture_channel ::
                                Method "get_roughness_texture_channel" cls sig => cls -> sig
get_roughness_texture_channel
  = runMethod @"get_roughness_texture_channel"

get_round_precision ::
                      Method "get_round_precision" cls sig => cls -> sig
get_round_precision = runMethod @"get_round_precision"

get_rpc_call_mode ::
                    Method "get_rpc_call_mode" cls sig => cls -> sig
get_rpc_call_mode = runMethod @"get_rpc_call_mode"

get_rpc_sender_id ::
                    Method "get_rpc_sender_id" cls sig => cls -> sig
get_rpc_sender_id = runMethod @"get_rpc_sender_id"

get_rumble :: Method "get_rumble" cls sig => cls -> sig
get_rumble = runMethod @"get_rumble"

get_runtime :: Method "get_runtime" cls sig => cls -> sig
get_runtime = runMethod @"get_runtime"

get_safe_margin :: Method "get_safe_margin" cls sig => cls -> sig
get_safe_margin = runMethod @"get_safe_margin"

get_sample_partition_type ::
                            Method "get_sample_partition_type" cls sig => cls -> sig
get_sample_partition_type = runMethod @"get_sample_partition_type"

get_save_extension ::
                     Method "get_save_extension" cls sig => cls -> sig
get_save_extension = runMethod @"get_save_extension"

get_scale :: Method "get_scale" cls sig => cls -> sig
get_scale = runMethod @"get_scale"

get_scancode :: Method "get_scancode" cls sig => cls -> sig
get_scancode = runMethod @"get_scancode"

get_scancode_string ::
                      Method "get_scancode_string" cls sig => cls -> sig
get_scancode_string = runMethod @"get_scancode_string"

get_scancode_with_modifiers ::
                              Method "get_scancode_with_modifiers" cls sig => cls -> sig
get_scancode_with_modifiers
  = runMethod @"get_scancode_with_modifiers"

get_scanning_progress ::
                        Method "get_scanning_progress" cls sig => cls -> sig
get_scanning_progress = runMethod @"get_scanning_progress"

get_scenario :: Method "get_scenario" cls sig => cls -> sig
get_scenario = runMethod @"get_scenario"

get_scene :: Method "get_scene" cls sig => cls -> sig
get_scene = runMethod @"get_scene"

get_scene_instance_load_placeholder ::
                                      Method "get_scene_instance_load_placeholder" cls sig =>
                                      cls -> sig
get_scene_instance_load_placeholder
  = runMethod @"get_scene_instance_load_placeholder"

get_screen_count :: Method "get_screen_count" cls sig => cls -> sig
get_screen_count = runMethod @"get_screen_count"

get_screen_dpi :: Method "get_screen_dpi" cls sig => cls -> sig
get_screen_dpi = runMethod @"get_screen_dpi"

get_screen_orientation ::
                         Method "get_screen_orientation" cls sig => cls -> sig
get_screen_orientation = runMethod @"get_screen_orientation"

get_screen_position ::
                      Method "get_screen_position" cls sig => cls -> sig
get_screen_position = runMethod @"get_screen_position"

get_screen_size :: Method "get_screen_size" cls sig => cls -> sig
get_screen_size = runMethod @"get_screen_size"

get_script :: Method "get_script" cls sig => cls -> sig
get_script = runMethod @"get_script"

get_script_class_icon_path ::
                             Method "get_script_class_icon_path" cls sig => cls -> sig
get_script_class_icon_path
  = runMethod @"get_script_class_icon_path"

get_script_class_name ::
                        Method "get_script_class_name" cls sig => cls -> sig
get_script_class_name = runMethod @"get_script_class_name"

get_script_create_dialog ::
                           Method "get_script_create_dialog" cls sig => cls -> sig
get_script_create_dialog = runMethod @"get_script_create_dialog"

get_script_editor ::
                    Method "get_script_editor" cls sig => cls -> sig
get_script_editor = runMethod @"get_script_editor"

get_scroll :: Method "get_scroll" cls sig => cls -> sig
get_scroll = runMethod @"get_scroll"

get_scroll_base_offset ::
                         Method "get_scroll_base_offset" cls sig => cls -> sig
get_scroll_base_offset = runMethod @"get_scroll_base_offset"

get_scroll_base_scale ::
                        Method "get_scroll_base_scale" cls sig => cls -> sig
get_scroll_base_scale = runMethod @"get_scroll_base_scale"

get_scroll_offset ::
                    Method "get_scroll_offset" cls sig => cls -> sig
get_scroll_offset = runMethod @"get_scroll_offset"

get_scroll_ofs :: Method "get_scroll_ofs" cls sig => cls -> sig
get_scroll_ofs = runMethod @"get_scroll_ofs"

get_scrolling_enabled ::
                        Method "get_scrolling_enabled" cls sig => cls -> sig
get_scrolling_enabled = runMethod @"get_scrolling_enabled"

get_seamless :: Method "get_seamless" cls sig => cls -> sig
get_seamless = runMethod @"get_seamless"

get_seamless_image ::
                     Method "get_seamless_image" cls sig => cls -> sig
get_seamless_image = runMethod @"get_seamless_image"

get_secret_character ::
                       Method "get_secret_character" cls sig => cls -> sig
get_secret_character = runMethod @"get_secret_character"

get_section_keys :: Method "get_section_keys" cls sig => cls -> sig
get_section_keys = runMethod @"get_section_keys"

get_sections :: Method "get_sections" cls sig => cls -> sig
get_sections = runMethod @"get_sections"

get_seed :: Method "get_seed" cls sig => cls -> sig
get_seed = runMethod @"get_seed"

get_segments :: Method "get_segments" cls sig => cls -> sig
get_segments = runMethod @"get_segments"

get_select_mode :: Method "get_select_mode" cls sig => cls -> sig
get_select_mode = runMethod @"get_select_mode"

get_select_with_rmb ::
                      Method "get_select_with_rmb" cls sig => cls -> sig
get_select_with_rmb = runMethod @"get_select_with_rmb"

get_selected :: Method "get_selected" cls sig => cls -> sig
get_selected = runMethod @"get_selected"

get_selected_column ::
                      Method "get_selected_column" cls sig => cls -> sig
get_selected_column = runMethod @"get_selected_column"

get_selected_id :: Method "get_selected_id" cls sig => cls -> sig
get_selected_id = runMethod @"get_selected_id"

get_selected_items ::
                     Method "get_selected_items" cls sig => cls -> sig
get_selected_items = runMethod @"get_selected_items"

get_selected_metadata ::
                        Method "get_selected_metadata" cls sig => cls -> sig
get_selected_metadata = runMethod @"get_selected_metadata"

get_selected_nodes ::
                     Method "get_selected_nodes" cls sig => cls -> sig
get_selected_nodes = runMethod @"get_selected_nodes"

get_selected_path ::
                    Method "get_selected_path" cls sig => cls -> sig
get_selected_path = runMethod @"get_selected_path"

get_selection :: Method "get_selection" cls sig => cls -> sig
get_selection = runMethod @"get_selection"

get_selection_from_column ::
                            Method "get_selection_from_column" cls sig => cls -> sig
get_selection_from_column = runMethod @"get_selection_from_column"

get_selection_from_line ::
                          Method "get_selection_from_line" cls sig => cls -> sig
get_selection_from_line = runMethod @"get_selection_from_line"

get_selection_text ::
                     Method "get_selection_text" cls sig => cls -> sig
get_selection_text = runMethod @"get_selection_text"

get_selection_to_column ::
                          Method "get_selection_to_column" cls sig => cls -> sig
get_selection_to_column = runMethod @"get_selection_to_column"

get_selection_to_line ::
                        Method "get_selection_to_line" cls sig => cls -> sig
get_selection_to_line = runMethod @"get_selection_to_line"

get_self_modulate ::
                    Method "get_self_modulate" cls sig => cls -> sig
get_self_modulate = runMethod @"get_self_modulate"

get_service_type :: Method "get_service_type" cls sig => cls -> sig
get_service_type = runMethod @"get_service_type"

get_setting :: Method "get_setting" cls sig => cls -> sig
get_setting = runMethod @"get_setting"

get_settings_dir :: Method "get_settings_dir" cls sig => cls -> sig
get_settings_dir = runMethod @"get_settings_dir"

get_sha256 :: Method "get_sha256" cls sig => cls -> sig
get_sha256 = runMethod @"get_sha256"

get_shader :: Method "get_shader" cls sig => cls -> sig
get_shader = runMethod @"get_shader"

get_shader_param :: Method "get_shader_param" cls sig => cls -> sig
get_shader_param = runMethod @"get_shader_param"

get_shadow_atlas_quadrant_subdiv ::
                                   Method "get_shadow_atlas_quadrant_subdiv" cls sig => cls -> sig
get_shadow_atlas_quadrant_subdiv
  = runMethod @"get_shadow_atlas_quadrant_subdiv"

get_shadow_atlas_size ::
                        Method "get_shadow_atlas_size" cls sig => cls -> sig
get_shadow_atlas_size = runMethod @"get_shadow_atlas_size"

get_shadow_buffer_size ::
                         Method "get_shadow_buffer_size" cls sig => cls -> sig
get_shadow_buffer_size = runMethod @"get_shadow_buffer_size"

get_shadow_color :: Method "get_shadow_color" cls sig => cls -> sig
get_shadow_color = runMethod @"get_shadow_color"

get_shadow_depth_range ::
                         Method "get_shadow_depth_range" cls sig => cls -> sig
get_shadow_depth_range = runMethod @"get_shadow_depth_range"

get_shadow_detail ::
                    Method "get_shadow_detail" cls sig => cls -> sig
get_shadow_detail = runMethod @"get_shadow_detail"

get_shadow_filter ::
                    Method "get_shadow_filter" cls sig => cls -> sig
get_shadow_filter = runMethod @"get_shadow_filter"

get_shadow_gradient_length ::
                             Method "get_shadow_gradient_length" cls sig => cls -> sig
get_shadow_gradient_length
  = runMethod @"get_shadow_gradient_length"

get_shadow_mode :: Method "get_shadow_mode" cls sig => cls -> sig
get_shadow_mode = runMethod @"get_shadow_mode"

get_shadow_reverse_cull_face ::
                               Method "get_shadow_reverse_cull_face" cls sig => cls -> sig
get_shadow_reverse_cull_face
  = runMethod @"get_shadow_reverse_cull_face"

get_shadow_size :: Method "get_shadow_size" cls sig => cls -> sig
get_shadow_size = runMethod @"get_shadow_size"

get_shadow_smooth ::
                    Method "get_shadow_smooth" cls sig => cls -> sig
get_shadow_smooth = runMethod @"get_shadow_smooth"

get_shape :: Method "get_shape" cls sig => cls -> sig
get_shape = runMethod @"get_shape"

get_shape_owners :: Method "get_shape_owners" cls sig => cls -> sig
get_shape_owners = runMethod @"get_shape_owners"

get_shape_rid :: Method "get_shape_rid" cls sig => cls -> sig
get_shape_rid = runMethod @"get_shape_rid"

get_sharp_limit :: Method "get_sharp_limit" cls sig => cls -> sig
get_sharp_limit = runMethod @"get_sharp_limit"

get_shift :: Method "get_shift" cls sig => cls -> sig
get_shift = runMethod @"get_shift"

get_shortcut :: Method "get_shortcut" cls sig => cls -> sig
get_shortcut = runMethod @"get_shortcut"

get_side :: Method "get_side" cls sig => cls -> sig
get_side = runMethod @"get_side"

get_sidechain :: Method "get_sidechain" cls sig => cls -> sig
get_sidechain = runMethod @"get_sidechain"

get_sides :: Method "get_sides" cls sig => cls -> sig
get_sides = runMethod @"get_sides"

get_signal :: Method "get_signal" cls sig => cls -> sig
get_signal = runMethod @"get_signal"

get_signal_connection_list ::
                             Method "get_signal_connection_list" cls sig => cls -> sig
get_signal_connection_list
  = runMethod @"get_signal_connection_list"

get_signal_documentation ::
                           Method "get_signal_documentation" cls sig => cls -> sig
get_signal_documentation = runMethod @"get_signal_documentation"

get_signal_list :: Method "get_signal_list" cls sig => cls -> sig
get_signal_list = runMethod @"get_signal_list"

get_simple_path :: Method "get_simple_path" cls sig => cls -> sig
get_simple_path = runMethod @"get_simple_path"

get_simulate_physics ::
                       Method "get_simulate_physics" cls sig => cls -> sig
get_simulate_physics = runMethod @"get_simulate_physics"

get_simulation_precision ::
                           Method "get_simulation_precision" cls sig => cls -> sig
get_simulation_precision = runMethod @"get_simulation_precision"

get_singleton :: Method "get_singleton" cls sig => cls -> sig
get_singleton = runMethod @"get_singleton"

get_size :: Method "get_size" cls sig => cls -> sig
get_size = runMethod @"get_size"

get_size_override ::
                    Method "get_size_override" cls sig => cls -> sig
get_size_override = runMethod @"get_size_override"

get_skeleton :: Method "get_skeleton" cls sig => cls -> sig
get_skeleton = runMethod @"get_skeleton"

get_skeleton_path ::
                    Method "get_skeleton_path" cls sig => cls -> sig
get_skeleton_path = runMethod @"get_skeleton_path"

get_skeleton_rest ::
                    Method "get_skeleton_rest" cls sig => cls -> sig
get_skeleton_rest = runMethod @"get_skeleton_rest"

get_skidinfo :: Method "get_skidinfo" cls sig => cls -> sig
get_skidinfo = runMethod @"get_skidinfo"

get_sky :: Method "get_sky" cls sig => cls -> sig
get_sky = runMethod @"get_sky"

get_sky_curve :: Method "get_sky_curve" cls sig => cls -> sig
get_sky_curve = runMethod @"get_sky_curve"

get_sky_custom_fov ::
                     Method "get_sky_custom_fov" cls sig => cls -> sig
get_sky_custom_fov = runMethod @"get_sky_custom_fov"

get_sky_energy :: Method "get_sky_energy" cls sig => cls -> sig
get_sky_energy = runMethod @"get_sky_energy"

get_sky_horizon_color ::
                        Method "get_sky_horizon_color" cls sig => cls -> sig
get_sky_horizon_color = runMethod @"get_sky_horizon_color"

get_sky_top_color ::
                    Method "get_sky_top_color" cls sig => cls -> sig
get_sky_top_color = runMethod @"get_sky_top_color"

get_slide_collision ::
                      Method "get_slide_collision" cls sig => cls -> sig
get_slide_collision = runMethod @"get_slide_collision"

get_slide_count :: Method "get_slide_count" cls sig => cls -> sig
get_slide_count = runMethod @"get_slide_count"

get_slips_on_slope ::
                     Method "get_slips_on_slope" cls sig => cls -> sig
get_slips_on_slope = runMethod @"get_slips_on_slope"

get_slot_color_left ::
                      Method "get_slot_color_left" cls sig => cls -> sig
get_slot_color_left = runMethod @"get_slot_color_left"

get_slot_color_right ::
                       Method "get_slot_color_right" cls sig => cls -> sig
get_slot_color_right = runMethod @"get_slot_color_right"

get_slot_type_left ::
                     Method "get_slot_type_left" cls sig => cls -> sig
get_slot_type_left = runMethod @"get_slot_type_left"

get_slot_type_right ::
                      Method "get_slot_type_right" cls sig => cls -> sig
get_slot_type_right = runMethod @"get_slot_type_right"

get_smooth_faces :: Method "get_smooth_faces" cls sig => cls -> sig
get_smooth_faces = runMethod @"get_smooth_faces"

get_snap :: Method "get_snap" cls sig => cls -> sig
get_snap = runMethod @"get_snap"

get_soft_clip_db :: Method "get_soft_clip_db" cls sig => cls -> sig
get_soft_clip_db = runMethod @"get_soft_clip_db"

get_soft_clip_ratio ::
                      Method "get_soft_clip_ratio" cls sig => cls -> sig
get_soft_clip_ratio = runMethod @"get_soft_clip_ratio"

get_softness :: Method "get_softness" cls sig => cls -> sig
get_softness = runMethod @"get_softness"

get_solver_priority ::
                      Method "get_solver_priority" cls sig => cls -> sig
get_solver_priority = runMethod @"get_solver_priority"

get_source :: Method "get_source" cls sig => cls -> sig
get_source = runMethod @"get_source"

get_source_code :: Method "get_source_code" cls sig => cls -> sig
get_source_code = runMethod @"get_source_code"

get_source_file :: Method "get_source_file" cls sig => cls -> sig
get_source_file = runMethod @"get_source_file"

get_source_folder ::
                    Method "get_source_folder" cls sig => cls -> sig
get_source_folder = runMethod @"get_source_folder"

get_space :: Method "get_space" cls sig => cls -> sig
get_space = runMethod @"get_space"

get_space_left :: Method "get_space_left" cls sig => cls -> sig
get_space_left = runMethod @"get_space_left"

get_space_override_mode ::
                          Method "get_space_override_mode" cls sig => cls -> sig
get_space_override_mode = runMethod @"get_space_override_mode"

get_space_state :: Method "get_space_state" cls sig => cls -> sig
get_space_state = runMethod @"get_space_state"

get_spacing :: Method "get_spacing" cls sig => cls -> sig
get_spacing = runMethod @"get_spacing"

get_speaker_mode :: Method "get_speaker_mode" cls sig => cls -> sig
get_speaker_mode = runMethod @"get_speaker_mode"

get_specular :: Method "get_specular" cls sig => cls -> sig
get_specular = runMethod @"get_specular"

get_specular_mode ::
                    Method "get_specular_mode" cls sig => cls -> sig
get_specular_mode = runMethod @"get_specular_mode"

get_speed :: Method "get_speed" cls sig => cls -> sig
get_speed = runMethod @"get_speed"

get_speed_scale :: Method "get_speed_scale" cls sig => cls -> sig
get_speed_scale = runMethod @"get_speed_scale"

get_spin_degrees :: Method "get_spin_degrees" cls sig => cls -> sig
get_spin_degrees = runMethod @"get_spin_degrees"

get_spin_sides :: Method "get_spin_sides" cls sig => cls -> sig
get_spin_sides = runMethod @"get_spin_sides"

get_splash_tick_msec ::
                       Method "get_splash_tick_msec" cls sig => cls -> sig
get_splash_tick_msec = runMethod @"get_splash_tick_msec"

get_split_offset :: Method "get_split_offset" cls sig => cls -> sig
get_split_offset = runMethod @"get_split_offset"

get_splits :: Method "get_splits" cls sig => cls -> sig
get_splits = runMethod @"get_splits"

get_spread :: Method "get_spread" cls sig => cls -> sig
get_spread = runMethod @"get_spread"

get_sprite_frames ::
                    Method "get_sprite_frames" cls sig => cls -> sig
get_sprite_frames = runMethod @"get_sprite_frames"

get_ssao_ao_channel_affect ::
                             Method "get_ssao_ao_channel_affect" cls sig => cls -> sig
get_ssao_ao_channel_affect
  = runMethod @"get_ssao_ao_channel_affect"

get_ssao_bias :: Method "get_ssao_bias" cls sig => cls -> sig
get_ssao_bias = runMethod @"get_ssao_bias"

get_ssao_blur :: Method "get_ssao_blur" cls sig => cls -> sig
get_ssao_blur = runMethod @"get_ssao_blur"

get_ssao_color :: Method "get_ssao_color" cls sig => cls -> sig
get_ssao_color = runMethod @"get_ssao_color"

get_ssao_direct_light_affect ::
                               Method "get_ssao_direct_light_affect" cls sig => cls -> sig
get_ssao_direct_light_affect
  = runMethod @"get_ssao_direct_light_affect"

get_ssao_edge_sharpness ::
                          Method "get_ssao_edge_sharpness" cls sig => cls -> sig
get_ssao_edge_sharpness = runMethod @"get_ssao_edge_sharpness"

get_ssao_intensity ::
                     Method "get_ssao_intensity" cls sig => cls -> sig
get_ssao_intensity = runMethod @"get_ssao_intensity"

get_ssao_intensity2 ::
                      Method "get_ssao_intensity2" cls sig => cls -> sig
get_ssao_intensity2 = runMethod @"get_ssao_intensity2"

get_ssao_quality :: Method "get_ssao_quality" cls sig => cls -> sig
get_ssao_quality = runMethod @"get_ssao_quality"

get_ssao_radius :: Method "get_ssao_radius" cls sig => cls -> sig
get_ssao_radius = runMethod @"get_ssao_radius"

get_ssao_radius2 :: Method "get_ssao_radius2" cls sig => cls -> sig
get_ssao_radius2 = runMethod @"get_ssao_radius2"

get_ssr_depth_tolerance ::
                          Method "get_ssr_depth_tolerance" cls sig => cls -> sig
get_ssr_depth_tolerance = runMethod @"get_ssr_depth_tolerance"

get_ssr_fade_in :: Method "get_ssr_fade_in" cls sig => cls -> sig
get_ssr_fade_in = runMethod @"get_ssr_fade_in"

get_ssr_fade_out :: Method "get_ssr_fade_out" cls sig => cls -> sig
get_ssr_fade_out = runMethod @"get_ssr_fade_out"

get_ssr_max_steps ::
                    Method "get_ssr_max_steps" cls sig => cls -> sig
get_ssr_max_steps = runMethod @"get_ssr_max_steps"

get_stage :: Method "get_stage" cls sig => cls -> sig
get_stage = runMethod @"get_stage"

get_stage_count :: Method "get_stage_count" cls sig => cls -> sig
get_stage_count = runMethod @"get_stage_count"

get_start :: Method "get_start" cls sig => cls -> sig
get_start = runMethod @"get_start"

get_start_node :: Method "get_start_node" cls sig => cls -> sig
get_start_node = runMethod @"get_start_node"

get_state :: Method "get_state" cls sig => cls -> sig
get_state = runMethod @"get_state"

get_static_memory_peak_usage ::
                               Method "get_static_memory_peak_usage" cls sig => cls -> sig
get_static_memory_peak_usage
  = runMethod @"get_static_memory_peak_usage"

get_static_memory_usage ::
                          Method "get_static_memory_usage" cls sig => cls -> sig
get_static_memory_usage = runMethod @"get_static_memory_usage"

get_status :: Method "get_status" cls sig => cls -> sig
get_status = runMethod @"get_status"

get_steering :: Method "get_steering" cls sig => cls -> sig
get_steering = runMethod @"get_steering"

get_step :: Method "get_step" cls sig => cls -> sig
get_step = runMethod @"get_step"

get_steps :: Method "get_steps" cls sig => cls -> sig
get_steps = runMethod @"get_steps"

get_stiffness :: Method "get_stiffness" cls sig => cls -> sig
get_stiffness = runMethod @"get_stiffness"

get_storage :: Method "get_storage" cls sig => cls -> sig
get_storage = runMethod @"get_storage"

get_stored_values ::
                    Method "get_stored_values" cls sig => cls -> sig
get_stored_values = runMethod @"get_stored_values"

get_stream :: Method "get_stream" cls sig => cls -> sig
get_stream = runMethod @"get_stream"

get_stream_name :: Method "get_stream_name" cls sig => cls -> sig
get_stream_name = runMethod @"get_stream_name"

get_stream_paused ::
                    Method "get_stream_paused" cls sig => cls -> sig
get_stream_paused = runMethod @"get_stream_paused"

get_stream_peer :: Method "get_stream_peer" cls sig => cls -> sig
get_stream_peer = runMethod @"get_stream_peer"

get_stream_position ::
                      Method "get_stream_position" cls sig => cls -> sig
get_stream_position = runMethod @"get_stream_position"

get_stretch_margin ::
                     Method "get_stretch_margin" cls sig => cls -> sig
get_stretch_margin = runMethod @"get_stretch_margin"

get_stretch_mode :: Method "get_stretch_mode" cls sig => cls -> sig
get_stretch_mode = runMethod @"get_stretch_mode"

get_stretch_ratio ::
                    Method "get_stretch_ratio" cls sig => cls -> sig
get_stretch_ratio = runMethod @"get_stretch_ratio"

get_stretch_shrink ::
                     Method "get_stretch_shrink" cls sig => cls -> sig
get_stretch_shrink = runMethod @"get_stretch_shrink"

get_string :: Method "get_string" cls sig => cls -> sig
get_string = runMethod @"get_string"

get_string_size :: Method "get_string_size" cls sig => cls -> sig
get_string_size = runMethod @"get_string_size"

get_strings :: Method "get_strings" cls sig => cls -> sig
get_strings = runMethod @"get_strings"

get_stylebox :: Method "get_stylebox" cls sig => cls -> sig
get_stylebox = runMethod @"get_stylebox"

get_stylebox_list ::
                    Method "get_stylebox_list" cls sig => cls -> sig
get_stylebox_list = runMethod @"get_stylebox_list"

get_stylebox_types ::
                     Method "get_stylebox_types" cls sig => cls -> sig
get_stylebox_types = runMethod @"get_stylebox_types"

get_subdir :: Method "get_subdir" cls sig => cls -> sig
get_subdir = runMethod @"get_subdir"

get_subdir_count :: Method "get_subdir_count" cls sig => cls -> sig
get_subdir_count = runMethod @"get_subdir_count"

get_subdiv :: Method "get_subdiv" cls sig => cls -> sig
get_subdiv = runMethod @"get_subdiv"

get_subdivide_depth ::
                      Method "get_subdivide_depth" cls sig => cls -> sig
get_subdivide_depth = runMethod @"get_subdivide_depth"

get_subdivide_height ::
                       Method "get_subdivide_height" cls sig => cls -> sig
get_subdivide_height = runMethod @"get_subdivide_height"

get_subdivide_width ::
                      Method "get_subdivide_width" cls sig => cls -> sig
get_subdivide_width = runMethod @"get_subdivide_width"

get_subject :: Method "get_subject" cls sig => cls -> sig
get_subject = runMethod @"get_subject"

get_submenu_popup_delay ::
                          Method "get_submenu_popup_delay" cls sig => cls -> sig
get_submenu_popup_delay = runMethod @"get_submenu_popup_delay"

get_subsurface_scattering_strength ::
                                     Method "get_subsurface_scattering_strength" cls sig =>
                                     cls -> sig
get_subsurface_scattering_strength
  = runMethod @"get_subsurface_scattering_strength"

get_suffix :: Method "get_suffix" cls sig => cls -> sig
get_suffix = runMethod @"get_suffix"

get_sun_angle_max ::
                    Method "get_sun_angle_max" cls sig => cls -> sig
get_sun_angle_max = runMethod @"get_sun_angle_max"

get_sun_angle_min ::
                    Method "get_sun_angle_min" cls sig => cls -> sig
get_sun_angle_min = runMethod @"get_sun_angle_min"

get_sun_color :: Method "get_sun_color" cls sig => cls -> sig
get_sun_color = runMethod @"get_sun_color"

get_sun_curve :: Method "get_sun_curve" cls sig => cls -> sig
get_sun_curve = runMethod @"get_sun_curve"

get_sun_energy :: Method "get_sun_energy" cls sig => cls -> sig
get_sun_energy = runMethod @"get_sun_energy"

get_sun_latitude :: Method "get_sun_latitude" cls sig => cls -> sig
get_sun_latitude = runMethod @"get_sun_latitude"

get_sun_longitude ::
                    Method "get_sun_longitude" cls sig => cls -> sig
get_sun_longitude = runMethod @"get_sun_longitude"

get_surface_count ::
                    Method "get_surface_count" cls sig => cls -> sig
get_surface_count = runMethod @"get_surface_count"

get_surface_material ::
                       Method "get_surface_material" cls sig => cls -> sig
get_surface_material = runMethod @"get_surface_material"

get_surface_material_count ::
                             Method "get_surface_material_count" cls sig => cls -> sig
get_surface_material_count
  = runMethod @"get_surface_material_count"

get_surround :: Method "get_surround" cls sig => cls -> sig
get_surround = runMethod @"get_surround"

get_suspension_max_force ::
                           Method "get_suspension_max_force" cls sig => cls -> sig
get_suspension_max_force = runMethod @"get_suspension_max_force"

get_suspension_rest_length ::
                             Method "get_suspension_rest_length" cls sig => cls -> sig
get_suspension_rest_length
  = runMethod @"get_suspension_rest_length"

get_suspension_stiffness ::
                           Method "get_suspension_stiffness" cls sig => cls -> sig
get_suspension_stiffness = runMethod @"get_suspension_stiffness"

get_suspension_travel ::
                        Method "get_suspension_travel" cls sig => cls -> sig
get_suspension_travel = runMethod @"get_suspension_travel"

get_switch_mode :: Method "get_switch_mode" cls sig => cls -> sig
get_switch_mode = runMethod @"get_switch_mode"

get_symbol_prefix ::
                    Method "get_symbol_prefix" cls sig => cls -> sig
get_symbol_prefix = runMethod @"get_symbol_prefix"

get_system_dir :: Method "get_system_dir" cls sig => cls -> sig
get_system_dir = runMethod @"get_system_dir"

get_system_time_secs ::
                       Method "get_system_time_secs" cls sig => cls -> sig
get_system_time_secs = runMethod @"get_system_time_secs"

get_tab_align :: Method "get_tab_align" cls sig => cls -> sig
get_tab_align = runMethod @"get_tab_align"

get_tab_close_display_policy ::
                               Method "get_tab_close_display_policy" cls sig => cls -> sig
get_tab_close_display_policy
  = runMethod @"get_tab_close_display_policy"

get_tab_control :: Method "get_tab_control" cls sig => cls -> sig
get_tab_control = runMethod @"get_tab_control"

get_tab_count :: Method "get_tab_count" cls sig => cls -> sig
get_tab_count = runMethod @"get_tab_count"

get_tab_disabled :: Method "get_tab_disabled" cls sig => cls -> sig
get_tab_disabled = runMethod @"get_tab_disabled"

get_tab_icon :: Method "get_tab_icon" cls sig => cls -> sig
get_tab_icon = runMethod @"get_tab_icon"

get_tab_offset :: Method "get_tab_offset" cls sig => cls -> sig
get_tab_offset = runMethod @"get_tab_offset"

get_tab_rect :: Method "get_tab_rect" cls sig => cls -> sig
get_tab_rect = runMethod @"get_tab_rect"

get_tab_size :: Method "get_tab_size" cls sig => cls -> sig
get_tab_size = runMethod @"get_tab_size"

get_tab_title :: Method "get_tab_title" cls sig => cls -> sig
get_tab_title = runMethod @"get_tab_title"

get_tabs_rearrange_group ::
                           Method "get_tabs_rearrange_group" cls sig => cls -> sig
get_tabs_rearrange_group = runMethod @"get_tabs_rearrange_group"

get_tap1_delay_ms ::
                    Method "get_tap1_delay_ms" cls sig => cls -> sig
get_tap1_delay_ms = runMethod @"get_tap1_delay_ms"

get_tap1_level_db ::
                    Method "get_tap1_level_db" cls sig => cls -> sig
get_tap1_level_db = runMethod @"get_tap1_level_db"

get_tap1_pan :: Method "get_tap1_pan" cls sig => cls -> sig
get_tap1_pan = runMethod @"get_tap1_pan"

get_tap2_delay_ms ::
                    Method "get_tap2_delay_ms" cls sig => cls -> sig
get_tap2_delay_ms = runMethod @"get_tap2_delay_ms"

get_tap2_level_db ::
                    Method "get_tap2_level_db" cls sig => cls -> sig
get_tap2_level_db = runMethod @"get_tap2_level_db"

get_tap2_pan :: Method "get_tap2_pan" cls sig => cls -> sig
get_tap2_pan = runMethod @"get_tap2_pan"

get_target_fps :: Method "get_target_fps" cls sig => cls -> sig
get_target_fps = runMethod @"get_target_fps"

get_target_node :: Method "get_target_node" cls sig => cls -> sig
get_target_node = runMethod @"get_target_node"

get_target_path :: Method "get_target_path" cls sig => cls -> sig
get_target_path = runMethod @"get_target_path"

get_target_transform ::
                       Method "get_target_transform" cls sig => cls -> sig
get_target_transform = runMethod @"get_target_transform"

get_test_cube :: Method "get_test_cube" cls sig => cls -> sig
get_test_cube = runMethod @"get_test_cube"

get_test_texture :: Method "get_test_texture" cls sig => cls -> sig
get_test_texture = runMethod @"get_test_texture"

get_text :: Method "get_text" cls sig => cls -> sig
get_text = runMethod @"get_text"

get_text_align :: Method "get_text_align" cls sig => cls -> sig
get_text_align = runMethod @"get_text_align"

get_texture :: Method "get_texture" cls sig => cls -> sig
get_texture = runMethod @"get_texture"

get_texture_count ::
                    Method "get_texture_count" cls sig => cls -> sig
get_texture_count = runMethod @"get_texture_count"

get_texture_mode :: Method "get_texture_mode" cls sig => cls -> sig
get_texture_mode = runMethod @"get_texture_mode"

get_texture_offset ::
                     Method "get_texture_offset" cls sig => cls -> sig
get_texture_offset = runMethod @"get_texture_offset"

get_texture_pressed ::
                      Method "get_texture_pressed" cls sig => cls -> sig
get_texture_pressed = runMethod @"get_texture_pressed"

get_texture_rotation ::
                       Method "get_texture_rotation" cls sig => cls -> sig
get_texture_rotation = runMethod @"get_texture_rotation"

get_texture_rotation_degrees ::
                               Method "get_texture_rotation_degrees" cls sig => cls -> sig
get_texture_rotation_degrees
  = runMethod @"get_texture_rotation_degrees"

get_texture_scale ::
                    Method "get_texture_scale" cls sig => cls -> sig
get_texture_scale = runMethod @"get_texture_scale"

get_texture_size :: Method "get_texture_size" cls sig => cls -> sig
get_texture_size = runMethod @"get_texture_size"

get_texture_type :: Method "get_texture_type" cls sig => cls -> sig
get_texture_type = runMethod @"get_texture_type"

get_theme :: Method "get_theme" cls sig => cls -> sig
get_theme = runMethod @"get_theme"

get_thickness :: Method "get_thickness" cls sig => cls -> sig
get_thickness = runMethod @"get_thickness"

get_threshold :: Method "get_threshold" cls sig => cls -> sig
get_threshold = runMethod @"get_threshold"

get_threshold_db :: Method "get_threshold_db" cls sig => cls -> sig
get_threshold_db = runMethod @"get_threshold_db"

get_ticks :: Method "get_ticks" cls sig => cls -> sig
get_ticks = runMethod @"get_ticks"

get_ticks_msec :: Method "get_ticks_msec" cls sig => cls -> sig
get_ticks_msec = runMethod @"get_ticks_msec"

get_ticks_on_borders ::
                       Method "get_ticks_on_borders" cls sig => cls -> sig
get_ticks_on_borders = runMethod @"get_ticks_on_borders"

get_ticks_usec :: Method "get_ticks_usec" cls sig => cls -> sig
get_ticks_usec = runMethod @"get_ticks_usec"

get_tile_origin :: Method "get_tile_origin" cls sig => cls -> sig
get_tile_origin = runMethod @"get_tile_origin"

get_tiles_ids :: Method "get_tiles_ids" cls sig => cls -> sig
get_tiles_ids = runMethod @"get_tiles_ids"

get_tileset :: Method "get_tileset" cls sig => cls -> sig
get_tileset = runMethod @"get_tileset"

get_time :: Method "get_time" cls sig => cls -> sig
get_time = runMethod @"get_time"

get_time_left :: Method "get_time_left" cls sig => cls -> sig
get_time_left = runMethod @"get_time_left"

get_time_pullout :: Method "get_time_pullout" cls sig => cls -> sig
get_time_pullout = runMethod @"get_time_pullout"

get_time_scale :: Method "get_time_scale" cls sig => cls -> sig
get_time_scale = runMethod @"get_time_scale"

get_time_zone_info ::
                     Method "get_time_zone_info" cls sig => cls -> sig
get_time_zone_info = runMethod @"get_time_zone_info"

get_timer_process_mode ::
                         Method "get_timer_process_mode" cls sig => cls -> sig
get_timer_process_mode = runMethod @"get_timer_process_mode"

get_tint_over :: Method "get_tint_over" cls sig => cls -> sig
get_tint_over = runMethod @"get_tint_over"

get_tint_progress ::
                    Method "get_tint_progress" cls sig => cls -> sig
get_tint_progress = runMethod @"get_tint_progress"

get_tint_under :: Method "get_tint_under" cls sig => cls -> sig
get_tint_under = runMethod @"get_tint_under"

get_tip_bone :: Method "get_tip_bone" cls sig => cls -> sig
get_tip_bone = runMethod @"get_tip_bone"

get_title :: Method "get_title" cls sig => cls -> sig
get_title = runMethod @"get_title"

get_to_cell_xform ::
                    Method "get_to_cell_xform" cls sig => cls -> sig
get_to_cell_xform = runMethod @"get_to_cell_xform"

get_tonemap_auto_exposure ::
                            Method "get_tonemap_auto_exposure" cls sig => cls -> sig
get_tonemap_auto_exposure = runMethod @"get_tonemap_auto_exposure"

get_tonemap_auto_exposure_grey ::
                                 Method "get_tonemap_auto_exposure_grey" cls sig => cls -> sig
get_tonemap_auto_exposure_grey
  = runMethod @"get_tonemap_auto_exposure_grey"

get_tonemap_auto_exposure_max ::
                                Method "get_tonemap_auto_exposure_max" cls sig => cls -> sig
get_tonemap_auto_exposure_max
  = runMethod @"get_tonemap_auto_exposure_max"

get_tonemap_auto_exposure_min ::
                                Method "get_tonemap_auto_exposure_min" cls sig => cls -> sig
get_tonemap_auto_exposure_min
  = runMethod @"get_tonemap_auto_exposure_min"

get_tonemap_auto_exposure_speed ::
                                  Method "get_tonemap_auto_exposure_speed" cls sig => cls -> sig
get_tonemap_auto_exposure_speed
  = runMethod @"get_tonemap_auto_exposure_speed"

get_tonemap_exposure ::
                       Method "get_tonemap_exposure" cls sig => cls -> sig
get_tonemap_exposure = runMethod @"get_tonemap_exposure"

get_tonemap_white ::
                    Method "get_tonemap_white" cls sig => cls -> sig
get_tonemap_white = runMethod @"get_tonemap_white"

get_tonemapper :: Method "get_tonemapper" cls sig => cls -> sig
get_tonemapper = runMethod @"get_tonemapper"

get_tooltip :: Method "get_tooltip" cls sig => cls -> sig
get_tooltip = runMethod @"get_tooltip"

get_tooltip_text :: Method "get_tooltip_text" cls sig => cls -> sig
get_tooltip_text = runMethod @"get_tooltip_text"

get_top_radius :: Method "get_top_radius" cls sig => cls -> sig
get_top_radius = runMethod @"get_top_radius"

get_total_angular_damp ::
                         Method "get_total_angular_damp" cls sig => cls -> sig
get_total_angular_damp = runMethod @"get_total_angular_damp"

get_total_character_count ::
                            Method "get_total_character_count" cls sig => cls -> sig
get_total_character_count = runMethod @"get_total_character_count"

get_total_gravity ::
                    Method "get_total_gravity" cls sig => cls -> sig
get_total_gravity = runMethod @"get_total_gravity"

get_total_linear_damp ::
                        Method "get_total_linear_damp" cls sig => cls -> sig
get_total_linear_damp = runMethod @"get_total_linear_damp"

get_total_mass :: Method "get_total_mass" cls sig => cls -> sig
get_total_mass = runMethod @"get_total_mass"

get_track_count :: Method "get_track_count" cls sig => cls -> sig
get_track_count = runMethod @"get_track_count"

get_tracked_linear_velocity ::
                              Method "get_tracked_linear_velocity" cls sig => cls -> sig
get_tracked_linear_velocity
  = runMethod @"get_tracked_linear_velocity"

get_tracker :: Method "get_tracker" cls sig => cls -> sig
get_tracker = runMethod @"get_tracker"

get_tracker_count ::
                    Method "get_tracker_count" cls sig => cls -> sig
get_tracker_count = runMethod @"get_tracker_count"

get_tracking_status ::
                      Method "get_tracking_status" cls sig => cls -> sig
get_tracking_status = runMethod @"get_tracking_status"

get_tracks_orientation ::
                         Method "get_tracks_orientation" cls sig => cls -> sig
get_tracks_orientation = runMethod @"get_tracks_orientation"

get_tracks_position ::
                      Method "get_tracks_position" cls sig => cls -> sig
get_tracks_position = runMethod @"get_tracks_position"

get_trail_color_modifier ::
                           Method "get_trail_color_modifier" cls sig => cls -> sig
get_trail_color_modifier = runMethod @"get_trail_color_modifier"

get_trail_divisor ::
                    Method "get_trail_divisor" cls sig => cls -> sig
get_trail_divisor = runMethod @"get_trail_divisor"

get_trail_size_modifier ::
                          Method "get_trail_size_modifier" cls sig => cls -> sig
get_trail_size_modifier = runMethod @"get_trail_size_modifier"

get_transfer_channel ::
                       Method "get_transfer_channel" cls sig => cls -> sig
get_transfer_channel = runMethod @"get_transfer_channel"

get_transfer_mode ::
                    Method "get_transfer_mode" cls sig => cls -> sig
get_transfer_mode = runMethod @"get_transfer_mode"

get_transform :: Method "get_transform" cls sig => cls -> sig
get_transform = runMethod @"get_transform"

get_transform_format ::
                       Method "get_transform_format" cls sig => cls -> sig
get_transform_format = runMethod @"get_transform_format"

get_transformable_selected_nodes ::
                                   Method "get_transformable_selected_nodes" cls sig => cls -> sig
get_transformable_selected_nodes
  = runMethod @"get_transformable_selected_nodes"

get_transformed_aabb ::
                       Method "get_transformed_aabb" cls sig => cls -> sig
get_transformed_aabb = runMethod @"get_transformed_aabb"

get_transition :: Method "get_transition" cls sig => cls -> sig
get_transition = runMethod @"get_transition"

get_transition_count ::
                       Method "get_transition_count" cls sig => cls -> sig
get_transition_count = runMethod @"get_transition_count"

get_transition_from ::
                      Method "get_transition_from" cls sig => cls -> sig
get_transition_from = runMethod @"get_transition_from"

get_transition_to ::
                    Method "get_transition_to" cls sig => cls -> sig
get_transition_to = runMethod @"get_transition_to"

get_translation :: Method "get_translation" cls sig => cls -> sig
get_translation = runMethod @"get_translation"

get_transmission :: Method "get_transmission" cls sig => cls -> sig
get_transmission = runMethod @"get_transmission"

get_travel :: Method "get_travel" cls sig => cls -> sig
get_travel = runMethod @"get_travel"

get_travel_path :: Method "get_travel_path" cls sig => cls -> sig
get_travel_path = runMethod @"get_travel_path"

get_tree :: Method "get_tree" cls sig => cls -> sig
get_tree = runMethod @"get_tree"

get_tree_root :: Method "get_tree_root" cls sig => cls -> sig
get_tree_root = runMethod @"get_tree_root"

get_triangle_count ::
                     Method "get_triangle_count" cls sig => cls -> sig
get_triangle_count = runMethod @"get_triangle_count"

get_triangle_point ::
                     Method "get_triangle_point" cls sig => cls -> sig
get_triangle_point = runMethod @"get_triangle_point"

get_true_bit_count ::
                     Method "get_true_bit_count" cls sig => cls -> sig
get_true_bit_count = runMethod @"get_true_bit_count"

get_tween_process_mode ::
                         Method "get_tween_process_mode" cls sig => cls -> sig
get_tween_process_mode = runMethod @"get_tween_process_mode"

get_type :: Method "get_type" cls sig => cls -> sig
get_type = runMethod @"get_type"

get_type_list :: Method "get_type_list" cls sig => cls -> sig
get_type_list = runMethod @"get_type_list"

get_typed :: Method "get_typed" cls sig => cls -> sig
get_typed = runMethod @"get_typed"

get_u16 :: Method "get_u16" cls sig => cls -> sig
get_u16 = runMethod @"get_u16"

get_u32 :: Method "get_u32" cls sig => cls -> sig
get_u32 = runMethod @"get_u32"

get_u64 :: Method "get_u64" cls sig => cls -> sig
get_u64 = runMethod @"get_u64"

get_u8 :: Method "get_u8" cls sig => cls -> sig
get_u8 = runMethod @"get_u8"

get_under_texture ::
                    Method "get_under_texture" cls sig => cls -> sig
get_under_texture = runMethod @"get_under_texture"

get_underline_mode ::
                     Method "get_underline_mode" cls sig => cls -> sig
get_underline_mode = runMethod @"get_underline_mode"

get_undo_redo :: Method "get_undo_redo" cls sig => cls -> sig
get_undo_redo = runMethod @"get_undo_redo"

get_unicode :: Method "get_unicode" cls sig => cls -> sig
get_unicode = runMethod @"get_unicode"

get_uniform_name :: Method "get_uniform_name" cls sig => cls -> sig
get_uniform_name = runMethod @"get_uniform_name"

get_unique_id :: Method "get_unique_id" cls sig => cls -> sig
get_unique_id = runMethod @"get_unique_id"

get_unit_db :: Method "get_unit_db" cls sig => cls -> sig
get_unit_db = runMethod @"get_unit_db"

get_unit_offset :: Method "get_unit_offset" cls sig => cls -> sig
get_unit_offset = runMethod @"get_unit_offset"

get_unit_size :: Method "get_unit_size" cls sig => cls -> sig
get_unit_size = runMethod @"get_unit_size"

get_unix_time :: Method "get_unix_time" cls sig => cls -> sig
get_unix_time = runMethod @"get_unix_time"

get_unix_time_from_datetime ::
                              Method "get_unix_time_from_datetime" cls sig => cls -> sig
get_unix_time_from_datetime
  = runMethod @"get_unix_time_from_datetime"

get_up_vector :: Method "get_up_vector" cls sig => cls -> sig
get_up_vector = runMethod @"get_up_vector"

get_update_mode :: Method "get_update_mode" cls sig => cls -> sig
get_update_mode = runMethod @"get_update_mode"

get_update_position ::
                      Method "get_update_position" cls sig => cls -> sig
get_update_position = runMethod @"get_update_position"

get_update_rotation ::
                      Method "get_update_rotation" cls sig => cls -> sig
get_update_rotation = runMethod @"get_update_rotation"

get_update_scale :: Method "get_update_scale" cls sig => cls -> sig
get_update_scale = runMethod @"get_update_scale"

get_usage :: Method "get_usage" cls sig => cls -> sig
get_usage = runMethod @"get_usage"

get_use_default_args ::
                       Method "get_use_default_args" cls sig => cls -> sig
get_use_default_args = runMethod @"get_use_default_args"

get_use_filter :: Method "get_use_filter" cls sig => cls -> sig
get_use_filter = runMethod @"get_use_filter"

get_use_global_coordinates ::
                             Method "get_use_global_coordinates" cls sig => cls -> sig
get_use_global_coordinates
  = runMethod @"get_use_global_coordinates"

get_use_local_coordinates ::
                            Method "get_use_local_coordinates" cls sig => cls -> sig
get_use_local_coordinates = runMethod @"get_use_local_coordinates"

get_use_mipmaps :: Method "get_use_mipmaps" cls sig => cls -> sig
get_use_mipmaps = runMethod @"get_use_mipmaps"

get_use_parent_material ::
                          Method "get_use_parent_material" cls sig => cls -> sig
get_use_parent_material = runMethod @"get_use_parent_material"

get_used_cells :: Method "get_used_cells" cls sig => cls -> sig
get_used_cells = runMethod @"get_used_cells"

get_used_cells_by_id ::
                       Method "get_used_cells_by_id" cls sig => cls -> sig
get_used_cells_by_id = runMethod @"get_used_cells_by_id"

get_used_rect :: Method "get_used_rect" cls sig => cls -> sig
get_used_rect = runMethod @"get_used_rect"

get_user_count :: Method "get_user_count" cls sig => cls -> sig
get_user_count = runMethod @"get_user_count"

get_user_data_dir ::
                    Method "get_user_data_dir" cls sig => cls -> sig
get_user_data_dir = runMethod @"get_user_data_dir"

get_user_lightmap ::
                    Method "get_user_lightmap" cls sig => cls -> sig
get_user_lightmap = runMethod @"get_user_lightmap"

get_user_path :: Method "get_user_path" cls sig => cls -> sig
get_user_path = runMethod @"get_user_path"

get_utf8_string :: Method "get_utf8_string" cls sig => cls -> sig
get_utf8_string = runMethod @"get_utf8_string"

get_uv :: Method "get_uv" cls sig => cls -> sig
get_uv = runMethod @"get_uv"

get_uv1_offset :: Method "get_uv1_offset" cls sig => cls -> sig
get_uv1_offset = runMethod @"get_uv1_offset"

get_uv1_scale :: Method "get_uv1_scale" cls sig => cls -> sig
get_uv1_scale = runMethod @"get_uv1_scale"

get_uv1_triplanar_blend_sharpness ::
                                    Method "get_uv1_triplanar_blend_sharpness" cls sig => cls -> sig
get_uv1_triplanar_blend_sharpness
  = runMethod @"get_uv1_triplanar_blend_sharpness"

get_uv2_offset :: Method "get_uv2_offset" cls sig => cls -> sig
get_uv2_offset = runMethod @"get_uv2_offset"

get_uv2_scale :: Method "get_uv2_scale" cls sig => cls -> sig
get_uv2_scale = runMethod @"get_uv2_scale"

get_uv2_triplanar_blend_sharpness ::
                                    Method "get_uv2_triplanar_blend_sharpness" cls sig => cls -> sig
get_uv2_triplanar_blend_sharpness
  = runMethod @"get_uv2_triplanar_blend_sharpness"

get_uv84_normal_bit ::
                      Method "get_uv84_normal_bit" cls sig => cls -> sig
get_uv84_normal_bit = runMethod @"get_uv84_normal_bit"

get_v_axis_stretch_mode ::
                          Method "get_v_axis_stretch_mode" cls sig => cls -> sig
get_v_axis_stretch_mode = runMethod @"get_v_axis_stretch_mode"

get_v_frames :: Method "get_v_frames" cls sig => cls -> sig
get_v_frames = runMethod @"get_v_frames"

get_v_grow_direction ::
                       Method "get_v_grow_direction" cls sig => cls -> sig
get_v_grow_direction = runMethod @"get_v_grow_direction"

get_v_offset :: Method "get_v_offset" cls sig => cls -> sig
get_v_offset = runMethod @"get_v_offset"

get_v_scroll :: Method "get_v_scroll" cls sig => cls -> sig
get_v_scroll = runMethod @"get_v_scroll"

get_v_scroll_speed ::
                     Method "get_v_scroll_speed" cls sig => cls -> sig
get_v_scroll_speed = runMethod @"get_v_scroll_speed"

get_v_scrollbar :: Method "get_v_scrollbar" cls sig => cls -> sig
get_v_scrollbar = runMethod @"get_v_scrollbar"

get_v_size_flags :: Method "get_v_size_flags" cls sig => cls -> sig
get_v_size_flags = runMethod @"get_v_size_flags"

get_valid_node_id ::
                    Method "get_valid_node_id" cls sig => cls -> sig
get_valid_node_id = runMethod @"get_valid_node_id"

get_validate :: Method "get_validate" cls sig => cls -> sig
get_validate = runMethod @"get_validate"

get_valign :: Method "get_valign" cls sig => cls -> sig
get_valign = runMethod @"get_valign"

get_value :: Method "get_value" cls sig => cls -> sig
get_value = runMethod @"get_value"

get_value_label :: Method "get_value_label" cls sig => cls -> sig
get_value_label = runMethod @"get_value_label"

get_var :: Method "get_var" cls sig => cls -> sig
get_var = runMethod @"get_var"

get_var_name :: Method "get_var_name" cls sig => cls -> sig
get_var_name = runMethod @"get_var_name"

get_var_type :: Method "get_var_type" cls sig => cls -> sig
get_var_type = runMethod @"get_var_type"

get_variable :: Method "get_variable" cls sig => cls -> sig
get_variable = runMethod @"get_variable"

get_variable_default_value ::
                             Method "get_variable_default_value" cls sig => cls -> sig
get_variable_default_value
  = runMethod @"get_variable_default_value"

get_variable_export ::
                      Method "get_variable_export" cls sig => cls -> sig
get_variable_export = runMethod @"get_variable_export"

get_variable_info ::
                    Method "get_variable_info" cls sig => cls -> sig
get_variable_info = runMethod @"get_variable_info"

get_vbox :: Method "get_vbox" cls sig => cls -> sig
get_vbox = runMethod @"get_vbox"

get_version :: Method "get_version" cls sig => cls -> sig
get_version = runMethod @"get_version"

get_version_info :: Method "get_version_info" cls sig => cls -> sig
get_version_info = runMethod @"get_version_info"

get_vertex :: Method "get_vertex" cls sig => cls -> sig
get_vertex = runMethod @"get_vertex"

get_vertex_bones :: Method "get_vertex_bones" cls sig => cls -> sig
get_vertex_bones = runMethod @"get_vertex_bones"

get_vertex_color :: Method "get_vertex_color" cls sig => cls -> sig
get_vertex_color = runMethod @"get_vertex_color"

get_vertex_colors ::
                    Method "get_vertex_colors" cls sig => cls -> sig
get_vertex_colors = runMethod @"get_vertex_colors"

get_vertex_count :: Method "get_vertex_count" cls sig => cls -> sig
get_vertex_count = runMethod @"get_vertex_count"

get_vertex_edges :: Method "get_vertex_edges" cls sig => cls -> sig
get_vertex_edges = runMethod @"get_vertex_edges"

get_vertex_faces :: Method "get_vertex_faces" cls sig => cls -> sig
get_vertex_faces = runMethod @"get_vertex_faces"

get_vertex_meta :: Method "get_vertex_meta" cls sig => cls -> sig
get_vertex_meta = runMethod @"get_vertex_meta"

get_vertex_normal ::
                    Method "get_vertex_normal" cls sig => cls -> sig
get_vertex_normal = runMethod @"get_vertex_normal"

get_vertex_tangent ::
                     Method "get_vertex_tangent" cls sig => cls -> sig
get_vertex_tangent = runMethod @"get_vertex_tangent"

get_vertex_uv :: Method "get_vertex_uv" cls sig => cls -> sig
get_vertex_uv = runMethod @"get_vertex_uv"

get_vertex_uv2 :: Method "get_vertex_uv2" cls sig => cls -> sig
get_vertex_uv2 = runMethod @"get_vertex_uv2"

get_vertex_weights ::
                     Method "get_vertex_weights" cls sig => cls -> sig
get_vertex_weights = runMethod @"get_vertex_weights"

get_vertices :: Method "get_vertices" cls sig => cls -> sig
get_vertices = runMethod @"get_vertices"

get_verts_per_poly ::
                     Method "get_verts_per_poly" cls sig => cls -> sig
get_verts_per_poly = runMethod @"get_verts_per_poly"

get_vflip :: Method "get_vflip" cls sig => cls -> sig
get_vflip = runMethod @"get_vflip"

get_vframes :: Method "get_vframes" cls sig => cls -> sig
get_vframes = runMethod @"get_vframes"

get_video_driver_count ::
                         Method "get_video_driver_count" cls sig => cls -> sig
get_video_driver_count = runMethod @"get_video_driver_count"

get_video_driver_name ::
                        Method "get_video_driver_name" cls sig => cls -> sig
get_video_driver_name = runMethod @"get_video_driver_name"

get_video_texture ::
                    Method "get_video_texture" cls sig => cls -> sig
get_video_texture = runMethod @"get_video_texture"

get_viewport :: Method "get_viewport" cls sig => cls -> sig
get_viewport = runMethod @"get_viewport"

get_viewport_path_in_scene ::
                             Method "get_viewport_path_in_scene" cls sig => cls -> sig
get_viewport_path_in_scene
  = runMethod @"get_viewport_path_in_scene"

get_viewport_rect ::
                    Method "get_viewport_rect" cls sig => cls -> sig
get_viewport_rect = runMethod @"get_viewport_rect"

get_viewport_rid :: Method "get_viewport_rid" cls sig => cls -> sig
get_viewport_rid = runMethod @"get_viewport_rid"

get_viewport_transform ::
                         Method "get_viewport_transform" cls sig => cls -> sig
get_viewport_transform = runMethod @"get_viewport_transform"

get_virtual_keyboard_height ::
                              Method "get_virtual_keyboard_height" cls sig => cls -> sig
get_virtual_keyboard_height
  = runMethod @"get_virtual_keyboard_height"

get_visibility_aabb ::
                      Method "get_visibility_aabb" cls sig => cls -> sig
get_visibility_aabb = runMethod @"get_visibility_aabb"

get_visibility_mode ::
                      Method "get_visibility_mode" cls sig => cls -> sig
get_visibility_mode = runMethod @"get_visibility_mode"

get_visibility_rect ::
                      Method "get_visibility_rect" cls sig => cls -> sig
get_visibility_rect = runMethod @"get_visibility_rect"

get_visible_characters ::
                         Method "get_visible_characters" cls sig => cls -> sig
get_visible_characters = runMethod @"get_visible_characters"

get_visible_line_count ::
                         Method "get_visible_line_count" cls sig => cls -> sig
get_visible_line_count = runMethod @"get_visible_line_count"

get_visible_name :: Method "get_visible_name" cls sig => cls -> sig
get_visible_name = runMethod @"get_visible_name"

get_visible_rect :: Method "get_visible_rect" cls sig => cls -> sig
get_visible_rect = runMethod @"get_visible_rect"

get_visual_script ::
                    Method "get_visual_script" cls sig => cls -> sig
get_visual_script = runMethod @"get_visual_script"

get_voice_count :: Method "get_voice_count" cls sig => cls -> sig
get_voice_count = runMethod @"get_voice_count"

get_voice_cutoff_hz ::
                      Method "get_voice_cutoff_hz" cls sig => cls -> sig
get_voice_cutoff_hz = runMethod @"get_voice_cutoff_hz"

get_voice_delay_ms ::
                     Method "get_voice_delay_ms" cls sig => cls -> sig
get_voice_delay_ms = runMethod @"get_voice_delay_ms"

get_voice_depth_ms ::
                     Method "get_voice_depth_ms" cls sig => cls -> sig
get_voice_depth_ms = runMethod @"get_voice_depth_ms"

get_voice_level_db ::
                     Method "get_voice_level_db" cls sig => cls -> sig
get_voice_level_db = runMethod @"get_voice_level_db"

get_voice_pan :: Method "get_voice_pan" cls sig => cls -> sig
get_voice_pan = runMethod @"get_voice_pan"

get_voice_rate_hz ::
                    Method "get_voice_rate_hz" cls sig => cls -> sig
get_voice_rate_hz = runMethod @"get_voice_rate_hz"

get_volume :: Method "get_volume" cls sig => cls -> sig
get_volume = runMethod @"get_volume"

get_volume_db :: Method "get_volume_db" cls sig => cls -> sig
get_volume_db = runMethod @"get_volume_db"

get_volume_stiffness ::
                       Method "get_volume_stiffness" cls sig => cls -> sig
get_volume_stiffness = runMethod @"get_volume_stiffness"

get_wait_time :: Method "get_wait_time" cls sig => cls -> sig
get_wait_time = runMethod @"get_wait_time"

get_weight :: Method "get_weight" cls sig => cls -> sig
get_weight = runMethod @"get_weight"

get_wet :: Method "get_wet" cls sig => cls -> sig
get_wet = runMethod @"get_wet"

get_white_texture ::
                    Method "get_white_texture" cls sig => cls -> sig
get_white_texture = runMethod @"get_white_texture"

get_width :: Method "get_width" cls sig => cls -> sig
get_width = runMethod @"get_width"

get_window_layout ::
                    Method "get_window_layout" cls sig => cls -> sig
get_window_layout = runMethod @"get_window_layout"

get_window_per_pixel_transparency_enabled ::
                                            Method "get_window_per_pixel_transparency_enabled" cls
                                              sig =>
                                            cls -> sig
get_window_per_pixel_transparency_enabled
  = runMethod @"get_window_per_pixel_transparency_enabled"

get_window_position ::
                      Method "get_window_position" cls sig => cls -> sig
get_window_position = runMethod @"get_window_position"

get_window_safe_area ::
                       Method "get_window_safe_area" cls sig => cls -> sig
get_window_safe_area = runMethod @"get_window_safe_area"

get_window_size :: Method "get_window_size" cls sig => cls -> sig
get_window_size = runMethod @"get_window_size"

get_word_under_cursor ::
                        Method "get_word_under_cursor" cls sig => cls -> sig
get_word_under_cursor = runMethod @"get_word_under_cursor"

get_world :: Method "get_world" cls sig => cls -> sig
get_world = runMethod @"get_world"

get_world_2d :: Method "get_world_2d" cls sig => cls -> sig
get_world_2d = runMethod @"get_world_2d"

get_world_scale :: Method "get_world_scale" cls sig => cls -> sig
get_world_scale = runMethod @"get_world_scale"

get_write_mode :: Method "get_write_mode" cls sig => cls -> sig
get_write_mode = runMethod @"get_write_mode"

get_x_label :: Method "get_x_label" cls sig => cls -> sig
get_x_label = runMethod @"get_x_label"

get_xfade_time :: Method "get_xfade_time" cls sig => cls -> sig
get_xfade_time = runMethod @"get_xfade_time"

get_y_label :: Method "get_y_label" cls sig => cls -> sig
get_y_label = runMethod @"get_y_label"

get_yield_mode :: Method "get_yield_mode" cls sig => cls -> sig
get_yield_mode = runMethod @"get_yield_mode"

get_z_index :: Method "get_z_index" cls sig => cls -> sig
get_z_index = runMethod @"get_z_index"

get_z_range_max :: Method "get_z_range_max" cls sig => cls -> sig
get_z_range_max = runMethod @"get_z_range_max"

get_z_range_min :: Method "get_z_range_min" cls sig => cls -> sig
get_z_range_min = runMethod @"get_z_range_min"

get_zero_y :: Method "get_zero_y" cls sig => cls -> sig
get_zero_y = runMethod @"get_zero_y"

get_zfar :: Method "get_zfar" cls sig => cls -> sig
get_zfar = runMethod @"get_zfar"

get_znear :: Method "get_znear" cls sig => cls -> sig
get_znear = runMethod @"get_znear"

get_zoom :: Method "get_zoom" cls sig => cls -> sig
get_zoom = runMethod @"get_zoom"

get_zoom_hbox :: Method "get_zoom_hbox" cls sig => cls -> sig
get_zoom_hbox = runMethod @"get_zoom_hbox"

gi_probe_create :: Method "gi_probe_create" cls sig => cls -> sig
gi_probe_create = runMethod @"gi_probe_create"

gi_probe_get_bias ::
                    Method "gi_probe_get_bias" cls sig => cls -> sig
gi_probe_get_bias = runMethod @"gi_probe_get_bias"

gi_probe_get_bounds ::
                      Method "gi_probe_get_bounds" cls sig => cls -> sig
gi_probe_get_bounds = runMethod @"gi_probe_get_bounds"

gi_probe_get_cell_size ::
                         Method "gi_probe_get_cell_size" cls sig => cls -> sig
gi_probe_get_cell_size = runMethod @"gi_probe_get_cell_size"

gi_probe_get_dynamic_data ::
                            Method "gi_probe_get_dynamic_data" cls sig => cls -> sig
gi_probe_get_dynamic_data = runMethod @"gi_probe_get_dynamic_data"

gi_probe_get_dynamic_range ::
                             Method "gi_probe_get_dynamic_range" cls sig => cls -> sig
gi_probe_get_dynamic_range
  = runMethod @"gi_probe_get_dynamic_range"

gi_probe_get_energy ::
                      Method "gi_probe_get_energy" cls sig => cls -> sig
gi_probe_get_energy = runMethod @"gi_probe_get_energy"

gi_probe_get_normal_bias ::
                           Method "gi_probe_get_normal_bias" cls sig => cls -> sig
gi_probe_get_normal_bias = runMethod @"gi_probe_get_normal_bias"

gi_probe_get_propagation ::
                           Method "gi_probe_get_propagation" cls sig => cls -> sig
gi_probe_get_propagation = runMethod @"gi_probe_get_propagation"

gi_probe_get_to_cell_xform ::
                             Method "gi_probe_get_to_cell_xform" cls sig => cls -> sig
gi_probe_get_to_cell_xform
  = runMethod @"gi_probe_get_to_cell_xform"

gi_probe_is_compressed ::
                         Method "gi_probe_is_compressed" cls sig => cls -> sig
gi_probe_is_compressed = runMethod @"gi_probe_is_compressed"

gi_probe_is_interior ::
                       Method "gi_probe_is_interior" cls sig => cls -> sig
gi_probe_is_interior = runMethod @"gi_probe_is_interior"

gi_probe_set_bias ::
                    Method "gi_probe_set_bias" cls sig => cls -> sig
gi_probe_set_bias = runMethod @"gi_probe_set_bias"

gi_probe_set_bounds ::
                      Method "gi_probe_set_bounds" cls sig => cls -> sig
gi_probe_set_bounds = runMethod @"gi_probe_set_bounds"

gi_probe_set_cell_size ::
                         Method "gi_probe_set_cell_size" cls sig => cls -> sig
gi_probe_set_cell_size = runMethod @"gi_probe_set_cell_size"

gi_probe_set_compress ::
                        Method "gi_probe_set_compress" cls sig => cls -> sig
gi_probe_set_compress = runMethod @"gi_probe_set_compress"

gi_probe_set_dynamic_data ::
                            Method "gi_probe_set_dynamic_data" cls sig => cls -> sig
gi_probe_set_dynamic_data = runMethod @"gi_probe_set_dynamic_data"

gi_probe_set_dynamic_range ::
                             Method "gi_probe_set_dynamic_range" cls sig => cls -> sig
gi_probe_set_dynamic_range
  = runMethod @"gi_probe_set_dynamic_range"

gi_probe_set_energy ::
                      Method "gi_probe_set_energy" cls sig => cls -> sig
gi_probe_set_energy = runMethod @"gi_probe_set_energy"

gi_probe_set_interior ::
                        Method "gi_probe_set_interior" cls sig => cls -> sig
gi_probe_set_interior = runMethod @"gi_probe_set_interior"

gi_probe_set_normal_bias ::
                           Method "gi_probe_set_normal_bias" cls sig => cls -> sig
gi_probe_set_normal_bias = runMethod @"gi_probe_set_normal_bias"

gi_probe_set_propagation ::
                           Method "gi_probe_set_propagation" cls sig => cls -> sig
gi_probe_set_propagation = runMethod @"gi_probe_set_propagation"

gi_probe_set_to_cell_xform ::
                             Method "gi_probe_set_to_cell_xform" cls sig => cls -> sig
gi_probe_set_to_cell_xform
  = runMethod @"gi_probe_set_to_cell_xform"

global_rotate :: Method "global_rotate" cls sig => cls -> sig
global_rotate = runMethod @"global_rotate"

global_scale :: Method "global_scale" cls sig => cls -> sig
global_scale = runMethod @"global_scale"

global_translate :: Method "global_translate" cls sig => cls -> sig
global_translate = runMethod @"global_translate"

globalize_path :: Method "globalize_path" cls sig => cls -> sig
globalize_path = runMethod @"globalize_path"

grab_click_focus :: Method "grab_click_focus" cls sig => cls -> sig
grab_click_focus = runMethod @"grab_click_focus"

grab_focus :: Method "grab_focus" cls sig => cls -> sig
grab_focus = runMethod @"grab_focus"

groove_joint_create ::
                      Method "groove_joint_create" cls sig => cls -> sig
groove_joint_create = runMethod @"groove_joint_create"

grow_mask :: Method "grow_mask" cls sig => cls -> sig
grow_mask = runMethod @"grow_mask"

gui_get_drag_data ::
                    Method "gui_get_drag_data" cls sig => cls -> sig
gui_get_drag_data = runMethod @"gui_get_drag_data"

gui_has_modal_stack ::
                      Method "gui_has_modal_stack" cls sig => cls -> sig
gui_has_modal_stack = runMethod @"gui_has_modal_stack"

gui_is_dragging :: Method "gui_is_dragging" cls sig => cls -> sig
gui_is_dragging = runMethod @"gui_is_dragging"

handles :: Method "handles" cls sig => cls -> sig
handles = runMethod @"handles"

has :: Method "has" cls sig => cls -> sig
has = runMethod @"has"

has_action :: Method "has_action" cls sig => cls -> sig
has_action = runMethod @"has_action"

has_alpha :: Method "has_alpha" cls sig => cls -> sig
has_alpha = runMethod @"has_alpha"

has_animation :: Method "has_animation" cls sig => cls -> sig
has_animation = runMethod @"has_animation"

has_attribute :: Method "has_attribute" cls sig => cls -> sig
has_attribute = runMethod @"has_attribute"

has_auto_advance :: Method "has_auto_advance" cls sig => cls -> sig
has_auto_advance = runMethod @"has_auto_advance"

has_auto_height :: Method "has_auto_height" cls sig => cls -> sig
has_auto_height = runMethod @"has_auto_height"

has_autoplay :: Method "has_autoplay" cls sig => cls -> sig
has_autoplay = runMethod @"has_autoplay"

has_autorestart :: Method "has_autorestart" cls sig => cls -> sig
has_autorestart = runMethod @"has_autorestart"

has_autostart :: Method "has_autostart" cls sig => cls -> sig
has_autostart = runMethod @"has_autostart"

has_autowrap :: Method "has_autowrap" cls sig => cls -> sig
has_autowrap = runMethod @"has_autowrap"

has_cached :: Method "has_cached" cls sig => cls -> sig
has_cached = runMethod @"has_cached"

has_changed :: Method "has_changed" cls sig => cls -> sig
has_changed = runMethod @"has_changed"

has_color :: Method "has_color" cls sig => cls -> sig
has_color = runMethod @"has_color"

has_color_override ::
                     Method "has_color_override" cls sig => cls -> sig
has_color_override = runMethod @"has_color_override"

has_constant :: Method "has_constant" cls sig => cls -> sig
has_constant = runMethod @"has_constant"

has_constant_override ::
                        Method "has_constant_override" cls sig => cls -> sig
has_constant_override = runMethod @"has_constant_override"

has_custom_signal ::
                    Method "has_custom_signal" cls sig => cls -> sig
has_custom_signal = runMethod @"has_custom_signal"

has_data_connection ::
                      Method "has_data_connection" cls sig => cls -> sig
has_data_connection = runMethod @"has_data_connection"

has_environment :: Method "has_environment" cls sig => cls -> sig
has_environment = runMethod @"has_environment"

has_execute_failed ::
                     Method "has_execute_failed" cls sig => cls -> sig
has_execute_failed = runMethod @"has_execute_failed"

has_expand :: Method "has_expand" cls sig => cls -> sig
has_expand = runMethod @"has_expand"

has_feature :: Method "has_feature" cls sig => cls -> sig
has_feature = runMethod @"has_feature"

has_filter :: Method "has_filter" cls sig => cls -> sig
has_filter = runMethod @"has_filter"

has_filter_clip :: Method "has_filter_clip" cls sig => cls -> sig
has_filter_clip = runMethod @"has_filter_clip"

has_focus :: Method "has_focus" cls sig => cls -> sig
has_focus = runMethod @"has_focus"

has_font :: Method "has_font" cls sig => cls -> sig
has_font = runMethod @"has_font"

has_font_override ::
                    Method "has_font_override" cls sig => cls -> sig
has_font_override = runMethod @"has_font_override"

has_function :: Method "has_function" cls sig => cls -> sig
has_function = runMethod @"has_function"

has_group :: Method "has_group" cls sig => cls -> sig
has_group = runMethod @"has_group"

has_icon :: Method "has_icon" cls sig => cls -> sig
has_icon = runMethod @"has_icon"

has_icon_override ::
                    Method "has_icon_override" cls sig => cls -> sig
has_icon_override = runMethod @"has_icon_override"

has_keyword_color ::
                    Method "has_keyword_color" cls sig => cls -> sig
has_keyword_color = runMethod @"has_keyword_color"

has_loop :: Method "has_loop" cls sig => cls -> sig
has_loop = runMethod @"has_loop"

has_main_screen :: Method "has_main_screen" cls sig => cls -> sig
has_main_screen = runMethod @"has_main_screen"

has_meta :: Method "has_meta" cls sig => cls -> sig
has_meta = runMethod @"has_meta"

has_method :: Method "has_method" cls sig => cls -> sig
has_method = runMethod @"has_method"

has_mipmaps :: Method "has_mipmaps" cls sig => cls -> sig
has_mipmaps = runMethod @"has_mipmaps"

has_network_peer :: Method "has_network_peer" cls sig => cls -> sig
has_network_peer = runMethod @"has_network_peer"

has_node :: Method "has_node" cls sig => cls -> sig
has_node = runMethod @"has_node"

has_node_and_resource ::
                        Method "has_node_and_resource" cls sig => cls -> sig
has_node_and_resource = runMethod @"has_node_and_resource"

has_os_feature :: Method "has_os_feature" cls sig => cls -> sig
has_os_feature = runMethod @"has_os_feature"

has_outline :: Method "has_outline" cls sig => cls -> sig
has_outline = runMethod @"has_outline"

has_param :: Method "has_param" cls sig => cls -> sig
has_param = runMethod @"has_param"

has_peer :: Method "has_peer" cls sig => cls -> sig
has_peer = runMethod @"has_peer"

has_point :: Method "has_point" cls sig => cls -> sig
has_point = runMethod @"has_point"

has_resource :: Method "has_resource" cls sig => cls -> sig
has_resource = runMethod @"has_resource"

has_response :: Method "has_response" cls sig => cls -> sig
has_response = runMethod @"has_response"

has_script_signal ::
                    Method "has_script_signal" cls sig => cls -> sig
has_script_signal = runMethod @"has_script_signal"

has_section :: Method "has_section" cls sig => cls -> sig
has_section = runMethod @"has_section"

has_section_key :: Method "has_section_key" cls sig => cls -> sig
has_section_key = runMethod @"has_section_key"

has_sequence_connection ::
                          Method "has_sequence_connection" cls sig => cls -> sig
has_sequence_connection = runMethod @"has_sequence_connection"

has_setting :: Method "has_setting" cls sig => cls -> sig
has_setting = runMethod @"has_setting"

has_shader_override ::
                      Method "has_shader_override" cls sig => cls -> sig
has_shader_override = runMethod @"has_shader_override"

has_shadow :: Method "has_shadow" cls sig => cls -> sig
has_shadow = runMethod @"has_shadow"

has_singleton :: Method "has_singleton" cls sig => cls -> sig
has_singleton = runMethod @"has_singleton"

has_source_code :: Method "has_source_code" cls sig => cls -> sig
has_source_code = runMethod @"has_source_code"

has_stylebox :: Method "has_stylebox" cls sig => cls -> sig
has_stylebox = runMethod @"has_stylebox"

has_stylebox_override ::
                        Method "has_stylebox_override" cls sig => cls -> sig
has_stylebox_override = runMethod @"has_stylebox_override"

has_touchscreen_ui_hint ::
                          Method "has_touchscreen_ui_hint" cls sig => cls -> sig
has_touchscreen_ui_hint = runMethod @"has_touchscreen_ui_hint"

has_transition :: Method "has_transition" cls sig => cls -> sig
has_transition = runMethod @"has_transition"

has_transparent_background ::
                             Method "has_transparent_background" cls sig => cls -> sig
has_transparent_background
  = runMethod @"has_transparent_background"

has_user_signal :: Method "has_user_signal" cls sig => cls -> sig
has_user_signal = runMethod @"has_user_signal"

has_variable :: Method "has_variable" cls sig => cls -> sig
has_variable = runMethod @"has_variable"

has_virtual_keyboard ::
                       Method "has_virtual_keyboard" cls sig => cls -> sig
has_virtual_keyboard = runMethod @"has_virtual_keyboard"

hide :: Method "hide" cls sig => cls -> sig
hide = runMethod @"hide"

hide_bottom_panel ::
                    Method "hide_bottom_panel" cls sig => cls -> sig
hide_bottom_panel = runMethod @"hide_bottom_panel"

hide_virtual_keyboard ::
                        Method "hide_virtual_keyboard" cls sig => cls -> sig
hide_virtual_keyboard = runMethod @"hide_virtual_keyboard"

hinge_joint_get_flag ::
                       Method "hinge_joint_get_flag" cls sig => cls -> sig
hinge_joint_get_flag = runMethod @"hinge_joint_get_flag"

hinge_joint_get_param ::
                        Method "hinge_joint_get_param" cls sig => cls -> sig
hinge_joint_get_param = runMethod @"hinge_joint_get_param"

hinge_joint_set_flag ::
                       Method "hinge_joint_set_flag" cls sig => cls -> sig
hinge_joint_set_flag = runMethod @"hinge_joint_set_flag"

hinge_joint_set_param ::
                        Method "hinge_joint_set_param" cls sig => cls -> sig
hinge_joint_set_param = runMethod @"hinge_joint_set_param"

idle :: Method "idle" cls sig => cls -> sig
idle = runMethod @"idle"

immediate_begin :: Method "immediate_begin" cls sig => cls -> sig
immediate_begin = runMethod @"immediate_begin"

immediate_clear :: Method "immediate_clear" cls sig => cls -> sig
immediate_clear = runMethod @"immediate_clear"

immediate_color :: Method "immediate_color" cls sig => cls -> sig
immediate_color = runMethod @"immediate_color"

immediate_create :: Method "immediate_create" cls sig => cls -> sig
immediate_create = runMethod @"immediate_create"

immediate_end :: Method "immediate_end" cls sig => cls -> sig
immediate_end = runMethod @"immediate_end"

immediate_get_material ::
                         Method "immediate_get_material" cls sig => cls -> sig
immediate_get_material = runMethod @"immediate_get_material"

immediate_normal :: Method "immediate_normal" cls sig => cls -> sig
immediate_normal = runMethod @"immediate_normal"

immediate_set_material ::
                         Method "immediate_set_material" cls sig => cls -> sig
immediate_set_material = runMethod @"immediate_set_material"

immediate_tangent ::
                    Method "immediate_tangent" cls sig => cls -> sig
immediate_tangent = runMethod @"immediate_tangent"

immediate_uv :: Method "immediate_uv" cls sig => cls -> sig
immediate_uv = runMethod @"immediate_uv"

immediate_uv2 :: Method "immediate_uv2" cls sig => cls -> sig
immediate_uv2 = runMethod @"immediate_uv2"

immediate_vertex :: Method "immediate_vertex" cls sig => cls -> sig
immediate_vertex = runMethod @"immediate_vertex"

immediate_vertex_2d ::
                      Method "immediate_vertex_2d" cls sig => cls -> sig
immediate_vertex_2d = runMethod @"immediate_vertex_2d"

import' :: Method "import" cls sig => cls -> sig
import' = runMethod @"import"

import_animation_from_other_importer ::
                                       Method "import_animation_from_other_importer" cls sig =>
                                       cls -> sig
import_animation_from_other_importer
  = runMethod @"import_animation_from_other_importer"

import_scene_from_other_importer ::
                                   Method "import_scene_from_other_importer" cls sig => cls -> sig
import_scene_from_other_importer
  = runMethod @"import_scene_from_other_importer"

index :: Method "index" cls sig => cls -> sig
index = runMethod @"index"

init :: Method "init" cls sig => cls -> sig
init = runMethod @"init"

init_ref :: Method "init_ref" cls sig => cls -> sig
init_ref = runMethod @"init_ref"

initialize :: Method "initialize" cls sig => cls -> sig
initialize = runMethod @"initialize"

input :: Method "input" cls sig => cls -> sig
input = runMethod @"input"

input_event :: Method "input_event" cls sig => cls -> sig
input_event = runMethod @"input_event"

input_text :: Method "input_text" cls sig => cls -> sig
input_text = runMethod @"input_text"

insert_text_at_cursor ::
                        Method "insert_text_at_cursor" cls sig => cls -> sig
insert_text_at_cursor = runMethod @"insert_text_at_cursor"

inspect_object :: Method "inspect_object" cls sig => cls -> sig
inspect_object = runMethod @"inspect_object"

instance' :: Method "instance" cls sig => cls -> sig
instance' = runMethod @"instance"

instance_attach_object_instance_id ::
                                     Method "instance_attach_object_instance_id" cls sig =>
                                     cls -> sig
instance_attach_object_instance_id
  = runMethod @"instance_attach_object_instance_id"

instance_attach_skeleton ::
                           Method "instance_attach_skeleton" cls sig => cls -> sig
instance_attach_skeleton = runMethod @"instance_attach_skeleton"

instance_create :: Method "instance_create" cls sig => cls -> sig
instance_create = runMethod @"instance_create"

instance_create2 :: Method "instance_create2" cls sig => cls -> sig
instance_create2 = runMethod @"instance_create2"

instance_geometry_set_as_instance_lod ::
                                        Method "instance_geometry_set_as_instance_lod" cls sig =>
                                        cls -> sig
instance_geometry_set_as_instance_lod
  = runMethod @"instance_geometry_set_as_instance_lod"

instance_geometry_set_cast_shadows_setting ::
                                             Method "instance_geometry_set_cast_shadows_setting" cls
                                               sig =>
                                             cls -> sig
instance_geometry_set_cast_shadows_setting
  = runMethod @"instance_geometry_set_cast_shadows_setting"

instance_geometry_set_draw_range ::
                                   Method "instance_geometry_set_draw_range" cls sig => cls -> sig
instance_geometry_set_draw_range
  = runMethod @"instance_geometry_set_draw_range"

instance_geometry_set_flag ::
                             Method "instance_geometry_set_flag" cls sig => cls -> sig
instance_geometry_set_flag
  = runMethod @"instance_geometry_set_flag"

instance_geometry_set_material_override ::
                                          Method "instance_geometry_set_material_override" cls
                                            sig =>
                                          cls -> sig
instance_geometry_set_material_override
  = runMethod @"instance_geometry_set_material_override"

instance_has :: Method "instance_has" cls sig => cls -> sig
instance_has = runMethod @"instance_has"

instance_set_base ::
                    Method "instance_set_base" cls sig => cls -> sig
instance_set_base = runMethod @"instance_set_base"

instance_set_blend_shape_weight ::
                                  Method "instance_set_blend_shape_weight" cls sig => cls -> sig
instance_set_blend_shape_weight
  = runMethod @"instance_set_blend_shape_weight"

instance_set_custom_aabb ::
                           Method "instance_set_custom_aabb" cls sig => cls -> sig
instance_set_custom_aabb = runMethod @"instance_set_custom_aabb"

instance_set_exterior ::
                        Method "instance_set_exterior" cls sig => cls -> sig
instance_set_exterior = runMethod @"instance_set_exterior"

instance_set_extra_visibility_margin ::
                                       Method "instance_set_extra_visibility_margin" cls sig =>
                                       cls -> sig
instance_set_extra_visibility_margin
  = runMethod @"instance_set_extra_visibility_margin"

instance_set_layer_mask ::
                          Method "instance_set_layer_mask" cls sig => cls -> sig
instance_set_layer_mask = runMethod @"instance_set_layer_mask"

instance_set_scenario ::
                        Method "instance_set_scenario" cls sig => cls -> sig
instance_set_scenario = runMethod @"instance_set_scenario"

instance_set_surface_material ::
                                Method "instance_set_surface_material" cls sig => cls -> sig
instance_set_surface_material
  = runMethod @"instance_set_surface_material"

instance_set_transform ::
                         Method "instance_set_transform" cls sig => cls -> sig
instance_set_transform = runMethod @"instance_set_transform"

instance_set_use_lightmap ::
                            Method "instance_set_use_lightmap" cls sig => cls -> sig
instance_set_use_lightmap = runMethod @"instance_set_use_lightmap"

instance_set_visible ::
                       Method "instance_set_visible" cls sig => cls -> sig
instance_set_visible = runMethod @"instance_set_visible"

instances_cull_aabb ::
                      Method "instances_cull_aabb" cls sig => cls -> sig
instances_cull_aabb = runMethod @"instances_cull_aabb"

instances_cull_convex ::
                        Method "instances_cull_convex" cls sig => cls -> sig
instances_cull_convex = runMethod @"instances_cull_convex"

instances_cull_ray ::
                     Method "instances_cull_ray" cls sig => cls -> sig
instances_cull_ray = runMethod @"instances_cull_ray"

integrate_forces :: Method "integrate_forces" cls sig => cls -> sig
integrate_forces = runMethod @"integrate_forces"

interpolate :: Method "interpolate" cls sig => cls -> sig
interpolate = runMethod @"interpolate"

interpolate_baked ::
                    Method "interpolate_baked" cls sig => cls -> sig
interpolate_baked = runMethod @"interpolate_baked"

interpolate_baked_up_vector ::
                              Method "interpolate_baked_up_vector" cls sig => cls -> sig
interpolate_baked_up_vector
  = runMethod @"interpolate_baked_up_vector"

interpolate_callback ::
                       Method "interpolate_callback" cls sig => cls -> sig
interpolate_callback = runMethod @"interpolate_callback"

interpolate_deferred_callback ::
                                Method "interpolate_deferred_callback" cls sig => cls -> sig
interpolate_deferred_callback
  = runMethod @"interpolate_deferred_callback"

interpolate_method ::
                     Method "interpolate_method" cls sig => cls -> sig
interpolate_method = runMethod @"interpolate_method"

interpolate_property ::
                       Method "interpolate_property" cls sig => cls -> sig
interpolate_property = runMethod @"interpolate_property"

interpolatef :: Method "interpolatef" cls sig => cls -> sig
interpolatef = runMethod @"interpolatef"

intersect_point :: Method "intersect_point" cls sig => cls -> sig
intersect_point = runMethod @"intersect_point"

intersect_ray :: Method "intersect_ray" cls sig => cls -> sig
intersect_ray = runMethod @"intersect_ray"

intersect_shape :: Method "intersect_shape" cls sig => cls -> sig
intersect_shape = runMethod @"intersect_shape"

invalidate :: Method "invalidate" cls sig => cls -> sig
invalidate = runMethod @"invalidate"

is_3d_disabled :: Method "is_3d_disabled" cls sig => cls -> sig
is_3d_disabled = runMethod @"is_3d_disabled"

is_a_parent_of :: Method "is_a_parent_of" cls sig => cls -> sig
is_a_parent_of = runMethod @"is_a_parent_of"

is_able_to_sleep :: Method "is_able_to_sleep" cls sig => cls -> sig
is_able_to_sleep = runMethod @"is_able_to_sleep"

is_absorbent :: Method "is_absorbent" cls sig => cls -> sig
is_absorbent = runMethod @"is_absorbent"

is_action :: Method "is_action" cls sig => cls -> sig
is_action = runMethod @"is_action"

is_action_just_pressed ::
                         Method "is_action_just_pressed" cls sig => cls -> sig
is_action_just_pressed = runMethod @"is_action_just_pressed"

is_action_just_released ::
                          Method "is_action_just_released" cls sig => cls -> sig
is_action_just_released = runMethod @"is_action_just_released"

is_action_pressed ::
                    Method "is_action_pressed" cls sig => cls -> sig
is_action_pressed = runMethod @"is_action_pressed"

is_action_released ::
                     Method "is_action_released" cls sig => cls -> sig
is_action_released = runMethod @"is_action_released"

is_action_type :: Method "is_action_type" cls sig => cls -> sig
is_action_type = runMethod @"is_action_type"

is_active :: Method "is_active" cls sig => cls -> sig
is_active = runMethod @"is_active"

is_adjustment_enabled ::
                        Method "is_adjustment_enabled" cls sig => cls -> sig
is_adjustment_enabled = runMethod @"is_adjustment_enabled"

is_always_ordered ::
                    Method "is_always_ordered" cls sig => cls -> sig
is_always_ordered = runMethod @"is_always_ordered"

is_anti_aliased :: Method "is_anti_aliased" cls sig => cls -> sig
is_anti_aliased = runMethod @"is_anti_aliased"

is_anything_selected ::
                       Method "is_anything_selected" cls sig => cls -> sig
is_anything_selected = runMethod @"is_anything_selected"

is_audio_listener ::
                    Method "is_audio_listener" cls sig => cls -> sig
is_audio_listener = runMethod @"is_audio_listener"

is_audio_listener_2d ::
                       Method "is_audio_listener_2d" cls sig => cls -> sig
is_audio_listener_2d = runMethod @"is_audio_listener_2d"

is_autoplay_enabled ::
                      Method "is_autoplay_enabled" cls sig => cls -> sig
is_autoplay_enabled = runMethod @"is_autoplay_enabled"

is_big_endian_enabled ::
                        Method "is_big_endian_enabled" cls sig => cls -> sig
is_big_endian_enabled = runMethod @"is_big_endian_enabled"

is_blend_splits_enabled ::
                          Method "is_blend_splits_enabled" cls sig => cls -> sig
is_blend_splits_enabled = runMethod @"is_blend_splits_enabled"

is_blocking_handshake_enabled ::
                                Method "is_blocking_handshake_enabled" cls sig => cls -> sig
is_blocking_handshake_enabled
  = runMethod @"is_blocking_handshake_enabled"

is_blocking_mode_enabled ::
                           Method "is_blocking_mode_enabled" cls sig => cls -> sig
is_blocking_mode_enabled = runMethod @"is_blocking_mode_enabled"

is_blocking_signals ::
                      Method "is_blocking_signals" cls sig => cls -> sig
is_blocking_signals = runMethod @"is_blocking_signals"

is_bone_rest_disabled ::
                        Method "is_bone_rest_disabled" cls sig => cls -> sig
is_bone_rest_disabled = runMethod @"is_bone_rest_disabled"

is_box_projection_enabled ::
                            Method "is_box_projection_enabled" cls sig => cls -> sig
is_box_projection_enabled = runMethod @"is_box_projection_enabled"

is_breakpoint_gutter_enabled ::
                               Method "is_breakpoint_gutter_enabled" cls sig => cls -> sig
is_breakpoint_gutter_enabled
  = runMethod @"is_breakpoint_gutter_enabled"

is_bus_bypassing_effects ::
                           Method "is_bus_bypassing_effects" cls sig => cls -> sig
is_bus_bypassing_effects = runMethod @"is_bus_bypassing_effects"

is_bus_effect_enabled ::
                        Method "is_bus_effect_enabled" cls sig => cls -> sig
is_bus_effect_enabled = runMethod @"is_bus_effect_enabled"

is_bus_mute :: Method "is_bus_mute" cls sig => cls -> sig
is_bus_mute = runMethod @"is_bus_mute"

is_bus_solo :: Method "is_bus_solo" cls sig => cls -> sig
is_bus_solo = runMethod @"is_bus_solo"

is_button_disabled ::
                     Method "is_button_disabled" cls sig => cls -> sig
is_button_disabled = runMethod @"is_button_disabled"

is_button_pressed ::
                    Method "is_button_pressed" cls sig => cls -> sig
is_button_pressed = runMethod @"is_button_pressed"

is_cell_transposed ::
                     Method "is_cell_transposed" cls sig => cls -> sig
is_cell_transposed = runMethod @"is_cell_transposed"

is_cell_x_flipped ::
                    Method "is_cell_x_flipped" cls sig => cls -> sig
is_cell_x_flipped = runMethod @"is_cell_x_flipped"

is_cell_y_flipped ::
                    Method "is_cell_y_flipped" cls sig => cls -> sig
is_cell_y_flipped = runMethod @"is_cell_y_flipped"

is_centered :: Method "is_centered" cls sig => cls -> sig
is_centered = runMethod @"is_centered"

is_checkable :: Method "is_checkable" cls sig => cls -> sig
is_checkable = runMethod @"is_checkable"

is_checked :: Method "is_checked" cls sig => cls -> sig
is_checked = runMethod @"is_checked"

is_class :: Method "is_class" cls sig => cls -> sig
is_class = runMethod @"is_class"

is_class_enabled :: Method "is_class_enabled" cls sig => cls -> sig
is_class_enabled = runMethod @"is_class_enabled"

is_clear_button_enabled ::
                          Method "is_clear_button_enabled" cls sig => cls -> sig
is_clear_button_enabled = runMethod @"is_clear_button_enabled"

is_clip_to_areas_enabled ::
                           Method "is_clip_to_areas_enabled" cls sig => cls -> sig
is_clip_to_areas_enabled = runMethod @"is_clip_to_areas_enabled"

is_clip_to_bodies_enabled ::
                            Method "is_clip_to_bodies_enabled" cls sig => cls -> sig
is_clip_to_bodies_enabled = runMethod @"is_clip_to_bodies_enabled"

is_clipping_contents ::
                       Method "is_clipping_contents" cls sig => cls -> sig
is_clipping_contents = runMethod @"is_clipping_contents"

is_clipping_text :: Method "is_clipping_text" cls sig => cls -> sig
is_clipping_text = runMethod @"is_clipping_text"

is_close_button_visible ::
                          Method "is_close_button_visible" cls sig => cls -> sig
is_close_button_visible = runMethod @"is_close_button_visible"

is_closed :: Method "is_closed" cls sig => cls -> sig
is_closed = runMethod @"is_closed"

is_collapsed :: Method "is_collapsed" cls sig => cls -> sig
is_collapsed = runMethod @"is_collapsed"

is_collide_with_areas_enabled ::
                                Method "is_collide_with_areas_enabled" cls sig => cls -> sig
is_collide_with_areas_enabled
  = runMethod @"is_collide_with_areas_enabled"

is_collide_with_bodies_enabled ::
                                 Method "is_collide_with_bodies_enabled" cls sig => cls -> sig
is_collide_with_bodies_enabled
  = runMethod @"is_collide_with_bodies_enabled"

is_colliding :: Method "is_colliding" cls sig => cls -> sig
is_colliding = runMethod @"is_colliding"

is_comment :: Method "is_comment" cls sig => cls -> sig
is_comment = runMethod @"is_comment"

is_compressed :: Method "is_compressed" cls sig => cls -> sig
is_compressed = runMethod @"is_compressed"

is_cone :: Method "is_cone" cls sig => cls -> sig
is_cone = runMethod @"is_cone"

is_connected :: Method "is_connected" cls sig => cls -> sig
is_connected = runMethod @"is_connected"

is_connected_to_host ::
                       Method "is_connected_to_host" cls sig => cls -> sig
is_connected_to_host = runMethod @"is_connected_to_host"

is_connection_available ::
                          Method "is_connection_available" cls sig => cls -> sig
is_connection_available = runMethod @"is_connection_available"

is_contact_monitor_enabled ::
                             Method "is_contact_monitor_enabled" cls sig => cls -> sig
is_contact_monitor_enabled
  = runMethod @"is_contact_monitor_enabled"

is_context_menu_enabled ::
                          Method "is_context_menu_enabled" cls sig => cls -> sig
is_context_menu_enabled = runMethod @"is_context_menu_enabled"

is_current :: Method "is_current" cls sig => cls -> sig
is_current = runMethod @"is_current"

is_custom_set_as_button ::
                          Method "is_custom_set_as_button" cls sig => cls -> sig
is_custom_set_as_button = runMethod @"is_custom_set_as_button"

is_debug_build :: Method "is_debug_build" cls sig => cls -> sig
is_debug_build = runMethod @"is_debug_build"

is_debugging_collisions_hint ::
                               Method "is_debugging_collisions_hint" cls sig => cls -> sig
is_debugging_collisions_hint
  = runMethod @"is_debugging_collisions_hint"

is_debugging_navigation_hint ::
                               Method "is_debugging_navigation_hint" cls sig => cls -> sig
is_debugging_navigation_hint
  = runMethod @"is_debugging_navigation_hint"

is_deferred_mode :: Method "is_deferred_mode" cls sig => cls -> sig
is_deferred_mode = runMethod @"is_deferred_mode"

is_depth_deep_parallax_enabled ::
                                 Method "is_depth_deep_parallax_enabled" cls sig => cls -> sig
is_depth_deep_parallax_enabled
  = runMethod @"is_depth_deep_parallax_enabled"

is_disabled :: Method "is_disabled" cls sig => cls -> sig
is_disabled = runMethod @"is_disabled"

is_discover_ipv6 :: Method "is_discover_ipv6" cls sig => cls -> sig
is_discover_ipv6 = runMethod @"is_discover_ipv6"

is_displayed_folded ::
                      Method "is_displayed_folded" cls sig => cls -> sig
is_displayed_folded = runMethod @"is_displayed_folded"

is_distance_field_hint ::
                         Method "is_distance_field_hint" cls sig => cls -> sig
is_distance_field_hint = runMethod @"is_distance_field_hint"

is_dof_blur_far_enabled ::
                          Method "is_dof_blur_far_enabled" cls sig => cls -> sig
is_dof_blur_far_enabled = runMethod @"is_dof_blur_far_enabled"

is_dof_blur_near_enabled ::
                           Method "is_dof_blur_near_enabled" cls sig => cls -> sig
is_dof_blur_near_enabled = runMethod @"is_dof_blur_near_enabled"

is_doubleclick :: Method "is_doubleclick" cls sig => cls -> sig
is_doubleclick = runMethod @"is_doubleclick"

is_draw_behind_parent_enabled ::
                                Method "is_draw_behind_parent_enabled" cls sig => cls -> sig
is_draw_behind_parent_enabled
  = runMethod @"is_draw_behind_parent_enabled"

is_draw_center_enabled ::
                         Method "is_draw_center_enabled" cls sig => cls -> sig
is_draw_center_enabled = runMethod @"is_draw_center_enabled"

is_draw_red :: Method "is_draw_red" cls sig => cls -> sig
is_draw_red = runMethod @"is_draw_red"

is_echo :: Method "is_echo" cls sig => cls -> sig
is_echo = runMethod @"is_echo"

is_editable :: Method "is_editable" cls sig => cls -> sig
is_editable = runMethod @"is_editable"

is_editing_alpha :: Method "is_editing_alpha" cls sig => cls -> sig
is_editing_alpha = runMethod @"is_editing_alpha"

is_editor_hint :: Method "is_editor_hint" cls sig => cls -> sig
is_editor_hint = runMethod @"is_editor_hint"

is_editor_only :: Method "is_editor_only" cls sig => cls -> sig
is_editor_only = runMethod @"is_editor_only"

is_emission_angle_enabled ::
                            Method "is_emission_angle_enabled" cls sig => cls -> sig
is_emission_angle_enabled = runMethod @"is_emission_angle_enabled"

is_emitting :: Method "is_emitting" cls sig => cls -> sig
is_emitting = runMethod @"is_emitting"

is_empty :: Method "is_empty" cls sig => cls -> sig
is_empty = runMethod @"is_empty"

is_enabled :: Method "is_enabled" cls sig => cls -> sig
is_enabled = runMethod @"is_enabled"

is_enabler_enabled ::
                     Method "is_enabler_enabled" cls sig => cls -> sig
is_enabler_enabled = runMethod @"is_enabler_enabled"

is_exclusive :: Method "is_exclusive" cls sig => cls -> sig
is_exclusive = runMethod @"is_exclusive"

is_feedback_active ::
                     Method "is_feedback_active" cls sig => cls -> sig
is_feedback_active = runMethod @"is_feedback_active"

is_filter_enabled ::
                    Method "is_filter_enabled" cls sig => cls -> sig
is_filter_enabled = runMethod @"is_filter_enabled"

is_flat :: Method "is_flat" cls sig => cls -> sig
is_flat = runMethod @"is_flat"

is_flipped_h :: Method "is_flipped_h" cls sig => cls -> sig
is_flipped_h = runMethod @"is_flipped_h"

is_flipped_v :: Method "is_flipped_v" cls sig => cls -> sig
is_flipped_v = runMethod @"is_flipped_v"

is_fog_depth_enabled ::
                       Method "is_fog_depth_enabled" cls sig => cls -> sig
is_fog_depth_enabled = runMethod @"is_fog_depth_enabled"

is_fog_enabled :: Method "is_fog_enabled" cls sig => cls -> sig
is_fog_enabled = runMethod @"is_fog_enabled"

is_fog_height_enabled ::
                        Method "is_fog_height_enabled" cls sig => cls -> sig
is_fog_height_enabled = runMethod @"is_fog_height_enabled"

is_fog_transmit_enabled ::
                          Method "is_fog_transmit_enabled" cls sig => cls -> sig
is_fog_transmit_enabled = runMethod @"is_fog_transmit_enabled"

is_folded :: Method "is_folded" cls sig => cls -> sig
is_folded = runMethod @"is_folded"

is_folding_disabled ::
                      Method "is_folding_disabled" cls sig => cls -> sig
is_folding_disabled = runMethod @"is_folding_disabled"

is_folding_hidden ::
                    Method "is_folding_hidden" cls sig => cls -> sig
is_folding_hidden = runMethod @"is_folding_hidden"

is_follow_smoothing_enabled ::
                              Method "is_follow_smoothing_enabled" cls sig => cls -> sig
is_follow_smoothing_enabled
  = runMethod @"is_follow_smoothing_enabled"

is_glow_bicubic_upscale_enabled ::
                                  Method "is_glow_bicubic_upscale_enabled" cls sig => cls -> sig
is_glow_bicubic_upscale_enabled
  = runMethod @"is_glow_bicubic_upscale_enabled"

is_glow_enabled :: Method "is_glow_enabled" cls sig => cls -> sig
is_glow_enabled = runMethod @"is_glow_enabled"

is_glow_level_enabled ::
                        Method "is_glow_level_enabled" cls sig => cls -> sig
is_glow_level_enabled = runMethod @"is_glow_level_enabled"

is_gravity_a_point ::
                     Method "is_gravity_a_point" cls sig => cls -> sig
is_gravity_a_point = runMethod @"is_gravity_a_point"

is_greater_allowed ::
                     Method "is_greater_allowed" cls sig => cls -> sig
is_greater_allowed = runMethod @"is_greater_allowed"

is_greater_than :: Method "is_greater_than" cls sig => cls -> sig
is_greater_than = runMethod @"is_greater_than"

is_grow_enabled :: Method "is_grow_enabled" cls sig => cls -> sig
is_grow_enabled = runMethod @"is_grow_enabled"

is_h_drag_enabled ::
                    Method "is_h_drag_enabled" cls sig => cls -> sig
is_h_drag_enabled = runMethod @"is_h_drag_enabled"

is_h_scroll_enabled ::
                      Method "is_h_scroll_enabled" cls sig => cls -> sig
is_h_scroll_enabled = runMethod @"is_h_scroll_enabled"

is_hdr :: Method "is_hdr" cls sig => cls -> sig
is_hdr = runMethod @"is_hdr"

is_hide_on_checkable_item_selection ::
                                      Method "is_hide_on_checkable_item_selection" cls sig =>
                                      cls -> sig
is_hide_on_checkable_item_selection
  = runMethod @"is_hide_on_checkable_item_selection"

is_hide_on_item_selection ::
                            Method "is_hide_on_item_selection" cls sig => cls -> sig
is_hide_on_item_selection = runMethod @"is_hide_on_item_selection"

is_hide_on_state_item_selection ::
                                  Method "is_hide_on_state_item_selection" cls sig => cls -> sig
is_hide_on_state_item_selection
  = runMethod @"is_hide_on_state_item_selection"

is_hide_on_window_lose_focus ::
                               Method "is_hide_on_window_lose_focus" cls sig => cls -> sig
is_hide_on_window_lose_focus
  = runMethod @"is_hide_on_window_lose_focus"

is_hiding_enabled ::
                    Method "is_hiding_enabled" cls sig => cls -> sig
is_hiding_enabled = runMethod @"is_hiding_enabled"

is_highlight_all_occurrences_enabled ::
                                       Method "is_highlight_all_occurrences_enabled" cls sig =>
                                       cls -> sig
is_highlight_all_occurrences_enabled
  = runMethod @"is_highlight_all_occurrences_enabled"

is_highlight_current_line_enabled ::
                                    Method "is_highlight_current_line_enabled" cls sig => cls -> sig
is_highlight_current_line_enabled
  = runMethod @"is_highlight_current_line_enabled"

is_hovered :: Method "is_hovered" cls sig => cls -> sig
is_hovered = runMethod @"is_hovered"

is_ignore_camera_zoom ::
                        Method "is_ignore_camera_zoom" cls sig => cls -> sig
is_ignore_camera_zoom = runMethod @"is_ignore_camera_zoom"

is_in_contact :: Method "is_in_contact" cls sig => cls -> sig
is_in_contact = runMethod @"is_in_contact"

is_in_group :: Method "is_in_group" cls sig => cls -> sig
is_in_group = runMethod @"is_in_group"

is_in_low_processor_usage_mode ::
                                 Method "is_in_low_processor_usage_mode" cls sig => cls -> sig
is_in_low_processor_usage_mode
  = runMethod @"is_in_low_processor_usage_mode"

is_in_physics_frame ::
                      Method "is_in_physics_frame" cls sig => cls -> sig
is_in_physics_frame = runMethod @"is_in_physics_frame"

is_initialized :: Method "is_initialized" cls sig => cls -> sig
is_initialized = runMethod @"is_initialized"

is_input_disabled ::
                    Method "is_input_disabled" cls sig => cls -> sig
is_input_disabled = runMethod @"is_input_disabled"

is_input_handled :: Method "is_input_handled" cls sig => cls -> sig
is_input_handled = runMethod @"is_input_handled"

is_input_set_as_auto_advance ::
                               Method "is_input_set_as_auto_advance" cls sig => cls -> sig
is_input_set_as_auto_advance
  = runMethod @"is_input_set_as_auto_advance"

is_inside_tree :: Method "is_inside_tree" cls sig => cls -> sig
is_inside_tree = runMethod @"is_inside_tree"

is_interior :: Method "is_interior" cls sig => cls -> sig
is_interior = runMethod @"is_interior"

is_interpolation_enabled ::
                           Method "is_interpolation_enabled" cls sig => cls -> sig
is_interpolation_enabled = runMethod @"is_interpolation_enabled"

is_inverting_faces ::
                     Method "is_inverting_faces" cls sig => cls -> sig
is_inverting_faces = runMethod @"is_inverting_faces"

is_invisible :: Method "is_invisible" cls sig => cls -> sig
is_invisible = runMethod @"is_invisible"

is_item_checkable ::
                    Method "is_item_checkable" cls sig => cls -> sig
is_item_checkable = runMethod @"is_item_checkable"

is_item_checked :: Method "is_item_checked" cls sig => cls -> sig
is_item_checked = runMethod @"is_item_checked"

is_item_disabled :: Method "is_item_disabled" cls sig => cls -> sig
is_item_disabled = runMethod @"is_item_disabled"

is_item_radio_checkable ::
                          Method "is_item_radio_checkable" cls sig => cls -> sig
is_item_radio_checkable = runMethod @"is_item_radio_checkable"

is_item_selectable ::
                     Method "is_item_selectable" cls sig => cls -> sig
is_item_selectable = runMethod @"is_item_selectable"

is_item_separator ::
                    Method "is_item_separator" cls sig => cls -> sig
is_item_separator = runMethod @"is_item_separator"

is_item_shortcut_disabled ::
                            Method "is_item_shortcut_disabled" cls sig => cls -> sig
is_item_shortcut_disabled = runMethod @"is_item_shortcut_disabled"

is_item_tooltip_enabled ::
                          Method "is_item_tooltip_enabled" cls sig => cls -> sig
is_item_tooltip_enabled = runMethod @"is_item_tooltip_enabled"

is_joy_button_pressed ::
                        Method "is_joy_button_pressed" cls sig => cls -> sig
is_joy_button_pressed = runMethod @"is_joy_button_pressed"

is_joy_known :: Method "is_joy_known" cls sig => cls -> sig
is_joy_known = runMethod @"is_joy_known"

is_keep_screen_on ::
                    Method "is_keep_screen_on" cls sig => cls -> sig
is_keep_screen_on = runMethod @"is_keep_screen_on"

is_key_pressed :: Method "is_key_pressed" cls sig => cls -> sig
is_key_pressed = runMethod @"is_key_pressed"

is_keying :: Method "is_keying" cls sig => cls -> sig
is_keying = runMethod @"is_keying"

is_lesser_allowed ::
                    Method "is_lesser_allowed" cls sig => cls -> sig
is_lesser_allowed = runMethod @"is_lesser_allowed"

is_limit_drawing_enabled ::
                           Method "is_limit_drawing_enabled" cls sig => cls -> sig
is_limit_drawing_enabled = runMethod @"is_limit_drawing_enabled"

is_limit_smoothing_enabled ::
                             Method "is_limit_smoothing_enabled" cls sig => cls -> sig
is_limit_smoothing_enabled
  = runMethod @"is_limit_smoothing_enabled"

is_line_hidden :: Method "is_line_hidden" cls sig => cls -> sig
is_line_hidden = runMethod @"is_line_hidden"

is_listening :: Method "is_listening" cls sig => cls -> sig
is_listening = runMethod @"is_listening"

is_local_to_scene ::
                    Method "is_local_to_scene" cls sig => cls -> sig
is_local_to_scene = runMethod @"is_local_to_scene"

is_local_transform_notification_enabled ::
                                          Method "is_local_transform_notification_enabled" cls
                                            sig =>
                                          cls -> sig
is_local_transform_notification_enabled
  = runMethod @"is_local_transform_notification_enabled"

is_margin_drawing_enabled ::
                            Method "is_margin_drawing_enabled" cls sig => cls -> sig
is_margin_drawing_enabled = runMethod @"is_margin_drawing_enabled"

is_meta_underlined ::
                     Method "is_meta_underlined" cls sig => cls -> sig
is_meta_underlined = runMethod @"is_meta_underlined"

is_mode_overriding_title ::
                           Method "is_mode_overriding_title" cls sig => cls -> sig
is_mode_overriding_title = runMethod @"is_mode_overriding_title"

is_monitorable :: Method "is_monitorable" cls sig => cls -> sig
is_monitorable = runMethod @"is_monitorable"

is_monitoring :: Method "is_monitoring" cls sig => cls -> sig
is_monitoring = runMethod @"is_monitoring"

is_mouse_button_pressed ::
                          Method "is_mouse_button_pressed" cls sig => cls -> sig
is_mouse_button_pressed = runMethod @"is_mouse_button_pressed"

is_multiplayer_poll_enabled ::
                              Method "is_multiplayer_poll_enabled" cls sig => cls -> sig
is_multiplayer_poll_enabled
  = runMethod @"is_multiplayer_poll_enabled"

is_negative :: Method "is_negative" cls sig => cls -> sig
is_negative = runMethod @"is_negative"

is_network_master ::
                    Method "is_network_master" cls sig => cls -> sig
is_network_master = runMethod @"is_network_master"

is_network_server ::
                    Method "is_network_server" cls sig => cls -> sig
is_network_server = runMethod @"is_network_server"

is_node_connected ::
                    Method "is_node_connected" cls sig => cls -> sig
is_node_connected = runMethod @"is_node_connected"

is_node_connection ::
                     Method "is_node_connection" cls sig => cls -> sig
is_node_connection = runMethod @"is_node_connection"

is_node_instance_placeholder ::
                               Method "is_node_instance_placeholder" cls sig => cls -> sig
is_node_instance_placeholder
  = runMethod @"is_node_instance_placeholder"

is_normalmap :: Method "is_normalmap" cls sig => cls -> sig
is_normalmap = runMethod @"is_normalmap"

is_object_decoding_allowed ::
                             Method "is_object_decoding_allowed" cls sig => cls -> sig
is_object_decoding_allowed
  = runMethod @"is_object_decoding_allowed"

is_ok_left_and_cancel_right ::
                              Method "is_ok_left_and_cancel_right" cls sig => cls -> sig
is_ok_left_and_cancel_right
  = runMethod @"is_ok_left_and_cancel_right"

is_on_ceiling :: Method "is_on_ceiling" cls sig => cls -> sig
is_on_ceiling = runMethod @"is_on_ceiling"

is_on_floor :: Method "is_on_floor" cls sig => cls -> sig
is_on_floor = runMethod @"is_on_floor"

is_on_screen :: Method "is_on_screen" cls sig => cls -> sig
is_on_screen = runMethod @"is_on_screen"

is_on_wall :: Method "is_on_wall" cls sig => cls -> sig
is_on_wall = runMethod @"is_on_wall"

is_one_shot :: Method "is_one_shot" cls sig => cls -> sig
is_one_shot = runMethod @"is_one_shot"

is_one_way_collision_enabled ::
                               Method "is_one_way_collision_enabled" cls sig => cls -> sig
is_one_way_collision_enabled
  = runMethod @"is_one_way_collision_enabled"

is_open :: Method "is_open" cls sig => cls -> sig
is_open = runMethod @"is_open"

is_overriding_audio_bus ::
                          Method "is_overriding_audio_bus" cls sig => cls -> sig
is_overriding_audio_bus = runMethod @"is_overriding_audio_bus"

is_overriding_selected_font_color ::
                                    Method "is_overriding_selected_font_color" cls sig => cls -> sig
is_overriding_selected_font_color
  = runMethod @"is_overriding_selected_font_color"

is_overwrite_warning_disabled ::
                                Method "is_overwrite_warning_disabled" cls sig => cls -> sig
is_overwrite_warning_disabled
  = runMethod @"is_overwrite_warning_disabled"

is_parent_class :: Method "is_parent_class" cls sig => cls -> sig
is_parent_class = runMethod @"is_parent_class"

is_passby_press_enabled ::
                          Method "is_passby_press_enabled" cls sig => cls -> sig
is_passby_press_enabled = runMethod @"is_passby_press_enabled"

is_path_continuous_u ::
                       Method "is_path_continuous_u" cls sig => cls -> sig
is_path_continuous_u = runMethod @"is_path_continuous_u"

is_path_filtered :: Method "is_path_filtered" cls sig => cls -> sig
is_path_filtered = runMethod @"is_path_filtered"

is_path_joined :: Method "is_path_joined" cls sig => cls -> sig
is_path_joined = runMethod @"is_path_joined"

is_path_local :: Method "is_path_local" cls sig => cls -> sig
is_path_local = runMethod @"is_path_local"

is_paused :: Method "is_paused" cls sig => cls -> sig
is_paused = runMethod @"is_paused"

is_percent_visible ::
                     Method "is_percent_visible" cls sig => cls -> sig
is_percent_visible = runMethod @"is_percent_visible"

is_physics_processing ::
                        Method "is_physics_processing" cls sig => cls -> sig
is_physics_processing = runMethod @"is_physics_processing"

is_physics_processing_internal ::
                                 Method "is_physics_processing_internal" cls sig => cls -> sig
is_physics_processing_internal
  = runMethod @"is_physics_processing_internal"

is_pickable :: Method "is_pickable" cls sig => cls -> sig
is_pickable = runMethod @"is_pickable"

is_pixel_opaque :: Method "is_pixel_opaque" cls sig => cls -> sig
is_pixel_opaque = runMethod @"is_pixel_opaque"

is_playing :: Method "is_playing" cls sig => cls -> sig
is_playing = runMethod @"is_playing"

is_plugin_enabled ::
                    Method "is_plugin_enabled" cls sig => cls -> sig
is_plugin_enabled = runMethod @"is_plugin_enabled"

is_point_inside :: Method "is_point_inside" cls sig => cls -> sig
is_point_inside = runMethod @"is_point_inside"

is_position_behind ::
                     Method "is_position_behind" cls sig => cls -> sig
is_position_behind = runMethod @"is_position_behind"

is_pressed :: Method "is_pressed" cls sig => cls -> sig
is_pressed = runMethod @"is_pressed"

is_primary :: Method "is_primary" cls sig => cls -> sig
is_primary = runMethod @"is_primary"

is_processing :: Method "is_processing" cls sig => cls -> sig
is_processing = runMethod @"is_processing"

is_processing_input ::
                      Method "is_processing_input" cls sig => cls -> sig
is_processing_input = runMethod @"is_processing_input"

is_processing_internal ::
                         Method "is_processing_internal" cls sig => cls -> sig
is_processing_internal = runMethod @"is_processing_internal"

is_processing_unhandled_input ::
                                Method "is_processing_unhandled_input" cls sig => cls -> sig
is_processing_unhandled_input
  = runMethod @"is_processing_unhandled_input"

is_processing_unhandled_key_input ::
                                    Method "is_processing_unhandled_key_input" cls sig => cls -> sig
is_processing_unhandled_key_input
  = runMethod @"is_processing_unhandled_key_input"

is_proximity_fade_enabled ::
                            Method "is_proximity_fade_enabled" cls sig => cls -> sig
is_proximity_fade_enabled = runMethod @"is_proximity_fade_enabled"

is_queued_for_deletion ::
                         Method "is_queued_for_deletion" cls sig => cls -> sig
is_queued_for_deletion = runMethod @"is_queued_for_deletion"

is_ratio_exp :: Method "is_ratio_exp" cls sig => cls -> sig
is_ratio_exp = runMethod @"is_ratio_exp"

is_raw_mode :: Method "is_raw_mode" cls sig => cls -> sig
is_raw_mode = runMethod @"is_raw_mode"

is_ray_pickable :: Method "is_ray_pickable" cls sig => cls -> sig
is_ray_pickable = runMethod @"is_ray_pickable"

is_read_only :: Method "is_read_only" cls sig => cls -> sig
is_read_only = runMethod @"is_read_only"

is_readonly :: Method "is_readonly" cls sig => cls -> sig
is_readonly = runMethod @"is_readonly"

is_recording_active ::
                      Method "is_recording_active" cls sig => cls -> sig
is_recording_active = runMethod @"is_recording_active"

is_refusing_new_connections ::
                              Method "is_refusing_new_connections" cls sig => cls -> sig
is_refusing_new_connections
  = runMethod @"is_refusing_new_connections"

is_refusing_new_network_connections ::
                                      Method "is_refusing_new_network_connections" cls sig =>
                                      cls -> sig
is_refusing_new_network_connections
  = runMethod @"is_refusing_new_network_connections"

is_region :: Method "is_region" cls sig => cls -> sig
is_region = runMethod @"is_region"

is_region_filter_clip_enabled ::
                                Method "is_region_filter_clip_enabled" cls sig => cls -> sig
is_region_filter_clip_enabled
  = runMethod @"is_region_filter_clip_enabled"

is_reloadable :: Method "is_reloadable" cls sig => cls -> sig
is_reloadable = runMethod @"is_reloadable"

is_repeat :: Method "is_repeat" cls sig => cls -> sig
is_repeat = runMethod @"is_repeat"

is_resizable :: Method "is_resizable" cls sig => cls -> sig
is_resizable = runMethod @"is_resizable"

is_response_chunked ::
                      Method "is_response_chunked" cls sig => cls -> sig
is_response_chunked = runMethod @"is_response_chunked"

is_return_value_enabled ::
                          Method "is_return_value_enabled" cls sig => cls -> sig
is_return_value_enabled = runMethod @"is_return_value_enabled"

is_right_click_moving_caret ::
                              Method "is_right_click_moving_caret" cls sig => cls -> sig
is_right_click_moving_caret
  = runMethod @"is_right_click_moving_caret"

is_right_disconnects_enabled ::
                               Method "is_right_disconnects_enabled" cls sig => cls -> sig
is_right_disconnects_enabled
  = runMethod @"is_right_disconnects_enabled"

is_root_hidden :: Method "is_root_hidden" cls sig => cls -> sig
is_root_hidden = runMethod @"is_root_hidden"

is_root_shape :: Method "is_root_shape" cls sig => cls -> sig
is_root_shape = runMethod @"is_root_shape"

is_rotating :: Method "is_rotating" cls sig => cls -> sig
is_rotating = runMethod @"is_rotating"

is_rough :: Method "is_rough" cls sig => cls -> sig
is_rough = runMethod @"is_rough"

is_running :: Method "is_running" cls sig => cls -> sig
is_running = runMethod @"is_running"

is_same_column_width ::
                       Method "is_same_column_width" cls sig => cls -> sig
is_same_column_width = runMethod @"is_same_column_width"

is_scale_disabled ::
                    Method "is_scale_disabled" cls sig => cls -> sig
is_scale_disabled = runMethod @"is_scale_disabled"

is_scancode_unicode ::
                      Method "is_scancode_unicode" cls sig => cls -> sig
is_scancode_unicode = runMethod @"is_scancode_unicode"

is_scanning :: Method "is_scanning" cls sig => cls -> sig
is_scanning = runMethod @"is_scanning"

is_screen_drawing_enabled ::
                            Method "is_screen_drawing_enabled" cls sig => cls -> sig
is_screen_drawing_enabled = runMethod @"is_screen_drawing_enabled"

is_scroll_active :: Method "is_scroll_active" cls sig => cls -> sig
is_scroll_active = runMethod @"is_scroll_active"

is_scroll_following ::
                      Method "is_scroll_following" cls sig => cls -> sig
is_scroll_following = runMethod @"is_scroll_following"

is_scrollable :: Method "is_scrollable" cls sig => cls -> sig
is_scrollable = runMethod @"is_scrollable"

is_secret :: Method "is_secret" cls sig => cls -> sig
is_secret = runMethod @"is_secret"

is_selectable :: Method "is_selectable" cls sig => cls -> sig
is_selectable = runMethod @"is_selectable"

is_selected :: Method "is_selected" cls sig => cls -> sig
is_selected = runMethod @"is_selected"

is_selection_active ::
                      Method "is_selection_active" cls sig => cls -> sig
is_selection_active = runMethod @"is_selection_active"

is_selection_enabled ::
                       Method "is_selection_enabled" cls sig => cls -> sig
is_selection_enabled = runMethod @"is_selection_enabled"

is_set_as_interior ::
                     Method "is_set_as_interior" cls sig => cls -> sig
is_set_as_interior = runMethod @"is_set_as_interior"

is_set_as_toplevel ::
                     Method "is_set_as_toplevel" cls sig => cls -> sig
is_set_as_toplevel = runMethod @"is_set_as_toplevel"

is_shadow_enabled ::
                    Method "is_shadow_enabled" cls sig => cls -> sig
is_shadow_enabled = runMethod @"is_shadow_enabled"

is_shape_centered ::
                    Method "is_shape_centered" cls sig => cls -> sig
is_shape_centered = runMethod @"is_shape_centered"

is_shape_owner_disabled ::
                          Method "is_shape_owner_disabled" cls sig => cls -> sig
is_shape_owner_disabled = runMethod @"is_shape_owner_disabled"

is_shape_owner_one_way_collision_enabled ::
                                           Method "is_shape_owner_one_way_collision_enabled" cls
                                             sig =>
                                           cls -> sig
is_shape_owner_one_way_collision_enabled
  = runMethod @"is_shape_owner_one_way_collision_enabled"

is_shape_visible :: Method "is_shape_visible" cls sig => cls -> sig
is_shape_visible = runMethod @"is_shape_visible"

is_shortcut :: Method "is_shortcut" cls sig => cls -> sig
is_shortcut = runMethod @"is_shortcut"

is_show_line_numbers_enabled ::
                               Method "is_show_line_numbers_enabled" cls sig => cls -> sig
is_show_line_numbers_enabled
  = runMethod @"is_show_line_numbers_enabled"

is_showing_hidden_files ::
                          Method "is_showing_hidden_files" cls sig => cls -> sig
is_showing_hidden_files = runMethod @"is_showing_hidden_files"

is_simulating_physics ::
                        Method "is_simulating_physics" cls sig => cls -> sig
is_simulating_physics = runMethod @"is_simulating_physics"

is_singleton :: Method "is_singleton" cls sig => cls -> sig
is_singleton = runMethod @"is_singleton"

is_size_override_enabled ::
                           Method "is_size_override_enabled" cls sig => cls -> sig
is_size_override_enabled = runMethod @"is_size_override_enabled"

is_size_override_stretch_enabled ::
                                   Method "is_size_override_stretch_enabled" cls sig => cls -> sig
is_size_override_stretch_enabled
  = runMethod @"is_size_override_stretch_enabled"

is_sleeping :: Method "is_sleeping" cls sig => cls -> sig
is_sleeping = runMethod @"is_sleeping"

is_slot_enabled_left ::
                       Method "is_slot_enabled_left" cls sig => cls -> sig
is_slot_enabled_left = runMethod @"is_slot_enabled_left"

is_slot_enabled_right ::
                        Method "is_slot_enabled_right" cls sig => cls -> sig
is_slot_enabled_right = runMethod @"is_slot_enabled_right"

is_smooth_scroll_enabled ::
                           Method "is_smooth_scroll_enabled" cls sig => cls -> sig
is_smooth_scroll_enabled = runMethod @"is_smooth_scroll_enabled"

is_snap_controls_to_pixels_enabled ::
                                     Method "is_snap_controls_to_pixels_enabled" cls sig =>
                                     cls -> sig
is_snap_controls_to_pixels_enabled
  = runMethod @"is_snap_controls_to_pixels_enabled"

is_sort_enabled :: Method "is_sort_enabled" cls sig => cls -> sig
is_sort_enabled = runMethod @"is_sort_enabled"

is_ssao_enabled :: Method "is_ssao_enabled" cls sig => cls -> sig
is_ssao_enabled = runMethod @"is_ssao_enabled"

is_ssr_enabled :: Method "is_ssr_enabled" cls sig => cls -> sig
is_ssr_enabled = runMethod @"is_ssr_enabled"

is_ssr_rough :: Method "is_ssr_rough" cls sig => cls -> sig
is_ssr_rough = runMethod @"is_ssr_rough"

is_static_body :: Method "is_static_body" cls sig => cls -> sig
is_static_body = runMethod @"is_static_body"

is_stdout_verbose ::
                    Method "is_stdout_verbose" cls sig => cls -> sig
is_stdout_verbose = runMethod @"is_stdout_verbose"

is_stereo :: Method "is_stereo" cls sig => cls -> sig
is_stereo = runMethod @"is_stereo"

is_stopped :: Method "is_stopped" cls sig => cls -> sig
is_stopped = runMethod @"is_stopped"

is_stretch_enabled ::
                     Method "is_stretch_enabled" cls sig => cls -> sig
is_stretch_enabled = runMethod @"is_stretch_enabled"

is_sync_to_physics_enabled ::
                             Method "is_sync_to_physics_enabled" cls sig => cls -> sig
is_sync_to_physics_enabled
  = runMethod @"is_sync_to_physics_enabled"

is_syntax_coloring_enabled ::
                             Method "is_syntax_coloring_enabled" cls sig => cls -> sig
is_syntax_coloring_enabled
  = runMethod @"is_syntax_coloring_enabled"

is_tap1_active :: Method "is_tap1_active" cls sig => cls -> sig
is_tap1_active = runMethod @"is_tap1_active"

is_tap2_active :: Method "is_tap2_active" cls sig => cls -> sig
is_tap2_active = runMethod @"is_tap2_active"

is_toggle_mode :: Method "is_toggle_mode" cls sig => cls -> sig
is_toggle_mode = runMethod @"is_toggle_mode"

is_tool :: Method "is_tool" cls sig => cls -> sig
is_tool = runMethod @"is_tool"

is_tracking_physics_step ::
                           Method "is_tracking_physics_step" cls sig => cls -> sig
is_tracking_physics_step = runMethod @"is_tracking_physics_step"

is_transform_notification_enabled ::
                                    Method "is_transform_notification_enabled" cls sig => cls -> sig
is_transform_notification_enabled
  = runMethod @"is_transform_notification_enabled"

is_up_vector_enabled ::
                       Method "is_up_vector_enabled" cls sig => cls -> sig
is_up_vector_enabled = runMethod @"is_up_vector_enabled"

is_uppercase :: Method "is_uppercase" cls sig => cls -> sig
is_uppercase = runMethod @"is_uppercase"

is_used_as_steering ::
                      Method "is_used_as_steering" cls sig => cls -> sig
is_used_as_steering = runMethod @"is_used_as_steering"

is_used_as_traction ::
                      Method "is_used_as_traction" cls sig => cls -> sig
is_used_as_traction = runMethod @"is_used_as_traction"

is_userfs_persistent ::
                       Method "is_userfs_persistent" cls sig => cls -> sig
is_userfs_persistent = runMethod @"is_userfs_persistent"

is_using_bbcode :: Method "is_using_bbcode" cls sig => cls -> sig
is_using_bbcode = runMethod @"is_using_bbcode"

is_using_collision ::
                     Method "is_using_collision" cls sig => cls -> sig
is_using_collision = runMethod @"is_using_collision"

is_using_continuous_collision_detection ::
                                          Method "is_using_continuous_collision_detection" cls
                                            sig =>
                                          cls -> sig
is_using_continuous_collision_detection
  = runMethod @"is_using_continuous_collision_detection"

is_using_custom_integrator ::
                             Method "is_using_custom_integrator" cls sig => cls -> sig
is_using_custom_integrator
  = runMethod @"is_using_custom_integrator"

is_using_font_oversampling ::
                             Method "is_using_font_oversampling" cls sig => cls -> sig
is_using_font_oversampling
  = runMethod @"is_using_font_oversampling"

is_using_magnet :: Method "is_using_magnet" cls sig => cls -> sig
is_using_magnet = runMethod @"is_using_magnet"

is_using_own_world ::
                     Method "is_using_own_world" cls sig => cls -> sig
is_using_own_world = runMethod @"is_using_own_world"

is_using_reverb_bus ::
                      Method "is_using_reverb_bus" cls sig => cls -> sig
is_using_reverb_bus = runMethod @"is_using_reverb_bus"

is_using_rounded_values ::
                          Method "is_using_rounded_values" cls sig => cls -> sig
is_using_rounded_values = runMethod @"is_using_rounded_values"

is_using_snap :: Method "is_using_snap" cls sig => cls -> sig
is_using_snap = runMethod @"is_using_snap"

is_using_sync :: Method "is_using_sync" cls sig => cls -> sig
is_using_sync = runMethod @"is_using_sync"

is_using_threads :: Method "is_using_threads" cls sig => cls -> sig
is_using_threads = runMethod @"is_using_threads"

is_using_top_left ::
                    Method "is_using_top_left" cls sig => cls -> sig
is_using_top_left = runMethod @"is_using_top_left"

is_v_drag_enabled ::
                    Method "is_v_drag_enabled" cls sig => cls -> sig
is_v_drag_enabled = runMethod @"is_v_drag_enabled"

is_v_scroll_enabled ::
                      Method "is_v_scroll_enabled" cls sig => cls -> sig
is_v_scroll_enabled = runMethod @"is_v_scroll_enabled"

is_valid :: Method "is_valid" cls sig => cls -> sig
is_valid = runMethod @"is_valid"

is_valid_connection_type ::
                           Method "is_valid_connection_type" cls sig => cls -> sig
is_valid_connection_type = runMethod @"is_valid_connection_type"

is_valid_gateway :: Method "is_valid_gateway" cls sig => cls -> sig
is_valid_gateway = runMethod @"is_valid_gateway"

is_verify_ssl_enabled ::
                        Method "is_verify_ssl_enabled" cls sig => cls -> sig
is_verify_ssl_enabled = runMethod @"is_verify_ssl_enabled"

is_vertical :: Method "is_vertical" cls sig => cls -> sig
is_vertical = runMethod @"is_vertical"

is_visible :: Method "is_visible" cls sig => cls -> sig
is_visible = runMethod @"is_visible"

is_visible_in_tree ::
                     Method "is_visible_in_tree" cls sig => cls -> sig
is_visible_in_tree = runMethod @"is_visible_in_tree"

is_vsync_enabled :: Method "is_vsync_enabled" cls sig => cls -> sig
is_vsync_enabled = runMethod @"is_vsync_enabled"

is_window_always_on_top ::
                          Method "is_window_always_on_top" cls sig => cls -> sig
is_window_always_on_top = runMethod @"is_window_always_on_top"

is_window_fullscreen ::
                       Method "is_window_fullscreen" cls sig => cls -> sig
is_window_fullscreen = runMethod @"is_window_fullscreen"

is_window_maximized ::
                      Method "is_window_maximized" cls sig => cls -> sig
is_window_maximized = runMethod @"is_window_maximized"

is_window_minimized ::
                      Method "is_window_minimized" cls sig => cls -> sig
is_window_minimized = runMethod @"is_window_minimized"

is_window_resizable ::
                      Method "is_window_resizable" cls sig => cls -> sig
is_window_resizable = runMethod @"is_window_resizable"

is_wrap_enabled :: Method "is_wrap_enabled" cls sig => cls -> sig
is_wrap_enabled = runMethod @"is_wrap_enabled"

is_y_sort_mode_enabled ::
                         Method "is_y_sort_mode_enabled" cls sig => cls -> sig
is_y_sort_mode_enabled = runMethod @"is_y_sort_mode_enabled"

is_z_relative :: Method "is_z_relative" cls sig => cls -> sig
is_z_relative = runMethod @"is_z_relative"

iteration :: Method "iteration" cls sig => cls -> sig
iteration = runMethod @"iteration"

joint_create_cone_twist ::
                          Method "joint_create_cone_twist" cls sig => cls -> sig
joint_create_cone_twist = runMethod @"joint_create_cone_twist"

joint_create_generic_6dof ::
                            Method "joint_create_generic_6dof" cls sig => cls -> sig
joint_create_generic_6dof = runMethod @"joint_create_generic_6dof"

joint_create_hinge ::
                     Method "joint_create_hinge" cls sig => cls -> sig
joint_create_hinge = runMethod @"joint_create_hinge"

joint_create_pin :: Method "joint_create_pin" cls sig => cls -> sig
joint_create_pin = runMethod @"joint_create_pin"

joint_create_slider ::
                      Method "joint_create_slider" cls sig => cls -> sig
joint_create_slider = runMethod @"joint_create_slider"

joint_get_param :: Method "joint_get_param" cls sig => cls -> sig
joint_get_param = runMethod @"joint_get_param"

joint_get_solver_priority ::
                            Method "joint_get_solver_priority" cls sig => cls -> sig
joint_get_solver_priority = runMethod @"joint_get_solver_priority"

joint_get_type :: Method "joint_get_type" cls sig => cls -> sig
joint_get_type = runMethod @"joint_get_type"

joint_set_param :: Method "joint_set_param" cls sig => cls -> sig
joint_set_param = runMethod @"joint_set_param"

joint_set_solver_priority ::
                            Method "joint_set_solver_priority" cls sig => cls -> sig
joint_set_solver_priority = runMethod @"joint_set_solver_priority"

joy_connection_changed ::
                         Method "joy_connection_changed" cls sig => cls -> sig
joy_connection_changed = runMethod @"joy_connection_changed"

kill :: Method "kill" cls sig => cls -> sig
kill = runMethod @"kill"

light_directional_set_blend_splits ::
                                     Method "light_directional_set_blend_splits" cls sig =>
                                     cls -> sig
light_directional_set_blend_splits
  = runMethod @"light_directional_set_blend_splits"

light_directional_set_shadow_depth_range_mode ::
                                                Method
                                                  "light_directional_set_shadow_depth_range_mode"
                                                  cls sig =>
                                                cls -> sig
light_directional_set_shadow_depth_range_mode
  = runMethod @"light_directional_set_shadow_depth_range_mode"

light_directional_set_shadow_mode ::
                                    Method "light_directional_set_shadow_mode" cls sig => cls -> sig
light_directional_set_shadow_mode
  = runMethod @"light_directional_set_shadow_mode"

light_omni_set_shadow_detail ::
                               Method "light_omni_set_shadow_detail" cls sig => cls -> sig
light_omni_set_shadow_detail
  = runMethod @"light_omni_set_shadow_detail"

light_omni_set_shadow_mode ::
                             Method "light_omni_set_shadow_mode" cls sig => cls -> sig
light_omni_set_shadow_mode
  = runMethod @"light_omni_set_shadow_mode"

light_set_color :: Method "light_set_color" cls sig => cls -> sig
light_set_color = runMethod @"light_set_color"

light_set_cull_mask ::
                      Method "light_set_cull_mask" cls sig => cls -> sig
light_set_cull_mask = runMethod @"light_set_cull_mask"

light_set_negative ::
                     Method "light_set_negative" cls sig => cls -> sig
light_set_negative = runMethod @"light_set_negative"

light_set_param :: Method "light_set_param" cls sig => cls -> sig
light_set_param = runMethod @"light_set_param"

light_set_projector ::
                      Method "light_set_projector" cls sig => cls -> sig
light_set_projector = runMethod @"light_set_projector"

light_set_reverse_cull_face_mode ::
                                   Method "light_set_reverse_cull_face_mode" cls sig => cls -> sig
light_set_reverse_cull_face_mode
  = runMethod @"light_set_reverse_cull_face_mode"

light_set_shadow :: Method "light_set_shadow" cls sig => cls -> sig
light_set_shadow = runMethod @"light_set_shadow"

light_set_shadow_color ::
                         Method "light_set_shadow_color" cls sig => cls -> sig
light_set_shadow_color = runMethod @"light_set_shadow_color"

lightmap_capture_create ::
                          Method "lightmap_capture_create" cls sig => cls -> sig
lightmap_capture_create = runMethod @"lightmap_capture_create"

lightmap_capture_get_bounds ::
                              Method "lightmap_capture_get_bounds" cls sig => cls -> sig
lightmap_capture_get_bounds
  = runMethod @"lightmap_capture_get_bounds"

lightmap_capture_get_energy ::
                              Method "lightmap_capture_get_energy" cls sig => cls -> sig
lightmap_capture_get_energy
  = runMethod @"lightmap_capture_get_energy"

lightmap_capture_get_octree ::
                              Method "lightmap_capture_get_octree" cls sig => cls -> sig
lightmap_capture_get_octree
  = runMethod @"lightmap_capture_get_octree"

lightmap_capture_get_octree_cell_subdiv ::
                                          Method "lightmap_capture_get_octree_cell_subdiv" cls
                                            sig =>
                                          cls -> sig
lightmap_capture_get_octree_cell_subdiv
  = runMethod @"lightmap_capture_get_octree_cell_subdiv"

lightmap_capture_get_octree_cell_transform ::
                                             Method "lightmap_capture_get_octree_cell_transform" cls
                                               sig =>
                                             cls -> sig
lightmap_capture_get_octree_cell_transform
  = runMethod @"lightmap_capture_get_octree_cell_transform"

lightmap_capture_set_bounds ::
                              Method "lightmap_capture_set_bounds" cls sig => cls -> sig
lightmap_capture_set_bounds
  = runMethod @"lightmap_capture_set_bounds"

lightmap_capture_set_energy ::
                              Method "lightmap_capture_set_energy" cls sig => cls -> sig
lightmap_capture_set_energy
  = runMethod @"lightmap_capture_set_energy"

lightmap_capture_set_octree ::
                              Method "lightmap_capture_set_octree" cls sig => cls -> sig
lightmap_capture_set_octree
  = runMethod @"lightmap_capture_set_octree"

lightmap_capture_set_octree_cell_subdiv ::
                                          Method "lightmap_capture_set_octree_cell_subdiv" cls
                                            sig =>
                                          cls -> sig
lightmap_capture_set_octree_cell_subdiv
  = runMethod @"lightmap_capture_set_octree_cell_subdiv"

lightmap_capture_set_octree_cell_transform ::
                                             Method "lightmap_capture_set_octree_cell_transform" cls
                                               sig =>
                                             cls -> sig
lightmap_capture_set_octree_cell_transform
  = runMethod @"lightmap_capture_set_octree_cell_transform"

lightmap_unwrap :: Method "lightmap_unwrap" cls sig => cls -> sig
lightmap_unwrap = runMethod @"lightmap_unwrap"

line_intersects_line_2d ::
                          Method "line_intersects_line_2d" cls sig => cls -> sig
line_intersects_line_2d = runMethod @"line_intersects_line_2d"

line_shape_create ::
                    Method "line_shape_create" cls sig => cls -> sig
line_shape_create = runMethod @"line_shape_create"

list_dir_begin :: Method "list_dir_begin" cls sig => cls -> sig
list_dir_begin = runMethod @"list_dir_begin"

list_dir_end :: Method "list_dir_end" cls sig => cls -> sig
list_dir_end = runMethod @"list_dir_end"

listen :: Method "listen" cls sig => cls -> sig
listen = runMethod @"listen"

load :: Method "load" cls sig => cls -> sig
load = runMethod @"load"

load_from_globals ::
                    Method "load_from_globals" cls sig => cls -> sig
load_from_globals = runMethod @"load_from_globals"

load_interactive :: Method "load_interactive" cls sig => cls -> sig
load_interactive = runMethod @"load_interactive"

load_jpg_from_buffer ::
                       Method "load_jpg_from_buffer" cls sig => cls -> sig
load_jpg_from_buffer = runMethod @"load_jpg_from_buffer"

load_png_from_buffer ::
                       Method "load_png_from_buffer" cls sig => cls -> sig
load_png_from_buffer = runMethod @"load_png_from_buffer"

load_resource_pack ::
                     Method "load_resource_pack" cls sig => cls -> sig
load_resource_pack = runMethod @"load_resource_pack"

load_webp_from_buffer ::
                        Method "load_webp_from_buffer" cls sig => cls -> sig
load_webp_from_buffer = runMethod @"load_webp_from_buffer"

localize_path :: Method "localize_path" cls sig => cls -> sig
localize_path = runMethod @"localize_path"

lock :: Method "lock" cls sig => cls -> sig
lock = runMethod @"lock"

look_at :: Method "look_at" cls sig => cls -> sig
look_at = runMethod @"look_at"

look_at_from_position ::
                        Method "look_at_from_position" cls sig => cls -> sig
look_at_from_position = runMethod @"look_at_from_position"

make_atlas :: Method "make_atlas" cls sig => cls -> sig
make_atlas = runMethod @"make_atlas"

make_baked_meshes ::
                    Method "make_baked_meshes" cls sig => cls -> sig
make_baked_meshes = runMethod @"make_baked_meshes"

make_bottom_panel_item_visible ::
                                 Method "make_bottom_panel_item_visible" cls sig => cls -> sig
make_bottom_panel_item_visible
  = runMethod @"make_bottom_panel_item_visible"

make_canvas_position_local ::
                             Method "make_canvas_position_local" cls sig => cls -> sig
make_canvas_position_local
  = runMethod @"make_canvas_position_local"

make_convex_from_brothers ::
                            Method "make_convex_from_brothers" cls sig => cls -> sig
make_convex_from_brothers = runMethod @"make_convex_from_brothers"

make_current :: Method "make_current" cls sig => cls -> sig
make_current = runMethod @"make_current"

make_dir :: Method "make_dir" cls sig => cls -> sig
make_dir = runMethod @"make_dir"

make_dir_recursive ::
                     Method "make_dir_recursive" cls sig => cls -> sig
make_dir_recursive = runMethod @"make_dir_recursive"

make_input_local :: Method "make_input_local" cls sig => cls -> sig
make_input_local = runMethod @"make_input_local"

make_mesh_previews ::
                     Method "make_mesh_previews" cls sig => cls -> sig
make_mesh_previews = runMethod @"make_mesh_previews"

make_polygons_from_outlines ::
                              Method "make_polygons_from_outlines" cls sig => cls -> sig
make_polygons_from_outlines
  = runMethod @"make_polygons_from_outlines"

make_sphere_mesh :: Method "make_sphere_mesh" cls sig => cls -> sig
make_sphere_mesh = runMethod @"make_sphere_mesh"

make_visible :: Method "make_visible" cls sig => cls -> sig
make_visible = runMethod @"make_visible"

map_to_world :: Method "map_to_world" cls sig => cls -> sig
map_to_world = runMethod @"map_to_world"

material_create :: Method "material_create" cls sig => cls -> sig
material_create = runMethod @"material_create"

material_get_param ::
                     Method "material_get_param" cls sig => cls -> sig
material_get_param = runMethod @"material_get_param"

material_get_param_default ::
                             Method "material_get_param_default" cls sig => cls -> sig
material_get_param_default
  = runMethod @"material_get_param_default"

material_get_shader ::
                      Method "material_get_shader" cls sig => cls -> sig
material_get_shader = runMethod @"material_get_shader"

material_set_line_width ::
                          Method "material_set_line_width" cls sig => cls -> sig
material_set_line_width = runMethod @"material_set_line_width"

material_set_next_pass ::
                         Method "material_set_next_pass" cls sig => cls -> sig
material_set_next_pass = runMethod @"material_set_next_pass"

material_set_param ::
                     Method "material_set_param" cls sig => cls -> sig
material_set_param = runMethod @"material_set_param"

material_set_render_priority ::
                               Method "material_set_render_priority" cls sig => cls -> sig
material_set_render_priority
  = runMethod @"material_set_render_priority"

material_set_shader ::
                      Method "material_set_shader" cls sig => cls -> sig
material_set_shader = runMethod @"material_set_shader"

menu_option :: Method "menu_option" cls sig => cls -> sig
menu_option = runMethod @"menu_option"

mesh_add_surface_from_arrays ::
                               Method "mesh_add_surface_from_arrays" cls sig => cls -> sig
mesh_add_surface_from_arrays
  = runMethod @"mesh_add_surface_from_arrays"

mesh_clear :: Method "mesh_clear" cls sig => cls -> sig
mesh_clear = runMethod @"mesh_clear"

mesh_create :: Method "mesh_create" cls sig => cls -> sig
mesh_create = runMethod @"mesh_create"

mesh_get_blend_shape_count ::
                             Method "mesh_get_blend_shape_count" cls sig => cls -> sig
mesh_get_blend_shape_count
  = runMethod @"mesh_get_blend_shape_count"

mesh_get_blend_shape_mode ::
                            Method "mesh_get_blend_shape_mode" cls sig => cls -> sig
mesh_get_blend_shape_mode = runMethod @"mesh_get_blend_shape_mode"

mesh_get_custom_aabb ::
                       Method "mesh_get_custom_aabb" cls sig => cls -> sig
mesh_get_custom_aabb = runMethod @"mesh_get_custom_aabb"

mesh_get_surface_count ::
                         Method "mesh_get_surface_count" cls sig => cls -> sig
mesh_get_surface_count = runMethod @"mesh_get_surface_count"

mesh_remove_surface ::
                      Method "mesh_remove_surface" cls sig => cls -> sig
mesh_remove_surface = runMethod @"mesh_remove_surface"

mesh_set_blend_shape_count ::
                             Method "mesh_set_blend_shape_count" cls sig => cls -> sig
mesh_set_blend_shape_count
  = runMethod @"mesh_set_blend_shape_count"

mesh_set_blend_shape_mode ::
                            Method "mesh_set_blend_shape_mode" cls sig => cls -> sig
mesh_set_blend_shape_mode = runMethod @"mesh_set_blend_shape_mode"

mesh_set_custom_aabb ::
                       Method "mesh_set_custom_aabb" cls sig => cls -> sig
mesh_set_custom_aabb = runMethod @"mesh_set_custom_aabb"

mesh_surface_get_aabb ::
                        Method "mesh_surface_get_aabb" cls sig => cls -> sig
mesh_surface_get_aabb = runMethod @"mesh_surface_get_aabb"

mesh_surface_get_array ::
                         Method "mesh_surface_get_array" cls sig => cls -> sig
mesh_surface_get_array = runMethod @"mesh_surface_get_array"

mesh_surface_get_array_index_len ::
                                   Method "mesh_surface_get_array_index_len" cls sig => cls -> sig
mesh_surface_get_array_index_len
  = runMethod @"mesh_surface_get_array_index_len"

mesh_surface_get_array_len ::
                             Method "mesh_surface_get_array_len" cls sig => cls -> sig
mesh_surface_get_array_len
  = runMethod @"mesh_surface_get_array_len"

mesh_surface_get_arrays ::
                          Method "mesh_surface_get_arrays" cls sig => cls -> sig
mesh_surface_get_arrays = runMethod @"mesh_surface_get_arrays"

mesh_surface_get_blend_shape_arrays ::
                                      Method "mesh_surface_get_blend_shape_arrays" cls sig =>
                                      cls -> sig
mesh_surface_get_blend_shape_arrays
  = runMethod @"mesh_surface_get_blend_shape_arrays"

mesh_surface_get_format ::
                          Method "mesh_surface_get_format" cls sig => cls -> sig
mesh_surface_get_format = runMethod @"mesh_surface_get_format"

mesh_surface_get_format_offset ::
                                 Method "mesh_surface_get_format_offset" cls sig => cls -> sig
mesh_surface_get_format_offset
  = runMethod @"mesh_surface_get_format_offset"

mesh_surface_get_format_stride ::
                                 Method "mesh_surface_get_format_stride" cls sig => cls -> sig
mesh_surface_get_format_stride
  = runMethod @"mesh_surface_get_format_stride"

mesh_surface_get_index_array ::
                               Method "mesh_surface_get_index_array" cls sig => cls -> sig
mesh_surface_get_index_array
  = runMethod @"mesh_surface_get_index_array"

mesh_surface_get_material ::
                            Method "mesh_surface_get_material" cls sig => cls -> sig
mesh_surface_get_material = runMethod @"mesh_surface_get_material"

mesh_surface_get_primitive_type ::
                                  Method "mesh_surface_get_primitive_type" cls sig => cls -> sig
mesh_surface_get_primitive_type
  = runMethod @"mesh_surface_get_primitive_type"

mesh_surface_get_skeleton_aabb ::
                                 Method "mesh_surface_get_skeleton_aabb" cls sig => cls -> sig
mesh_surface_get_skeleton_aabb
  = runMethod @"mesh_surface_get_skeleton_aabb"

mesh_surface_set_material ::
                            Method "mesh_surface_set_material" cls sig => cls -> sig
mesh_surface_set_material = runMethod @"mesh_surface_set_material"

mesh_surface_update_region ::
                             Method "mesh_surface_update_region" cls sig => cls -> sig
mesh_surface_update_region
  = runMethod @"mesh_surface_update_region"

method_track_get_key_indices ::
                               Method "method_track_get_key_indices" cls sig => cls -> sig
method_track_get_key_indices
  = runMethod @"method_track_get_key_indices"

method_track_get_name ::
                        Method "method_track_get_name" cls sig => cls -> sig
method_track_get_name = runMethod @"method_track_get_name"

method_track_get_params ::
                          Method "method_track_get_params" cls sig => cls -> sig
method_track_get_params = runMethod @"method_track_get_params"

minimum_size_changed ::
                       Method "minimum_size_changed" cls sig => cls -> sig
minimum_size_changed = runMethod @"minimum_size_changed"

mix_node_get_amount ::
                      Method "mix_node_get_amount" cls sig => cls -> sig
mix_node_get_amount = runMethod @"mix_node_get_amount"

mix_node_set_amount ::
                      Method "mix_node_set_amount" cls sig => cls -> sig
mix_node_set_amount = runMethod @"mix_node_set_amount"

move_and_collide :: Method "move_and_collide" cls sig => cls -> sig
move_and_collide = runMethod @"move_and_collide"

move_and_slide :: Method "move_and_slide" cls sig => cls -> sig
move_and_slide = runMethod @"move_and_slide"

move_and_slide_with_snap ::
                           Method "move_and_slide_with_snap" cls sig => cls -> sig
move_and_slide_with_snap = runMethod @"move_and_slide_with_snap"

move_bus :: Method "move_bus" cls sig => cls -> sig
move_bus = runMethod @"move_bus"

move_child :: Method "move_child" cls sig => cls -> sig
move_child = runMethod @"move_child"

move_item :: Method "move_item" cls sig => cls -> sig
move_item = runMethod @"move_item"

move_local_x :: Method "move_local_x" cls sig => cls -> sig
move_local_x = runMethod @"move_local_x"

move_local_y :: Method "move_local_y" cls sig => cls -> sig
move_local_y = runMethod @"move_local_y"

move_tab :: Method "move_tab" cls sig => cls -> sig
move_tab = runMethod @"move_tab"

move_to_bottom :: Method "move_to_bottom" cls sig => cls -> sig
move_to_bottom = runMethod @"move_to_bottom"

move_to_top :: Method "move_to_top" cls sig => cls -> sig
move_to_top = runMethod @"move_to_top"

multimesh_allocate ::
                     Method "multimesh_allocate" cls sig => cls -> sig
multimesh_allocate = runMethod @"multimesh_allocate"

multimesh_get_aabb ::
                     Method "multimesh_get_aabb" cls sig => cls -> sig
multimesh_get_aabb = runMethod @"multimesh_get_aabb"

multimesh_get_instance_count ::
                               Method "multimesh_get_instance_count" cls sig => cls -> sig
multimesh_get_instance_count
  = runMethod @"multimesh_get_instance_count"

multimesh_get_mesh ::
                     Method "multimesh_get_mesh" cls sig => cls -> sig
multimesh_get_mesh = runMethod @"multimesh_get_mesh"

multimesh_get_visible_instances ::
                                  Method "multimesh_get_visible_instances" cls sig => cls -> sig
multimesh_get_visible_instances
  = runMethod @"multimesh_get_visible_instances"

multimesh_instance_get_color ::
                               Method "multimesh_instance_get_color" cls sig => cls -> sig
multimesh_instance_get_color
  = runMethod @"multimesh_instance_get_color"

multimesh_instance_get_custom_data ::
                                     Method "multimesh_instance_get_custom_data" cls sig =>
                                     cls -> sig
multimesh_instance_get_custom_data
  = runMethod @"multimesh_instance_get_custom_data"

multimesh_instance_get_transform ::
                                   Method "multimesh_instance_get_transform" cls sig => cls -> sig
multimesh_instance_get_transform
  = runMethod @"multimesh_instance_get_transform"

multimesh_instance_get_transform_2d ::
                                      Method "multimesh_instance_get_transform_2d" cls sig =>
                                      cls -> sig
multimesh_instance_get_transform_2d
  = runMethod @"multimesh_instance_get_transform_2d"

multimesh_instance_set_color ::
                               Method "multimesh_instance_set_color" cls sig => cls -> sig
multimesh_instance_set_color
  = runMethod @"multimesh_instance_set_color"

multimesh_instance_set_custom_data ::
                                     Method "multimesh_instance_set_custom_data" cls sig =>
                                     cls -> sig
multimesh_instance_set_custom_data
  = runMethod @"multimesh_instance_set_custom_data"

multimesh_instance_set_transform ::
                                   Method "multimesh_instance_set_transform" cls sig => cls -> sig
multimesh_instance_set_transform
  = runMethod @"multimesh_instance_set_transform"

multimesh_instance_set_transform_2d ::
                                      Method "multimesh_instance_set_transform_2d" cls sig =>
                                      cls -> sig
multimesh_instance_set_transform_2d
  = runMethod @"multimesh_instance_set_transform_2d"

multimesh_set_as_bulk_array ::
                              Method "multimesh_set_as_bulk_array" cls sig => cls -> sig
multimesh_set_as_bulk_array
  = runMethod @"multimesh_set_as_bulk_array"

multimesh_set_mesh ::
                     Method "multimesh_set_mesh" cls sig => cls -> sig
multimesh_set_mesh = runMethod @"multimesh_set_mesh"

multimesh_set_visible_instances ::
                                  Method "multimesh_set_visible_instances" cls sig => cls -> sig
multimesh_set_visible_instances
  = runMethod @"multimesh_set_visible_instances"

native_video_is_playing ::
                          Method "native_video_is_playing" cls sig => cls -> sig
native_video_is_playing = runMethod @"native_video_is_playing"

native_video_pause ::
                     Method "native_video_pause" cls sig => cls -> sig
native_video_pause = runMethod @"native_video_pause"

native_video_play ::
                    Method "native_video_play" cls sig => cls -> sig
native_video_play = runMethod @"native_video_play"

native_video_stop ::
                    Method "native_video_stop" cls sig => cls -> sig
native_video_stop = runMethod @"native_video_stop"

native_video_unpause ::
                       Method "native_video_unpause" cls sig => cls -> sig
native_video_unpause = runMethod @"native_video_unpause"

navmesh_add :: Method "navmesh_add" cls sig => cls -> sig
navmesh_add = runMethod @"navmesh_add"

navmesh_remove :: Method "navmesh_remove" cls sig => cls -> sig
navmesh_remove = runMethod @"navmesh_remove"

navmesh_set_transform ::
                        Method "navmesh_set_transform" cls sig => cls -> sig
navmesh_set_transform = runMethod @"navmesh_set_transform"

navpoly_add :: Method "navpoly_add" cls sig => cls -> sig
navpoly_add = runMethod @"navpoly_add"

navpoly_remove :: Method "navpoly_remove" cls sig => cls -> sig
navpoly_remove = runMethod @"navpoly_remove"

navpoly_set_transform ::
                        Method "navpoly_set_transform" cls sig => cls -> sig
navpoly_set_transform = runMethod @"navpoly_set_transform"

new :: Method "new" cls sig => cls -> sig
new = runMethod @"new"

newline :: Method "newline" cls sig => cls -> sig
newline = runMethod @"newline"

node_exists :: Method "node_exists" cls sig => cls -> sig
node_exists = runMethod @"node_exists"

node_get_input_count ::
                       Method "node_get_input_count" cls sig => cls -> sig
node_get_input_count = runMethod @"node_get_input_count"

node_get_input_source ::
                        Method "node_get_input_source" cls sig => cls -> sig
node_get_input_source = runMethod @"node_get_input_source"

node_get_position ::
                    Method "node_get_position" cls sig => cls -> sig
node_get_position = runMethod @"node_get_position"

node_get_type :: Method "node_get_type" cls sig => cls -> sig
node_get_type = runMethod @"node_get_type"

node_rename :: Method "node_rename" cls sig => cls -> sig
node_rename = runMethod @"node_rename"

node_set_position ::
                    Method "node_set_position" cls sig => cls -> sig
node_set_position = runMethod @"node_set_position"

normalmap_to_xy :: Method "normalmap_to_xy" cls sig => cls -> sig
normalmap_to_xy = runMethod @"normalmap_to_xy"

notification :: Method "notification" cls sig => cls -> sig
notification = runMethod @"notification"

notify_group :: Method "notify_group" cls sig => cls -> sig
notify_group = runMethod @"notify_group"

notify_group_flags ::
                     Method "notify_group_flags" cls sig => cls -> sig
notify_group_flags = runMethod @"notify_group_flags"

omni_light_create ::
                    Method "omni_light_create" cls sig => cls -> sig
omni_light_create = runMethod @"omni_light_create"

oneshot_node_get_autorestart_delay ::
                                     Method "oneshot_node_get_autorestart_delay" cls sig =>
                                     cls -> sig
oneshot_node_get_autorestart_delay
  = runMethod @"oneshot_node_get_autorestart_delay"

oneshot_node_get_autorestart_random_delay ::
                                            Method "oneshot_node_get_autorestart_random_delay" cls
                                              sig =>
                                            cls -> sig
oneshot_node_get_autorestart_random_delay
  = runMethod @"oneshot_node_get_autorestart_random_delay"

oneshot_node_get_fadein_time ::
                               Method "oneshot_node_get_fadein_time" cls sig => cls -> sig
oneshot_node_get_fadein_time
  = runMethod @"oneshot_node_get_fadein_time"

oneshot_node_get_fadeout_time ::
                                Method "oneshot_node_get_fadeout_time" cls sig => cls -> sig
oneshot_node_get_fadeout_time
  = runMethod @"oneshot_node_get_fadeout_time"

oneshot_node_has_autorestart ::
                               Method "oneshot_node_has_autorestart" cls sig => cls -> sig
oneshot_node_has_autorestart
  = runMethod @"oneshot_node_has_autorestart"

oneshot_node_is_active ::
                         Method "oneshot_node_is_active" cls sig => cls -> sig
oneshot_node_is_active = runMethod @"oneshot_node_is_active"

oneshot_node_set_autorestart ::
                               Method "oneshot_node_set_autorestart" cls sig => cls -> sig
oneshot_node_set_autorestart
  = runMethod @"oneshot_node_set_autorestart"

oneshot_node_set_autorestart_delay ::
                                     Method "oneshot_node_set_autorestart_delay" cls sig =>
                                     cls -> sig
oneshot_node_set_autorestart_delay
  = runMethod @"oneshot_node_set_autorestart_delay"

oneshot_node_set_autorestart_random_delay ::
                                            Method "oneshot_node_set_autorestart_random_delay" cls
                                              sig =>
                                            cls -> sig
oneshot_node_set_autorestart_random_delay
  = runMethod @"oneshot_node_set_autorestart_random_delay"

oneshot_node_set_fadein_time ::
                               Method "oneshot_node_set_fadein_time" cls sig => cls -> sig
oneshot_node_set_fadein_time
  = runMethod @"oneshot_node_set_fadein_time"

oneshot_node_set_fadeout_time ::
                                Method "oneshot_node_set_fadeout_time" cls sig => cls -> sig
oneshot_node_set_fadeout_time
  = runMethod @"oneshot_node_set_fadeout_time"

oneshot_node_set_filter_path ::
                               Method "oneshot_node_set_filter_path" cls sig => cls -> sig
oneshot_node_set_filter_path
  = runMethod @"oneshot_node_set_filter_path"

oneshot_node_start ::
                     Method "oneshot_node_start" cls sig => cls -> sig
oneshot_node_start = runMethod @"oneshot_node_start"

oneshot_node_stop ::
                    Method "oneshot_node_stop" cls sig => cls -> sig
oneshot_node_stop = runMethod @"oneshot_node_stop"

opaque_to_polygons ::
                     Method "opaque_to_polygons" cls sig => cls -> sig
opaque_to_polygons = runMethod @"opaque_to_polygons"

open :: Method "open" cls sig => cls -> sig
open = runMethod @"open"

open_buffer :: Method "open_buffer" cls sig => cls -> sig
open_buffer = runMethod @"open_buffer"

open_compressed :: Method "open_compressed" cls sig => cls -> sig
open_compressed = runMethod @"open_compressed"

open_encrypted :: Method "open_encrypted" cls sig => cls -> sig
open_encrypted = runMethod @"open_encrypted"

open_encrypted_with_pass ::
                           Method "open_encrypted_with_pass" cls sig => cls -> sig
open_encrypted_with_pass = runMethod @"open_encrypted_with_pass"

open_midi_inputs :: Method "open_midi_inputs" cls sig => cls -> sig
open_midi_inputs = runMethod @"open_midi_inputs"

open_scene_from_path ::
                       Method "open_scene_from_path" cls sig => cls -> sig
open_scene_from_path = runMethod @"open_scene_from_path"

open_script_create_dialog ::
                            Method "open_script_create_dialog" cls sig => cls -> sig
open_script_create_dialog = runMethod @"open_script_create_dialog"

orthonormalize :: Method "orthonormalize" cls sig => cls -> sig
orthonormalize = runMethod @"orthonormalize"

overlaps_area :: Method "overlaps_area" cls sig => cls -> sig
overlaps_area = runMethod @"overlaps_area"

overlaps_body :: Method "overlaps_body" cls sig => cls -> sig
overlaps_body = runMethod @"overlaps_body"

pack :: Method "pack" cls sig => cls -> sig
pack = runMethod @"pack"

parse :: Method "parse" cls sig => cls -> sig
parse = runMethod @"parse"

parse_bbcode :: Method "parse_bbcode" cls sig => cls -> sig
parse_bbcode = runMethod @"parse_bbcode"

parse_begin :: Method "parse_begin" cls sig => cls -> sig
parse_begin = runMethod @"parse_begin"

parse_category :: Method "parse_category" cls sig => cls -> sig
parse_category = runMethod @"parse_category"

parse_end :: Method "parse_end" cls sig => cls -> sig
parse_end = runMethod @"parse_end"

parse_input_event ::
                    Method "parse_input_event" cls sig => cls -> sig
parse_input_event = runMethod @"parse_input_event"

parse_property :: Method "parse_property" cls sig => cls -> sig
parse_property = runMethod @"parse_property"

particles_create :: Method "particles_create" cls sig => cls -> sig
particles_create = runMethod @"particles_create"

particles_get_current_aabb ::
                             Method "particles_get_current_aabb" cls sig => cls -> sig
particles_get_current_aabb
  = runMethod @"particles_get_current_aabb"

particles_get_emitting ::
                         Method "particles_get_emitting" cls sig => cls -> sig
particles_get_emitting = runMethod @"particles_get_emitting"

particles_restart ::
                    Method "particles_restart" cls sig => cls -> sig
particles_restart = runMethod @"particles_restart"

particles_set_amount ::
                       Method "particles_set_amount" cls sig => cls -> sig
particles_set_amount = runMethod @"particles_set_amount"

particles_set_custom_aabb ::
                            Method "particles_set_custom_aabb" cls sig => cls -> sig
particles_set_custom_aabb = runMethod @"particles_set_custom_aabb"

particles_set_draw_order ::
                           Method "particles_set_draw_order" cls sig => cls -> sig
particles_set_draw_order = runMethod @"particles_set_draw_order"

particles_set_draw_pass_mesh ::
                               Method "particles_set_draw_pass_mesh" cls sig => cls -> sig
particles_set_draw_pass_mesh
  = runMethod @"particles_set_draw_pass_mesh"

particles_set_draw_passes ::
                            Method "particles_set_draw_passes" cls sig => cls -> sig
particles_set_draw_passes = runMethod @"particles_set_draw_passes"

particles_set_emission_transform ::
                                   Method "particles_set_emission_transform" cls sig => cls -> sig
particles_set_emission_transform
  = runMethod @"particles_set_emission_transform"

particles_set_emitting ::
                         Method "particles_set_emitting" cls sig => cls -> sig
particles_set_emitting = runMethod @"particles_set_emitting"

particles_set_explosiveness_ratio ::
                                    Method "particles_set_explosiveness_ratio" cls sig => cls -> sig
particles_set_explosiveness_ratio
  = runMethod @"particles_set_explosiveness_ratio"

particles_set_fixed_fps ::
                          Method "particles_set_fixed_fps" cls sig => cls -> sig
particles_set_fixed_fps = runMethod @"particles_set_fixed_fps"

particles_set_fractional_delta ::
                                 Method "particles_set_fractional_delta" cls sig => cls -> sig
particles_set_fractional_delta
  = runMethod @"particles_set_fractional_delta"

particles_set_lifetime ::
                         Method "particles_set_lifetime" cls sig => cls -> sig
particles_set_lifetime = runMethod @"particles_set_lifetime"

particles_set_one_shot ::
                         Method "particles_set_one_shot" cls sig => cls -> sig
particles_set_one_shot = runMethod @"particles_set_one_shot"

particles_set_pre_process_time ::
                                 Method "particles_set_pre_process_time" cls sig => cls -> sig
particles_set_pre_process_time
  = runMethod @"particles_set_pre_process_time"

particles_set_process_material ::
                                 Method "particles_set_process_material" cls sig => cls -> sig
particles_set_process_material
  = runMethod @"particles_set_process_material"

particles_set_randomness_ratio ::
                                 Method "particles_set_randomness_ratio" cls sig => cls -> sig
particles_set_randomness_ratio
  = runMethod @"particles_set_randomness_ratio"

particles_set_speed_scale ::
                            Method "particles_set_speed_scale" cls sig => cls -> sig
particles_set_speed_scale = runMethod @"particles_set_speed_scale"

particles_set_use_local_coordinates ::
                                      Method "particles_set_use_local_coordinates" cls sig =>
                                      cls -> sig
particles_set_use_local_coordinates
  = runMethod @"particles_set_use_local_coordinates"

paste :: Method "paste" cls sig => cls -> sig
paste = runMethod @"paste"

pck_start :: Method "pck_start" cls sig => cls -> sig
pck_start = runMethod @"pck_start"

physical_bones_add_collision_exception ::
                                         Method "physical_bones_add_collision_exception" cls sig =>
                                         cls -> sig
physical_bones_add_collision_exception
  = runMethod @"physical_bones_add_collision_exception"

physical_bones_remove_collision_exception ::
                                            Method "physical_bones_remove_collision_exception" cls
                                              sig =>
                                            cls -> sig
physical_bones_remove_collision_exception
  = runMethod @"physical_bones_remove_collision_exception"

physical_bones_start_simulation ::
                                  Method "physical_bones_start_simulation" cls sig => cls -> sig
physical_bones_start_simulation
  = runMethod @"physical_bones_start_simulation"

physical_bones_stop_simulation ::
                                 Method "physical_bones_stop_simulation" cls sig => cls -> sig
physical_bones_stop_simulation
  = runMethod @"physical_bones_stop_simulation"

pin_joint_create :: Method "pin_joint_create" cls sig => cls -> sig
pin_joint_create = runMethod @"pin_joint_create"

pin_joint_get_local_a ::
                        Method "pin_joint_get_local_a" cls sig => cls -> sig
pin_joint_get_local_a = runMethod @"pin_joint_get_local_a"

pin_joint_get_local_b ::
                        Method "pin_joint_get_local_b" cls sig => cls -> sig
pin_joint_get_local_b = runMethod @"pin_joint_get_local_b"

pin_joint_get_param ::
                      Method "pin_joint_get_param" cls sig => cls -> sig
pin_joint_get_param = runMethod @"pin_joint_get_param"

pin_joint_set_local_a ::
                        Method "pin_joint_set_local_a" cls sig => cls -> sig
pin_joint_set_local_a = runMethod @"pin_joint_set_local_a"

pin_joint_set_local_b ::
                        Method "pin_joint_set_local_b" cls sig => cls -> sig
pin_joint_set_local_b = runMethod @"pin_joint_set_local_b"

pin_joint_set_param ::
                      Method "pin_joint_set_param" cls sig => cls -> sig
pin_joint_set_param = runMethod @"pin_joint_set_param"

play :: Method "play" cls sig => cls -> sig
play = runMethod @"play"

play_backwards :: Method "play_backwards" cls sig => cls -> sig
play_backwards = runMethod @"play_backwards"

point_is_inside_triangle ::
                           Method "point_is_inside_triangle" cls sig => cls -> sig
point_is_inside_triangle = runMethod @"point_is_inside_triangle"

poll :: Method "poll" cls sig => cls -> sig
poll = runMethod @"poll"

pop :: Method "pop" cls sig => cls -> sig
pop = runMethod @"pop"

popup :: Method "popup" cls sig => cls -> sig
popup = runMethod @"popup"

popup_centered :: Method "popup_centered" cls sig => cls -> sig
popup_centered = runMethod @"popup_centered"

popup_centered_minsize ::
                         Method "popup_centered_minsize" cls sig => cls -> sig
popup_centered_minsize = runMethod @"popup_centered_minsize"

popup_centered_ratio ::
                       Method "popup_centered_ratio" cls sig => cls -> sig
popup_centered_ratio = runMethod @"popup_centered_ratio"

ports_changed_notify ::
                       Method "ports_changed_notify" cls sig => cls -> sig
ports_changed_notify = runMethod @"ports_changed_notify"

post :: Method "post" cls sig => cls -> sig
post = runMethod @"post"

post_import :: Method "post_import" cls sig => cls -> sig
post_import = runMethod @"post_import"

premultiply_alpha ::
                    Method "premultiply_alpha" cls sig => cls -> sig
premultiply_alpha = runMethod @"premultiply_alpha"

print :: Method "print" cls sig => cls -> sig
print = runMethod @"print"

print_all_resources ::
                      Method "print_all_resources" cls sig => cls -> sig
print_all_resources = runMethod @"print_all_resources"

print_all_textures_by_size ::
                             Method "print_all_textures_by_size" cls sig => cls -> sig
print_all_textures_by_size
  = runMethod @"print_all_textures_by_size"

print_resources_by_type ::
                          Method "print_resources_by_type" cls sig => cls -> sig
print_resources_by_type = runMethod @"print_resources_by_type"

print_resources_in_use ::
                         Method "print_resources_in_use" cls sig => cls -> sig
print_resources_in_use = runMethod @"print_resources_in_use"

print_stray_nodes ::
                    Method "print_stray_nodes" cls sig => cls -> sig
print_stray_nodes = runMethod @"print_stray_nodes"

print_tree :: Method "print_tree" cls sig => cls -> sig
print_tree = runMethod @"print_tree"

print_tree_pretty ::
                    Method "print_tree_pretty" cls sig => cls -> sig
print_tree_pretty = runMethod @"print_tree_pretty"

process :: Method "process" cls sig => cls -> sig
process = runMethod @"process"

project_local_ray_normal ::
                           Method "project_local_ray_normal" cls sig => cls -> sig
project_local_ray_normal = runMethod @"project_local_ray_normal"

project_position :: Method "project_position" cls sig => cls -> sig
project_position = runMethod @"project_position"

project_ray_normal ::
                     Method "project_ray_normal" cls sig => cls -> sig
project_ray_normal = runMethod @"project_ray_normal"

project_ray_origin ::
                     Method "project_ray_origin" cls sig => cls -> sig
project_ray_origin = runMethod @"project_ray_origin"

propagate_call :: Method "propagate_call" cls sig => cls -> sig
propagate_call = runMethod @"propagate_call"

propagate_notification ::
                         Method "propagate_notification" cls sig => cls -> sig
propagate_notification = runMethod @"propagate_notification"

property_can_revert ::
                      Method "property_can_revert" cls sig => cls -> sig
property_can_revert = runMethod @"property_can_revert"

property_get_revert ::
                      Method "property_get_revert" cls sig => cls -> sig
property_get_revert = runMethod @"property_get_revert"

property_list_changed_notify ::
                               Method "property_list_changed_notify" cls sig => cls -> sig
property_list_changed_notify
  = runMethod @"property_list_changed_notify"

push_align :: Method "push_align" cls sig => cls -> sig
push_align = runMethod @"push_align"

push_cell :: Method "push_cell" cls sig => cls -> sig
push_cell = runMethod @"push_cell"

push_color :: Method "push_color" cls sig => cls -> sig
push_color = runMethod @"push_color"

push_font :: Method "push_font" cls sig => cls -> sig
push_font = runMethod @"push_font"

push_indent :: Method "push_indent" cls sig => cls -> sig
push_indent = runMethod @"push_indent"

push_list :: Method "push_list" cls sig => cls -> sig
push_list = runMethod @"push_list"

push_meta :: Method "push_meta" cls sig => cls -> sig
push_meta = runMethod @"push_meta"

push_strikethrough ::
                     Method "push_strikethrough" cls sig => cls -> sig
push_strikethrough = runMethod @"push_strikethrough"

push_table :: Method "push_table" cls sig => cls -> sig
push_table = runMethod @"push_table"

push_underline :: Method "push_underline" cls sig => cls -> sig
push_underline = runMethod @"push_underline"

put_16 :: Method "put_16" cls sig => cls -> sig
put_16 = runMethod @"put_16"

put_32 :: Method "put_32" cls sig => cls -> sig
put_32 = runMethod @"put_32"

put_64 :: Method "put_64" cls sig => cls -> sig
put_64 = runMethod @"put_64"

put_8 :: Method "put_8" cls sig => cls -> sig
put_8 = runMethod @"put_8"

put_data :: Method "put_data" cls sig => cls -> sig
put_data = runMethod @"put_data"

put_double :: Method "put_double" cls sig => cls -> sig
put_double = runMethod @"put_double"

put_float :: Method "put_float" cls sig => cls -> sig
put_float = runMethod @"put_float"

put_packet :: Method "put_packet" cls sig => cls -> sig
put_packet = runMethod @"put_packet"

put_partial_data :: Method "put_partial_data" cls sig => cls -> sig
put_partial_data = runMethod @"put_partial_data"

put_string :: Method "put_string" cls sig => cls -> sig
put_string = runMethod @"put_string"

put_u16 :: Method "put_u16" cls sig => cls -> sig
put_u16 = runMethod @"put_u16"

put_u32 :: Method "put_u32" cls sig => cls -> sig
put_u32 = runMethod @"put_u32"

put_u64 :: Method "put_u64" cls sig => cls -> sig
put_u64 = runMethod @"put_u64"

put_u8 :: Method "put_u8" cls sig => cls -> sig
put_u8 = runMethod @"put_u8"

put_utf8_string :: Method "put_utf8_string" cls sig => cls -> sig
put_utf8_string = runMethod @"put_utf8_string"

put_var :: Method "put_var" cls sig => cls -> sig
put_var = runMethod @"put_var"

query_external_address ::
                         Method "query_external_address" cls sig => cls -> sig
query_external_address = runMethod @"query_external_address"

query_string_from_dict ::
                         Method "query_string_from_dict" cls sig => cls -> sig
query_string_from_dict = runMethod @"query_string_from_dict"

queue :: Method "queue" cls sig => cls -> sig
queue = runMethod @"queue"

queue_delete :: Method "queue_delete" cls sig => cls -> sig
queue_delete = runMethod @"queue_delete"

queue_edited_resource_preview ::
                                Method "queue_edited_resource_preview" cls sig => cls -> sig
queue_edited_resource_preview
  = runMethod @"queue_edited_resource_preview"

queue_free :: Method "queue_free" cls sig => cls -> sig
queue_free = runMethod @"queue_free"

queue_resource_preview ::
                         Method "queue_resource_preview" cls sig => cls -> sig
queue_resource_preview = runMethod @"queue_resource_preview"

queue_save_layout ::
                    Method "queue_save_layout" cls sig => cls -> sig
queue_save_layout = runMethod @"queue_save_layout"

queue_sort :: Method "queue_sort" cls sig => cls -> sig
queue_sort = runMethod @"queue_sort"

quit :: Method "quit" cls sig => cls -> sig
quit = runMethod @"quit"

raise :: Method "raise" cls sig => cls -> sig
raise = runMethod @"raise"

raw_to_base64 :: Method "raw_to_base64" cls sig => cls -> sig
raw_to_base64 = runMethod @"raw_to_base64"

ray_intersects_triangle ::
                          Method "ray_intersects_triangle" cls sig => cls -> sig
ray_intersects_triangle = runMethod @"ray_intersects_triangle"

ray_shape_create :: Method "ray_shape_create" cls sig => cls -> sig
ray_shape_create = runMethod @"ray_shape_create"

read :: Method "read" cls sig => cls -> sig
read = runMethod @"read"

read_response_body_chunk ::
                           Method "read_response_body_chunk" cls sig => cls -> sig
read_response_body_chunk = runMethod @"read_response_body_chunk"

recompute_caches :: Method "recompute_caches" cls sig => cls -> sig
recompute_caches = runMethod @"recompute_caches"

rectangle_shape_create ::
                         Method "rectangle_shape_create" cls sig => cls -> sig
rectangle_shape_create = runMethod @"rectangle_shape_create"

redo :: Method "redo" cls sig => cls -> sig
redo = runMethod @"redo"

redraw :: Method "redraw" cls sig => cls -> sig
redraw = runMethod @"redraw"

reference :: Method "reference" cls sig => cls -> sig
reference = runMethod @"reference"

reflection_probe_create ::
                          Method "reflection_probe_create" cls sig => cls -> sig
reflection_probe_create = runMethod @"reflection_probe_create"

reflection_probe_set_as_interior ::
                                   Method "reflection_probe_set_as_interior" cls sig => cls -> sig
reflection_probe_set_as_interior
  = runMethod @"reflection_probe_set_as_interior"

reflection_probe_set_cull_mask ::
                                 Method "reflection_probe_set_cull_mask" cls sig => cls -> sig
reflection_probe_set_cull_mask
  = runMethod @"reflection_probe_set_cull_mask"

reflection_probe_set_enable_box_projection ::
                                             Method "reflection_probe_set_enable_box_projection" cls
                                               sig =>
                                             cls -> sig
reflection_probe_set_enable_box_projection
  = runMethod @"reflection_probe_set_enable_box_projection"

reflection_probe_set_enable_shadows ::
                                      Method "reflection_probe_set_enable_shadows" cls sig =>
                                      cls -> sig
reflection_probe_set_enable_shadows
  = runMethod @"reflection_probe_set_enable_shadows"

reflection_probe_set_extents ::
                               Method "reflection_probe_set_extents" cls sig => cls -> sig
reflection_probe_set_extents
  = runMethod @"reflection_probe_set_extents"

reflection_probe_set_intensity ::
                                 Method "reflection_probe_set_intensity" cls sig => cls -> sig
reflection_probe_set_intensity
  = runMethod @"reflection_probe_set_intensity"

reflection_probe_set_interior_ambient ::
                                        Method "reflection_probe_set_interior_ambient" cls sig =>
                                        cls -> sig
reflection_probe_set_interior_ambient
  = runMethod @"reflection_probe_set_interior_ambient"

reflection_probe_set_interior_ambient_energy ::
                                               Method "reflection_probe_set_interior_ambient_energy"
                                                 cls sig =>
                                               cls -> sig
reflection_probe_set_interior_ambient_energy
  = runMethod @"reflection_probe_set_interior_ambient_energy"

reflection_probe_set_interior_ambient_probe_contribution ::
                                                           Method
                                                             "reflection_probe_set_interior_ambient_probe_contribution"
                                                             cls sig =>
                                                           cls -> sig
reflection_probe_set_interior_ambient_probe_contribution
  = runMethod
      @"reflection_probe_set_interior_ambient_probe_contribution"

reflection_probe_set_max_distance ::
                                    Method "reflection_probe_set_max_distance" cls sig => cls -> sig
reflection_probe_set_max_distance
  = runMethod @"reflection_probe_set_max_distance"

reflection_probe_set_origin_offset ::
                                     Method "reflection_probe_set_origin_offset" cls sig =>
                                     cls -> sig
reflection_probe_set_origin_offset
  = runMethod @"reflection_probe_set_origin_offset"

reflection_probe_set_update_mode ::
                                   Method "reflection_probe_set_update_mode" cls sig => cls -> sig
reflection_probe_set_update_mode
  = runMethod @"reflection_probe_set_update_mode"

refresh :: Method "refresh" cls sig => cls -> sig
refresh = runMethod @"refresh"

regen_normalmaps :: Method "regen_normalmaps" cls sig => cls -> sig
regen_normalmaps = runMethod @"regen_normalmaps"

register_text_enter ::
                      Method "register_text_enter" cls sig => cls -> sig
register_text_enter = runMethod @"register_text_enter"

release_focus :: Method "release_focus" cls sig => cls -> sig
release_focus = runMethod @"release_focus"

reload :: Method "reload" cls sig => cls -> sig
reload = runMethod @"reload"

reload_current_scene ::
                       Method "reload_current_scene" cls sig => cls -> sig
reload_current_scene = runMethod @"reload_current_scene"

reload_scene_from_path ::
                         Method "reload_scene_from_path" cls sig => cls -> sig
reload_scene_from_path = runMethod @"reload_scene_from_path"

remove :: Method "remove" cls sig => cls -> sig
remove = runMethod @"remove"

remove_all :: Method "remove_all" cls sig => cls -> sig
remove_all = runMethod @"remove_all"

remove_and_skip :: Method "remove_and_skip" cls sig => cls -> sig
remove_and_skip = runMethod @"remove_and_skip"

remove_animation :: Method "remove_animation" cls sig => cls -> sig
remove_animation = runMethod @"remove_animation"

remove_autoload_singleton ::
                            Method "remove_autoload_singleton" cls sig => cls -> sig
remove_autoload_singleton = runMethod @"remove_autoload_singleton"

remove_blend_point ::
                     Method "remove_blend_point" cls sig => cls -> sig
remove_blend_point = runMethod @"remove_blend_point"

remove_breakpoints ::
                     Method "remove_breakpoints" cls sig => cls -> sig
remove_breakpoints = runMethod @"remove_breakpoints"

remove_bus :: Method "remove_bus" cls sig => cls -> sig
remove_bus = runMethod @"remove_bus"

remove_bus_effect ::
                    Method "remove_bus_effect" cls sig => cls -> sig
remove_bus_effect = runMethod @"remove_bus_effect"

remove_child :: Method "remove_child" cls sig => cls -> sig
remove_child = runMethod @"remove_child"

remove_collision_exception_with ::
                                  Method "remove_collision_exception_with" cls sig => cls -> sig
remove_collision_exception_with
  = runMethod @"remove_collision_exception_with"

remove_control_from_bottom_panel ::
                                   Method "remove_control_from_bottom_panel" cls sig => cls -> sig
remove_control_from_bottom_panel
  = runMethod @"remove_control_from_bottom_panel"

remove_control_from_container ::
                                Method "remove_control_from_container" cls sig => cls -> sig
remove_control_from_container
  = runMethod @"remove_control_from_container"

remove_control_from_docks ::
                            Method "remove_control_from_docks" cls sig => cls -> sig
remove_control_from_docks = runMethod @"remove_control_from_docks"

remove_custom_node ::
                     Method "remove_custom_node" cls sig => cls -> sig
remove_custom_node = runMethod @"remove_custom_node"

remove_custom_signal ::
                       Method "remove_custom_signal" cls sig => cls -> sig
remove_custom_signal = runMethod @"remove_custom_signal"

remove_custom_type ::
                     Method "remove_custom_type" cls sig => cls -> sig
remove_custom_type = runMethod @"remove_custom_type"

remove_device :: Method "remove_device" cls sig => cls -> sig
remove_device = runMethod @"remove_device"

remove_exception :: Method "remove_exception" cls sig => cls -> sig
remove_exception = runMethod @"remove_exception"

remove_exception_rid ::
                       Method "remove_exception_rid" cls sig => cls -> sig
remove_exception_rid = runMethod @"remove_exception_rid"

remove_excluded_object ::
                         Method "remove_excluded_object" cls sig => cls -> sig
remove_excluded_object = runMethod @"remove_excluded_object"

remove_export_plugin ::
                       Method "remove_export_plugin" cls sig => cls -> sig
remove_export_plugin = runMethod @"remove_export_plugin"

remove_fallback :: Method "remove_fallback" cls sig => cls -> sig
remove_fallback = runMethod @"remove_fallback"

remove_frame :: Method "remove_frame" cls sig => cls -> sig
remove_frame = runMethod @"remove_frame"

remove_from_group ::
                    Method "remove_from_group" cls sig => cls -> sig
remove_from_group = runMethod @"remove_from_group"

remove_function :: Method "remove_function" cls sig => cls -> sig
remove_function = runMethod @"remove_function"

remove_import_plugin ::
                       Method "remove_import_plugin" cls sig => cls -> sig
remove_import_plugin = runMethod @"remove_import_plugin"

remove_input :: Method "remove_input" cls sig => cls -> sig
remove_input = runMethod @"remove_input"

remove_inspector_plugin ::
                          Method "remove_inspector_plugin" cls sig => cls -> sig
remove_inspector_plugin = runMethod @"remove_inspector_plugin"

remove_item :: Method "remove_item" cls sig => cls -> sig
remove_item = runMethod @"remove_item"

remove_joy_mapping ::
                     Method "remove_joy_mapping" cls sig => cls -> sig
remove_joy_mapping = runMethod @"remove_joy_mapping"

remove_line :: Method "remove_line" cls sig => cls -> sig
remove_line = runMethod @"remove_line"

remove_node :: Method "remove_node" cls sig => cls -> sig
remove_node = runMethod @"remove_node"

remove_outline :: Method "remove_outline" cls sig => cls -> sig
remove_outline = runMethod @"remove_outline"

remove_point :: Method "remove_point" cls sig => cls -> sig
remove_point = runMethod @"remove_point"

remove_preview_generator ::
                           Method "remove_preview_generator" cls sig => cls -> sig
remove_preview_generator = runMethod @"remove_preview_generator"

remove_resource :: Method "remove_resource" cls sig => cls -> sig
remove_resource = runMethod @"remove_resource"

remove_scene_import_plugin ::
                             Method "remove_scene_import_plugin" cls sig => cls -> sig
remove_scene_import_plugin
  = runMethod @"remove_scene_import_plugin"

remove_shape_owner ::
                     Method "remove_shape_owner" cls sig => cls -> sig
remove_shape_owner = runMethod @"remove_shape_owner"

remove_tab :: Method "remove_tab" cls sig => cls -> sig
remove_tab = runMethod @"remove_tab"

remove_tile :: Method "remove_tile" cls sig => cls -> sig
remove_tile = runMethod @"remove_tile"

remove_tool_menu_item ::
                        Method "remove_tool_menu_item" cls sig => cls -> sig
remove_tool_menu_item = runMethod @"remove_tool_menu_item"

remove_track :: Method "remove_track" cls sig => cls -> sig
remove_track = runMethod @"remove_track"

remove_transition ::
                    Method "remove_transition" cls sig => cls -> sig
remove_transition = runMethod @"remove_transition"

remove_transition_by_index ::
                             Method "remove_transition_by_index" cls sig => cls -> sig
remove_transition_by_index
  = runMethod @"remove_transition_by_index"

remove_translation ::
                     Method "remove_translation" cls sig => cls -> sig
remove_translation = runMethod @"remove_translation"

remove_triangle :: Method "remove_triangle" cls sig => cls -> sig
remove_triangle = runMethod @"remove_triangle"

remove_valid_connection_type ::
                               Method "remove_valid_connection_type" cls sig => cls -> sig
remove_valid_connection_type
  = runMethod @"remove_valid_connection_type"

remove_valid_left_disconnect_type ::
                                    Method "remove_valid_left_disconnect_type" cls sig => cls -> sig
remove_valid_left_disconnect_type
  = runMethod @"remove_valid_left_disconnect_type"

remove_valid_right_disconnect_type ::
                                     Method "remove_valid_right_disconnect_type" cls sig =>
                                     cls -> sig
remove_valid_right_disconnect_type
  = runMethod @"remove_valid_right_disconnect_type"

remove_variable :: Method "remove_variable" cls sig => cls -> sig
remove_variable = runMethod @"remove_variable"

rename :: Method "rename" cls sig => cls -> sig
rename = runMethod @"rename"

rename_animation :: Method "rename_animation" cls sig => cls -> sig
rename_animation = runMethod @"rename_animation"

rename_custom_signal ::
                       Method "rename_custom_signal" cls sig => cls -> sig
rename_custom_signal = runMethod @"rename_custom_signal"

rename_function :: Method "rename_function" cls sig => cls -> sig
rename_function = runMethod @"rename_function"

rename_node :: Method "rename_node" cls sig => cls -> sig
rename_node = runMethod @"rename_node"

rename_parameter :: Method "rename_parameter" cls sig => cls -> sig
rename_parameter = runMethod @"rename_parameter"

rename_resource :: Method "rename_resource" cls sig => cls -> sig
rename_resource = runMethod @"rename_resource"

rename_variable :: Method "rename_variable" cls sig => cls -> sig
rename_variable = runMethod @"rename_variable"

replace_by :: Method "replace_by" cls sig => cls -> sig
replace_by = runMethod @"replace_by"

replace_by_instance ::
                      Method "replace_by_instance" cls sig => cls -> sig
replace_by_instance = runMethod @"replace_by_instance"

request :: Method "request" cls sig => cls -> sig
request = runMethod @"request"

request_attention ::
                    Method "request_attention" cls sig => cls -> sig
request_attention = runMethod @"request_attention"

request_frame_drawn_callback ::
                               Method "request_frame_drawn_callback" cls sig => cls -> sig
request_frame_drawn_callback
  = runMethod @"request_frame_drawn_callback"

request_raw :: Method "request_raw" cls sig => cls -> sig
request_raw = runMethod @"request_raw"

request_ready :: Method "request_ready" cls sig => cls -> sig
request_ready = runMethod @"request_ready"

reset :: Method "reset" cls sig => cls -> sig
reset = runMethod @"reset"

reset_all :: Method "reset_all" cls sig => cls -> sig
reset_all = runMethod @"reset_all"

reset_smoothing :: Method "reset_smoothing" cls sig => cls -> sig
reset_smoothing = runMethod @"reset_smoothing"

resize :: Method "resize" cls sig => cls -> sig
resize = runMethod @"resize"

resize_to_po2 :: Method "resize_to_po2" cls sig => cls -> sig
resize_to_po2 = runMethod @"resize_to_po2"

resolve_hostname :: Method "resolve_hostname" cls sig => cls -> sig
resolve_hostname = runMethod @"resolve_hostname"

resolve_hostname_queue_item ::
                              Method "resolve_hostname_queue_item" cls sig => cls -> sig
resolve_hostname_queue_item
  = runMethod @"resolve_hostname_queue_item"

resource_changed :: Method "resource_changed" cls sig => cls -> sig
resource_changed = runMethod @"resource_changed"

restart :: Method "restart" cls sig => cls -> sig
restart = runMethod @"restart"

resume :: Method "resume" cls sig => cls -> sig
resume = runMethod @"resume"

resume_all :: Method "resume_all" cls sig => cls -> sig
resume_all = runMethod @"resume_all"

rgbe_to_srgb :: Method "rgbe_to_srgb" cls sig => cls -> sig
rgbe_to_srgb = runMethod @"rgbe_to_srgb"

rotate :: Method "rotate" cls sig => cls -> sig
rotate = runMethod @"rotate"

rotate_object_local ::
                      Method "rotate_object_local" cls sig => cls -> sig
rotate_object_local = runMethod @"rotate_object_local"

rotate_x :: Method "rotate_x" cls sig => cls -> sig
rotate_x = runMethod @"rotate_x"

rotate_y :: Method "rotate_y" cls sig => cls -> sig
rotate_y = runMethod @"rotate_y"

rotate_z :: Method "rotate_z" cls sig => cls -> sig
rotate_z = runMethod @"rotate_z"

rpc :: Method "rpc" cls sig => cls -> sig
rpc = runMethod @"rpc"

rpc_config :: Method "rpc_config" cls sig => cls -> sig
rpc_config = runMethod @"rpc_config"

rpc_id :: Method "rpc_id" cls sig => cls -> sig
rpc_id = runMethod @"rpc_id"

rpc_unreliable :: Method "rpc_unreliable" cls sig => cls -> sig
rpc_unreliable = runMethod @"rpc_unreliable"

rpc_unreliable_id ::
                    Method "rpc_unreliable_id" cls sig => cls -> sig
rpc_unreliable_id = runMethod @"rpc_unreliable_id"

rset :: Method "rset" cls sig => cls -> sig
rset = runMethod @"rset"

rset_config :: Method "rset_config" cls sig => cls -> sig
rset_config = runMethod @"rset_config"

rset_id :: Method "rset_id" cls sig => cls -> sig
rset_id = runMethod @"rset_id"

rset_unreliable :: Method "rset_unreliable" cls sig => cls -> sig
rset_unreliable = runMethod @"rset_unreliable"

rset_unreliable_id ::
                     Method "rset_unreliable_id" cls sig => cls -> sig
rset_unreliable_id = runMethod @"rset_unreliable_id"

save :: Method "save" cls sig => cls -> sig
save = runMethod @"save"

save_custom :: Method "save_custom" cls sig => cls -> sig
save_custom = runMethod @"save_custom"

save_external_data ::
                     Method "save_external_data" cls sig => cls -> sig
save_external_data = runMethod @"save_external_data"

save_png :: Method "save_png" cls sig => cls -> sig
save_png = runMethod @"save_png"

save_scene :: Method "save_scene" cls sig => cls -> sig
save_scene = runMethod @"save_scene"

save_scene_as :: Method "save_scene_as" cls sig => cls -> sig
save_scene_as = runMethod @"save_scene_as"

save_to_wav :: Method "save_to_wav" cls sig => cls -> sig
save_to_wav = runMethod @"save_to_wav"

scale_object_local ::
                     Method "scale_object_local" cls sig => cls -> sig
scale_object_local = runMethod @"scale_object_local"

scan :: Method "scan" cls sig => cls -> sig
scan = runMethod @"scan"

scan_sources :: Method "scan_sources" cls sig => cls -> sig
scan_sources = runMethod @"scan_sources"

scenario_create :: Method "scenario_create" cls sig => cls -> sig
scenario_create = runMethod @"scenario_create"

scenario_set_debug ::
                     Method "scenario_set_debug" cls sig => cls -> sig
scenario_set_debug = runMethod @"scenario_set_debug"

scenario_set_environment ::
                           Method "scenario_set_environment" cls sig => cls -> sig
scenario_set_environment = runMethod @"scenario_set_environment"

scenario_set_fallback_environment ::
                                    Method "scenario_set_fallback_environment" cls sig => cls -> sig
scenario_set_fallback_environment
  = runMethod @"scenario_set_fallback_environment"

scenario_set_reflection_atlas_size ::
                                     Method "scenario_set_reflection_atlas_size" cls sig =>
                                     cls -> sig
scenario_set_reflection_atlas_size
  = runMethod @"scenario_set_reflection_atlas_size"

scroll_to_line :: Method "scroll_to_line" cls sig => cls -> sig
scroll_to_line = runMethod @"scroll_to_line"

search :: Method "search" cls sig => cls -> sig
search = runMethod @"search"

search_all :: Method "search_all" cls sig => cls -> sig
search_all = runMethod @"search_all"

seek :: Method "seek" cls sig => cls -> sig
seek = runMethod @"seek"

seek_end :: Method "seek_end" cls sig => cls -> sig
seek_end = runMethod @"seek_end"

segment_intersects_circle ::
                            Method "segment_intersects_circle" cls sig => cls -> sig
segment_intersects_circle = runMethod @"segment_intersects_circle"

segment_intersects_convex ::
                            Method "segment_intersects_convex" cls sig => cls -> sig
segment_intersects_convex = runMethod @"segment_intersects_convex"

segment_intersects_cylinder ::
                              Method "segment_intersects_cylinder" cls sig => cls -> sig
segment_intersects_cylinder
  = runMethod @"segment_intersects_cylinder"

segment_intersects_segment_2d ::
                                Method "segment_intersects_segment_2d" cls sig => cls -> sig
segment_intersects_segment_2d
  = runMethod @"segment_intersects_segment_2d"

segment_intersects_sphere ::
                            Method "segment_intersects_sphere" cls sig => cls -> sig
segment_intersects_sphere = runMethod @"segment_intersects_sphere"

segment_intersects_triangle ::
                              Method "segment_intersects_triangle" cls sig => cls -> sig
segment_intersects_triangle
  = runMethod @"segment_intersects_triangle"

segment_shape_create ::
                       Method "segment_shape_create" cls sig => cls -> sig
segment_shape_create = runMethod @"segment_shape_create"

select :: Method "select" cls sig => cls -> sig
select = runMethod @"select"

select_all :: Method "select_all" cls sig => cls -> sig
select_all = runMethod @"select_all"

select_file :: Method "select_file" cls sig => cls -> sig
select_file = runMethod @"select_file"

send_bytes :: Method "send_bytes" cls sig => cls -> sig
send_bytes = runMethod @"send_bytes"

sequence_connect :: Method "sequence_connect" cls sig => cls -> sig
sequence_connect = runMethod @"sequence_connect"

sequence_disconnect ::
                      Method "sequence_disconnect" cls sig => cls -> sig
sequence_disconnect = runMethod @"sequence_disconnect"

set :: Method "set" cls sig => cls -> sig
set = runMethod @"set"

set_a :: Method "set_a" cls sig => cls -> sig
set_a = runMethod @"set_a"

set_aa_size :: Method "set_aa_size" cls sig => cls -> sig
set_aa_size = runMethod @"set_aa_size"

set_aabb :: Method "set_aabb" cls sig => cls -> sig
set_aabb = runMethod @"set_aabb"

set_abort_on_missing_resources ::
                                 Method "set_abort_on_missing_resources" cls sig => cls -> sig
set_abort_on_missing_resources
  = runMethod @"set_abort_on_missing_resources"

set_absorbent :: Method "set_absorbent" cls sig => cls -> sig
set_absorbent = runMethod @"set_absorbent"

set_access :: Method "set_access" cls sig => cls -> sig
set_access = runMethod @"set_access"

set_action :: Method "set_action" cls sig => cls -> sig
set_action = runMethod @"set_action"

set_action_mode :: Method "set_action_mode" cls sig => cls -> sig
set_action_mode = runMethod @"set_action_mode"

set_action_name :: Method "set_action_name" cls sig => cls -> sig
set_action_name = runMethod @"set_action_name"

set_active :: Method "set_active" cls sig => cls -> sig
set_active = runMethod @"set_active"

set_adjustment_brightness ::
                            Method "set_adjustment_brightness" cls sig => cls -> sig
set_adjustment_brightness = runMethod @"set_adjustment_brightness"

set_adjustment_color_correction ::
                                  Method "set_adjustment_color_correction" cls sig => cls -> sig
set_adjustment_color_correction
  = runMethod @"set_adjustment_color_correction"

set_adjustment_contrast ::
                          Method "set_adjustment_contrast" cls sig => cls -> sig
set_adjustment_contrast = runMethod @"set_adjustment_contrast"

set_adjustment_enable ::
                        Method "set_adjustment_enable" cls sig => cls -> sig
set_adjustment_enable = runMethod @"set_adjustment_enable"

set_adjustment_saturation ::
                            Method "set_adjustment_saturation" cls sig => cls -> sig
set_adjustment_saturation = runMethod @"set_adjustment_saturation"

set_advance_condition ::
                        Method "set_advance_condition" cls sig => cls -> sig
set_advance_condition = runMethod @"set_advance_condition"

set_agent_height :: Method "set_agent_height" cls sig => cls -> sig
set_agent_height = runMethod @"set_agent_height"

set_agent_max_climb ::
                      Method "set_agent_max_climb" cls sig => cls -> sig
set_agent_max_climb = runMethod @"set_agent_max_climb"

set_agent_max_slope ::
                      Method "set_agent_max_slope" cls sig => cls -> sig
set_agent_max_slope = runMethod @"set_agent_max_slope"

set_agent_radius :: Method "set_agent_radius" cls sig => cls -> sig
set_agent_radius = runMethod @"set_agent_radius"

set_albedo :: Method "set_albedo" cls sig => cls -> sig
set_albedo = runMethod @"set_albedo"

set_align :: Method "set_align" cls sig => cls -> sig
set_align = runMethod @"set_align"

set_alignment :: Method "set_alignment" cls sig => cls -> sig
set_alignment = runMethod @"set_alignment"

set_allow_greater ::
                    Method "set_allow_greater" cls sig => cls -> sig
set_allow_greater = runMethod @"set_allow_greater"

set_allow_lesser :: Method "set_allow_lesser" cls sig => cls -> sig
set_allow_lesser = runMethod @"set_allow_lesser"

set_allow_object_decoding ::
                            Method "set_allow_object_decoding" cls sig => cls -> sig
set_allow_object_decoding = runMethod @"set_allow_object_decoding"

set_allow_reselect ::
                     Method "set_allow_reselect" cls sig => cls -> sig
set_allow_reselect = runMethod @"set_allow_reselect"

set_allow_rmb_select ::
                       Method "set_allow_rmb_select" cls sig => cls -> sig
set_allow_rmb_select = runMethod @"set_allow_rmb_select"

set_alpha_cut_mode ::
                     Method "set_alpha_cut_mode" cls sig => cls -> sig
set_alpha_cut_mode = runMethod @"set_alpha_cut_mode"

set_alpha_scissor_threshold ::
                              Method "set_alpha_scissor_threshold" cls sig => cls -> sig
set_alpha_scissor_threshold
  = runMethod @"set_alpha_scissor_threshold"

set_alt :: Method "set_alt" cls sig => cls -> sig
set_alt = runMethod @"set_alt"

set_always_ordered ::
                     Method "set_always_ordered" cls sig => cls -> sig
set_always_ordered = runMethod @"set_always_ordered"

set_ambient_light_color ::
                          Method "set_ambient_light_color" cls sig => cls -> sig
set_ambient_light_color = runMethod @"set_ambient_light_color"

set_ambient_light_energy ::
                           Method "set_ambient_light_energy" cls sig => cls -> sig
set_ambient_light_energy = runMethod @"set_ambient_light_energy"

set_ambient_light_sky_contribution ::
                                     Method "set_ambient_light_sky_contribution" cls sig =>
                                     cls -> sig
set_ambient_light_sky_contribution
  = runMethod @"set_ambient_light_sky_contribution"

set_amount :: Method "set_amount" cls sig => cls -> sig
set_amount = runMethod @"set_amount"

set_anchor :: Method "set_anchor" cls sig => cls -> sig
set_anchor = runMethod @"set_anchor"

set_anchor_and_margin ::
                        Method "set_anchor_and_margin" cls sig => cls -> sig
set_anchor_and_margin = runMethod @"set_anchor_and_margin"

set_anchor_detection_is_enabled ::
                                  Method "set_anchor_detection_is_enabled" cls sig => cls -> sig
set_anchor_detection_is_enabled
  = runMethod @"set_anchor_detection_is_enabled"

set_anchor_id :: Method "set_anchor_id" cls sig => cls -> sig
set_anchor_id = runMethod @"set_anchor_id"

set_anchor_mode :: Method "set_anchor_mode" cls sig => cls -> sig
set_anchor_mode = runMethod @"set_anchor_mode"

set_anchors_and_margins_preset ::
                                 Method "set_anchors_and_margins_preset" cls sig => cls -> sig
set_anchors_and_margins_preset
  = runMethod @"set_anchors_and_margins_preset"

set_anchors_preset ::
                     Method "set_anchors_preset" cls sig => cls -> sig
set_anchors_preset = runMethod @"set_anchors_preset"

set_angular_damp :: Method "set_angular_damp" cls sig => cls -> sig
set_angular_damp = runMethod @"set_angular_damp"

set_angular_velocity ::
                       Method "set_angular_velocity" cls sig => cls -> sig
set_angular_velocity = runMethod @"set_angular_velocity"

set_animation :: Method "set_animation" cls sig => cls -> sig
set_animation = runMethod @"set_animation"

set_animation_loop ::
                     Method "set_animation_loop" cls sig => cls -> sig
set_animation_loop = runMethod @"set_animation_loop"

set_animation_path ::
                     Method "set_animation_path" cls sig => cls -> sig
set_animation_path = runMethod @"set_animation_path"

set_animation_player ::
                       Method "set_animation_player" cls sig => cls -> sig
set_animation_player = runMethod @"set_animation_player"

set_animation_process_mode ::
                             Method "set_animation_process_mode" cls sig => cls -> sig
set_animation_process_mode
  = runMethod @"set_animation_process_mode"

set_animation_speed ::
                      Method "set_animation_speed" cls sig => cls -> sig
set_animation_speed = runMethod @"set_animation_speed"

set_anisotropy :: Method "set_anisotropy" cls sig => cls -> sig
set_anisotropy = runMethod @"set_anisotropy"

set_anti_aliased :: Method "set_anti_aliased" cls sig => cls -> sig
set_anti_aliased = runMethod @"set_anti_aliased"

set_antialiased :: Method "set_antialiased" cls sig => cls -> sig
set_antialiased = runMethod @"set_antialiased"

set_ao_light_affect ::
                      Method "set_ao_light_affect" cls sig => cls -> sig
set_ao_light_affect = runMethod @"set_ao_light_affect"

set_ao_texture_channel ::
                         Method "set_ao_texture_channel" cls sig => cls -> sig
set_ao_texture_channel = runMethod @"set_ao_texture_channel"

set_applied_force ::
                    Method "set_applied_force" cls sig => cls -> sig
set_applied_force = runMethod @"set_applied_force"

set_applied_torque ::
                     Method "set_applied_torque" cls sig => cls -> sig
set_applied_torque = runMethod @"set_applied_torque"

set_areaAngular_stiffness ::
                            Method "set_areaAngular_stiffness" cls sig => cls -> sig
set_areaAngular_stiffness = runMethod @"set_areaAngular_stiffness"

set_area_mask :: Method "set_area_mask" cls sig => cls -> sig
set_area_mask = runMethod @"set_area_mask"

set_as_audio_listener ::
                        Method "set_as_audio_listener" cls sig => cls -> sig
set_as_audio_listener = runMethod @"set_as_audio_listener"

set_as_audio_listener_2d ::
                           Method "set_as_audio_listener_2d" cls sig => cls -> sig
set_as_audio_listener_2d = runMethod @"set_as_audio_listener_2d"

set_as_interior :: Method "set_as_interior" cls sig => cls -> sig
set_as_interior = runMethod @"set_as_interior"

set_as_normalmap :: Method "set_as_normalmap" cls sig => cls -> sig
set_as_normalmap = runMethod @"set_as_normalmap"

set_as_ratio :: Method "set_as_ratio" cls sig => cls -> sig
set_as_ratio = runMethod @"set_as_ratio"

set_as_toplevel :: Method "set_as_toplevel" cls sig => cls -> sig
set_as_toplevel = runMethod @"set_as_toplevel"

set_ascent :: Method "set_ascent" cls sig => cls -> sig
set_ascent = runMethod @"set_ascent"

set_assign_op :: Method "set_assign_op" cls sig => cls -> sig
set_assign_op = runMethod @"set_assign_op"

set_assigned_animation ::
                         Method "set_assigned_animation" cls sig => cls -> sig
set_assigned_animation = runMethod @"set_assigned_animation"

set_atlas :: Method "set_atlas" cls sig => cls -> sig
set_atlas = runMethod @"set_atlas"

set_attach_to_screen_rect ::
                            Method "set_attach_to_screen_rect" cls sig => cls -> sig
set_attach_to_screen_rect = runMethod @"set_attach_to_screen_rect"

set_attack_us :: Method "set_attack_us" cls sig => cls -> sig
set_attack_us = runMethod @"set_attack_us"

set_attenuation :: Method "set_attenuation" cls sig => cls -> sig
set_attenuation = runMethod @"set_attenuation"

set_attenuation_filter_cutoff_hz ::
                                   Method "set_attenuation_filter_cutoff_hz" cls sig => cls -> sig
set_attenuation_filter_cutoff_hz
  = runMethod @"set_attenuation_filter_cutoff_hz"

set_attenuation_filter_db ::
                            Method "set_attenuation_filter_db" cls sig => cls -> sig
set_attenuation_filter_db = runMethod @"set_attenuation_filter_db"

set_attenuation_model ::
                        Method "set_attenuation_model" cls sig => cls -> sig
set_attenuation_model = runMethod @"set_attenuation_model"

set_audio_bus :: Method "set_audio_bus" cls sig => cls -> sig
set_audio_bus = runMethod @"set_audio_bus"

set_audio_bus_name ::
                     Method "set_audio_bus_name" cls sig => cls -> sig
set_audio_bus_name = runMethod @"set_audio_bus_name"

set_audio_bus_override ::
                         Method "set_audio_bus_override" cls sig => cls -> sig
set_audio_bus_override = runMethod @"set_audio_bus_override"

set_audio_stream :: Method "set_audio_stream" cls sig => cls -> sig
set_audio_stream = runMethod @"set_audio_stream"

set_audio_track :: Method "set_audio_track" cls sig => cls -> sig
set_audio_track = runMethod @"set_audio_track"

set_auto_accept_quit ::
                       Method "set_auto_accept_quit" cls sig => cls -> sig
set_auto_accept_quit = runMethod @"set_auto_accept_quit"

set_auto_advance :: Method "set_auto_advance" cls sig => cls -> sig
set_auto_advance = runMethod @"set_auto_advance"

set_auto_height :: Method "set_auto_height" cls sig => cls -> sig
set_auto_height = runMethod @"set_auto_height"

set_auto_triangles ::
                     Method "set_auto_triangles" cls sig => cls -> sig
set_auto_triangles = runMethod @"set_auto_triangles"

set_autoplay :: Method "set_autoplay" cls sig => cls -> sig
set_autoplay = runMethod @"set_autoplay"

set_autorestart :: Method "set_autorestart" cls sig => cls -> sig
set_autorestart = runMethod @"set_autorestart"

set_autorestart_delay ::
                        Method "set_autorestart_delay" cls sig => cls -> sig
set_autorestart_delay = runMethod @"set_autorestart_delay"

set_autorestart_random_delay ::
                               Method "set_autorestart_random_delay" cls sig => cls -> sig
set_autorestart_random_delay
  = runMethod @"set_autorestart_random_delay"

set_autostart :: Method "set_autostart" cls sig => cls -> sig
set_autostart = runMethod @"set_autostart"

set_autowrap :: Method "set_autowrap" cls sig => cls -> sig
set_autowrap = runMethod @"set_autowrap"

set_axis :: Method "set_axis" cls sig => cls -> sig
set_axis = runMethod @"set_axis"

set_axis_lock :: Method "set_axis_lock" cls sig => cls -> sig
set_axis_lock = runMethod @"set_axis_lock"

set_axis_value :: Method "set_axis_value" cls sig => cls -> sig
set_axis_value = runMethod @"set_axis_value"

set_axis_velocity ::
                    Method "set_axis_velocity" cls sig => cls -> sig
set_axis_velocity = runMethod @"set_axis_velocity"

set_b :: Method "set_b" cls sig => cls -> sig
set_b = runMethod @"set_b"

set_background :: Method "set_background" cls sig => cls -> sig
set_background = runMethod @"set_background"

set_bake_cell_size ::
                     Method "set_bake_cell_size" cls sig => cls -> sig
set_bake_cell_size = runMethod @"set_bake_cell_size"

set_bake_interval ::
                    Method "set_bake_interval" cls sig => cls -> sig
set_bake_interval = runMethod @"set_bake_interval"

set_bake_mode :: Method "set_bake_mode" cls sig => cls -> sig
set_bake_mode = runMethod @"set_bake_mode"

set_bake_quality :: Method "set_bake_quality" cls sig => cls -> sig
set_bake_quality = runMethod @"set_bake_quality"

set_bake_resolution ::
                      Method "set_bake_resolution" cls sig => cls -> sig
set_bake_resolution = runMethod @"set_bake_resolution"

set_band_gain_db :: Method "set_band_gain_db" cls sig => cls -> sig
set_band_gain_db = runMethod @"set_band_gain_db"

set_base :: Method "set_base" cls sig => cls -> sig
set_base = runMethod @"set_base"

set_base_path :: Method "set_base_path" cls sig => cls -> sig
set_base_path = runMethod @"set_base_path"

set_base_script :: Method "set_base_script" cls sig => cls -> sig
set_base_script = runMethod @"set_base_script"

set_base_type :: Method "set_base_type" cls sig => cls -> sig
set_base_type = runMethod @"set_base_type"

set_basic_type :: Method "set_basic_type" cls sig => cls -> sig
set_basic_type = runMethod @"set_basic_type"

set_basic_type_constant ::
                          Method "set_basic_type_constant" cls sig => cls -> sig
set_basic_type_constant = runMethod @"set_basic_type_constant"

set_bbcode :: Method "set_bbcode" cls sig => cls -> sig
set_bbcode = runMethod @"set_bbcode"

set_begin :: Method "set_begin" cls sig => cls -> sig
set_begin = runMethod @"set_begin"

set_begin_cap_mode ::
                     Method "set_begin_cap_mode" cls sig => cls -> sig
set_begin_cap_mode = runMethod @"set_begin_cap_mode"

set_bg_color :: Method "set_bg_color" cls sig => cls -> sig
set_bg_color = runMethod @"set_bg_color"

set_bg_energy :: Method "set_bg_energy" cls sig => cls -> sig
set_bg_energy = runMethod @"set_bg_energy"

set_bias :: Method "set_bias" cls sig => cls -> sig
set_bias = runMethod @"set_bias"

set_big_endian :: Method "set_big_endian" cls sig => cls -> sig
set_big_endian = runMethod @"set_big_endian"

set_billboard_mode ::
                     Method "set_billboard_mode" cls sig => cls -> sig
set_billboard_mode = runMethod @"set_billboard_mode"

set_bind_ip :: Method "set_bind_ip" cls sig => cls -> sig
set_bind_ip = runMethod @"set_bind_ip"

set_bit :: Method "set_bit" cls sig => cls -> sig
set_bit = runMethod @"set_bit"

set_bit_rect :: Method "set_bit_rect" cls sig => cls -> sig
set_bit_rect = runMethod @"set_bit_rect"

set_bitmask :: Method "set_bitmask" cls sig => cls -> sig
set_bitmask = runMethod @"set_bitmask"

set_blend_mode :: Method "set_blend_mode" cls sig => cls -> sig
set_blend_mode = runMethod @"set_blend_mode"

set_blend_point_node ::
                       Method "set_blend_point_node" cls sig => cls -> sig
set_blend_point_node = runMethod @"set_blend_point_node"

set_blend_point_position ::
                           Method "set_blend_point_position" cls sig => cls -> sig
set_blend_point_position = runMethod @"set_blend_point_position"

set_blend_shape_mode ::
                       Method "set_blend_shape_mode" cls sig => cls -> sig
set_blend_shape_mode = runMethod @"set_blend_shape_mode"

set_blend_splits :: Method "set_blend_splits" cls sig => cls -> sig
set_blend_splits = runMethod @"set_blend_splits"

set_blend_time :: Method "set_blend_time" cls sig => cls -> sig
set_blend_time = runMethod @"set_blend_time"

set_block_signals ::
                    Method "set_block_signals" cls sig => cls -> sig
set_block_signals = runMethod @"set_block_signals"

set_blocking_handshake_enabled ::
                                 Method "set_blocking_handshake_enabled" cls sig => cls -> sig
set_blocking_handshake_enabled
  = runMethod @"set_blocking_handshake_enabled"

set_blocking_mode ::
                    Method "set_blocking_mode" cls sig => cls -> sig
set_blocking_mode = runMethod @"set_blocking_mode"

set_body_offset :: Method "set_body_offset" cls sig => cls -> sig
set_body_offset = runMethod @"set_body_offset"

set_body_size_limit ::
                      Method "set_body_size_limit" cls sig => cls -> sig
set_body_size_limit = runMethod @"set_body_size_limit"

set_bone_custom_pose ::
                       Method "set_bone_custom_pose" cls sig => cls -> sig
set_bone_custom_pose = runMethod @"set_bone_custom_pose"

set_bone_disable_rest ::
                        Method "set_bone_disable_rest" cls sig => cls -> sig
set_bone_disable_rest = runMethod @"set_bone_disable_rest"

set_bone_global_pose ::
                       Method "set_bone_global_pose" cls sig => cls -> sig
set_bone_global_pose = runMethod @"set_bone_global_pose"

set_bone_ignore_animation ::
                            Method "set_bone_ignore_animation" cls sig => cls -> sig
set_bone_ignore_animation = runMethod @"set_bone_ignore_animation"

set_bone_name :: Method "set_bone_name" cls sig => cls -> sig
set_bone_name = runMethod @"set_bone_name"

set_bone_parent :: Method "set_bone_parent" cls sig => cls -> sig
set_bone_parent = runMethod @"set_bone_parent"

set_bone_path :: Method "set_bone_path" cls sig => cls -> sig
set_bone_path = runMethod @"set_bone_path"

set_bone_pose :: Method "set_bone_pose" cls sig => cls -> sig
set_bone_pose = runMethod @"set_bone_pose"

set_bone_rest :: Method "set_bone_rest" cls sig => cls -> sig
set_bone_rest = runMethod @"set_bone_rest"

set_bone_weights :: Method "set_bone_weights" cls sig => cls -> sig
set_bone_weights = runMethod @"set_bone_weights"

set_boot_image :: Method "set_boot_image" cls sig => cls -> sig
set_boot_image = runMethod @"set_boot_image"

set_border_blend :: Method "set_border_blend" cls sig => cls -> sig
set_border_blend = runMethod @"set_border_blend"

set_border_color :: Method "set_border_color" cls sig => cls -> sig
set_border_color = runMethod @"set_border_color"

set_border_width :: Method "set_border_width" cls sig => cls -> sig
set_border_width = runMethod @"set_border_width"

set_border_width_all ::
                       Method "set_border_width_all" cls sig => cls -> sig
set_border_width_all = runMethod @"set_border_width_all"

set_borderless_window ::
                        Method "set_borderless_window" cls sig => cls -> sig
set_borderless_window = runMethod @"set_borderless_window"

set_bottom_radius ::
                    Method "set_bottom_radius" cls sig => cls -> sig
set_bottom_radius = runMethod @"set_bottom_radius"

set_bounce :: Method "set_bounce" cls sig => cls -> sig
set_bounce = runMethod @"set_bounce"

set_bounds :: Method "set_bounds" cls sig => cls -> sig
set_bounds = runMethod @"set_bounds"

set_brake :: Method "set_brake" cls sig => cls -> sig
set_brake = runMethod @"set_brake"

set_breakpoint_gutter_enabled ::
                                Method "set_breakpoint_gutter_enabled" cls sig => cls -> sig
set_breakpoint_gutter_enabled
  = runMethod @"set_breakpoint_gutter_enabled"

set_buffering_msec ::
                     Method "set_buffering_msec" cls sig => cls -> sig
set_buffering_msec = runMethod @"set_buffering_msec"

set_build_mode :: Method "set_build_mode" cls sig => cls -> sig
set_build_mode = runMethod @"set_build_mode"

set_bus :: Method "set_bus" cls sig => cls -> sig
set_bus = runMethod @"set_bus"

set_bus_bypass_effects ::
                         Method "set_bus_bypass_effects" cls sig => cls -> sig
set_bus_bypass_effects = runMethod @"set_bus_bypass_effects"

set_bus_count :: Method "set_bus_count" cls sig => cls -> sig
set_bus_count = runMethod @"set_bus_count"

set_bus_effect_enabled ::
                         Method "set_bus_effect_enabled" cls sig => cls -> sig
set_bus_effect_enabled = runMethod @"set_bus_effect_enabled"

set_bus_layout :: Method "set_bus_layout" cls sig => cls -> sig
set_bus_layout = runMethod @"set_bus_layout"

set_bus_mute :: Method "set_bus_mute" cls sig => cls -> sig
set_bus_mute = runMethod @"set_bus_mute"

set_bus_name :: Method "set_bus_name" cls sig => cls -> sig
set_bus_name = runMethod @"set_bus_name"

set_bus_send :: Method "set_bus_send" cls sig => cls -> sig
set_bus_send = runMethod @"set_bus_send"

set_bus_solo :: Method "set_bus_solo" cls sig => cls -> sig
set_bus_solo = runMethod @"set_bus_solo"

set_bus_volume_db ::
                    Method "set_bus_volume_db" cls sig => cls -> sig
set_bus_volume_db = runMethod @"set_bus_volume_db"

set_button :: Method "set_button" cls sig => cls -> sig
set_button = runMethod @"set_button"

set_button_group :: Method "set_button_group" cls sig => cls -> sig
set_button_group = runMethod @"set_button_group"

set_button_icon :: Method "set_button_icon" cls sig => cls -> sig
set_button_icon = runMethod @"set_button_icon"

set_button_index :: Method "set_button_index" cls sig => cls -> sig
set_button_index = runMethod @"set_button_index"

set_button_mask :: Method "set_button_mask" cls sig => cls -> sig
set_button_mask = runMethod @"set_button_mask"

set_call_mode :: Method "set_call_mode" cls sig => cls -> sig
set_call_mode = runMethod @"set_call_mode"

set_can_sleep :: Method "set_can_sleep" cls sig => cls -> sig
set_can_sleep = runMethod @"set_can_sleep"

set_canvas_max_layer ::
                       Method "set_canvas_max_layer" cls sig => cls -> sig
set_canvas_max_layer = runMethod @"set_canvas_max_layer"

set_canvas_transform ::
                       Method "set_canvas_transform" cls sig => cls -> sig
set_canvas_transform = runMethod @"set_canvas_transform"

set_capture_cell_size ::
                        Method "set_capture_cell_size" cls sig => cls -> sig
set_capture_cell_size = runMethod @"set_capture_cell_size"

set_capture_input_on_drag ::
                            Method "set_capture_input_on_drag" cls sig => cls -> sig
set_capture_input_on_drag = runMethod @"set_capture_input_on_drag"

set_cast_shadows_setting ::
                           Method "set_cast_shadows_setting" cls sig => cls -> sig
set_cast_shadows_setting = runMethod @"set_cast_shadows_setting"

set_cast_to :: Method "set_cast_to" cls sig => cls -> sig
set_cast_to = runMethod @"set_cast_to"

set_ceiling_db :: Method "set_ceiling_db" cls sig => cls -> sig
set_ceiling_db = runMethod @"set_ceiling_db"

set_cell :: Method "set_cell" cls sig => cls -> sig
set_cell = runMethod @"set_cell"

set_cell_height :: Method "set_cell_height" cls sig => cls -> sig
set_cell_height = runMethod @"set_cell_height"

set_cell_item :: Method "set_cell_item" cls sig => cls -> sig
set_cell_item = runMethod @"set_cell_item"

set_cell_mode :: Method "set_cell_mode" cls sig => cls -> sig
set_cell_mode = runMethod @"set_cell_mode"

set_cell_scale :: Method "set_cell_scale" cls sig => cls -> sig
set_cell_scale = runMethod @"set_cell_scale"

set_cell_size :: Method "set_cell_size" cls sig => cls -> sig
set_cell_size = runMethod @"set_cell_size"

set_cell_space_transform ::
                           Method "set_cell_space_transform" cls sig => cls -> sig
set_cell_space_transform = runMethod @"set_cell_space_transform"

set_cell_subdiv :: Method "set_cell_subdiv" cls sig => cls -> sig
set_cell_subdiv = runMethod @"set_cell_subdiv"

set_cellv :: Method "set_cellv" cls sig => cls -> sig
set_cellv = runMethod @"set_cellv"

set_center_x :: Method "set_center_x" cls sig => cls -> sig
set_center_x = runMethod @"set_center_x"

set_center_y :: Method "set_center_y" cls sig => cls -> sig
set_center_y = runMethod @"set_center_y"

set_center_z :: Method "set_center_z" cls sig => cls -> sig
set_center_z = runMethod @"set_center_z"

set_centered :: Method "set_centered" cls sig => cls -> sig
set_centered = runMethod @"set_centered"

set_channel_count ::
                    Method "set_channel_count" cls sig => cls -> sig
set_channel_count = runMethod @"set_channel_count"

set_checkable :: Method "set_checkable" cls sig => cls -> sig
set_checkable = runMethod @"set_checkable"

set_checked :: Method "set_checked" cls sig => cls -> sig
set_checked = runMethod @"set_checked"

set_class_constant ::
                     Method "set_class_constant" cls sig => cls -> sig
set_class_constant = runMethod @"set_class_constant"

set_class_name :: Method "set_class_name" cls sig => cls -> sig
set_class_name = runMethod @"set_class_name"

set_clear_button_enabled ::
                           Method "set_clear_button_enabled" cls sig => cls -> sig
set_clear_button_enabled = runMethod @"set_clear_button_enabled"

set_clear_mode :: Method "set_clear_mode" cls sig => cls -> sig
set_clear_mode = runMethod @"set_clear_mode"

set_clearcoat :: Method "set_clearcoat" cls sig => cls -> sig
set_clearcoat = runMethod @"set_clearcoat"

set_clearcoat_gloss ::
                      Method "set_clearcoat_gloss" cls sig => cls -> sig
set_clearcoat_gloss = runMethod @"set_clearcoat_gloss"

set_click_mask :: Method "set_click_mask" cls sig => cls -> sig
set_click_mask = runMethod @"set_click_mask"

set_clip :: Method "set_clip" cls sig => cls -> sig
set_clip = runMethod @"set_clip"

set_clip_contents ::
                    Method "set_clip_contents" cls sig => cls -> sig
set_clip_contents = runMethod @"set_clip_contents"

set_clip_text :: Method "set_clip_text" cls sig => cls -> sig
set_clip_text = runMethod @"set_clip_text"

set_clip_to_areas ::
                    Method "set_clip_to_areas" cls sig => cls -> sig
set_clip_to_areas = runMethod @"set_clip_to_areas"

set_clip_to_bodies ::
                     Method "set_clip_to_bodies" cls sig => cls -> sig
set_clip_to_bodies = runMethod @"set_clip_to_bodies"

set_clip_uv :: Method "set_clip_uv" cls sig => cls -> sig
set_clip_uv = runMethod @"set_clip_uv"

set_clipboard :: Method "set_clipboard" cls sig => cls -> sig
set_clipboard = runMethod @"set_clipboard"

set_closed :: Method "set_closed" cls sig => cls -> sig
set_closed = runMethod @"set_closed"

set_code :: Method "set_code" cls sig => cls -> sig
set_code = runMethod @"set_code"

set_collapsed :: Method "set_collapsed" cls sig => cls -> sig
set_collapsed = runMethod @"set_collapsed"

set_collide_with_areas ::
                         Method "set_collide_with_areas" cls sig => cls -> sig
set_collide_with_areas = runMethod @"set_collide_with_areas"

set_collide_with_bodies ::
                          Method "set_collide_with_bodies" cls sig => cls -> sig
set_collide_with_bodies = runMethod @"set_collide_with_bodies"

set_collision_bounce ::
                       Method "set_collision_bounce" cls sig => cls -> sig
set_collision_bounce = runMethod @"set_collision_bounce"

set_collision_friction ::
                         Method "set_collision_friction" cls sig => cls -> sig
set_collision_friction = runMethod @"set_collision_friction"

set_collision_layer ::
                      Method "set_collision_layer" cls sig => cls -> sig
set_collision_layer = runMethod @"set_collision_layer"

set_collision_layer_bit ::
                          Method "set_collision_layer_bit" cls sig => cls -> sig
set_collision_layer_bit = runMethod @"set_collision_layer_bit"

set_collision_mask ::
                     Method "set_collision_mask" cls sig => cls -> sig
set_collision_mask = runMethod @"set_collision_mask"

set_collision_mask_bit ::
                         Method "set_collision_mask_bit" cls sig => cls -> sig
set_collision_mask_bit = runMethod @"set_collision_mask_bit"

set_collision_use_kinematic ::
                              Method "set_collision_use_kinematic" cls sig => cls -> sig
set_collision_use_kinematic
  = runMethod @"set_collision_use_kinematic"

set_color :: Method "set_color" cls sig => cls -> sig
set_color = runMethod @"set_color"

set_color_default ::
                    Method "set_color_default" cls sig => cls -> sig
set_color_default = runMethod @"set_color_default"

set_color_format :: Method "set_color_format" cls sig => cls -> sig
set_color_format = runMethod @"set_color_format"

set_color_ramp :: Method "set_color_ramp" cls sig => cls -> sig
set_color_ramp = runMethod @"set_color_ramp"

set_colors :: Method "set_colors" cls sig => cls -> sig
set_colors = runMethod @"set_colors"

set_column_expand ::
                    Method "set_column_expand" cls sig => cls -> sig
set_column_expand = runMethod @"set_column_expand"

set_column_min_width ::
                       Method "set_column_min_width" cls sig => cls -> sig
set_column_min_width = runMethod @"set_column_min_width"

set_column_title :: Method "set_column_title" cls sig => cls -> sig
set_column_title = runMethod @"set_column_title"

set_column_titles_visible ::
                            Method "set_column_titles_visible" cls sig => cls -> sig
set_column_titles_visible = runMethod @"set_column_titles_visible"

set_columns :: Method "set_columns" cls sig => cls -> sig
set_columns = runMethod @"set_columns"

set_command :: Method "set_command" cls sig => cls -> sig
set_command = runMethod @"set_command"

set_comment :: Method "set_comment" cls sig => cls -> sig
set_comment = runMethod @"set_comment"

set_compress :: Method "set_compress" cls sig => cls -> sig
set_compress = runMethod @"set_compress"

set_compression_mode ::
                       Method "set_compression_mode" cls sig => cls -> sig
set_compression_mode = runMethod @"set_compression_mode"

set_cone :: Method "set_cone" cls sig => cls -> sig
set_cone = runMethod @"set_cone"

set_config_file :: Method "set_config_file" cls sig => cls -> sig
set_config_file = runMethod @"set_config_file"

set_connection :: Method "set_connection" cls sig => cls -> sig
set_connection = runMethod @"set_connection"

set_connection_activity ::
                          Method "set_connection_activity" cls sig => cls -> sig
set_connection_activity = runMethod @"set_connection_activity"

set_constant :: Method "set_constant" cls sig => cls -> sig
set_constant = runMethod @"set_constant"

set_constant_angular_velocity ::
                                Method "set_constant_angular_velocity" cls sig => cls -> sig
set_constant_angular_velocity
  = runMethod @"set_constant_angular_velocity"

set_constant_linear_velocity ::
                               Method "set_constant_linear_velocity" cls sig => cls -> sig
set_constant_linear_velocity
  = runMethod @"set_constant_linear_velocity"

set_constant_type ::
                    Method "set_constant_type" cls sig => cls -> sig
set_constant_type = runMethod @"set_constant_type"

set_constant_value ::
                     Method "set_constant_value" cls sig => cls -> sig
set_constant_value = runMethod @"set_constant_value"

set_constructor :: Method "set_constructor" cls sig => cls -> sig
set_constructor = runMethod @"set_constructor"

set_constructor_type ::
                       Method "set_constructor_type" cls sig => cls -> sig
set_constructor_type = runMethod @"set_constructor_type"

set_contact_monitor ::
                      Method "set_contact_monitor" cls sig => cls -> sig
set_contact_monitor = runMethod @"set_contact_monitor"

set_context_menu_enabled ::
                           Method "set_context_menu_enabled" cls sig => cls -> sig
set_context_menu_enabled = runMethod @"set_context_menu_enabled"

set_continuous_collision_detection_mode ::
                                          Method "set_continuous_collision_detection_mode" cls
                                            sig =>
                                          cls -> sig
set_continuous_collision_detection_mode
  = runMethod @"set_continuous_collision_detection_mode"

set_control :: Method "set_control" cls sig => cls -> sig
set_control = runMethod @"set_control"

set_controller_id ::
                    Method "set_controller_id" cls sig => cls -> sig
set_controller_id = runMethod @"set_controller_id"

set_copy_mode :: Method "set_copy_mode" cls sig => cls -> sig
set_copy_mode = runMethod @"set_copy_mode"

set_corner_detail ::
                    Method "set_corner_detail" cls sig => cls -> sig
set_corner_detail = runMethod @"set_corner_detail"

set_corner_radius ::
                    Method "set_corner_radius" cls sig => cls -> sig
set_corner_radius = runMethod @"set_corner_radius"

set_corner_radius_all ::
                        Method "set_corner_radius_all" cls sig => cls -> sig
set_corner_radius_all = runMethod @"set_corner_radius_all"

set_corner_radius_individual ::
                               Method "set_corner_radius_individual" cls sig => cls -> sig
set_corner_radius_individual
  = runMethod @"set_corner_radius_individual"

set_cross_fade_time ::
                      Method "set_cross_fade_time" cls sig => cls -> sig
set_cross_fade_time = runMethod @"set_cross_fade_time"

set_cube_map :: Method "set_cube_map" cls sig => cls -> sig
set_cube_map = runMethod @"set_cube_map"

set_cubic_interpolation ::
                          Method "set_cubic_interpolation" cls sig => cls -> sig
set_cubic_interpolation = runMethod @"set_cubic_interpolation"

set_cull_mask :: Method "set_cull_mask" cls sig => cls -> sig
set_cull_mask = runMethod @"set_cull_mask"

set_cull_mask_bit ::
                    Method "set_cull_mask_bit" cls sig => cls -> sig
set_cull_mask_bit = runMethod @"set_cull_mask_bit"

set_cull_mode :: Method "set_cull_mode" cls sig => cls -> sig
set_cull_mode = runMethod @"set_cull_mode"

set_current :: Method "set_current" cls sig => cls -> sig
set_current = runMethod @"set_current"

set_current_animation ::
                        Method "set_current_animation" cls sig => cls -> sig
set_current_animation = runMethod @"set_current_animation"

set_current_dir :: Method "set_current_dir" cls sig => cls -> sig
set_current_dir = runMethod @"set_current_dir"

set_current_file :: Method "set_current_file" cls sig => cls -> sig
set_current_file = runMethod @"set_current_file"

set_current_path :: Method "set_current_path" cls sig => cls -> sig
set_current_path = runMethod @"set_current_path"

set_current_scene ::
                    Method "set_current_scene" cls sig => cls -> sig
set_current_scene = runMethod @"set_current_scene"

set_current_screen ::
                     Method "set_current_screen" cls sig => cls -> sig
set_current_screen = runMethod @"set_current_screen"

set_current_tab :: Method "set_current_tab" cls sig => cls -> sig
set_current_tab = runMethod @"set_current_tab"

set_cursor_position ::
                      Method "set_cursor_position" cls sig => cls -> sig
set_cursor_position = runMethod @"set_cursor_position"

set_curve :: Method "set_curve" cls sig => cls -> sig
set_curve = runMethod @"set_curve"

set_custom_aabb :: Method "set_custom_aabb" cls sig => cls -> sig
set_custom_aabb = runMethod @"set_custom_aabb"

set_custom_as_button ::
                       Method "set_custom_as_button" cls sig => cls -> sig
set_custom_as_button = runMethod @"set_custom_as_button"

set_custom_bg_color ::
                      Method "set_custom_bg_color" cls sig => cls -> sig
set_custom_bg_color = runMethod @"set_custom_bg_color"

set_custom_color :: Method "set_custom_color" cls sig => cls -> sig
set_custom_color = runMethod @"set_custom_color"

set_custom_data_format ::
                         Method "set_custom_data_format" cls sig => cls -> sig
set_custom_data_format = runMethod @"set_custom_data_format"

set_custom_draw :: Method "set_custom_draw" cls sig => cls -> sig
set_custom_draw = runMethod @"set_custom_draw"

set_custom_minimum_height ::
                            Method "set_custom_minimum_height" cls sig => cls -> sig
set_custom_minimum_height = runMethod @"set_custom_minimum_height"

set_custom_minimum_size ::
                          Method "set_custom_minimum_size" cls sig => cls -> sig
set_custom_minimum_size = runMethod @"set_custom_minimum_size"

set_custom_mouse_cursor ::
                          Method "set_custom_mouse_cursor" cls sig => cls -> sig
set_custom_mouse_cursor = runMethod @"set_custom_mouse_cursor"

set_custom_multiplayer ::
                         Method "set_custom_multiplayer" cls sig => cls -> sig
set_custom_multiplayer = runMethod @"set_custom_multiplayer"

set_custom_solver_bias ::
                         Method "set_custom_solver_bias" cls sig => cls -> sig
set_custom_solver_bias = runMethod @"set_custom_solver_bias"

set_custom_step :: Method "set_custom_step" cls sig => cls -> sig
set_custom_step = runMethod @"set_custom_step"

set_custom_transform ::
                       Method "set_custom_transform" cls sig => cls -> sig
set_custom_transform = runMethod @"set_custom_transform"

set_custom_viewport ::
                      Method "set_custom_viewport" cls sig => cls -> sig
set_custom_viewport = runMethod @"set_custom_viewport"

set_cutoff :: Method "set_cutoff" cls sig => cls -> sig
set_cutoff = runMethod @"set_cutoff"

set_d :: Method "set_d" cls sig => cls -> sig
set_d = runMethod @"set_d"

set_damping :: Method "set_damping" cls sig => cls -> sig
set_damping = runMethod @"set_damping"

set_damping_coefficient ::
                          Method "set_damping_coefficient" cls sig => cls -> sig
set_damping_coefficient = runMethod @"set_damping_coefficient"

set_damping_compression ::
                          Method "set_damping_compression" cls sig => cls -> sig
set_damping_compression = runMethod @"set_damping_compression"

set_damping_relaxation ::
                         Method "set_damping_relaxation" cls sig => cls -> sig
set_damping_relaxation = runMethod @"set_damping_relaxation"

set_data :: Method "set_data" cls sig => cls -> sig
set_data = runMethod @"set_data"

set_data_array :: Method "set_data_array" cls sig => cls -> sig
set_data_array = runMethod @"set_data_array"

set_data_partial :: Method "set_data_partial" cls sig => cls -> sig
set_data_partial = runMethod @"set_data_partial"

set_db :: Method "set_db" cls sig => cls -> sig
set_db = runMethod @"set_db"

set_deadzone :: Method "set_deadzone" cls sig => cls -> sig
set_deadzone = runMethod @"set_deadzone"

set_debug_collisions_hint ::
                            Method "set_debug_collisions_hint" cls sig => cls -> sig
set_debug_collisions_hint = runMethod @"set_debug_collisions_hint"

set_debug_draw :: Method "set_debug_draw" cls sig => cls -> sig
set_debug_draw = runMethod @"set_debug_draw"

set_debug_generate_wireframes ::
                                Method "set_debug_generate_wireframes" cls sig => cls -> sig
set_debug_generate_wireframes
  = runMethod @"set_debug_generate_wireframes"

set_debug_navigation_hint ::
                            Method "set_debug_navigation_hint" cls sig => cls -> sig
set_debug_navigation_hint = runMethod @"set_debug_navigation_hint"

set_deconstruct_type ::
                       Method "set_deconstruct_type" cls sig => cls -> sig
set_deconstruct_type = runMethod @"set_deconstruct_type"

set_default_blend_time ::
                         Method "set_default_blend_time" cls sig => cls -> sig
set_default_blend_time = runMethod @"set_default_blend_time"

set_default_clear_color ::
                          Method "set_default_clear_color" cls sig => cls -> sig
set_default_clear_color = runMethod @"set_default_clear_color"

set_default_color ::
                    Method "set_default_color" cls sig => cls -> sig
set_default_color = runMethod @"set_default_color"

set_default_cursor_shape ::
                           Method "set_default_cursor_shape" cls sig => cls -> sig
set_default_cursor_shape = runMethod @"set_default_cursor_shape"

set_default_font :: Method "set_default_font" cls sig => cls -> sig
set_default_font = runMethod @"set_default_font"

set_default_input_value ::
                          Method "set_default_input_value" cls sig => cls -> sig
set_default_input_value = runMethod @"set_default_input_value"

set_default_length ::
                     Method "set_default_length" cls sig => cls -> sig
set_default_length = runMethod @"set_default_length"

set_default_margin ::
                     Method "set_default_margin" cls sig => cls -> sig
set_default_margin = runMethod @"set_default_margin"

set_default_texture_param ::
                            Method "set_default_texture_param" cls sig => cls -> sig
set_default_texture_param = runMethod @"set_default_texture_param"

set_deferred_mode ::
                    Method "set_deferred_mode" cls sig => cls -> sig
set_deferred_mode = runMethod @"set_deferred_mode"

set_delta :: Method "set_delta" cls sig => cls -> sig
set_delta = runMethod @"set_delta"

set_depth :: Method "set_depth" cls sig => cls -> sig
set_depth = runMethod @"set_depth"

set_depth_deep_parallax ::
                          Method "set_depth_deep_parallax" cls sig => cls -> sig
set_depth_deep_parallax = runMethod @"set_depth_deep_parallax"

set_depth_deep_parallax_max_layers ::
                                     Method "set_depth_deep_parallax_max_layers" cls sig =>
                                     cls -> sig
set_depth_deep_parallax_max_layers
  = runMethod @"set_depth_deep_parallax_max_layers"

set_depth_deep_parallax_min_layers ::
                                     Method "set_depth_deep_parallax_min_layers" cls sig =>
                                     cls -> sig
set_depth_deep_parallax_min_layers
  = runMethod @"set_depth_deep_parallax_min_layers"

set_depth_draw_mode ::
                      Method "set_depth_draw_mode" cls sig => cls -> sig
set_depth_draw_mode = runMethod @"set_depth_draw_mode"

set_depth_scale :: Method "set_depth_scale" cls sig => cls -> sig
set_depth_scale = runMethod @"set_depth_scale"

set_description :: Method "set_description" cls sig => cls -> sig
set_description = runMethod @"set_description"

set_description_url ::
                      Method "set_description_url" cls sig => cls -> sig
set_description_url = runMethod @"set_description_url"

set_dest_address :: Method "set_dest_address" cls sig => cls -> sig
set_dest_address = runMethod @"set_dest_address"

set_detail_blend_mode ::
                        Method "set_detail_blend_mode" cls sig => cls -> sig
set_detail_blend_mode = runMethod @"set_detail_blend_mode"

set_detail_sample_distance ::
                             Method "set_detail_sample_distance" cls sig => cls -> sig
set_detail_sample_distance
  = runMethod @"set_detail_sample_distance"

set_detail_sample_max_error ::
                              Method "set_detail_sample_max_error" cls sig => cls -> sig
set_detail_sample_max_error
  = runMethod @"set_detail_sample_max_error"

set_detail_uv :: Method "set_detail_uv" cls sig => cls -> sig
set_detail_uv = runMethod @"set_detail_uv"

set_device :: Method "set_device" cls sig => cls -> sig
set_device = runMethod @"set_device"

set_diffuse_mode :: Method "set_diffuse_mode" cls sig => cls -> sig
set_diffuse_mode = runMethod @"set_diffuse_mode"

set_disable_3d :: Method "set_disable_3d" cls sig => cls -> sig
set_disable_3d = runMethod @"set_disable_3d"

set_disable_folding ::
                      Method "set_disable_folding" cls sig => cls -> sig
set_disable_folding = runMethod @"set_disable_folding"

set_disable_input ::
                    Method "set_disable_input" cls sig => cls -> sig
set_disable_input = runMethod @"set_disable_input"

set_disable_overwrite_warning ::
                                Method "set_disable_overwrite_warning" cls sig => cls -> sig
set_disable_overwrite_warning
  = runMethod @"set_disable_overwrite_warning"

set_disable_scale ::
                    Method "set_disable_scale" cls sig => cls -> sig
set_disable_scale = runMethod @"set_disable_scale"

set_disable_shortcuts ::
                        Method "set_disable_shortcuts" cls sig => cls -> sig
set_disable_shortcuts = runMethod @"set_disable_shortcuts"

set_disabled :: Method "set_disabled" cls sig => cls -> sig
set_disabled = runMethod @"set_disabled"

set_disabled_texture ::
                       Method "set_disabled_texture" cls sig => cls -> sig
set_disabled_texture = runMethod @"set_disabled_texture"

set_discover_ipv6 ::
                    Method "set_discover_ipv6" cls sig => cls -> sig
set_discover_ipv6 = runMethod @"set_discover_ipv6"

set_discover_local_port ::
                          Method "set_discover_local_port" cls sig => cls -> sig
set_discover_local_port = runMethod @"set_discover_local_port"

set_discover_multicast_if ::
                            Method "set_discover_multicast_if" cls sig => cls -> sig
set_discover_multicast_if = runMethod @"set_discover_multicast_if"

set_dispatch_mode ::
                    Method "set_dispatch_mode" cls sig => cls -> sig
set_dispatch_mode = runMethod @"set_dispatch_mode"

set_display_folded ::
                     Method "set_display_folded" cls sig => cls -> sig
set_display_folded = runMethod @"set_display_folded"

set_display_mode :: Method "set_display_mode" cls sig => cls -> sig
set_display_mode = runMethod @"set_display_mode"

set_display_to_lens ::
                      Method "set_display_to_lens" cls sig => cls -> sig
set_display_to_lens = runMethod @"set_display_to_lens"

set_display_width ::
                    Method "set_display_width" cls sig => cls -> sig
set_display_width = runMethod @"set_display_width"

set_distance_fade ::
                    Method "set_distance_fade" cls sig => cls -> sig
set_distance_fade = runMethod @"set_distance_fade"

set_distance_fade_max_distance ::
                                 Method "set_distance_fade_max_distance" cls sig => cls -> sig
set_distance_fade_max_distance
  = runMethod @"set_distance_fade_max_distance"

set_distance_fade_min_distance ::
                                 Method "set_distance_fade_min_distance" cls sig => cls -> sig
set_distance_fade_min_distance
  = runMethod @"set_distance_fade_min_distance"

set_distance_field_hint ::
                          Method "set_distance_field_hint" cls sig => cls -> sig
set_distance_field_hint = runMethod @"set_distance_field_hint"

set_dof_blur_far_amount ::
                          Method "set_dof_blur_far_amount" cls sig => cls -> sig
set_dof_blur_far_amount = runMethod @"set_dof_blur_far_amount"

set_dof_blur_far_distance ::
                            Method "set_dof_blur_far_distance" cls sig => cls -> sig
set_dof_blur_far_distance = runMethod @"set_dof_blur_far_distance"

set_dof_blur_far_enabled ::
                           Method "set_dof_blur_far_enabled" cls sig => cls -> sig
set_dof_blur_far_enabled = runMethod @"set_dof_blur_far_enabled"

set_dof_blur_far_quality ::
                           Method "set_dof_blur_far_quality" cls sig => cls -> sig
set_dof_blur_far_quality = runMethod @"set_dof_blur_far_quality"

set_dof_blur_far_transition ::
                              Method "set_dof_blur_far_transition" cls sig => cls -> sig
set_dof_blur_far_transition
  = runMethod @"set_dof_blur_far_transition"

set_dof_blur_near_amount ::
                           Method "set_dof_blur_near_amount" cls sig => cls -> sig
set_dof_blur_near_amount = runMethod @"set_dof_blur_near_amount"

set_dof_blur_near_distance ::
                             Method "set_dof_blur_near_distance" cls sig => cls -> sig
set_dof_blur_near_distance
  = runMethod @"set_dof_blur_near_distance"

set_dof_blur_near_enabled ::
                            Method "set_dof_blur_near_enabled" cls sig => cls -> sig
set_dof_blur_near_enabled = runMethod @"set_dof_blur_near_enabled"

set_dof_blur_near_quality ::
                            Method "set_dof_blur_near_quality" cls sig => cls -> sig
set_dof_blur_near_quality = runMethod @"set_dof_blur_near_quality"

set_dof_blur_near_transition ::
                               Method "set_dof_blur_near_transition" cls sig => cls -> sig
set_dof_blur_near_transition
  = runMethod @"set_dof_blur_near_transition"

set_doppler_tracking ::
                       Method "set_doppler_tracking" cls sig => cls -> sig
set_doppler_tracking = runMethod @"set_doppler_tracking"

set_doubleclick :: Method "set_doubleclick" cls sig => cls -> sig
set_doubleclick = runMethod @"set_doubleclick"

set_download_file ::
                    Method "set_download_file" cls sig => cls -> sig
set_download_file = runMethod @"set_download_file"

set_drag_coefficient ::
                       Method "set_drag_coefficient" cls sig => cls -> sig
set_drag_coefficient = runMethod @"set_drag_coefficient"

set_drag_forwarding ::
                      Method "set_drag_forwarding" cls sig => cls -> sig
set_drag_forwarding = runMethod @"set_drag_forwarding"

set_drag_margin :: Method "set_drag_margin" cls sig => cls -> sig
set_drag_margin = runMethod @"set_drag_margin"

set_drag_preview :: Method "set_drag_preview" cls sig => cls -> sig
set_drag_preview = runMethod @"set_drag_preview"

set_drag_to_rearrange_enabled ::
                                Method "set_drag_to_rearrange_enabled" cls sig => cls -> sig
set_drag_to_rearrange_enabled
  = runMethod @"set_drag_to_rearrange_enabled"

set_dragger_visibility ::
                         Method "set_dragger_visibility" cls sig => cls -> sig
set_dragger_visibility = runMethod @"set_dragger_visibility"

set_draw_behind_parent ::
                         Method "set_draw_behind_parent" cls sig => cls -> sig
set_draw_behind_parent = runMethod @"set_draw_behind_parent"

set_draw_center :: Method "set_draw_center" cls sig => cls -> sig
set_draw_center = runMethod @"set_draw_center"

set_draw_flag :: Method "set_draw_flag" cls sig => cls -> sig
set_draw_flag = runMethod @"set_draw_flag"

set_draw_order :: Method "set_draw_order" cls sig => cls -> sig
set_draw_order = runMethod @"set_draw_order"

set_draw_pass_mesh ::
                     Method "set_draw_pass_mesh" cls sig => cls -> sig
set_draw_pass_mesh = runMethod @"set_draw_pass_mesh"

set_draw_passes :: Method "set_draw_passes" cls sig => cls -> sig
set_draw_passes = runMethod @"set_draw_passes"

set_draw_red :: Method "set_draw_red" cls sig => cls -> sig
set_draw_red = runMethod @"set_draw_red"

set_drive :: Method "set_drive" cls sig => cls -> sig
set_drive = runMethod @"set_drive"

set_drop_mode_flags ::
                      Method "set_drop_mode_flags" cls sig => cls -> sig
set_drop_mode_flags = runMethod @"set_drop_mode_flags"

set_dry :: Method "set_dry" cls sig => cls -> sig
set_dry = runMethod @"set_dry"

set_dynamic_data :: Method "set_dynamic_data" cls sig => cls -> sig
set_dynamic_data = runMethod @"set_dynamic_data"

set_dynamic_range ::
                    Method "set_dynamic_range" cls sig => cls -> sig
set_dynamic_range = runMethod @"set_dynamic_range"

set_echo :: Method "set_echo" cls sig => cls -> sig
set_echo = runMethod @"set_echo"

set_edge_max_error ::
                     Method "set_edge_max_error" cls sig => cls -> sig
set_edge_max_error = runMethod @"set_edge_max_error"

set_edge_max_length ::
                      Method "set_edge_max_length" cls sig => cls -> sig
set_edge_max_length = runMethod @"set_edge_max_length"

set_edge_meta :: Method "set_edge_meta" cls sig => cls -> sig
set_edge_meta = runMethod @"set_edge_meta"

set_edit_alpha :: Method "set_edit_alpha" cls sig => cls -> sig
set_edit_alpha = runMethod @"set_edit_alpha"

set_editable :: Method "set_editable" cls sig => cls -> sig
set_editable = runMethod @"set_editable"

set_edited_scene_root ::
                        Method "set_edited_scene_root" cls sig => cls -> sig
set_edited_scene_root = runMethod @"set_edited_scene_root"

set_editor_hint :: Method "set_editor_hint" cls sig => cls -> sig
set_editor_hint = runMethod @"set_editor_hint"

set_editor_only :: Method "set_editor_only" cls sig => cls -> sig
set_editor_only = runMethod @"set_editor_only"

set_emission :: Method "set_emission" cls sig => cls -> sig
set_emission = runMethod @"set_emission"

set_emission_angle ::
                     Method "set_emission_angle" cls sig => cls -> sig
set_emission_angle = runMethod @"set_emission_angle"

set_emission_angle_enabled ::
                             Method "set_emission_angle_enabled" cls sig => cls -> sig
set_emission_angle_enabled
  = runMethod @"set_emission_angle_enabled"

set_emission_angle_filter_attenuation_db ::
                                           Method "set_emission_angle_filter_attenuation_db" cls
                                             sig =>
                                           cls -> sig
set_emission_angle_filter_attenuation_db
  = runMethod @"set_emission_angle_filter_attenuation_db"

set_emission_box_extents ::
                           Method "set_emission_box_extents" cls sig => cls -> sig
set_emission_box_extents = runMethod @"set_emission_box_extents"

set_emission_color_texture ::
                             Method "set_emission_color_texture" cls sig => cls -> sig
set_emission_color_texture
  = runMethod @"set_emission_color_texture"

set_emission_colors ::
                      Method "set_emission_colors" cls sig => cls -> sig
set_emission_colors = runMethod @"set_emission_colors"

set_emission_energy ::
                      Method "set_emission_energy" cls sig => cls -> sig
set_emission_energy = runMethod @"set_emission_energy"

set_emission_normal_texture ::
                              Method "set_emission_normal_texture" cls sig => cls -> sig
set_emission_normal_texture
  = runMethod @"set_emission_normal_texture"

set_emission_normals ::
                       Method "set_emission_normals" cls sig => cls -> sig
set_emission_normals = runMethod @"set_emission_normals"

set_emission_operator ::
                        Method "set_emission_operator" cls sig => cls -> sig
set_emission_operator = runMethod @"set_emission_operator"

set_emission_point_count ::
                           Method "set_emission_point_count" cls sig => cls -> sig
set_emission_point_count = runMethod @"set_emission_point_count"

set_emission_point_texture ::
                             Method "set_emission_point_texture" cls sig => cls -> sig
set_emission_point_texture
  = runMethod @"set_emission_point_texture"

set_emission_points ::
                      Method "set_emission_points" cls sig => cls -> sig
set_emission_points = runMethod @"set_emission_points"

set_emission_rect_extents ::
                            Method "set_emission_rect_extents" cls sig => cls -> sig
set_emission_rect_extents = runMethod @"set_emission_rect_extents"

set_emission_shape ::
                     Method "set_emission_shape" cls sig => cls -> sig
set_emission_shape = runMethod @"set_emission_shape"

set_emission_sphere_radius ::
                             Method "set_emission_sphere_radius" cls sig => cls -> sig
set_emission_sphere_radius
  = runMethod @"set_emission_sphere_radius"

set_emitting :: Method "set_emitting" cls sig => cls -> sig
set_emitting = runMethod @"set_emitting"

set_enable_box_projection ::
                            Method "set_enable_box_projection" cls sig => cls -> sig
set_enable_box_projection = runMethod @"set_enable_box_projection"

set_enable_follow_smoothing ::
                              Method "set_enable_follow_smoothing" cls sig => cls -> sig
set_enable_follow_smoothing
  = runMethod @"set_enable_follow_smoothing"

set_enable_h_scroll ::
                      Method "set_enable_h_scroll" cls sig => cls -> sig
set_enable_h_scroll = runMethod @"set_enable_h_scroll"

set_enable_return_value ::
                          Method "set_enable_return_value" cls sig => cls -> sig
set_enable_return_value = runMethod @"set_enable_return_value"

set_enable_shadows ::
                     Method "set_enable_shadows" cls sig => cls -> sig
set_enable_shadows = runMethod @"set_enable_shadows"

set_enable_v_scroll ::
                      Method "set_enable_v_scroll" cls sig => cls -> sig
set_enable_v_scroll = runMethod @"set_enable_v_scroll"

set_enabled :: Method "set_enabled" cls sig => cls -> sig
set_enabled = runMethod @"set_enabled"

set_enabled_focus_mode ::
                         Method "set_enabled_focus_mode" cls sig => cls -> sig
set_enabled_focus_mode = runMethod @"set_enabled_focus_mode"

set_enabled_inputs ::
                     Method "set_enabled_inputs" cls sig => cls -> sig
set_enabled_inputs = runMethod @"set_enabled_inputs"

set_enabler :: Method "set_enabler" cls sig => cls -> sig
set_enabler = runMethod @"set_enabler"

set_end :: Method "set_end" cls sig => cls -> sig
set_end = runMethod @"set_end"

set_end_cap_mode :: Method "set_end_cap_mode" cls sig => cls -> sig
set_end_cap_mode = runMethod @"set_end_cap_mode"

set_end_node :: Method "set_end_node" cls sig => cls -> sig
set_end_node = runMethod @"set_end_node"

set_endian_swap :: Method "set_endian_swap" cls sig => cls -> sig
set_endian_swap = runMethod @"set_endian_swap"

set_energy :: Method "set_energy" cls sig => cls -> sig
set_energy = runMethod @"set_energy"

set_engine_force :: Method "set_engine_force" cls sig => cls -> sig
set_engine_force = runMethod @"set_engine_force"

set_environment :: Method "set_environment" cls sig => cls -> sig
set_environment = runMethod @"set_environment"

set_error :: Method "set_error" cls sig => cls -> sig
set_error = runMethod @"set_error"

set_error_line :: Method "set_error_line" cls sig => cls -> sig
set_error_line = runMethod @"set_error_line"

set_error_string :: Method "set_error_string" cls sig => cls -> sig
set_error_string = runMethod @"set_error_string"

set_exclude :: Method "set_exclude" cls sig => cls -> sig
set_exclude = runMethod @"set_exclude"

set_exclude_nodes_from_collision ::
                                   Method "set_exclude_nodes_from_collision" cls sig => cls -> sig
set_exclude_nodes_from_collision
  = runMethod @"set_exclude_nodes_from_collision"

set_exclude_parent_body ::
                          Method "set_exclude_parent_body" cls sig => cls -> sig
set_exclude_parent_body = runMethod @"set_exclude_parent_body"

set_exclusive :: Method "set_exclusive" cls sig => cls -> sig
set_exclusive = runMethod @"set_exclusive"

set_exit_code :: Method "set_exit_code" cls sig => cls -> sig
set_exit_code = runMethod @"set_exit_code"

set_exp_ratio :: Method "set_exp_ratio" cls sig => cls -> sig
set_exp_ratio = runMethod @"set_exp_ratio"

set_expand :: Method "set_expand" cls sig => cls -> sig
set_expand = runMethod @"set_expand"

set_expand_margin ::
                    Method "set_expand_margin" cls sig => cls -> sig
set_expand_margin = runMethod @"set_expand_margin"

set_expand_margin_all ::
                        Method "set_expand_margin_all" cls sig => cls -> sig
set_expand_margin_all = runMethod @"set_expand_margin_all"

set_expand_margin_individual ::
                               Method "set_expand_margin_individual" cls sig => cls -> sig
set_expand_margin_individual
  = runMethod @"set_expand_margin_individual"

set_expand_margin_size ::
                         Method "set_expand_margin_size" cls sig => cls -> sig
set_expand_margin_size = runMethod @"set_expand_margin_size"

set_expand_right :: Method "set_expand_right" cls sig => cls -> sig
set_expand_right = runMethod @"set_expand_right"

set_expand_to_text_length ::
                            Method "set_expand_to_text_length" cls sig => cls -> sig
set_expand_to_text_length = runMethod @"set_expand_to_text_length"

set_explosiveness_ratio ::
                          Method "set_explosiveness_ratio" cls sig => cls -> sig
set_explosiveness_ratio = runMethod @"set_explosiveness_ratio"

set_extents :: Method "set_extents" cls sig => cls -> sig
set_extents = runMethod @"set_extents"

set_extra_cull_margin ::
                        Method "set_extra_cull_margin" cls sig => cls -> sig
set_extra_cull_margin = runMethod @"set_extra_cull_margin"

set_face_meta :: Method "set_face_meta" cls sig => cls -> sig
set_face_meta = runMethod @"set_face_meta"

set_faces :: Method "set_faces" cls sig => cls -> sig
set_faces = runMethod @"set_faces"

set_factor :: Method "set_factor" cls sig => cls -> sig
set_factor = runMethod @"set_factor"

set_fadein_time :: Method "set_fadein_time" cls sig => cls -> sig
set_fadein_time = runMethod @"set_fadein_time"

set_fadeout_time :: Method "set_fadeout_time" cls sig => cls -> sig
set_fadeout_time = runMethod @"set_fadeout_time"

set_fallback :: Method "set_fallback" cls sig => cls -> sig
set_fallback = runMethod @"set_fallback"

set_fallback_environment ::
                           Method "set_fallback_environment" cls sig => cls -> sig
set_fallback_environment = runMethod @"set_fallback_environment"

set_favorites :: Method "set_favorites" cls sig => cls -> sig
set_favorites = runMethod @"set_favorites"

set_feature :: Method "set_feature" cls sig => cls -> sig
set_feature = runMethod @"set_feature"

set_feedback :: Method "set_feedback" cls sig => cls -> sig
set_feedback = runMethod @"set_feedback"

set_feedback_active ::
                      Method "set_feedback_active" cls sig => cls -> sig
set_feedback_active = runMethod @"set_feedback_active"

set_feedback_delay_ms ::
                        Method "set_feedback_delay_ms" cls sig => cls -> sig
set_feedback_delay_ms = runMethod @"set_feedback_delay_ms"

set_feedback_level_db ::
                        Method "set_feedback_level_db" cls sig => cls -> sig
set_feedback_level_db = runMethod @"set_feedback_level_db"

set_feedback_lowpass ::
                       Method "set_feedback_lowpass" cls sig => cls -> sig
set_feedback_lowpass = runMethod @"set_feedback_lowpass"

set_file :: Method "set_file" cls sig => cls -> sig
set_file = runMethod @"set_file"

set_filename :: Method "set_filename" cls sig => cls -> sig
set_filename = runMethod @"set_filename"

set_fill_degrees :: Method "set_fill_degrees" cls sig => cls -> sig
set_fill_degrees = runMethod @"set_fill_degrees"

set_fill_mode :: Method "set_fill_mode" cls sig => cls -> sig
set_fill_mode = runMethod @"set_fill_mode"

set_filter_clip :: Method "set_filter_clip" cls sig => cls -> sig
set_filter_clip = runMethod @"set_filter_clip"

set_filter_enabled ::
                     Method "set_filter_enabled" cls sig => cls -> sig
set_filter_enabled = runMethod @"set_filter_enabled"

set_filter_ledge_spans ::
                         Method "set_filter_ledge_spans" cls sig => cls -> sig
set_filter_ledge_spans = runMethod @"set_filter_ledge_spans"

set_filter_low_hanging_obstacles ::
                                   Method "set_filter_low_hanging_obstacles" cls sig => cls -> sig
set_filter_low_hanging_obstacles
  = runMethod @"set_filter_low_hanging_obstacles"

set_filter_path :: Method "set_filter_path" cls sig => cls -> sig
set_filter_path = runMethod @"set_filter_path"

set_filter_walkable_low_height_spans ::
                                       Method "set_filter_walkable_low_height_spans" cls sig =>
                                       cls -> sig
set_filter_walkable_low_height_spans
  = runMethod @"set_filter_walkable_low_height_spans"

set_filters :: Method "set_filters" cls sig => cls -> sig
set_filters = runMethod @"set_filters"

set_fixed_column_width ::
                         Method "set_fixed_column_width" cls sig => cls -> sig
set_fixed_column_width = runMethod @"set_fixed_column_width"

set_fixed_fps :: Method "set_fixed_fps" cls sig => cls -> sig
set_fixed_fps = runMethod @"set_fixed_fps"

set_fixed_icon_size ::
                      Method "set_fixed_icon_size" cls sig => cls -> sig
set_fixed_icon_size = runMethod @"set_fixed_icon_size"

set_flag :: Method "set_flag" cls sig => cls -> sig
set_flag = runMethod @"set_flag"

set_flag_x :: Method "set_flag_x" cls sig => cls -> sig
set_flag_x = runMethod @"set_flag_x"

set_flag_y :: Method "set_flag_y" cls sig => cls -> sig
set_flag_y = runMethod @"set_flag_y"

set_flag_z :: Method "set_flag_z" cls sig => cls -> sig
set_flag_z = runMethod @"set_flag_z"

set_flags :: Method "set_flags" cls sig => cls -> sig
set_flags = runMethod @"set_flags"

set_flat :: Method "set_flat" cls sig => cls -> sig
set_flat = runMethod @"set_flat"

set_flatness :: Method "set_flatness" cls sig => cls -> sig
set_flatness = runMethod @"set_flatness"

set_flip_faces :: Method "set_flip_faces" cls sig => cls -> sig
set_flip_faces = runMethod @"set_flip_faces"

set_flip_h :: Method "set_flip_h" cls sig => cls -> sig
set_flip_h = runMethod @"set_flip_h"

set_flip_v :: Method "set_flip_v" cls sig => cls -> sig
set_flip_v = runMethod @"set_flip_v"

set_focus_mode :: Method "set_focus_mode" cls sig => cls -> sig
set_focus_mode = runMethod @"set_focus_mode"

set_focus_neighbour ::
                      Method "set_focus_neighbour" cls sig => cls -> sig
set_focus_neighbour = runMethod @"set_focus_neighbour"

set_focus_next :: Method "set_focus_next" cls sig => cls -> sig
set_focus_next = runMethod @"set_focus_next"

set_focus_previous ::
                     Method "set_focus_previous" cls sig => cls -> sig
set_focus_previous = runMethod @"set_focus_previous"

set_focused_texture ::
                      Method "set_focused_texture" cls sig => cls -> sig
set_focused_texture = runMethod @"set_focused_texture"

set_fog_color :: Method "set_fog_color" cls sig => cls -> sig
set_fog_color = runMethod @"set_fog_color"

set_fog_depth_begin ::
                      Method "set_fog_depth_begin" cls sig => cls -> sig
set_fog_depth_begin = runMethod @"set_fog_depth_begin"

set_fog_depth_curve ::
                      Method "set_fog_depth_curve" cls sig => cls -> sig
set_fog_depth_curve = runMethod @"set_fog_depth_curve"

set_fog_depth_enabled ::
                        Method "set_fog_depth_enabled" cls sig => cls -> sig
set_fog_depth_enabled = runMethod @"set_fog_depth_enabled"

set_fog_enabled :: Method "set_fog_enabled" cls sig => cls -> sig
set_fog_enabled = runMethod @"set_fog_enabled"

set_fog_height_curve ::
                       Method "set_fog_height_curve" cls sig => cls -> sig
set_fog_height_curve = runMethod @"set_fog_height_curve"

set_fog_height_enabled ::
                         Method "set_fog_height_enabled" cls sig => cls -> sig
set_fog_height_enabled = runMethod @"set_fog_height_enabled"

set_fog_height_max ::
                     Method "set_fog_height_max" cls sig => cls -> sig
set_fog_height_max = runMethod @"set_fog_height_max"

set_fog_height_min ::
                     Method "set_fog_height_min" cls sig => cls -> sig
set_fog_height_min = runMethod @"set_fog_height_min"

set_fog_sun_amount ::
                     Method "set_fog_sun_amount" cls sig => cls -> sig
set_fog_sun_amount = runMethod @"set_fog_sun_amount"

set_fog_sun_color ::
                    Method "set_fog_sun_color" cls sig => cls -> sig
set_fog_sun_color = runMethod @"set_fog_sun_color"

set_fog_transmit_curve ::
                         Method "set_fog_transmit_curve" cls sig => cls -> sig
set_fog_transmit_curve = runMethod @"set_fog_transmit_curve"

set_fog_transmit_enabled ::
                           Method "set_fog_transmit_enabled" cls sig => cls -> sig
set_fog_transmit_enabled = runMethod @"set_fog_transmit_enabled"

set_follow_smoothing ::
                       Method "set_follow_smoothing" cls sig => cls -> sig
set_follow_smoothing = runMethod @"set_follow_smoothing"

set_font :: Method "set_font" cls sig => cls -> sig
set_font = runMethod @"set_font"

set_font_data :: Method "set_font_data" cls sig => cls -> sig
set_font_data = runMethod @"set_font_data"

set_font_path :: Method "set_font_path" cls sig => cls -> sig
set_font_path = runMethod @"set_font_path"

set_force_draw_over_forwarding_enabled ::
                                         Method "set_force_draw_over_forwarding_enabled" cls sig =>
                                         cls -> sig
set_force_draw_over_forwarding_enabled
  = runMethod @"set_force_draw_over_forwarding_enabled"

set_format :: Method "set_format" cls sig => cls -> sig
set_format = runMethod @"set_format"

set_fov :: Method "set_fov" cls sig => cls -> sig
set_fov = runMethod @"set_fov"

set_fps :: Method "set_fps" cls sig => cls -> sig
set_fps = runMethod @"set_fps"

set_fractional_delta ::
                       Method "set_fractional_delta" cls sig => cls -> sig
set_fractional_delta = runMethod @"set_fractional_delta"

set_frame :: Method "set_frame" cls sig => cls -> sig
set_frame = runMethod @"set_frame"

set_frame_color :: Method "set_frame_color" cls sig => cls -> sig
set_frame_color = runMethod @"set_frame_color"

set_frame_delay :: Method "set_frame_delay" cls sig => cls -> sig
set_frame_delay = runMethod @"set_frame_delay"

set_frame_texture ::
                    Method "set_frame_texture" cls sig => cls -> sig
set_frame_texture = runMethod @"set_frame_texture"

set_frames :: Method "set_frames" cls sig => cls -> sig
set_frames = runMethod @"set_frames"

set_friction :: Method "set_friction" cls sig => cls -> sig
set_friction = runMethod @"set_friction"

set_friction_slip ::
                    Method "set_friction_slip" cls sig => cls -> sig
set_friction_slip = runMethod @"set_friction_slip"

set_func :: Method "set_func" cls sig => cls -> sig
set_func = runMethod @"set_func"

set_function :: Method "set_function" cls sig => cls -> sig
set_function = runMethod @"set_function"

set_function_scroll ::
                      Method "set_function_scroll" cls sig => cls -> sig
set_function_scroll = runMethod @"set_function_scroll"

set_gain :: Method "set_gain" cls sig => cls -> sig
set_gain = runMethod @"set_gain"

set_gizmo :: Method "set_gizmo" cls sig => cls -> sig
set_gizmo = runMethod @"set_gizmo"

set_global_canvas_transform ::
                              Method "set_global_canvas_transform" cls sig => cls -> sig
set_global_canvas_transform
  = runMethod @"set_global_canvas_transform"

set_global_constant ::
                      Method "set_global_constant" cls sig => cls -> sig
set_global_constant = runMethod @"set_global_constant"

set_global_position ::
                      Method "set_global_position" cls sig => cls -> sig
set_global_position = runMethod @"set_global_position"

set_global_rotation ::
                      Method "set_global_rotation" cls sig => cls -> sig
set_global_rotation = runMethod @"set_global_rotation"

set_global_rotation_degrees ::
                              Method "set_global_rotation_degrees" cls sig => cls -> sig
set_global_rotation_degrees
  = runMethod @"set_global_rotation_degrees"

set_global_scale :: Method "set_global_scale" cls sig => cls -> sig
set_global_scale = runMethod @"set_global_scale"

set_global_transform ::
                       Method "set_global_transform" cls sig => cls -> sig
set_global_transform = runMethod @"set_global_transform"

set_glow_bicubic_upscale ::
                           Method "set_glow_bicubic_upscale" cls sig => cls -> sig
set_glow_bicubic_upscale = runMethod @"set_glow_bicubic_upscale"

set_glow_blend_mode ::
                      Method "set_glow_blend_mode" cls sig => cls -> sig
set_glow_blend_mode = runMethod @"set_glow_blend_mode"

set_glow_bloom :: Method "set_glow_bloom" cls sig => cls -> sig
set_glow_bloom = runMethod @"set_glow_bloom"

set_glow_enabled :: Method "set_glow_enabled" cls sig => cls -> sig
set_glow_enabled = runMethod @"set_glow_enabled"

set_glow_hdr_bleed_scale ::
                           Method "set_glow_hdr_bleed_scale" cls sig => cls -> sig
set_glow_hdr_bleed_scale = runMethod @"set_glow_hdr_bleed_scale"

set_glow_hdr_bleed_threshold ::
                               Method "set_glow_hdr_bleed_threshold" cls sig => cls -> sig
set_glow_hdr_bleed_threshold
  = runMethod @"set_glow_hdr_bleed_threshold"

set_glow_intensity ::
                     Method "set_glow_intensity" cls sig => cls -> sig
set_glow_intensity = runMethod @"set_glow_intensity"

set_glow_level :: Method "set_glow_level" cls sig => cls -> sig
set_glow_level = runMethod @"set_glow_level"

set_glow_strength ::
                    Method "set_glow_strength" cls sig => cls -> sig
set_glow_strength = runMethod @"set_glow_strength"

set_gradient :: Method "set_gradient" cls sig => cls -> sig
set_gradient = runMethod @"set_gradient"

set_graph_offset :: Method "set_graph_offset" cls sig => cls -> sig
set_graph_offset = runMethod @"set_graph_offset"

set_gravity :: Method "set_gravity" cls sig => cls -> sig
set_gravity = runMethod @"set_gravity"

set_gravity_distance_scale ::
                             Method "set_gravity_distance_scale" cls sig => cls -> sig
set_gravity_distance_scale
  = runMethod @"set_gravity_distance_scale"

set_gravity_is_point ::
                       Method "set_gravity_is_point" cls sig => cls -> sig
set_gravity_is_point = runMethod @"set_gravity_is_point"

set_gravity_scale ::
                    Method "set_gravity_scale" cls sig => cls -> sig
set_gravity_scale = runMethod @"set_gravity_scale"

set_gravity_vector ::
                     Method "set_gravity_vector" cls sig => cls -> sig
set_gravity_vector = runMethod @"set_gravity_vector"

set_grid_radius :: Method "set_grid_radius" cls sig => cls -> sig
set_grid_radius = runMethod @"set_grid_radius"

set_ground_bottom_color ::
                          Method "set_ground_bottom_color" cls sig => cls -> sig
set_ground_bottom_color = runMethod @"set_ground_bottom_color"

set_ground_curve :: Method "set_ground_curve" cls sig => cls -> sig
set_ground_curve = runMethod @"set_ground_curve"

set_ground_energy ::
                    Method "set_ground_energy" cls sig => cls -> sig
set_ground_energy = runMethod @"set_ground_energy"

set_ground_horizon_color ::
                           Method "set_ground_horizon_color" cls sig => cls -> sig
set_ground_horizon_color = runMethod @"set_ground_horizon_color"

set_group :: Method "set_group" cls sig => cls -> sig
set_group = runMethod @"set_group"

set_group_flags :: Method "set_group_flags" cls sig => cls -> sig
set_group_flags = runMethod @"set_group_flags"

set_group_name :: Method "set_group_name" cls sig => cls -> sig
set_group_name = runMethod @"set_group_name"

set_grow :: Method "set_grow" cls sig => cls -> sig
set_grow = runMethod @"set_grow"

set_grow_begin :: Method "set_grow_begin" cls sig => cls -> sig
set_grow_begin = runMethod @"set_grow_begin"

set_grow_enabled :: Method "set_grow_enabled" cls sig => cls -> sig
set_grow_enabled = runMethod @"set_grow_enabled"

set_grow_end :: Method "set_grow_end" cls sig => cls -> sig
set_grow_end = runMethod @"set_grow_end"

set_h_axis_stretch_mode ::
                          Method "set_h_axis_stretch_mode" cls sig => cls -> sig
set_h_axis_stretch_mode = runMethod @"set_h_axis_stretch_mode"

set_h_drag_enabled ::
                     Method "set_h_drag_enabled" cls sig => cls -> sig
set_h_drag_enabled = runMethod @"set_h_drag_enabled"

set_h_frames :: Method "set_h_frames" cls sig => cls -> sig
set_h_frames = runMethod @"set_h_frames"

set_h_grow_direction ::
                       Method "set_h_grow_direction" cls sig => cls -> sig
set_h_grow_direction = runMethod @"set_h_grow_direction"

set_h_offset :: Method "set_h_offset" cls sig => cls -> sig
set_h_offset = runMethod @"set_h_offset"

set_h_scroll :: Method "set_h_scroll" cls sig => cls -> sig
set_h_scroll = runMethod @"set_h_scroll"

set_h_size_flags :: Method "set_h_size_flags" cls sig => cls -> sig
set_h_size_flags = runMethod @"set_h_size_flags"

set_half_offset :: Method "set_half_offset" cls sig => cls -> sig
set_half_offset = runMethod @"set_half_offset"

set_handle :: Method "set_handle" cls sig => cls -> sig
set_handle = runMethod @"set_handle"

set_hdr :: Method "set_hdr" cls sig => cls -> sig
set_hdr = runMethod @"set_hdr"

set_height :: Method "set_height" cls sig => cls -> sig
set_height = runMethod @"set_height"

set_hframes :: Method "set_hframes" cls sig => cls -> sig
set_hframes = runMethod @"set_hframes"

set_hidden :: Method "set_hidden" cls sig => cls -> sig
set_hidden = runMethod @"set_hidden"

set_hide_folding :: Method "set_hide_folding" cls sig => cls -> sig
set_hide_folding = runMethod @"set_hide_folding"

set_hide_on_checkable_item_selection ::
                                       Method "set_hide_on_checkable_item_selection" cls sig =>
                                       cls -> sig
set_hide_on_checkable_item_selection
  = runMethod @"set_hide_on_checkable_item_selection"

set_hide_on_item_selection ::
                             Method "set_hide_on_item_selection" cls sig => cls -> sig
set_hide_on_item_selection
  = runMethod @"set_hide_on_item_selection"

set_hide_on_ok :: Method "set_hide_on_ok" cls sig => cls -> sig
set_hide_on_ok = runMethod @"set_hide_on_ok"

set_hide_on_state_item_selection ::
                                   Method "set_hide_on_state_item_selection" cls sig => cls -> sig
set_hide_on_state_item_selection
  = runMethod @"set_hide_on_state_item_selection"

set_hide_on_window_lose_focus ::
                                Method "set_hide_on_window_lose_focus" cls sig => cls -> sig
set_hide_on_window_lose_focus
  = runMethod @"set_hide_on_window_lose_focus"

set_hide_root :: Method "set_hide_root" cls sig => cls -> sig
set_hide_root = runMethod @"set_hide_root"

set_hiding_enabled ::
                     Method "set_hiding_enabled" cls sig => cls -> sig
set_hiding_enabled = runMethod @"set_hiding_enabled"

set_highlight_all_occurrences ::
                                Method "set_highlight_all_occurrences" cls sig => cls -> sig
set_highlight_all_occurrences
  = runMethod @"set_highlight_all_occurrences"

set_highlight_current_line ::
                             Method "set_highlight_current_line" cls sig => cls -> sig
set_highlight_current_line
  = runMethod @"set_highlight_current_line"

set_hinting :: Method "set_hinting" cls sig => cls -> sig
set_hinting = runMethod @"set_hinting"

set_hover_texture ::
                    Method "set_hover_texture" cls sig => cls -> sig
set_hover_texture = runMethod @"set_hover_texture"

set_hpf :: Method "set_hpf" cls sig => cls -> sig
set_hpf = runMethod @"set_hpf"

set_icon :: Method "set_icon" cls sig => cls -> sig
set_icon = runMethod @"set_icon"

set_icon_max_width ::
                     Method "set_icon_max_width" cls sig => cls -> sig
set_icon_max_width = runMethod @"set_icon_max_width"

set_icon_mode :: Method "set_icon_mode" cls sig => cls -> sig
set_icon_mode = runMethod @"set_icon_mode"

set_icon_region :: Method "set_icon_region" cls sig => cls -> sig
set_icon_region = runMethod @"set_icon_region"

set_icon_scale :: Method "set_icon_scale" cls sig => cls -> sig
set_icon_scale = runMethod @"set_icon_scale"

set_identity :: Method "set_identity" cls sig => cls -> sig
set_identity = runMethod @"set_identity"

set_igd_control_url ::
                      Method "set_igd_control_url" cls sig => cls -> sig
set_igd_control_url = runMethod @"set_igd_control_url"

set_igd_our_addr :: Method "set_igd_our_addr" cls sig => cls -> sig
set_igd_our_addr = runMethod @"set_igd_our_addr"

set_igd_service_type ::
                       Method "set_igd_service_type" cls sig => cls -> sig
set_igd_service_type = runMethod @"set_igd_service_type"

set_igd_status :: Method "set_igd_status" cls sig => cls -> sig
set_igd_status = runMethod @"set_igd_status"

set_ignore_camera_zoom ::
                         Method "set_ignore_camera_zoom" cls sig => cls -> sig
set_ignore_camera_zoom = runMethod @"set_ignore_camera_zoom"

set_ignore_transform_notification ::
                                    Method "set_ignore_transform_notification" cls sig => cls -> sig
set_ignore_transform_notification
  = runMethod @"set_ignore_transform_notification"

set_image_path :: Method "set_image_path" cls sig => cls -> sig
set_image_path = runMethod @"set_image_path"

set_ime_position :: Method "set_ime_position" cls sig => cls -> sig
set_ime_position = runMethod @"set_ime_position"

set_index :: Method "set_index" cls sig => cls -> sig
set_index = runMethod @"set_index"

set_indexed :: Method "set_indexed" cls sig => cls -> sig
set_indexed = runMethod @"set_indexed"

set_inertia :: Method "set_inertia" cls sig => cls -> sig
set_inertia = runMethod @"set_inertia"

set_initial_offset ::
                     Method "set_initial_offset" cls sig => cls -> sig
set_initial_offset = runMethod @"set_initial_offset"

set_initial_value ::
                    Method "set_initial_value" cls sig => cls -> sig
set_initial_value = runMethod @"set_initial_value"

set_inner_radius :: Method "set_inner_radius" cls sig => cls -> sig
set_inner_radius = runMethod @"set_inner_radius"

set_input_as_auto_advance ::
                            Method "set_input_as_auto_advance" cls sig => cls -> sig
set_input_as_auto_advance = runMethod @"set_input_as_auto_advance"

set_input_as_handled ::
                       Method "set_input_as_handled" cls sig => cls -> sig
set_input_as_handled = runMethod @"set_input_as_handled"

set_input_buffer_max_size ::
                            Method "set_input_buffer_max_size" cls sig => cls -> sig
set_input_buffer_max_size = runMethod @"set_input_buffer_max_size"

set_input_caption ::
                    Method "set_input_caption" cls sig => cls -> sig
set_input_caption = runMethod @"set_input_caption"

set_input_event_forwarding_always_enabled ::
                                            Method "set_input_event_forwarding_always_enabled" cls
                                              sig =>
                                            cls -> sig
set_input_event_forwarding_always_enabled
  = runMethod @"set_input_event_forwarding_always_enabled"

set_input_name :: Method "set_input_name" cls sig => cls -> sig
set_input_name = runMethod @"set_input_name"

set_input_port_default_value ::
                               Method "set_input_port_default_value" cls sig => cls -> sig
set_input_port_default_value
  = runMethod @"set_input_port_default_value"

set_instance :: Method "set_instance" cls sig => cls -> sig
set_instance = runMethod @"set_instance"

set_instance_base_type ::
                         Method "set_instance_base_type" cls sig => cls -> sig
set_instance_base_type = runMethod @"set_instance_base_type"

set_instance_color ::
                     Method "set_instance_color" cls sig => cls -> sig
set_instance_color = runMethod @"set_instance_color"

set_instance_count ::
                     Method "set_instance_count" cls sig => cls -> sig
set_instance_count = runMethod @"set_instance_count"

set_instance_custom_data ::
                           Method "set_instance_custom_data" cls sig => cls -> sig
set_instance_custom_data = runMethod @"set_instance_custom_data"

set_instance_transform ::
                         Method "set_instance_transform" cls sig => cls -> sig
set_instance_transform = runMethod @"set_instance_transform"

set_intensity :: Method "set_intensity" cls sig => cls -> sig
set_intensity = runMethod @"set_intensity"

set_interior :: Method "set_interior" cls sig => cls -> sig
set_interior = runMethod @"set_interior"

set_interior_ambient ::
                       Method "set_interior_ambient" cls sig => cls -> sig
set_interior_ambient = runMethod @"set_interior_ambient"

set_interior_ambient_energy ::
                              Method "set_interior_ambient_energy" cls sig => cls -> sig
set_interior_ambient_energy
  = runMethod @"set_interior_ambient_energy"

set_interior_ambient_probe_contribution ::
                                          Method "set_interior_ambient_probe_contribution" cls
                                            sig =>
                                          cls -> sig
set_interior_ambient_probe_contribution
  = runMethod @"set_interior_ambient_probe_contribution"

set_interpolation ::
                    Method "set_interpolation" cls sig => cls -> sig
set_interpolation = runMethod @"set_interpolation"

set_interpolation_enabled ::
                            Method "set_interpolation_enabled" cls sig => cls -> sig
set_interpolation_enabled = runMethod @"set_interpolation_enabled"

set_invert :: Method "set_invert" cls sig => cls -> sig
set_invert = runMethod @"set_invert"

set_invert_border ::
                    Method "set_invert_border" cls sig => cls -> sig
set_invert_border = runMethod @"set_invert_border"

set_invert_faces :: Method "set_invert_faces" cls sig => cls -> sig
set_invert_faces = runMethod @"set_invert_faces"

set_iod :: Method "set_iod" cls sig => cls -> sig
set_iod = runMethod @"set_iod"

set_is_hemisphere ::
                    Method "set_is_hemisphere" cls sig => cls -> sig
set_is_hemisphere = runMethod @"set_is_hemisphere"

set_is_initialized ::
                     Method "set_is_initialized" cls sig => cls -> sig
set_is_initialized = runMethod @"set_is_initialized"

set_is_primary :: Method "set_is_primary" cls sig => cls -> sig
set_is_primary = runMethod @"set_is_primary"

set_item_accelerator ::
                       Method "set_item_accelerator" cls sig => cls -> sig
set_item_accelerator = runMethod @"set_item_accelerator"

set_item_as_checkable ::
                        Method "set_item_as_checkable" cls sig => cls -> sig
set_item_as_checkable = runMethod @"set_item_as_checkable"

set_item_as_radio_checkable ::
                              Method "set_item_as_radio_checkable" cls sig => cls -> sig
set_item_as_radio_checkable
  = runMethod @"set_item_as_radio_checkable"

set_item_as_separator ::
                        Method "set_item_as_separator" cls sig => cls -> sig
set_item_as_separator = runMethod @"set_item_as_separator"

set_item_checked :: Method "set_item_checked" cls sig => cls -> sig
set_item_checked = runMethod @"set_item_checked"

set_item_cull_mask ::
                     Method "set_item_cull_mask" cls sig => cls -> sig
set_item_cull_mask = runMethod @"set_item_cull_mask"

set_item_custom_bg_color ::
                           Method "set_item_custom_bg_color" cls sig => cls -> sig
set_item_custom_bg_color = runMethod @"set_item_custom_bg_color"

set_item_custom_fg_color ::
                           Method "set_item_custom_fg_color" cls sig => cls -> sig
set_item_custom_fg_color = runMethod @"set_item_custom_fg_color"

set_item_disabled ::
                    Method "set_item_disabled" cls sig => cls -> sig
set_item_disabled = runMethod @"set_item_disabled"

set_item_icon :: Method "set_item_icon" cls sig => cls -> sig
set_item_icon = runMethod @"set_item_icon"

set_item_icon_modulate ::
                         Method "set_item_icon_modulate" cls sig => cls -> sig
set_item_icon_modulate = runMethod @"set_item_icon_modulate"

set_item_icon_region ::
                       Method "set_item_icon_region" cls sig => cls -> sig
set_item_icon_region = runMethod @"set_item_icon_region"

set_item_id :: Method "set_item_id" cls sig => cls -> sig
set_item_id = runMethod @"set_item_id"

set_item_mesh :: Method "set_item_mesh" cls sig => cls -> sig
set_item_mesh = runMethod @"set_item_mesh"

set_item_metadata ::
                    Method "set_item_metadata" cls sig => cls -> sig
set_item_metadata = runMethod @"set_item_metadata"

set_item_multistate ::
                      Method "set_item_multistate" cls sig => cls -> sig
set_item_multistate = runMethod @"set_item_multistate"

set_item_name :: Method "set_item_name" cls sig => cls -> sig
set_item_name = runMethod @"set_item_name"

set_item_navmesh :: Method "set_item_navmesh" cls sig => cls -> sig
set_item_navmesh = runMethod @"set_item_navmesh"

set_item_preview :: Method "set_item_preview" cls sig => cls -> sig
set_item_preview = runMethod @"set_item_preview"

set_item_selectable ::
                      Method "set_item_selectable" cls sig => cls -> sig
set_item_selectable = runMethod @"set_item_selectable"

set_item_shadow_cull_mask ::
                            Method "set_item_shadow_cull_mask" cls sig => cls -> sig
set_item_shadow_cull_mask = runMethod @"set_item_shadow_cull_mask"

set_item_shapes :: Method "set_item_shapes" cls sig => cls -> sig
set_item_shapes = runMethod @"set_item_shapes"

set_item_shortcut ::
                    Method "set_item_shortcut" cls sig => cls -> sig
set_item_shortcut = runMethod @"set_item_shortcut"

set_item_shortcut_disabled ::
                             Method "set_item_shortcut_disabled" cls sig => cls -> sig
set_item_shortcut_disabled
  = runMethod @"set_item_shortcut_disabled"

set_item_submenu :: Method "set_item_submenu" cls sig => cls -> sig
set_item_submenu = runMethod @"set_item_submenu"

set_item_text :: Method "set_item_text" cls sig => cls -> sig
set_item_text = runMethod @"set_item_text"

set_item_tooltip :: Method "set_item_tooltip" cls sig => cls -> sig
set_item_tooltip = runMethod @"set_item_tooltip"

set_item_tooltip_enabled ::
                           Method "set_item_tooltip_enabled" cls sig => cls -> sig
set_item_tooltip_enabled = runMethod @"set_item_tooltip_enabled"

set_iterations_per_second ::
                            Method "set_iterations_per_second" cls sig => cls -> sig
set_iterations_per_second = runMethod @"set_iterations_per_second"

set_joint_mode :: Method "set_joint_mode" cls sig => cls -> sig
set_joint_mode = runMethod @"set_joint_mode"

set_joint_offset :: Method "set_joint_offset" cls sig => cls -> sig
set_joint_offset = runMethod @"set_joint_offset"

set_joint_type :: Method "set_joint_type" cls sig => cls -> sig
set_joint_type = runMethod @"set_joint_type"

set_k1 :: Method "set_k1" cls sig => cls -> sig
set_k1 = runMethod @"set_k1"

set_k2 :: Method "set_k2" cls sig => cls -> sig
set_k2 = runMethod @"set_k2"

set_keep_3d_linear ::
                     Method "set_keep_3d_linear" cls sig => cls -> sig
set_keep_3d_linear = runMethod @"set_keep_3d_linear"

set_keep_aspect_mode ::
                       Method "set_keep_aspect_mode" cls sig => cls -> sig
set_keep_aspect_mode = runMethod @"set_keep_aspect_mode"

set_keep_hf_hz :: Method "set_keep_hf_hz" cls sig => cls -> sig
set_keep_hf_hz = runMethod @"set_keep_hf_hz"

set_keep_screen_on ::
                     Method "set_keep_screen_on" cls sig => cls -> sig
set_keep_screen_on = runMethod @"set_keep_screen_on"

set_keying :: Method "set_keying" cls sig => cls -> sig
set_keying = runMethod @"set_keying"

set_label :: Method "set_label" cls sig => cls -> sig
set_label = runMethod @"set_label"

set_lacunarity :: Method "set_lacunarity" cls sig => cls -> sig
set_lacunarity = runMethod @"set_lacunarity"

set_layer :: Method "set_layer" cls sig => cls -> sig
set_layer = runMethod @"set_layer"

set_layer_data :: Method "set_layer_data" cls sig => cls -> sig
set_layer_data = runMethod @"set_layer_data"

set_layer_mask :: Method "set_layer_mask" cls sig => cls -> sig
set_layer_mask = runMethod @"set_layer_mask"

set_layer_mask_bit ::
                     Method "set_layer_mask_bit" cls sig => cls -> sig
set_layer_mask_bit = runMethod @"set_layer_mask_bit"

set_layer_range_max ::
                      Method "set_layer_range_max" cls sig => cls -> sig
set_layer_range_max = runMethod @"set_layer_range_max"

set_layer_range_min ::
                      Method "set_layer_range_min" cls sig => cls -> sig
set_layer_range_min = runMethod @"set_layer_range_min"

set_left_to_right ::
                    Method "set_left_to_right" cls sig => cls -> sig
set_left_to_right = runMethod @"set_left_to_right"

set_length :: Method "set_length" cls sig => cls -> sig
set_length = runMethod @"set_length"

set_library :: Method "set_library" cls sig => cls -> sig
set_library = runMethod @"set_library"

set_lifetime :: Method "set_lifetime" cls sig => cls -> sig
set_lifetime = runMethod @"set_lifetime"

set_light_data :: Method "set_light_data" cls sig => cls -> sig
set_light_data = runMethod @"set_light_data"

set_light_mask :: Method "set_light_mask" cls sig => cls -> sig
set_light_mask = runMethod @"set_light_mask"

set_light_mode :: Method "set_light_mode" cls sig => cls -> sig
set_light_mode = runMethod @"set_light_mode"

set_lightmap_size_hint ::
                         Method "set_lightmap_size_hint" cls sig => cls -> sig
set_lightmap_size_hint = runMethod @"set_lightmap_size_hint"

set_limit :: Method "set_limit" cls sig => cls -> sig
set_limit = runMethod @"set_limit"

set_limit_begin :: Method "set_limit_begin" cls sig => cls -> sig
set_limit_begin = runMethod @"set_limit_begin"

set_limit_drawing_enabled ::
                            Method "set_limit_drawing_enabled" cls sig => cls -> sig
set_limit_drawing_enabled = runMethod @"set_limit_drawing_enabled"

set_limit_end :: Method "set_limit_end" cls sig => cls -> sig
set_limit_end = runMethod @"set_limit_end"

set_limit_smoothing_enabled ::
                              Method "set_limit_smoothing_enabled" cls sig => cls -> sig
set_limit_smoothing_enabled
  = runMethod @"set_limit_smoothing_enabled"

set_line_as_hidden ::
                     Method "set_line_as_hidden" cls sig => cls -> sig
set_line_as_hidden = runMethod @"set_line_as_hidden"

set_line_width :: Method "set_line_width" cls sig => cls -> sig
set_line_width = runMethod @"set_line_width"

set_linear_damp :: Method "set_linear_damp" cls sig => cls -> sig
set_linear_damp = runMethod @"set_linear_damp"

set_linear_stiffness ::
                       Method "set_linear_stiffness" cls sig => cls -> sig
set_linear_stiffness = runMethod @"set_linear_stiffness"

set_linear_velocity ::
                      Method "set_linear_velocity" cls sig => cls -> sig
set_linear_velocity = runMethod @"set_linear_velocity"

set_lines_skipped ::
                    Method "set_lines_skipped" cls sig => cls -> sig
set_lines_skipped = runMethod @"set_lines_skipped"

set_load_once :: Method "set_load_once" cls sig => cls -> sig
set_load_once = runMethod @"set_load_once"

set_local_to_scene ::
                     Method "set_local_to_scene" cls sig => cls -> sig
set_local_to_scene = runMethod @"set_local_to_scene"

set_locale :: Method "set_locale" cls sig => cls -> sig
set_locale = runMethod @"set_locale"

set_lod_max_distance ::
                       Method "set_lod_max_distance" cls sig => cls -> sig
set_lod_max_distance = runMethod @"set_lod_max_distance"

set_lod_max_hysteresis ::
                         Method "set_lod_max_hysteresis" cls sig => cls -> sig
set_lod_max_hysteresis = runMethod @"set_lod_max_hysteresis"

set_lod_min_distance ::
                       Method "set_lod_min_distance" cls sig => cls -> sig
set_lod_min_distance = runMethod @"set_lod_min_distance"

set_lod_min_hysteresis ::
                         Method "set_lod_min_hysteresis" cls sig => cls -> sig
set_lod_min_hysteresis = runMethod @"set_lod_min_hysteresis"

set_lookahead :: Method "set_lookahead" cls sig => cls -> sig
set_lookahead = runMethod @"set_lookahead"

set_loop :: Method "set_loop" cls sig => cls -> sig
set_loop = runMethod @"set_loop"

set_loop_begin :: Method "set_loop_begin" cls sig => cls -> sig
set_loop_begin = runMethod @"set_loop_begin"

set_loop_end :: Method "set_loop_end" cls sig => cls -> sig
set_loop_end = runMethod @"set_loop_end"

set_loop_mode :: Method "set_loop_mode" cls sig => cls -> sig
set_loop_mode = runMethod @"set_loop_mode"

set_loop_offset :: Method "set_loop_offset" cls sig => cls -> sig
set_loop_offset = runMethod @"set_loop_offset"

set_lossy_storage_quality ::
                            Method "set_lossy_storage_quality" cls sig => cls -> sig
set_lossy_storage_quality = runMethod @"set_lossy_storage_quality"

set_low_processor_usage_mode ::
                               Method "set_low_processor_usage_mode" cls sig => cls -> sig
set_low_processor_usage_mode
  = runMethod @"set_low_processor_usage_mode"

set_magnet_position ::
                      Method "set_magnet_position" cls sig => cls -> sig
set_magnet_position = runMethod @"set_magnet_position"

set_margin :: Method "set_margin" cls sig => cls -> sig
set_margin = runMethod @"set_margin"

set_margin_drawing_enabled ::
                             Method "set_margin_drawing_enabled" cls sig => cls -> sig
set_margin_drawing_enabled
  = runMethod @"set_margin_drawing_enabled"

set_margin_size :: Method "set_margin_size" cls sig => cls -> sig
set_margin_size = runMethod @"set_margin_size"

set_margins_preset ::
                     Method "set_margins_preset" cls sig => cls -> sig
set_margins_preset = runMethod @"set_margins_preset"

set_mass :: Method "set_mass" cls sig => cls -> sig
set_mass = runMethod @"set_mass"

set_master_player ::
                    Method "set_master_player" cls sig => cls -> sig
set_master_player = runMethod @"set_master_player"

set_material :: Method "set_material" cls sig => cls -> sig
set_material = runMethod @"set_material"

set_material_override ::
                        Method "set_material_override" cls sig => cls -> sig
set_material_override = runMethod @"set_material_override"

set_math_constant ::
                    Method "set_math_constant" cls sig => cls -> sig
set_math_constant = runMethod @"set_math_constant"

set_max :: Method "set_max" cls sig => cls -> sig
set_max = runMethod @"set_max"

set_max_columns :: Method "set_max_columns" cls sig => cls -> sig
set_max_columns = runMethod @"set_max_columns"

set_max_contacts_reported ::
                            Method "set_max_contacts_reported" cls sig => cls -> sig
set_max_contacts_reported = runMethod @"set_max_contacts_reported"

set_max_db :: Method "set_max_db" cls sig => cls -> sig
set_max_db = runMethod @"set_max_db"

set_max_distance :: Method "set_max_distance" cls sig => cls -> sig
set_max_distance = runMethod @"set_max_distance"

set_max_iterations ::
                     Method "set_max_iterations" cls sig => cls -> sig
set_max_iterations = runMethod @"set_max_iterations"

set_max_length :: Method "set_max_length" cls sig => cls -> sig
set_max_length = runMethod @"set_max_length"

set_max_lines_visible ::
                        Method "set_max_lines_visible" cls sig => cls -> sig
set_max_lines_visible = runMethod @"set_max_lines_visible"

set_max_redirects ::
                    Method "set_max_redirects" cls sig => cls -> sig
set_max_redirects = runMethod @"set_max_redirects"

set_max_space :: Method "set_max_space" cls sig => cls -> sig
set_max_space = runMethod @"set_max_space"

set_max_text_lines ::
                     Method "set_max_text_lines" cls sig => cls -> sig
set_max_text_lines = runMethod @"set_max_text_lines"

set_max_value :: Method "set_max_value" cls sig => cls -> sig
set_max_value = runMethod @"set_max_value"

set_mesh :: Method "set_mesh" cls sig => cls -> sig
set_mesh = runMethod @"set_mesh"

set_mesh_library :: Method "set_mesh_library" cls sig => cls -> sig
set_mesh_library = runMethod @"set_mesh_library"

set_message_translation ::
                          Method "set_message_translation" cls sig => cls -> sig
set_message_translation = runMethod @"set_message_translation"

set_meta :: Method "set_meta" cls sig => cls -> sig
set_meta = runMethod @"set_meta"

set_meta_underline ::
                     Method "set_meta_underline" cls sig => cls -> sig
set_meta_underline = runMethod @"set_meta_underline"

set_metadata :: Method "set_metadata" cls sig => cls -> sig
set_metadata = runMethod @"set_metadata"

set_metakey :: Method "set_metakey" cls sig => cls -> sig
set_metakey = runMethod @"set_metakey"

set_metallic :: Method "set_metallic" cls sig => cls -> sig
set_metallic = runMethod @"set_metallic"

set_metallic_texture_channel ::
                               Method "set_metallic_texture_channel" cls sig => cls -> sig
set_metallic_texture_channel
  = runMethod @"set_metallic_texture_channel"

set_mid_height :: Method "set_mid_height" cls sig => cls -> sig
set_mid_height = runMethod @"set_mid_height"

set_min :: Method "set_min" cls sig => cls -> sig
set_min = runMethod @"set_min"

set_min_distance :: Method "set_min_distance" cls sig => cls -> sig
set_min_distance = runMethod @"set_min_distance"

set_min_space :: Method "set_min_space" cls sig => cls -> sig
set_min_space = runMethod @"set_min_space"

set_min_value :: Method "set_min_value" cls sig => cls -> sig
set_min_value = runMethod @"set_min_value"

set_mirroring :: Method "set_mirroring" cls sig => cls -> sig
set_mirroring = runMethod @"set_mirroring"

set_mix :: Method "set_mix" cls sig => cls -> sig
set_mix = runMethod @"set_mix"

set_mix_mode :: Method "set_mix_mode" cls sig => cls -> sig
set_mix_mode = runMethod @"set_mix_mode"

set_mix_rate :: Method "set_mix_rate" cls sig => cls -> sig
set_mix_rate = runMethod @"set_mix_rate"

set_mix_target :: Method "set_mix_target" cls sig => cls -> sig
set_mix_target = runMethod @"set_mix_target"

set_mode :: Method "set_mode" cls sig => cls -> sig
set_mode = runMethod @"set_mode"

set_mode_overrides_title ::
                           Method "set_mode_overrides_title" cls sig => cls -> sig
set_mode_overrides_title = runMethod @"set_mode_overrides_title"

set_modulate :: Method "set_modulate" cls sig => cls -> sig
set_modulate = runMethod @"set_modulate"

set_monitorable :: Method "set_monitorable" cls sig => cls -> sig
set_monitorable = runMethod @"set_monitorable"

set_monitoring :: Method "set_monitoring" cls sig => cls -> sig
set_monitoring = runMethod @"set_monitoring"

set_motion :: Method "set_motion" cls sig => cls -> sig
set_motion = runMethod @"set_motion"

set_motion_offset ::
                    Method "set_motion_offset" cls sig => cls -> sig
set_motion_offset = runMethod @"set_motion_offset"

set_motion_scale :: Method "set_motion_scale" cls sig => cls -> sig
set_motion_scale = runMethod @"set_motion_scale"

set_mouse_filter :: Method "set_mouse_filter" cls sig => cls -> sig
set_mouse_filter = runMethod @"set_mouse_filter"

set_mouse_mode :: Method "set_mouse_mode" cls sig => cls -> sig
set_mouse_mode = runMethod @"set_mouse_mode"

set_msaa :: Method "set_msaa" cls sig => cls -> sig
set_msaa = runMethod @"set_msaa"

set_multimesh :: Method "set_multimesh" cls sig => cls -> sig
set_multimesh = runMethod @"set_multimesh"

set_multiplayer :: Method "set_multiplayer" cls sig => cls -> sig
set_multiplayer = runMethod @"set_multiplayer"

set_multiplayer_poll_enabled ::
                               Method "set_multiplayer_poll_enabled" cls sig => cls -> sig
set_multiplayer_poll_enabled
  = runMethod @"set_multiplayer_poll_enabled"

set_name :: Method "set_name" cls sig => cls -> sig
set_name = runMethod @"set_name"

set_navigation_mesh ::
                      Method "set_navigation_mesh" cls sig => cls -> sig
set_navigation_mesh = runMethod @"set_navigation_mesh"

set_navigation_polygon ::
                         Method "set_navigation_polygon" cls sig => cls -> sig
set_navigation_polygon = runMethod @"set_navigation_polygon"

set_negative :: Method "set_negative" cls sig => cls -> sig
set_negative = runMethod @"set_negative"

set_network_master ::
                     Method "set_network_master" cls sig => cls -> sig
set_network_master = runMethod @"set_network_master"

set_network_peer :: Method "set_network_peer" cls sig => cls -> sig
set_network_peer = runMethod @"set_network_peer"

set_next_pass :: Method "set_next_pass" cls sig => cls -> sig
set_next_pass = runMethod @"set_next_pass"

set_nine_patch_stretch ::
                         Method "set_nine_patch_stretch" cls sig => cls -> sig
set_nine_patch_stretch = runMethod @"set_nine_patch_stretch"

set_no_delay :: Method "set_no_delay" cls sig => cls -> sig
set_no_delay = runMethod @"set_no_delay"

set_node_a :: Method "set_node_a" cls sig => cls -> sig
set_node_a = runMethod @"set_node_a"

set_node_b :: Method "set_node_b" cls sig => cls -> sig
set_node_b = runMethod @"set_node_b"

set_node_path :: Method "set_node_path" cls sig => cls -> sig
set_node_path = runMethod @"set_node_path"

set_node_position ::
                    Method "set_node_position" cls sig => cls -> sig
set_node_position = runMethod @"set_node_position"

set_noise :: Method "set_noise" cls sig => cls -> sig
set_noise = runMethod @"set_noise"

set_normal :: Method "set_normal" cls sig => cls -> sig
set_normal = runMethod @"set_normal"

set_normal_bias :: Method "set_normal_bias" cls sig => cls -> sig
set_normal_bias = runMethod @"set_normal_bias"

set_normal_map :: Method "set_normal_map" cls sig => cls -> sig
set_normal_map = runMethod @"set_normal_map"

set_normal_scale :: Method "set_normal_scale" cls sig => cls -> sig
set_normal_scale = runMethod @"set_normal_scale"

set_normal_texture ::
                     Method "set_normal_texture" cls sig => cls -> sig
set_normal_texture = runMethod @"set_normal_texture"

set_normalmap :: Method "set_normalmap" cls sig => cls -> sig
set_normalmap = runMethod @"set_normalmap"

set_notify_local_transform ::
                             Method "set_notify_local_transform" cls sig => cls -> sig
set_notify_local_transform
  = runMethod @"set_notify_local_transform"

set_notify_transform ::
                       Method "set_notify_transform" cls sig => cls -> sig
set_notify_transform = runMethod @"set_notify_transform"

set_object_id :: Method "set_object_id" cls sig => cls -> sig
set_object_id = runMethod @"set_object_id"

set_occluder_light_mask ::
                          Method "set_occluder_light_mask" cls sig => cls -> sig
set_occluder_light_mask = runMethod @"set_occluder_light_mask"

set_occluder_polygon ::
                       Method "set_occluder_polygon" cls sig => cls -> sig
set_occluder_polygon = runMethod @"set_occluder_polygon"

set_octant_size :: Method "set_octant_size" cls sig => cls -> sig
set_octant_size = runMethod @"set_octant_size"

set_octaves :: Method "set_octaves" cls sig => cls -> sig
set_octaves = runMethod @"set_octaves"

set_octree :: Method "set_octree" cls sig => cls -> sig
set_octree = runMethod @"set_octree"

set_offset :: Method "set_offset" cls sig => cls -> sig
set_offset = runMethod @"set_offset"

set_offsets :: Method "set_offsets" cls sig => cls -> sig
set_offsets = runMethod @"set_offsets"

set_one_shot :: Method "set_one_shot" cls sig => cls -> sig
set_one_shot = runMethod @"set_one_shot"

set_one_way_collision ::
                        Method "set_one_way_collision" cls sig => cls -> sig
set_one_way_collision = runMethod @"set_one_way_collision"

set_opacity :: Method "set_opacity" cls sig => cls -> sig
set_opacity = runMethod @"set_opacity"

set_operation :: Method "set_operation" cls sig => cls -> sig
set_operation = runMethod @"set_operation"

set_operator :: Method "set_operator" cls sig => cls -> sig
set_operator = runMethod @"set_operator"

set_order :: Method "set_order" cls sig => cls -> sig
set_order = runMethod @"set_order"

set_origin_offset ::
                    Method "set_origin_offset" cls sig => cls -> sig
set_origin_offset = runMethod @"set_origin_offset"

set_orthogonal :: Method "set_orthogonal" cls sig => cls -> sig
set_orthogonal = runMethod @"set_orthogonal"

set_out_of_range_mode ::
                        Method "set_out_of_range_mode" cls sig => cls -> sig
set_out_of_range_mode = runMethod @"set_out_of_range_mode"

set_outer_radius :: Method "set_outer_radius" cls sig => cls -> sig
set_outer_radius = runMethod @"set_outer_radius"

set_outline :: Method "set_outline" cls sig => cls -> sig
set_outline = runMethod @"set_outline"

set_outline_color ::
                    Method "set_outline_color" cls sig => cls -> sig
set_outline_color = runMethod @"set_outline_color"

set_outline_size :: Method "set_outline_size" cls sig => cls -> sig
set_outline_size = runMethod @"set_outline_size"

set_output_buffer_max_size ::
                             Method "set_output_buffer_max_size" cls sig => cls -> sig
set_output_buffer_max_size
  = runMethod @"set_output_buffer_max_size"

set_output_port_for_preview ::
                              Method "set_output_port_for_preview" cls sig => cls -> sig
set_output_port_for_preview
  = runMethod @"set_output_port_for_preview"

set_over_texture :: Method "set_over_texture" cls sig => cls -> sig
set_over_texture = runMethod @"set_over_texture"

set_overlay :: Method "set_overlay" cls sig => cls -> sig
set_overlay = runMethod @"set_overlay"

set_override_selected_font_color ::
                                   Method "set_override_selected_font_color" cls sig => cls -> sig
set_override_selected_font_color
  = runMethod @"set_override_selected_font_color"

set_oversample :: Method "set_oversample" cls sig => cls -> sig
set_oversample = runMethod @"set_oversample"

set_owner :: Method "set_owner" cls sig => cls -> sig
set_owner = runMethod @"set_owner"

set_page :: Method "set_page" cls sig => cls -> sig
set_page = runMethod @"set_page"

set_pan :: Method "set_pan" cls sig => cls -> sig
set_pan = runMethod @"set_pan"

set_pan_pullout :: Method "set_pan_pullout" cls sig => cls -> sig
set_pan_pullout = runMethod @"set_pan_pullout"

set_panorama :: Method "set_panorama" cls sig => cls -> sig
set_panorama = runMethod @"set_panorama"

set_param :: Method "set_param" cls sig => cls -> sig
set_param = runMethod @"set_param"

set_param_curve :: Method "set_param_curve" cls sig => cls -> sig
set_param_curve = runMethod @"set_param_curve"

set_param_randomness ::
                       Method "set_param_randomness" cls sig => cls -> sig
set_param_randomness = runMethod @"set_param_randomness"

set_param_texture ::
                    Method "set_param_texture" cls sig => cls -> sig
set_param_texture = runMethod @"set_param_texture"

set_param_x :: Method "set_param_x" cls sig => cls -> sig
set_param_x = runMethod @"set_param_x"

set_param_y :: Method "set_param_y" cls sig => cls -> sig
set_param_y = runMethod @"set_param_y"

set_param_z :: Method "set_param_z" cls sig => cls -> sig
set_param_z = runMethod @"set_param_z"

set_parameter :: Method "set_parameter" cls sig => cls -> sig
set_parameter = runMethod @"set_parameter"

set_parent_collision_ignore ::
                              Method "set_parent_collision_ignore" cls sig => cls -> sig
set_parent_collision_ignore
  = runMethod @"set_parent_collision_ignore"

set_particle_flag ::
                    Method "set_particle_flag" cls sig => cls -> sig
set_particle_flag = runMethod @"set_particle_flag"

set_particles_anim_h_frames ::
                              Method "set_particles_anim_h_frames" cls sig => cls -> sig
set_particles_anim_h_frames
  = runMethod @"set_particles_anim_h_frames"

set_particles_anim_loop ::
                          Method "set_particles_anim_loop" cls sig => cls -> sig
set_particles_anim_loop = runMethod @"set_particles_anim_loop"

set_particles_anim_v_frames ::
                              Method "set_particles_anim_v_frames" cls sig => cls -> sig
set_particles_anim_v_frames
  = runMethod @"set_particles_anim_v_frames"

set_passby_press :: Method "set_passby_press" cls sig => cls -> sig
set_passby_press = runMethod @"set_passby_press"

set_patch_margin :: Method "set_patch_margin" cls sig => cls -> sig
set_patch_margin = runMethod @"set_patch_margin"

set_path :: Method "set_path" cls sig => cls -> sig
set_path = runMethod @"set_path"

set_path_continuous_u ::
                        Method "set_path_continuous_u" cls sig => cls -> sig
set_path_continuous_u = runMethod @"set_path_continuous_u"

set_path_interval ::
                    Method "set_path_interval" cls sig => cls -> sig
set_path_interval = runMethod @"set_path_interval"

set_path_joined :: Method "set_path_joined" cls sig => cls -> sig
set_path_joined = runMethod @"set_path_joined"

set_path_local :: Method "set_path_local" cls sig => cls -> sig
set_path_local = runMethod @"set_path_local"

set_path_node :: Method "set_path_node" cls sig => cls -> sig
set_path_node = runMethod @"set_path_node"

set_path_rotation ::
                    Method "set_path_rotation" cls sig => cls -> sig
set_path_rotation = runMethod @"set_path_rotation"

set_pause :: Method "set_pause" cls sig => cls -> sig
set_pause = runMethod @"set_pause"

set_pause_mode :: Method "set_pause_mode" cls sig => cls -> sig
set_pause_mode = runMethod @"set_pause_mode"

set_paused :: Method "set_paused" cls sig => cls -> sig
set_paused = runMethod @"set_paused"

set_percent_visible ::
                      Method "set_percent_visible" cls sig => cls -> sig
set_percent_visible = runMethod @"set_percent_visible"

set_period :: Method "set_period" cls sig => cls -> sig
set_period = runMethod @"set_period"

set_persistence :: Method "set_persistence" cls sig => cls -> sig
set_persistence = runMethod @"set_persistence"

set_perspective :: Method "set_perspective" cls sig => cls -> sig
set_perspective = runMethod @"set_perspective"

set_physics_jitter_fix ::
                         Method "set_physics_jitter_fix" cls sig => cls -> sig
set_physics_jitter_fix = runMethod @"set_physics_jitter_fix"

set_physics_material_override ::
                                Method "set_physics_material_override" cls sig => cls -> sig
set_physics_material_override
  = runMethod @"set_physics_material_override"

set_physics_object_picking ::
                             Method "set_physics_object_picking" cls sig => cls -> sig
set_physics_object_picking
  = runMethod @"set_physics_object_picking"

set_physics_process ::
                      Method "set_physics_process" cls sig => cls -> sig
set_physics_process = runMethod @"set_physics_process"

set_physics_process_internal ::
                               Method "set_physics_process_internal" cls sig => cls -> sig
set_physics_process_internal
  = runMethod @"set_physics_process_internal"

set_pick_color :: Method "set_pick_color" cls sig => cls -> sig
set_pick_color = runMethod @"set_pick_color"

set_pickable :: Method "set_pickable" cls sig => cls -> sig
set_pickable = runMethod @"set_pickable"

set_piece_offset :: Method "set_piece_offset" cls sig => cls -> sig
set_piece_offset = runMethod @"set_piece_offset"

set_piece_texture ::
                    Method "set_piece_texture" cls sig => cls -> sig
set_piece_texture = runMethod @"set_piece_texture"

set_pitch_scale :: Method "set_pitch_scale" cls sig => cls -> sig
set_pitch_scale = runMethod @"set_pitch_scale"

set_pivot_offset :: Method "set_pivot_offset" cls sig => cls -> sig
set_pivot_offset = runMethod @"set_pivot_offset"

set_pixel :: Method "set_pixel" cls sig => cls -> sig
set_pixel = runMethod @"set_pixel"

set_pixel_size :: Method "set_pixel_size" cls sig => cls -> sig
set_pixel_size = runMethod @"set_pixel_size"

set_pixelv :: Method "set_pixelv" cls sig => cls -> sig
set_pixelv = runMethod @"set_pixelv"

set_placeholder :: Method "set_placeholder" cls sig => cls -> sig
set_placeholder = runMethod @"set_placeholder"

set_placeholder_alpha ::
                        Method "set_placeholder_alpha" cls sig => cls -> sig
set_placeholder_alpha = runMethod @"set_placeholder_alpha"

set_plane :: Method "set_plane" cls sig => cls -> sig
set_plane = runMethod @"set_plane"

set_plugin_enabled ::
                     Method "set_plugin_enabled" cls sig => cls -> sig
set_plugin_enabled = runMethod @"set_plugin_enabled"

set_point_cloud :: Method "set_point_cloud" cls sig => cls -> sig
set_point_cloud = runMethod @"set_point_cloud"

set_point_in :: Method "set_point_in" cls sig => cls -> sig
set_point_in = runMethod @"set_point_in"

set_point_left_mode ::
                      Method "set_point_left_mode" cls sig => cls -> sig
set_point_left_mode = runMethod @"set_point_left_mode"

set_point_left_tangent ::
                         Method "set_point_left_tangent" cls sig => cls -> sig
set_point_left_tangent = runMethod @"set_point_left_tangent"

set_point_offset :: Method "set_point_offset" cls sig => cls -> sig
set_point_offset = runMethod @"set_point_offset"

set_point_out :: Method "set_point_out" cls sig => cls -> sig
set_point_out = runMethod @"set_point_out"

set_point_penalty ::
                    Method "set_point_penalty" cls sig => cls -> sig
set_point_penalty = runMethod @"set_point_penalty"

set_point_position ::
                     Method "set_point_position" cls sig => cls -> sig
set_point_position = runMethod @"set_point_position"

set_point_right_mode ::
                       Method "set_point_right_mode" cls sig => cls -> sig
set_point_right_mode = runMethod @"set_point_right_mode"

set_point_right_tangent ::
                          Method "set_point_right_tangent" cls sig => cls -> sig
set_point_right_tangent = runMethod @"set_point_right_tangent"

set_point_size :: Method "set_point_size" cls sig => cls -> sig
set_point_size = runMethod @"set_point_size"

set_point_tilt :: Method "set_point_tilt" cls sig => cls -> sig
set_point_tilt = runMethod @"set_point_tilt"

set_point_value :: Method "set_point_value" cls sig => cls -> sig
set_point_value = runMethod @"set_point_value"

set_point_weight_scale ::
                         Method "set_point_weight_scale" cls sig => cls -> sig
set_point_weight_scale = runMethod @"set_point_weight_scale"

set_points :: Method "set_points" cls sig => cls -> sig
set_points = runMethod @"set_points"

set_polygon :: Method "set_polygon" cls sig => cls -> sig
set_polygon = runMethod @"set_polygon"

set_popup :: Method "set_popup" cls sig => cls -> sig
set_popup = runMethod @"set_popup"

set_pose_matching_coefficient ::
                                Method "set_pose_matching_coefficient" cls sig => cls -> sig
set_pose_matching_coefficient
  = runMethod @"set_pose_matching_coefficient"

set_position :: Method "set_position" cls sig => cls -> sig
set_position = runMethod @"set_position"

set_post_gain :: Method "set_post_gain" cls sig => cls -> sig
set_post_gain = runMethod @"set_post_gain"

set_pre_gain :: Method "set_pre_gain" cls sig => cls -> sig
set_pre_gain = runMethod @"set_pre_gain"

set_pre_process_time ::
                       Method "set_pre_process_time" cls sig => cls -> sig
set_pre_process_time = runMethod @"set_pre_process_time"

set_predelay_feedback ::
                        Method "set_predelay_feedback" cls sig => cls -> sig
set_predelay_feedback = runMethod @"set_predelay_feedback"

set_predelay_msec ::
                    Method "set_predelay_msec" cls sig => cls -> sig
set_predelay_msec = runMethod @"set_predelay_msec"

set_prefix :: Method "set_prefix" cls sig => cls -> sig
set_prefix = runMethod @"set_prefix"

set_preload :: Method "set_preload" cls sig => cls -> sig
set_preload = runMethod @"set_preload"

set_pressed :: Method "set_pressed" cls sig => cls -> sig
set_pressed = runMethod @"set_pressed"

set_pressed_texture ::
                      Method "set_pressed_texture" cls sig => cls -> sig
set_pressed_texture = runMethod @"set_pressed_texture"

set_pressure :: Method "set_pressure" cls sig => cls -> sig
set_pressure = runMethod @"set_pressure"

set_pressure_coefficient ::
                           Method "set_pressure_coefficient" cls sig => cls -> sig
set_pressure_coefficient = runMethod @"set_pressure_coefficient"

set_primary_interface ::
                        Method "set_primary_interface" cls sig => cls -> sig
set_primary_interface = runMethod @"set_primary_interface"

set_priority :: Method "set_priority" cls sig => cls -> sig
set_priority = runMethod @"set_priority"

set_probe_data :: Method "set_probe_data" cls sig => cls -> sig
set_probe_data = runMethod @"set_probe_data"

set_process :: Method "set_process" cls sig => cls -> sig
set_process = runMethod @"set_process"

set_process_input ::
                    Method "set_process_input" cls sig => cls -> sig
set_process_input = runMethod @"set_process_input"

set_process_internal ::
                       Method "set_process_internal" cls sig => cls -> sig
set_process_internal = runMethod @"set_process_internal"

set_process_material ::
                       Method "set_process_material" cls sig => cls -> sig
set_process_material = runMethod @"set_process_material"

set_process_mode :: Method "set_process_mode" cls sig => cls -> sig
set_process_mode = runMethod @"set_process_mode"

set_process_priority ::
                       Method "set_process_priority" cls sig => cls -> sig
set_process_priority = runMethod @"set_process_priority"

set_process_unhandled_input ::
                              Method "set_process_unhandled_input" cls sig => cls -> sig
set_process_unhandled_input
  = runMethod @"set_process_unhandled_input"

set_process_unhandled_key_input ::
                                  Method "set_process_unhandled_key_input" cls sig => cls -> sig
set_process_unhandled_key_input
  = runMethod @"set_process_unhandled_key_input"

set_progress_texture ::
                       Method "set_progress_texture" cls sig => cls -> sig
set_progress_texture = runMethod @"set_progress_texture"

set_project_metadata ::
                       Method "set_project_metadata" cls sig => cls -> sig
set_project_metadata = runMethod @"set_project_metadata"

set_projection :: Method "set_projection" cls sig => cls -> sig
set_projection = runMethod @"set_projection"

set_propagation :: Method "set_propagation" cls sig => cls -> sig
set_propagation = runMethod @"set_propagation"

set_property :: Method "set_property" cls sig => cls -> sig
set_property = runMethod @"set_property"

set_proximity_fade ::
                     Method "set_proximity_fade" cls sig => cls -> sig
set_proximity_fade = runMethod @"set_proximity_fade"

set_proximity_fade_distance ::
                              Method "set_proximity_fade_distance" cls sig => cls -> sig
set_proximity_fade_distance
  = runMethod @"set_proximity_fade_distance"

set_quadrant_size ::
                    Method "set_quadrant_size" cls sig => cls -> sig
set_quadrant_size = runMethod @"set_quadrant_size"

set_quit_on_go_back ::
                      Method "set_quit_on_go_back" cls sig => cls -> sig
set_quit_on_go_back = runMethod @"set_quit_on_go_back"

set_radial_center_offset ::
                           Method "set_radial_center_offset" cls sig => cls -> sig
set_radial_center_offset = runMethod @"set_radial_center_offset"

set_radial_initial_angle ::
                           Method "set_radial_initial_angle" cls sig => cls -> sig
set_radial_initial_angle = runMethod @"set_radial_initial_angle"

set_radial_segments ::
                      Method "set_radial_segments" cls sig => cls -> sig
set_radial_segments = runMethod @"set_radial_segments"

set_radiance_size ::
                    Method "set_radiance_size" cls sig => cls -> sig
set_radiance_size = runMethod @"set_radiance_size"

set_radius :: Method "set_radius" cls sig => cls -> sig
set_radius = runMethod @"set_radius"

set_random_pitch :: Method "set_random_pitch" cls sig => cls -> sig
set_random_pitch = runMethod @"set_random_pitch"

set_randomness_ratio ::
                       Method "set_randomness_ratio" cls sig => cls -> sig
set_randomness_ratio = runMethod @"set_randomness_ratio"

set_range :: Method "set_range" cls sig => cls -> sig
set_range = runMethod @"set_range"

set_range_config :: Method "set_range_config" cls sig => cls -> sig
set_range_config = runMethod @"set_range_config"

set_range_max_hz :: Method "set_range_max_hz" cls sig => cls -> sig
set_range_max_hz = runMethod @"set_range_max_hz"

set_range_min_hz :: Method "set_range_min_hz" cls sig => cls -> sig
set_range_min_hz = runMethod @"set_range_min_hz"

set_rate_hz :: Method "set_rate_hz" cls sig => cls -> sig
set_rate_hz = runMethod @"set_rate_hz"

set_ratio :: Method "set_ratio" cls sig => cls -> sig
set_ratio = runMethod @"set_ratio"

set_raw_mode :: Method "set_raw_mode" cls sig => cls -> sig
set_raw_mode = runMethod @"set_raw_mode"

set_ray_pickable :: Method "set_ray_pickable" cls sig => cls -> sig
set_ray_pickable = runMethod @"set_ray_pickable"

set_read_chunk_size ::
                      Method "set_read_chunk_size" cls sig => cls -> sig
set_read_chunk_size = runMethod @"set_read_chunk_size"

set_read_only :: Method "set_read_only" cls sig => cls -> sig
set_read_only = runMethod @"set_read_only"

set_readonly :: Method "set_readonly" cls sig => cls -> sig
set_readonly = runMethod @"set_readonly"

set_recent_dirs :: Method "set_recent_dirs" cls sig => cls -> sig
set_recent_dirs = runMethod @"set_recent_dirs"

set_recording_active ::
                       Method "set_recording_active" cls sig => cls -> sig
set_recording_active = runMethod @"set_recording_active"

set_rect :: Method "set_rect" cls sig => cls -> sig
set_rect = runMethod @"set_rect"

set_refraction :: Method "set_refraction" cls sig => cls -> sig
set_refraction = runMethod @"set_refraction"

set_refraction_texture_channel ::
                                 Method "set_refraction_texture_channel" cls sig => cls -> sig
set_refraction_texture_channel
  = runMethod @"set_refraction_texture_channel"

set_refuse_new_connections ::
                             Method "set_refuse_new_connections" cls sig => cls -> sig
set_refuse_new_connections
  = runMethod @"set_refuse_new_connections"

set_refuse_new_network_connections ::
                                     Method "set_refuse_new_network_connections" cls sig =>
                                     cls -> sig
set_refuse_new_network_connections
  = runMethod @"set_refuse_new_network_connections"

set_region :: Method "set_region" cls sig => cls -> sig
set_region = runMethod @"set_region"

set_region_filter_clip ::
                         Method "set_region_filter_clip" cls sig => cls -> sig
set_region_filter_clip = runMethod @"set_region_filter_clip"

set_region_merge_size ::
                        Method "set_region_merge_size" cls sig => cls -> sig
set_region_merge_size = runMethod @"set_region_merge_size"

set_region_min_size ::
                      Method "set_region_min_size" cls sig => cls -> sig
set_region_min_size = runMethod @"set_region_min_size"

set_region_rect :: Method "set_region_rect" cls sig => cls -> sig
set_region_rect = runMethod @"set_region_rect"

set_relative :: Method "set_relative" cls sig => cls -> sig
set_relative = runMethod @"set_relative"

set_release_ms :: Method "set_release_ms" cls sig => cls -> sig
set_release_ms = runMethod @"set_release_ms"

set_reloadable :: Method "set_reloadable" cls sig => cls -> sig
set_reloadable = runMethod @"set_reloadable"

set_remote_node :: Method "set_remote_node" cls sig => cls -> sig
set_remote_node = runMethod @"set_remote_node"

set_render_priority ::
                      Method "set_render_priority" cls sig => cls -> sig
set_render_priority = runMethod @"set_render_priority"

set_repeat :: Method "set_repeat" cls sig => cls -> sig
set_repeat = runMethod @"set_repeat"

set_resizable :: Method "set_resizable" cls sig => cls -> sig
set_resizable = runMethod @"set_resizable"

set_resonance :: Method "set_resonance" cls sig => cls -> sig
set_resonance = runMethod @"set_resonance"

set_resource_path ::
                    Method "set_resource_path" cls sig => cls -> sig
set_resource_path = runMethod @"set_resource_path"

set_rest :: Method "set_rest" cls sig => cls -> sig
set_rest = runMethod @"set_rest"

set_rest_length :: Method "set_rest_length" cls sig => cls -> sig
set_rest_length = runMethod @"set_rest_length"

set_result :: Method "set_result" cls sig => cls -> sig
set_result = runMethod @"set_result"

set_return_type :: Method "set_return_type" cls sig => cls -> sig
set_return_type = runMethod @"set_return_type"

set_reverb_amount ::
                    Method "set_reverb_amount" cls sig => cls -> sig
set_reverb_amount = runMethod @"set_reverb_amount"

set_reverb_bus :: Method "set_reverb_bus" cls sig => cls -> sig
set_reverb_bus = runMethod @"set_reverb_bus"

set_reverb_uniformity ::
                        Method "set_reverb_uniformity" cls sig => cls -> sig
set_reverb_uniformity = runMethod @"set_reverb_uniformity"

set_right_click_moves_caret ::
                              Method "set_right_click_moves_caret" cls sig => cls -> sig
set_right_click_moves_caret
  = runMethod @"set_right_click_moves_caret"

set_right_disconnects ::
                        Method "set_right_disconnects" cls sig => cls -> sig
set_right_disconnects = runMethod @"set_right_disconnects"

set_rim :: Method "set_rim" cls sig => cls -> sig
set_rim = runMethod @"set_rim"

set_rim_tint :: Method "set_rim_tint" cls sig => cls -> sig
set_rim_tint = runMethod @"set_rim_tint"

set_ring_sides :: Method "set_ring_sides" cls sig => cls -> sig
set_ring_sides = runMethod @"set_ring_sides"

set_rings :: Method "set_rings" cls sig => cls -> sig
set_rings = runMethod @"set_rings"

set_roll_influence ::
                     Method "set_roll_influence" cls sig => cls -> sig
set_roll_influence = runMethod @"set_roll_influence"

set_room_size :: Method "set_room_size" cls sig => cls -> sig
set_room_size = runMethod @"set_room_size"

set_root :: Method "set_root" cls sig => cls -> sig
set_root = runMethod @"set_root"

set_root_bone :: Method "set_root_bone" cls sig => cls -> sig
set_root_bone = runMethod @"set_root_bone"

set_root_motion_track ::
                        Method "set_root_motion_track" cls sig => cls -> sig
set_root_motion_track = runMethod @"set_root_motion_track"

set_root_node :: Method "set_root_node" cls sig => cls -> sig
set_root_node = runMethod @"set_root_node"

set_rotate :: Method "set_rotate" cls sig => cls -> sig
set_rotate = runMethod @"set_rotate"

set_rotating :: Method "set_rotating" cls sig => cls -> sig
set_rotating = runMethod @"set_rotating"

set_rotation :: Method "set_rotation" cls sig => cls -> sig
set_rotation = runMethod @"set_rotation"

set_rotation_degrees ::
                       Method "set_rotation_degrees" cls sig => cls -> sig
set_rotation_degrees = runMethod @"set_rotation_degrees"

set_rotation_mode ::
                    Method "set_rotation_mode" cls sig => cls -> sig
set_rotation_mode = runMethod @"set_rotation_mode"

set_rough :: Method "set_rough" cls sig => cls -> sig
set_rough = runMethod @"set_rough"

set_roughness :: Method "set_roughness" cls sig => cls -> sig
set_roughness = runMethod @"set_roughness"

set_roughness_texture_channel ::
                                Method "set_roughness_texture_channel" cls sig => cls -> sig
set_roughness_texture_channel
  = runMethod @"set_roughness_texture_channel"

set_round_precision ::
                      Method "set_round_precision" cls sig => cls -> sig
set_round_precision = runMethod @"set_round_precision"

set_rpc_call_mode ::
                    Method "set_rpc_call_mode" cls sig => cls -> sig
set_rpc_call_mode = runMethod @"set_rpc_call_mode"

set_rumble :: Method "set_rumble" cls sig => cls -> sig
set_rumble = runMethod @"set_rumble"

set_safe_margin :: Method "set_safe_margin" cls sig => cls -> sig
set_safe_margin = runMethod @"set_safe_margin"

set_same_column_width ::
                        Method "set_same_column_width" cls sig => cls -> sig
set_same_column_width = runMethod @"set_same_column_width"

set_sample_partition_type ::
                            Method "set_sample_partition_type" cls sig => cls -> sig
set_sample_partition_type = runMethod @"set_sample_partition_type"

set_scale :: Method "set_scale" cls sig => cls -> sig
set_scale = runMethod @"set_scale"

set_scancode :: Method "set_scancode" cls sig => cls -> sig
set_scancode = runMethod @"set_scancode"

set_scene_instance_load_placeholder ::
                                      Method "set_scene_instance_load_placeholder" cls sig =>
                                      cls -> sig
set_scene_instance_load_placeholder
  = runMethod @"set_scene_instance_load_placeholder"

set_screen_drawing_enabled ::
                             Method "set_screen_drawing_enabled" cls sig => cls -> sig
set_screen_drawing_enabled
  = runMethod @"set_screen_drawing_enabled"

set_screen_orientation ::
                         Method "set_screen_orientation" cls sig => cls -> sig
set_screen_orientation = runMethod @"set_screen_orientation"

set_screen_stretch ::
                     Method "set_screen_stretch" cls sig => cls -> sig
set_screen_stretch = runMethod @"set_screen_stretch"

set_script :: Method "set_script" cls sig => cls -> sig
set_script = runMethod @"set_script"

set_script_class_icon_path ::
                             Method "set_script_class_icon_path" cls sig => cls -> sig
set_script_class_icon_path
  = runMethod @"set_script_class_icon_path"

set_script_class_name ::
                        Method "set_script_class_name" cls sig => cls -> sig
set_script_class_name = runMethod @"set_script_class_name"

set_scroll_active ::
                    Method "set_scroll_active" cls sig => cls -> sig
set_scroll_active = runMethod @"set_scroll_active"

set_scroll_base_offset ::
                         Method "set_scroll_base_offset" cls sig => cls -> sig
set_scroll_base_offset = runMethod @"set_scroll_base_offset"

set_scroll_base_scale ::
                        Method "set_scroll_base_scale" cls sig => cls -> sig
set_scroll_base_scale = runMethod @"set_scroll_base_scale"

set_scroll_follow ::
                    Method "set_scroll_follow" cls sig => cls -> sig
set_scroll_follow = runMethod @"set_scroll_follow"

set_scroll_offset ::
                    Method "set_scroll_offset" cls sig => cls -> sig
set_scroll_offset = runMethod @"set_scroll_offset"

set_scroll_ofs :: Method "set_scroll_ofs" cls sig => cls -> sig
set_scroll_ofs = runMethod @"set_scroll_ofs"

set_scrollable :: Method "set_scrollable" cls sig => cls -> sig
set_scrollable = runMethod @"set_scrollable"

set_scrolling_enabled ::
                        Method "set_scrolling_enabled" cls sig => cls -> sig
set_scrolling_enabled = runMethod @"set_scrolling_enabled"

set_seamless :: Method "set_seamless" cls sig => cls -> sig
set_seamless = runMethod @"set_seamless"

set_secret :: Method "set_secret" cls sig => cls -> sig
set_secret = runMethod @"set_secret"

set_secret_character ::
                       Method "set_secret_character" cls sig => cls -> sig
set_secret_character = runMethod @"set_secret_character"

set_seed :: Method "set_seed" cls sig => cls -> sig
set_seed = runMethod @"set_seed"

set_segments :: Method "set_segments" cls sig => cls -> sig
set_segments = runMethod @"set_segments"

set_select_mode :: Method "set_select_mode" cls sig => cls -> sig
set_select_mode = runMethod @"set_select_mode"

set_select_with_rmb ::
                      Method "set_select_with_rmb" cls sig => cls -> sig
set_select_with_rmb = runMethod @"set_select_with_rmb"

set_selectable :: Method "set_selectable" cls sig => cls -> sig
set_selectable = runMethod @"set_selectable"

set_selected :: Method "set_selected" cls sig => cls -> sig
set_selected = runMethod @"set_selected"

set_selection_enabled ::
                        Method "set_selection_enabled" cls sig => cls -> sig
set_selection_enabled = runMethod @"set_selection_enabled"

set_self_modulate ::
                    Method "set_self_modulate" cls sig => cls -> sig
set_self_modulate = runMethod @"set_self_modulate"

set_service_type :: Method "set_service_type" cls sig => cls -> sig
set_service_type = runMethod @"set_service_type"

set_setting :: Method "set_setting" cls sig => cls -> sig
set_setting = runMethod @"set_setting"

set_shader :: Method "set_shader" cls sig => cls -> sig
set_shader = runMethod @"set_shader"

set_shader_param :: Method "set_shader_param" cls sig => cls -> sig
set_shader_param = runMethod @"set_shader_param"

set_shadow :: Method "set_shadow" cls sig => cls -> sig
set_shadow = runMethod @"set_shadow"

set_shadow_atlas_quadrant_subdiv ::
                                   Method "set_shadow_atlas_quadrant_subdiv" cls sig => cls -> sig
set_shadow_atlas_quadrant_subdiv
  = runMethod @"set_shadow_atlas_quadrant_subdiv"

set_shadow_atlas_size ::
                        Method "set_shadow_atlas_size" cls sig => cls -> sig
set_shadow_atlas_size = runMethod @"set_shadow_atlas_size"

set_shadow_buffer_size ::
                         Method "set_shadow_buffer_size" cls sig => cls -> sig
set_shadow_buffer_size = runMethod @"set_shadow_buffer_size"

set_shadow_color :: Method "set_shadow_color" cls sig => cls -> sig
set_shadow_color = runMethod @"set_shadow_color"

set_shadow_depth_range ::
                         Method "set_shadow_depth_range" cls sig => cls -> sig
set_shadow_depth_range = runMethod @"set_shadow_depth_range"

set_shadow_detail ::
                    Method "set_shadow_detail" cls sig => cls -> sig
set_shadow_detail = runMethod @"set_shadow_detail"

set_shadow_enabled ::
                     Method "set_shadow_enabled" cls sig => cls -> sig
set_shadow_enabled = runMethod @"set_shadow_enabled"

set_shadow_filter ::
                    Method "set_shadow_filter" cls sig => cls -> sig
set_shadow_filter = runMethod @"set_shadow_filter"

set_shadow_gradient_length ::
                             Method "set_shadow_gradient_length" cls sig => cls -> sig
set_shadow_gradient_length
  = runMethod @"set_shadow_gradient_length"

set_shadow_mode :: Method "set_shadow_mode" cls sig => cls -> sig
set_shadow_mode = runMethod @"set_shadow_mode"

set_shadow_reverse_cull_face ::
                               Method "set_shadow_reverse_cull_face" cls sig => cls -> sig
set_shadow_reverse_cull_face
  = runMethod @"set_shadow_reverse_cull_face"

set_shadow_size :: Method "set_shadow_size" cls sig => cls -> sig
set_shadow_size = runMethod @"set_shadow_size"

set_shadow_smooth ::
                    Method "set_shadow_smooth" cls sig => cls -> sig
set_shadow_smooth = runMethod @"set_shadow_smooth"

set_shape :: Method "set_shape" cls sig => cls -> sig
set_shape = runMethod @"set_shape"

set_shape_centered ::
                     Method "set_shape_centered" cls sig => cls -> sig
set_shape_centered = runMethod @"set_shape_centered"

set_shape_rid :: Method "set_shape_rid" cls sig => cls -> sig
set_shape_rid = runMethod @"set_shape_rid"

set_shape_visible ::
                    Method "set_shape_visible" cls sig => cls -> sig
set_shape_visible = runMethod @"set_shape_visible"

set_sharp_limit :: Method "set_sharp_limit" cls sig => cls -> sig
set_sharp_limit = runMethod @"set_sharp_limit"

set_shift :: Method "set_shift" cls sig => cls -> sig
set_shift = runMethod @"set_shift"

set_shortcut :: Method "set_shortcut" cls sig => cls -> sig
set_shortcut = runMethod @"set_shortcut"

set_show_close_button ::
                        Method "set_show_close_button" cls sig => cls -> sig
set_show_close_button = runMethod @"set_show_close_button"

set_show_hidden_files ::
                        Method "set_show_hidden_files" cls sig => cls -> sig
set_show_hidden_files = runMethod @"set_show_hidden_files"

set_show_line_numbers ::
                        Method "set_show_line_numbers" cls sig => cls -> sig
set_show_line_numbers = runMethod @"set_show_line_numbers"

set_side :: Method "set_side" cls sig => cls -> sig
set_side = runMethod @"set_side"

set_sidechain :: Method "set_sidechain" cls sig => cls -> sig
set_sidechain = runMethod @"set_sidechain"

set_sides :: Method "set_sides" cls sig => cls -> sig
set_sides = runMethod @"set_sides"

set_signal :: Method "set_signal" cls sig => cls -> sig
set_signal = runMethod @"set_signal"

set_simulation_precision ::
                           Method "set_simulation_precision" cls sig => cls -> sig
set_simulation_precision = runMethod @"set_simulation_precision"

set_singleton :: Method "set_singleton" cls sig => cls -> sig
set_singleton = runMethod @"set_singleton"

set_size :: Method "set_size" cls sig => cls -> sig
set_size = runMethod @"set_size"

set_size_override ::
                    Method "set_size_override" cls sig => cls -> sig
set_size_override = runMethod @"set_size_override"

set_size_override_stretch ::
                            Method "set_size_override_stretch" cls sig => cls -> sig
set_size_override_stretch = runMethod @"set_size_override_stretch"

set_skeleton :: Method "set_skeleton" cls sig => cls -> sig
set_skeleton = runMethod @"set_skeleton"

set_skeleton_path ::
                    Method "set_skeleton_path" cls sig => cls -> sig
set_skeleton_path = runMethod @"set_skeleton_path"

set_sky :: Method "set_sky" cls sig => cls -> sig
set_sky = runMethod @"set_sky"

set_sky_curve :: Method "set_sky_curve" cls sig => cls -> sig
set_sky_curve = runMethod @"set_sky_curve"

set_sky_custom_fov ::
                     Method "set_sky_custom_fov" cls sig => cls -> sig
set_sky_custom_fov = runMethod @"set_sky_custom_fov"

set_sky_energy :: Method "set_sky_energy" cls sig => cls -> sig
set_sky_energy = runMethod @"set_sky_energy"

set_sky_horizon_color ::
                        Method "set_sky_horizon_color" cls sig => cls -> sig
set_sky_horizon_color = runMethod @"set_sky_horizon_color"

set_sky_top_color ::
                    Method "set_sky_top_color" cls sig => cls -> sig
set_sky_top_color = runMethod @"set_sky_top_color"

set_sleep_state :: Method "set_sleep_state" cls sig => cls -> sig
set_sleep_state = runMethod @"set_sleep_state"

set_sleeping :: Method "set_sleeping" cls sig => cls -> sig
set_sleeping = runMethod @"set_sleeping"

set_slips_on_slope ::
                     Method "set_slips_on_slope" cls sig => cls -> sig
set_slips_on_slope = runMethod @"set_slips_on_slope"

set_slot :: Method "set_slot" cls sig => cls -> sig
set_slot = runMethod @"set_slot"

set_smooth_faces :: Method "set_smooth_faces" cls sig => cls -> sig
set_smooth_faces = runMethod @"set_smooth_faces"

set_smooth_scroll_enable ::
                           Method "set_smooth_scroll_enable" cls sig => cls -> sig
set_smooth_scroll_enable = runMethod @"set_smooth_scroll_enable"

set_snap :: Method "set_snap" cls sig => cls -> sig
set_snap = runMethod @"set_snap"

set_snap_controls_to_pixels ::
                              Method "set_snap_controls_to_pixels" cls sig => cls -> sig
set_snap_controls_to_pixels
  = runMethod @"set_snap_controls_to_pixels"

set_soft_clip_db :: Method "set_soft_clip_db" cls sig => cls -> sig
set_soft_clip_db = runMethod @"set_soft_clip_db"

set_soft_clip_ratio ::
                      Method "set_soft_clip_ratio" cls sig => cls -> sig
set_soft_clip_ratio = runMethod @"set_soft_clip_ratio"

set_softness :: Method "set_softness" cls sig => cls -> sig
set_softness = runMethod @"set_softness"

set_solver_priority ::
                      Method "set_solver_priority" cls sig => cls -> sig
set_solver_priority = runMethod @"set_solver_priority"

set_sort_enabled :: Method "set_sort_enabled" cls sig => cls -> sig
set_sort_enabled = runMethod @"set_sort_enabled"

set_source :: Method "set_source" cls sig => cls -> sig
set_source = runMethod @"set_source"

set_source_code :: Method "set_source_code" cls sig => cls -> sig
set_source_code = runMethod @"set_source_code"

set_space_override_mode ::
                          Method "set_space_override_mode" cls sig => cls -> sig
set_space_override_mode = runMethod @"set_space_override_mode"

set_spacing :: Method "set_spacing" cls sig => cls -> sig
set_spacing = runMethod @"set_spacing"

set_spatial_node :: Method "set_spatial_node" cls sig => cls -> sig
set_spatial_node = runMethod @"set_spatial_node"

set_specular :: Method "set_specular" cls sig => cls -> sig
set_specular = runMethod @"set_specular"

set_specular_mode ::
                    Method "set_specular_mode" cls sig => cls -> sig
set_specular_mode = runMethod @"set_specular_mode"

set_speed :: Method "set_speed" cls sig => cls -> sig
set_speed = runMethod @"set_speed"

set_speed_scale :: Method "set_speed_scale" cls sig => cls -> sig
set_speed_scale = runMethod @"set_speed_scale"

set_spin_degrees :: Method "set_spin_degrees" cls sig => cls -> sig
set_spin_degrees = runMethod @"set_spin_degrees"

set_spin_sides :: Method "set_spin_sides" cls sig => cls -> sig
set_spin_sides = runMethod @"set_spin_sides"

set_split_offset :: Method "set_split_offset" cls sig => cls -> sig
set_split_offset = runMethod @"set_split_offset"

set_splits :: Method "set_splits" cls sig => cls -> sig
set_splits = runMethod @"set_splits"

set_spread :: Method "set_spread" cls sig => cls -> sig
set_spread = runMethod @"set_spread"

set_sprite_frames ::
                    Method "set_sprite_frames" cls sig => cls -> sig
set_sprite_frames = runMethod @"set_sprite_frames"

set_ssao_ao_channel_affect ::
                             Method "set_ssao_ao_channel_affect" cls sig => cls -> sig
set_ssao_ao_channel_affect
  = runMethod @"set_ssao_ao_channel_affect"

set_ssao_bias :: Method "set_ssao_bias" cls sig => cls -> sig
set_ssao_bias = runMethod @"set_ssao_bias"

set_ssao_blur :: Method "set_ssao_blur" cls sig => cls -> sig
set_ssao_blur = runMethod @"set_ssao_blur"

set_ssao_color :: Method "set_ssao_color" cls sig => cls -> sig
set_ssao_color = runMethod @"set_ssao_color"

set_ssao_direct_light_affect ::
                               Method "set_ssao_direct_light_affect" cls sig => cls -> sig
set_ssao_direct_light_affect
  = runMethod @"set_ssao_direct_light_affect"

set_ssao_edge_sharpness ::
                          Method "set_ssao_edge_sharpness" cls sig => cls -> sig
set_ssao_edge_sharpness = runMethod @"set_ssao_edge_sharpness"

set_ssao_enabled :: Method "set_ssao_enabled" cls sig => cls -> sig
set_ssao_enabled = runMethod @"set_ssao_enabled"

set_ssao_intensity ::
                     Method "set_ssao_intensity" cls sig => cls -> sig
set_ssao_intensity = runMethod @"set_ssao_intensity"

set_ssao_intensity2 ::
                      Method "set_ssao_intensity2" cls sig => cls -> sig
set_ssao_intensity2 = runMethod @"set_ssao_intensity2"

set_ssao_quality :: Method "set_ssao_quality" cls sig => cls -> sig
set_ssao_quality = runMethod @"set_ssao_quality"

set_ssao_radius :: Method "set_ssao_radius" cls sig => cls -> sig
set_ssao_radius = runMethod @"set_ssao_radius"

set_ssao_radius2 :: Method "set_ssao_radius2" cls sig => cls -> sig
set_ssao_radius2 = runMethod @"set_ssao_radius2"

set_ssr_depth_tolerance ::
                          Method "set_ssr_depth_tolerance" cls sig => cls -> sig
set_ssr_depth_tolerance = runMethod @"set_ssr_depth_tolerance"

set_ssr_enabled :: Method "set_ssr_enabled" cls sig => cls -> sig
set_ssr_enabled = runMethod @"set_ssr_enabled"

set_ssr_fade_in :: Method "set_ssr_fade_in" cls sig => cls -> sig
set_ssr_fade_in = runMethod @"set_ssr_fade_in"

set_ssr_fade_out :: Method "set_ssr_fade_out" cls sig => cls -> sig
set_ssr_fade_out = runMethod @"set_ssr_fade_out"

set_ssr_max_steps ::
                    Method "set_ssr_max_steps" cls sig => cls -> sig
set_ssr_max_steps = runMethod @"set_ssr_max_steps"

set_ssr_rough :: Method "set_ssr_rough" cls sig => cls -> sig
set_ssr_rough = runMethod @"set_ssr_rough"

set_start_node :: Method "set_start_node" cls sig => cls -> sig
set_start_node = runMethod @"set_start_node"

set_state :: Method "set_state" cls sig => cls -> sig
set_state = runMethod @"set_state"

set_steering :: Method "set_steering" cls sig => cls -> sig
set_steering = runMethod @"set_steering"

set_step :: Method "set_step" cls sig => cls -> sig
set_step = runMethod @"set_step"

set_steps :: Method "set_steps" cls sig => cls -> sig
set_steps = runMethod @"set_steps"

set_stereo :: Method "set_stereo" cls sig => cls -> sig
set_stereo = runMethod @"set_stereo"

set_stiffness :: Method "set_stiffness" cls sig => cls -> sig
set_stiffness = runMethod @"set_stiffness"

set_storage :: Method "set_storage" cls sig => cls -> sig
set_storage = runMethod @"set_storage"

set_stream :: Method "set_stream" cls sig => cls -> sig
set_stream = runMethod @"set_stream"

set_stream_paused ::
                    Method "set_stream_paused" cls sig => cls -> sig
set_stream_paused = runMethod @"set_stream_paused"

set_stream_peer :: Method "set_stream_peer" cls sig => cls -> sig
set_stream_peer = runMethod @"set_stream_peer"

set_stream_position ::
                      Method "set_stream_position" cls sig => cls -> sig
set_stream_position = runMethod @"set_stream_position"

set_stretch :: Method "set_stretch" cls sig => cls -> sig
set_stretch = runMethod @"set_stretch"

set_stretch_margin ::
                     Method "set_stretch_margin" cls sig => cls -> sig
set_stretch_margin = runMethod @"set_stretch_margin"

set_stretch_mode :: Method "set_stretch_mode" cls sig => cls -> sig
set_stretch_mode = runMethod @"set_stretch_mode"

set_stretch_ratio ::
                    Method "set_stretch_ratio" cls sig => cls -> sig
set_stretch_ratio = runMethod @"set_stretch_ratio"

set_stretch_shrink ::
                     Method "set_stretch_shrink" cls sig => cls -> sig
set_stretch_shrink = runMethod @"set_stretch_shrink"

set_stylebox :: Method "set_stylebox" cls sig => cls -> sig
set_stylebox = runMethod @"set_stylebox"

set_subdiv :: Method "set_subdiv" cls sig => cls -> sig
set_subdiv = runMethod @"set_subdiv"

set_subdivide_depth ::
                      Method "set_subdivide_depth" cls sig => cls -> sig
set_subdivide_depth = runMethod @"set_subdivide_depth"

set_subdivide_height ::
                       Method "set_subdivide_height" cls sig => cls -> sig
set_subdivide_height = runMethod @"set_subdivide_height"

set_subdivide_width ::
                      Method "set_subdivide_width" cls sig => cls -> sig
set_subdivide_width = runMethod @"set_subdivide_width"

set_submenu_popup_delay ::
                          Method "set_submenu_popup_delay" cls sig => cls -> sig
set_submenu_popup_delay = runMethod @"set_submenu_popup_delay"

set_subsurface_scattering_strength ::
                                     Method "set_subsurface_scattering_strength" cls sig =>
                                     cls -> sig
set_subsurface_scattering_strength
  = runMethod @"set_subsurface_scattering_strength"

set_suffix :: Method "set_suffix" cls sig => cls -> sig
set_suffix = runMethod @"set_suffix"

set_sun_angle_max ::
                    Method "set_sun_angle_max" cls sig => cls -> sig
set_sun_angle_max = runMethod @"set_sun_angle_max"

set_sun_angle_min ::
                    Method "set_sun_angle_min" cls sig => cls -> sig
set_sun_angle_min = runMethod @"set_sun_angle_min"

set_sun_color :: Method "set_sun_color" cls sig => cls -> sig
set_sun_color = runMethod @"set_sun_color"

set_sun_curve :: Method "set_sun_curve" cls sig => cls -> sig
set_sun_curve = runMethod @"set_sun_curve"

set_sun_energy :: Method "set_sun_energy" cls sig => cls -> sig
set_sun_energy = runMethod @"set_sun_energy"

set_sun_latitude :: Method "set_sun_latitude" cls sig => cls -> sig
set_sun_latitude = runMethod @"set_sun_latitude"

set_sun_longitude ::
                    Method "set_sun_longitude" cls sig => cls -> sig
set_sun_longitude = runMethod @"set_sun_longitude"

set_surface_material ::
                       Method "set_surface_material" cls sig => cls -> sig
set_surface_material = runMethod @"set_surface_material"

set_surround :: Method "set_surround" cls sig => cls -> sig
set_surround = runMethod @"set_surround"

set_suspension_max_force ::
                           Method "set_suspension_max_force" cls sig => cls -> sig
set_suspension_max_force = runMethod @"set_suspension_max_force"

set_suspension_rest_length ::
                             Method "set_suspension_rest_length" cls sig => cls -> sig
set_suspension_rest_length
  = runMethod @"set_suspension_rest_length"

set_suspension_stiffness ::
                           Method "set_suspension_stiffness" cls sig => cls -> sig
set_suspension_stiffness = runMethod @"set_suspension_stiffness"

set_suspension_travel ::
                        Method "set_suspension_travel" cls sig => cls -> sig
set_suspension_travel = runMethod @"set_suspension_travel"

set_switch_mode :: Method "set_switch_mode" cls sig => cls -> sig
set_switch_mode = runMethod @"set_switch_mode"

set_symbol_prefix ::
                    Method "set_symbol_prefix" cls sig => cls -> sig
set_symbol_prefix = runMethod @"set_symbol_prefix"

set_sync_to_physics ::
                      Method "set_sync_to_physics" cls sig => cls -> sig
set_sync_to_physics = runMethod @"set_sync_to_physics"

set_syntax_coloring ::
                      Method "set_syntax_coloring" cls sig => cls -> sig
set_syntax_coloring = runMethod @"set_syntax_coloring"

set_tab_align :: Method "set_tab_align" cls sig => cls -> sig
set_tab_align = runMethod @"set_tab_align"

set_tab_close_display_policy ::
                               Method "set_tab_close_display_policy" cls sig => cls -> sig
set_tab_close_display_policy
  = runMethod @"set_tab_close_display_policy"

set_tab_disabled :: Method "set_tab_disabled" cls sig => cls -> sig
set_tab_disabled = runMethod @"set_tab_disabled"

set_tab_icon :: Method "set_tab_icon" cls sig => cls -> sig
set_tab_icon = runMethod @"set_tab_icon"

set_tab_size :: Method "set_tab_size" cls sig => cls -> sig
set_tab_size = runMethod @"set_tab_size"

set_tab_title :: Method "set_tab_title" cls sig => cls -> sig
set_tab_title = runMethod @"set_tab_title"

set_table_column_expand ::
                          Method "set_table_column_expand" cls sig => cls -> sig
set_table_column_expand = runMethod @"set_table_column_expand"

set_tabs_rearrange_group ::
                           Method "set_tabs_rearrange_group" cls sig => cls -> sig
set_tabs_rearrange_group = runMethod @"set_tabs_rearrange_group"

set_tabs_visible :: Method "set_tabs_visible" cls sig => cls -> sig
set_tabs_visible = runMethod @"set_tabs_visible"

set_tangent :: Method "set_tangent" cls sig => cls -> sig
set_tangent = runMethod @"set_tangent"

set_tap1_active :: Method "set_tap1_active" cls sig => cls -> sig
set_tap1_active = runMethod @"set_tap1_active"

set_tap1_delay_ms ::
                    Method "set_tap1_delay_ms" cls sig => cls -> sig
set_tap1_delay_ms = runMethod @"set_tap1_delay_ms"

set_tap1_level_db ::
                    Method "set_tap1_level_db" cls sig => cls -> sig
set_tap1_level_db = runMethod @"set_tap1_level_db"

set_tap1_pan :: Method "set_tap1_pan" cls sig => cls -> sig
set_tap1_pan = runMethod @"set_tap1_pan"

set_tap2_active :: Method "set_tap2_active" cls sig => cls -> sig
set_tap2_active = runMethod @"set_tap2_active"

set_tap2_delay_ms ::
                    Method "set_tap2_delay_ms" cls sig => cls -> sig
set_tap2_delay_ms = runMethod @"set_tap2_delay_ms"

set_tap2_level_db ::
                    Method "set_tap2_level_db" cls sig => cls -> sig
set_tap2_level_db = runMethod @"set_tap2_level_db"

set_tap2_pan :: Method "set_tap2_pan" cls sig => cls -> sig
set_tap2_pan = runMethod @"set_tap2_pan"

set_target :: Method "set_target" cls sig => cls -> sig
set_target = runMethod @"set_target"

set_target_fps :: Method "set_target_fps" cls sig => cls -> sig
set_target_fps = runMethod @"set_target_fps"

set_target_node :: Method "set_target_node" cls sig => cls -> sig
set_target_node = runMethod @"set_target_node"

set_target_path :: Method "set_target_path" cls sig => cls -> sig
set_target_path = runMethod @"set_target_path"

set_target_peer :: Method "set_target_peer" cls sig => cls -> sig
set_target_peer = runMethod @"set_target_peer"

set_target_transform ::
                       Method "set_target_transform" cls sig => cls -> sig
set_target_transform = runMethod @"set_target_transform"

set_text :: Method "set_text" cls sig => cls -> sig
set_text = runMethod @"set_text"

set_text_align :: Method "set_text_align" cls sig => cls -> sig
set_text_align = runMethod @"set_text_align"

set_texture :: Method "set_texture" cls sig => cls -> sig
set_texture = runMethod @"set_texture"

set_texture_mode :: Method "set_texture_mode" cls sig => cls -> sig
set_texture_mode = runMethod @"set_texture_mode"

set_texture_offset ::
                     Method "set_texture_offset" cls sig => cls -> sig
set_texture_offset = runMethod @"set_texture_offset"

set_texture_pressed ::
                      Method "set_texture_pressed" cls sig => cls -> sig
set_texture_pressed = runMethod @"set_texture_pressed"

set_texture_rotation ::
                       Method "set_texture_rotation" cls sig => cls -> sig
set_texture_rotation = runMethod @"set_texture_rotation"

set_texture_rotation_degrees ::
                               Method "set_texture_rotation_degrees" cls sig => cls -> sig
set_texture_rotation_degrees
  = runMethod @"set_texture_rotation_degrees"

set_texture_scale ::
                    Method "set_texture_scale" cls sig => cls -> sig
set_texture_scale = runMethod @"set_texture_scale"

set_texture_size :: Method "set_texture_size" cls sig => cls -> sig
set_texture_size = runMethod @"set_texture_size"

set_texture_type :: Method "set_texture_type" cls sig => cls -> sig
set_texture_type = runMethod @"set_texture_type"

set_theme :: Method "set_theme" cls sig => cls -> sig
set_theme = runMethod @"set_theme"

set_thickness :: Method "set_thickness" cls sig => cls -> sig
set_thickness = runMethod @"set_thickness"

set_thread_name :: Method "set_thread_name" cls sig => cls -> sig
set_thread_name = runMethod @"set_thread_name"

set_threshold :: Method "set_threshold" cls sig => cls -> sig
set_threshold = runMethod @"set_threshold"

set_threshold_db :: Method "set_threshold_db" cls sig => cls -> sig
set_threshold_db = runMethod @"set_threshold_db"

set_ticks :: Method "set_ticks" cls sig => cls -> sig
set_ticks = runMethod @"set_ticks"

set_ticks_on_borders ::
                       Method "set_ticks_on_borders" cls sig => cls -> sig
set_ticks_on_borders = runMethod @"set_ticks_on_borders"

set_tile_origin :: Method "set_tile_origin" cls sig => cls -> sig
set_tile_origin = runMethod @"set_tile_origin"

set_tileset :: Method "set_tileset" cls sig => cls -> sig
set_tileset = runMethod @"set_tileset"

set_time_left :: Method "set_time_left" cls sig => cls -> sig
set_time_left = runMethod @"set_time_left"

set_time_pullout :: Method "set_time_pullout" cls sig => cls -> sig
set_time_pullout = runMethod @"set_time_pullout"

set_time_scale :: Method "set_time_scale" cls sig => cls -> sig
set_time_scale = runMethod @"set_time_scale"

set_timer_process_mode ::
                         Method "set_timer_process_mode" cls sig => cls -> sig
set_timer_process_mode = runMethod @"set_timer_process_mode"

set_tint_over :: Method "set_tint_over" cls sig => cls -> sig
set_tint_over = runMethod @"set_tint_over"

set_tint_progress ::
                    Method "set_tint_progress" cls sig => cls -> sig
set_tint_progress = runMethod @"set_tint_progress"

set_tint_under :: Method "set_tint_under" cls sig => cls -> sig
set_tint_under = runMethod @"set_tint_under"

set_tip_bone :: Method "set_tip_bone" cls sig => cls -> sig
set_tip_bone = runMethod @"set_tip_bone"

set_title :: Method "set_title" cls sig => cls -> sig
set_title = runMethod @"set_title"

set_to_cell_xform ::
                    Method "set_to_cell_xform" cls sig => cls -> sig
set_to_cell_xform = runMethod @"set_to_cell_xform"

set_toggle_mode :: Method "set_toggle_mode" cls sig => cls -> sig
set_toggle_mode = runMethod @"set_toggle_mode"

set_tonemap_auto_exposure ::
                            Method "set_tonemap_auto_exposure" cls sig => cls -> sig
set_tonemap_auto_exposure = runMethod @"set_tonemap_auto_exposure"

set_tonemap_auto_exposure_grey ::
                                 Method "set_tonemap_auto_exposure_grey" cls sig => cls -> sig
set_tonemap_auto_exposure_grey
  = runMethod @"set_tonemap_auto_exposure_grey"

set_tonemap_auto_exposure_max ::
                                Method "set_tonemap_auto_exposure_max" cls sig => cls -> sig
set_tonemap_auto_exposure_max
  = runMethod @"set_tonemap_auto_exposure_max"

set_tonemap_auto_exposure_min ::
                                Method "set_tonemap_auto_exposure_min" cls sig => cls -> sig
set_tonemap_auto_exposure_min
  = runMethod @"set_tonemap_auto_exposure_min"

set_tonemap_auto_exposure_speed ::
                                  Method "set_tonemap_auto_exposure_speed" cls sig => cls -> sig
set_tonemap_auto_exposure_speed
  = runMethod @"set_tonemap_auto_exposure_speed"

set_tonemap_exposure ::
                       Method "set_tonemap_exposure" cls sig => cls -> sig
set_tonemap_exposure = runMethod @"set_tonemap_exposure"

set_tonemap_white ::
                    Method "set_tonemap_white" cls sig => cls -> sig
set_tonemap_white = runMethod @"set_tonemap_white"

set_tonemapper :: Method "set_tonemapper" cls sig => cls -> sig
set_tonemapper = runMethod @"set_tonemapper"

set_tooltip :: Method "set_tooltip" cls sig => cls -> sig
set_tooltip = runMethod @"set_tooltip"

set_top_radius :: Method "set_top_radius" cls sig => cls -> sig
set_top_radius = runMethod @"set_top_radius"

set_total_mass :: Method "set_total_mass" cls sig => cls -> sig
set_total_mass = runMethod @"set_total_mass"

set_track_physics_step ::
                         Method "set_track_physics_step" cls sig => cls -> sig
set_track_physics_step = runMethod @"set_track_physics_step"

set_trail_color_modifier ::
                           Method "set_trail_color_modifier" cls sig => cls -> sig
set_trail_color_modifier = runMethod @"set_trail_color_modifier"

set_trail_divisor ::
                    Method "set_trail_divisor" cls sig => cls -> sig
set_trail_divisor = runMethod @"set_trail_divisor"

set_trail_size_modifier ::
                          Method "set_trail_size_modifier" cls sig => cls -> sig
set_trail_size_modifier = runMethod @"set_trail_size_modifier"

set_transfer_channel ::
                       Method "set_transfer_channel" cls sig => cls -> sig
set_transfer_channel = runMethod @"set_transfer_channel"

set_transfer_mode ::
                    Method "set_transfer_mode" cls sig => cls -> sig
set_transfer_mode = runMethod @"set_transfer_mode"

set_transform :: Method "set_transform" cls sig => cls -> sig
set_transform = runMethod @"set_transform"

set_transform_format ::
                       Method "set_transform_format" cls sig => cls -> sig
set_transform_format = runMethod @"set_transform_format"

set_translation :: Method "set_translation" cls sig => cls -> sig
set_translation = runMethod @"set_translation"

set_transmission :: Method "set_transmission" cls sig => cls -> sig
set_transmission = runMethod @"set_transmission"

set_transparent_background ::
                             Method "set_transparent_background" cls sig => cls -> sig
set_transparent_background
  = runMethod @"set_transparent_background"

set_tree_root :: Method "set_tree_root" cls sig => cls -> sig
set_tree_root = runMethod @"set_tree_root"

set_tween_process_mode ::
                         Method "set_tween_process_mode" cls sig => cls -> sig
set_tween_process_mode = runMethod @"set_tween_process_mode"

set_typed :: Method "set_typed" cls sig => cls -> sig
set_typed = runMethod @"set_typed"

set_under_texture ::
                    Method "set_under_texture" cls sig => cls -> sig
set_under_texture = runMethod @"set_under_texture"

set_underline_mode ::
                     Method "set_underline_mode" cls sig => cls -> sig
set_underline_mode = runMethod @"set_underline_mode"

set_unicode :: Method "set_unicode" cls sig => cls -> sig
set_unicode = runMethod @"set_unicode"

set_uniform_name :: Method "set_uniform_name" cls sig => cls -> sig
set_uniform_name = runMethod @"set_uniform_name"

set_unit_db :: Method "set_unit_db" cls sig => cls -> sig
set_unit_db = runMethod @"set_unit_db"

set_unit_offset :: Method "set_unit_offset" cls sig => cls -> sig
set_unit_offset = runMethod @"set_unit_offset"

set_unit_size :: Method "set_unit_size" cls sig => cls -> sig
set_unit_size = runMethod @"set_unit_size"

set_up_vector :: Method "set_up_vector" cls sig => cls -> sig
set_up_vector = runMethod @"set_up_vector"

set_up_vector_enabled ::
                        Method "set_up_vector_enabled" cls sig => cls -> sig
set_up_vector_enabled = runMethod @"set_up_vector_enabled"

set_update_mode :: Method "set_update_mode" cls sig => cls -> sig
set_update_mode = runMethod @"set_update_mode"

set_update_position ::
                      Method "set_update_position" cls sig => cls -> sig
set_update_position = runMethod @"set_update_position"

set_update_rotation ::
                      Method "set_update_rotation" cls sig => cls -> sig
set_update_rotation = runMethod @"set_update_rotation"

set_update_scale :: Method "set_update_scale" cls sig => cls -> sig
set_update_scale = runMethod @"set_update_scale"

set_uppercase :: Method "set_uppercase" cls sig => cls -> sig
set_uppercase = runMethod @"set_uppercase"

set_usage :: Method "set_usage" cls sig => cls -> sig
set_usage = runMethod @"set_usage"

set_use_arvr :: Method "set_use_arvr" cls sig => cls -> sig
set_use_arvr = runMethod @"set_use_arvr"

set_use_as_steering ::
                      Method "set_use_as_steering" cls sig => cls -> sig
set_use_as_steering = runMethod @"set_use_as_steering"

set_use_as_traction ::
                      Method "set_use_as_traction" cls sig => cls -> sig
set_use_as_traction = runMethod @"set_use_as_traction"

set_use_bbcode :: Method "set_use_bbcode" cls sig => cls -> sig
set_use_bbcode = runMethod @"set_use_bbcode"

set_use_collision ::
                    Method "set_use_collision" cls sig => cls -> sig
set_use_collision = runMethod @"set_use_collision"

set_use_continuous_collision_detection ::
                                         Method "set_use_continuous_collision_detection" cls sig =>
                                         cls -> sig
set_use_continuous_collision_detection
  = runMethod @"set_use_continuous_collision_detection"

set_use_custom_integrator ::
                            Method "set_use_custom_integrator" cls sig => cls -> sig
set_use_custom_integrator = runMethod @"set_use_custom_integrator"

set_use_default_args ::
                       Method "set_use_default_args" cls sig => cls -> sig
set_use_default_args = runMethod @"set_use_default_args"

set_use_file_access_save_and_swap ::
                                    Method "set_use_file_access_save_and_swap" cls sig => cls -> sig
set_use_file_access_save_and_swap
  = runMethod @"set_use_file_access_save_and_swap"

set_use_filter :: Method "set_use_filter" cls sig => cls -> sig
set_use_filter = runMethod @"set_use_filter"

set_use_font_oversampling ::
                            Method "set_use_font_oversampling" cls sig => cls -> sig
set_use_font_oversampling = runMethod @"set_use_font_oversampling"

set_use_global_coordinates ::
                             Method "set_use_global_coordinates" cls sig => cls -> sig
set_use_global_coordinates
  = runMethod @"set_use_global_coordinates"

set_use_local_coordinates ::
                            Method "set_use_local_coordinates" cls sig => cls -> sig
set_use_local_coordinates = runMethod @"set_use_local_coordinates"

set_use_magnet :: Method "set_use_magnet" cls sig => cls -> sig
set_use_magnet = runMethod @"set_use_magnet"

set_use_mipmaps :: Method "set_use_mipmaps" cls sig => cls -> sig
set_use_mipmaps = runMethod @"set_use_mipmaps"

set_use_own_world ::
                    Method "set_use_own_world" cls sig => cls -> sig
set_use_own_world = runMethod @"set_use_own_world"

set_use_parent_material ::
                          Method "set_use_parent_material" cls sig => cls -> sig
set_use_parent_material = runMethod @"set_use_parent_material"

set_use_reverb_bus ::
                     Method "set_use_reverb_bus" cls sig => cls -> sig
set_use_reverb_bus = runMethod @"set_use_reverb_bus"

set_use_rounded_values ::
                         Method "set_use_rounded_values" cls sig => cls -> sig
set_use_rounded_values = runMethod @"set_use_rounded_values"

set_use_snap :: Method "set_use_snap" cls sig => cls -> sig
set_use_snap = runMethod @"set_use_snap"

set_use_sync :: Method "set_use_sync" cls sig => cls -> sig
set_use_sync = runMethod @"set_use_sync"

set_use_threads :: Method "set_use_threads" cls sig => cls -> sig
set_use_threads = runMethod @"set_use_threads"

set_use_top_left :: Method "set_use_top_left" cls sig => cls -> sig
set_use_top_left = runMethod @"set_use_top_left"

set_use_vsync :: Method "set_use_vsync" cls sig => cls -> sig
set_use_vsync = runMethod @"set_use_vsync"

set_uv :: Method "set_uv" cls sig => cls -> sig
set_uv = runMethod @"set_uv"

set_uv1_offset :: Method "set_uv1_offset" cls sig => cls -> sig
set_uv1_offset = runMethod @"set_uv1_offset"

set_uv1_scale :: Method "set_uv1_scale" cls sig => cls -> sig
set_uv1_scale = runMethod @"set_uv1_scale"

set_uv1_triplanar_blend_sharpness ::
                                    Method "set_uv1_triplanar_blend_sharpness" cls sig => cls -> sig
set_uv1_triplanar_blend_sharpness
  = runMethod @"set_uv1_triplanar_blend_sharpness"

set_uv2 :: Method "set_uv2" cls sig => cls -> sig
set_uv2 = runMethod @"set_uv2"

set_uv2_offset :: Method "set_uv2_offset" cls sig => cls -> sig
set_uv2_offset = runMethod @"set_uv2_offset"

set_uv2_scale :: Method "set_uv2_scale" cls sig => cls -> sig
set_uv2_scale = runMethod @"set_uv2_scale"

set_uv2_triplanar_blend_sharpness ::
                                    Method "set_uv2_triplanar_blend_sharpness" cls sig => cls -> sig
set_uv2_triplanar_blend_sharpness
  = runMethod @"set_uv2_triplanar_blend_sharpness"

set_v_axis_stretch_mode ::
                          Method "set_v_axis_stretch_mode" cls sig => cls -> sig
set_v_axis_stretch_mode = runMethod @"set_v_axis_stretch_mode"

set_v_drag_enabled ::
                     Method "set_v_drag_enabled" cls sig => cls -> sig
set_v_drag_enabled = runMethod @"set_v_drag_enabled"

set_v_frames :: Method "set_v_frames" cls sig => cls -> sig
set_v_frames = runMethod @"set_v_frames"

set_v_grow_direction ::
                       Method "set_v_grow_direction" cls sig => cls -> sig
set_v_grow_direction = runMethod @"set_v_grow_direction"

set_v_offset :: Method "set_v_offset" cls sig => cls -> sig
set_v_offset = runMethod @"set_v_offset"

set_v_scroll :: Method "set_v_scroll" cls sig => cls -> sig
set_v_scroll = runMethod @"set_v_scroll"

set_v_scroll_speed ::
                     Method "set_v_scroll_speed" cls sig => cls -> sig
set_v_scroll_speed = runMethod @"set_v_scroll_speed"

set_v_size_flags :: Method "set_v_size_flags" cls sig => cls -> sig
set_v_size_flags = runMethod @"set_v_size_flags"

set_validate :: Method "set_validate" cls sig => cls -> sig
set_validate = runMethod @"set_validate"

set_valign :: Method "set_valign" cls sig => cls -> sig
set_valign = runMethod @"set_valign"

set_value :: Method "set_value" cls sig => cls -> sig
set_value = runMethod @"set_value"

set_value_label :: Method "set_value_label" cls sig => cls -> sig
set_value_label = runMethod @"set_value_label"

set_var_name :: Method "set_var_name" cls sig => cls -> sig
set_var_name = runMethod @"set_var_name"

set_var_type :: Method "set_var_type" cls sig => cls -> sig
set_var_type = runMethod @"set_var_type"

set_variable :: Method "set_variable" cls sig => cls -> sig
set_variable = runMethod @"set_variable"

set_variable_default_value ::
                             Method "set_variable_default_value" cls sig => cls -> sig
set_variable_default_value
  = runMethod @"set_variable_default_value"

set_variable_export ::
                      Method "set_variable_export" cls sig => cls -> sig
set_variable_export = runMethod @"set_variable_export"

set_variable_info ::
                    Method "set_variable_info" cls sig => cls -> sig
set_variable_info = runMethod @"set_variable_info"

set_verify_ssl_enabled ::
                         Method "set_verify_ssl_enabled" cls sig => cls -> sig
set_verify_ssl_enabled = runMethod @"set_verify_ssl_enabled"

set_vertex :: Method "set_vertex" cls sig => cls -> sig
set_vertex = runMethod @"set_vertex"

set_vertex_bones :: Method "set_vertex_bones" cls sig => cls -> sig
set_vertex_bones = runMethod @"set_vertex_bones"

set_vertex_color :: Method "set_vertex_color" cls sig => cls -> sig
set_vertex_color = runMethod @"set_vertex_color"

set_vertex_colors ::
                    Method "set_vertex_colors" cls sig => cls -> sig
set_vertex_colors = runMethod @"set_vertex_colors"

set_vertex_meta :: Method "set_vertex_meta" cls sig => cls -> sig
set_vertex_meta = runMethod @"set_vertex_meta"

set_vertex_normal ::
                    Method "set_vertex_normal" cls sig => cls -> sig
set_vertex_normal = runMethod @"set_vertex_normal"

set_vertex_tangent ::
                     Method "set_vertex_tangent" cls sig => cls -> sig
set_vertex_tangent = runMethod @"set_vertex_tangent"

set_vertex_uv :: Method "set_vertex_uv" cls sig => cls -> sig
set_vertex_uv = runMethod @"set_vertex_uv"

set_vertex_uv2 :: Method "set_vertex_uv2" cls sig => cls -> sig
set_vertex_uv2 = runMethod @"set_vertex_uv2"

set_vertex_weights ::
                     Method "set_vertex_weights" cls sig => cls -> sig
set_vertex_weights = runMethod @"set_vertex_weights"

set_vertical :: Method "set_vertical" cls sig => cls -> sig
set_vertical = runMethod @"set_vertical"

set_vertices :: Method "set_vertices" cls sig => cls -> sig
set_vertices = runMethod @"set_vertices"

set_verts_per_poly ::
                     Method "set_verts_per_poly" cls sig => cls -> sig
set_verts_per_poly = runMethod @"set_verts_per_poly"

set_vflip :: Method "set_vflip" cls sig => cls -> sig
set_vflip = runMethod @"set_vflip"

set_vframes :: Method "set_vframes" cls sig => cls -> sig
set_vframes = runMethod @"set_vframes"

set_viewport_path_in_scene ::
                             Method "set_viewport_path_in_scene" cls sig => cls -> sig
set_viewport_path_in_scene
  = runMethod @"set_viewport_path_in_scene"

set_visibility_aabb ::
                      Method "set_visibility_aabb" cls sig => cls -> sig
set_visibility_aabb = runMethod @"set_visibility_aabb"

set_visibility_mode ::
                      Method "set_visibility_mode" cls sig => cls -> sig
set_visibility_mode = runMethod @"set_visibility_mode"

set_visibility_rect ::
                      Method "set_visibility_rect" cls sig => cls -> sig
set_visibility_rect = runMethod @"set_visibility_rect"

set_visible :: Method "set_visible" cls sig => cls -> sig
set_visible = runMethod @"set_visible"

set_visible_characters ::
                         Method "set_visible_characters" cls sig => cls -> sig
set_visible_characters = runMethod @"set_visible_characters"

set_voice_count :: Method "set_voice_count" cls sig => cls -> sig
set_voice_count = runMethod @"set_voice_count"

set_voice_cutoff_hz ::
                      Method "set_voice_cutoff_hz" cls sig => cls -> sig
set_voice_cutoff_hz = runMethod @"set_voice_cutoff_hz"

set_voice_delay_ms ::
                     Method "set_voice_delay_ms" cls sig => cls -> sig
set_voice_delay_ms = runMethod @"set_voice_delay_ms"

set_voice_depth_ms ::
                     Method "set_voice_depth_ms" cls sig => cls -> sig
set_voice_depth_ms = runMethod @"set_voice_depth_ms"

set_voice_level_db ::
                     Method "set_voice_level_db" cls sig => cls -> sig
set_voice_level_db = runMethod @"set_voice_level_db"

set_voice_pan :: Method "set_voice_pan" cls sig => cls -> sig
set_voice_pan = runMethod @"set_voice_pan"

set_voice_rate_hz ::
                    Method "set_voice_rate_hz" cls sig => cls -> sig
set_voice_rate_hz = runMethod @"set_voice_rate_hz"

set_volume :: Method "set_volume" cls sig => cls -> sig
set_volume = runMethod @"set_volume"

set_volume_db :: Method "set_volume_db" cls sig => cls -> sig
set_volume_db = runMethod @"set_volume_db"

set_volume_stiffness ::
                       Method "set_volume_stiffness" cls sig => cls -> sig
set_volume_stiffness = runMethod @"set_volume_stiffness"

set_wait_time :: Method "set_wait_time" cls sig => cls -> sig
set_wait_time = runMethod @"set_wait_time"

set_weight :: Method "set_weight" cls sig => cls -> sig
set_weight = runMethod @"set_weight"

set_wet :: Method "set_wet" cls sig => cls -> sig
set_wet = runMethod @"set_wet"

set_width :: Method "set_width" cls sig => cls -> sig
set_width = runMethod @"set_width"

set_window_always_on_top ::
                           Method "set_window_always_on_top" cls sig => cls -> sig
set_window_always_on_top = runMethod @"set_window_always_on_top"

set_window_fullscreen ::
                        Method "set_window_fullscreen" cls sig => cls -> sig
set_window_fullscreen = runMethod @"set_window_fullscreen"

set_window_layout ::
                    Method "set_window_layout" cls sig => cls -> sig
set_window_layout = runMethod @"set_window_layout"

set_window_maximized ::
                       Method "set_window_maximized" cls sig => cls -> sig
set_window_maximized = runMethod @"set_window_maximized"

set_window_minimized ::
                       Method "set_window_minimized" cls sig => cls -> sig
set_window_minimized = runMethod @"set_window_minimized"

set_window_per_pixel_transparency_enabled ::
                                            Method "set_window_per_pixel_transparency_enabled" cls
                                              sig =>
                                            cls -> sig
set_window_per_pixel_transparency_enabled
  = runMethod @"set_window_per_pixel_transparency_enabled"

set_window_position ::
                      Method "set_window_position" cls sig => cls -> sig
set_window_position = runMethod @"set_window_position"

set_window_resizable ::
                       Method "set_window_resizable" cls sig => cls -> sig
set_window_resizable = runMethod @"set_window_resizable"

set_window_size :: Method "set_window_size" cls sig => cls -> sig
set_window_size = runMethod @"set_window_size"

set_window_title :: Method "set_window_title" cls sig => cls -> sig
set_window_title = runMethod @"set_window_title"

set_world :: Method "set_world" cls sig => cls -> sig
set_world = runMethod @"set_world"

set_world_2d :: Method "set_world_2d" cls sig => cls -> sig
set_world_2d = runMethod @"set_world_2d"

set_world_scale :: Method "set_world_scale" cls sig => cls -> sig
set_world_scale = runMethod @"set_world_scale"

set_wrap_enabled :: Method "set_wrap_enabled" cls sig => cls -> sig
set_wrap_enabled = runMethod @"set_wrap_enabled"

set_write_mode :: Method "set_write_mode" cls sig => cls -> sig
set_write_mode = runMethod @"set_write_mode"

set_x_label :: Method "set_x_label" cls sig => cls -> sig
set_x_label = runMethod @"set_x_label"

set_xfade_time :: Method "set_xfade_time" cls sig => cls -> sig
set_xfade_time = runMethod @"set_xfade_time"

set_y_label :: Method "set_y_label" cls sig => cls -> sig
set_y_label = runMethod @"set_y_label"

set_y_sort_mode :: Method "set_y_sort_mode" cls sig => cls -> sig
set_y_sort_mode = runMethod @"set_y_sort_mode"

set_yield_mode :: Method "set_yield_mode" cls sig => cls -> sig
set_yield_mode = runMethod @"set_yield_mode"

set_z_as_relative ::
                    Method "set_z_as_relative" cls sig => cls -> sig
set_z_as_relative = runMethod @"set_z_as_relative"

set_z_index :: Method "set_z_index" cls sig => cls -> sig
set_z_index = runMethod @"set_z_index"

set_z_range_max :: Method "set_z_range_max" cls sig => cls -> sig
set_z_range_max = runMethod @"set_z_range_max"

set_z_range_min :: Method "set_z_range_min" cls sig => cls -> sig
set_z_range_min = runMethod @"set_z_range_min"

set_zero_y :: Method "set_zero_y" cls sig => cls -> sig
set_zero_y = runMethod @"set_zero_y"

set_zfar :: Method "set_zfar" cls sig => cls -> sig
set_zfar = runMethod @"set_zfar"

set_znear :: Method "set_znear" cls sig => cls -> sig
set_znear = runMethod @"set_znear"

set_zoom :: Method "set_zoom" cls sig => cls -> sig
set_zoom = runMethod @"set_zoom"

setup :: Method "setup" cls sig => cls -> sig
setup = runMethod @"setup"

setup_local_to_scene ::
                       Method "setup_local_to_scene" cls sig => cls -> sig
setup_local_to_scene = runMethod @"setup_local_to_scene"

shader_create :: Method "shader_create" cls sig => cls -> sig
shader_create = runMethod @"shader_create"

shader_get_code :: Method "shader_get_code" cls sig => cls -> sig
shader_get_code = runMethod @"shader_get_code"

shader_get_default_texture_param ::
                                   Method "shader_get_default_texture_param" cls sig => cls -> sig
shader_get_default_texture_param
  = runMethod @"shader_get_default_texture_param"

shader_get_param_list ::
                        Method "shader_get_param_list" cls sig => cls -> sig
shader_get_param_list = runMethod @"shader_get_param_list"

shader_set_code :: Method "shader_set_code" cls sig => cls -> sig
shader_set_code = runMethod @"shader_set_code"

shader_set_default_texture_param ::
                                   Method "shader_set_default_texture_param" cls sig => cls -> sig
shader_set_default_texture_param
  = runMethod @"shader_set_default_texture_param"

shape_create :: Method "shape_create" cls sig => cls -> sig
shape_create = runMethod @"shape_create"

shape_find_owner :: Method "shape_find_owner" cls sig => cls -> sig
shape_find_owner = runMethod @"shape_find_owner"

shape_get_data :: Method "shape_get_data" cls sig => cls -> sig
shape_get_data = runMethod @"shape_get_data"

shape_get_type :: Method "shape_get_type" cls sig => cls -> sig
shape_get_type = runMethod @"shape_get_type"

shape_owner_add_shape ::
                        Method "shape_owner_add_shape" cls sig => cls -> sig
shape_owner_add_shape = runMethod @"shape_owner_add_shape"

shape_owner_clear_shapes ::
                           Method "shape_owner_clear_shapes" cls sig => cls -> sig
shape_owner_clear_shapes = runMethod @"shape_owner_clear_shapes"

shape_owner_get_owner ::
                        Method "shape_owner_get_owner" cls sig => cls -> sig
shape_owner_get_owner = runMethod @"shape_owner_get_owner"

shape_owner_get_shape ::
                        Method "shape_owner_get_shape" cls sig => cls -> sig
shape_owner_get_shape = runMethod @"shape_owner_get_shape"

shape_owner_get_shape_count ::
                              Method "shape_owner_get_shape_count" cls sig => cls -> sig
shape_owner_get_shape_count
  = runMethod @"shape_owner_get_shape_count"

shape_owner_get_shape_index ::
                              Method "shape_owner_get_shape_index" cls sig => cls -> sig
shape_owner_get_shape_index
  = runMethod @"shape_owner_get_shape_index"

shape_owner_get_transform ::
                            Method "shape_owner_get_transform" cls sig => cls -> sig
shape_owner_get_transform = runMethod @"shape_owner_get_transform"

shape_owner_remove_shape ::
                           Method "shape_owner_remove_shape" cls sig => cls -> sig
shape_owner_remove_shape = runMethod @"shape_owner_remove_shape"

shape_owner_set_disabled ::
                           Method "shape_owner_set_disabled" cls sig => cls -> sig
shape_owner_set_disabled = runMethod @"shape_owner_set_disabled"

shape_owner_set_one_way_collision ::
                                    Method "shape_owner_set_one_way_collision" cls sig => cls -> sig
shape_owner_set_one_way_collision
  = runMethod @"shape_owner_set_one_way_collision"

shape_owner_set_transform ::
                            Method "shape_owner_set_transform" cls sig => cls -> sig
shape_owner_set_transform = runMethod @"shape_owner_set_transform"

shape_set_data :: Method "shape_set_data" cls sig => cls -> sig
shape_set_data = runMethod @"shape_set_data"

share :: Method "share" cls sig => cls -> sig
share = runMethod @"share"

shell_open :: Method "shell_open" cls sig => cls -> sig
shell_open = runMethod @"shell_open"

shortcut_match :: Method "shortcut_match" cls sig => cls -> sig
shortcut_match = runMethod @"shortcut_match"

should_load_once :: Method "should_load_once" cls sig => cls -> sig
should_load_once = runMethod @"should_load_once"

show :: Method "show" cls sig => cls -> sig
show = runMethod @"show"

show_modal :: Method "show_modal" cls sig => cls -> sig
show_modal = runMethod @"show_modal"

show_virtual_keyboard ::
                        Method "show_virtual_keyboard" cls sig => cls -> sig
show_virtual_keyboard = runMethod @"show_virtual_keyboard"

shrink_x2 :: Method "shrink_x2" cls sig => cls -> sig
shrink_x2 = runMethod @"shrink_x2"

size :: Method "size" cls sig => cls -> sig
size = runMethod @"size"

skeleton_allocate ::
                    Method "skeleton_allocate" cls sig => cls -> sig
skeleton_allocate = runMethod @"skeleton_allocate"

skeleton_bone_get_transform ::
                              Method "skeleton_bone_get_transform" cls sig => cls -> sig
skeleton_bone_get_transform
  = runMethod @"skeleton_bone_get_transform"

skeleton_bone_get_transform_2d ::
                                 Method "skeleton_bone_get_transform_2d" cls sig => cls -> sig
skeleton_bone_get_transform_2d
  = runMethod @"skeleton_bone_get_transform_2d"

skeleton_bone_set_transform ::
                              Method "skeleton_bone_set_transform" cls sig => cls -> sig
skeleton_bone_set_transform
  = runMethod @"skeleton_bone_set_transform"

skeleton_bone_set_transform_2d ::
                                 Method "skeleton_bone_set_transform_2d" cls sig => cls -> sig
skeleton_bone_set_transform_2d
  = runMethod @"skeleton_bone_set_transform_2d"

skeleton_create :: Method "skeleton_create" cls sig => cls -> sig
skeleton_create = runMethod @"skeleton_create"

skeleton_get_bone_count ::
                          Method "skeleton_get_bone_count" cls sig => cls -> sig
skeleton_get_bone_count = runMethod @"skeleton_get_bone_count"

skip :: Method "skip" cls sig => cls -> sig
skip = runMethod @"skip"

skip_section :: Method "skip_section" cls sig => cls -> sig
skip_section = runMethod @"skip_section"

sky_create :: Method "sky_create" cls sig => cls -> sig
sky_create = runMethod @"sky_create"

sky_set_texture :: Method "sky_set_texture" cls sig => cls -> sig
sky_set_texture = runMethod @"sky_set_texture"

slider_joint_get_param ::
                         Method "slider_joint_get_param" cls sig => cls -> sig
slider_joint_get_param = runMethod @"slider_joint_get_param"

slider_joint_set_param ::
                         Method "slider_joint_set_param" cls sig => cls -> sig
slider_joint_set_param = runMethod @"slider_joint_set_param"

sort_items_by_text ::
                     Method "sort_items_by_text" cls sig => cls -> sig
sort_items_by_text = runMethod @"sort_items_by_text"

space_create :: Method "space_create" cls sig => cls -> sig
space_create = runMethod @"space_create"

space_get_direct_state ::
                         Method "space_get_direct_state" cls sig => cls -> sig
space_get_direct_state = runMethod @"space_get_direct_state"

space_get_param :: Method "space_get_param" cls sig => cls -> sig
space_get_param = runMethod @"space_get_param"

space_is_active :: Method "space_is_active" cls sig => cls -> sig
space_is_active = runMethod @"space_is_active"

space_set_active :: Method "space_set_active" cls sig => cls -> sig
space_set_active = runMethod @"space_set_active"

space_set_param :: Method "space_set_param" cls sig => cls -> sig
space_set_param = runMethod @"space_set_param"

spot_light_create ::
                    Method "spot_light_create" cls sig => cls -> sig
spot_light_create = runMethod @"spot_light_create"

srgb_to_linear :: Method "srgb_to_linear" cls sig => cls -> sig
srgb_to_linear = runMethod @"srgb_to_linear"

start :: Method "start" cls sig => cls -> sig
start = runMethod @"start"

start_joy_vibration ::
                      Method "start_joy_vibration" cls sig => cls -> sig
start_joy_vibration = runMethod @"start_joy_vibration"

stop :: Method "stop" cls sig => cls -> sig
stop = runMethod @"stop"

stop_all :: Method "stop_all" cls sig => cls -> sig
stop_all = runMethod @"stop_all"

stop_joy_vibration ::
                     Method "stop_joy_vibration" cls sig => cls -> sig
stop_joy_vibration = runMethod @"stop_joy_vibration"

store_16 :: Method "store_16" cls sig => cls -> sig
store_16 = runMethod @"store_16"

store_32 :: Method "store_32" cls sig => cls -> sig
store_32 = runMethod @"store_32"

store_64 :: Method "store_64" cls sig => cls -> sig
store_64 = runMethod @"store_64"

store_8 :: Method "store_8" cls sig => cls -> sig
store_8 = runMethod @"store_8"

store_buffer :: Method "store_buffer" cls sig => cls -> sig
store_buffer = runMethod @"store_buffer"

store_double :: Method "store_double" cls sig => cls -> sig
store_double = runMethod @"store_double"

store_float :: Method "store_float" cls sig => cls -> sig
store_float = runMethod @"store_float"

store_line :: Method "store_line" cls sig => cls -> sig
store_line = runMethod @"store_line"

store_pascal_string ::
                      Method "store_pascal_string" cls sig => cls -> sig
store_pascal_string = runMethod @"store_pascal_string"

store_real :: Method "store_real" cls sig => cls -> sig
store_real = runMethod @"store_real"

store_string :: Method "store_string" cls sig => cls -> sig
store_string = runMethod @"store_string"

store_var :: Method "store_var" cls sig => cls -> sig
store_var = runMethod @"store_var"

sub :: Method "sub" cls sig => cls -> sig
sub = runMethod @"sub"

surface_find_by_name ::
                       Method "surface_find_by_name" cls sig => cls -> sig
surface_find_by_name = runMethod @"surface_find_by_name"

surface_get_array_index_len ::
                              Method "surface_get_array_index_len" cls sig => cls -> sig
surface_get_array_index_len
  = runMethod @"surface_get_array_index_len"

surface_get_array_len ::
                        Method "surface_get_array_len" cls sig => cls -> sig
surface_get_array_len = runMethod @"surface_get_array_len"

surface_get_arrays ::
                     Method "surface_get_arrays" cls sig => cls -> sig
surface_get_arrays = runMethod @"surface_get_arrays"

surface_get_blend_shape_arrays ::
                                 Method "surface_get_blend_shape_arrays" cls sig => cls -> sig
surface_get_blend_shape_arrays
  = runMethod @"surface_get_blend_shape_arrays"

surface_get_format ::
                     Method "surface_get_format" cls sig => cls -> sig
surface_get_format = runMethod @"surface_get_format"

surface_get_material ::
                       Method "surface_get_material" cls sig => cls -> sig
surface_get_material = runMethod @"surface_get_material"

surface_get_name :: Method "surface_get_name" cls sig => cls -> sig
surface_get_name = runMethod @"surface_get_name"

surface_get_primitive_type ::
                             Method "surface_get_primitive_type" cls sig => cls -> sig
surface_get_primitive_type
  = runMethod @"surface_get_primitive_type"

surface_remove :: Method "surface_remove" cls sig => cls -> sig
surface_remove = runMethod @"surface_remove"

surface_set_material ::
                       Method "surface_set_material" cls sig => cls -> sig
surface_set_material = runMethod @"surface_set_material"

surface_set_name :: Method "surface_set_name" cls sig => cls -> sig
surface_set_name = runMethod @"surface_set_name"

surface_update_region ::
                        Method "surface_update_region" cls sig => cls -> sig
surface_update_region = runMethod @"surface_update_region"

swap_bus_effects :: Method "swap_bus_effects" cls sig => cls -> sig
swap_bus_effects = runMethod @"swap_bus_effects"

sync :: Method "sync" cls sig => cls -> sig
sync = runMethod @"sync"

take_connection :: Method "take_connection" cls sig => cls -> sig
take_connection = runMethod @"take_connection"

take_over_path :: Method "take_over_path" cls sig => cls -> sig
take_over_path = runMethod @"take_over_path"

targeting_method :: Method "targeting_method" cls sig => cls -> sig
targeting_method = runMethod @"targeting_method"

targeting_property ::
                     Method "targeting_property" cls sig => cls -> sig
targeting_property = runMethod @"targeting_property"

tell :: Method "tell" cls sig => cls -> sig
tell = runMethod @"tell"

terminate :: Method "terminate" cls sig => cls -> sig
terminate = runMethod @"terminate"

tessellate :: Method "tessellate" cls sig => cls -> sig
tessellate = runMethod @"tessellate"

test_mask :: Method "test_mask" cls sig => cls -> sig
test_mask = runMethod @"test_mask"

test_motion :: Method "test_motion" cls sig => cls -> sig
test_motion = runMethod @"test_motion"

test_move :: Method "test_move" cls sig => cls -> sig
test_move = runMethod @"test_move"

texture_allocate :: Method "texture_allocate" cls sig => cls -> sig
texture_allocate = runMethod @"texture_allocate"

texture_create :: Method "texture_create" cls sig => cls -> sig
texture_create = runMethod @"texture_create"

texture_create_from_image ::
                            Method "texture_create_from_image" cls sig => cls -> sig
texture_create_from_image = runMethod @"texture_create_from_image"

texture_debug_usage ::
                      Method "texture_debug_usage" cls sig => cls -> sig
texture_debug_usage = runMethod @"texture_debug_usage"

texture_get_data :: Method "texture_get_data" cls sig => cls -> sig
texture_get_data = runMethod @"texture_get_data"

texture_get_depth ::
                    Method "texture_get_depth" cls sig => cls -> sig
texture_get_depth = runMethod @"texture_get_depth"

texture_get_flags ::
                    Method "texture_get_flags" cls sig => cls -> sig
texture_get_flags = runMethod @"texture_get_flags"

texture_get_format ::
                     Method "texture_get_format" cls sig => cls -> sig
texture_get_format = runMethod @"texture_get_format"

texture_get_height ::
                     Method "texture_get_height" cls sig => cls -> sig
texture_get_height = runMethod @"texture_get_height"

texture_get_path :: Method "texture_get_path" cls sig => cls -> sig
texture_get_path = runMethod @"texture_get_path"

texture_get_texid ::
                    Method "texture_get_texid" cls sig => cls -> sig
texture_get_texid = runMethod @"texture_get_texid"

texture_get_type :: Method "texture_get_type" cls sig => cls -> sig
texture_get_type = runMethod @"texture_get_type"

texture_get_width ::
                    Method "texture_get_width" cls sig => cls -> sig
texture_get_width = runMethod @"texture_get_width"

texture_set_data :: Method "texture_set_data" cls sig => cls -> sig
texture_set_data = runMethod @"texture_set_data"

texture_set_data_partial ::
                           Method "texture_set_data_partial" cls sig => cls -> sig
texture_set_data_partial = runMethod @"texture_set_data_partial"

texture_set_flags ::
                    Method "texture_set_flags" cls sig => cls -> sig
texture_set_flags = runMethod @"texture_set_flags"

texture_set_path :: Method "texture_set_path" cls sig => cls -> sig
texture_set_path = runMethod @"texture_set_path"

texture_set_shrink_all_x2_on_set_data ::
                                        Method "texture_set_shrink_all_x2_on_set_data" cls sig =>
                                        cls -> sig
texture_set_shrink_all_x2_on_set_data
  = runMethod @"texture_set_shrink_all_x2_on_set_data"

texture_set_size_override ::
                            Method "texture_set_size_override" cls sig => cls -> sig
texture_set_size_override = runMethod @"texture_set_size_override"

textures_keep_original ::
                         Method "textures_keep_original" cls sig => cls -> sig
textures_keep_original = runMethod @"textures_keep_original"

tile_add_shape :: Method "tile_add_shape" cls sig => cls -> sig
tile_add_shape = runMethod @"tile_add_shape"

tile_get_light_occluder ::
                          Method "tile_get_light_occluder" cls sig => cls -> sig
tile_get_light_occluder = runMethod @"tile_get_light_occluder"

tile_get_material ::
                    Method "tile_get_material" cls sig => cls -> sig
tile_get_material = runMethod @"tile_get_material"

tile_get_modulate ::
                    Method "tile_get_modulate" cls sig => cls -> sig
tile_get_modulate = runMethod @"tile_get_modulate"

tile_get_name :: Method "tile_get_name" cls sig => cls -> sig
tile_get_name = runMethod @"tile_get_name"

tile_get_navigation_polygon ::
                              Method "tile_get_navigation_polygon" cls sig => cls -> sig
tile_get_navigation_polygon
  = runMethod @"tile_get_navigation_polygon"

tile_get_navigation_polygon_offset ::
                                     Method "tile_get_navigation_polygon_offset" cls sig =>
                                     cls -> sig
tile_get_navigation_polygon_offset
  = runMethod @"tile_get_navigation_polygon_offset"

tile_get_normal_map ::
                      Method "tile_get_normal_map" cls sig => cls -> sig
tile_get_normal_map = runMethod @"tile_get_normal_map"

tile_get_occluder_offset ::
                           Method "tile_get_occluder_offset" cls sig => cls -> sig
tile_get_occluder_offset = runMethod @"tile_get_occluder_offset"

tile_get_region :: Method "tile_get_region" cls sig => cls -> sig
tile_get_region = runMethod @"tile_get_region"

tile_get_shape :: Method "tile_get_shape" cls sig => cls -> sig
tile_get_shape = runMethod @"tile_get_shape"

tile_get_shape_count ::
                       Method "tile_get_shape_count" cls sig => cls -> sig
tile_get_shape_count = runMethod @"tile_get_shape_count"

tile_get_shape_offset ::
                        Method "tile_get_shape_offset" cls sig => cls -> sig
tile_get_shape_offset = runMethod @"tile_get_shape_offset"

tile_get_shape_one_way ::
                         Method "tile_get_shape_one_way" cls sig => cls -> sig
tile_get_shape_one_way = runMethod @"tile_get_shape_one_way"

tile_get_shape_transform ::
                           Method "tile_get_shape_transform" cls sig => cls -> sig
tile_get_shape_transform = runMethod @"tile_get_shape_transform"

tile_get_shapes :: Method "tile_get_shapes" cls sig => cls -> sig
tile_get_shapes = runMethod @"tile_get_shapes"

tile_get_texture :: Method "tile_get_texture" cls sig => cls -> sig
tile_get_texture = runMethod @"tile_get_texture"

tile_get_texture_offset ::
                          Method "tile_get_texture_offset" cls sig => cls -> sig
tile_get_texture_offset = runMethod @"tile_get_texture_offset"

tile_get_tile_mode ::
                     Method "tile_get_tile_mode" cls sig => cls -> sig
tile_get_tile_mode = runMethod @"tile_get_tile_mode"

tile_get_z_index :: Method "tile_get_z_index" cls sig => cls -> sig
tile_get_z_index = runMethod @"tile_get_z_index"

tile_set_light_occluder ::
                          Method "tile_set_light_occluder" cls sig => cls -> sig
tile_set_light_occluder = runMethod @"tile_set_light_occluder"

tile_set_material ::
                    Method "tile_set_material" cls sig => cls -> sig
tile_set_material = runMethod @"tile_set_material"

tile_set_modulate ::
                    Method "tile_set_modulate" cls sig => cls -> sig
tile_set_modulate = runMethod @"tile_set_modulate"

tile_set_name :: Method "tile_set_name" cls sig => cls -> sig
tile_set_name = runMethod @"tile_set_name"

tile_set_navigation_polygon ::
                              Method "tile_set_navigation_polygon" cls sig => cls -> sig
tile_set_navigation_polygon
  = runMethod @"tile_set_navigation_polygon"

tile_set_navigation_polygon_offset ::
                                     Method "tile_set_navigation_polygon_offset" cls sig =>
                                     cls -> sig
tile_set_navigation_polygon_offset
  = runMethod @"tile_set_navigation_polygon_offset"

tile_set_normal_map ::
                      Method "tile_set_normal_map" cls sig => cls -> sig
tile_set_normal_map = runMethod @"tile_set_normal_map"

tile_set_occluder_offset ::
                           Method "tile_set_occluder_offset" cls sig => cls -> sig
tile_set_occluder_offset = runMethod @"tile_set_occluder_offset"

tile_set_region :: Method "tile_set_region" cls sig => cls -> sig
tile_set_region = runMethod @"tile_set_region"

tile_set_shape :: Method "tile_set_shape" cls sig => cls -> sig
tile_set_shape = runMethod @"tile_set_shape"

tile_set_shape_offset ::
                        Method "tile_set_shape_offset" cls sig => cls -> sig
tile_set_shape_offset = runMethod @"tile_set_shape_offset"

tile_set_shape_one_way ::
                         Method "tile_set_shape_one_way" cls sig => cls -> sig
tile_set_shape_one_way = runMethod @"tile_set_shape_one_way"

tile_set_shape_transform ::
                           Method "tile_set_shape_transform" cls sig => cls -> sig
tile_set_shape_transform = runMethod @"tile_set_shape_transform"

tile_set_shapes :: Method "tile_set_shapes" cls sig => cls -> sig
tile_set_shapes = runMethod @"tile_set_shapes"

tile_set_texture :: Method "tile_set_texture" cls sig => cls -> sig
tile_set_texture = runMethod @"tile_set_texture"

tile_set_texture_offset ::
                          Method "tile_set_texture_offset" cls sig => cls -> sig
tile_set_texture_offset = runMethod @"tile_set_texture_offset"

tile_set_tile_mode ::
                     Method "tile_set_tile_mode" cls sig => cls -> sig
tile_set_tile_mode = runMethod @"tile_set_tile_mode"

tile_set_z_index :: Method "tile_set_z_index" cls sig => cls -> sig
tile_set_z_index = runMethod @"tile_set_z_index"

timescale_node_get_scale ::
                           Method "timescale_node_get_scale" cls sig => cls -> sig
timescale_node_get_scale = runMethod @"timescale_node_get_scale"

timescale_node_set_scale ::
                           Method "timescale_node_set_scale" cls sig => cls -> sig
timescale_node_set_scale = runMethod @"timescale_node_set_scale"

timeseek_node_seek ::
                     Method "timeseek_node_seek" cls sig => cls -> sig
timeseek_node_seek = runMethod @"timeseek_node_seek"

to_global :: Method "to_global" cls sig => cls -> sig
to_global = runMethod @"to_global"

to_local :: Method "to_local" cls sig => cls -> sig
to_local = runMethod @"to_local"

toggle_fold_line :: Method "toggle_fold_line" cls sig => cls -> sig
toggle_fold_line = runMethod @"toggle_fold_line"

toggle_item_checked ::
                      Method "toggle_item_checked" cls sig => cls -> sig
toggle_item_checked = runMethod @"toggle_item_checked"

toggle_item_multistate ::
                         Method "toggle_item_multistate" cls sig => cls -> sig
toggle_item_multistate = runMethod @"toggle_item_multistate"

tr :: Method "tr" cls sig => cls -> sig
tr = runMethod @"tr"

track_find_key :: Method "track_find_key" cls sig => cls -> sig
track_find_key = runMethod @"track_find_key"

track_get_interpolation_loop_wrap ::
                                    Method "track_get_interpolation_loop_wrap" cls sig => cls -> sig
track_get_interpolation_loop_wrap
  = runMethod @"track_get_interpolation_loop_wrap"

track_get_interpolation_type ::
                               Method "track_get_interpolation_type" cls sig => cls -> sig
track_get_interpolation_type
  = runMethod @"track_get_interpolation_type"

track_get_key_count ::
                      Method "track_get_key_count" cls sig => cls -> sig
track_get_key_count = runMethod @"track_get_key_count"

track_get_key_time ::
                     Method "track_get_key_time" cls sig => cls -> sig
track_get_key_time = runMethod @"track_get_key_time"

track_get_key_transition ::
                           Method "track_get_key_transition" cls sig => cls -> sig
track_get_key_transition = runMethod @"track_get_key_transition"

track_get_key_value ::
                      Method "track_get_key_value" cls sig => cls -> sig
track_get_key_value = runMethod @"track_get_key_value"

track_get_path :: Method "track_get_path" cls sig => cls -> sig
track_get_path = runMethod @"track_get_path"

track_get_type :: Method "track_get_type" cls sig => cls -> sig
track_get_type = runMethod @"track_get_type"

track_insert_key :: Method "track_insert_key" cls sig => cls -> sig
track_insert_key = runMethod @"track_insert_key"

track_is_enabled :: Method "track_is_enabled" cls sig => cls -> sig
track_is_enabled = runMethod @"track_is_enabled"

track_is_imported ::
                    Method "track_is_imported" cls sig => cls -> sig
track_is_imported = runMethod @"track_is_imported"

track_move_down :: Method "track_move_down" cls sig => cls -> sig
track_move_down = runMethod @"track_move_down"

track_move_up :: Method "track_move_up" cls sig => cls -> sig
track_move_up = runMethod @"track_move_up"

track_remove_key :: Method "track_remove_key" cls sig => cls -> sig
track_remove_key = runMethod @"track_remove_key"

track_remove_key_at_position ::
                               Method "track_remove_key_at_position" cls sig => cls -> sig
track_remove_key_at_position
  = runMethod @"track_remove_key_at_position"

track_set_enabled ::
                    Method "track_set_enabled" cls sig => cls -> sig
track_set_enabled = runMethod @"track_set_enabled"

track_set_imported ::
                     Method "track_set_imported" cls sig => cls -> sig
track_set_imported = runMethod @"track_set_imported"

track_set_interpolation_loop_wrap ::
                                    Method "track_set_interpolation_loop_wrap" cls sig => cls -> sig
track_set_interpolation_loop_wrap
  = runMethod @"track_set_interpolation_loop_wrap"

track_set_interpolation_type ::
                               Method "track_set_interpolation_type" cls sig => cls -> sig
track_set_interpolation_type
  = runMethod @"track_set_interpolation_type"

track_set_key_transition ::
                           Method "track_set_key_transition" cls sig => cls -> sig
track_set_key_transition = runMethod @"track_set_key_transition"

track_set_key_value ::
                      Method "track_set_key_value" cls sig => cls -> sig
track_set_key_value = runMethod @"track_set_key_value"

track_set_path :: Method "track_set_path" cls sig => cls -> sig
track_set_path = runMethod @"track_set_path"

track_swap :: Method "track_swap" cls sig => cls -> sig
track_swap = runMethod @"track_swap"

transform_track_insert_key ::
                             Method "transform_track_insert_key" cls sig => cls -> sig
transform_track_insert_key
  = runMethod @"transform_track_insert_key"

transform_track_interpolate ::
                              Method "transform_track_interpolate" cls sig => cls -> sig
transform_track_interpolate
  = runMethod @"transform_track_interpolate"

transition_node_delete_input ::
                               Method "transition_node_delete_input" cls sig => cls -> sig
transition_node_delete_input
  = runMethod @"transition_node_delete_input"

transition_node_get_current ::
                              Method "transition_node_get_current" cls sig => cls -> sig
transition_node_get_current
  = runMethod @"transition_node_get_current"

transition_node_get_input_count ::
                                  Method "transition_node_get_input_count" cls sig => cls -> sig
transition_node_get_input_count
  = runMethod @"transition_node_get_input_count"

transition_node_get_xfade_time ::
                                 Method "transition_node_get_xfade_time" cls sig => cls -> sig
transition_node_get_xfade_time
  = runMethod @"transition_node_get_xfade_time"

transition_node_has_input_auto_advance ::
                                         Method "transition_node_has_input_auto_advance" cls sig =>
                                         cls -> sig
transition_node_has_input_auto_advance
  = runMethod @"transition_node_has_input_auto_advance"

transition_node_set_current ::
                              Method "transition_node_set_current" cls sig => cls -> sig
transition_node_set_current
  = runMethod @"transition_node_set_current"

transition_node_set_input_auto_advance ::
                                         Method "transition_node_set_input_auto_advance" cls sig =>
                                         cls -> sig
transition_node_set_input_auto_advance
  = runMethod @"transition_node_set_input_auto_advance"

transition_node_set_input_count ::
                                  Method "transition_node_set_input_count" cls sig => cls -> sig
transition_node_set_input_count
  = runMethod @"transition_node_set_input_count"

transition_node_set_xfade_time ::
                                 Method "transition_node_set_xfade_time" cls sig => cls -> sig
transition_node_set_xfade_time
  = runMethod @"transition_node_set_xfade_time"

translate :: Method "translate" cls sig => cls -> sig
translate = runMethod @"translate"

translate_object_local ::
                         Method "translate_object_local" cls sig => cls -> sig
translate_object_local = runMethod @"translate_object_local"

travel :: Method "travel" cls sig => cls -> sig
travel = runMethod @"travel"

triangulate_polygon ::
                      Method "triangulate_polygon" cls sig => cls -> sig
triangulate_polygon = runMethod @"triangulate_polygon"

try_lock :: Method "try_lock" cls sig => cls -> sig
try_lock = runMethod @"try_lock"

unbind_child_node_from_bone ::
                              Method "unbind_child_node_from_bone" cls sig => cls -> sig
unbind_child_node_from_bone
  = runMethod @"unbind_child_node_from_bone"

undo :: Method "undo" cls sig => cls -> sig
undo = runMethod @"undo"

unfold_line :: Method "unfold_line" cls sig => cls -> sig
unfold_line = runMethod @"unfold_line"

unhandled_input :: Method "unhandled_input" cls sig => cls -> sig
unhandled_input = runMethod @"unhandled_input"

unhide_all_lines :: Method "unhide_all_lines" cls sig => cls -> sig
unhide_all_lines = runMethod @"unhide_all_lines"

uninitialize :: Method "uninitialize" cls sig => cls -> sig
uninitialize = runMethod @"uninitialize"

unlock :: Method "unlock" cls sig => cls -> sig
unlock = runMethod @"unlock"

unparent_bone_and_rest ::
                         Method "unparent_bone_and_rest" cls sig => cls -> sig
unparent_bone_and_rest = runMethod @"unparent_bone_and_rest"

unproject_position ::
                     Method "unproject_position" cls sig => cls -> sig
unproject_position = runMethod @"unproject_position"

unreference :: Method "unreference" cls sig => cls -> sig
unreference = runMethod @"unreference"

unselect :: Method "unselect" cls sig => cls -> sig
unselect = runMethod @"unselect"

unselect_all :: Method "unselect_all" cls sig => cls -> sig
unselect_all = runMethod @"unselect_all"

unshare :: Method "unshare" cls sig => cls -> sig
unshare = runMethod @"unshare"

update :: Method "update" cls sig => cls -> sig
update = runMethod @"update"

update_bitmask_area ::
                      Method "update_bitmask_area" cls sig => cls -> sig
update_bitmask_area = runMethod @"update_bitmask_area"

update_bitmask_region ::
                        Method "update_bitmask_region" cls sig => cls -> sig
update_bitmask_region = runMethod @"update_bitmask_region"

update_changes :: Method "update_changes" cls sig => cls -> sig
update_changes = runMethod @"update_changes"

update_dirty_quadrants ::
                         Method "update_dirty_quadrants" cls sig => cls -> sig
update_dirty_quadrants = runMethod @"update_dirty_quadrants"

update_file :: Method "update_file" cls sig => cls -> sig
update_file = runMethod @"update_file"

update_gizmo :: Method "update_gizmo" cls sig => cls -> sig
update_gizmo = runMethod @"update_gizmo"

update_overlays :: Method "update_overlays" cls sig => cls -> sig
update_overlays = runMethod @"update_overlays"

update_position :: Method "update_position" cls sig => cls -> sig
update_position = runMethod @"update_position"

update_property :: Method "update_property" cls sig => cls -> sig
update_property = runMethod @"update_property"

update_script_classes ::
                        Method "update_script_classes" cls sig => cls -> sig
update_script_classes = runMethod @"update_script_classes"

update_worlds :: Method "update_worlds" cls sig => cls -> sig
update_worlds = runMethod @"update_worlds"

use_arvr :: Method "use_arvr" cls sig => cls -> sig
use_arvr = runMethod @"use_arvr"

utf8_to_base64 :: Method "utf8_to_base64" cls sig => cls -> sig
utf8_to_base64 = runMethod @"utf8_to_base64"

value_track_get_key_indices ::
                              Method "value_track_get_key_indices" cls sig => cls -> sig
value_track_get_key_indices
  = runMethod @"value_track_get_key_indices"

value_track_get_update_mode ::
                              Method "value_track_get_update_mode" cls sig => cls -> sig
value_track_get_update_mode
  = runMethod @"value_track_get_update_mode"

value_track_set_update_mode ::
                              Method "value_track_set_update_mode" cls sig => cls -> sig
value_track_set_update_mode
  = runMethod @"value_track_set_update_mode"

variant_to_base64 ::
                    Method "variant_to_base64" cls sig => cls -> sig
variant_to_base64 = runMethod @"variant_to_base64"

viewport_attach_camera ::
                         Method "viewport_attach_camera" cls sig => cls -> sig
viewport_attach_camera = runMethod @"viewport_attach_camera"

viewport_attach_canvas ::
                         Method "viewport_attach_canvas" cls sig => cls -> sig
viewport_attach_canvas = runMethod @"viewport_attach_canvas"

viewport_attach_to_screen ::
                            Method "viewport_attach_to_screen" cls sig => cls -> sig
viewport_attach_to_screen = runMethod @"viewport_attach_to_screen"

viewport_create :: Method "viewport_create" cls sig => cls -> sig
viewport_create = runMethod @"viewport_create"

viewport_detach :: Method "viewport_detach" cls sig => cls -> sig
viewport_detach = runMethod @"viewport_detach"

viewport_get_render_info ::
                           Method "viewport_get_render_info" cls sig => cls -> sig
viewport_get_render_info = runMethod @"viewport_get_render_info"

viewport_get_texture ::
                       Method "viewport_get_texture" cls sig => cls -> sig
viewport_get_texture = runMethod @"viewport_get_texture"

viewport_remove_canvas ::
                         Method "viewport_remove_canvas" cls sig => cls -> sig
viewport_remove_canvas = runMethod @"viewport_remove_canvas"

viewport_set_active ::
                      Method "viewport_set_active" cls sig => cls -> sig
viewport_set_active = runMethod @"viewport_set_active"

viewport_set_canvas_stacking ::
                               Method "viewport_set_canvas_stacking" cls sig => cls -> sig
viewport_set_canvas_stacking
  = runMethod @"viewport_set_canvas_stacking"

viewport_set_canvas_transform ::
                                Method "viewport_set_canvas_transform" cls sig => cls -> sig
viewport_set_canvas_transform
  = runMethod @"viewport_set_canvas_transform"

viewport_set_clear_mode ::
                          Method "viewport_set_clear_mode" cls sig => cls -> sig
viewport_set_clear_mode = runMethod @"viewport_set_clear_mode"

viewport_set_debug_draw ::
                          Method "viewport_set_debug_draw" cls sig => cls -> sig
viewport_set_debug_draw = runMethod @"viewport_set_debug_draw"

viewport_set_disable_3d ::
                          Method "viewport_set_disable_3d" cls sig => cls -> sig
viewport_set_disable_3d = runMethod @"viewport_set_disable_3d"

viewport_set_disable_environment ::
                                   Method "viewport_set_disable_environment" cls sig => cls -> sig
viewport_set_disable_environment
  = runMethod @"viewport_set_disable_environment"

viewport_set_global_canvas_transform ::
                                       Method "viewport_set_global_canvas_transform" cls sig =>
                                       cls -> sig
viewport_set_global_canvas_transform
  = runMethod @"viewport_set_global_canvas_transform"

viewport_set_hdr :: Method "viewport_set_hdr" cls sig => cls -> sig
viewport_set_hdr = runMethod @"viewport_set_hdr"

viewport_set_hide_canvas ::
                           Method "viewport_set_hide_canvas" cls sig => cls -> sig
viewport_set_hide_canvas = runMethod @"viewport_set_hide_canvas"

viewport_set_hide_scenario ::
                             Method "viewport_set_hide_scenario" cls sig => cls -> sig
viewport_set_hide_scenario
  = runMethod @"viewport_set_hide_scenario"

viewport_set_msaa ::
                    Method "viewport_set_msaa" cls sig => cls -> sig
viewport_set_msaa = runMethod @"viewport_set_msaa"

viewport_set_parent_viewport ::
                               Method "viewport_set_parent_viewport" cls sig => cls -> sig
viewport_set_parent_viewport
  = runMethod @"viewport_set_parent_viewport"

viewport_set_scenario ::
                        Method "viewport_set_scenario" cls sig => cls -> sig
viewport_set_scenario = runMethod @"viewport_set_scenario"

viewport_set_shadow_atlas_quadrant_subdivision ::
                                                 Method
                                                   "viewport_set_shadow_atlas_quadrant_subdivision"
                                                   cls sig =>
                                                 cls -> sig
viewport_set_shadow_atlas_quadrant_subdivision
  = runMethod @"viewport_set_shadow_atlas_quadrant_subdivision"

viewport_set_shadow_atlas_size ::
                                 Method "viewport_set_shadow_atlas_size" cls sig => cls -> sig
viewport_set_shadow_atlas_size
  = runMethod @"viewport_set_shadow_atlas_size"

viewport_set_size ::
                    Method "viewport_set_size" cls sig => cls -> sig
viewport_set_size = runMethod @"viewport_set_size"

viewport_set_transparent_background ::
                                      Method "viewport_set_transparent_background" cls sig =>
                                      cls -> sig
viewport_set_transparent_background
  = runMethod @"viewport_set_transparent_background"

viewport_set_update_mode ::
                           Method "viewport_set_update_mode" cls sig => cls -> sig
viewport_set_update_mode = runMethod @"viewport_set_update_mode"

viewport_set_usage ::
                     Method "viewport_set_usage" cls sig => cls -> sig
viewport_set_usage = runMethod @"viewport_set_usage"

viewport_set_use_arvr ::
                        Method "viewport_set_use_arvr" cls sig => cls -> sig
viewport_set_use_arvr = runMethod @"viewport_set_use_arvr"

viewport_set_vflip ::
                     Method "viewport_set_vflip" cls sig => cls -> sig
viewport_set_vflip = runMethod @"viewport_set_vflip"

wait :: Method "wait" cls sig => cls -> sig
wait = runMethod @"wait"

wait_to_finish :: Method "wait_to_finish" cls sig => cls -> sig
wait_to_finish = runMethod @"wait_to_finish"

warp_mouse :: Method "warp_mouse" cls sig => cls -> sig
warp_mouse = runMethod @"warp_mouse"

warp_mouse_position ::
                      Method "warp_mouse_position" cls sig => cls -> sig
warp_mouse_position = runMethod @"warp_mouse_position"

was_string_packet ::
                    Method "was_string_packet" cls sig => cls -> sig
was_string_packet = runMethod @"was_string_packet"

world_to_map :: Method "world_to_map" cls sig => cls -> sig
world_to_map = runMethod @"world_to_map"

xformed_by :: Method "xformed_by" cls sig => cls -> sig
xformed_by = runMethod @"xformed_by"