/*
 *  $Id: loglevel.c,v 1.14 2002/08/22 09:37:23 dreibh Exp $
 *
 * RSerPool implementation.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * Acknowledgement
 * This work was partially funded by the Bundesministerium fr Bildung und
 * Forschung (BMBF) of the Federal Republic of Germany (Frderkennzeichen 01AK045).
 * The authors alone are responsible for the contents.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * There are two mailinglists available at http://www.sctp.de/rserpool.html
 * which should be used for any discussion related to this implementation.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@exp-math.uni-essen.de
 *
 * Purpose: Logging Management
 *
 */


#include "tdtypes.h"
#include "loglevel.h"
#include "utilities.h"


unsigned int gLogLevel = MAX_LOGLEVEL;

#ifdef HAVE_STDERR_FILEPTR
FILE**       gStdLog = &stderr;
#else
static FILE* _stderr = stderr;
FILE**       gStdLog = &_stderr;
#endif

static bool colorMode   = true;
static bool closeStdLog = false;


/* ????? Thread-safety !!! */


/* ###### Set ASCII color ################################################ */
void setLogColor(const unsigned int color)
{
   if(colorMode) {
      fprintf(stdlog,"\x1b[%dm",
              30 + (color % 8) + ((color > 8) ? 60 : 0));
   }
}


/* ###### Initialize logfile ############################################# */
static bool initLogFile(const unsigned int logLevel, const char* fileName, const char* fileMode)
{
   finishLogging();
   if(fileName != NULL) {
      *gStdLog = fopen(fileName,fileMode);
      if(*gStdLog != NULL) {
         closeStdLog = true;
         gLogLevel   = min(logLevel,MAX_LOGLEVEL);
         return(true);
      }
   }

   *gStdLog     = stderr;
   closeStdLog = false;
   return(false);
}


/* ###### Set logging parameter ########################################## */
bool initLogging(const char* parameter)
{
   if(!(strncmp(parameter,"-logfile=",9))) {
      return(initLogFile(gLogLevel,(char*)&parameter[9],"w"));
   }
   else if(!(strncmp(parameter,"-logappend=",11))) {
      return(initLogFile(gLogLevel,(char*)&parameter[11],"a"));
   }
   else if(!(strcmp(parameter,"-logquiet"))) {
      initLogFile(0,NULL,"w");
      gLogLevel = 0;
   }
   else if(!(strncmp(parameter,"-loglevel=",10))) {
      gLogLevel = min(atol((char*)&parameter[10]),MAX_LOGLEVEL);
   }
   else if(!(strncmp(parameter,"-logcolor=",10))) {
      if(!(strcasecmp((char*)&parameter[10],"off"))) {
         colorMode = false;
      }
      else {
         colorMode = true;
      }
   }
   else {
      printf("ERROR: Invalid logging parameter: %s\n",parameter);
      return(false);
   }
   return(true);
}


/* ###### Begin logging ################################################## */
void beginLogging()
{
   if((closeStdLog) && (ftell(*gStdLog) > 0)) {
      fputs("\n#########################################################################################\n\n",*gStdLog);
   }
   LOG_NOTE
   fprintf(stdlog,"Logging started, log level is %d.\n",gLogLevel);
   LOG_END
}


/* ###### Finish logging ################################################# */
void finishLogging()
{
   if((*gStdLog) && (closeStdLog)) {
      LOG_ACTION
      fputs("Logging finished.\n",stdlog);
      LOG_END
      fclose(*gStdLog);
      closeStdLog = false;
      *gStdLog     = stderr;
   }
}
