/*
 *  $Id: servertable.h,v 1.6 2002/08/22 09:37:25 dreibh Exp $
 *
 * RSerPool implementation.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * Acknowledgement
 * This work was partially funded by the Bundesministerium fr Bildung und
 * Forschung (BMBF) of the Federal Republic of Germany (Frderkennzeichen 01AK045).
 * The authors alone are responsible for the contents.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * There are two mailinglists available at http://www.sctp.de/rserpool.html
 * which should be used for any discussion related to this implementation.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@exp-math.uni-essen.de
 *
 * Purpose: Server Table
 *
 */


#ifndef SERVERTABLE_H
#define SERVERTABLE_H


#include "tdtypes.h"
#include "dispatcher.h"
#include "timer.h"
#include "serverannounce.h"
#include "asapmessage.h"


#ifdef __cplusplus
extern "C" {
#endif


struct ServerTable
{
   struct Dispatcher* Dispatcher;
   GList*             ServerAnnounceList;
   card64             ServerAnnounceListAddition;
   int                IPv4ServerAnnounceSocket;
#ifdef HAVE_IPV6
   int                IPv6ServerAnnounceSocket;
#endif


   struct Timer*      ServerAnnounceMaintenanceTimer;

   card64             ServerAnnounceMaintenanceInterval;
   card64             ServerAnnounceTimeout;
};



/**
  * Constructor.
  *
  * @param dispatcher Dispatcher.
  * @param serverAnnounceMaintenanceInterval Interval for server announce list maintenance in microseconds.
  * @param serverAnnounceTimeout Timeout of server announce in microseconds.
  * @param serverAnnounceConfigFile Name of server announce configuration file.
  * @return serverTable or NULL in case of error.
  */
struct ServerTable* serverTableNew(struct Dispatcher* dispatcher,
                                   const  card64      serverAnnounceMaintenanceInterval,
                                   const  card64      serverAnnounceTimeout,
                                   const char*        serverAnnounceConfigFile);


/**
  * Destructor.
  *
  * @param serverTable ServerTable.
  */
void serverTableDelete(struct ServerTable* ServerTable);

/**
  * Do server hunt.
  *
  * @param serverTable ServerTable.
  * @param connectTimeout Connect timeout in microseconds.
  * @param maxTrials Maximum number of connect trial rounds.
  * @param nameserversConfigFile Name of server announce configuration file.
  * @return Number of valid servers seen.
  */
int serverTableFindServer(struct ServerTable* serverTable,
                          const card64        connectTimeout,
                          const unsigned int  maxTrials,
                          const char*         nameserversConfigFile,
                          const int           protocol);


#ifdef __cplusplus
}
#endif


#endif
