/*
 *  $Id: tagitem.c,v 1.3 2002/08/22 09:37:26 dreibh Exp $
 *
 * RSerPool implementation.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * Acknowledgement
 * This work was partially funded by the Bundesministerium fr Bildung und
 * Forschung (BMBF) of the Federal Republic of Germany (Frderkennzeichen 01AK045).
 * The authors alone are responsible for the contents.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * There are two mailinglists available at http://www.sctp.de/rserpool.html
 * which should be used for any discussion related to this implementation.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@exp-math.uni-essen.de
 *
 * Purpose: Tag Item
 *
 */


#include "tdtypes.h"
#include "tagitem.h"



/* ###### Allocate tag items ############################################# */
struct TagItem* tagListAllocate(const size_t items)
{
   return((struct TagItem*)calloc(items,sizeof(struct TagItem)));
}


/* ###### Free tag items ################################################# */
void tagListFree(struct TagItem* tagList)
{
   if(tagList != NULL) {
      free(tagList);
   }
}


/* ###### Get next tag item ############################################## */
struct TagItem* tagListNext(struct TagItem* tagList)
{
   struct TagItem* tagListPtr = tagList;
   bool            updated    = false;

   while(true) {
      if(tagListPtr == NULL) {
         return(NULL);
      }
      switch (tagListPtr->Tag) {
         case TAG_MORE:
            if(!(tagListPtr = (struct TagItem *)tagListPtr->Data)) {
               return(NULL);
            }
            continue;
         break;
        case TAG_IGNORE:
         break;
        case TAG_END:
           return(NULL);
         break;
        case TAG_SKIP:
           tagListPtr += (long)tagListPtr->Data;
         break;
        default:
           if(updated) {
              return(tagListPtr);
           }
         break;
      }

      tagListPtr++;
      updated = true;
   }
}


/* ###### Find tag item ################################################## */
struct TagItem* tagListFind(struct TagItem* tagList, const tag_t tag)
{
   struct TagItem* tagListPtr = tagList;

   LOG_VERBOSE5
   fprintf(stdlog,"Looking for tag #%u...\n",tag);
   LOG_END

   while(tagListPtr != NULL) {
      if(tagListPtr->Tag == tag) {
         LOG_VERBOSE5
         fputs("Tag found\n",stdlog);
         LOG_END
         return(tagListPtr);
      }

      tagListPtr = tagListNext(tagListPtr);
   }

   LOG_VERBOSE5
   fputs("Tag not found\n",stdlog);
   LOG_END
   return(NULL);
}


/* ###### Get tag data ################################################### */
tagdata_t tagListGetData(struct TagItem* tagList,
                         const tag_t     tag,
                         const tagdata_t defaultValue)
{
   struct TagItem* found;

   found = tagListFind(tagList,tag);
   if(found != NULL) {
      LOG_VERBOSE5
      fprintf(stdlog,"Get value %u ($%x) for tag #%u\n",
              (unsigned int)found->Data, (unsigned int)found->Data, tag);
      LOG_END
      return(found->Data);
   }

   LOG_VERBOSE5
   fprintf(stdlog,"Using default value %u ($%x) for tag #%u\n",
           (unsigned int)defaultValue, (unsigned int)defaultValue, tag);
   LOG_END
   return(defaultValue);
}


/* ###### Print tag items ################################################ */
void tagListPrint(struct TagItem* tagList, FILE* fd)
{
   struct TagItem* tagListPtr = tagList;
   unsigned int    number  = 1;

   fputs("TagList: ",fd);
   if(tagListPtr != NULL) {
      fputs("\n",fd);
      while(tagListPtr != NULL) {
         fprintf(fd,"   %5d: tag %9d -> %9d ($%08x)\n",
                 number++, tagListPtr->Tag, (unsigned int)tagListPtr->Data, (unsigned int)tagListPtr->Data);
         tagListPtr = tagListNext(tagListPtr);
      }
   }
   else {
      fputs("(empty)\n",fd);
   }
}
