/*
 *  $Id: tagitem.h,v 1.3 2002/08/22 09:37:26 dreibh Exp $
 *
 * RSerPool implementation.
 *
 * Realized in co-operation between Siemens AG
 * and University of Essen, Institute of Computer Networking Technology.
 *
 * Acknowledgement
 * This work was partially funded by the Bundesministerium fr Bildung und
 * Forschung (BMBF) of the Federal Republic of Germany (Frderkennzeichen 01AK045).
 * The authors alone are responsible for the contents.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * There are two mailinglists available at http://www.sctp.de/rserpool.html
 * which should be used for any discussion related to this implementation.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@exp-math.uni-essen.de
 *
 * Purpose: Tag Item
 *
 */


#ifndef TAGITEM_H
#define TAGITEM_H


#ifdef __cplusplus
extern "C" {
#endif



#define TAG_DONE   0   /* Terminates array of TagItems.                   */
#define TAG_END    0   /* Synonym for TAG_DONE.                           */
#define TAG_IGNORE 1   /* Ignore this item.                               */
#define TAG_MORE   2   /* Data is pointer to another array of TagItems,
                          current array is terminated.                    */
#define TAG_SKIP   3   /* Skip this and the next Data items.              */
#define TAG_USER   4   /* First usable tag for user data.                 */



typedef unsigned int  tag_t;
typedef unsigned long tagdata_t;


struct TagItem
{
   tag_t     Tag;
   tagdata_t Data;
};



/**
  * Allocate and clear tag item array. The array has to be freed using
  * tagListFree().
  *
  * @param items Number of tag items to allocate.
  *
  * @see freeListAllocate
  */
struct TagItem* tagListAllocate(const size_t items);

/**
  * Free tag item array allocated by tagListAllocate().
  *
  * @param tagList TagItem array.
  *
  * @see tagListAllocate
  */
void tagListFree(struct TagItem* tagList);

/**
  * Get next tag item in list.
  *
  * @param tagList TagItem array.
  * @return Next TagItem or NULL if it is last.
  */
struct TagItem* tagListNext(struct TagItem* tagList);

/**
  * Find tag item with given tag in tag list.
  *
  * @param tagList TagItem array.
  * @param tag Tag to search.
  * @return TagItem or NULL if not found.
  */
struct TagItem* tagListFind(struct TagItem* tagList,
                            const tag_t     tag);

/**
  * Get data of given tag in tag list or default value.
  *
  * @param tagList TagItem array.
  * @param tag Tag to search.
  * @param defaultValue Value to return if tag is not found.
  * @return Data of tag item found or given default value when not found.
  */
tagdata_t tagListGetData(struct TagItem* tagList,
                         const tag_t     tag,
                         const tagdata_t defaultValue);

/**
  * Print tag list.
  *
  * @param tagList TagItem array.
  * @param fd File to write tag list to (e.g. stdout, stderr, ...).
  */
void tagListPrint(struct TagItem* tagList, FILE* fd);


#ifdef __cplusplus
}
#endif


#endif
