/*
 * The rsplib Prototype -- An RSerPool Implementation.
 * Copyright (C) 2005-2006 by Thomas Dreibholz, dreibh@exp-math.uni-essen.de
 *
 * $Id: pingpongpackets.h 928 2006-02-10 10:10:30Z dreibh $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@iem.uni-due.de
 *
 */

#ifndef PINGPONGPACKETS_H
#define PINGPONGPACKETS_H

#include <stdint.h>


#define PPID_PPP 0x29097602

#define PPPT_PING 0x01
#define PPPT_PONG 0x02

struct PingPongCommonHeader
{
   uint8_t  Type;
   uint8_t  Flags;
   uint16_t Length;
};

struct Ping
{
   struct PingPongCommonHeader Header;
   uint64_t                    MessageNo;
   char                        Data[];
};

struct Pong
{
   struct PingPongCommonHeader Header;
   uint64_t                    MessageNo;
   uint64_t                    ReplyNo;
   char                        Data[];
};


#define PPP_COOKIE_ID "<PP-TD1>"

struct PPPCookie
{
   char     ID[8];
   uint64_t ReplyNo;
};


#endif
