/*
 * The rsplib Prototype -- An RSerPool Implementation.
 * Copyright (C) 2005-2007 by Thomas Dreibholz, dreibh@exp-math.uni-essen.de
 *
 * $Id: threadsafety.h 1284 2007-01-10 18:41:25Z dreibh $
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Contact: rsplib-discussion@sctp.de
 *          dreibh@iem.uni-due.de
 *
 */

#ifndef THREADSAFETY_H
#define THREADSAFETY_H

#include "tdtypes.h"

#include <pthread.h>


#ifdef __cplusplus
extern "C" {
#endif


struct ThreadSafety
{
   pthread_mutex_t Mutex;
#ifdef __APPLE__
   pthread_t       MutexOwner;
   unsigned int    MutexRecursionLevel;
#endif
   char            Name[32];
};


/**
  * Create new recursive mutex.
  *
  * @param threadSafety ThreadSafety.
  * @param name Mutex name for debugging purposes or NULL.
  */
void threadSafetyNew(struct ThreadSafety* threadSafety,
                     const char*          name);

/**
  * Delete recursive mutex.
  *
  * @param threadSafety ThreadSafety.
  */
void threadSafetyDelete(struct ThreadSafety* threadSafety);

/**
  * Lock mutex.
  *
  * @param threadSafety ThreadSafety.
  */
void threadSafetyLock(struct ThreadSafety* threadSafety);

/**
  * Unlock mutex.
  *
  * @param threadSafety ThreadSafety.
  */
void threadSafetyUnlock(struct ThreadSafety* threadSafety);


#ifdef __cplusplus
}
#endif

#endif
