Name: rsplib
Version: 3.5.3
Release: 1
Summary: Reliable Server Pooling (RSerPool) implementation
License: GPL-3.0-or-later
Group: Applications/Internet
URL: https://www.nntb.no/~dreibh/rserpool/
Source: https://www.nntb.no/~dreibh/rserpool/download/%{name}-%{version}.tar.xz

AutoReqProv: on
BuildRequires: bzip2-devel
BuildRequires: cmake
BuildRequires: ghostscript
BuildRequires: GraphicsMagick
BuildRequires: gcc
BuildRequires: gcc-c++
BuildRequires: lksctp-tools-devel
BuildRequires: (qt6-qtbase-devel or qt5-qtbase-devel)
BuildRequires: pdf2svg
BuildRoot: %{_tmppath}/%{name}-%{version}-build

# Meta-package rsplib: install rsplib-all => install all sub-packages!
Requires: %{name}-all


%description
RSerPool client/server API library for session management Reliable Server
Pooling (RSerPool) is the IETF's standard (RFC 5351 to RFC 5356) for a
lightweight server pool and session management framework. It provides highly
available pool management (that is registration handling and load
distribution/balancing) by components called Registrar and a
client-side/server-side API for accessing the service of a pool.

%prep
%setup -q

%build
%cmake -DCMAKE_INSTALL_PREFIX=/usr -DUSE_KERNEL_SCTP=ON -DENABLE_CSP=ON -DENABLE_QT=ON -DENABLE_ICONS=ON .
%cmake_build

%install
%cmake_install

%files


%package librsplib
Summary: RSerPool client/server API library for session management
Group: System Environment/Libraries

%description librsplib
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
The API library is provided by this package.

%files librsplib
%{_libdir}/librspcsp.so.*
%{_libdir}/librspdispatcher.so.*
%{_libdir}/librsphsmgt.so.*
%{_libdir}/librsplib.so.*
%{_libdir}/librspmessaging.so.*
%{_libdir}/libtdbreakdetector.so.*
%{_libdir}/libtdloglevel.so.*
%{_libdir}/libtdnetutilities.so.*
%{_libdir}/libtdrandomizer.so.*
%{_libdir}/libtdstorage.so.*
%{_libdir}/libtdstringutilities.so.*
%{_libdir}/libtdtagitem.so.*
%{_libdir}/libtdthreadsafety.so.*
%{_libdir}/libtdtimeutilities.so.*
%{_libdir}/libcpprspserver.so.*
%{_libdir}/libtdcppthread.so.*


%package librsplib-static
Summary: RSerPool client/server API static library for session management
Group: System Environment/Libraries

%description librsplib-static
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
The static API library is provided by this package.

%files librsplib-static
%{_libdir}/librspcsp*.a
%{_libdir}/librspdispatcher*.a
%{_libdir}/librsphsmgt*.a
%{_libdir}/librsplib*.a
%{_libdir}/librspmessaging*.a
%{_libdir}/libtdbreakdetector*.a
%{_libdir}/libtdloglevel*.a
%{_libdir}/libtdnetutilities*.a
%{_libdir}/libtdrandomizer*.a
%{_libdir}/libtdstorage*.a
%{_libdir}/libtdstringutilities*.a
%{_libdir}/libtdtagitem*.a
%{_libdir}/libtdthreadsafety*.a
%{_libdir}/libtdtimeutilities*.a


%package librsplib-devel
Summary: Headers of the RSerPool client/server API library rsplib
Group: Development/Libraries
Requires: %{name}-librsplib = %{version}-%{release}

%description librsplib-devel
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides header files for the rsplib library. You need them
to develop your own RSerPool-based clients and servers.

%files librsplib-devel
%{_includedir}/rserpool/rserpool-internals.h
%{_includedir}/rserpool/rserpool-policytypes.h
%{_includedir}/rserpool/rserpool.h
%{_includedir}/rserpool/rserpool-csp.h
%{_includedir}/rserpool/tagitem.h
%{_libdir}/librspcsp*.so
%{_libdir}/librspdispatcher*.so
%{_libdir}/librsphsmgt*.so
%{_libdir}/librsplib*.so
%{_libdir}/librspmessaging*.so
%{_libdir}/libtdbreakdetector*.so
%{_libdir}/libtdloglevel*.so
%{_libdir}/libtdnetutilities*.so
%{_libdir}/libtdrandomizer*.so
%{_libdir}/libtdstorage*.so
%{_libdir}/libtdstringutilities*.so
%{_libdir}/libtdtagitem*.so
%{_libdir}/libtdthreadsafety*.so
%{_libdir}/libtdtimeutilities*.so
# NOTE: These files are library-internal files, not to be packaged in the RPM:
%ghost %{_includedir}/rserpool/asapinstance.h
%ghost %{_includedir}/rserpool/asapinterthreadmessage.h
%ghost %{_includedir}/rserpool/breakdetector.h
%ghost %{_includedir}/rserpool/componentstatuspackets.h
%ghost %{_includedir}/rserpool/componentstatusreporter.h
%ghost %{_includedir}/rserpool/debug.h
%ghost %{_includedir}/rserpool/dispatcher.h
%ghost %{_includedir}/rserpool/doublelinkedringlist.h
%ghost %{_includedir}/rserpool/ext_socket.h
%ghost %{_includedir}/rserpool/fdcallback.h
%ghost %{_includedir}/rserpool/identifierbitmap.h
%ghost %{_includedir}/rserpool/interthreadmessageport.h
%ghost %{_includedir}/rserpool/leaflinkedredblacktree.h
%ghost %{_includedir}/rserpool/loglevel.h
%ghost %{_includedir}/rserpool/messagebuffer.h
%ghost %{_includedir}/rserpool/netdouble.h
%ghost %{_includedir}/rserpool/netutilities.h
%ghost %{_includedir}/rserpool/notificationqueue.h
%ghost %{_includedir}/rserpool/peerlist-template.h
%ghost %{_includedir}/rserpool/peerlist-template_impl.h
%ghost %{_includedir}/rserpool/peerlistmanagement-template.h
%ghost %{_includedir}/rserpool/peerlistmanagement-template_impl.h
%ghost %{_includedir}/rserpool/peerlistnode-template.h
%ghost %{_includedir}/rserpool/peerlistnode-template_impl.h
%ghost %{_includedir}/rserpool/poolelementnode-template.h
%ghost %{_includedir}/rserpool/poolelementnode-template_impl.h
%ghost %{_includedir}/rserpool/poolhandle.h
%ghost %{_includedir}/rserpool/poolhandlespacechecksum.h
%ghost %{_includedir}/rserpool/poolhandlespacemanagement-basics.h
%ghost %{_includedir}/rserpool/poolhandlespacemanagement-template.h
%ghost %{_includedir}/rserpool/poolhandlespacemanagement-template_impl.h
%ghost %{_includedir}/rserpool/poolhandlespacemanagement.h
%ghost %{_includedir}/rserpool/poolhandlespacenode-template.h
%ghost %{_includedir}/rserpool/poolhandlespacenode-template_impl.h
%ghost %{_includedir}/rserpool/poolnode-template.h
%ghost %{_includedir}/rserpool/poolnode-template_impl.h
%ghost %{_includedir}/rserpool/poolpolicy-template.h
%ghost %{_includedir}/rserpool/poolpolicy-template_impl.h
%ghost %{_includedir}/rserpool/poolpolicysettings.h
%ghost %{_includedir}/rserpool/pooluserlist-template.h
%ghost %{_includedir}/rserpool/pooluserlist-template_impl.h
%ghost %{_includedir}/rserpool/poolusernode-template.h
%ghost %{_includedir}/rserpool/poolusernode-template_impl.h
%ghost %{_includedir}/rserpool/randomizer.h
%ghost %{_includedir}/rserpool/redblacktree.h
%ghost %{_includedir}/rserpool/redblacktree_impl.h
%ghost %{_includedir}/rserpool/registrartable.h
%ghost %{_includedir}/rserpool/rserpoolerror.h
%ghost %{_includedir}/rserpool/rserpoolmessage.h
%ghost %{_includedir}/rserpool/rserpoolmessagecreator.h
%ghost %{_includedir}/rserpool/rserpoolmessageparser.h
%ghost %{_includedir}/rserpool/rserpoolsocket.h
%ghost %{_includedir}/rserpool/session.h
%ghost %{_includedir}/rserpool/sessioncontrol.h
%ghost %{_includedir}/rserpool/sessionstorage.h
%ghost %{_includedir}/rserpool/simpleredblacktree.h
%ghost %{_includedir}/rserpool/sockaddrunion.h
%ghost %{_includedir}/rserpool/stringutilities.h
%ghost %{_includedir}/rserpool/tdtypes.h
%ghost %{_includedir}/rserpool/threadsafety.h
%ghost %{_includedir}/rserpool/threadsignal.h
%ghost %{_includedir}/rserpool/timer.h
%ghost %{_includedir}/rserpool/timestamphashtable.h
%ghost %{_includedir}/rserpool/timeutilities.h
%ghost %{_includedir}/rserpool/transportaddressblock.h


%package libcpprspserver
Summary: C++ RSerPool client/server API library
Group: System Environment/Libraries
Requires: %{name}-librsplib = %{version}-%{release}

%description libcpprspserver
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the C++ API library.

%files libcpprspserver
%{_libdir}/libcpprspserver.so.*
%{_libdir}/libtdcppthread.so.*


%package libcpprspserver-static
Summary: C++ RSerPool client/server API static library
Group: System Environment/Libraries
Requires: %{name}-librsplib = %{version}-%{release}

%description libcpprspserver-static
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the static C++ API for the rsplib library.
This package provides the static C++ API library.

%files libcpprspserver-static
%{_libdir}/libcpprspserver*.a
%{_libdir}/libtdcppthread*.a


%package libcpprspserver-devel
Summary: Headers of the C++ RSerPool client/server API library
Group: Development/Libraries
Requires: %{name}-libcpprspserver = %{version}-%{release}
Requires: %{name}-librsplib-devel = %{version}-%{release}

%description libcpprspserver-devel
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the header files for the rsplib C++ API. You need them to
develop your own RSerPool-based clients and servers based on the C++ API.

%files libcpprspserver-devel
%{_includedir}/rserpool/cpprspserver.h
%{_includedir}/rserpool/mutex.h
%{_includedir}/rserpool/tcplikeserver.h
%{_includedir}/rserpool/thread.h
%{_includedir}/rserpool/udplikeserver.h
%{_libdir}/libcpprspserver*.so
%{_libdir}/libtdcppthread*.so


%package docs
Summary: Documentation files for RSPLIB
Group: System Environment/Libraries
BuildArch: noarch
Requires: %{name}-tools = %{version}-%{release}

%description docs
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package contains the documentation for the RSerPool implementation
RSPLIB.

%files docs
%{_datadir}/doc/rsplib/Handbook.pdf


%package registrar
Summary: RSerPool Registrar service
Group: Applications/Internet
Requires: %{name}-librsplib = %{version}-%{release}
Recommends: %{name}-docs = %{version}-%{release}

%description registrar
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the registrar, which is the management component
for RSerPool-based server pools. You need at least one registrar in a
setup, but for redundancy reasons, you should have at least two.

%files registrar
%{_bindir}/rspregistrar
%{_datadir}/bash-completion/completions/rspregistrar
%{_prefix}/lib/systemd/system/rspregistrar.service
%{_mandir}/man1/rspregistrar.1.gz


%package tools
Summary: RSerPool test tools
Group: Applications/Internet
Requires: %{name}-librsplib = %{version}-%{release}
Recommends: %{name}-docs = %{version}-%{release}
Recommends: %{name}-common = %{version}-%{release}
Recommends: chrpath

%description tools
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides some test tools for RSerPool setups.

%files tools
%{_bindir}/cspmonitor
%{_bindir}/hsdump
%{_bindir}/rspserver
%{_bindir}/rspterminal
%{_datadir}/bash-completion/completions/cspmonitor
%{_datadir}/bash-completion/completions/hsdump
%{_datadir}/bash-completion/completions/rspserver
%{_datadir}/bash-completion/completions/rspterminal
%{_mandir}/man1/rspserver.1.gz
%{_mandir}/man1/rspterminal.1.gz
%{_mandir}/man1/cspmonitor.1.gz
%{_mandir}/man1/hsdump.1.gz


%package services
Summary: RSerPool example services
Group: Applications/Internet
Requires: %{name}-libcpprspserver = %{version}-%{release}
Requires: %{name}-librsplib = %{version}-%{release}
Requires: %{name}-tools = %{version}-%{release}
Recommends: %{name}-docs = %{version}-%{release}
Suggests: %{name}-fractalpooluser

%description services
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the rsplib RSerPool example services:
Echo, Discard, Daytime, CharGen, CalcApp, and ScriptingService.

%files services
%{_bindir}/calcappclient
%{_bindir}/pingpongclient
%{_bindir}/scriptingclient
%{_bindir}/scriptingcontrol
%{_bindir}/scriptingserviceexample
%{_datadir}/bash-completion/completions/calcappclient
%{_datadir}/bash-completion/completions/pingpongclient
%{_datadir}/bash-completion/completions/scriptingclient
%{_mandir}/man1/calcappclient.1.gz
%{_mandir}/man1/pingpongclient.1.gz
%{_mandir}/man1/scriptingclient.1.gz
%{_mandir}/man1/scriptingcontrol.1.gz
%{_mandir}/man1/scriptingserviceexample.1.gz


%package fractalpooluser
Summary: RSerPool-based fractal generator client
Group: Applications/Internet
Requires: %{name}-libcpprspserver = %{version}-%{release}
Requires: %{name}-librsplib = %{version}-%{release}
Requires: %{name}-tools = %{version}-%{release}
Recommends: %{name}-docs = %{version}-%{release}
Recommends: %{name}-services = %{version}-%{release}

%description fractalpooluser
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides the provides the Pool User client for the
FractalGenerator service. Is uses a Qt-based GUI.

%files fractalpooluser
%{_bindir}/fractalpooluser
%{_datadir}/applications/fractalpooluser.desktop
%{_datadir}/bash-completion/completions/fractalpooluser
%{_datadir}/fractalpooluser/*.qm
%{_mandir}/man1/fractalpooluser.1.gz


%package common
Summary: RSerPool Fractal Generator Service example input files
Group: Applications/Internet
BuildArch: noarch
Recommends: fractgen
Recommends: %{name}-tools = %{version}-%{release}

%description common
Reliable Server Pooling (RSerPool) is the IETF's standard (RFC 5351 to
RFC 5356) for a lightweight server pool and session management framework.
It provides highly available pool management (that is registration
handling and load distribution/balancing) by components called Registrar
and a client-side/server-side API for accessing the service of a pool.
This package provides common files for the example service.

%files common
%{_datadir}/fgpconfig/*.fsf
%{_datadir}/icons/hicolor/*x*/apps/rsplib.png
%{_datadir}/icons/hicolor/scalable/apps/rsplib.svg
%{_datadir}/rsplib/rsplib.bib
%{_datadir}/rsplib/rsplib.pdf
%{_datadir}/rsplib/rsplib.png


%package all
Summary: RSerPool implementation RSPLIB
Group: Applications/Internet
BuildArch: noarch
Obsoletes: %{name} < %{version}
Provides:  %{name} = %{version}
Requires: %{name}-common = %{version}-%{release}
Requires: %{name}-docs = %{version}-%{release}
Requires: %{name}-fractalpooluser = %{version}-%{release}
Requires: %{name}-libcpprspserver = %{version}-%{release}
Requires: %{name}-libcpprspserver-devel = %{version}-%{release}
Requires: %{name}-libcpprspserver-static = %{version}-%{release}
Requires: %{name}-librsplib = %{version}-%{release}
Requires: %{name}-librsplib-devel = %{version}-%{release}
Requires: %{name}-librsplib-static = %{version}-%{release}
Requires: %{name}-registrar = %{version}-%{release}
Requires: %{name}-services = %{version}-%{release}
Requires: %{name}-tools = %{version}-%{release}

%description all
This is the installation metapackage for the RSerPool implementation RSPLIB.
It installs all RSPLIB components.

%files all


%changelog
* Sat Jul 05 2025 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.5.3
- New upstream release.
* Mon May 12 2025 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.5.2
- New upstream release.
* Mon Feb 17 2025 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.5.1
- New upstream release.
* Fri Dec 13 2024 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.5.0
- New upstream release.
* Wed Aug 07 2024 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.10
- New upstream release.
* Sat Jun 08 2024 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.9
- New upstream release.
* Thu Apr 11 2024 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.8
- New upstream release.
* Mon Dec 18 2023 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.7
- New upstream release.
* Mon Dec 18 2023 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.6
- New upstream release.
* Wed Dec 06 2023 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.5
- New upstream release.
* Sun Jan 22 2023 Thomas Dreibholz <thomas.dreibholz@gmail.com> - 3.4.4
- New upstream release.
* Sun Sep 11 2022 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.4.3
- New upstream release.
* Mon Aug 22 2022 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.4.2
- New upstream release.
* Mon Jan 10 2022 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.4.1
- New upstream release.
* Mon Jan 03 2022 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.4.0
- New upstream release.
* Mon Nov 08 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.3.3
- New upstream release.
* Wed Nov 03 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.3.3
- New upstream release.
* Mon Oct 25 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.3.2
- New upstream release.
* Mon May 03 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.3.1
- New upstream release.
* Sat Mar 06 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.3.0
- New upstream release.
* Sun Feb 14 2021 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.7
- New upstream release.
* Fri Nov 13 2020 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.6
- New upstream release.
* Fri Feb 07 2020 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.5
- New upstream release.
* Wed Aug 07 2019 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.4
- New upstream release.
* Tue Aug 06 2019 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.3
- New upstream release.
* Fri Jun 14 2019 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.2
- New upstream release.
* Tue May 21 2019 Thomas Dreibholz <dreibh@iem.uni-due.de> - 3.2.1
- New upstream release.
* Tue Nov 21 2017 Thomas Dreibholz <dreibh@simula.no> 3.1.8
- Initial RPM release
